<?php // -*- coding:utf-8 -*-
// parameters:
// lang=xx    : only tranlates language 'xx',
//              if not given all languages are translated
// comments   : generate all comments (equal to close&module)
// close      : look for similar strings that are already translated and
//              generate a comment if a 'match' is made
// module     : generate comments that describe in which .php and/or .tpl
//              module(s) a certain string was found (useful for checking
//              translations in context)
// patch      : looks for the file 'language.patch' in the same directory
//              as the corresponding language.php and overrides any strings
//              in language.php - good if a user does not agree with
//              some translations or if only changes are sent to the maintainer
// spelling   : generates a file 'spellcheck_me.txt' that contains the
//              words used in the translation. It is then easy to check this
//              file for spelling errors (corrections must be done in
//              'language.php, however)
// groupwrite : Sets the generated files permissions to allow the generated
//              language.php also be group writable. This is good for
//              translators if they do not have root access to tiki but
//              are in the same group as the webserver. Please remember
//              to have write access removed when translation is finished
//              for security reasons. (Run script again without this
//              parameter)
// Examples:
// http://www.neonchart.com/get_strings.php?lang=sv
// Will translate langauage 'sv' and (almost) avoiding comment generation

// http://www.neonchart.com/get_strings.php?lang=sv&comments
// Will translate langauage 'sv' and generate all possible comments.
// This is the most usefull mode when working on a translation.

// http://www.neonchart.com/get_strings.php?lang=sv&nohelp&nosections
// These options will only provide the minimal amout of comments.
// Usefull mode when preparing a translation for distribution.

// http://www.neonchart.com/get_strings.php?nohelp&nosections
// Prepare all languages for release 


$lang=Array(
// ### Start of unused words
// ### Please remove manually!
// ### N.B. Legitimate strings may be marked// ### as unused!
// ### Please see http://tikiwiki.org/tiki-index.php?page=UnusedWords for further info
"PHPOpenTracker" => "PHPOpenTracker",
"Tiki forums" => "Tikiフォーラム",
"Mus enter a name to add a site" => "サイト追加には、名前が必要",
"Newss from" => "Newss from",
"Directory (include trailing slash)" => "パス（最後のスラッシュを忘れずに）",
"Mark as Flagged" => "旗印をつける",
"Renders a graph, with linked pages navigation visually figured.\n" => "リンク・ページの仕組みをグラフィックで表示する\n",
"Are you sure you want to delete this attachment?" => "この添付ファイルを削除してもよろしいですか？",
"Are you sure you want to delete this copyright?" => "この著作権を削除してもよろしいですか？",
"Are you sure you want to delete this tracker?" => "このトラッカーを削除しても宜しいですか？",
"Click here to delete this tracker" => "クリックして、このトラッカーを削除する",
"Are you sure you want to delete this contact?" => "このコンタクトを削除しても宜しいですか？",
"You can view the page following this link:" => "次のリンクをアクセスすると、ページを表示する事が出来ます:",
"updated by the phpwiki import process" => "updated by the phpwiki import process",
"created from phpwiki import" => "created from phpwiki import",
"Your Tiki account information for" => "Tiki Account Info :: ",
"A password reminder email has been sent " => "パスワードが記入されたメールが",
"A new password has been sent " => "新しいパスワードが",
"Upload was not successful (maybe a duplicate file)" => "Upload was not successful (maybe a duplicate file)",
"Invalid password.  You current password is required to change your email address." => "Invalid password.  You current password is required to change your email address.",
" new topic:" => " new topic:",
"New article submitted at " => "New article submitted at ",
"New message arrived from " => "New message arrived from ",
"Welcome to " => "Welcome to ",
" at " => " at ",
"Bye bye from " => "Bye bye from ",
"parent" => "parent",
"Posted comments" => "Posted comments",
"Unflagg" => "Unflagg",
"Time Zone Map" => "Time Zone Map",
"stat" => "stat",
"Comm" => "Comm",
"ExtWikis" => "ExtWikis",
"assgn" => "assgn",
"save a custom copy" => "save a custom copy",
"use square brackets for an" => "use square brackets for an",
"link_description" => "link_description",
"Prevents parsing data" => "Prevents parsing data",
"act status" => "act status",
"running" => "running",
"Path to where the dumped files are (relative to tiki basedir with trailing slash ex: dump/)" => "Path to where the dumped files are (relative to tiki basedir with trailing slash ex: dump/)",
"ver" => "ver",
"op" => "op",
"Control by Object" => "Control by Object",
"Control by category" => "Control by category",
"Hide suggested questions" => "Hide suggested questions",
"this post was reported" => "this post was reported",
"report this post" => "report this post",
"checked" => "checked",
"unchecked" => "unchecked",
"someone from" => "。Tikiサイト「",
"Diff:" => "Diff:",
"The new page content is:" => "The new page content is:",
"More info about" => "More info about",
"idle" => "idle",
"Wiki page" => "Wikiページ",
"pageviews" => "ページ・ビュー数",
"Security check failed!" => "セキュリティー・チェックは失敗しました!",
"topic:" => "トピック:",
"You are not permitted to edit someone else\\'s post!" => "他人のポストを編集することは許可されてません!",
"Only an admin can remove a thread." => "スレッド削除は、管理者しかできません",
"forum topic" => "フォーラムトピック",
"Insert articles into a wikipage" => "Wikiのページに記事を挿入",
"note: those parameters are exclusive" => "注意: そのパラメーターはExclusiveです",
"Click here to delete this attachment" => "クリックしてこの添付を削除",
"Are you sure you want to delete this comment?" => "本当にこのコメントを削除しますか?",
"Click here to delete this comment" => "クリックしてコメントの削除",
"reply to this" => "返信する",
"Reply to parent comment" => "「親」コメントに返事をする",
"Click here to delete this copyright" => "クリックしてコピーライトを削除",
"compose message tpl" => "メッセージの作成TPL",
"messages tpl" => "メッセージTPL",
"Return to messages" => "メッセージ画面に戻る",
"Click here to unassign this module" => "クリックしてモジュールの割当解除",
"Admin structures" => "ストラクチャーを管理",
"Reduce area width" => "幅を狭く",
"Enlarge area width" => "幅を広く",
"In blog listing show user as" => "ブログ表示でユーザをこのように表示します",
"CMS settings" => "CMS設定",
"Time Zone" => "時間帯",
"Server time zone" => "サーバーが使用する時間帯",
"Ranking" => "ランキング",
"Warn on edit" => "編集時に警告",
"Are you sure you want to delete this calendar?" => "このカレンダーを削除してもよろしいですか？",
"Delete item from category?" => "カテゴリーからアイテムを削除しますか？",
"Are you sure you want to delete this category?" => "カテゴリーを削除してもよろしいですか？",
"Click here to delete this channel" => "クリックしてチャンネルの削除",
"Click here to delete this template" => "クリックしてテンプレートの削除",
"Click here to delete this cookie" => "クリックして中華クッキーの削除",
"Click here to delete this drawing" => "クリックして図形の削除",
"admin forums tpl" => "フォーラムTPLの管理",
"Threads can be voted" => "スレッドの投票が可能",
"Are you sure you want to delete this forum?" => "このフォーラム削除はよろしいですか？",
"Click here to delete this repository" => "クリックしてリポジトリーの削除",
"Click here to delete this rule" => "クリックしてルールの削除",
"Are you sure you want to delete this menu?" => "メニューを削除してもよろしいですか？",
"Click here to delete this menu" => "クリックしてメニューの削除",
"Click here to edit this menu" => "クリックしてメニューの編集",
"Click here to configure this menu" => "クリックしてメニューの設定",
"Add all your site users to this newsletter (broadcast)" => "全てのユーザーをこのニュースレターに加える(同報通知)",
"Add users" => "ユーザーの追加",
"admin notifications tpl" => "イベントのメール通知管理TPL",
"admin polls tpl" => "アンケートTPLの管理",
"tiki admin quicktags tpl" => "クイックタグの管理TPL",
"admin structures tpl" => "ストラクチャーtplを管理",
"admin surveys tpl" => "サーベイTPLの管理",
"Create New Survey:" => "サーベイの新規作成:",
"Show status when listing tracker items?" => "トラッカー・アイテム一覧時、ステータスを表示しますか？",
"Add New Group" => "新規グループ",
"Edit this group:" => "グループを編集する:",
"File gals" => "ファイルギャラリー",
"Image gals" => "画像ギャラリー",
"Cms" => "CMS(記事)",
"Content Templates" => "コンテント・テンプレート",
"Klick to enlarge" => "拡大するのにクリック",
"You can include the image in an HTML or Tiki page using" => "次の文字列を選択、コピー・ペーストすると、画像をHTMLやWikiページに含めます",
"Calendars Panel" => "表示設定パネル",
"Events Panel" => "イベント・パネル",
"Hide" => "隠す",
"-1m" => "-1ヶ月間",
"-7d" => "-7日間",
"-1d" => "-1日間",
"+1d" => "+1日",
"+7d" => "+7日",
"+1m" => "+1月",
"today" => "今日",
"Reuse question" => "質問の再利用",
"Add scaled images size X x Y" => "スケールされた画像を追加「X」ｘ「Y」",
"Import pages from a PHPWiki Dump" => "PHPWikiのダンプから、ページをインポートする",
"Received Pages" => "受信ページ",
"Show chart for the last " => "チャートに以前",
"days (0=all)" => "日間を表示(0=全て)",
"use filename" => "ファイル名を使う",
"remove bookmark" => "ブックマークを削除",
"Use dbl click to edit pages" => "ダブルクリックで編集",
"Change your email" => "メールアドレスを変更する",
"change email" => "アドレスを変更",
"Change your password" => "パスワードを変更する",
"change password" => "パスワードを変更",
"Configure this page" => "このページを設定する",
"All tasks" => "全てのタスク",
"mark as done" => "チェックされたタスクを「終了」にする",
"open tasks" => "チェックされたタスクを「更新中」にする",
"Add or edit a task" => "タスクの追加・変更",
"Start date" => "開始日付",
"Completed" => "終了",
"FAQ Questions" => "FAQ 質問集",
"FAQ Answers" => "FAQ 回答集",
"Show suggested questions/suggest a question" => "提案質問の表示／質問を提案する",
"Tracker Items" => "トラッカー・アイテム",
"Filters" => "フィルター",
"Click here to edit this comment" => "クリックしてコメントの編集",
"Click here to delete this contact" => "クリックしてコメントの削除",
"You can edit the page following this link:" => "次のリンクを利用してページの編集が出来ます:",
"Are you sure you want to delete this directory?" => "このディレクタリーを削除してもよろしいですか？",
"MyTiki (click!)" => "私のTiki(クリック!)",
"Admin (click!)" => "Tiki管理 (クリック!)",
"Go \r\n                    back" => "戻る",
"Return to home \r\n                    page" => "ホームへ戻る",
"Confirmation required" => "確認が必要です",
"WikiDiff::apply: line count mismatch: %s != %s" => "WikiDiff::apply: line count mismatch: %s != %s",
"WikiDiff::_check: failed" => "WikiDiff::_check: failed",
"WikiDiff::_check: edit sequence is non-optimal" => "WikiDiff::_check: edit sequence is non-optimal",
"WikiDiff Okay: LCS = %s" => "WikiDiff Okay: LCS = %s",
"no description" => "no description",
"Information:" => "Information:",
"Admin->Modules" => "Admin->Modules",
"Remind passwords by email" => "Remind passwords by email",
"LDAP Host" => "LDAP Host",
"LDAP Port" => "LDAP Port",
"Use {literal}{{/literal}ed id=name} or {literal}{{/literal}ted id=name} to insert dynamic zones" => "Use {literal}{{/literal}ed id=name} or {literal}{{/literal}ted id=name} to insert dynamic zones",
"Emphasis" => "Emphasis",
"italics" => "italics",
"both" => "both",
"use ...page... to separate pages" => "use ...page... to separate pages",
"make_headings" => "make_headings",
"underlines text" => "underlines text",
"Simple box" => "Simple box",
"Center" => "Center",
"Will display the text centered" => "Will display the text centered",
"Activs" => "Activs",
"Ins" => "Ins",
"time" => "time",
"Wiki quick help" => "Wiki quick help",
"Actual_version" => "Actual_version",
"Diff to version" => "Diff to version",
"perm" => "perm",
"You do not have permission to write the template" => "You do not have permission to write the template",
"You have to provide a name to the image" => "You have to provide a name to the image",
"requested a reminder of the password for the" => "」で登録されてる",
"since this is your registered email address we inform that the" => "のパスワード復帰依頼がありました。登録メール・アドレスがあった為、",
"password for this account is" => "新しいパスワードをお知らせします：",
"You can view the page by following this link:\n    {\$mail_machine}/tiki-index.php?page={\$mail_page|escape:\"url\"}" => "次のリンクをアクセスすると、ページを表示する事が出来ます:\n    {\$mail_machine}/tiki-index.php?page={\$mail_page|escape:\"url\"}",
"You can edit the page by following this link:\n    {\$mail_machine}/tiki-editpage.php?page={\$mail_page|escape:\"url\"}" => "次のリンクをアクセスすると、ページの編集が出来ます:\n    {\$mail_machine}/tiki-editpage.php?page={\$mail_page|escape:\"url\"}",
"You can view a diff back to the previous version by following\nthis link:\n    {\$mail_machine}/tiki-pagehistory.php?page={\$mail_page|escape:\"url\"}&diff2={\$mail_last_version}" => "このリンクをアクセスすると、以前のバージョンとの違いを表示することが出来ます:\n    {\$mail_machine}/tiki-pagehistory.php?page={\$mail_page|escape:\"url\"}&diff2={\$mail_last_version}",
"Click the :: option on the menu for more options." => "メニューの「::」をクリックして、オプションが出ます。",
"Please also see" => "さらに、",
"Please" => "多々な機能を",
"log in" => "ご利用するのに、",
"to access full functionalities" => "ログインしてください",
"Blog settings" => "ブログ設定",
"FAQs settings" => "FAQ設定",
"FAQ comments" => "FAQコメント",
"Poll settings" => "アンケートの設定",
"Create a tag for the current wiki" => "現在のWikiのタグを作成する",
"Tag Name" => "タグ名",
"Restore the wiki" => "Wikiを復元する",
"Remove a tag" => "タグを削除",
"Wiki comments settings" => "Wikiコメントの設定",
"Wiki page list configuration" => "Wikiページ一覧の設定",
"Like pages" => "似類ページ",
"Set" => "設定",
"Administration" => "Tiki管理パネル",
"List Calendars" => "カレンダーの一覧",
"Batch upload (CSV file)" => "バッチ処理(CSV ファイル)",
"Add Calendar Item" => "カレンダー・アイテムの追加",
"Will display using the indicated HTML color" => "Will display using the\nindicated HTML color",
"Quicklinks" => "クイックリンクス",
"Comparing versions" => "バージョンの比較",
"You have to create a gallery first!" => "先ず、ギャラリーを作って下さい!",
"Editing tracker item" => "トラッカー・アイテム編集中",
"You have to type a searchword" => "検索する文字列を入力して下さい",
// ### end of unused words

// ### start of untranslated words
// ### uncomment value pairs as you translate
// "The text in RED is" => "The text in RED is",
// "character(s) too long - please edit it." => "character(s) too long - please edit it.",
// "Catalan_Countries" => "Catalan_Countries",
// "Kazakstan" => "Kazakstan",
// "Kiribati" => "Kiribati",
// "Kuwait" => "Kuwait",
// "Latvia" => "Latvia",
// "Lebanon" => "Lebanon",
// "Lithuania" => "Lithuania",
// "Luxemburg" => "Luxemburg",
// "Malawi" => "Malawi",
// "Malaysia" => "Malaysia",
// "Malta" => "Malta",
// "Marshall_Islands" => "Marshall_Islands",
// "Mauritius" => "Mauritius",
// "Mexico" => "Mexico",
// "Morocco" => "Morocco",
// "Mozambique" => "Mozambique",
// "Nauru" => "Nauru",
// "Nepal" => "Nepal",
// "Netherlands" => "Netherlands",
// "New_Caledonia" => "New_Caledonia",
// "New_Zealand" => "New_Zealand",
// "Nicaragua" => "Nicaragua",
// "Nigeria" => "Nigeria",
// "Niue" => "Niue",
// "Norway" => "Norway",
// "Other" => "Other",
// "Pakistan" => "Pakistan",
// "Panama" => "Panama",
// "Papua_New_Guinea" => "Papua_New_Guinea",
// "Paraguay" => "Paraguay",
// "Peru" => "Peru",
// "Phillippines" => "Phillippines",
// "Poland" => "Poland",
// "Portugal" => "Portugal",
// "Puerto_Rico" => "Puerto_Rico",
// "Quatar" => "Quatar",
// "Romania" => "Romania",
// "Russia" => "Russia",
// "Samoa" => "Samoa",
// "Saudi_Arabia" => "Saudi_Arabia",
// "Singapore" => "Singapore",
// "Slovakia" => "Slovakia",
// "Slovenia" => "Slovenia",
// "Solomon_Islands" => "Solomon_Islands",
// "Somalia" => "Somalia",
// "South_Africa" => "South_Africa",
// "South_Korea" => "South_Korea",
// "Spain" => "Spain",
// "Sri_Lanka" => "Sri_Lanka",
// "St_Vincent_Grenadines" => "St_Vincent_Grenadines",
// "Surinam" => "Surinam",
// "Sweden" => "Sweden",
// "Switzerland" => "Switzerland",
// "Taiwan" => "Taiwan",
// "Thailand" => "Thailand",
// "Tonga" => "Tonga",
// "Trinidad_Tobago" => "Trinidad_Tobago",
// "Turkey" => "Turkey",
// "Tuvalu" => "Tuvalu",
// "Ukraine" => "Ukraine",
// "United_Arab_Emirates" => "United_Arab_Emirates",
// "United_Kingdom" => "United_Kingdom",
// "United_States" => "United_States",
// "Uruguay" => "Uruguay",
// "Vanuatu" => "Vanuatu",
// "Venezuela" => "Venezuela",
// "Wales" => "Wales",
// "Yugoslavia" => "Yugoslavia",
// "Zambia" => "Zambia",
// "Zimbabwe" => "Zimbabwe",
// "Bulgaria" => "Bulgaria",
// "Arabic" => "Arabic",
// "Catalan" => "Catalan",
// "Simplified Chinese" => "Simplified Chinese",
// "Chinese" => "Chinese",
// "Czech" => "Czech",
// "Danish" => "Danish",
// "German" => "German",
// "English" => "English",
// "English British" => "English British",
// "Spanish" => "Spanish",
// "Greek" => "Greek",
// "Finnish" => "Finnish",
// "French" => "French",
// "Hebrew" => "Hebrew",
// "Croatian" => "Croatian",
// "Italian" => "Italian",
// "Korean" => "Korean",
// "Hungarian" => "Hungarian",
// "Dutch" => "Dutch",
// "Norwegian" => "Norwegian",
// "Polish" => "Polish",
// "Português" => "Português",
// "Brazilian Portuguese" => "Brazilian Portuguese",
// "Russian" => "Russian",
// "Pijin Solomon" => "Pijin Solomon",
// "Slovak" => "Slovak",
// "Serbian" => "Serbian",
// "Serbian Latin" => "Serbian Latin",
// "Swedish" => "Swedish",
// "Tuvaluan" => "Tuvaluan",
// "Traditional Chinese" => "Traditional Chinese",
// "Ukrainian" => "Ukrainian",
// "This instance of activity is already complete" => "This instance of activity is already complete",
// "Fatal error: cannot execute automatic activity \$activityId" => "Fatal error: cannot execute automatic activity \$activityId",
// "Fatal error: setting next activity to an unexisting activity" => "Fatal error: setting next activity to an unexisting activity",
// "Fatal error: nextActivity does not match any candidate in autorouting switch activity" => "Fatal error: nextActivity does not match any candidate in autorouting switch activity",
// "Fatal error: non-deterministic decision for autorouting activity" => "Fatal error: non-deterministic decision for autorouting activity",
// "Fatal error: trying to send an instance to an activity but no transition found" => "Fatal error: trying to send an instance to an activity but no transition found",
// "Cannot add transition only split activities can have more than one outbound transition" => "Cannot add transition only split activities can have more than one outbound transition",
// "Circular reference found some activity has a transition leading to itself" => "Circular reference found some activity has a transition leading to itself",
// "Process does not have a start activity" => "Process does not have a start activity",
// "Process does not have exactly one end activity" => "Process does not have exactly one end activity",
// "End activity is not reachable from start activity" => "End activity is not reachable from start activity",
// " is interactive but has no role assigned" => " is interactive but has no role assigned",
// " is non-interactive and non-autorouted but has no role assigned" => " is non-interactive and non-autorouted but has no role assigned",
// " is standalone but has transitions" => " is standalone but has transitions",
// " is not mapped" => " is not mapped",
// "Activity '.\$res['name'].' is standalone and is using the \$instance object" => "Activity '.\$res['name'].' is standalone and is using the \$instance object",
// "Activity '.\$res['name'].' is interactive so it must use the \$instance->complete() method" => "Activity '.\$res['name'].' is interactive so it must use the \$instance->complete() method",
// "Activity '.\$res['name'].' is non-interactive so it must not use the \$instance->complete() method" => "Activity '.\$res['name'].' is non-interactive so it must not use the \$instance->complete() method",
// "Activity '.\$res['name'].' is switch so it must use \$instance->setNextActivity(\$actname) method" => "Activity '.\$res['name'].' is switch so it must use \$instance->setNextActivity(\$actname) method",
// "Process %d has been activated" => "Process %d has been activated",
// "Process %d has been deactivated" => "Process %d has been deactivated",
// "Process %s %s imported" => "Process %s %s imported",
// "Process %s removed" => "Process %s removed",
// "Process %s has been updated" => "Process %s has been updated",
// "Process %s has been created" => "Process %s has been created",
// "Administration:" => "Administration:",
// "file gallery" => "file gallery",
// "image gallery" => "image gallery",
// "newsletter" => "newsletter",
// "survey" => "survey",
// "wiki page" => "wiki page",
// "Cannot write to this file: " => "Cannot write to this file: ",
// "Use this thread to discuss the %s page." => "Use this thread to discuss the %s page.",
// "Line:" => "Line:",
// "Lines:" => "Lines:",
// "There was a problem with your upload." => "There was a problem with your upload.",
// "The file you are trying to upload is too big." => "The file you are trying to upload is too big.",
// "The file you are trying to upload was only partially uploaded." => "The file you are trying to upload was only partially uploaded.",
// "You must select a file for upload." => "You must select a file for upload.",
// "No valid ogr2ogr executable" => "No valid ogr2ogr executable",
// "Could not create \$tdo.mif in data directory" => "Could not create \$tdo.mif in data directory",
// "Could not create \$tdo.mid in data directory" => "Could not create \$tdo.mid in data directory",
// "User Map Generated in:" => "User Map Generated in:",
// "Image Map Generated in:" => "Image Map Generated in:",
// "File %s not found" => "File %s not found",
// "File %s is not a valid archive" => "File %s is not a valid archive",
// "%s is an empty archive file" => "%s is an empty archive file",
// "Invalid remote file on url %s" => "Invalid remote file on url %s",
// "Impossible to open %s : %s" => "Impossible to open %s : %s",
// "This poll is closed." => "This poll is closed.",
// "Forums last posts" => "Forums last posts",
// "tikiwiki logo" => "tikiwiki logo",
// "See other user's profile" => "See other user's profile",
// "Have your profile seen" => "Have your profile seen",
// "Make friends" => "Make friends",
// "Receive message" => "Receive message",
// "Read an article" => "Read an article",
// "Publish an article" => "Publish an article",
// "Have your article read" => "Have your article read",
// "Create new file gallery" => "Create new file gallery",
// "Upload new file to gallery" => "Upload new file to gallery",
// "Download other user's file" => "Download other user's file",
// "Have your file downloaded" => "Have your file downloaded",
// "Create a new image gallery" => "Create a new image gallery",
// "Upload new image to gallery" => "Upload new image to gallery",
// "See other user's gallery" => "See other user's gallery",
// "See other user's image" => "See other user's image",
// "Have your gallery seen by other user" => "Have your gallery seen by other user",
// "Have your image seen" => "Have your image seen",
// "Create new blog" => "Create new blog",
// "Post in a blog" => "Post in a blog",
// "Read other user's blog" => "Read other user's blog",
// "Have your blog read" => "Have your blog read",
// "Create a new wiki page" => "Create a new wiki page",
// "Edit an existing page" => "Edit an existing page",
// "Trackeritem" => "Trackeritem",
// "Tracker item" => "Tracker item",
// "The text is" => "The text is",
// "Text cut here" => "Text cut here",
// "Task" => "Task",
// "Start date:" => "Start date:",
// "End date:" => "End date:",
// "Friend" => "Friend",
// "km" => "km",
// "Last seen on " => "Last seen on ",
// "(idle for %s seconds)" => "(idle for %s seconds)",
// "User information - Click for more info" => "User information - Click for more info",
// "More info about \$other_user" => "More info about \$other_user",
// "(idle for \$idletime seconds)" => "(idle for \$idletime seconds)",
// "Use this tree to copy the structure" => "Use this tree to copy the structure",
// "An error occured in a database query!" => "An error occured in a database query!",
// "img-g" => "img-g",
// "file-g" => "file-g",
// "arts" => "arts",
// "Altering database table failed" => "Altering database table failed",
// "%d points" => "%d points",
// "Removed" => "Removed",
// "__WARNING__: No such module \$plugin! " => "__WARNING__: No such module \$plugin! ",
// "Create page:" => "Create page:",
// "index" => "index",
// "show" => "show",
// "hide" => "hide",
// "Updated" => "Updated",
// "Status:" => "Status:",
// "(unchanged)" => "(unchanged)",
// "Item Modification" => "Item Modification",
// "Item creation" => "Item creation",
// "field is not numeric" => "field is not numeric",
// "half column" => "half column",
// "prepend" => "prepend",
// "append" => "append",
// "max" => "max",
// "Text options: 1,size,prepend,append,max with size in chars, prepend will be displayed before the field append will be displayed just after, max is the maximum number of characters that can be saved, and initial 1 to make that next text field or checkbox is in same row. If you indicate only 1 it means next field is in same row too." => "Text options: 1,size,prepend,append,max with size in chars, prepend will be displayed before the field append will be displayed just after, max is the maximum number of characters that can be saved, and initial 1 to make that next text field or checkbox is in same row. If you indicate only 1 it means next field is in same row too.",
// "Textarea options: quicktags,width,height,max,listmax - Use Quicktags is 1 or 0, widthis indicated in chars, height is indicated in lines, max is the maximum number of characters that can be saved, listmax isthe maximum number of characters that are displayed in list mode." => "Textarea options: quicktags,width,height,max,listmax - Use Quicktags is 1 or 0, widthis indicated in chars, height is indicated in lines, max is the maximum number of characters that can be saved, listmax isthe maximum number of characters that are displayed in list mode.",
// "Checkbox options: put 1 if you need that next field is on the same row." => "Checkbox options: put 1 if you need that next field is on the same row.",
// "numeric field" => "numeric field",
// "Numeric options: 1,size,prepend,append with size in chars, prepend will be displayed before the field append will be displayed just after, and initial 1 to make that next text field or checkbox is in same row. If you indicate only 1 it means next field is in same row too." => "Numeric options: 1,size,prepend,append with size in chars, prepend will be displayed before the field append will be displayed just after, and initial 1 to make that next text field or checkbox is in same row. If you indicate only 1 it means next field is in same row too.",
// "Dropdown options: list of items separated with commas." => "Dropdown options: list of items separated with commas.",
// "User Selector: use options for automatic field feeding : you can use 1 for author login or 2 for modificator login." => "User Selector: use options for automatic field feeding : you can use 1 for author login or 2 for modificator login.",
// "Group Selector: use options for automatic field feeding : you can use 1 for group of creation and 2 for group where modification come from. The default group has to be set, or the first group that come is chosen for a user, or the default group is Registered." => "Group Selector: use options for automatic field feeding : you can use 1 for group of creation and 2 for group where modification come from. The default group has to be set, or the first group that come is chosen for a user, or the default group is Registered.",
// "country selector" => "country selector",
// "Country Selector options: 1|2 where 1 show only country name and 2 show only country flag. By default show both country name and flag" => "Country Selector options: 1|2 where 1 show only country name and 2 show only country flag. By default show both country name and flag",
// "jscalendar" => "jscalendar",
// "Image options: xListSize,yListSize,xDetailsSize,yDetailsSize,uploadLimitScale indicated in pixels." => "Image options: xListSize,yListSize,xDetailsSize,yDetailsSize,uploadLimitScale indicated in pixels.",
// "Action options: Label,post,tiki-index.php,page:fieldname,highlight=test" => "Action options: Label,post,tiki-index.php,page:fieldname,highlight=test",
// "header" => "header",
// "Category options: parentId" => "Category options: parentId",
// "item link" => "item link",
// "Item Link options: trackerId,fieldId,linkToItem links to item from trackerId which fieldId matches the content of that field. linkToItem 1|0 to create a link to the item in view mode and listing" => "Item Link options: trackerId,fieldId,linkToItem links to item from trackerId which fieldId matches the content of that field. linkToItem 1|0 to create a link to the item in view mode and listing",
// "items list" => "items list",
// "Items list options: trackerId,fieldIdThere, fieldIdHere, displayFieldIdThere, linkToItems displays the list of displayFieldIdThere from item in tracker trackerId where fieldIdThere matches fieldIdHere. linkToItems 1|0 to create a link to items in view mode and listing" => "Items list options: trackerId,fieldIdThere, fieldIdHere, displayFieldIdThere, linkToItems displays the list of displayFieldIdThere from item in tracker trackerId where fieldIdThere matches fieldIdHere. linkToItems 1|0 to create a link to items in view mode and listing",
// "Email address options: 0|1|2 where 0 puts the address as plain text, 1 does a hex encoded mailto link (more difficult for web spiders to pick it up and spam) and 2 does the normal href mailto." => "Email address options: 0|1|2 where 0 puts the address as plain text, 1 does a hex encoded mailto link (more difficult for web spiders to pick it up and spam) and 2 does the normal href mailto.",
// "system" => "system",
// "pending" => "pending",
// "Added:" => "Added:",
// "Removed:" => "Removed:",
// "Remaining:" => "Remaining:",
// "Old:" => "Old:",
// "New:" => "New:",
// "No extra information for that attached file. " => "No extra information for that attached file. ",
// "Include all post in a blog" => "Include all post in a blog",
// "Lists files in a directory" => "Lists files in a directory",
// "could not be opened because it doesn't exist or permission was denied" => "could not be opened because it doesn't exist or permission was denied",
// "Takes regex expressions and parses the content between the REGEX tags and replaces the text." => "Takes regex expressions and parses the content between the REGEX tags and replaces the text.",
// "one data per line" => "one data per line",
// "The SNARF plugin replaces itself with the HTML body of a URL.  Arbitrary regex replacement can be done on this content using regex and regexres, the latter being used as the second argument to preg_replace." => "The SNARF plugin replaces itself with the HTML body of a URL.  Arbitrary regex replacement can be done on this content using regex and regexres, the latter being used as the second argument to preg_replace.",
// "This data is put in a CODE caption." => "This data is put in a CODE caption.",
// "Missing url parameter for SNARF plugin." => "Missing url parameter for SNARF plugin.",
// "Displays browser client info" => "Displays browser client info",
// "Puts a link to an anchor in a wiki page. Use in conjunction with the ANAME plugin, which sets the location and name of the anchor" => "Puts a link to an anchor in a wiki page. Use in conjunction with the ANAME plugin, which sets the location and name of the anchor",
// "linktext" => "linktext",
// "Puts an anchor into a wiki page. Use in conjunction with the ALINK plugin, which makes links to the anchor" => "Puts an anchor into a wiki page. Use in conjunction with the ALINK plugin, which makes links to the anchor",
// "~np~{~/np~ARTICLES(max=>3,topic=>topicName,type=>type,categId=>Category parent ID)}{ARTICLES} Insert articles into a wikipage" => "~np~{~/np~ARTICLES(max=>3,topic=>topicName,type=>type,categId=>Category parent ID)}{ARTICLES} Insert articles into a wikipage",
// "no such attachment on this page" => "no such attachment on this page",
// "Displays an attachment or a list of them" => "Displays an attachment or a list of them",
// "num is optional and is the order number of the attachment in the list. If not provided, a list of all attachments is displayed.  Inline makes the comment be the text of the link." => "num is optional and is the order number of the attachment in the list. If not provided, a list of all attachments is displayed.  Inline makes the comment be the text of the link.",
// "note: colors and ln are exclusive" => "note: colors and ln are exclusive",
// "and" => "and",
// "Insert a division block on wiki page" => "Insert a division block on wiki page",
// "Creates a definition list" => "Creates a definition list",
// "one definition per line" => "one definition per line",
// "Displays a SWF on the wiki page" => "Displays a SWF on the wiki page",
// "Formula" => "Formula",
// "No formula specified." => "No formula specified.",
// "Impossible to render the graphic." => "Impossible to render the graphic.",
// "View graphic" => "View graphic",
// "Display wiki text if user is in one of listed groups" => "Display wiki text if user is in one of listed groups",
// "Runs a Java applet to access a local Jabber service" => "Runs a Java applet to access a local Jabber service",
// "Displays a map" => "Displays a map",
// "Displays an miniquiz" => "Displays an miniquiz",
// "Displays object hit info by object and days" => "Displays object hit info by object and days",
// "Displays the output of a poll, fields are indicated with numeric ids." => "Displays the output of a poll, fields are indicated with numeric ids.",
// "missing poll ID for plugin POLL" => "missing poll ID for plugin POLL",
// " wrote:" => " wrote:",
// "Quote:" => "Quote:",
// "Quote text by surrounding the text with a box, like the [QUOTE] BBCode" => "Quote text by surrounding the text with a box, like the [QUOTE] BBCode",
// "~np~{~/np~RSS(id=>feedId,max=>3,date=>1,body=>1)}{RSS} Insert rss feed output into a wikipage" => "~np~{~/np~RSS(id=>feedId,max=>3,date=>1,body=>1)}{RSS} Insert rss feed output into a wikipage",
// "Automatically creates a link to the appropriate SourceForge object" => "Automatically creates a link to the appropriate SourceForge object",
// "TikiSheet" => "TikiSheet",
// "Sheet Heading" => "Sheet Heading",
// "Edit Sheet" => "Edit Sheet",
// "List wiki pages" => "List wiki pages",
// "Last modified by" => "Last modified by",
// "Clickable Skype link" => "Clickable Skype link",
// "row1col1" => "row1col1",
// "row1col2" => "row1col2",
// "row2col1" => "row2col1",
// "row2col2" => "row2col2",
// "Displays text in subscript." => "Displays text in subscript.",
// "Displays text between an html tag" => "Displays text between an html tag",
// "Displays the thumbnail for an image" => "Displays the thumbnail for an image",
// "Following mandatory fields are missing" => "Following mandatory fields are missing",
// "Following fields are incorrect" => "Following fields are incorrect",
// "Displays an input form for tracker submit" => "Displays an input form for tracker submit",
// "You do not have permission to insert an item" => "You do not have permission to insert an item",
// "Fields marked with a * are mandatory." => "Fields marked with a * are mandatory.",
// "All fields must be from the same tracker" => "All fields must be from the same tracker",
// "Filters the items of a tracker, fields are indicated with numeric ids." => "Filters the items of a tracker, fields are indicated with numeric ids.",
// "missing parameters" => "missing parameters",
// "tracker field type not processed yet" => "tracker field type not processed yet",
// "incorrect filterfield" => "incorrect filterfield",
// "Displays the output of a tracker content, fields are indicated with numeric ids." => "Displays the output of a tracker content, fields are indicated with numeric ids.",
// "missing tracker ID for plugin TRACKER" => "missing tracker ID for plugin TRACKER",
// "missing fields list" => "missing fields list",
// "Error in tracker ID" => "Error in tracker ID",
// "No field indicated" => "No field indicated",
// "Split the text in parts visible only under some conditions" => "Split the text in parts visible only under some conditions",
// "Lists ''wanted'' Wiki pages: " => "Lists ''wanted'' Wiki pages: ",
// "Page-Pattern" => "Page-Pattern",
// "Custom-Level-Regex" => "Custom-Level-Regex",
// "^Parameters: key=>value,...\n" => "^Parameters: key=>value,...\n",
// "__key__ | __default__ | __comments__\n" => "__key__ | __default__ | __comments__\n",
// "empty string" => "empty string",
// "A wildcard pattern of originating pages to be ignored.<br />" => "A wildcard pattern of originating pages to be ignored.<br />",
// "(refer to PHP function fnmatch() for details)\n" => "(refer to PHP function fnmatch() for details)\n",
// "The character, by which ignored patterns are separated.<br />" => "The character, by which ignored patterns are separated.<br />",
// "possible values: characters\n" => "possible values: characters\n",
// "Whether to include external wikis in the list.<br />" => "Whether to include external wikis in the list.<br />",
// "possible values: " => "possible values: ",
// "Collect either originating or wanted pages in a cell and display them in the second column.<br />" => "Collect either originating or wanted pages in a cell and display them in the second column.<br />",
// "Switch-on debug output with details about the items.<br />" => "Switch-on debug output with details about the items.<br />",
// "Multiple collected items are separated in distinct table rows, or by comma or line break in one cell.<br />" => "Multiple collected items are separated in distinct table rows, or by comma or line break in one cell.<br />",
// "Filter the list of wanted pages according to page_regex or custom filter. The default value is the site's __current__ page_regex.<br />" => "Filter the list of wanted pages according to page_regex or custom filter. The default value is the site's __current__ page_regex.<br />",
// "A custom filter for wanted pages to be listed (only used when level=>custom).<br />" => "A custom filter for wanted pages to be listed (only used when level=>custom).<br />",
// "a valid regex-expression (PCRE)" => "a valid regex-expression (PCRE)",
// "non-valid custom regex" => "non-valid custom regex",
// ", " => ", ",
// "ignored" => "ignored",
// "dash-WikiWord" => "dash-WikiWord",
// "WikiWord" => "WikiWord",
// "not in level" => "not in level",
// "End of debug output." => "End of debug output.",
// "Wanted Page" => "Wanted Page",
// "Referenced By Page" => "Referenced By Page",
// "Plugin " => "Plugin ",
// "Sent box is full. Archive or delete some sent messages first if you want to send more messages." => "Sent box is full. Archive or delete some sent messages first if you want to send more messages.",
// "You have to be able to receive messages in order to send them. Goto your user preferences and enable 'Allow messages from other users'" => "You have to be able to receive messages in order to send them. Goto your user preferences and enable 'Allow messages from other users'",
// "User %s can not receive messages, mailbox is full" => "User %s can not receive messages, mailbox is full",
// "User %s can not receive messages" => "User %s can not receive messages",
// "Invalid user: %s" => "Invalid user: %s",
// "Archive is full. Delete some messages from archive first." => "Archive is full. Delete some messages from archive first.",
// "move %s in %s" => "move %s in %s",
// "Please provide an Id" => "Please provide an Id",
// "no object here yet" => "no object here yet",
// "This module requires parameters trackerId and name set" => "This module requires parameters trackerId and name set",
// "Changes" => "Changes",
// "Changes since" => "Changes since",
// "new posts" => "new posts",
// "new articles" => "new articles",
// "new FAQs" => "new FAQs",
// "new blogs" => "new blogs",
// "new blog posts" => "new blog posts",
// "new image galleries" => "new image galleries",
// "new file galleries" => "new file galleries",
// "new polls" => "new polls",
// "new tracker items" => "new tracker items",
// "The task title must have at least 3 characters" => "The task title must have at least 3 characters",
// "Invalid server key" => "Invalid server key",
// "Tip: hold down CTRL to select multiple categories" => "Tip: hold down CTRL to select multiple categories",
// "Tip: uncheck the above checkbox to uncategorize this page/object" => "Tip: uncheck the above checkbox to uncategorize this page/object",
// "browse category" => "browse category",
// "Posted messages" => "Posted messages",
// "Plain" => "Plain",
// "Threaded" => "Threaded",
// "Headers Only" => "Headers Only",
// "below your current threshold" => "below your current threshold",
// "new reply" => "new reply",
// "Editing reply" => "Editing reply",
// "Reply to the selected post" => "Reply to the selected post",
// "Post new message" => "Post new message",
// "Comment on the selected post" => "Comment on the selected post",
// "Reply to parent post" => "Reply to parent post",
// "Post new reply" => "Post new reply",
// "Reply" => "Reply",
// "Posting replies" => "Posting replies",
// "HTML tags are not allowed inside posts" => "HTML tags are not allowed inside posts",
// "Perhaps you were looking for:" => "Perhaps you were looking for:",
// "There are no wiki pages similar to '{\$page}'" => "There are no wiki pages similar to '{\$page}'",
// "(page will be orphaned)" => "(page will be orphaned)",
// "Close Window" => "Close Window",
// "Last update from CVS" => "Last update from CVS",
// "RSS Wiki" => "RSS Wiki",
// "RSS Blogs" => "RSS Blogs",
// "RSS Articles" => "RSS Articles",
// "RSS Image Galleries" => "RSS Image Galleries",
// "RSS File Galleries" => "RSS File Galleries",
// "RSS Forums" => "RSS Forums",
// "RSS Maps" => "RSS Maps",
// "RSS Directories" => "RSS Directories",
// "RSS Calendars" => "RSS Calendars",
// "Information" => "Information",
// "New topic:" => "New topic:",
// "Topic:" => "Topic:",
// "You sent a request with the subject:" => "You sent a request with the subject:",
// "Use the subject to indicate the operation to apply:" => "Use the subject to indicate the operation to apply:",
// "GET:WikiName to get a wiki page" => "GET:WikiName to get a wiki page",
// "PUT:WikiName to update/create a wiki page (use the body for the page data)" => "PUT:WikiName to update/create a wiki page (use the body for the page data)",
// "APPEND:WikiName to append data to a Wiki page (use the body for the data to add)" => "APPEND:WikiName to append data to a Wiki page (use the body for the data to add)",
// "PREPEND:WikiName to append the data at the top" => "PREPEND:WikiName to append the data at the top",
// "Tiki mail-in auto-reply." => "Tiki mail-in auto-reply.",
// "Page not found:" => "Page not found:",
// "New message arrived from %s" => "New message arrived from %s",
// "Your Tiki account registration request for {\$mail_site} was validated by the site admin and your account is active now." => "Your Tiki account registration request for {\$mail_site} was validated by the site admin and your account is active now.",
// "To login with your username and password, please follow this link:" => "To login with your username and password, please follow this link:",
// "Tiki User Account Activated" => "Tiki User Account Activated",
// "has requested an account on" => "has requested an account on",
// "To validate that account, please follow the link:" => "To validate that account, please follow the link:",
// "best regards" => "best regards",
// "your Tikiwiki" => "your Tikiwiki",
// "Tiki User Registration Request" => "Tiki User Registration Request",
// "Go to your friendship network to accept or refuse this request" => "Go to your friendship network to accept or refuse this request",
// "You're invited to join my network of friends!" => "You're invited to join my network of friends!",
// "Bye bye from %s at %s" => "Bye bye from %s at %s",
// "Welcome to %s at %s" => "Welcome to %s at %s",
// "Someone coming from IP Address" => "Someone coming from IP Address",
// "requested a reminder of the password for your account" => "requested a reminder of the password for your account",
// "requested password reset for your account" => "requested password reset for your account",
// "Since this is your registered email address we inform that the password for this account is" => "Since this is your registered email address we inform that the password for this account is",
// "Please click on the following link to confirm you wish to reset your password and go to the screen where you must enter a new \"permanent\" password. Please pick a password only you will know, and don't share it with anyone else.\n{\$mail_machine}/tiki-remind_password.php?user={\$mail_user|escape:'url'}&actpass={\$mail_apass}\n\nDone! You should be logged in." => "Please click on the following link to confirm you wish to reset your password and go to the screen where you must enter a new \"permanent\" password. Please pick a password only you will know, and don't share it with anyone else.\n{\$mail_machine}/tiki-remind_password.php?user={\$mail_user|escape:'url'}&actpass={\$mail_apass}\n\nDone! You should be logged in.",
// "Important: Username & password are CaSe SenSitiVe" => "Important: Username & password are CaSe SenSitiVe",
// "Important: The old password remains active if you don't click the link above." => "Important: The old password remains active if you don't click the link above.",
// "Your Tiki account information for %s" => "Your Tiki account information for %s",
// "New article submitted at %s" => "New article submitted at %s",
// "View the tracker item at:" => "View the tracker item at:",
// "Tracker was modified at" => "Tracker was modified at",
// "Your account request have been stored and will be activated by the admin as soon as possible." => "Your account request have been stored and will be activated by the admin as soon as possible.",
// "New article post: {\$mail_title} by {\$mail_user} at {\$mail_date|tiki_short_datetime}" => "New article post: {\$mail_title} by {\$mail_user} at {\$mail_date|tiki_short_datetime}",
// "View the article at:" => "View the article at:",
// "New article post at %s" => "New article post at %s",
// "New blog post at %s" => "New blog post at %s",
// "File Gallery %s changed" => "File Gallery %s changed",
// "A file was removed from the file gallery" => "A file was removed from the file gallery",
// "Removed by" => "Removed by",
// "File Name" => "File Name",
// "A new file was posted to file gallery" => "A new file was posted to file gallery",
// "Posted by" => "Posted by",
// "The map {\$mail_page} was changed by {\$mail_user} at {\$mail_date|tiki_short_datetime}" => "The map {\$mail_page} was changed by {\$mail_user} at {\$mail_date|tiki_short_datetime}",
// "A new file have been attached to page" => "A new file have been attached to page",
// "File name" => "File name",
// "New attachment on %s, page" => "New attachment on %s, page",
// "The page {\$mail_page} was created by {\$mail_user} at {\$mail_date|tiki_short_datetime}" => "The page {\$mail_page} was created by {\$mail_user} at {\$mail_date|tiki_short_datetime}",
// "You can view the page by following this link:" => "You can view the page by following this link:",
// "You can view a diff back to the previous version by following this link:" => "You can view a diff back to the previous version by following this link:",
// "The changes in this version follow below, followed after by the current full page text." => "The changes in this version follow below, followed after by the current full page text.",
// "-Lines: {\$oldd} changed to +Lines: {\$newd}" => "-Lines: {\$oldd} changed to +Lines: {\$newd}",
// "The new page content follows below." => "The new page content follows below.",
// "Wiki page %s changed" => "Wiki page %s changed",
// "The page {\$mail_page} was commented by {\$mail_user} at {\$mail_date|tiki_short_datetime}" => "The page {\$mail_page} was commented by {\$mail_user} at {\$mail_date|tiki_short_datetime}",
// "Wiki page renamed" => "Wiki page renamed",
// "Old name" => "Old name",
// "click on the map to zoom or pan, do not drag" => "click on the map to zoom or pan, do not drag",
// "Scale" => "Scale",
// "Zoom out x4" => "Zoom out x4",
// "Zoom out x3" => "Zoom out x3",
// "Zoom out x2" => "Zoom out x2",
// "Query" => "Query",
// "Pan" => "Pan",
// "Zoom in x2" => "Zoom in x2",
// "Zoom in x3" => "Zoom in x3",
// "Zoom in x4" => "Zoom in x4",
// "Redraw" => "Redraw",
// "select zoom/pan/query and image size" => "select zoom/pan/query and image size",
// "Go" => "Go",
// "View the Map Only" => "View the Map Only",
// "Reset Map" => "Reset Map",
// "Click on the map or click redraw" => "Click on the map or click redraw",
// "Overview" => "Overview",
// "Legend" => "Legend",
// "Layer Manager" => "Layer Manager",
// "Layer" => "Layer",
// "On" => "On",
// "Label" => "Label",
// "Download" => "Download",
// "Download Layer" => "Download Layer",
// "This layer has been set by the maps administrator to not be downloadable" => "This layer has been set by the maps administrator to not be downloadable",
// "you have requested to download the layer:" => "you have requested to download the layer:",
// "from\nthe mapfile:" => "from\nthe mapfile:",
// "Here are the files to download, do not forget to rename them:" => "Here are the files to download, do not forget to rename them:",
// "Mapfiles" => "Mapfiles",
// "Mapfile" => "Mapfile",
// "Available mapfiles" => "Available mapfiles",
// "hits last 7 days" => "hits last 7 days",
// "monitor this map" => "monitor this map",
// "stop monitoring this map" => "stop monitoring this map",
// "Create a new mapfile" => "Create a new mapfile",
// "Mapfile listing" => "Mapfile listing",
// "Reload" => "Reload",
// "Mapfile History" => "Mapfile History",
// "Comparing version {\$old.version} with version {\$new.version}" => "Comparing version {\$old.version} with version {\$new.version}",
// "Version:" => "Version:",
// "Legend:" => "Legend:",
// "v=view" => "v=view",
// "c=compare" => "c=compare",
// "d=diff" => "d=diff",
// "Side-by-side diff" => "Side-by-side diff",
// "Full side-by-side diff" => "Full side-by-side diff",
// "Unified diff" => "Unified diff",
// "Side-by-side view" => "Side-by-side view",
// "older version" => "older version",
// "Directories" => "Directories",
// "back to" => "back to",
// "Upload From Disk:" => "Upload From Disk:",
// "Upload Files" => "Upload Files",
// "Bytes maximum" => "Bytes maximum",
// "Create" => "Create",
// "index file (.shp):" => "index file (.shp):",
// "files to index (regexp):" => "files to index (regexp):",
// "Message Archive" => "Message Archive",
// "messages" => "messages",
// "Archive is full!" => "Archive is full!",
// "download" => "download",
// "flagged" => "flagged",
// "If you want people to be able to reply to you, you have to check <a href='tiki-user_preferences.php'>Allow messages from other users</a>" => "If you want people to be able to reply to you, you have to check <a href='tiki-user_preferences.php'>Allow messages from other users</a>",
// "No messages to download" => "No messages to download",
// "Mailbox is full! Delete or archive some messages if you want to receive more messages." => "Mailbox is full! Delete or archive some messages if you want to receive more messages.",
// "move to archive" => "move to archive",
// "reply to" => "reply to",
// "find replied message" => "find replied message",
// "Sent" => "Sent",
// "Archive" => "Archive",
// "Auto-archive age for read messages:" => "Auto-archive age for read messages:",
// "Return to mailbox" => "Return to mailbox",
// "Unflag" => "Unflag",
// "Return to archive" => "Return to archive",
// "Return to outbox" => "Return to outbox",
// "Sent Messages" => "Sent Messages",
// "Replied" => "Replied",
// "Not replied" => "Not replied",
// "receiver" => "receiver",
// "replied" => "replied",
// "'name' parameter for tikimodule missed" => "'name' parameter for tikimodule missed",
// "Hide module contents" => "Hide module contents",
// "opp side" => "opp side",
// "Shoutbox Words" => "Shoutbox Words",
// "Security Admin" => "Security Admin",
// "Display type unknown, you have to enter the banner type" => "Display type unknown, you have to enter the banner type",
// "You forgot your Google ad_client number !" => "You forgot your Google ad_client number !",
// "MyTiki home" => "MyTiki home",
// "WfMenu" => "WfMenu",
// "FriendsMenu" => "FriendsMenu",
// "Community" => "Community",
// "User list" => "User list",
// "Friendship Network" => "Friendship Network",
// "WikiMenu" => "WikiMenu",
// "GalMenu" => "GalMenu",
// "ForMenu" => "ForMenu",
// "DirMenu" => "DirMenu",
// "FileGalMenu" => "FileGalMenu",
// "Maps" => "Maps",
// "ShtMenu" => "ShtMenu",
// "TrkMenu" => "TrkMenu",
// "SrvMenu" => "SrvMenu",
// "Send events" => "Send events",
// "Admin events" => "Admin events",
// "EphMenu" => "EphMenu",
// "Ephemerides Admin" => "Ephemerides Admin",
// "ChartMenu" => "ChartMenu",
// "Charts Admin" => "Charts Admin",
// "AdmMenu" => "AdmMenu",
// "Admin home" => "Admin home",
// "Mods Admin" => "Mods Admin",
// "UsrMenu" => "UsrMenu",
// "Click the :: options in the Menu for more options." => "Click the :: options in the Menu for more options.",
// "Please, also see" => "Please, also see",
// "Note 1:" => "Note 1:",
// "as well as assign or edit many others." => "as well as assign or edit many others.",
// "Note 2:" => "Note 2:",
// "The menu module installed by default is named" => "The menu module installed by default is named",
// "it is a \"custom module\" which includes menu ID " => "it is a \"custom module\" which includes menu ID ",
// "That menu is stored in database and it can be edited from " => "That menu is stored in database and it can be edited from ",
// "Do not mix this with the original <em>application_menu</em> module" => "Do not mix this with the original <em>application_menu</em> module",
// "That one can be heavily customized to match style used but it can be currently done only by editing mod-application_menu.tpl file \"manually\"" => "That one can be heavily customized to match style used but it can be currently done only by editing mod-application_menu.tpl file \"manually\"",
// "January" => "January",
// "February" => "February",
// "March" => "March",
// "April" => "April",
// "May" => "May",
// "June" => "June",
// "July" => "July",
// "August" => "August",
// "September" => "September",
// "October" => "October",
// "November" => "November",
// "December" => "December",
// "Current events" => "Current events",
// "Last `\$module_rows` forum posts" => "Last `\$module_rows` forum posts",
// "Last forum posts" => "Last forum posts",
// "Last `\$module_rows` actions" => "Last `\$module_rows` actions",
// "Last actions" => "Last actions",
// "Last `\$module_rows` Images" => "Last `\$module_rows` Images",
// "Last Images" => "Last Images",
// "Last `\$module_rows` modified events" => "Last `\$module_rows` modified events",
// "Last modifed events" => "Last modifed events",
// "Last `\$module_rows` Modified Comments" => "Last `\$module_rows` Modified Comments",
// "Last Modified Comments" => "Last Modified Comments",
// "Last `\$module_rows` visitors" => "Last `\$module_rows` visitors",
// "Last visitors" => "Last visitors",
// "Login through CAS" => "Login through CAS",
// "Login as admin" => "Login as admin",
// "local account" => "local account",
// "Send a message" => "Send a message",
// "Random Images" => "Random Images",
// "Your email could not be validated; make sure you email is correct and click register below." => "Your email could not be validated; make sure you email is correct and click register below.",
// "Random Image" => "Random Image",
// "RSS Feeds" => "RSS Feeds",
// "Wiki RSS" => "Wiki RSS",
// "Blogs RSS" => "Blogs RSS",
// "Articles RSS" => "Articles RSS",
// "Image Galleries RSS" => "Image Galleries RSS",
// "File Galleries RSS" => "File Galleries RSS",
// "Forums RSS" => "Forums RSS",
// "Maps RSS" => "Maps RSS",
// "Calendars" => "Calendars",
// "Exact&nbsp;match" => "Exact&nbsp;match",
// "Top `\$module_rows` Forum Posters" => "Top `\$module_rows` Forum Posters",
// "Top Forum Posters" => "Top Forum Posters",
// "Top `\$module_rows` Objects" => "Top `\$module_rows` Objects",
// "Top Objects" => "Top Objects",
// "Upcoming `\$module_rows` events" => "Upcoming `\$module_rows` events",
// "Public tasks" => "Public tasks",
// "select" => "select",
// "User informations" => "User informations",
// "Group informations" => "Group informations",
// "You need to activate user and/or group trackers" => "You need to activate user and/or group trackers",
// "Top users" => "Top users",
// "on host" => "on host",
// " on page " => " on page ",
// "Click to see the ratings" => "Click to see the ratings",
// "[-]" => "[-]",
// "Manage structures" => "Manage structures",
// "Are you sure you want to remove this module?" => "Are you sure you want to remove this module?",
// "Powered by" => "Powered by",
// "page id" => "page id",
// "3d browser" => "3d browser",
// "Parent page" => "Parent page",
// "Child" => "Child",
// "Add Page" => "Add Page",
// "Last edited by" => "Last edited by",
// "based on work by" => "based on work by",
// "Page last modified on" => "Page last modified on",
// "Contributors to this page" => "Contributors to this page",
// "translation" => "translation",
// "Tiki community" => "Tiki community",
// "User List" => "User List",
// "Homework" => "Homework",
// "Assignments" => "Assignments",
// "Show/Hide Left Menus" => "Show/Hide Left Menus",
// "Show/Hide Right Menus" => "Show/Hide Right Menus",
// "Member list" => "Member list",
// "logout" => "logout",
// "Edit Summary" => "Edit Summary",
// "Anti-Bot verification code" => "Anti-Bot verification code",
// "Enter the code you see above" => "Enter the code you see above",
// "RSS Trackers" => "RSS Trackers",
// "left/right" => "left/right",
// "Edit mapfiles" => "Edit mapfiles",
// "Topic image" => "Topic image",
// "Location : " => "Location : ",
// "Translate in" => "Translate in",
// "babelfish it" => "babelfish it",
// "Welcome to" => "Welcome to",
// "Click here to create it" => "Click here to create it",
// "Meta Tags" => "Meta Tags",
// "Site Identity" => "Site Identity",
// "Site Calendar" => "Site Calendar",
// "Intertiki" => "Intertiki",
// "InterTiki" => "InterTiki",
// "i18n" => "i18n",
// "Tip" => "Tip",
// "To add/remove blogs, go to \"Create/Edit blog\" under \"Blogs\" on the application menu, or" => "To add/remove blogs, go to \"Create/Edit blog\" under \"Blogs\" on the application menu, or",
// "Post level trackback pings" => "Post level trackback pings",
// "Not Installed" => "Not Installed",
// "To add/remove calendars, look for \"Calendar\" under \"Admin\" on the application menu, or" => "To add/remove calendars, look for \"Calendar\" under \"Admin\" on the application menu, or",
// "Group calendar sticky popup" => "Group calendar sticky popup",
// "Group calendar item view tab" => "Group calendar item view tab",
// "Calendar manual selection of time/date" => "Calendar manual selection of time/date",
// "JsCalendar" => "JsCalendar",
// "Change settings" => "Change settings",
// "Look under \"Articles\" on the application menu for links to" => "Look under \"Articles\" on the application menu for links to",
// "Print article" => "Print article",
// "Settings for page articles home" => "Settings for page articles home",
// "Fields to display on page" => "Fields to display on page",
// "User identity features" => "User identity features",
// "Show user's info on mouseover" => "Show user's info on mouseover",
// "Picture" => "Picture",
// "Number of friends" => "Number of friends",
// "E-mail" => "E-mail",
// "Distance" => "Distance",
// "To configure your directory, find \"Admin directory\" under \"Directory\" on the application menu, or" => "To configure your directory, find \"Admin directory\" under \"Directory\" on the application menu, or",
// "enable cool sites" => "enable cool sites",
// "To add/remove FAQs, look for \"Admin FAQs\" under \"FAQs\" on the application menu, or" => "To add/remove FAQs, look for \"Admin FAQs\" under \"FAQs\" on the application menu, or",
// "Please see the <a class=\"rbox-link\" target=\"tikihelp\" href=\"http://doc.tikiwiki.org/tiki-index.php?page=Features\">evaluation of each feature</a> on Tiki's developer site." => "Please see the <a class=\"rbox-link\" target=\"tikihelp\" href=\"http://doc.tikiwiki.org/tiki-index.php?page=Features\">evaluation of each feature</a> on Tiki's developer site.",
// "tikiwiki.org help" => "tikiwiki.org help",
// "Multilingual" => "Multilingual",
// "Best language" => "Best language",
// "Template Viewing" => "Template Viewing",
// "PHPLayers" => "PHPLayers",
// "Use Tabs" => "Use Tabs",
// "Tiki Sheet" => "Tiki Sheet",
// "Site Logo and Identity" => "Site Logo and Identity",
// "Mobile" => "Mobile",
// "Google Maps" => "Google Maps",
// "Trackbacks Pings" => "Trackbacks Pings",
// "Use Quote plugin rather than &ldquo;>&rdquo; for quoting" => "Use Quote plugin rather than &ldquo;>&rdquo; for quoting",
// "Contact Us (Anonymous)" => "Contact Us (Anonymous)",
// "Redirect On Error" => "Redirect On Error",
// "always" => "always",
// "module decides" => "module decides",
// "never" => "never",
// "Users can Shade Modules" => "Users can Shade Modules",
// "User Watches Translations" => "User Watches Translations",
// "Users can Flip Columns" => "Users can Flip Columns",
// "user decides" => "user decides",
// "Bottom bar icons" => "Bottom bar icons",
// "Bottom bar debug" => "Bottom bar debug",
// "To add/remove file galleries, go to \"File Galleries\" on the application menu, or" => "To add/remove file galleries, go to \"File Galleries\" on the application menu, or",
// "Home Gallery" => "Home Gallery",
// "Allow same file to be uploaded more than once" => "Allow same file to be uploaded more than once",
// "Storing files in a directory" => "Storing files in a directory",
// "If you decide to store files in a directory you must ensure that the user cannot access directly to the directory." => "If you decide to store files in a directory you must ensure that the user cannot access directly to the directory.",
// "You have two options to accomplish this:<br /><ul><li>Use a directory outside your document root, make sure your php script can read and write to that directory</li><li>Use a directory inside the document root and use .htaccess to prevent the user from listing the directory contents</li></ul>" => "You have two options to accomplish this:<br /><ul><li>Use a directory outside your document root, make sure your php script can read and write to that directory</li><li>Use a directory inside the document root and use .htaccess to prevent the user from listing the directory contents</li></ul>",
// "To configure the directory path use UNIX like paths for example files/ or c:/foo/files or /www/files/" => "To configure the directory path use UNIX like paths for example files/ or c:/foo/files or /www/files/",
// "Change configuration" => "Change configuration",
// "File galleries search indexing" => "File galleries search indexing",
// "Leave command blank to delete handler" => "Leave command blank to delete handler",
// "Use %1 for where internal file name should be substituted (example: \"strings %1\" to convert the document to text using the unix strings command)" => "Use %1 for where internal file name should be substituted (example: \"strings %1\" to convert the document to text using the unix strings command)",
// "Enable auto indexing on file upload or change" => "Enable auto indexing on file upload or change",
// "MIME Type" => "MIME Type",
// "System command" => "System command",
// "Reindex all files for search" => "Reindex all files for search",
// "To add/remove forums, look for \"Admin forums\" under \"Forums\" on the application menu, or" => "To add/remove forums, look for \"Admin forums\" under \"Forums\" on the application menu, or",
// "Home Forum" => "Home Forum",
// "Forums features" => "Forums features",
// "To add/remove image galleries, go to \"Image Galleries\" on the application menu, or" => "To add/remove image galleries, go to \"Image Galleries\" on the application menu, or",
// "You can upload images of a size of " => "You can upload images of a size of ",
// "Alter the php.ini variables file_uploads, upload_max_filesize, post_max_size and database variables (max_allowed_packet for mysql) to change this value" => "Alter the php.ini variables file_uploads, upload_max_filesize, post_max_size and database variables (max_allowed_packet for mysql) to change this value",
// "Directory Batch Loading" => "Directory Batch Loading",
// "If you enable Directory Batch Loading, you need to setup a web-readable directory (outside of your web space is better). Then setup a way to upload images in that dir, either by scp, ftp, or other protocols" => "If you enable Directory Batch Loading, you need to setup a web-readable directory (outside of your web space is better). Then setup a way to upload images in that dir, either by scp, ftp, or other protocols",
// "Enable directory batch loading" => "Enable directory batch loading",
// "Batch loading directory" => "Batch loading directory",
// "Enable cache images to all galleries" => "Enable cache images to all galleries",
// "Images cache directory" => "Images cache directory",
// "Exterminator" => "Exterminator",
// "Mover" => "Mover",
// "Move images from database storage to filesystem storage" => "Move images from database storage to filesystem storage",
// "Move images from filesystem storage to database storage" => "Move images from filesystem storage to database storage",
// "Move images from old filesystem store to new directory" => "Move images from old filesystem store to new directory",
// "Moved" => "Moved",
// "Change style only" => "Change style only",
// "Go to group homepage only if login from default homepage" => "Go to group homepage only if login from default homepage",
// "Detect browser language" => "Detect browser language",
// "PHP error reporting level for non-admin:" => "PHP error reporting level for non-admin:",
// "No error reporting" => "No error reporting",
// "Report all PHP errors" => "Report all PHP errors",
// "Report all errors except notices" => "Report all errors except notices",
// "Report PHP errors only for admin" => "Report PHP errors only for admin",
// "Default charset for sending mail:" => "Default charset for sending mail:",
// "Mail end of line:" => "Mail end of line:",
// "(standard)" => "(standard)",
// "(some Unix MTA)" => "(some Unix MTA)",
// "output compression is active." => "output compression is active.",
// "compression is handled by" => "compression is handled by",
// "Hide anonymous-only modules from registered users" => "Hide anonymous-only modules from registered users",
// "HTTPS Server" => "HTTPS Server",
// "Automatic (uses HTTPS variable)" => "Automatic (uses HTTPS variable)",
// "Allow anonymous users to \"Contact Us\"" => "Allow anonymous users to \"Contact Us\"",
// "Store session data in database" => "Store session data in database",
// "Session lifetime in minutes" => "Session lifetime in minutes",
// "Use proxy" => "Use proxy",
// "Proxy Host" => "Proxy Host",
// "Proxy port" => "Proxy port",
// "Help URL" => "Help URL",
// "Please expect not found help-pages with the default-URL." => "Please expect not found help-pages with the default-URL.",
// "Any help with the documentation is welcome." => "Any help with the documentation is welcome.",
// "Favicon icon file name:" => "Favicon icon file name:",
// "Favicon icon MIME type:" => "Favicon icon MIME type:",
// "image/png" => "image/png",
// "image/bmp" => "image/bmp",
// "image/x-icon" => "image/x-icon",
// "Locations separator" => "Locations separator",
// "Register this site at tikiwiki.org" => "Register this site at tikiwiki.org",
// "Click here for more details." => "Click here for more details.",
// "Google Map setup" => "Google Map setup",
// "You need to request a Google Maps Key for this web site. You can easily generate a key for your domain at :" => "You need to request a Google Maps Key for this web site. You can easily generate a key for your domain at :",
// "Google Map Key" => "Google Map Key",
// "Default x for map center" => "Default x for map center",
// "Default y from map center" => "Default y from map center",
// "Default zoom level" => "Default zoom level",
// "whole earth" => "whole earth",
// "country size" => "country size",
// "city size" => "city size",
// "max zoom" => "max zoom",
// "Internationalization" => "Internationalization",
// "I18n setup" => "I18n setup",
// "Best Language" => "Best Language",
// "Restrict available languages" => "Restrict available languages",
// "Available languages:" => "Available languages:",
// "Intertiki exchange feature" => "Intertiki exchange feature",
// "Tiki preferences value field in db is set to be max. 250 characters long by default until now. That applies for the custom code content too. Check this field if you want to update your preferences database table to support more than 250 chars (although it was tested and works fine with mysql, it's recommended to backup your data manually before any database update)" => "Tiki preferences value field in db is set to be max. 250 characters long by default until now. That applies for the custom code content too. Check this field if you want to update your preferences database table to support more than 250 chars (although it was tested and works fine with mysql, it's recommended to backup your data manually before any database update)",
// "Intertiki client" => "Intertiki client",
// "Tiki Unique key" => "Tiki Unique key",
// "InterTiki Slave mode" => "InterTiki Slave mode",
// "Warning: overrides manually registered local users" => "Warning: overrides manually registered local users",
// " as master" => " as master",
// "Import user preferences" => "Import user preferences",
// "Import user groups" => "Import user groups",
// "Limit group import (comma-separated list of imported groups, leave empty to avoid limitation)" => "Limit group import (comma-separated list of imported groups, leave empty to avoid limitation)",
// "InterTiki Server" => "InterTiki Server",
// "host" => "host",
// "Add new server" => "Add new server",
// "Intertiki server" => "Intertiki server",
// "Intertiki Server enabled" => "Intertiki Server enabled",
// "Access Log file" => "Access Log file",
// "Errors Log file" => "Errors Log file",
// "Known hosts" => "Known hosts",
// "Key" => "Key",
// "IP" => "IP",
// "New" => "New",
// "Enable/disable Tiki features in " => "Enable/disable Tiki features in ",
// "Admin->Features" => "Admin->Features",
// ", but configure them elsewhere" => ", but configure them elsewhere",
// "Users &amp; groups" => "Users &amp; groups",
// "Tiki and PAM" => "Tiki and PAM",
// "CAS (Central Authentication Service)" => "CAS (Central Authentication Service)",
// "... but need admin validation" => "... but need admin validation",
// "must be turned on and notification is sent to the admin's" => "must be turned on and notification is sent to the admin's",
// "inter-user message inbox" => "inter-user message inbox",
// "Create a group for each user <br />(with the same\nname as the user)" => "Create a group for each user <br />(with the same\nname as the user)",
// "Use tracker for more user information" => "Use tracker for more user information",
// "Use tracker for more group information" => "Use tracker for more group information",
// " - Php GD library required" => " - Php GD library required",
// "Validate email address (may not work)" => "Validate email address (may not work)",
// "Users can opt-out internal messages" => "Users can opt-out internal messages",
// "Users accept internal messages by default" => "Users accept internal messages by default",
// "Remind passwords by email (if \"Store plaintext passwords\" is activated.) Else, Reset passwords by email" => "Remind passwords by email (if \"Store plaintext passwords\" is activated.) Else, Reset passwords by email",
// "Reg users can change password" => "Reg users can change password",
// "Restrict available themes" => "Restrict available themes",
// "Available styles:" => "Available styles:",
// "Maximum mailbox size (messages, 0=unlimited)" => "Maximum mailbox size (messages, 0=unlimited)",
// "Maximum mail archive size (messages, 0=unlimited)" => "Maximum mail archive size (messages, 0=unlimited)",
// "Maximum sent box size (messages, 0=unlimited)" => "Maximum sent box size (messages, 0=unlimited)",
// "year" => "year",
// "Remember me name" => "Remember me name",
// "Remember me domain" => "Remember me domain",
// "Remember me path" => "Remember me path",
// "Protect against CSRF with a confirmation step" => "Protect against CSRF with a confirmation step",
// "Protect against CSRF with a ticket" => "Protect against CSRF with a ticket",
// "Highlight Group" => "Highlight Group",
// "choose a group ..." => "choose a group ...",
// "LDAP" => "LDAP",
// "Auth Type" => "Auth Type",
// "IMAP/POP3/LDAP Host" => "IMAP/POP3/LDAP Host",
// "IMAP/POP3/LDAP Port" => "IMAP/POP3/LDAP Port",
// "IMAP/POP3 BaseDSN" => "IMAP/POP3 BaseDSN",
// "LDAP URL<br />(if set, this will override the Host and Port below)" => "LDAP URL<br />(if set, this will override the Host and Port below)",
// "PAM" => "PAM",
// "PAM service" => "PAM service",
// "Currently unused" => "Currently unused",
// "You also need to upload the <a target=\"_blank\" href=\"http://esup-phpcas.sourceforge.net/\">phpCAS library</a> separately to lib/phpcas/." => "You also need to upload the <a target=\"_blank\" href=\"http://esup-phpcas.sourceforge.net/\">phpCAS library</a> separately to lib/phpcas/.",
// "CAS server version" => "CAS server version",
// "Version 1.0" => "Version 1.0",
// "Version 2.0" => "Version 2.0",
// "CAS server hostname" => "CAS server hostname",
// "CAS server port" => "CAS server port",
// "CAS server path" => "CAS server path",
// "Change CAS preferences" => "Change CAS preferences",
// "full path to mapfiles" => "full path to mapfiles",
// "default mapfile" => "default mapfile",
// "Wiki Page for Help" => "Wiki Page for Help",
// "Wiki Page for Comments" => "Wiki Page for Comments",
// "Full path to gdaltindex" => "Full path to gdaltindex",
// "Full path to ogr2ogr" => "Full path to ogr2ogr",
// "Map Zone" => "Map Zone",
// "Generate User Map" => "Generate User Map",
// "<b>Item</b>" => "<b>Item</b>",
// "<b>Value</b>" => "<b>Value</b>",
// "Meta Keywords" => "Meta Keywords",
// "Meta Description" => "Meta Description",
// "Meta Author" => "Meta Author",
// "Geourl" => "Geourl",
// "geo.position" => "geo.position",
// "geo.region" => "geo.region",
// "geo.placename" => "geo.placename",
// "Robots" => "Robots",
// "meta robots" => "meta robots",
// "revisit after" => "revisit after",
// "To add/remove polls, look for \"Polls\" under \"Admin\" on the application menu, or" => "To add/remove polls, look for \"Polls\" under \"Admin\" on the application menu, or",
// "Allow Anonymous Poll Voting" => "Allow Anonymous Poll Voting",
// "This page is to configure settings of RSS feeds generated/exported by Tiki. To read/import RSS feeds, look for \"RSS modules\" on the application menu, or" => "This page is to configure settings of RSS feeds generated/exported by Tiki. To read/import RSS feeds, look for \"RSS modules\" on the application menu, or",
// "Feed for mapfiles" => "Feed for mapfiles",
// "Feed for directories" => "Feed for directories",
// "Feed for individual tracker items" => "Feed for individual tracker items",
// "Feed for tracker items" => "Feed for tracker items",
// "Feed for upcoming calendar events" => "Feed for upcoming calendar events",
// "Default RDF version" => "Default RDF version",
// "Specification" => "Specification",
// "Documentation" => "Documentation",
// "Editor" => "Editor",
// "Webmaster" => "Webmaster",
// "Caching time :" => "Caching time :",
// "seconds (0 = cache inactive)" => "seconds (0 = cache inactive)",
// "Only enable caching if all syndicated content is public (visible to everyone) or private documents might leak out. Cache ignores existing permissions." => "Only enable caching if all syndicated content is public (visible to everyone) or private documents might leak out. Cache ignores existing permissions.",
// "You can see users rank by score in the module users_rank, for that go to" => "You can see users rank by score in the module users_rank, for that go to",
// "Admin modules" => "Admin modules",
// "Expiration" => "Expiration",
// "Search features" => "Search features",
// "Referer Search Highlighting" => "Referer Search Highlighting",
// "Refresh wiki search index now" => "Refresh wiki search index now",
// "Performance issues" => "Performance issues",
// "Search may show forbidden results. Much better performance though." => "Search may show forbidden results. Much better performance though.",
// "Ignore individual object permissions" => "Ignore individual object permissions",
// "Ignore category viewing restrictions" => "Ignore category viewing restrictions",
// "Settings for searching content" => "Settings for searching content",
// "Search refresh rate" => "Search refresh rate",
// "Minimum length of search word" => "Minimum length of search word",
// "Max. number of words containing a syllable" => "Max. number of words containing a syllable",
// "Max. age in hours of syllable search cache" => "Max. age in hours of syllable search cache",
// "LRU list purging rate" => "LRU list purging rate",
// "LRU list length" => "LRU list length",
// "Don't forget: to use feature you will need to enable it on" => "Don't forget: to use feature you will need to enable it on",
// "Custom Code" => "Custom Code",
// "Custom code" => "Custom code",
// "Site Breadcrumbs" => "Site Breadcrumbs",
// "Site breadcrumbs" => "Site breadcrumbs",
// "Site location bar" => "Site location bar",
// "at top of page" => "at top of page",
// "at top of center column" => "at top of center column",
// "Prefix breadcrumbs with 'Location:' label?" => "Prefix breadcrumbs with 'Location:' label?",
// "Larger font for" => "Larger font for",
// "entire location" => "entire location",
// "page name" => "page name",
// "Use page description:" => "Use page description:",
// "Site Search" => "Site Search",
// "Site search bar" => "Site search bar",
// "Site Logo" => "Site Logo",
// "Site logo" => "Site logo",
// "Site logo source" => "Site logo source",
// "Site logo background color" => "Site logo background color",
// "Site logo title (on mouse over)" => "Site logo title (on mouse over)",
// "Alt. description (e.g. for text browsers)" => "Alt. description (e.g. for text browsers)",
// "Site Ads and Banners" => "Site Ads and Banners",
// "Site ads and banners" => "Site ads and banners",
// "Site Menu" => "Site Menu",
// "Site menu bar" => "Site menu bar",
// "Note: This feature also requires phplayers to be turned on in Admin->Features" => "Note: This feature also requires phplayers to be turned on in Admin->Features",
// "To configure your trackers, look for \"Admin trackers\" under \"Trackers\" on the application menu, or" => "To configure your trackers, look for \"Admin trackers\" under \"Trackers\" on the application menu, or",
// "Trackers attachments preferences" => "Trackers attachments preferences",
// "Trackers with mirror tables" => "Trackers with mirror tables",
// "Use trackers with mirror tables" => "Use trackers with mirror tables",
// "Values are stored in a dedicated table for each tracker, then you can easily manipulate them outside TikiWiki" => "Values are stored in a dedicated table for each tracker, then you can easily manipulate them outside TikiWiki",
// "WARNING : Old and New trackers cannot coexist. Trackers created with new library\nwill not work with old library and conversely" => "WARNING : Old and New trackers cannot coexist. Trackers created with new library\nwill not work with old library and conversely",
// "Validate choice" => "Validate choice",
// "Trackers attachments" => "Trackers attachments",
// "Storage" => "Storage",
// "Change all to db" => "Change all to db",
// "Change all to file" => "Change all to file",
// "Unlimited" => "Unlimited",
// "To add/edit wiki pages easily, add the module quick_edit via \"Modules\" on the application menu, or" => "To add/edit wiki pages easily, add the module quick_edit via \"Modules\" on the application menu, or",
// "Create a Tag for the Current Wiki" => "Create a Tag for the Current Wiki",
// "Tag name" => "Tag name",
// "Restore the Wiki" => "Restore the Wiki",
// "Remove a Tag" => "Remove a Tag",
// "Wiki Comments Settings" => "Wiki Comments Settings",
// "Wiki Administration" => "Wiki Administration",
// "Manage attachment preferences" => "Manage attachment preferences",
// "complete" => "complete",
// "latin" => "latin",
// "english" => "english",
// "Wiki Page List Configuration" => "Wiki Page List Configuration",
// "Wiki 3D Browser Configuration" => "Wiki 3D Browser Configuration",
// "Enable wiki 3D browser" => "Enable wiki 3D browser",
// "Browser width" => "Browser width",
// "Browser height" => "Browser height",
// "Navigation depth" => "Navigation depth",
// "Feed animation interval (milisecs)" => "Feed animation interval (milisecs)",
// "Existing page node color" => "Existing page node color",
// "Missing page node color" => "Missing page node color",
// "Load page on navigation" => "Load page on navigation",
// "Camera distance" => "Camera distance",
// "Camera distance adjusted relative to nearest node" => "Camera distance adjusted relative to nearest node",
// "Field of view" => "Field of view",
// "Node size" => "Node size",
// "Text size" => "Text size",
// "Friction constant" => "Friction constant",
// "Elastic constant" => "Elastic constant",
// "Eletrostatic constant" => "Eletrostatic constant",
// "Spring (connection) size" => "Spring (connection) size",
// "Node mass" => "Node mass",
// "Node charge" => "Node charge",
// "HTML in Wiki Pages" => "HTML in Wiki Pages",
// "Wiki syntax used when a page contains HTML" => "Wiki syntax used when a page contains HTML",
// "full" => "full",
// "partial" => "partial",
// "Wysiwyg editor" => "Wysiwyg editor",
// "default" => "default",
// "optional" => "optional",
// "Anonymous editors must input anti-bot code" => "Anonymous editors must input anti-bot code",
// "Similar" => "Similar",
// "Warn on edit conflict" => "Warn on edit conflict",
// "Edit idle timeout" => "Edit idle timeout",
// "Show page ID" => "Show page ID",
// "Footnotes" => "Footnotes",
// "Accept dashes and underscores in WikiWords" => "Accept dashes and underscores in WikiWords",
// "Use Wiki paragraph formatting" => "Use Wiki paragraph formatting",
// "Open page as structure" => "Open page as structure",
// "Use external link icons" => "Use external link icons",
// "User's Page" => "User's Page",
// "UserPage prefix" => "UserPage prefix",
// "List authors" => "List authors",
// "as Creator &amp; Last Editor" => "as Creator &amp; Last Editor",
// "Business style" => "Business style",
// "Collaborative style" => "Collaborative style",
// "no (disabled)" => "no (disabled)",
// "Print Page" => "Print Page",
// "Search and replace" => "Search and replace",
// "unlimited" => "unlimited",
// "IP not displayed in history" => "IP not displayed in history",
// "Diff style" => "Diff style",
// "Only with last version" => "Only with last version",
// "Any 2 versions" => "Any 2 versions",
// "Wiki attachments preferences" => "Wiki attachments preferences",
// "Crosslinks to other features and settings" => "Crosslinks to other features and settings",
// "Other sections" => "Other sections",
// "Spreadsheet" => "Spreadsheet",
// "Administration features" => "Administration features",
// "Security" => "Security",
// "System" => "System",
// "SysLogs" => "SysLogs",
// "Mods" => "Mods",
// "Transversal features" => "Transversal features",
// "which apply to more than one section" => "which apply to more than one section",
// "Navigation features" => "Navigation features",
// "Look &amp; feel" => "Look &amp; feel",
// "themes" => "themes",
// "Text area features" => "Text area features",
// "features you can use in all text areas, like wiki pages, blogs, articles, forums, etc" => "features you can use in all text areas, like wiki pages, blogs, articles, forums, etc",
// "Stats &amp; banners" => "Stats &amp; banners",
// "Help on Banning System" => "Help on Banning System",
// "admin banning tpl" => "admin banning tpl",
// "Configure/Options" => "Configure/Options",
// "participants" => "participants",
// "subscription" => "subscription",
// "perso" => "perso",
// "Custom Participants" => "Custom Participants",
// "Custom Subscription List" => "Custom Subscription List",
// "Personal Calendar" => "Personal Calendar",
// "admin categories" => "admin categories",
// "admin categories tpl" => "admin categories tpl",
// "browse the category system" => "browse the category system",
// "Perms inherited from closest parent if possible or from global perms" => "Perms inherited from closest parent if possible or from global perms",
// "Assign permissions automatically" => "Assign permissions automatically",
// "recommended for best performance" => "recommended for best performance",
// "Edit permissions for this category" => "Edit permissions for this category",
// "View template" => "View template",
// "admin charts template" => "admin charts template",
// "Users can vote for only one item from this chart per period" => "Users can vote for only one item from this chart per period",
// "Prevent users from voting for the same item more than once" => "Prevent users from voting for the same item more than once",
// "Chat Admin" => "Chat Admin",
// "Chat Admin tpl" => "Chat Admin tpl",
// "Half a second" => "Half a second",
// "admin content templates" => "admin content templates",
// "admin content templates template" => "admin content templates template",
// "use in events" => "use in events",
// "admin FortuneCookie tpl" => "admin FortuneCookie tpl",
// "To use cookie in a text area (Wiki page, etc), a <a class=\"rbox-link\" href=\"tiki-admin_modules.php\">module</a> or a template, use {literal}{cookie}{/literal}." => "To use cookie in a text area (Wiki page, etc), a <a class=\"rbox-link\" href=\"tiki-admin_modules.php\">module</a> or a template, use {literal}{cookie}{/literal}.",
// "Help on Drawings" => "Help on Drawings",
// "admin Drawings tpl" => "admin Drawings tpl",
// "To create a drawing in a Wiki page, use {literal}{draw name=foo}{/literal}, where foo is the name of the drawing. After saving, click on the drawing link." => "To create a drawing in a Wiki page, use {literal}{draw name=foo}{/literal}, where foo is the name of the drawing. After saving, click on the drawing link.",
// "Admin DSN" => "Admin DSN",
// "tiki-admin_dsn tpl" => "tiki-admin_dsn tpl",
// "Use Admin DSN to define the database to be used by the SQL plugin." => "Use Admin DSN to define the database to be used by the SQL plugin.",
// "admin External Wikis" => "admin External Wikis",
// "tiki admin external wikis template" => "tiki admin external wikis template",
// "admin forums template" => "admin forums template",
// "Edit existing forums" => "Edit existing forums",
// "Posts can be rated" => "Posts can be rated",
// "Send mails even when the post is generated by inbound mail" => "Send mails even when the post is generated by inbound mail",
// "Append a reply link to outbound mails" => "Append a reply link to outbound mails",
// "Edit Existing Forums" => "Edit Existing Forums",
// "Assign Permissions (Active)" => "Assign Permissions (Active)",
// "admin hotwords" => "admin hotwords",
// "admin hotwords template" => "admin hotwords template",
// "admin HTML page dynamic zones" => "admin HTML page dynamic zones",
// "admin Html Pages" => "admin Html Pages",
// "admin Html Pages template" => "admin Html Pages template",
// "Use {literal}{/literal}ed id=name} or {literal}{/literal}ted id=name} to insert dynamic zones" => "Use {literal}{/literal}ed id=name} or {literal}{/literal}ted id=name} to insert dynamic zones",
// "An easier way to integrate content from another site into Tiki is via iframed links using Tiki's <a class=\"rbox-link\" href=\"tiki-admin_links.php\">featured links</a> feature." => "An easier way to integrate content from another site into Tiki is via iframed links using Tiki's <a class=\"rbox-link\" href=\"tiki-admin_links.php\">featured links</a> feature.",
// "Edit Repository:" => "Edit Repository:",
// "Create New Repository" => "Create New Repository",
// "list repositories" => "list repositories",
// "new repository" => "new repository",
// "view repository" => "view repository",
// "Human readable repository name" => "Human readable repository name",
// "Path to repository (local filesystem: relative/absolute web root, remote: prefixed with 'http://')" => "Path to repository (local filesystem: relative/absolute web root, remote: prefixed with 'http://')",
// "File name of start page" => "File name of start page",
// "Start page" => "Start page",
// "CSS file to load when browse this repository" => "CSS file to load when browse this repository",
// "CSS file" => "CSS file",
// "Is repository visible to users" => "Is repository visible to users",
// "Can files from repository be cached" => "Can files from repository be cached",
// "Cacheable" => "Cacheable",
// "Are files from repository can be cached" => "Are files from repository can be cached",
// "Clear all cached pages of this repository" => "Clear all cached pages of this repository",
// "Clear cache" => "Clear cache",
// "Seconds count 'till cached page will be expired" => "Seconds count 'till cached page will be expired",
// "Cache expiration" => "Cache expiration",
// "Human readable text description of repository" => "Human readable text description of repository",
// "Available Repositories" => "Available Repositories",
// "CSS File" => "CSS File",
// "Edit rules" => "Edit rules",
// "Edit Rules for Repository:" => "Edit Rules for Repository:",
// "configure repositories" => "configure repositories",
// "configure this repository" => "configure this repository",
// "view this repository" => "view this repository",
// "Add new rule" => "Add new rule",
// "new rule" => "new rule",
// "view/hide copy rules dialog" => "view/hide copy rules dialog",
// "copy rules" => "copy rules",
// "Source repository" => "Source repository",
// "Copy" => "Copy",
// "According this order rules will be applied ('0' or empty = auto)" => "According this order rules will be applied ('0' or empty = auto)",
// "Rule order" => "Rule order",
// "Text to search for" => "Text to search for",
// "Text to replace" => "Text to replace",
// "Replace" => "Replace",
// "Is this regular expression or simple search/replacer" => "Is this regular expression or simple search/replacer",
// "Regex" => "Regex",
// "Is case sensitive (for simple replacer)" => "Is case sensitive (for simple replacer)",
// "Case sensitive" => "Case sensitive",
// "subset of chars: imsxeADSXUu, which is regex modifiers" => "subset of chars: imsxeADSXUu, which is regex modifiers",
// "Regex modifiers" => "Regex modifiers",
// "Human readable text description of rule" => "Human readable text description of rule",
// "Check to enable this rule" => "Check to enable this rule",
// "Enabled" => "Enabled",
// "Preview options" => "Preview options",
// "Apply all rules or just this to generate preview" => "Apply all rules or just this to generate preview",
// "Apply all rules" => "Apply all rules",
// "View source code after rules applied" => "View source code after rules applied",
// "Code preview" => "Code preview",
// "Generate HTML preview" => "Generate HTML preview",
// "HTML preview" => "HTML preview",
// "Test file from repository to generate preview for (empty = configured start page)" => "Test file from repository to generate preview for (empty = configured start page)",
// "Preview Results" => "Preview Results",
// "Rules List" => "Rules List",
// "Case" => "Case",
// "admin featured links" => "admin featured links",
// "admin featured links template" => "admin featured links template",
// "To use these links, you must assign the featured_links <a class=\"rbox-link\" href=\"tiki-admin_modules.php\"> module</a>." => "To use these links, you must assign the featured_links <a class=\"rbox-link\" href=\"tiki-admin_modules.php\"> module</a>.",
// "Mail-in accounts" => "Mail-in accounts",
// "admin Webmail" => "admin Webmail",
// "admin mailin template" => "admin mailin template",
// "Account" => "Account",
// "Add new Mail-in account" => "Add new Mail-in account",
// "Edit Mail-in account" => "Edit Mail-in account",
// "article-put" => "article-put",
// "Article Topic" => "Article Topic",
// "Article Type" => "Article Type",
// "Allow anonymous acces" => "Allow anonymous acces",
// "Allow attachments" => "Allow attachments",
// "Discard to the end from" => "Discard to the end from",
// "Check Mail-in accounts" => "Check Mail-in accounts",
// "Check automatically" => "Check automatically",
// "Frequency" => "Frequency",
// "mn" => "mn",
// "Show Quick Urls" => "Show Quick Urls",
// "Hide Quick Urls" => "Hide Quick Urls",
// "sorted section" => "sorted section",
// "separator" => "separator",
// "admin menu builder" => "admin menu builder",
// "admin menus template" => "admin menus template",
// "To use menus in a <a class=\"rbox-link\" href=\"tiki-admin_modules.php\">module</a>, <a class=\"rbox-link\" href=\"tiki-admin.php?page=siteid\">Site identity</a> or a template, use {literal}{menu id=x}{/literal}, where x is the ID of the menu. To use <a class=\"rbox-link\" target=\"tikihelp\" href=\"http://phplayersmenu.sourceforge.net/\">phplayersmenu</a>, you can use one of the three following syntaxes:" => "To use menus in a <a class=\"rbox-link\" href=\"tiki-admin_modules.php\">module</a>, <a class=\"rbox-link\" href=\"tiki-admin.php?page=siteid\">Site identity</a> or a template, use {literal}{menu id=x}{/literal}, where x is the ID of the menu. To use <a class=\"rbox-link\" target=\"tikihelp\" href=\"http://phplayersmenu.sourceforge.net/\">phplayersmenu</a>, you can use one of the three following syntaxes:",
// "This will work well (or not!) depending on your theme. To learn more about <a class=\"rbox-link\" target=\"tikihelp\" href=\"http://themes.tikiwiki.org\">themes</a>" => "This will work well (or not!) depending on your theme. To learn more about <a class=\"rbox-link\" target=\"tikihelp\" href=\"http://themes.tikiwiki.org\">themes</a>",
// "admin modules template" => "admin modules template",
// "Visibility" => "Visibility",
// "Displayed for the eligible users with no personal assigned modules" => "Displayed for the eligible users with no personal assigned modules",
// "Displayed now for all eligible users even with personal assigned modules" => "Displayed now for all eligible users even with personal assigned modules",
// "Displayed now, can't be unassigned" => "Displayed now, can't be unassigned",
// "Not displayed until a user chooses it" => "Not displayed until a user chooses it",
// "parameters" => "parameters",
// "Must be wiki parsed" => "Must be wiki parsed",
// "Random active poll" => "Random active poll",
// "Random current poll" => "Random current poll",
// "phpLayersMenus" => "phpLayersMenus",
// "use phplayermenu" => "use phplayermenu",
// "structure" => "structure",
// "Add email:" => "Add email:",
// "Add user:" => "Add user:",
// "Group users" => "Group users",
// "Group subscription also subscribes included groups" => "Group subscription also subscribes included groups",
// "Don't send confirmation mail" => "Don't send confirmation mail",
// "The user email will be refreshed at each newsletter sending" => "The user email will be refreshed at each newsletter sending",
// "Subscribe group" => "Subscribe group",
// "Included group, group users and emails will be refreshed at each newsletter sending" => "Included group, group users and emails will be refreshed at each newsletter sending",
// "admin newsletters template" => "admin newsletters template",
// "Users can subscribe/unsubscribe to this list" => "Users can subscribe/unsubscribe to this list",
// "Users can subscribe any email address" => "Users can subscribe any email address",
// "Add unsubscribe instructions to each newsletter" => "Add unsubscribe instructions to each newsletter",
// "Validate email addresses" => "Validate email addresses",
// "send newsletter" => "send newsletter",
// "archives" => "archives",
// "admin notifications template" => "admin notifications template",
// "Any wiki page is changed, even minor changes" => "Any wiki page is changed, even minor changes",
// "PHP error" => "PHP error",
// "No records found." => "No records found.",
// "admin polls template" => "admin polls template",
// "configure polls" => "configure polls",
// "tiki admin quicktags template" => "tiki admin quicktags template",
// "label" => "label",
// "Insert (use 'text' for figuring the selection)" => "Insert (use 'text' for figuring the selection)",
// "Path to the tag icon" => "Path to the tag icon",
// "Insert" => "Insert",
// "Icon" => "Icon",
// "admin RSS modules" => "admin RSS modules",
// "admin RSSmodules template" => "admin RSSmodules template",
// "This page is to configure settings of RSS feeds read/imported by Tiki. To generate/export RSS feeds, look for \"RSS feeds\" on the admin panel, or" => "This page is to configure settings of RSS feeds read/imported by Tiki. To generate/export RSS feeds, look for \"RSS feeds\" on the admin panel, or",
// "To use RSS feeds in a text area (Wiki page, etc), a <a class=\"rbox-link\" href=\"tiki-admin_modules.php\">module</a> or a template, use {literal}{rss id=x}{/literal}, where x is the ID of the RSS feed." => "To use RSS feeds in a text area (Wiki page, etc), a <a class=\"rbox-link\" href=\"tiki-admin_modules.php\">module</a> or a template, use {literal}{rss id=x}{/literal}, where x is the ID of the RSS feed.",
// "show feed title" => "show feed title",
// "show publish date" => "show publish date",
// "show pubdate" => "show pubdate",
// "Score System" => "Score System",
// "security admin" => "security admin",
// "security admin tpl" => "security admin tpl",
// "edit tpl" => "edit tpl",
// "To <a class=\"rbox-link\" target=\"tikihelp\" href=\"http://security.tikiwiki.org/tiki-contact.php\">report any security issues</a>." => "To <a class=\"rbox-link\" target=\"tikihelp\" href=\"http://security.tikiwiki.org/tiki-contact.php\">report any security issues</a>.",
// "PHP settings" => "PHP settings",
// "PHP variable" => "PHP variable",
// "Setting" => "Setting",
// "Risk Factor" => "Risk Factor",
// "Explanation" => "Explanation",
// "TikiWiki settings" => "TikiWiki settings",
// "Tiki variable" => "Tiki variable",
// "Check all tiki files" => "Check all tiki files",
// "Note, that this can take a very long time. You should check your max_execution_time setting in php.ini." => "Note, that this can take a very long time. You should check your max_execution_time setting in php.ini.",
// "Note: You have to import security data via installation process (<a href=\"tiki-install.php\">tiki-install.php</a>). Import the *secdb* update files in your database." => "Note: You have to import security data via installation process (<a href=\"tiki-install.php\">tiki-install.php</a>). Import the *secdb* update files in your database.",
// "File checks" => "File checks",
// "State" => "State",
// "Admin Shoutbox Words" => "Admin Shoutbox Words",
// "admin shoutbox words" => "admin shoutbox words",
// "admin shoutbox words template" => "admin shoutbox words template",
// "Add Banned Word" => "Add Banned Word",
// "Are you sure you want to delete this word?" => "Are you sure you want to delete this word?",
// "admin structures template" => "admin structures template",
// "create webhelp" => "create webhelp",
// "view webhelp" => "view webhelp",
// "For a multiple answer question put the answers into the following field, separated by a comma. Example: one,two,many,lots" => "For a multiple answer question put the answers into the following field, separated by a comma. Example: one,two,many,lots",
// "administer surveys template" => "administer surveys template",
// "Create New Survey" => "Create New Survey",
// "active perms" => "active perms",
// "If your Tiki is acting weird, 1st thing to try it to clear your cache below. Also very important to clear your cache after an upgrade (by FTP/SSH if need be)." => "If your Tiki is acting weird, 1st thing to try it to clear your cache below. Also very important to clear your cache after an upgrade (by FTP/SSH if need be).",
// "Empty" => "Empty",
// "Templates compiler" => "Templates compiler",
// "Compile" => "Compile",
// "Fix UTF-8 Errors in Tables" => "Fix UTF-8 Errors in Tables",
// "Warning: Make a backup of your Database before using this function!" => "Warning: Make a backup of your Database before using this function!",
// "Warning: If you try to convert large tables, raise the maximum execution time in your php.ini!" => "Warning: If you try to convert large tables, raise the maximum execution time in your php.ini!",
// "This function converts ISO-8859-1 encoded strings in your tables to UTF-8" => "This function converts ISO-8859-1 encoded strings in your tables to UTF-8",
// "This may be necessary if you created content with tiki &lt; 1.8.4 and Default Charset settings in apache set to ISO-8859-1" => "This may be necessary if you created content with tiki &lt; 1.8.4 and Default Charset settings in apache set to ISO-8859-1",
// "UTF-8 Errors fixed" => "UTF-8 Errors fixed",
// "Table" => "Table",
// "Field" => "Field",
// "Investigate" => "Investigate",
// "Fix it" => "Fix it",
// "admin topics template" => "admin topics template",
// "Remove with articles" => "Remove with articles",
// "Column is searchable?" => "Column is searchable?",
// "Field is public? (for use thru trackerlist plugin)" => "Field is public? (for use thru trackerlist plugin)",
// "Field is hidden?" => "Field is hidden?",
// "not hidden" => "not hidden",
// "visible by admin only" => "visible by admin only",
// "editable by admin only" => "editable by admin only",
// "Field is mandatory?" => "Field is mandatory?",
// "Searchable" => "Searchable",
// "Public" => "Public",
// "Hidden" => "Hidden",
// "Mandatory" => "Mandatory",
// "Import/export trackers fields" => "Import/export trackers fields",
// "admin Trackers tpl" => "admin Trackers tpl",
// "Edit fields for tracker" => "Edit fields for tracker",
// "Edit tracker" => "Edit tracker",
// "Create trackers" => "Create trackers",
// "Import/export" => "Import/export",
// "active permissions" => "active permissions",
// "Use \"explicit\" names in the mirror table" => "Use \"explicit\" names in the mirror table",
// "tracker name must be unique, field names must be unique \nfor a tracker and they must be valid in SQL" => "tracker name must be unique, field names must be unique \nfor a tracker and they must be valid in SQL",
// "Show status" => "Show status",
// "Default status displayed in list mode" => "Default status displayed in list mode",
// "Show status to tracker admin only" => "Show status to tracker admin only",
// "Send copies of all activity in this tracker to this e-mail address" => "Send copies of all activity in this tracker to this e-mail address",
// "Use simplified e-mail format" => "Use simplified e-mail format",
// "The tracker needs a text field named Subject" => "The tracker needs a text field named Subject",
// "New items are created with status" => "New items are created with status",
// "Authoritative status for modified items" => "Authoritative status for modified items",
// "No change" => "No change",
// "Item creator can modify his items?" => "Item creator can modify his items?",
// "The tracker needs a user field with the option 1" => "The tracker needs a user field with the option 1",
// "Member of the default group of creator can modify items?" => "Member of the default group of creator can modify items?",
// "The tracker needs a group field with the option 1" => "The tracker needs a group field with the option 1",
// "What field is used for default sort?" => "What field is used for default sort?",
// "What is default sort order in list?" => "What is default sort order in list?",
// "ascending" => "ascending",
// "descending" => "descending",
// "Tracker items allow ratings?" => "Tracker items allow ratings?",
// "with values" => "with values",
// "and display rating results in listing?" => "and display rating results in listing?",
// "and display comments in listing?" => "and display comments in listing?",
// "and display attachments in listing?" => "and display attachments in listing?",
// "Attachment display options (Use numbers to order items, 0 will not be displayed, and negative values display in popups)" => "Attachment display options (Use numbers to order items, 0 will not be displayed, and negative values display in popups)",
// "filename" => "filename",
// "filesize" => "filesize",
// "filetype" => "filetype",
// "longdesc" => "longdesc",
// "Import/export trackers" => "Import/export trackers",
// "Import/Export CSV Data" => "Import/Export CSV Data",
// "Download CSV export" => "Download CSV export",
// "tracker_{\$trackerId}.csv" => "tracker_{\$trackerId}.csv",
// "Import file" => "Import file",
// "admin groups" => "admin groups",
// "admin groups template" => "admin groups template",
// "Add new group" => "Add new group",
// "Edit group" => "Edit group",
// "Members" => "Members",
// "Add a new group" => "Add a new group",
// "assign permissions" => "assign permissions",
// "Group Homepage" => "Group Homepage",
// "Use wiki page name or full URL" => "Use wiki page name or full URL",
// "Group Information Tracker" => "Group Information Tracker",
// "choose a group tracker ..." => "choose a group tracker ...",
// "choose a field ..." => "choose a field ...",
// "Users Information Tracker" => "Users Information Tracker",
// "choose a users tracker ..." => "choose a users tracker ...",
// "Group tracker item : {\$groupitemid}" => "Group tracker item : {\$groupitemid}",
// "Group tracker item not found" => "Group tracker item not found",
// "Create item" => "Create item",
// "Members List" => "Members List",
// "remove from group" => "remove from group",
// "users in group" => "users in group",
// "List all members" => "List all members",
// "admin users" => "admin users",
// "admin users template" => "admin users template",
// "Warning: since this tiki site is in slave mode, all user information you enter manually will be automatically overriden by other site's data, including users permissions" => "Warning: since this tiki site is in slave mode, all user information you enter manually will be automatically overriden by other site's data, including users permissions",
// "Edit user" => "Edit user",
// "Change user preferences" => "Change user preferences",
// "edit account settings" => "edit account settings",
// "edit included group" => "edit included group",
// "select all" => "select all",
// "Perform action with checked:" => "Perform action with checked:",
// "remove users and their userpages" => "remove users and their userpages",
// "manage group assignments" => "manage group assignments",
// "set default groups" => "set default groups",
// "Assign selected to" => "Assign selected to",
// "Remove selected from" => "Remove selected from",
// "the following groups:" => "the following groups:",
// "Tip: hold down CTRL to select multiple" => "Tip: hold down CTRL to select multiple",
// "Set the default group of the selected users to" => "Set the default group of the selected users to",
// "assign to groups" => "assign to groups",
// "Warning: changing the username will require the user to change his password and will mess with slave intertiki sites that use this one as master" => "Warning: changing the username will require the user to change his password and will mess with slave intertiki sites that use this one as master",
// "Warning: changing the username will require the user to change his password" => "Warning: changing the username will require the user to change his password",
// "Registration" => "Registration",
// "Batch upload (CSV file<a {popup text='login,password,email,groups<br />user1,password1,email1,&quot;group1,group2&quot;<br />user2, password2,email2'}><img src=\"img/icons/help.gif\" border=\"0\" height=\"16\" width=\"16\" alt='{tr}help" => "Batch upload (CSV file<a {popup text='login,password,email,groups<br />user1,password1,email1,&quot;group1,group2&quot;<br />user2, password2,email2'}><img src=\"img/icons/help.gif\" border=\"0\" height=\"16\" width=\"16\" alt='{tr}help",
// "User tracker item : {\$usersitemid}" => "User tracker item : {\$usersitemid}",
// "Shows up in the drop down list of article types" => "Shows up in the drop down list of article types",
// "Allow ratings by the author" => "Allow ratings by the author",
// "non-admins can view before the publish date" => "non-admins can view before the publish date",
// "non-admins can view after the expire date" => "non-admins can view after the expire date",
// "No article body, heading only" => "No article body, heading only",
// "Allow comments for this type" => "Allow comments for this type",
// "Allow comments to include a rating value" => "Allow comments to include a rating value",
// "Show topic or own image" => "Show topic or own image",
// "Show author's avatar" => "Show author's avatar",
// "Show author name" => "Show author name",
// "Show the number of times the article was read" => "Show the number of times the article was read",
// "Show the size of the article" => "Show the size of the article",
// "Show topline" => "Show topline",
// "Show a small title over the title" => "Show a small title over the title",
// "Show subtitle" => "Show subtitle",
// "Show the subtitle" => "Show the subtitle",
// "Show source" => "Show source",
// "Show link to source after article body" => "Show link to source after article body",
// "Show Image Caption" => "Show Image Caption",
// "Show a legend under the image" => "Show a legend under the image",
// "Show Language" => "Show Language",
// "Show the language" => "Show the language",
// "The person who submits an article of this type can edit it" => "The person who submits an article of this type can edit it",
// "Delete this type" => "Delete this type",
// "Show lang" => "Show lang",
// "Review" => "Review",
// "Classified" => "Classified",
// "edit article tpl" => "edit article tpl",
// "advanced feature" => "advanced feature",
// "level configuration" => "level configuration",
// "inherited from" => "inherited from",
// "inherited" => "inherited",
// "Available groups" => "Available groups",
// "assign perms to this group" => "assign perms to this group",
// "Use of this feature is NOT recommended. Please use phpMyAdmin or mysqldump instead." => "Use of this feature is NOT recommended. Please use phpMyAdmin or mysqldump instead.",
// "Your image gallery storage is set to \"{\$gal_use_dir}\", you will need to backup this using FTP or SCP." => "Your image gallery storage is set to \"{\$gal_use_dir}\", you will need to backup this using FTP or SCP.",
// "Your file gallery storage is set to \"{\$fgal_use_dir}\", you will need to backup this using FTP or SCP." => "Your file gallery storage is set to \"{\$fgal_use_dir}\", you will need to backup this using FTP or SCP.",
// "If any of your forums have attachments stored in the directory you will need to backup these using FTP or SCP." => "If any of your forums have attachments stored in the directory you will need to backup these using FTP or SCP.",
// "Directory batch upload" => "Directory batch upload",
// "available images" => "available images",
// "width" => "width",
// "height" => "height",
// "remove file extension from image name" => "remove file extension from image name",
// "eg. from \"digicam0001.jpg\" then name digicam0001 will be used for the name field" => "eg. from \"digicam0001.jpg\" then name digicam0001 will be used for the name field",
// "convert sub directories to sub galleries" => "convert sub directories to sub galleries",
// "eg. from \"misc/screenshots/digicam0001.jpg\" a gallery named screenshots will be created" => "eg. from \"misc/screenshots/digicam0001.jpg\" a gallery named screenshots will be created",
// "use sub directory names as description" => "use sub directory names as description",
// "eg. from \"misc/screenshots/digicam0001.jpg\" a description misc/screenshots will be created" => "eg. from \"misc/screenshots/digicam0001.jpg\" a description misc/screenshots will be created",
// "Select a Gallery" => "Select a Gallery",
// "Mark entry as private:" => "Mark entry as private:",
// "admin the category system" => "admin the category system",
// "admin category" => "admin category",
// "Browse in" => "Browse in",
// "Wiki pages" => "Wiki pages",
// "Trackers Items" => "Trackers Items",
// "Sheets" => "Sheets",
// "Hide subcategories objects" => "Hide subcategories objects",
// "Show subcategories objects" => "Show subcategories objects",
// "Upper level" => "Upper level",
// "list galleries" => "list galleries",
// "Directory batch" => "Directory batch",
// "subgallery" => "subgallery",
// "Subgallery" => "Subgallery",
// "hit" => "hit",
// "slideshow forward" => "slideshow forward",
// "Cyclic" => "Cyclic",
// "Direction" => "Direction",
// "Click to zoom" => "Click to zoom",
// "Latitude (WGS84/decimal degrees)" => "Latitude (WGS84/decimal degrees)",
// "Longitude (WGS84/decimal degrees)" => "Longitude (WGS84/decimal degrees)",
// "You can include the image in an HTML page using one of these lines" => "You can include the image in an HTML page using one of these lines",
// "You can include the image in a tiki page using one of these lines" => "You can include the image in a tiki page using one of these lines",
// "add item" => "add item",
// "Edit/Create" => "Edit/Create",
// "Focus:" => "Focus:",
// "change focus" => "change focus",
// "quarter" => "quarter",
// "semester" => "semester",
// "calendar view" => "calendar view",
// "list view" => "list view",
// "zoom" => "zoom",
// "Subscription List" => "Subscription List",
// "Syntax error" => "Syntax error",
// "Format: mm/dd/yyyy hh:mm<br />..." => "Format: mm/dd/yyyy hh:mm<br />...",
// "See strtotime php function" => "See strtotime php function",
// "Format: mm/dd/yyy hh:mm<br />..." => "Format: mm/dd/yyy hh:mm<br />...",
// "save_to" => "save_to",
// "close" => "close",
// "click to view" => "click to view",
// "Calendar import" => "Calendar import",
// "Calendar has been updated" => "Calendar has been updated",
// "CSV File" => "CSV File",
// "Assign permissions to category" => "Assign permissions to category",
// "Current permissions for this category" => "Current permissions for this category",
// "remove from this category &amp; all its children" => "remove from this category &amp; all its children",
// "remove from this category only" => "remove from this category only",
// "this category &amp; all its children" => "this category &amp; all its children",
// "this category only" => "this category only",
// "Assigning permissions for <b>all children</b> is recommended for best performance." => "Assigning permissions for <b>all children</b> is recommended for best performance.",
// "Automatic Page Breaks" => "Automatic Page Breaks",
// "click here to send us an email" => "click here to send us an email",
// "Create WebHelp" => "Create WebHelp",
// "Top page" => "Top page",
// "You cannot add sites until Directory Categories are setup." => "You cannot add sites until Directory Categories are setup.",
// "Please contact the Site Administrator" => "Please contact the Site Administrator",
// "Name:" => "Name:",
// "URL:" => "URL:",
// "Categories:" => "Categories:",
// "admin directory tpl" => "admin directory tpl",
// "admin directory categories tpl" => "admin directory categories tpl",
// "directory admin related tpl" => "directory admin related tpl",
// "Admin Directory Sites tpl" => "Admin Directory Sites tpl",
// "add a category" => "add a category",
// "directory validate sites tpl" => "directory validate sites tpl",
// "Topline" => "Topline",
// "Subtitle" => "Subtitle",
// "Source" => "Source",
// "pixels" => "pixels",
// "Image caption" => "Image caption",
// "Remove Zones (you lose entered info for the banner)" => "Remove Zones (you lose entered info for the banner)",
// "Create Blog" => "Create Blog",
// "Allow trackback pings" => "Allow trackback pings",
// "Show user avatar" => "Show user avatar",
// "For more information, please see <a href=\"{\$helpurl}WikiSyntax\">WikiSyntax</a>" => "For more information, please see <a href=\"{\$helpurl}WikiSyntax\">WikiSyntax</a>",
// "Bold text" => "Bold text",
// "underscores" => "underscores",
// "Italic text" => "Italic text",
// "single quotes" => "single quotes",
// "Centered text" => "Centered text",
// "colons" => "colons",
// "Underlined text" => "Underlined text",
// "equals" => "equals",
// "Text box" => "Text box",
// "One carat" => "One carat",
// "Will display using the indicated HTML color or color name" => "Will display using the indicated HTML color or color name",
// "Headings" => "Headings",
// "make headings" => "make headings",
// "Show/Hide" => "Show/Hide",
// "show/hide heading section. + (shown) or - (hidden) by default" => "show/hide heading section. + (shown) or - (hidden) by default",
// "use square brackets for an external link: [URL] or [URL|link_description] or [URL|description|nocache]  (that last form prevents the local Wiki from caching the page; please use that form for large pages!)." => "use square brackets for an external link: [URL] or [URL|link_description] or [URL|description|nocache]  (that last form prevents the local Wiki from caching the page; please use that form for large pages!).",
// "For an external Wiki, use ExternalWikiName:PageName or ((External Wiki Name: Page Name))" => "For an external Wiki, use ExternalWikiName:PageName or ((External Wiki Name: Page Name))",
// "row" => "row",
// "col" => "col",
// "Line break" => "Line break",
// "(very useful especially in tables)" => "(very useful especially in tables)",
// "Horizontal rule" => "Horizontal rule",
// "to separate pages" => "to separate pages",
// "Wiki File Attachments" => "Wiki File Attachments",
// "Creates a link to the named file.  If page is not given, the file must be attached to the current page.  If desc is not given, the file name is used for the link text, unless showdesc is used, which makes the file description be used for the link text.  If image=1 is given, the attachment is treated as an image and is displayed directly on the page; no link is generated." => "Creates a link to the named file.  If page is not given, the file must be attached to the current page.  If desc is not given, the file name is used for the link text, unless showdesc is used, which makes the file description be used for the link text.  If image=1 is given, the attachment is treated as an image and is displayed directly on the page; no link is generated.",
// "Dynamic variables" => "Dynamic variables",
// "Inserts an editable variable" => "Inserts an editable variable",
// "Prevents wiki parsing of the enclosed data." => "Prevents wiki parsing of the enclosed data.",
// "Preformated sections" => "Preformated sections",
// "Displays preformated text/code; no Wiki processing is done inside these sections (as with np), and the spacing is fixed (no word wrapping is done)." => "Displays preformated text/code; no Wiki processing is done inside these sections (as with np), and the spacing is fixed (no word wrapping is done).",
// "Square Brackets" => "Square Brackets",
// "Use [[foo] to show [foo]." => "Use [[foo] to show [foo].",
// "Block Preformatting" => "Block Preformatting",
// "Indent text with any number of spaces to turn it into a monospaced block that still follows other Wiki formatting instructions. It will be indended with the same number of spaces that you used.  Note that this mode does not preserve exact spacing and line breaks; use ~pp~...~/pp~ for that." => "Indent text with any number of spaces to turn it into a monospaced block that still follows other Wiki formatting instructions. It will be indended with the same number of spaces that you used.  Note that this mode does not preserve exact spacing and line breaks; use ~pp~...~/pp~ for that.",
// "Table of contents" => "Table of contents",
// "\"{literal}{toc}{/literal}\", \"{literal}{maketoc}{/literal}\" prints out a table of contents for the current page based on structures (toc) or ! headings (maketoc)" => "\"{literal}{toc}{/literal}\", \"{literal}{maketoc}{/literal}\" prints out a table of contents for the current page based on structures (toc) or ! headings (maketoc)",
// "Quicktags" => "Quicktags",
// "italic" => "italic",
// "underline" => "underline",
// "table" => "table",
// "table new" => "table new",
// "wiki link'" => "wiki link'",
// "heading1" => "heading1",
// "title bar" => "title bar",
// "box" => "box",
// "rss feed" => "rss feed",
// "dynamic content" => "dynamic content",
// "tagline" => "tagline",
// "hr" => "hr",
// "center text" => "center text",
// "colored text" => "colored text",
// "dynamic variable" => "dynamic variable",
// "New wms Metadata" => "New wms Metadata",
// "New Class" => "New Class",
// "New Projection" => "New Projection",
// "New Query" => "New Query",
// "New Scalebar" => "New Scalebar",
// "New Layer" => "New Layer",
// "New Label" => "New Label",
// "New Reference" => "New Reference",
// "New Legend" => "New Legend",
// "New Web" => "New Web",
// "New Outputformat" => "New Outputformat",
// "New Mapfile" => "New Mapfile",
// "admin quicktags" => "admin quicktags",
// "browse image" => "browse image",
// "admin quizzes tpl" => "admin quizzes tpl",
// "Immediate feedback" => "Immediate feedback",
// "Show correct answers" => "Show correct answers",
// "Shuffle questions" => "Shuffle questions",
// "Shuffle answers" => "Shuffle answers",
// "Passing Percentage" => "Passing Percentage",
// "%" => "%",
// "edit quiz questions" => "edit quiz questions",
// "edit quiz questions tpl" => "edit quiz questions tpl",
// "Question Type" => "Question Type",
// "Import questions from text" => "Import questions from text",
// "Instructions: Type, or paste, your multiple choice questions below.  One line for the question, then start answer choices on subsequent lines.  Separate additional questions with a blank line.  Indicate correct answers by starting them with a \"*\" (without the quotes) character." => "Instructions: Type, or paste, your multiple choice questions below.  One line for the question, then start answer choices on subsequent lines.  Separate additional questions with a blank line.  Indicate correct answers by starting them with a \"*\" (without the quotes) character.",
// "Input" => "Input",
// "Help on Articles" => "Help on Articles",
// "edit submissions tpl" => "edit submissions tpl",
// "<b>*</b>=optional" => "<b>*</b>=optional",
// "<b>Topline</b>=small line above Title" => "<b>Topline</b>=small line above Title",
// "<b>Subtitle</b>=small line below Title" => "<b>Subtitle</b>=small line below Title",
// "<b>Source</b>=URL to article source" => "<b>Source</b>=URL to article source",
// "EditTemplates" => "EditTemplates",
// "EditTemplates tpl" => "EditTemplates tpl",
// "save only in the theme:" => "save only in the theme:",
// "Delete the copy in the theme:" => "Delete the copy in the theme:",
// "Edit a topic" => "Edit a topic",
// "Edit Translation:" => "Edit Translation:",
// "edit translations" => "edit translations",
// "edit translations template" => "edit translations template",
// "You must specify the object language" => "You must specify the object language",
// "The object doesn't exist" => "The object doesn't exist",
// "The object doesn't have a language" => "The object doesn't have a language",
// "The object has already a translation for this language" => "The object has already a translation for this language",
// "The object is already in the set of translations" => "The object is already in the set of translations",
// "Use this section to set the language of the version you are currently working on." => "Use this section to set the language of the version you are currently working on.",
// "Set of Translations" => "Set of Translations",
// "detach" => "detach",
// "add to the set" => "add to the set",
// "Select the article for which the current article is the translation." => "Select the article for which the current article is the translation.",
// "Translation of:" => "Translation of:",
// "Enter the name of the page for which the current page is the translation." => "Enter the name of the page for which the current page is the translation.",
// "Use rating" => "Use rating",
// "disable" => "disable",
// "There is no available poll template." => "There is no available poll template.",
// "You should ask an admin to create them." => "You should ask an admin to create them.",
// "an existing poll" => "an existing poll",
// "Search " => "Search ",
// "Case Insensitivity" => "Case Insensitivity",
// "replace" => "replace",
// "admin Ephemerides tpl" => "admin Ephemerides tpl",
// "File Galleries tpl" => "File Galleries tpl",
// "configure forum" => "configure forum",
// "friends tpl" => "friends tpl",
// "Pending requests" => "Pending requests",
// "Request Time" => "Request Time",
// "refuse" => "refuse",
// "Waiting requests" => "Waiting requests",
// "Your friends" => "Your friends",
// "break friendship" => "break friendship",
// "To learn more about the <a class=\"rbox-link\" target=\"tikihelp\" href=\"http://workflow.tikiwiki.org\">Galaxia workflow engine</a>" => "To learn more about the <a class=\"rbox-link\" target=\"tikihelp\" href=\"http://workflow.tikiwiki.org\">Galaxia workflow engine</a>",
// "Expiration Time" => "Expiration Time",
// "Years" => "Years",
// "Months" => "Months",
// "Days" => "Days",
// "Minutes" => "Minutes",
// "Process Graph" => "Process Graph",
// "Galaxia Admin Graph" => "Galaxia Admin Graph",
// "Galaxia Admin Graph tpl" => "Galaxia Admin Graph tpl",
// "Process Graph for" => "Process Graph for",
// "No process graph is available. Either the process still contains errors, the graph is not generated yet, or <a href=\"http://www.research.att.com/sw/tools/graphviz/\">GraphViz</a> is not properly installed." => "No process graph is available. Either the process still contains errors, the graph is not generated yet, or <a href=\"http://www.research.att.com/sw/tools/graphviz/\">GraphViz</a> is not properly installed.",
// "Ended" => "Ended",
// "Not Defined" => "Not Defined",
// "Not Interactive" => "Not Interactive",
// "Not Ended" => "Not Ended",
// "Executed" => "Executed",
// "Pop-up" => "Pop-up",
// "erase" => "erase",
// "Galaxia Admin Processes" => "Galaxia Admin Processes",
// "Galaxia Admin Processes tpl" => "Galaxia Admin Processes tpl",
// "Switch construct" => "Switch construct",
// "Galaxia Monitor Activities" => "Galaxia Monitor Activities",
// "Galaxia Monitor Activities tpl" => "Galaxia Monitor Activities tpl",
// "Enter the name of this instance" => "Enter the name of this instance",
// "The name is not valid. Please, enter the name again" => "The name is not valid. Please, enter the name again",
// "Galaxia Monitor Instances" => "Galaxia Monitor Instances",
// "Galaxia Monitor Instances tpl" => "Galaxia Monitor Instances tpl",
// "Not ended" => "Not ended",
// "Galaxia Monitor Processes" => "Galaxia Monitor Processes",
// "Galaxia Monitor Processes tpl" => "Galaxia Monitor Processes tpl",
// "Instance Id" => "Instance Id",
// "Instance Name" => "Instance Name",
// "Instance Status" => "Instance Status",
// "Elapsed time" => "Elapsed time",
// "My activities" => "My activities",
// "Current Activity" => "Current Activity",
// "Assigned To" => "Assigned To",
// "No activities found" => "No activities found",
// "My instances" => "My instances",
// "No instances found" => "No instances found",
// "Galaxia User Activities" => "Galaxia User Activities",
// "Galaxia User Activities tpl" => "Galaxia User Activities tpl",
// "No processes defined or activated yet" => "No processes defined or activated yet",
// "Galaxia User Instances" => "Galaxia User Instances",
// "Galaxia User Instances tpl" => "Galaxia User Instances tpl",
// "Not defined" => "Not defined",
// "Galaxia User Processes" => "Galaxia User Processes",
// "Galaxia User Processes tpl" => "Galaxia User Processes tpl",
// "galleries tpl" => "galleries tpl",
// "rebuild cache" => "rebuild cache",
// "Geographic" => "Geographic",
// "Default sort order" => "Default sort order",
// "Fields to show during browsing the gallery" => "Fields to show during browsing the gallery",
// "Image ID" => "Image ID",
// "Creation Date" => "Creation Date",
// "XY-Size" => "XY-Size",
// "Gallery Image" => "Gallery Image",
// "Parent gallery" => "Parent gallery",
// "Bounding box" => "Bounding box",
// "default scale" => "default scale",
// "Original image is default scale" => "Original image is default scale",
// "Add scaled images with bounding box of square size" => "Add scaled images with bounding box of square size",
// "Owner of the gallery" => "Owner of the gallery",
// "Choose a filter" => "Choose a filter",
// "Make Map" => "Make Map",
// "Save clicked point" => "Save clicked point",
// "Save current view as default" => "Save current view as default",
// "Reset view to site-wide default" => "Reset view to site-wide default",
// "Users Map" => "Users Map",
// "Select Graphic Type" => "Select Graphic Type",
// "Pie Chart" => "Pie Chart",
// "Multiline" => "Multiline",
// "Multibar" => "Multibar",
// "Bar Stack" => "Bar Stack",
// "Landscape" => "Landscape",
// "Portrait" => "Portrait",
// "Independant Scale" => "Independant Scale",
// "Horizontal" => "Horizontal",
// "Vertical" => "Vertical",
// "Horizontal Scale" => "Horizontal Scale",
// "Bottom" => "Bottom",
// "Vertical Scale" => "Vertical Scale",
// "Left" => "Left",
// "Right" => "Right",
// "Series" => "Series",
// "Import From File" => "Import From File",
// "Grab Wiki Tables" => "Grab Wiki Tables",
// "Import pages from a Structured Text Dump" => "Import pages from a Structured Text Dump",
// "ImportingPagesPhpWikiPageAdmin" => "ImportingPagesPhpWikiPageAdmin",
// "tiki-import_phpwiki tpl" => "tiki-import_phpwiki tpl",
// "Name of the dump file (it has to be in dump/)" => "Name of the dump file (it has to be in dump/)",
// "body" => "body",
// "Tiki installer" => "Tiki installer",
// "MultiTiki setup" => "MultiTiki setup",
// "To add a new virtual host" => "To add a new virtual host",
// "To add a new virtual host run the setup.sh with the domain name of the new host as a last parameter" => "To add a new virtual host run the setup.sh with the domain name of the new host as a last parameter",
// "MultiTiki" => "MultiTiki",
// "reload" => "reload",
// "Tiki cannot find a database connection" => "Tiki cannot find a database connection",
// "Please enter your database connection info" => "Please enter your database connection info",
// "Database type" => "Database type",
// "The type of database you intend to use" => "The type of database you intend to use",
// "Host:" => "Host:",
// "Hostname or IP for your MySQL database, example: localhost if running in the same machine as tiki" => "Hostname or IP for your MySQL database, example: localhost if running in the same machine as tiki",
// "If you use SQLite, insert the path and filename to your database file" => "If you use SQLite, insert the path and filename to your database file",
// "Database user" => "Database user",
// "Database password" => "Database password",
// "Database name" => "Database name",
// "The name of the database where tiki will create tables. You can create the database using mysqladmin, or PHPMyAdmin or ask your\nhosting service to create a MySQL database.  Normally Tiki tables won't conflict with other product names" => "The name of the database where tiki will create tables. You can create the database using mysqladmin, or PHPMyAdmin or ask your\nhosting service to create a MySQL database.  Normally Tiki tables won't conflict with other product names",
// "If you use Oracle, you can put your TNS Name here and leave hostname empty\nor you override tnsnames.ora and put your SID here and fill your hostname:port above" => "If you use Oracle, you can put your TNS Name here and leave hostname empty\nor you override tnsnames.ora and put your SID here and fill your hostname:port above",
// "Welcome to the installation &amp; upgrade script!" => "Welcome to the installation &amp; upgrade script!",
// "Install" => "Install",
// "Create database (clean install) with profile" => "Create database (clean install) with profile",
// "Descriptions of the available profiles" => "Descriptions of the available profiles",
// "Upgrade" => "Upgrade",
// "backup your database" => "backup your database",
// "with mysqldump or phpmyadmin before you proceed" => "with mysqldump or phpmyadmin before you proceed",
// "Update database using script" => "Update database using script",
// "For database update from 1.8 or later" => "For database update from 1.8 or later",
// "If you upgrade from 1.8.x you <b>MUST</b> run tiki_1.8to1.9 and don't need an additional script" => "If you upgrade from 1.8.x you <b>MUST</b> run tiki_1.8to1.9 and don't need an additional script",
// "If you upgrade from a previous 1.9.x version, use tiki_1.8to1.9, too. (ex.: 1.9.2 to 1.9.5)" => "If you upgrade from a previous 1.9.x version, use tiki_1.8to1.9, too. (ex.: 1.9.2 to 1.9.5)",
// "For database update from 1.7.x, please visit <a target=\"help\" href=\"http://tikiwiki.org/UpgradeTo18\">Tiki database 1.7.x to 1.8x instructions" => "For database update from 1.7.x, please visit <a target=\"help\" href=\"http://tikiwiki.org/UpgradeTo18\">Tiki database 1.7.x to 1.8x instructions",
// "For information about tiki-secdb_*.sql files, please see <a target=\"help\" href=\"http://tikiwiki.org/AdminSecurity\">http://tikiwiki.org/AdminSecurity" => "For information about tiki-secdb_*.sql files, please see <a target=\"help\" href=\"http://tikiwiki.org/AdminSecurity\">http://tikiwiki.org/AdminSecurity",
// "Do nothing and enter Tiki" => "Do nothing and enter Tiki",
// "Reset database connection settings" => "Reset database connection settings",
// "This site has an admin account configured" => "This site has an admin account configured",
// "Please enter your admin password to continue" => "Please enter your admin password to continue",
// "Print operations executed successfully" => "Print operations executed successfully",
// "Print operations failed" => "Print operations failed",
// "Your database has been configured and Tiki is ready to run, if\n    \t\tthis is your first install your admin password is 'admin'. You can\n    \t\tnow log in into Tiki as 'admin' - 'admin' and start configuring\n    \t\tthe application" => "Your database has been configured and Tiki is ready to run, if\n    \t\tthis is your first install your admin password is 'admin'. You can\n    \t\tnow log in into Tiki as 'admin' - 'admin' and start configuring\n    \t\tthe application",
// "Note: This install script may be potentially harmful so we strongly\n    \t\trecommend you to disable the script and then proceed into Tiki. If\n    \t\tyou decide to reuse later, just follow the instructions in\n\t\ttiki-install.php to restore" => "Note: This install script may be potentially harmful so we strongly\n    \t\trecommend you to disable the script and then proceed into Tiki. If\n    \t\tyou decide to reuse later, just follow the instructions in\n\t\ttiki-install.php to restore",
// "READ THE FOLLOWING NOTES BEFORE ENTERING TIKI USING THE LINKS BELOW!" => "READ THE FOLLOWING NOTES BEFORE ENTERING TIKI USING THE LINKS BELOW!",
// "Make sure tiki gets more than 8 MB of memory for script execution. \nSee file php.ini, the relevant key is memory_limit. Use something like memory_limit = 16M and restart your \nwebserver. Too little memory will cause blank pages!" => "Make sure tiki gets more than 8 MB of memory for script execution. \nSee file php.ini, the relevant key is memory_limit. Use something like memory_limit = 16M and restart your \nwebserver. Too little memory will cause blank pages!",
// "Tiki has not detected your PHP memory_limit. This probably means you have no set limit (all is well)" => "Tiki has not detected your PHP memory_limit. This probably means you have no set limit (all is well)",
// "Tiki has detected your PHP memory limit at only 8 Megs" => "Tiki has detected your PHP memory limit at only 8 Megs",
// "Tiki has detected your PHP memory_limit at" => "Tiki has detected your PHP memory_limit at",
// "Note" => "Note",
// "If this is a first time installation, go to tiki-admin.php after login to start configuring your new Tiki installation" => "If this is a first time installation, go to tiki-admin.php after login to start configuring your new Tiki installation",
// "If you did a Tiki upgrade, make sure to clean the caches (templates_c/) manually or by using the feature on admin / system" => "If you did a Tiki upgrade, make sure to clean the caches (templates_c/) manually or by using the feature on admin / system",
// "Now you may proceed by clicking one of these links" => "Now you may proceed by clicking one of these links",
// "Click here to disable the install script and proceed into tiki" => "Click here to disable the install script and proceed into tiki",
// "Click here to proceed into tiki without disabling the script" => "Click here to proceed into tiki without disabling the script",
// "Go back and run another install/upgrade script" => "Go back and run another install/upgrade script",
// "do not use your Back button in your browser!" => "do not use your Back button in your browser!",
// "Clear cached version and refresh cache" => "Clear cached version and refresh cache",
// "configure rules" => "configure rules",
// "edit repository" => "edit repository",
// "v" => "v",
// "list articles tpl" => "list articles tpl",
// "admin Banners" => "admin Banners",
// "admin Banners tpl" => "admin Banners tpl",
// "To use a banner in a <a class=\"rbox-link\" href=\"tiki-admin_modules.php\">module</a> or a template, use {literal}{banner zone=ABC}{/literal}, where ABC is the name of the zone." => "To use a banner in a <a class=\"rbox-link\" href=\"tiki-admin_modules.php\">module</a> or a template, use {literal}{banner zone=ABC}{/literal}, where ABC is the name of the zone.",
// "admin cache" => "admin cache",
// "admin cache tpl" => "admin cache tpl",
// "Help on Dynamic Content" => "Help on Dynamic Content",
// "admin DynamicContent tpl" => "admin DynamicContent tpl",
// "To use content blocks in a text area (Wiki page, etc), a <a class=\"rbox-link\" href=\"tiki-admin_modules.php\">module</a> or a template, use {literal}{content id=x}{/literal}, where x is the ID of the content block." => "To use content blocks in a text area (Wiki page, etc), a <a class=\"rbox-link\" href=\"tiki-admin_modules.php\">module</a> or a template, use {literal}{content id=x}{/literal}, where x is the ID of the content block.",
// "Future vers" => "Future vers",
// "monitor this gallery" => "monitor this gallery",
// "stop monitoring this gallery" => "stop monitoring this gallery",
// "games tpl" => "games tpl",
// "/" => "/",
// "list posts tpl" => "list posts tpl",
// "list quizzes tpl" => "list quizzes tpl",
// "edit quiz stats tpl" => "edit quiz stats tpl",
// "actions" => "actions",
// "take survey" => "take survey",
// "list trackers tpl" => "list trackers tpl",
// "users registered" => "users registered",
// "Distance (km)" => "Distance (km)",
// "List Movies" => "List Movies",
// "Choose a movie" => "Choose a movie",
// "admin live support tpl" => "admin live support tpl",
// "operator" => "operator",
// "Mail-in feature" => "Mail-in feature",
// "User Calendar" => "User Calendar",
// "User Calendar Doc tpl" => "User Calendar Doc tpl",
// "User Calendar Doc" => "User Calendar Doc",
// "User Calendar Preferences Doc tpl" => "User Calendar Preferences Doc tpl",
// "To learn more about <a class=\"rbox-link\" target=\"tikihelp\" href=\"http://mods.tikiwiki.org\">mods</a>." => "To learn more about <a class=\"rbox-link\" target=\"tikihelp\" href=\"http://mods.tikiwiki.org\">mods</a>.",
// "TikiWiki Mods" => "TikiWiki Mods",
// "Mods Configuration" => "Mods Configuration",
// "Update remote index" => "Update remote index",
// "Rebuild local list" => "Rebuild local list",
// "Republish all" => "Republish all",
// "Publish all" => "Publish all",
// "Unpublish all" => "Unpublish all",
// "Attention" => "Attention",
// "Apache has the right to write in your file tree, which enables the installation, removal or \nupgrade of packages. When you are done with those operations, think to fix those permissions back to a safe state (by using \n\"./fixperms.sh fix\" for example)." => "Apache has the right to write in your file tree, which enables the installation, removal or \nupgrade of packages. When you are done with those operations, think to fix those permissions back to a safe state (by using \n\"./fixperms.sh fix\" for example).",
// "To install, remove or upgrade packages you need to give the apache user the right\nto write files in your web tree (you can use \"./fixperms.sh open\" to set it up). After installation you need to remove that\npermission (using \"./fixperms.sh fix\")." => "To install, remove or upgrade packages you need to give the apache user the right\nto write files in your web tree (you can use \"./fixperms.sh open\" to set it up). After installation you need to remove that\npermission (using \"./fixperms.sh fix\").",
// "all types" => "all types",
// "Display only this type" => "Display only this type",
// "Unpublish" => "Unpublish",
// "Republish" => "Republish",
// "install" => "install",
// "TikiWiki Mods Configuration" => "TikiWiki Mods Configuration",
// "Enable Mods providing" => "Enable Mods providing",
// "Mods local directory" => "Mods local directory",
// "Mods remote server" => "Mods remote server",
// "Package Config" => "Package Config",
// "Last editor" => "Last editor",
// "Last modification" => "Last modification",
// "y" => "y",
// "subscribe" => "subscribe",
// "Sent edition" => "Sent edition",
// "Available Newsletters" => "Available Newsletters",
// "News from" => "News from",
// "Configure Newsreader" => "Configure Newsreader",
// "configure newsreader server tpl" => "configure newsreader server tpl",
// "Read the news" => "Read the news",
// "Preview of version" => "Preview of version",
// "(current)" => "(current)",
// "rollback to this version" => "rollback to this version",
// "Source of version" => "Source of version",
// "s=source" => "s=source",
// "b=rollback" => "b=rollback",
// "remove from this page" => "remove from this page",
// "remove from this structure" => "remove from this structure",
// "No individual permissions; category or global permissions apply" => "No individual permissions; category or global permissions apply",
// "this structure" => "this structure",
// "Current permissions for categories that this page belongs to" => "Current permissions for categories that this page belongs to",
// "No category permissions; global permissions apply" => "No category permissions; global permissions apply",
// "no avatar" => "no avatar",
// "icons" => "icons",
// "Avatar Image" => "Avatar Image",
// "Any" => "Any",
// "atts" => "atts",
// "Number of voices" => "Number of voices",
// "List Attachments" => "List Attachments",
// "View Results" => "View Results",
// "Note: Remember that this is only a preview, and has not yet been saved!" => "Note: Remember that this is only a preview, and has not yet been saved!",
// "add structure" => "add structure",
// "Edit quiz" => "Edit quiz",
// "Current Version" => "Current Version",
// "General Options" => "General Options",
// "Publication Date" => "Publication Date",
// "at " => "at ",
// "Use " => "Use ",
// "randomly selected questions." => "randomly selected questions.",
// "Test-time Options" => "Test-time Options",
// "Limit questions displayed per page to " => "Limit questions displayed per page to ",
// "&nbsp question(s)." => "&nbsp question(s).",
// "Impose a time limit of " => "Impose a time limit of ",
// "Allow students to store partial results and return to quiz." => "Allow students to store partial results and return to quiz.",
// "Allow students to retake this quiz " => "Allow students to retake this quiz ",
// "Grading and Feedback" => "Grading and Feedback",
// "Grading method " => "Grading method ",
// "Show students their score " => "Show students their score ",
// "Show students the correct answers " => "Show students the correct answers ",
// "Publish statistics " => "Publish statistics ",
// "Extra Options" => "Extra Options",
// "Solicit additional questions from students" => "Solicit additional questions from students",
// "Link quiz to forum named: " => "Link quiz to forum named: ",
// "Prologue:" => "Prologue:",
// "Epilogue:" => "Epilogue:",
// "time taken" => "time taken",
// "P/F" => "P/F",
// "P" => "P",
// "F" => "F",
// "received articles tpl" => "received articles tpl",
// "Help on Communication Center" => "Help on Communication Center",
// "received pages tpl" => "received pages tpl",
// "admin Referer stats" => "admin Referer stats",
// "admin Referer stats tpl" => "admin Referer stats tpl",
// "A valid email is mandatory to register" => "A valid email is mandatory to register",
// "NOTE: Make sure to whitelist this domain to prevent<br />registration emails being canned by your spam filter!" => "NOTE: Make sure to whitelist this domain to prevent<br />registration emails being canned by your spam filter!",
// "Tiki site registered" => "Tiki site registered",
// "You don't have permission to use this feature." => "You don't have permission to use this feature.",
// "Please register." => "Please register.",
// "Read this first!" => "Read this first!",
// "On this page you can make your tiki site known to tikiwiki.org. It will get shown there in a list of known tiki sites." => "On this page you can make your tiki site known to tikiwiki.org. It will get shown there in a list of known tiki sites.",
// "Registering is voluntary." => "Registering is voluntary.",
// "Registering does not give you any benefits except one more link to your site." => "Registering does not give you any benefits except one more link to your site.",
// "You don't get any emails, we don't sell the data about your site." => "You don't get any emails, we don't sell the data about your site.",
// "Registering is just for us to get an overview of Tiki's usage." => "Registering is just for us to get an overview of Tiki's usage.",
// "If your site is private or inside your intranet, you should not register!" => "If your site is private or inside your intranet, you should not register!",
// "tikiwiki.org" => "tikiwiki.org",
// "Information about your site" => "Information about your site",
// "last version" => "last version",
// "Replicate" => "Replicate",
// "Slave" => "Slave",
// "Master" => "Master",
// "Change" => "Change",
// "Operations" => "Operations",
// "Operations Log" => "Operations Log",
// "search stats tpl" => "search stats tpl",
// "entire site" => "entire site",
// "wiki pages" => "wiki pages",
// "Simple search" => "Simple search",
// "Apply content template" => "Apply content template",
// "admin send objects tpl" => "admin send objects tpl",
// "sheets tpl" => "sheets tpl",
// "Create a sheet" => "Create a sheet",
// "Edit this sheet:" => "Edit this sheet:",
// "create new sheet" => "create new sheet",
// "There are individual permissions set for this sheet" => "There are individual permissions set for this sheet",
// "Class Name" => "Class Name",
// "Header Rows" => "Header Rows",
// "Footer Rows" => "Footer Rows",
// "Create new Sheet" => "Create new Sheet",
// "You can access the sheet using the following URL" => "You can access the sheet using the following URL",
// "Available Sheets" => "Available Sheets",
// "Graph" => "Graph",
// "admin Tiki Shoutbox" => "admin Tiki Shoutbox",
// "admin Tiki Shoutbox tpl" => "admin Tiki Shoutbox tpl",
// "Change shoutbox general settings" => "Change shoutbox general settings",
// "auto-link urls" => "auto-link urls",
// "first" => "first",
// "big grin" => "big grin",
// "confused" => "confused",
// "cry" => "cry",
// "eek" => "eek",
// "evil" => "evil",
// "lol" => "lol",
// "mr green" => "mr green",
// "razz" => "razz",
// "redface" => "redface",
// "rolleyes" => "rolleyes",
// "smile" => "smile",
// "surprised" => "surprised",
// "twisted" => "twisted",
// "arrow" => "arrow",
// "santa" => "santa",
// "Most viewed objects" => "Most viewed objects",
// "Most viewed objects in the last 7 days" => "Most viewed objects in the last 7 days",
// "Usage chart image" => "Usage chart image",
// "Daily Usage" => "Daily Usage",
// "SysLog" => "SysLog",
// "system logs" => "system logs",
// "system logs tpl" => "system logs tpl",
// "Thank you for your submission" => "Thank you for your submission",
// "ThemeControl" => "ThemeControl",
// "ThemeControl tpl" => "ThemeControl tpl",
// "To learn more about <a class=\"rbox-link\" target=\"tikihelp\" href=\"http://themes.tikiwiki.org\">themes</a>." => "To learn more about <a class=\"rbox-link\" target=\"tikihelp\" href=\"http://themes.tikiwiki.org\">themes</a>.",
// "Control by Objects" => "Control by Objects",
// "ThemeControl Objects" => "ThemeControl Objects",
// "theme control objects tpl" => "theme control objects tpl",
// "theme control sections tpl" => "theme control sections tpl",
// "Edit File:" => "Edit File:",
// "You have to \ncreate a gallery first!" => "You have to \ncreate a gallery first!",
// "Image Gallery tpl" => "Image Gallery tpl",
// "or use filename" => "or use filename",
// "Note: Maximum image size is limited to" => "Note: Maximum image size is limited to",
// "Image ID thumb" => "Image ID thumb",
// "User Assigned Modules tpl" => "User Assigned Modules tpl",
// "User Bookmarks tpl" => "User Bookmarks tpl",
// "Folder in" => "Folder in",
// "Homepage" => "Homepage",
// "Users HomePage" => "Users HomePage",
// "Create page" => "Create page",
// "This user is your friend" => "This user is your friend",
// "Request friendship from this user" => "Request friendship from this user",
// "Toggle options" => "Toggle options",
// "Toggle" => "Toggle",
// "UserPreferences tpl" => "UserPreferences tpl",
// "Personal Information" => "Personal Information",
// "General preferences" => "General preferences",
// "Other preferences" => "Other preferences",
// "use google map locator" => "use google map locator",
// "Your personal tracker information" => "Your personal tracker information",
// "View extra information" => "View extra information",
// "Change information" => "Change information",
// "Unavailable - please set your e-mail below" => "Unavailable - please set your e-mail below",
// "Does your mail reader need a special charset" => "Does your mail reader need a special charset",
// "Use double-click to edit pages" => "Use double-click to edit pages",
// "Account Information" => "Account Information",
// "Leave \"New password\" and \"Confirm new password\" fields blank to keep current password" => "Leave \"New password\" and \"Confirm new password\" fields blank to keep current password",
// "Email address" => "Email address",
// "Confirm new password" => "Confirm new password",
// "Current password (required)" => "Current password (required)",
// "Change administrative info" => "Change administrative info",
// "Note author when reading his mail" => "Note author when reading his mail",
// "Auto-archive read messages after x days" => "Auto-archive read messages after x days",
// "My workflow" => "My workflow",
// "User Tasks tpl" => "User Tasks tpl",
// "New task" => "New task",
// "Task list" => "Task list",
// "Admin mode off" => "Admin mode off",
// "Admin mode on" => "Admin mode on",
// "Task help" => "Task help",
// "Received task" => "Received task",
// "You received this task, please read and execute it" => "You received this task, please read and execute it",
// "Send task" => "Send task",
// "You send this task to a other user" => "You send this task to a other user",
// "Shared task" => "Shared task",
// "This task is public to a special group" => "This task is public to a special group",
// "accepted by task user and creator" => "accepted by task user and creator",
// "accepted user and creator" => "accepted user and creator",
// "Task is accepted by user and creator" => "Task is accepted by user and creator",
// "not accepted by one user" => "not accepted by one user",
// "not accepted user" => "not accepted user",
// "Task is rejected by one user" => "Task is rejected by one user",
// "waiting for me" => "waiting for me",
// "Task is not accepted by you, read the task and accept or reject it" => "Task is not accepted by you, read the task and accept or reject it",
// "waiting for other user" => "waiting for other user",
// "Task is not accepted/rejected by other user" => "Task is not accepted/rejected by other user",
// "admin mode" => "admin mode",
// "trash" => "trash",
// "empty trash" => "empty trash",
// "Edit task" => "Edit task",
// "red" => "red",
// "NOT accept" => "NOT accept",
// "remove from trash" => "remove from trash",
// "move into trash" => "move into trash",
// "Task saved" => "Task saved",
// "Edit Task" => "Edit Task",
// "View Task" => "View Task",
// "Open a new task" => "Open a new task",
// "taskId" => "taskId",
// "Task user" => "Task user",
// "Only the creator can delete this task" => "Only the creator can delete this task",
// "use start date and time" => "use start date and time",
// "use end date and time" => "use end date and time",
// "open / in process" => "open / in process",
// "waiting / not started" => "waiting / not started",
// "waiting" => "waiting",
// "shared for group" => "shared for group",
// "accepted by user" => "accepted by user",
// "no / rejected" => "no / rejected",
// "accepted by creator" => "accepted by creator",
// "Info" => "Info",
// "This message will be send to users if you are makeing changes of assigned tasks" => "This message will be send to users if you are makeing changes of assigned tasks",
// "Send message with changes" => "Send message with changes",
// "Modified by" => "Modified by",
// "Marked as deleted" => "Marked as deleted",
// "Inform task user by email" => "Inform task user by email",
// "You can only view this task" => "You can only view this task",
// "%m/%d/%Y [%H:%M]" => "%m/%d/%Y [%H:%M]",
// "select one" => "select one",
// "undo trash" => "undo trash",
// "show:" => "show:",
// "received" => "received",
// "submitted" => "submitted",
// "shared" => "shared",
// "all shared tasks" => "all shared tasks",
// "completed (100%)" => "completed (100%)",
// "Public for group" => "Public for group",
// "User Watches tpl" => "User Watches tpl",
// "Add Watch" => "Add Watch",
// "A user submits a blog post" => "A user submits a blog post",
// "A user posts a forum thread" => "A user posts a forum thread",
// "A user posts a forum topic" => "A user posts a forum topic",
// "A user edited a wiki page" => "A user edited a wiki page",
// "edit user files" => "edit user files",
// "Insert Row" => "Insert Row",
// "Insert Column" => "Insert Column",
// "Remove Row" => "Remove Row",
// "Remove Column" => "Remove Column",
// "Merge Cells" => "Merge Cells",
// "Restore Cells" => "Restore Cells",
// "Copy Calculation" => "Copy Calculation",
// "Format Cell" => "Format Cell",
// "Before" => "Before",
// "After" => "After",
// "expires:" => "expires:",
// "permanency" => "permanency",
// "Answers" => "Answers",
// "add suggestion" => "add suggestion",
// "1 suggestion" => "1 suggestion",
// "suggestions" => "suggestions",
// "You have {\$unread} unread private messages" => "You have {\$unread} unread private messages",
// "emot" => "emot",
// "posts:" => "posts:",
// "IRC log" => "IRC log",
// "Select" => "Select",
// "Show All" => "Show All",
// "Edit fields" => "Edit fields",
// " item found" => " item found",
// " items found" => " items found",
// "list attachments" => "list attachments",
// "View inserted item" => "View inserted item",
// "fields marked with a * are mandatory" => "fields marked with a * are mandatory",
// "Tracker item:" => "Tracker item:",
// "Filter Tracker Items" => "Filter Tracker Items",
// "more info" => "more info",
// "remove image" => "remove image",
// "Special Operations" => "Special Operations",
// "Webmail Doc" => "Webmail Doc",
// "Webmail Doc template" => "Webmail Doc template",
// "Edit mail account" => "Edit mail account",
// "clip" => "clip",
// "%s enabled" => "%s enabled",
// "%s disabled" => "%s disabled",
// "Enable/disable Tiki features here, but configure them elsewhere" => "Enable/disable Tiki features here, but configure them elsewhere",
// "User registration, login and authentication" => "User registration, login and authentication",
// "Wiki Attachments" => "Wiki Attachments",
// "Article/CMS settings" => "Article/CMS settings",
// "Configuration options for all blogs on your site" => "Configuration options for all blogs on your site",
// "FAQ comments settings" => "FAQ comments settings",
// "Trackers settings" => "Trackers settings",
// "RSS settings" => "RSS settings",
// "Directory settings" => "Directory settings",
// "Maps configuration" => "Maps configuration",
// "Meta Tags settings" => "Meta Tags settings",
// "Score settings" => "Score settings",
// "Projects" => "Projects",
// "Projects configuration" => "Projects configuration",
// "Community settings" => "Community settings",
// "Site Identity features" => "Site Identity features",
// "Calendar settings" => "Calendar settings",
// "Intertiki settings" => "Intertiki settings",
// "Help on \$admintitle Config" => "Help on \$admintitle Config",
// "Click here to delete this category" => "Click here to delete this category",
// "Category can`t be parent of itself" => "Category can`t be parent of itself",
// "moved %d images, %d errors occured." => "moved %d images, %d errors occured.",
// "a timeout occured. Hit the reload button to move the rest" => "a timeout occured. Hit the reload button to move the rest",
// "Detected, Version:" => "Detected, Version:",
// "Not detected." => "Not detected.",
// "You cannot have a blank password" => "You cannot have a blank password",
// "No valid gdaltindex executable" => "No valid gdaltindex executable",
// "You cannot mix old and new trackers" => "You cannot mix old and new trackers",
// "Mail-in account %s incorrect" => "Mail-in account %s incorrect",
// "Mail-in account %s saved" => "Mail-in account %s saved",
// "Frequency should be a positive integer!" => "Frequency should be a positive integer!",
// "Mail-in accounts set to be checked every %s minutes" => "Mail-in accounts set to be checked every %s minutes",
// "Automatic Mail-in accounts checking disabled" => "Automatic Mail-in accounts checking disabled",
// "Cannot create or update module: You need to specify a name to the module" => "Cannot create or update module: You need to specify a name to the module",
// "Cannot create or update module: You cannot leave the data field empty" => "Cannot create or update module: You cannot leave the data field empty",
// "unsafe" => "unsafe",
// "register_globals should be off by default. See the php manual for details." => "register_globals should be off by default. See the php manual for details.",
// "safe" => "safe",
// "session.use_trans_sid should be off by default. See the php manual for details." => "session.use_trans_sid should be off by default. See the php manual for details.",
// "upload_tmp_dir is probably within your TikiWiki directory. There is a risk that someone can upload any file to this directory and access them via web browser" => "upload_tmp_dir is probably within your TikiWiki directory. There is a risk that someone can upload any file to this directory and access them via web browser",
// "cannot check if the upload_tmp_dir is accessible via web browser. To be sure you should check your webserver config." => "cannot check if the upload_tmp_dir is accessible via web browser. To be sure you should check your webserver config.",
// "setting the xbithack option is unsafe. Depending on the file handling of your webserver and your tiki settings, it may be possible that a attacker can upload scripts to file gallery and execute them" => "setting the xbithack option is unsafe. Depending on the file handling of your webserver and your tiki settings, it may be possible that a attacker can upload scripts to file gallery and execute them",
// "risky" => "risky",
// "allow_url_fopen may potentially be used to upload remote data or scripts. If you dont use the blog feature, you can switch it off." => "allow_url_fopen may potentially be used to upload remote data or scripts. If you dont use the blog feature, you can switch it off.",
// "The Path to store files in the filegallery should be outside the tiki root directory" => "The Path to store files in the filegallery should be outside the tiki root directory",
// "The Path to store files in the imagegallery should be outside the tiki root directory" => "The Path to store files in the imagegallery should be outside the tiki root directory",
// "The feature \"Edit Templates\" is switched on. Do not allow anyone you cannot trust to use this feature. It can easily be used to inject php code." => "The feature \"Edit Templates\" is switched on. Do not allow anyone you cannot trust to use this feature. It can easily be used to inject php code.",
// "installed" => "installed",
// "The \"Snarf Wikiplugin\" is installed. It can be used by wiki editors to include pages from the local network and via regex replacement create any html." => "The \"Snarf Wikiplugin\" is installed. It can be used by wiki editors to include pages from the local network and via regex replacement create any html.",
// "The \"Regex Wikiplugin\" is installed. It can be used by wiki editors to create any html via regex replacement." => "The \"Regex Wikiplugin\" is installed. It can be used by wiki editors to create any html via regex replacement.",
// "The \"Lsdir Wikiplugin\" is installed. It can be used by wiki editors to view the contents of any directory." => "The \"Lsdir Wikiplugin\" is installed. It can be used by wiki editors to view the contents of any directory.",
// "The \"Bloglist Wikiplugin\" is installed. It can be used by wiki editors to disclose private blog posts." => "The \"Bloglist Wikiplugin\" is installed. It can be used by wiki editors to disclose private blog posts.",
// "Path disclosure" => "Path disclosure",
// "Path disclosure through error message" => "Path disclosure through error message",
// "SQL injection" => "SQL injection",
// "SQL injection by authenticated user" => "SQL injection by authenticated user",
// "SQL injection by authenticated user with special privileges" => "SQL injection by authenticated user with special privileges",
// "SQL injection without authentication" => "SQL injection without authentication",
// "PHP command injection" => "PHP command injection",
// "PHP command injection by authenticated user" => "PHP command injection by authenticated user",
// "PHP command injection by authenticated user with special privileges" => "PHP command injection by authenticated user with special privileges",
// "PHP command injection without authentication" => "PHP command injection without authentication",
// "File upload" => "File upload",
// "File is not readable. Unable to check." => "File is not readable. Unable to check.",
// "This is not a TikiWiki file. Check if this file was uploaded and if it is dangerous." => "This is not a TikiWiki file. Check if this file was uploaded and if it is dangerous.",
// "This is a modified File. Cannot check version. Check if it is dangerous." => "This is a modified File. Cannot check version. Check if it is dangerous.",
// "This file is from another TikiWiki version: " => "This file is from another TikiWiki version: ",
// " or " => " or ",
// "You have to provide a word" => "You have to provide a word",
// "You don't have permission to use this feature" => "You don't have permission to use this feature",
// "No Errors detected" => "No Errors detected",
// "Created account %s <%s>" => "Created account %s <%s>",
// "Assigned %s in group %s" => "Assigned %s in group %s",
// "User %s already exists" => "User %s already exists",
// "New %s created with %s %s." => "New %s created with %s %s.",
// "Impossible to create new %s with %s %s." => "Impossible to create new %s with %s %s.",
// "%s %s successfully deleted." => "%s %s successfully deleted.",
// "%s %s removed from %s %s." => "%s %s removed from %s %s.",
// "%s <b>%s</b> successfully deleted." => "%s <b>%s</b> successfully deleted.",
// "%s <b>%s</b> assigned to %s <b>%s</b>." => "%s <b>%s</b> assigned to %s <b>%s</b>.",
// "%s <b>%s</b> removed from %s <b>%s</b>." => "%s <b>%s</b> removed from %s <b>%s</b>.",
// "group <b>%s</b> set as the default group of user <b>%s</b>." => "group <b>%s</b> set as the default group of user <b>%s</b>.",
// "%s modified successfully." => "%s modified successfully.",
// "%s modification failed." => "%s modification failed.",
// "%s changed from %s to %s" => "%s changed from %s to %s",
// "Impossible to change %s from %s to %s" => "Impossible to change %s from %s to %s",
// "Tiki RSS feed for articles" => "Tiki RSS feed for articles",
// "Last articles." => "Last articles.",
// "You have to indicate a group" => "You have to indicate a group",
// "This group is invalid" => "This group is invalid",
// "Image Galleries Admin Panel" => "Image Galleries Admin Panel",
// "Could not read image %s." => "Could not read image %s.",
// "Image %s upload failed." => "Image %s upload failed.",
// "Image %s uploaded successfully." => "Image %s uploaded successfully.",
// "Image %s removed from Batch directory." => "Image %s removed from Batch directory.",
// "Impossible to remove image %s from Batch directory." => "Impossible to remove image %s from Batch directory.",
// "Permission denied you cannot use the batch directory loading" => "Permission denied you cannot use the batch directory loading",
// "Incorrect directory chosen for batch upload of images." => "Incorrect directory chosen for batch upload of images.",
// "Please setup that dir on " => "Please setup that dir on ",
// "Please contact the website administrator." => "Please contact the website administrator.",
// "Tiki RSS feed for blog: " => "Tiki RSS feed for blog: ",
// "Tiki RSS feed for weblogs" => "Tiki RSS feed for weblogs",
// "Last posts to weblogs." => "Last posts to weblogs.",
// "Please login" => "Please login",
// "First day of week: Sunday (its ID is 0) - translators you need to localize this string!" => "First day of week: Sunday (its ID is 0) - translators you need to localize this string!",
// "%m/%d" => "%m/%d",
// "Access Denied" => "Access Denied",
// "Tiki RSS feed for calendars" => "Tiki RSS feed for calendars",
// "Upcoming events." => "Upcoming events.",
// "Start:" => "Start:",
// "End:" => "End:",
// "No category indicated" => "No category indicated",
// "Permission denied; you cannot assign permissions for this category" => "Permission denied; you cannot assign permissions for this category",
// "The passwords didn't match" => "The passwords didn't match",
// "ERROR: you must include a subject or a message at least" => "ERROR: you must include a subject or a message at least",
// "You need to change chmod 'whelp' manually to 777" => "You need to change chmod 'whelp' manually to 777",
// "Tiki RSS feed for directory sites" => "Tiki RSS feed for directory sites",
// "Last sites." => "Last sites.",
// "Site No validated yet" => "Site No validated yet",
// "No parent specified" => "No parent specified",
// "Last sites of directory \".\$rc[\"name\"].\" ." => "Last sites of directory \".\$rc[\"name\"].\" .",
// "Error : The file %s doesn't exist." => "Error : The file %s doesn't exist.",
// "The language can't be changed as its set of translations has already this language" => "The language can't be changed as its set of translations has already this language",
// "You do not have permission to write the template:" => "You do not have permission to write the template:",
// "No object indicated" => "No object indicated",
// "No type indicated" => "No type indicated",
// "You have mistyped the anti-bot verification code; please try again." => "You have mistyped the anti-bot verification code; please try again.",
// "unknown error" => "unknown error",
// "cannot be found" => "cannot be found",
// "No permission to view the page" => "No permission to view the page",
// "No questions group indicated" => "No questions group indicated",
// "Tiki RSS feed for file galleries" => "Tiki RSS feed for file galleries",
// "Last files uploaded to the file galleries." => "Last files uploaded to the file galleries.",
// "Tiki RSS feed for the file gallery: " => "Tiki RSS feed for the file gallery: ",
// "Tiki RSS feed for forum: " => "Tiki RSS feed for forum: ",
// "Tiki RSS feed for forums" => "Tiki RSS feed for forums",
// "Last topics in forums." => "Last topics in forums.",
// "Accepted friendship request from %s" => "Accepted friendship request from %s",
// "Refused friendship request from %s" => "Refused friendship request from %s",
// "Broke friendship with %s" => "Broke friendship with %s",
// "I have broken our friendship!" => "I have broken our friendship!",
// "You must be logged in to use this feature" => "You must be logged in to use this feature",
// "Friendship request sent to %s" => "Friendship request sent to %s",
// "You're already friend of %s" => "You're already friend of %s",
// "I have accepted your friendship request!" => "I have accepted your friendship request!",
// "I have refused your friendship request!" => "I have refused your friendship request!",
// "Role name cannot be empty" => "Role name cannot be empty",
// "Activity name cannot be empty" => "Activity name cannot be empty",
// "A start activity requires a name for the instance" => "A start activity requires a name for the instance",
// "You couldn't abort a instance" => "You couldn't abort a instance",
// "You couldn't exception a instance" => "You couldn't exception a instance",
// "No title indicated" => "No title indicated",
// "No comment indicated" => "No comment indicated",
// "No date indicated" => "No date indicated",
// "first uploaded image" => "first uploaded image",
// "last uploaded image" => "last uploaded image",
// "random image" => "random image",
// "Permission denied you cannot make the map of this gallery" => "Permission denied you cannot make the map of this gallery",
// "Back to preferences" => "Back to preferences",
// "No valid renderer found. GD or PDFLib required." => "No valid renderer found. GD or PDFLib required.",
// "No sheet specified." => "No sheet specified.",
// "You must select a renderer." => "You must select a renderer.",
// "Invalid Series for current graphic." => "Invalid Series for current graphic.",
// "Tiki RSS feed for image galleries" => "Tiki RSS feed for image galleries",
// "Last images uploaded to the image galleries." => "Last images uploaded to the image galleries.",
// "Tiki RSS feed for the image gallery: " => "Tiki RSS feed for the image gallery: ",
// "updated from structured text import" => "updated from structured text import",
// "created from structured text import" => "created from structured text import",
// "This gallery does not exist" => "This gallery does not exist",
// "The game file must have .swf or .dcr extension" => "The game file must have .swf or .dcr extension",
// "Please supply both files" => "Please supply both files",
// "Unable to contact remote server." => "Unable to contact remote server.",
// "XMLRPC Error: " => "XMLRPC Error: ",
// "Account validated successfully." => "Account validated successfully.",
// "Tiki mail-in auto-reply" => "Tiki mail-in auto-reply",
// "Sorry, you can't use this feature." => "Sorry, you can't use this feature.",
// "Maps feature is not correctly setup : Maps path is missing." => "Maps feature is not correctly setup : Maps path is missing.",
// "Please create a directory named \$map_path to hold your map files." => "Please create a directory named \$map_path to hold your map files.",
// "I could not make a copy" => "I could not make a copy",
// "You dont have permission to do that" => "You dont have permission to do that",
// "Tiki RSS feed for maps" => "Tiki RSS feed for maps",
// "List of maps available." => "List of maps available.",
// "You need to run setup.sh :<br />./setup.sh \$APACHEUSER all<br />Common Apache users are www-data, apache or nobody" => "You need to run setup.sh :<br />./setup.sh \$APACHEUSER all<br />Common Apache users are www-data, apache or nobody",
// "Your PHP installation does not have zlib enabled." => "Your PHP installation does not have zlib enabled.",
// "Pageviews" => "Pageviews",
// "You don't have permission to edit quizzes." => "You don't have permission to edit quizzes.",
// "Registered" => "Registered",
// "The registration mail can't be sent. Contact the administrator" => "The registration mail can't be sent. Contact the administrator",
// "Invalid username or activation code. Maybe this code has already been used." => "Invalid username or activation code. Maybe this code has already been used.",
// "Unable to send mail. User has not configured email" => "Unable to send mail. User has not configured email",
// "A password and your IP address reminder email has been sent " => "A password and your IP address reminder email has been sent ",
// "A new (and temporary) password and your IP address has been sent " => "A new (and temporary) password and your IP address has been sent ",
// "Permission denied you cannot rename this page" => "Permission denied you cannot rename this page",
// "Cannot rename page because the new name begins with reserved prefix" => "Cannot rename page because the new name begins with reserved prefix",
// "changed '%s' from '%s' to '%s'" => "changed '%s' from '%s' to '%s'",
// "Error Message" => "Error Message",
// "Tiki RSS Feed Error Message: \$errmsg" => "Tiki RSS Feed Error Message: \$errmsg",
// "One of the email addresses you typed is invalid" => "One of the email addresses you typed is invalid",
// "No newsletters available." => "No newsletters available.",
// "Error: " => "Error: ",
// "Use this thread to discuss the page:" => "Use this thread to discuss the page:",
// "An error occurred." => "An error occurred.",
// "Notice: invalid variable value:" => "Notice: invalid variable value:",
// "This feature is for admins only" => "This feature is for admins only",
// "empty" => "empty",
// "No trackerId specified" => "No trackerId specified",
// "Tiki RSS feed for individual trackers: " => "Tiki RSS feed for individual trackers: ",
// "File update was successful" => "File update was successful",
// "Could not find the file requested" => "Could not find the file requested",
// "The uploaded file ist not recognized as a image" => "The uploaded file ist not recognized as a image",
// "Usage" => "Usage",
// "Invalid password.  Your current password is required to change administrative information" => "Invalid password.  Your current password is required to change administrative information",
// "Email is set to %s" => "Email is set to %s",
// "was moved into trash" => "was moved into trash",
// "trashed by" => "trashed by",
// "Rights by creator" => "Rights by creator",
// "END" => "END",
// "Percentage" => "Percentage",
// "Task accepted by creator" => "Task accepted by creator",
// "Task accepted by task user" => "Task accepted by task user",
// "Task NOT accepted by creator" => "Task NOT accepted by creator",
// "Task NOT accepted by task user" => "Task NOT accepted by task user",
// "Sorry this task does not exist or you have no rights to view this task" => "Sorry this task does not exist or you have no rights to view this task",
// "Task entries:" => "Task entries:",
// "Changes:" => "Changes:",
// "Info message" => "Info message",
// "NEW Task" => "NEW Task",
// "Sorry you are not allowed to send tasks to other users, or the user is not allowed to receive tasks!" => "Sorry you are not allowed to send tasks to other users, or the user is not allowed to receive tasks!",
// "Changes on Task" => "Changes on Task",
// "You received a new task" => "You received a new task",
// "The priority is" => "The priority is",
// "very low" => "very low",
// "low" => "low",
// "high" => "high",
// "very high" => "very high",
// "You've to start your work at least on" => "You've to start your work at least on",
// "You've to finish your work on" => "You've to finish your work on",
// "Login and click the link below" => "Login and click the link below",
// "Please read the task and work on it!" => "Please read the task and work on it!",
// "Sorry, there was an error while trying to write data into the database" => "Sorry, there was an error while trying to write data into the database",
// "Permission denied you cannot remove trackbacks" => "Permission denied you cannot remove trackbacks",
// "A SheetId is required." => "A SheetId is required.",
// "That tracker don't use extras." => "That tracker don't use extras.",
// "Tiki RSS feed for the wiki pages" => "Tiki RSS feed for the wiki pages",
// "Last modifications to the Wiki." => "Last modifications to the Wiki.",
// ### end of untranslated words
// ###

// ###
// ### start of possibly untranslated words
// ###

"Re:" => "Re:",
"You must supply all the information, including title and year." => "You must supply all the information, including title and year.",
"Role" => "Role",
"by" => "by",
"locked" => "locked",
"locked by" => "locked by",
"continued" => "continued",
"in" => "in",
"new image uploaded by" => "new image uploaded by",
"uploaded by" => "uploaded by",
"new item in tracker" => "new item in tracker",
"new subscriptions" => "new subscriptions",
"not specified" => "not specified",
"Cannot upload this file maximum upload size exceeded" => "Cannot upload this file maximum upload size exceeded",
"Anonymous" => "Anonymous",
"Newsletter subscription information at " => "Newsletter subscription information at ",
"Cannot write to this file:" => "Cannot write to this file:",
"previous page" => "previous page",
"next page" => "next page",
"posted on" => "posted on",
"Invalid imagename (using filters for filenames)" => "Invalid imagename (using filters for filenames)",
"Errors detected" => "Errors detected",
"Upload was not successful" => "Upload was not successful",
"No image yet, sorry." => "No image yet, sorry.",
"unknown" => "unknown",
"NONE" => "NONE",
"Relevance" => "Relevance",
"Wiki last pages" => "Wiki last pages",
"Topic date" => "Topic date",
"Wiki last images" => "Wiki last images",
"Wiki last files" => "Wiki last files",
"Send message" => "Send message",
"Attach file" => "Attach file",
"Wiki" => "Wiki",
"FAQ" => "FAQ",
"File" => "File",
"%H:%M:%S %Z" => "%H:%M:%S %Z",
"%H:%M %Z" => "%H:%M %Z",
"unlocked" => "unlocked",
"You are banned from" => "You are banned from",
"wiki" => "wiki",
"picture not found" => "picture not found",
"drawing not found" => "drawing not found",
"Item" => "Item",
"Tracker was modified at " => "Tracker was modified at ",
"open" => "open",
"child categories" => "child categories",
"objects in category" => "objects in category",
"data" => "data",
"Page cannot be found" => "Page cannot be found",
"Insert theme styled box on wiki page" => "Insert theme styled box on wiki page",
"text" => "text",
"Insert list of items for the current/given category into wiki page" => "Insert list of items for the current/given category into wiki page",
"Categories are disabled" => "Categories are disabled",
"Display Tiki objects that have not been categorized" => "Display Tiki objects that have not been categorized",
"Insert the full category path for each category that this wiki page belongs to" => "Insert the full category path for each category that this wiki page belongs to",
"Centers the plugin content in the wiki page" => "Centers the plugin content in the wiki page",
"code" => "code",
"Insert copyright notices" => "Insert copyright notices",
"Example" => "Example",
"term" => "term",
"definition" => "definition",
"Displays the data using the TikiWiki odd/even table style" => "Displays the data using the TikiWiki odd/even table style",
"Displays a graphical GAUGE" => "Displays a graphical GAUGE",
"Please choose a module" => "Please choose a module",
"to be used as argument" => "to be used as argument",
"Displays a module inlined in page" => "Displays a module inlined in page",
"Sorry no such module" => "Sorry no such module",
"Displays the data using a monospace font" => "Displays the data using a monospace font",
"Sorts the plugin content in the wiki page" => "Sorts the plugin content in the wiki page",
"Missing db param" => "Missing db param",
"valid" => "valid",
"ERROR: Either the subject or body must be non-empty" => "ERROR: Either the subject or body must be non-empty",
"ERROR: No valid users to send the message" => "ERROR: No valid users to send the message",
"No more messages" => "No more messages",
"Quick edit a Wiki page" => "Quick edit a Wiki page",
"Since your last visit" => "Since your last visit",
"since" => "since",
"new comments" => "new comments",
"wiki pages changed" => "wiki pages changed",
"new images" => "new images",
"new files" => "new files",
"new users" => "new users",
"no such file" => "no such file",
"Invalid username or password" => "Invalid username or password",
"List of attached files" => "List of attached files",
"desc" => "desc",
"uploaded" => "uploaded",
"attach" => "attach",
"debug" => "debug",
"Fatal error" => "Fatal error",
" on " => " on ",
"RSS feed" => "RSS feed",
"Activity=" => "Activity=",
"stars" => "stars",
"private message" => "private message",
"send email to user" => "send email to user",
"user online" => "user online",
"user offline" => "user offline",
"on" => "on",
"score" => "score",
"attachment" => "attachment",
"Moderator actions" => "Moderator actions",
"Move to topic:" => "Move to topic:",
"reported:" => "reported:",
"queued:" => "queued:",
"Threshold" => "Threshold",
"Hide all" => "Hide all",
"replies" => "replies",
"Rating" => "Rating",
"Use" => "Use",
"or" => "or",
"for links" => "for links",
"Copyrights" => "Copyrights",
"Year" => "Year",
"Authors" => "Authors",
"Syntax" => "Syntax",
"Page generation debugging log" => "Page generation debugging log",
"Features state" => "Features state",
"Total" => "Total",
"features matched" => "features matched",
"Watchlist" => "Watchlist",
"Somebody or you tried to subscribe this email address at our site:" => "Somebody or you tried to subscribe this email address at our site:",
"To the newsletter:" => "To the newsletter:",
"In order to confirm your subscription you must access the following URL:" => "In order to confirm your subscription you must access the following URL:",
"Message" => "Message",
"Tiki mail-in instructions" => "Tiki mail-in instructions",
"A new message was posted to you at {\$mail_machine}" => "A new message was posted to you at {\$mail_machine}",
"From" => "From",
"Bye bye!" => "Bye bye!",
"This email address has been removed to the list of subscriptors of:" => "This email address has been removed to the list of subscriptors of:",
"Newsletter:" => "Newsletter:",
"You can unsubscribe from this newsletter following this link" => "You can unsubscribe from this newsletter following this link",
"Welcome to our newsletter!" => "Welcome to our newsletter!",
"This email address has been added to the list of subscriptors of:" => "This email address has been added to the list of subscriptors of:",
"Tiki email notification" => "Tiki email notification",
"A new article was submitted by {\$mail_user} to {\$mail_site} at {\$mail_date|tiki_short_datetime}" => "A new article was submitted by {\$mail_user} to {\$mail_site} at {\$mail_date|tiki_short_datetime}",
"Heading:" => "Heading:",
"Body:" => "Body:",
"If you don't want to receive these notifications follow this link:" => "If you don't want to receive these notifications follow this link:",
"File Description" => "File Description",
"The page {\$mail_page} was changed by {\$mail_user} at {\$mail_date|tiki_short_datetime}" => "The page {\$mail_page} was changed by {\$mail_user} at {\$mail_date|tiki_short_datetime}",
"Comment:" => "Comment:",
"of" => "of",
"Versions are identical" => "Versions are identical",
"Ip" => "Ip",
"1" => "1",
"2" => "2",
"3" => "3",
"4" => "4",
"5" => "5",
"To" => "To",
"CC" => "CC",
"BCC" => "BCC",
"Flag this message" => "Flag this message",
"Cc" => "Cc",
"no" => "no",
"Admin drawings" => "Admin drawings",
"Admin dsn" => "Admin dsn",
"Syntax highlighting" => "Syntax highlighting",
"Workflow" => "Workflow",
"Admin processes" => "Admin processes",
"Monitor processes" => "Monitor processes",
"Monitor activities" => "Monitor activities",
"Monitor instances" => "Monitor instances",
"User processes" => "User processes",
"User activities" => "User activities",
"User instances" => "User instances",
"List galleries" => "List galleries",
"Edit languages" => "Edit languages",
"DSN" => "DSN",
"Recently visited pages" => "Recently visited pages",
"top" => "top",
"Received objects" => "Received objects",
"Pages:" => "Pages:",
"Last Sites" => "Last Sites",
"Sites to validate" => "Sites to validate",
"Searches" => "Searches",
"Visited links" => "Visited links",
"Top Sites" => "Top Sites",
"Featured links" => "Featured links",
"Open operator console" => "Open operator console",
"standard" => "standard",
"secure" => "secure",
"stay in ssl mode" => "stay in ssl mode",
"Tiki Logo" => "Tiki Logo",
"new messages" => "new messages",
"new message" => "new message",
"Waiting Submissions" => "Waiting Submissions",
"submissions waiting to be examined" => "submissions waiting to be examined",
"Old articles" => "Old articles",
"Send a message to" => "Send a message to",
"Random Pages" => "Random Pages",
"in:" => "in:",
"Entire Site" => "Entire Site",
"Blog Posts" => "Blog Posts",
"go" => "go",
"Search Wiki PageName" => "Search Wiki PageName",
"Since your last visit on" => "Since your last visit on",
"click to edit" => "click to edit",
"Top galleries" => "Top galleries",
"User tasks" => "User tasks",
"online user" => "online user",
"sent" => "sent",
"use" => "use",
"Save to notepad" => "Save to notepad",
"Previous page" => "Previous page",
"Next page" => "Next page",
"First page" => "First page",
"Last page" => "Last page",
"To edit the copyright notices" => "To edit the copyright notices",
"discuss" => "discuss",
"1 comment" => "1 comment",
"none" => "none",
"This is" => "This is",
"by the" => "by the",
"dump" => "dump",
"rankings" => "rankings",
"list pages" => "list pages",
"Spellcheck" => "Spellcheck",
"dls" => "dls",
"at tracker" => "at tracker",
"switch" => "switch",
"Find:" => "Find:",
"Sort posts by:" => "Sort posts by:",
"posted by" => "posted by",
"read more" => "read more",
"pages" => "pages",
"Permalink" => "Permalink",
"view comments" => "view comments",
"Trackback pings" => "Trackback pings",
"URI" => "URI",
"RSS" => "RSS",
"Disabled" => "Disabled",
"Number of columns per page when listing categories" => "Number of columns per page when listing categories",
"Links per page" => "Links per page",
"Validate URLs" => "Validate URLs",
"inline frame" => "inline frame",
"Tiki sections and features" => "Tiki sections and features",
"Featured Help" => "Featured Help",
"Workflow engine" => "Workflow engine",
"Show Category Path" => "Show Category Path",
"Show Category Objects" => "Show Category Objects",
"Content Features" => "Content Features",
"Edit Templates" => "Edit Templates",
"Hotwords in New Windows" => "Hotwords in New Windows",
"Custom Home" => "Custom Home",
"Dynamic Content System" => "Dynamic Content System",
"Administration Features" => "Administration Features",
"Banning System" => "Banning System",
"Banning system" => "Banning system",
"Communications (send/receive objects)" => "Communications (send/receive objects)",
"XMLRPC API" => "XMLRPC API",
"General Layout options" => "General Layout options",
"Left column" => "Left column",
"Layout per section" => "Layout per section",
"Right column" => "Right column",
"Admin layout per section" => "Admin layout per section",
"Top bar" => "Top bar",
"Bottom bar" => "Bottom bar",
"please read" => "please read",
"Accept wiki syntax" => "Accept wiki syntax",
"Creation Date (desc)" => "Creation Date (desc)",
"Topics (desc)" => "Topics (desc)",
"Threads (desc)" => "Threads (desc)",
"Last post (desc)" => "Last post (desc)",
"Name (desc)" => "Name (desc)",
"Name (asc)" => "Name (asc)",
"Posts per day" => "Posts per day",
"All galleries" => "All galleries",
"OS" => "OS",
"Unix" => "Unix",
"Windows" => "Windows",
"Display menus as folders" => "Display menus as folders",
"Tikiwiki.org help" => "Tikiwiki.org help",
"Server name (for absolute URIs)" => "Server name (for absolute URIs)",
"Browser title" => "Browser title",
"Wiki_Tiki_Title" => "Wiki_Tiki_Title",
"Temporary directory" => "Temporary directory",
"Sender Email" => "Sender Email",
"Contact user" => "Contact user",
"contact feature disabled" => "contact feature disabled",
"Reg users can change language" => "Reg users can change language",
"Edit or ex/import Languages" => "Edit or ex/import Languages",
"Admin users" => "Admin users",
"User registration and login" => "User registration and login",
"Tiki and HTTP Auth" => "Tiki and HTTP Auth",
"Validate users by email" => "Validate users by email",
"Reg users can change theme" => "Reg users can change theme",
"Require HTTP Basic authentication" => "Require HTTP Basic authentication",
"Allow secure (https) login" => "Allow secure (https) login",
"Require secure (https) login" => "Require secure (https) login",
"HTTP server name" => "HTTP server name",
"HTTP port" => "HTTP port",
"HTTP URL prefix" => "HTTP URL prefix",
"HTTPS server name" => "HTTPS server name",
"HTTPS port" => "HTTPS port",
"HTTPS URL prefix" => "HTTPS URL prefix",
"Remember me feature" => "Remember me feature",
"Only for users" => "Only for users",
"Users and admins" => "Users and admins",
"Duration:" => "Duration:",
"PEAR::Auth" => "PEAR::Auth",
"Create user if not in Tiki?" => "Create user if not in Tiki?",
"Create user if not in Auth?" => "Create user if not in Auth?",
"Just use Tiki auth for admin?" => "Just use Tiki auth for admin?",
"LDAP Scope" => "LDAP Scope",
"LDAP Base DN" => "LDAP Base DN",
"LDAP User DN" => "LDAP User DN",
"LDAP User Attribute" => "LDAP User Attribute",
"LDAP User OC" => "LDAP User OC",
"LDAP Group DN" => "LDAP Group DN",
"LDAP Group Attribute" => "LDAP Group Attribute",
"LDAP Group OC" => "LDAP Group OC",
"LDAP Member Attribute" => "LDAP Member Attribute",
"LDAP Member Is DN" => "LDAP Member Is DN",
"LDAP Admin User" => "LDAP Admin User",
"LDAP Admin Pwd" => "LDAP Admin Pwd",
"<b>Feed</b>" => "<b>Feed</b>",
"<b>enable/disable</b>" => "<b>enable/disable</b>",
"<b>Max number of items</b>" => "<b>Max number of items</b>",
"Content" => "Content",
"change" => "change",
"Allow viewing HTML mails?" => "Allow viewing HTML mails?",
"Maximum size for each attachment" => "Maximum size for each attachment",
"Add or edit a rule" => "Add or edit a rule",
"Rule title" => "Rule title",
"Username regex matching" => "Username regex matching",
"IP regex matching" => "IP regex matching",
"Banned from sections" => "Banned from sections",
"Rule activated by dates" => "Rule activated by dates",
"Rule active from" => "Rule active from",
"Rule active until" => "Rule active until",
"Custom message to the user" => "Custom message to the user",
"Rules" => "Rules",
"x" => "x",
"User/IP" => "User/IP",
"Sections" => "Sections",
"ID" => "ID",
"loc" => "loc",
"cat" => "cat",
"lang" => "lang",
"prio" => "prio",
"Custom Locations" => "Custom Locations",
"yes" => "yes",
"Custom Categories" => "Custom Categories",
"Custom Languages" => "Custom Languages",
"Custom Priorities" => "Custom Priorities",
"Child categories" => "Child categories",
"URL" => "URL",
"Chart items" => "Chart items",
"No items defined yet" => "No items defined yet",
"Admin charts" => "Admin charts",
"Add or edit a chart" => "Add or edit a chart",
"Users can suggest new items" => "Users can suggest new items",
"Auto validate user suggestions" => "Auto validate user suggestions",
"Ranking shows" => "Ranking shows",
"All items" => "All items",
"Top 10 items" => "Top 10 items",
"Top 20 items" => "Top 20 items",
"Top 40 items" => "Top 40 items",
"Top 50 items" => "Top 50 items",
"Top 100 items" => "Top 100 items",
"Top 250 items" => "Top 250 items",
"Rank 1..5" => "Rank 1..5",
"Rank 1..10" => "Rank 1..10",
"Ranking frequency" => "Ranking frequency",
"Realtime" => "Realtime",
"Show Average" => "Show Average",
"Users can vote again after" => "Users can vote again after",
"Anytime" => "Anytime",
"5 minutes" => "5 minutes",
"1 day" => "1 day",
"1 week" => "1 week",
"1 month" => "1 month",
"Ranks" => "Ranks",
"No charts defined yet" => "No charts defined yet",
"Admin templates" => "Admin templates",
"Edit this template:" => "Edit this template:",
"Create new template" => "Create new template",
"use in cms" => "use in cms",
"use in wiki" => "use in wiki",
"use in newsletters" => "use in newsletters",
"use in HTML pages" => "use in HTML pages",
"template" => "template",
"Templates" => "Templates",
"sections" => "sections",
"Available drawings" => "Available drawings",
"Ver" => "Ver",
"Create/edit dsn" => "Create/edit dsn",
"dsn" => "dsn",
"Admin external wikis" => "Admin external wikis",
"URL (use \$page to be replaced by the page name in the URL example: http://www.example.com/tiki-index.php?page=\$page)" => "URL (use \$page to be replaced by the page name in the URL example: http://www.example.com/tiki-index.php?page=\$page)",
"extwiki" => "extwiki",
"coms" => "coms",
"age" => "age",
"ppd" => "ppd",
"last post" => "last post",
"Admin Hotwords" => "Admin Hotwords",
"Add Hotword" => "Add Hotword",
"Word" => "Word",
"Admin HTML pages" => "Admin HTML pages",
"Edit this page" => "Edit this page",
"View page" => "View page",
"Edit zone" => "Edit zone",
"Zone" => "Zone",
"Dynamic zones" => "Dynamic zones",
"zone" => "zone",
"content" => "content",
"Mass update" => "Mass update",
"Create new HTML page" => "Create new HTML page",
"Edit this HTML page:" => "Edit this HTML page:",
"Page name" => "Page name",
"Dynamic" => "Dynamic",
"Static" => "Static",
"Refresh rate (if dynamic) [secs]" => "Refresh rate (if dynamic) [secs]",
"Admin layout" => "Admin layout",
"layout options" => "layout options",
"Generate positions by hits" => "Generate positions by hits",
"List of featured links" => "List of featured links",
"url" => "url",
"Add Featured Link" => "Add Featured Link",
"Edit this Featured Link:" => "Edit this Featured Link:",
"Create new Featured Link" => "Create new Featured Link",
"disables the link" => "disables the link",
"Link type" => "Link type",
"replace current page" => "replace current page",
"framed" => "framed",
"open new window" => "open new window",
"wiki-get" => "wiki-get",
"wiki-put" => "wiki-put",
"wiki-append" => "wiki-append",
"Edit menu options" => "Edit menu options",
"Some useful URLs" => "Some useful URLs",
"section" => "section",
"Home Image Gal" => "Home Image Gal",
"Home Image Gallery" => "Home Image Gallery",
"Home File Gal" => "Home File Gal",
"Home File Gallery" => "Home File Gallery",
"List image galleries" => "List image galleries",
"Gallery Rankings" => "Gallery Rankings",
"Browse a gallery" => "Browse a gallery",
"Submit" => "Submit",
"Admin Menus" => "Admin Menus",
"Edit this Menu:" => "Edit this Menu:",
"dynamic collapsed" => "dynamic collapsed",
"dynamic extended" => "dynamic extended",
"fixed" => "fixed",
"\n<b>Note 1</b>: if you allow your users to configure modules then assigned\nmodules won't be reflected in the screen until you configure them\nfrom MyTiki->modules.<br />\n<b>Note 2</b>: If you assign modules to groups make sure that you\nhave turned off the option 'display modules to all groups always'\nfrom Admin->General\n" => "\n<b>Note 1</b>: if you allow your users to configure modules then assigned\nmodules won't be reflected in the screen until you configure them\nfrom MyTiki->modules.<br />\n<b>Note 2</b>: If you assign modules to groups make sure that you\nhave turned off the option 'display modules to all groups always'\nfrom Admin->General\n",
"Cache Time" => "Cache Time",
"Rows" => "Rows",
"rows" => "rows",
"Edit this user module:" => "Edit this user module:",
"create/edit" => "create/edit",
"Objects that can be included" => "Objects that can be included",
"Available polls" => "Available polls",
"use poll" => "use poll",
"Random image from" => "Random image from",
"use gallery" => "use gallery",
"Dynamic content blocks" => "Dynamic content blocks",
"use dynamic  content" => "use dynamic  content",
"use rss module" => "use rss module",
"use menu" => "use menu",
"Banner zones" => "Banner zones",
"use banner zone" => "use banner zone",
"subscribed" => "subscribed",
"Admin RSS modules" => "Admin RSS modules",
"Content for the feed" => "Content for the feed",
"Edit this RSS module:" => "Edit this RSS module:",
"Create new RSS module" => "Create new RSS module",
"Rss channels" => "Rss channels",
"Last update" => "Last update",
"export pages" => "export pages",
"One choice" => "One choice",
"Multiple choices" => "Multiple choices",
"Short text" => "Short text",
"Rate (1..5)" => "Rate (1..5)",
"Rate (1..10)" => "Rate (1..10)",
"Options (if apply)" => "Options (if apply)",
"status" => "status",
"files" => "files",
"topic image" => "topic image",
"Id" => "Id",
"Number of displayed rows" => "Number of displayed rows",
"Includes" => "Includes",
"Added users" => "Added users",
"Rejected users" => "Rejected users",
"Reason" => "Reason",
"Never" => "Never",
"Back to groups" => "Back to groups",
"Create level" => "Create level",
"level" => "level",
"to groups" => "to groups",
"to" => "to",
"backlinks to" => "backlinks to",
"No backlinks to this page" => "No backlinks to this page",
"List of available backups" => "List of available backups",
"Restoring a backup" => "Restoring a backup",
"Restoring a backup destoys all the data in your Tiki database. All your tables will be replaced with the information in the backup." => "Restoring a backup destoys all the data in your Tiki database. All your tables will be replaced with the information in the backup.",
"Create new backup" => "Create new backup",
"Creating backups may take a long time. If the process is not completed you will see a blank screen. If so you need to increment the maximum script execution time from your php.ini file" => "Creating backups may take a long time. If the process is not completed you will see a blank screen. If so you need to increment the maximum script execution time from your php.ini file",
"Upload a backup" => "Upload a backup",
"Upload backup" => "Upload backup",
"Process" => "Process",
"Upload image for this post" => "Upload image for this post",
"stop" => "stop",
"Image size" => "Image size",
"imagescale" => "imagescale",
"details" => "details",
"h" => "h",
"+" => "+",
"Location" => "Location",
"Organized by" => "Organized by",
"Participants" => "Participants",
"or create a new category" => "or create a new category",
"or create a new location" => "or create a new location",
"comma separated usernames" => "comma separated usernames",
"comma separated username:role" => "comma separated username:role",
"with roles" => "with roles",
"Chair" => "Chair",
"Optional" => "Optional",
"Change password enforced" => "Change password enforced",
"Browser not supported" => "Browser not supported",
"Channel Information" => "Channel Information",
"Ratio" => "Ratio",
"Textheight" => "Textheight",
"Height of top Heading" => "Height of top Heading",
"Height of mid Heading" => "Height of mid Heading",
"Height of inner Heading" => "Height of inner Heading",
"tbheight" => "tbheight",
"Select Wiki Pages" => "Select Wiki Pages",
"reset" => "reset",
"Structure" => "Structure",
"Tiki Debugger Console" => "Tiki Debugger Console",
"Close" => "Close",
"Current URL" => "Current URL",
"Command" => "Command",
"exec" => "exec",
"Type <code>help</code> to get list of available commands" => "Type <code>help</code> to get list of available commands",
"Random sub-categories" => "Random sub-categories",
"Editor group" => "Editor group",
"cType" => "cType",
"any" => "any",
"in entire directory" => "in entire directory",
"in current category" => "in current category",
"creation date (desc)" => "creation date (desc)",
"creation date (asc)" => "creation date (asc)",
"last updated (desc)" => "last updated (desc)",
"last updated (asc)" => "last updated (asc)",
"sort" => "sort",
"Added" => "Added",
"Last updated" => "Last updated",
"Max impressions" => "Max impressions",
"create zone" => "create zone",
"Show the banner only on" => "Show the banner only on",
"Select ONE method for the banner" => "Select ONE method for the banner",
"Use HTML" => "Use HTML",
"HTML code" => "HTML code",
"Use image" => "Use image",
"Image:" => "Image:",
"Current Image" => "Current Image",
"Use image generated by URL (the image will be requested at the URL for each impression)" => "Use image generated by URL (the image will be requested at the URL for each impression)",
"Use text" => "Use text",
"Text" => "Text",
"save the banner" => "save the banner",
"Current heading" => "Current heading",
"Edit Style Sheet" => "Edit Style Sheet",
"Style Sheet" => "Style Sheet",
"choose a stylesheet" => "choose a stylesheet",
"try" => "try",
"File with names appended by -{\$user} are modifiable, others are only duplicable and be used as model." => "File with names appended by -{\$user} are modifiable, others are only duplicable and be used as model.",
"Show Plugins Help" => "Show Plugins Help",
"some text" => "some text",
"Creates a box with the data" => "Creates a box with the data",
"Box content" => "Box content",
"Title bar" => "Title bar",
"creates a title bar" => "creates a title bar",
"Colored text" => "Colored text",
"Lists" => "Lists",
"for bullet lists" => "for bullet lists",
"for numbered lists" => "for numbered lists",
"for definiton lists" => "for definiton lists",
"Wiki References" => "Wiki References",
"JoinCapitalizedWords or use" => "JoinCapitalizedWords or use",
"page|desc" => "page|desc",
"for wiki references" => "for wiki references",
"SomeName" => "SomeName",
"prevents referencing" => "prevents referencing",
"External links" => "External links",
"Tables" => "Tables",
"creates a table" => "creates a table",
"displays an image" => "displays an image",
"Non cacheable images" => "Non cacheable images",
"makes a horizontal rule" => "makes a horizontal rule",
"creates the editable drawing foo" => "creates the editable drawing foo",
"Multi-page pages" => "Multi-page pages",
"RSS feeds" => "RSS feeds",
"Will be replaced by the actual value of the dynamic content block with id=n" => "Will be replaced by the actual value of the dynamic content block with id=n",
"Non parsed sections" => "Non parsed sections",
"Misc" => "Misc",
"Show Text Formatting Rules" => "Show Text Formatting Rules",
"No description available" => "No description available",
"bold" => "bold",
"external link" => "external link",
"special chars" => "special chars",
"special characters" => "special characters",
"Edit Image" => "Edit Image",
"Edit successful!" => "Edit successful!",
"Edit and create Languages" => "Edit and create Languages",
"Im- Export Languages" => "Im- Export Languages",
"Edit and create languages" => "Edit and create languages",
"Create Language" => "Create Language",
"Shortname" => "Shortname",
"like" => "like",
"Longname" => "Longname",
"Select the language to edit" => "Select the language to edit",
"Add a translation" => "Add a translation",
"Edit translations" => "Edit translations",
"Translate recorded" => "Translate recorded",
"Original" => "Original",
"Translation" => "Translation",
"translate" => "translate",
"reset table" => "reset table",
"Program dynamic content for block" => "Program dynamic content for block",
"create new block" => "create new block",
"Return to block listing" => "Return to block listing",
"Block description: " => "Block description: ",
"Create or edit content" => "Create or edit content",
"You are editing block:" => "You are editing block:",
"Publishing date" => "Publishing date",
"Publishing Date" => "Publishing Date",
"From Points" => "From Points",
"To Points" => "To Points",
"You will remove" => "You will remove",
"Remove only from structure" => "Remove only from structure",
"Available templates" => "Available templates",
"Name-filename" => "Name-filename",
"Filename only" => "Filename only",
"Max description display size" => "Max description display size",
"Available File Galleries" => "Available File Galleries",
"Message queue for" => "Message queue for",
"Edit queued message" => "Edit queued message",
"make this a thread of" => "make this a thread of",
"None, this is a thread message" => "None, this is a thread message",
"summary" => "summary",
"normal" => "normal",
"announce" => "announce",
"hot" => "hot",
"sticky" => "sticky",
"no feeling" => "no feeling",
"frown" => "frown",
"exclaim" => "exclaim",
"idea" => "idea",
"mad" => "mad",
"neutral" => "neutral",
"sad" => "sad",
"happy" => "happy",
"wink" => "wink",
"save and approve" => "save and approve",
"convert to topic" => "convert to topic",
"List of messages" => "List of messages",
"new topic" => "new topic",
"no summary" => "no summary",
"No messages queued yet" => "No messages queued yet",
"reject" => "reject",
"Reported messages for" => "Reported messages for",
"Reported by" => "Reported by",
"Activity completed" => "Activity completed",
"Admin process activities" => "Admin process activities",
"Add or edit an activity" => "Add or edit an activity",
"end" => "end",
"split" => "split",
"join" => "join",
"standalone" => "standalone",
"interactive" => "interactive",
"auto routed" => "auto routed",
"Add transitions" => "Add transitions",
"Add transition from:" => "Add transition from:",
"Add transition to:" => "Add transition to:",
"roles" => "roles",
"Add role" => "Add role",
"add new" => "add new",
"add role" => "add role",
"Process activities" => "Process activities",
"Int" => "Int",
"Routing" => "Routing",
"Interactive" => "Interactive",
"Automatic" => "Automatic",
"Auto routed" => "Auto routed",
"Manual" => "Manual",
"#" => "#",
"inter" => "inter",
"route" => "route",
"(no roles)" => "(no roles)",
"No activities defined yet" => "No activities defined yet",
"Process Transitions" => "Process Transitions",
"List of transitions" => "List of transitions",
"From:" => "From:",
"Origin" => "Origin",
"No transitions defined yet" => "No transitions defined yet",
"Add a transition" => "Add a transition",
"This process is invalid" => "This process is invalid",
"List of processes" => "List of processes",
"Inactive" => "Inactive",
"act" => "act",
"val" => "val",
"active process" => "active process",
"invalid" => "invalid",
"invalid process" => "invalid process",
"valid process" => "valid process",
"activities" => "activities",
"graph" => "graph",
"new minor" => "new minor",
"new major" => "new major",
"No processes defined yet" => "No processes defined yet",
"Admin instance" => "Admin instance",
"Process:" => "Process:",
"Instance" => "Instance",
"Workitems" => "Workitems",
"exception" => "exception",
"aborted" => "aborted",
"Owner" => "Owner",
"Send all to" => "Send all to",
"Don't move" => "Don't move",
"Activities" => "Activities",
"Act status" => "Act status",
"Properties" => "Properties",
"Property" => "Property",
"Value" => "Value",
"Add property" => "Add property",
"value" => "value",
"run instance" => "run instance",
"Add or edit a process" => "Add or edit a process",
"Process Name" => "Process Name",
"ver:" => "ver:",
"is active?" => "is active?",
"Admin process roles" => "Admin process roles",
"Add or edit a role" => "Add or edit a role",
"Process roles" => "Process roles",
"No roles defined yet" => "No roles defined yet",
"Map users to roles" => "Map users to roles",
"Map" => "Map",
"Roles" => "Roles",
"map" => "map",
"Map groups to roles" => "Map groups to roles",
"Operation" => "Operation",
"Warning" => "Warning",
"List of mappings" => "List of mappings",
"No mappings defined yet" => "No mappings defined yet",
"Admin process sources" => "Admin process sources",
"select source" => "select source",
"Shared code" => "Shared code",
"Set next user" => "Set next user",
"Get property" => "Get property",
"Set property" => "Set property",
"Complete" => "Complete",
"Process form" => "Process form",
"Set Next act" => "Set Next act",
"If:SetNextact" => "If:SetNextact",
"Map process roles" => "Map process roles",
"admin processes" => "admin processes",
"admin activities" => "admin activities",
"admin roles" => "admin roles",
"edit this process" => "edit this process",
"List of activities" => "List of activities",
"proc" => "proc",
"auto" => "auto",
"int" => "int",
"routing" => "routing",
"Instances" => "Instances",
"run" => "run",
"run activity" => "run activity",
"monitor" => "monitor",
"monitor processes" => "monitor processes",
"monitor activities" => "monitor activities",
"monitor instances" => "monitor instances",
"monitor workitems" => "monitor workitems",
"List of instances" => "List of instances",
"No instances created yet" => "No instances created yet",
"Valid" => "Valid",
"Invalid" => "Invalid",
"processes" => "processes",
"being run" => "being run",
"exceptions" => "exceptions",
"Monitor workitems" => "Monitor workitems",
"List of workitems" => "List of workitems",
"instance" => "instance",
"exception instance" => "exception instance",
"exceptions instance" => "exceptions instance",
"send instance" => "send instance",
"abort instance" => "abort instance",
"grab instance" => "grab instance",
"release instance" => "release instance",
"activate" => "activate",
"User Activities" => "User Activities",
"process" => "process",
"user processes" => "user processes",
"user activities" => "user activities",
"user instances" => "user instances",
"Inst Status" => "Inst Status",
"No instances defined yet" => "No instances defined yet",
"Browsing Workitem" => "Browsing Workitem",
"Workitem information" => "Workitem information",
"Im- Export languages" => "Im- Export languages",
"Select the language to Import" => "Select the language to Import",
"Select the language to Export" => "Select the language to Export",
"excerpt" => "excerpt",
"result" => "result",
"Search by Date" => "Search by Date",
"Found" => "Found",
"No pages found" => "No pages found",
"Method" => "Method",
"Use Dates?" => "Use Dates?",
"Max Impressions" => "Max Impressions",
"Impressions" => "Impressions",
"Clicks" => "Clicks",
"Dynamic content system" => "Dynamic content system",
"Create or edit content block" => "Create or edit content block",
"Available content blocks" => "Available content blocks",
"Current ver" => "Current ver",
"Next ver" => "Next ver",
"Old vers" => "Old vers",
"Program" => "Program",
"Edit a file using this form" => "Edit a file using this form",
"Move to" => "Move to",
"Dls" => "Dls",
"All games are from" => "All games are from",
"Upload a game" => "Upload a game",
"Upload a new game" => "Upload a new game",
"Flash binary (.sqf or .dcr)" => "Flash binary (.sqf or .dcr)",
"Thumbnail (if the game is foo.swf the thumbnail must be named foo.swf.gif or foo.swf.png or foo.swf.jpg)" => "Thumbnail (if the game is foo.swf the thumbnail must be named foo.swf.gif or foo.swf.png or foo.swf.jpg)",
"Edit game" => "Edit game",
"Played" => "Played",
"times" => "times",
"If you can't see the game then you need a flash plugin for your browser" => "If you can't see the game then you need a flash plugin for your browser",
"Approve" => "Approve",
"Open client window" => "Open client window",
"Generate HTML" => "Generate HTML",
"Transcripts" => "Transcripts",
"Support tickets" => "Support tickets",
"Online operators" => "Online operators",
"Operator" => "Operator",
"Accepted requests" => "Accepted requests",
"transcripts" => "transcripts",
"Offline operators" => "Offline operators",
"Add an operator to the system" => "Add an operator to the system",
"Operators must be tiki users" => "Operators must be tiki users",
"set as operator" => "set as operator",
"Chat started" => "Chat started",
"User:" => "User:",
"Operator:" => "Operator:",
"Live support:User window" => "Live support:User window",
"Request live support" => "Request live support",
"Request support" => "Request support",
"Open a support ticket instead" => "Open a support ticket instead",
"Your request is being processed" => "Your request is being processed",
"cancel request and exit" => "cancel request and exit",
"Live support:Console" => "Live support:Console",
"be online" => "be online",
"be offline" => "be offline",
"Support requests" => "Support requests",
"Requested" => "Requested",
"Accept" => "Accept",
"Join" => "Join",
"Support chat transcripts" => "Support chat transcripts",
"back to admin" => "back to admin",
"started" => "started",
"reason" => "reason",
"msgs" => "msgs",
"Transcript" => "Transcript",
"Thanks for your subscription. You will receive an email soon to confirm your subscription. No newsletters will be sent to you until the subscription is confirmed." => "Thanks for your subscription. You will receive an email soon to confirm your subscription. No newsletters will be sent to you until the subscription is confirmed.",
"Subscription confirmed!" => "Subscription confirmed!",
"Subscribe to newsletter" => "Subscribe to newsletter",
"Email:" => "Email:",
"Subscribe" => "Subscribe",
"Select news group" => "Select news group",
"Back to servers" => "Back to servers",
"Msgs" => "Msgs",
"Save position" => "Save position",
"Reading article from" => "Reading article from",
"Back to list of articles" => "Back to list of articles",
"First" => "First",
"Reading note:" => "Reading note:",
"List notes" => "List notes",
"Write note" => "Write note",
"wiki create" => "wiki create",
"wiki overwrite" => "wiki overwrite",
"back" => "back",
"Published" => "Published",
"Average" => "Average",
"Vote poll" => "Vote poll",
"Time" => "Time",
"User answers" => "User answers",
"Av score" => "Av score",
"Av time" => "Av time",
"Top 10" => "Top 10",
"Top 20" => "Top 20",
"Top 50" => "Top 50",
"Top 100" => "Top 100",
"Use Image" => "Use Image",
"Image x size" => "Image x size",
"Image y size" => "Image y size",
"Image name" => "Image name",
"to_version" => "to_version",
"searched" => "searched",
"Search in" => "Search in",
"Send post to this addresses" => "Send post to this addresses",
"cool" => "cool",
"pvs" => "pvs",
"Mb" => "Mb",
"Time Left" => "Time Left",
"send answers" => "send answers",
"Result" => "Result",
"Theme Control Center: categories" => "Theme Control Center: categories",
"Theme is selected as follows" => "Theme is selected as follows",
"If a theme is assigned to the individual object that theme is used." => "If a theme is assigned to the individual object that theme is used.",
"If not then if a theme is assigned to the object's category that theme is used" => "If not then if a theme is assigned to the object's category that theme is used",
"Finally if the user didn't select a theme the default theme is used" => "Finally if the user didn't select a theme the default theme is used",
"Control by Sections" => "Control by Sections",
"theme" => "theme",
"Theme Control Center: Objects" => "Theme Control Center: Objects",
"Control by Categories" => "Control by Categories",
"Theme Control Center: sections" => "Theme Control Center: sections",
"File Title" => "File Title",
"Now enter the file URL" => "Now enter the file URL",
"Batch upload" => "Batch upload",
"You can download this file using" => "You can download this file using",
"User_versions_for" => "User_versions_for",
"Create new banner" => "Create new banner",
"Banner Information" => "Banner Information",
"Click ratio" => "Click ratio",
"Weekdays" => "Weekdays",
"Banner raw data" => "Banner raw data",
"Cached" => "Cached",
"viewed" => "viewed",
"edit items" => "edit items",
"list charts" => "list charts",
"last chart" => "last chart",
"previous chart" => "previous chart",
"Chart created" => "Chart created",
"next chart" => "next chart",
"pos" => "pos",
"pre" => "pre",
"item" => "item",
"chg" => "chg",
"avg" => "avg",
"Next chart will be generated on" => "Next chart will be generated on",
"Item information" => "Item information",
"Chart" => "Chart",
"Permanency" => "Permanency",
"Dif" => "Dif",
"Best Position" => "Best Position",
"Highest" => "Highest",
"Q" => "Q",
"A" => "A",
"Your message has been queued for approval, the message will be posted after\na moderator approves it." => "Your message has been queued for approval, the message will be posted after\na moderator approves it.",
"Summary" => "Summary",
"moderator actions" => "moderator actions",
"move selected topics" => "move selected topics",
"unlock selected topics" => "unlock selected topics",
"lock selected topics" => "lock selected topics",
"delete selected topics" => "delete selected topics",
"merge" => "merge",
"merge selected topics" => "merge selected topics",
"reported messages:" => "reported messages:",
"queued messages:" => "queued messages:",
"Merge into topic" => "Merge into topic",
"pts" => "pts",
"No topics yet" => "No topics yet",
"Show posts" => "Show posts",
"Last hour" => "Last hour",
"Last 24 hours" => "Last 24 hours",
"Last 48 hours" => "Last 48 hours",
" unread private messages" => " unread private messages",
"prev topic" => "prev topic",
"next topic" => "next topic",
"Msg" => "Msg",
"You do not have permission to edit this banner" => "You do not have permission to edit this banner",
"You do not have permission to write the style sheet" => "You do not have permission to write the style sheet",
"Invalid request to edit an image" => "Invalid request to edit an image",
"Permission denied you cannot edit images" => "Permission denied you cannot edit images",
"Permission denied you can edit images but not in this gallery" => "Permission denied you can edit images but not in this gallery",
"Failed to edit the image" => "Failed to edit the image",
"Shortname must be 2 Characters" => "Shortname must be 2 Characters",
"You must provide a longname" => "You must provide a longname",
"Language created" => "Language created",
"Permission denied you cannot send submissions" => "Permission denied you cannot send submissions",
"Permission denied you cannot edit submissions" => "Permission denied you cannot edit submissions",
"You have to create a topic first" => "You have to create a topic first",
"You do not have permission to do that" => "You do not have permission to do that",
"You do not have permission to read the template" => "You do not have permission to read the template",
"Permission denied you cannot edit this page" => "Permission denied you cannot edit this page",
"page imported" => "page imported",
"created from import" => "created from import",
"You cannot edit this page because it is a user personal page" => "You cannot edit this page because it is a user personal page",
"Cannot edit page because it is locked" => "Cannot edit page because it is locked",
"Permission denied you cannot create galleries and so you cant edit them" => "Permission denied you cannot create galleries and so you cant edit them",
"Permission denied you cannot edit this gallery" => "Permission denied you cannot edit this gallery",
"Permission denied you cannot remove this gallery" => "Permission denied you cannot remove this gallery",
"Top visited file galleries" => "Top visited file galleries",
"Most downloaded files" => "Most downloaded files",
"Last files" => "Last files",
"Activity name already exists" => "Activity name already exists",
"indicates if the process is active. Invalid processes cant be active" => "indicates if the process is active. Invalid processes cant be active",
"The process name already exists" => "The process name already exists",
"Process already exists" => "Process already exists",
"You cant execute this activity" => "You cant execute this activity",
"Top images" => "Top images",
"Last images" => "Last images",
"overwriting old page" => "overwriting old page",
"page created" => "page created",
"Permission denied you cannot view pages like this page" => "Permission denied you cannot view pages like this page",
"Permission denied you cannot remove articles" => "Permission denied you cannot remove articles",
"Permission denied you cannot remove banners" => "Permission denied you cannot remove banners",
"Non-existent gallery" => "Non-existent gallery",
"Permission denied you cannot remove files from this gallery" => "Permission denied you cannot remove files from this gallery",
"Permission denied you can't upload files so you can't edit them" => "Permission denied you can't upload files so you can't edit them",
"Permission denied you cannot edit this file" => "Permission denied you cannot edit this file",
"The thumbnail name must be" => "The thumbnail name must be",
"Permission denied you cannot remove submissions" => "Permission denied you cannot remove submissions",
"Permission denied you cannot approve submissions" => "Permission denied you cannot approve submissions",
"Permission denied you cannot view pages" => "Permission denied you cannot view pages",
"Permission denied you cannot remove pages" => "Permission denied you cannot remove pages",
"Must be logged to use this feature" => "Must be logged to use this feature",
"Welcome at Hawiki" => "Welcome at Hawiki",
"This TikiWiki site is prepared for access from a lot of mobile devices, e.g. WAP phones, PDA's, i-mode devices and much more." => "This TikiWiki site is prepared for access from a lot of mobile devices, e.g. WAP phones, PDA's, i-mode devices and much more.",
"You can browse this site on your mobile device by directing your device's browser towards the following URL here on this site:" => "You can browse this site on your mobile device by directing your device's browser towards the following URL here on this site:",
"tiki-mobile.php" => "tiki-mobile.php",
"About" => "About",
"You must log in to use this feature" => "You must log in to use this feature",
"You do not have permission to view other users data" => "You do not have permission to view other users data",
"You must be logged in to subscribe to newsletters" => "You must be logged in to subscribe to newsletters",
"Cannot connect to" => "Cannot connect to",
"Missing information to read news (server,port,username,password,group) required" => "Missing information to read news (server,port,username,password,group) required",
"Cannot get messages" => "Cannot get messages",
"merged note:" => "merged note:",
"File is too big" => "File is too big",
"created from notepad" => "created from notepad",
"Not enough information to display this page" => "Not enough information to display this page",
"Permission denied you cannot browse this page history" => "Permission denied you cannot browse this page history",
"Article is not published yet" => "Article is not published yet",
"Post recommendation at" => "Post recommendation at",
" successfully sent" => " successfully sent",
" not sent" => " not sent",
"You do not have permission to edit messages" => "You do not have permission to edit messages",
"Page must be defined inside a structure to use this feature" => "Page must be defined inside a structure to use this feature",
"Quiz time limit exceeded quiz cannot be computed" => "Quiz time limit exceeded quiz cannot be computed",
"Please create a category first" => "Please create a category first",
"Invalid filename (using filters for filenames)" => "Invalid filename (using filters for filenames)",
"No permission to upload zipped file packages" => "No permission to upload zipped file packages",
"Cannot read file" => "Cannot read file",
"Permission denied you cannot upload files" => "Permission denied you cannot upload files",
"Permission denied you can upload files but not to this file gallery" => "Permission denied you can upload files but not to this file gallery",
"Error processing zipped image package" => "Error processing zipped image package",
"No permission to upload zipped image packages" => "No permission to upload zipped image packages",
"Permission denied you cannot upload images" => "Permission denied you cannot upload images",
"Permission denied you can upload images but not to this gallery" => "Permission denied you can upload images but not to this gallery",
"Cannot get image from URL" => "Cannot get image from URL",
"That is not an image (or you have php < 4.0.5)" => "That is not an image (or you have php < 4.0.5)",
"cannot process upload" => "cannot process upload",
"No url indicated" => "No url indicated",
"You are not logged in and no user indicated" => "You are not logged in and no user indicated",
"The user has chosen to make his information private" => "The user has chosen to make his information private",
"Cannot upload this file not enough quota" => "Cannot upload this file not enough quota",
"Permission denied you cannot remove the post" => "Permission denied you cannot remove the post",
"No cache information available" => "No cache information available",
"Wrong password. Cannot post comment" => "Wrong password. Cannot post comment",
"Please wait 2 minutes between posts" => "Please wait 2 minutes between posts",
"Your email address has been removed from the list of addresses monitoring this tracker" => "Your email address has been removed from the list of addresses monitoring this tracker",
"Your email address has been added to the list of addresses monitoring this tracker" => "Your email address has been added to the list of addresses monitoring this tracker",
"Your email address has been removed from the list of addresses monitoring this item" => "Your email address has been removed from the list of addresses monitoring this item",
"Your email address has been added to the list of addresses monitoring this item" => "Your email address has been added to the list of addresses monitoring this item",
"No subject" => "No subject",
"Your email was sent" => "Your email was sent",
// ###
// ### end of possibly untranslated words
// ###

"This script cannot be called directly" => "このスクリップトを直接呼び出すことができない",
"Missing title or body when trying to post a comment" => "コメントをポストする時、タイトルや本文はありませんでした",
"The copyright management feature is not enabled." => "著作権管理機能は無効に設定してあります",
"You do not have permission to use this feature." => "この機能を使う権限はありません",
"You do not have permission to use this feature" => "この機能の利用は許可されてません",
"This feature is disabled" => "この機能は無効になってます",
"Algeria" => "アルジェリア人民民主共和国",
"American_Samoa" => "サモア諸島",
"Angola" => "アンゴラ人民共和国",
"Antigua" => "アンティグア",
"Argentina" => "アルゼンチン共和国",
"Armenia" => "アルメニア",
"Australia" => "オーストラリア",
"Austria" => "オーストリア",
"Bahamas" => "バハマ国",
"Bahrain" => "バハレーン国",
"Bangladesh" => "バングラデシュ",
"Barbados" => "バルバドス",
"Belarus" => "ベラルーシ",
"Belgium" => "白耳義",
"Bermuda" => "バーミューダ",
"Bolivia" => "ボリビア共和国",
"Brazil" => "ブラジル",
"Brunei" => "ブルネイ",
"Canada" => "カナダ",
"Cayman_Islands" => "ケーマン諸島",
"Colombia" => "コロムビア",
"Cook_Islands" => "クック諸島",
"Costa_Rica" => "コスタリカ",
"Croatia" => "クロアチア",
"Cuba" => "キューバ",
"Cyprus" => "キプロス",
"Czech_Republic" => "チェコ",
"Denmark" => "デンマーク",
"Dominican_Republic" => "ドミニカ",
"Ecuador" => "エクアドル",
"Egypt" => "エジプト",
"El_Salvador" => "サルバドル",
"Estonia" => "エストニア",
"Federated_States_of_Micronesia" => "ミクロネシア",
"Fiji" => "フィジー",
"Finland" => "フィンランド",
"France" => "フランス",
"French_Polynesia" => "フランスポリネシア",
"Germany" => "ドイツ",
"Greece" => "ギリシア",
"Guam" => "グアム島",
"Guatemala" => "グアテマラ共和国",
"Haiti" => "ハイチ島",
"Honduras" => "ンジュラス共和国",
"Hungary" => "ハンガリー共和国",
"Chile" => "チリ",
"China" => "中国",
"Iceland" => "アイスランド",
"India" => "インド",
"Indonesia" => "インドネシア",
"Iran" => "イラン",
"Iraq" => "イラク",
"Ireland" => "アイルランド",
"Israel" => "イスラエル",
"Italy" => "イタリア",
"Ivory_Coast" => "象牙海岸",
"Jamaica" => "ジャマイカ",
"Japan" => "日本",
"Jordan" => "ヨルダン",
"Kenya" => "ケニア",
"None" => "なし",
"Japanese" => "日本語",
"Activity" => "アクティビティー",
"refresh" => "更新",
"The file is not a CSV file or has not a correct syntax" => "ファイルはCSV形式じゃないか、シンタックスに誤りがあります",
"article" => "記事",
"blog" => "ブログ",
"directory" => "ディレクタリー",
"faq" => "FAQ",
"forum" => "フォーラム",
"poll" => "アンケート",
"quiz" => "クイズ",
"tracker" => "トラッカー",
"image" => "画像",
"calendar" => "カレンダー",
"Wiki Home" => "Wiki ホーム",
"Home" => "ホーム",
"Blogs" => "ブログ",
"Blog" => "ブログ",
"Continue" => "続く",
"Articles" => "記事",
"By:" => "作者:",
"Read" => "既読",
"List articles" => "記事の一覧",
"Forums" => "フォーラム",
"Last post" => "最近のポスト",
"Wiki top pages" => "Wikiトップ・ランキング",
"Hits" => "ヒット数",
"Most relevant pages" => "一番関係のあるページ",
"Modified" => "修正",
"Forums last topics" => "最近のフォーラム・トピック",
"Forums most read topics" => "閲覧数の多いフォーラム・トピック",
"Reads" => "閲覧数",
"Forums best topics" => "フォーラムのベスト・トピック",
"Score" => "点数",
"Forums most visited forums" => "アクセス数の多いフォーラム",
"Visits" => "アクセス数",
"Forums with most posts" => "ポスト数の多いフォーラム",
"Posts" => "ポスト数",
"Wiki top galleries" => "トップ画像ギャラリー",
"Wiki top file galleries" => "トップ・ファイル・ギャラリー",
"Wiki top images" => "トップ画像",
"Wiki top files" => "トップ・ファイル",
"Downloads" => "ダウンロード数",
"Upload date" => "アップロード日",
"Wiki top articles" => "トップ記事",
"Most visited blogs" => "アクセス数の多いブログ",
"Most active blogs" => "アクチブなブログ",
"Blogs last posts" => "最近のブログポスト",
"Post date" => "ポスト日",
"Wiki top authors" => "Wikiのトップ作者",
"Pages" => "ページ",
"Top article authors" => "記事のトップ作者",
"Login" => "ログイン",
"Tracker" => "トラッカー",
"Unknown" => "不特定 Unknown",
"Image Gallery" => "画像ギャラリー",
"Image" => "画像",
"Article" => "記事",
"Directory category" => "ディレクタリーのカテゴリ",
"Directory" => "ディレクタリー",
"Forum" => "フォーラム",
"File Gallery" => "ファイルギャラリー",
"Gallery" => "ギャラリー",
"Blog post" => "ブログ・ポスト",
"Link" => "リンク",
"help" => "ヘルプ",
"from" => "送り主",
"for" => "に",
"Priority" => "重要度",
"%A %d of %B, %Y" => "%Y年%m月%d日 %A",
"%A %d of %B, %Y[%H:%M:%S %Z]" => "%Y年%m月%d日 %A [%H:%M:%S %Z]",
"%a %d of %b, %Y" => "%Y %m/%d %a",
"%a %d of %b, %Y[%H:%M %Z]" => "%Y %m/%d %a [%H:%M %Z]",
"created from structure" => "ストラクチャーから作成した",
"Help" => "ヘルプ",
"faqs" => "FAQ",
"quizzes" => "クイズ",
"blogs" => "ブログ",
"forums" => "フォーラム",
"games" => "ゲーム",
"Click to edit dynamic variable" => "Dynamic変数を変更するのにクリック",
"Update variables" => "変数の更新",
"Created" => "作成日",
"new" => "新規",
"Unknown language" => "知らない言語",
"Click here to confirm your action" => "クリックして操作の確認",
"Sea Surfing (CSRF) detected. Operation blocked." => "Sea Surfing (CSRF) を検出した為、操作を拒否",
"text field" => "テキスト",
"size" => "サイズ",
"textarea" => "textarea編集エリヤー",
"checkbox" => "チェックボックス",
"drop down" => "ドロップダウン",
"user selector" => "ユーザー選択",
"group selector" => "グループ選択",
"date and time" => "日付と時刻",
"action" => "操作",
"category" => "カテゴリ",
"email" => "メールアドレス",
"closed" => "閉",
"message" => "メッセージ",
"(AT)" => "(アット)",
"(DOT)" => "(ドット)",
"Date" => "日付",
"Title" => "タイトル",
"Author" => "著者",
"Include a page" => "ページを含む",
"Include an article" => "記事を含む",
"comment" => "コメント",
"Displays the user Avatar" => "ユーザのアバターを表示する",
"username" => "ユーザー名",
"List all pages which link to specific pages" => "特定のページにリンクするページの一覧を出す",
"No pages links to" => "他のページからのリンクはありません",
"One page links to" => "１ページからのリンクがある",
"pages link to" => "ページからリンクがある",
"Displays a snippet of code" => "コードの一部を表示する",
"days" => "日",
"hours" => "時間",
"minutes" => "分",
"seconds" => "秒",
"cells" => "セル",
"heads and cells separated by ~|~" => "列のヘッドとセルは~|~で区切る",
"description" => "説明",
"Displays the text only if the language matchs" => "言語がマッチする時のみ、テキストを表示する",
"Feature disabled" => "機能が無効です",
"Provides a list of plugins on this wiki." => "このWikiのプラグインの一覧を提供する",
"No version indicated" => "バージョンが指定されてない",
"No arguments indicated" => "Argumentはありません",
"Split a page into rows and columns" => "ページを列と行にSplitする",
"Run a sql query" => "SQLクエリーを実行する",
"sql query" => "SQLクエリー",
"Search the titles of all pages in this wiki" => "このWiki全体のページのタイトルに対して検索する",
"No pages found for title search" => "タイトル検索：ページはありませんでした",
"One page found for title search" => "１つのページをタイトル検索で見つかりました",
" pages found for title search" => "つのページをタイトル検索で見つかりました",
"Save" => "保存",
"at" => "日付・時間帯",
"Links to a translated content" => "翻訳されたコンテンツへリンクする",
"Displays the number of registered users" => "Tiki登録ユーザ数を表示する",
"External Wiki" => "外Wiki",
"failed" => "失敗した",
"You are not logged in" => "ログインされてません",
"Permission denied" => "許可されてません",
"Invalid user" => "無効なユーザー",
"Message will be sent to: " => "メッセイジはこちらに送ります: ",
"edit" => "管理・編集",
"Error" => "エラー",
"name" => "名前",
"delete" => "削除",
"Remove" => "削除",
"Upload file" => "ファイルのアップロード",
"Description:" => "説明:",
"Created by" => "製作者",
"Last modified" => "最終変更日時",
"Post" => "ポスト",
"post" => "ポスト",
"Edit blog" => "ブログ変更",
"monitor this blog" => "ブログ監視開始",
"stop monitoring this blog" => "ブログ監視終了",
"posts" => "ポスト数",
"visits" => "閲覧数",
"Categorize" => "カテゴリ化する",
"show categories" => "カテゴリを表示",
"hide categories" => "カテゴリを非表示",
"categorize this object" => "このオブジェクトをカテゴリ化する",
"No categories defined" => "カテゴリは作成されてない",
"Admin categories" => "カテゴリの管理",
"author" => "作者",
"user level" => "レベル",
"Vote" => "投票",
"Edit" => "管理･編集",
"reply" => "返信",
"delete selected" => "選択アイテムを削除",
"move" => "移動",
"Messages" => "メッセージ",
"All" => "全て",
"Style" => "スタイル",
"Sort" => "ソート",
"Newest first" => "新しい順",
"Oldest first" => "古い順",
"Find" => "検索",
"set" => "設定",
"Top" => "トップ",
"prev" => "前",
"Page" => "ページ",
"next" => "次",
"Editing comment" => "コメントの編集",
"Post new comment" => "コメントを追加する",
"Preview" => "プレビュー",
"preview" => "プレビュー",
"cancel" => "取消",
"Required" => "必須",
"Smileys" => "スマイリー",
"Comment" => "コメント",
"Posting comments" => "コメントの投稿",
"Go back" => "戻る",
"Return to home page" => "ホームページへ戻る",
"up" => "上へ",
"down" => "下へ",
"add" => "追加",
"Create this page" => "このページを作成する",
"Hi {\$mail_user} has sent you this link:" => "こんにちは。{\$mail_user} 様は以下のリンクを送りました。",
"Blog post:" => "ブログ・ポスト:",
"at:" => "日付・時間帯:",
"A new message was posted to forum" => "フォーラム新しいメッセージがポストされました",
"Hi," => "こんにちは、",
"Subject" => "題",
"Hi" => "こんにちは",
"Enjoy the site!" => "サイトへようこそ。これからもよろしくお願いします！",
"The user" => "Tikiアカウント名「",
"registered at your site" => "」があなたのサイトで先ほど登録しました：",
"New user registration" => "ユーザーの新規登録",
"You can always cancel your subscription using:" => "次を利用してサブスクリプションをキャンセルすることが出来ます:",
"You can edit the submission following this link:" => "次のリンクをアクセスすると、提案の編集が出来ます:",
"Title:" => "タイトル:",
"you or someone registered this email address at" => "。この宛先メール・アドレスで次のサイトにユーザー登録されました：",
"If you want to be a registered user in this site you will have to use the following link to login for the first time:" => "登録ユーザーとしてこのサイトを利用したいなら、次のリンクをアクセスして、確認・承諾して下さい:",
"Your Tiki information registration" => "TikiWiki Jouhou Touroku",
"You will receive an email with information to login for the first time into this site" => "ユーザー登録確認のメールを送信しました。メールを開いて、その中のリンクで、ユーザー登録の確認・承諾が出来ます。",
"New blog post: {\$mail_title}, \"{\$mail_post_title}\", by {\$mail_user} at {\$mail_date|tiki_short_datetime}" => "新ブログ・ポスト: 「{\$mail_user}, \"{\$mail_post_title}\",」から{\$mail_date|tiki_short_datetime}に「{\$mail_title}」がポストされた",
"View the blog at:" => "ブログをここで閲覧できます:",
"Name" => "名前",
"You can view the updated map following this link:" => "次のリンクをアクセスすると、更新された地図を表示する事が出来ます:",
"You can edit the map following this link:" => "次のリンクをアクセスすると、地図の編集が出来ます:",
"Type" => "種類",
"Size" => "サイズ",
"New name" => "新しい名前",
"Thank you for you registration. You may log in now." => "ご登録ありがとうございます。ログインをどうぞ。",
"Comments" => "コメント",
"Last modification date" => "最終変更日時",
"Actions" => "操作",
"hits" => "ヒット数",
"No records found" => "登録はありません",
"create" => "作成",
"History" => "履歴",
"save" => "保存",
"You can view this map in your browser using" => "次を利用すると、地図をブラウザーで表示出来ます",
"Version" => "バージョン",
"compare" => "比較",
"current" => "現在",
"User" => "ユーザー",
"Action" => "操作",
"view" => "表示",
"diff" => "違い",
"Files" => "ファイル",
"Create Directory:" => "ディレクタリーの新規作成:",
"Edit template" => "テンプレートを変更する",
"Unread" => "未読",
"Flagged" => "旗印あり",
"Unflagged" => "旗印なし",
"Containing" => "以下の文字を含む",
"filter" => "フィルター",
"sender" => "送信者",
"subject" => "題",
"date" => "日時",
"No messages to display" => "メッセージはありません",
"Broadcast message" => "メッセージの同報通知",
"Message Broadcast" => "メッセージの同報通知",
"edit template" => "テンプレートを変更する",
"Group" => "グループ",
"All users" => "全てのユーザー",
"Lowest" => "とても低い",
"Low" => "低い",
"Normal" => "普通",
"High" => "高い",
"Very High" => "とても高い",
"send" => "送信",
"Compose message" => "メッセージを作成する",
"Compose Message" => "メッセージの作成",
"Mark as read" => "既読にする",
"Mark as unread" => "未読にする",
"Mark as flagged" => "旗印をつける",
"Mark as unflagged" => "旗印を消す",
"mark" => "実行",
"Mailbox" => "受信箱",
"Compose" => "メッセージ作成",
"Broadcast" => "同報通知",
"Read message" => "メッセージを読む",
"Prev" => "前",
"Next" => "次",
"replyall" => "全員に返信",
"Move module up" => "モジュールを上に移動",
"Move module down" => "モジュールを下に移動",
"Move module to opposite side" => "モジュールを反対側に移動",
"Unassign this module" => "モジュールの割当解除",
"Are you sure you want to unassign this module?" => "モジュールの割当解除してもよろしいですか？",
"remove" => "削除",
"Admin Menu" => "メニューの管理",
"Live support" => "ライブ・サポート",
"Banning" => "拒否操作",
"Users" => "ユーザー",
"Groups" => "グループ",
"Cache" => "キャッシュ",
"Modules" => "モジュール",
"Links" => "リンク数",
"Hotwords" => "ホットワード",
"RSS modules" => "RSSモジュール",
"Menus" => "メニュー",
"Polls" => "アンケート",
"Backups" => "バックアップ",
"Mail notifications" => "イベントのメール通知",
"Search stats" => "検索の統計",
"QuickTags" => "クイックタグ",
"Chat" => "チャット",
"Categories" => "カテゴリ",
"Banners" => "バナー",
"Edit templates" => "テンプレート編集",
"Dynamic content" => "ダイナミック・コンテント",
"Cookies" => "中華クッキー",
"Mail-in" => "メール→Wiki変換",
"Content templates" => "コンテント・テンプレート",
"HTML pages" => "HTMLページ",
"Shoutbox" => "伝言板",
"Referer stats" => "Referer 統計",
"Import PHPWiki Dump" => "PHPWikiダンプのインポート",
"phpinfo" => "PHP情報「phpinfo」",
"External wikis" => "外のWiki",
"System Admin" => "システム管理",
"Menu" => "メニュー",
"Contact us" => "サイト主に連絡する",
"Stats" => "統計",
"Games" => "ゲーム",
"Calendar" => "カレンダー",
"MyMenu" => "メニュー",
"MyTiki" => "私のTiki",
"Preferences" => "設定",
"Tasks" => "タスク",
"Bookmarks" => "ブックマーク",
"Newsreader" => "ネットニュース",
"Webmail" => "ウェブメール",
"Notepad" => "メモ帳",
"My files" => "ファイル",
"User menu" => "メニュー",
"Mini calendar" => "ミニ・カレンダー",
"My watches" => "ウォッチ",
"Last changes" => "最後の変更",
"Dump" => "ファイルへ保存",
"Rankings" => "ランキング",
"List pages" => "ページの一覧",
"Orphan pages" => "遺児ページ",
"Sandbox" => "砂箱",
"Print" => "印刷",
"Send pages" => "ページを送る",
"Received pages" => "受信ページ",
"Structures" => "ストラクチャー",
"Image Galleries" => "画像ギャラリー",
"Galleries" => "ギャラリー",
"Upload image" => "画像のアップロード",
"System gallery" => "システム・ギャラリー",
"Articles home" => "記事ホーム",
"Submit article" => "記事を提案する",
"View submissions" => "提案記事を見る",
"Edit article" => "記事を編集する",
"Send articles" => "記事を配信する",
"Received articles" => "受信記事",
"Admin topics" => "トピックの管理",
"Admin types" => "記事類の管理",
"List blogs" => "ブログの一覧",
"Create/Edit blog" => "ブログの追加・変更",
"Admin posts" => "ポストの管理",
"List forums" => "フォーラム一覧",
"Admin forums" => "フォーラムの管理",
"Submit a new link" => "新リンクの提案",
"Browse directory" => "ディレクタリーの閲覧",
"Admin directory" => "ディレクタリーの管理",
"File Galleries" => "ファイルギャラリー",
"FAQs" => "FAQ",
"List FAQs" => "FAQの一覧",
"Admin FAQs" => "FAQの管理",
"Layer management" => "レイヤー管理",
"QuizMenu" => "クイズのメンユー",
"Quizzes" => "クイズ",
"List quizzes" => "クイズの一覧",
"Quiz stats" => "クイズの統計",
"Admin quiz" => "クイズの管理",
"Trackers" => "トラッカー",
"List trackers" => "トラッカーの表示",
"Admin trackers" => "トラッカーの管理",
"Surveys" => "サーベイ",
"List surveys" => "サーベイの一覧",
"Admin surveys" => "サーベイの管理",
"Newsletters" => "ニュースレター",
"Send newsletters" => "ニュースレターの発行",
"Admin newsletters" => "ニュースレターの管理",
"Events" => "イベント",
"Ephemerides" => "日替わり",
"Charts" => "チャート",
"Admin" => "管理",
"Debugger console" => "デバッグ・コンソール",
"Theme control" => "テーマ・コントロール",
"Drawings" => "画板",
"Integrator" => "インテグレーター",
"Click here to manage your personal menu" => "クリックして個人メニューの管理",
"User Menu" => "ユーザ メニュー",
"TikiWiki Assistant" => "TikiWikiアシスタント",
"Thank you for installing TikiWiki" => "TikiWikiのご利用、有難う！",
"for more setup details." => "をご覧になって、詳しい設定を行うことも出来る。",
"You can remove this module in" => "次のメニューを使って、このメッセージを隠すことも出来ます：",
"Monday" => "月曜日",
"Tuesday" => "火曜日",
"Wednesday" => "水曜日",
"Thursday" => "木曜日",
"Friday" => "金曜日",
"Saturday" => "土曜日",
"Sunday" => "日曜日",
"Filter" => "フィルター",
"Today" => "今日",
"Last `\$module_rows` Sites" => "過去`\$module_rows`つのサイト",
"Directory Stats" => "ディレクタリー統計",
"Sites" => "サイト",
"Top \$module_rows Sites" => "サイトのトップ\$module_rows",
"Top `\$module_rows` topics" => "トピックのトップ`\$module_rows`",
"Top topics" => "トップ・トピック",
"Last `\$module_rows` forum topics" => "過去`\$module_rows`つのフォーラム・トピック",
"Last forum topics" => "最近のフォーラムトピック",
"Most commented forums" => "コメント数の多いフォーラム",
"Most read topics" => "閲覧数の多いフォーラムトピック",
"Most visited forums" => "アクセス数の多いフォーラム",
"Google Search" => "Google検索",
"Last `\$module_rows` articles" => "過去`\$module_rows`つの記事",
"Last articles" => "最近の記事",
"Last `\$module_rows` blog posts" => "過去`\$module_rows`つのブログ・ポスト",
"Last blog posts" => "最近のブログ・ポスト",
"Last" => "以前",
"Last `\$module_rows` Created blogs" => "過去`\$module_rows`つの作成されたブログ",
"Last Created blogs" => "最近作成されたブログ",
"Last `\$module_rows` Created FAQs" => "過去`\$module_rows`つの作成されたFAQ",
"Last Created FAQs" => "最近作成されたFAQ",
"Last `\$module_rows` Created Quizzes" => "過去`\$module_rows`つの作成されたクイズ",
"Last Created Quizzes" => "最近作成されたクイズ",
"Last `\$module_rows` modified file galleries" => "過去`\$module_rows`つの変更されたファイル・ギャラリー",
"Last modified file galleries" => "最近変更されたファイル・ギャラリー",
"Last `\$module_rows` Files" => "過去`\$module_rows`つのファイル",
"Last Files" => "最近のファイル",
"Last `\$module_rows` galleries" => "過去`\$module_rows`つのギャラリー",
"Last galleries" => "最近のギャラリー",
"Last `\$module_rows` changes" => "過去`\$module_rows`つの変更",
"Last `\$module_rows` Modified Items" => "過去`\$module_rows`つの変更されたアイテム",
"Last Modified Items" => "最近変更されたアイテム",
"Last `\$module_rows` Modified blogs" => "過去`\$module_rows`つの変更されたブログ",
"Last Modified blogs" => "最近変更されたブログ",
"Last `\$module_rows` submissions" => "過去`\$module_rows`の提案",
"Last submissions" => "最近の提案",
"Last `\$module_rows` Items" => "過去`\$module_rows`つのアイテム",
"Last Items" => "最近のアイテム",
"Online users" => "オンライン・ユーザー",
"We have" => "私達は",
"online users" => "接続中のユーザー",
"logged as" => "ログイン名",
"Logout" => "ログアウト",
"user" => "ユーザー",
"pass" => "パスワード",
"login" => "ログイン",
"Remember me" => "パスワードを記憶",
"Click here to register" => "登録するのにここをクリック",
"register" => "新規登録",
"Click here if you've forgotten your password" => "パスワードをお忘れの場合、ここをクリック",
"I forgot my pass" => "パスワードを紛失",
"Click here to login using the default security protocol" => "ここをクリックして規定のセキュリティーでログインする",
"Click here to login using a secure protocol" => "ここをクリックして強力なセキュリティーでログインする",
"You have" => "あなたは",
"You have 0 new messages" => "メッセージは届いていません",
"Register as a new user" => "ユーザーの新規登録",
"Your registration code:" => "あなたの登録コード:",
"Username" => "ユーザー名",
"Passcode to register (not your user password)" => "登録パスコード（ユーザー・パスワードと違う）",
"Registration code" => "登録コード",
"Password" => "パスワード",
"Repeat password" => "パスワード(再入力)",
"Email" => "メールアドレス",
"Generate a password" => "パスワードの自動生成",
"Search" => "検索",
"Wiki Pages" => "Wikiページ数",
"Image Gals" => "画像ギャラリー",
"Images" => "画像",
"Read More" => "もっと読む",
"Language: " => "言語: ",
"Language" => "言語",
"Most Active blogs" => "アクチブなブログ",
"Top `\$module_rows` articles" => "記事のトップ`\$module_rows`",
"Top articles" => "トップ記事",
"Top `\$module_rows` File Galleries" => "ファイル・ギャラリーのトップ`\$module_rows`",
"Top File Galleries" => "トップ・ファイル・ギャラリー",
"Top `\$module_rows` files" => "ファイルのトップ`\$module_rows`",
"Top files" => "トップ・ファイル",
"Top `\$module_rows` games" => "ゲームのトップ`\$module_rows`",
"Top games" => "トップ・ゲーム",
"Top `\$module_rows` galleries" => "ギャラリーのトップ`\$module_rows`",
"Top `\$module_rows` Images" => "イメージのトップ`\$module_rows`",
"Top Images" => "トップ画像",
"Top `\$module_rows` Pages" => "ページのトップ`\$module_rows`",
"Top Pages" => "トップ・ページ",
"Top `\$module_rows` Quizzes" => "クイズのトップ`\$module_rows`",
"Top Quizzes" => "トップ・クイズ",
"Most `\$module_rows` visited blogs" => "アクセス件数でトップ`\$module_rows`つのブログ",
"Top `\$module_rows` Visited FAQs" => "アクセス件数でトップ`\$module_rows`つのFAQ",
"Top Visited FAQs" => "トップFAQ",
"Upcoming events" => "表示するこれからのイベント数",
"My blogs" => "ブログ",
"cache" => "キャッシュ",
"My galleries" => "ギャラリー",
"My Pages" => "ページ",
"done" => "終了",
"del" => "削除",
"Whats related" => "関連",
"Last `\$module_rows` wiki comments" => "過去`\$module_rows`つのWikiコメント",
"Last wiki comments" => "最近のWikiコメント",
"vote" => "投票",
"Sent editions" => "発行済み",
"find" => "検索",
"users" => "ユーザー",
"Structures:" => "ストラクチャー:",
"show structures" => "ストラクチャーを表示する",
"hide structures" => "ストラクチャーを隠す",
"Execution time" => "実行時間",
"secs" => "秒",
"Memory usage" => "メモリー利用料",
"database queries used" => "ッコのデータベース・クエリー実行",
"Server load" => "サーバーのロード",
"cached" => "キャッシュされた",
"print" => "印刷",
"create pdf" => "PDFを作成する",
"pdf" => "PDF",
"monitor this page" => "このページを監視する",
"stop monitoring this page" => "このページの監視を止める",
"backlinks" => "バックリンク",
"page" => "ページ",
"last modification" => "最終変更日時",
"click here" => "ここをクリック",
"The content on this page is licensed under the terms of the" => "The\ncontent on this page is licensed under the terms of the",
"The original document is available at" => "The original document is\navailable at",
"rename" => "名前変更",
"unlock" => "ロック解除",
"lock" => "ロック",
"perms" => "権限",
"history" => "履歴",
"similar" => "類似",
"undo" => "取消",
"slides" => "スライド",
"export" => "出力",
"add comment" => "コメントする",
"comments" => "コメント",
"attach file" => "ファイルを添付",
"1 file attached" => "添付：1つ",
"{\$atts_cnt} files attached" => "添付：{\$atts_cnt}つ",
"Page generated in" => "ページ作成に要した時間",
"The newsletter was sent to {\$sent} email addresses" => "ニュースレターは{\$sent}件のアドレスに送信されました。",
"This newsletter will be sent to {\$subscribers} email addresses." => "このニュースレターは{\$subscribers}件のアドレスに送信されます。",
"Prepare a newsletter to be sent" => "ニュースレターを用意する",
"Newsletter" => "ニュースレター",
"Apply template" => "テンプレート・テキストで上書き",
"Data" => "ポストの内容",
"Send Newsletters" => "ニュースレターを送信",
"Made with" => "材料：",
"powered by" => "パワーの提供",
"Last Changes" => "最後の変更",
"attachments" => "添付",
"Click" => "クリック",
"User files" => "ユーザーファイル",
"Favorites" => "お気に入り",
"Watches" => "ウォッチ",
"home" => "ホーム",
"chat" => "チャット",
"contact us" => "サイト主に連絡する",
"stats" => "統計",
"categories" => "つのカテゴリ",
"last changes" => "最後の変更",
"orphan pages" => "遺児ページ",
"sandbox" => "砂箱",
"received pages" => "受信ページ",
"structures" => "ストラクチャー",
"Articles Home" => "ニュース記事ホーム",
"Create/Edit Blog" => "ブログの新規作成・変更",
"Browse Directory" => "ディレクタリーの閲覧",
"List Quizzes" => "クイズの一覧",
"List Trackers" => "トラッカーの一覧",
"List Surveys" => "サーベイの一覧",
"Prefs" => "設定",
"MyFiles" => "ファイル",
"back to homepage" => "ホームへ戻る",
"This page is being edited by" => "次の人がこのページを編集してます",
"Proceed at your own peril" => "最大な注意を払ってお進み下さい",
"The SandBox is a page where you can practice your editing skills, use the preview feature to preview the appearance of the page, no versions are stored for this page." => "Tikiの「砂箱」と言うのは、安心して編集できるWikiのページです。TikiでのWikiの書き方を覚えたり、練習したり、記録の残らない特別なページです。",
"Description" => "説明",
"My Footnotes" => "脚注",
"Copyright" => "著作権",
"Year:" => "年:",
"Authors:" => "作者:",
"Allow HTML" => "HTMLの使用を許す",
"Import page" => "ページをインポート",
"export all versions" => "全バージョンを出力する",
"Upload picture" => "画像のアップロード",
"no cache" => "キャッシュしない",
"minute" => "分",
"hour" => "時間",
"License" => "レイセンス",
"Important" => "重要",
"Minor" => "マイナー",
"cancel edit" => "編集中止",
"No attachments for this page" => "このページには添付はありません",
"My Tiki" => "私のTiki",
"User Pages" => "ユーザ ページ",
"List pages where I am a creator" => "私がクリエータのページ一覧を出す",
"by creator" => "作成者順",
"List pages where I am a modificator" => "私が撰者のページ一覧を出す",
"by modificator" => "変更者順",
"User Galleries" => "ユーザ ギャラリー",
"Assigned items" => "割当アイテム",
"Unread Messages" => "未読メッセージ",
"User Blogs" => "ユーザ ブログ",
"Unassign module" => "モジュールの割当解除",
"debugger console" => "デバッグ・コンソール",
"Mini Calendar" => "ミニ・カレンダー",
"on:" => "作成日:",
"reads" => "閲覧回数",
"Article image" => "記事の画像",
"Refresh" => "更新",
"referenced by" => "外から参照リンク数",
"references" => "本文内リンク数",
"email this post" => "このポストをメールで送る",
"Viewing blog post" => "ブログ・ポストの表示",
"Return to blog" => "ブログへ戻る",
"Blog name" => "ブログ名",
"User Bookmarks" => "ユーザ ブックマーク",
"wiki help" => "Wikiのヘルプ",
"Enlarge area height" => "高さを大きく",
"Reduce area height" => "高さを小さく",
"Features" => "機能",
"General" => "全体設定",
"Home Blog" => "ホーム・ブログ",
"Home Blog (main blog)" => "ホーム・ブログ（主）",
"ok" => "OK",
"Blog features" => "ブログ機能",
"Blog level comments" => "ブログ全体に対するコメント",
"Post level comments" => "ポストに対するコメント",
"Spellchecking" => "スペルチェック",
"Default ordering for blog listing" => "ブログの規定表示順",
"Creation date (desc)" => "作成日(新しい順)",
"Last modification date (desc)" => "変更日(新しい順)",
"Blog title (asc)" => "ブログ･タイトル(Aあ順)",
"Number of posts (desc)" => "ポストの数(多い順)",
"Visits (desc)" => "アクセス数(多い順)",
"Activity (desc)" => "アクティビティー (多い順)",
"Change preferences" => "設定を変更する",
"Blog listing configuration (when listing available blogs)" => "ブログの表示設定(利用できるブログを表示する時)",
"Creation date" => "作成日",
"Last modification time" => "最終変更時刻",
"Plain text" => "テキストのみ",
"Link to user information" => "ユーザー情報へのリンク",
"User avatar" => "ユーザーのアバター",
"Blog comments settings" => "ブログ・コメント設定",
"Default number of comments per page" => "ページに表示するコメントの規定数",
"Comments default ordering" => "コメントの規定順",
"Points" => "点数",
"CMS features" => "CMS機能",
"Submissions" => "提案",
"Use templates" => "テンプレートを使う",
"Maximum number of articles in home" => "ホームに表示する記事の上限",
"Article comments settings" => "記事コメントの設定",
"Topic" => "トピック",
"Publish Date" => "公開日時",
"Expire Date" => "期限切れ",
"Visible" => "可視",
"Img" => "画像",
"Country" => "国",
"Last login" => "最終ログイン日時",
"Set features" => "設定を変更する",
"Method to open directory links" => "ディレクタリー・リンクの開き方",
"replace current window" => "現在の窓を使う",
"new window" => "新しいウィンドウで開く",
"Live Support" => "ライブ・サポート",
"Live support system" => "ライブ・サポート・システム",
"Help System" => "ヘルプ・システム",
"Show Babelfish Translation URLs" => "Babelfish翻訳URLを表示",
"Show Babelfish Translation Logo" => "Babelfish翻訳ロゴ・マークを表示",
"Show Module Controls" => "モジュール・コントロールを表示",
"Tiki Calendar" => "Tikiカレンダー",
"Tiki Template Viewing" => "Tikiテンプレートの表示",
"PhpLayers Dynamic menus" => "PhpLayersのダイナミック・メニュー",
"Edit CSS" => "CSSを編集",
"HTML Pages" => "HTMLページ",
"Allow Smileys" => "スマイリーを有効にする",
"AutoLinks" => "オートリンク",
"Debugger Console" => "デバッグ・コンソール",
"Theme Control" => "テーマ・コントロール",
"Referer Stats" => "Referer 統計",
"Contact Us" => "サイト主に連絡する",
"User Features" => "ユーザ 機能",
"User Preferences Screen" => "ユーザ 設定パネル",
"Users can Configure Modules" => "ユーザはモジュール設定できます",
"User Watches" => "ユーザ ウォッチ",
"User Tasks" => "ユーザ タスク",
"User Messages" => "ユーザ メッセージ",
"User Files" => "ユーザ ファイル",
"User Notepad" => "ユーザ メモ帳",
"Home Gallery (main gallery)" => "ホーム・ギャラリー(主)",
"Galleries features" => "ギャラリー機能",
"Use database to store files" => "ファイルをデータベースに保存",
"Use a directory to store files" => "ファイルをディレクタリーに保存",
"Directory path" => "ディレクタリー・パス（最後のスラッシュ/を忘れずに）",
"Uploaded filenames must match regex" => "アップロードするファイル名と一致すべきRegex",
"Uploaded filenames cannot match regex" => "アップロードするファイル名と一致しないRegex",
"Gallery listing configuration" => "ギャラリー一覧の設定",
"File galleries comments settings" => "ファイル･ギャラリーのコメント設定",
"Home Forum (main forum)" => "ホーム・フォーラム（主）",
"Forum quick jumps" => "フォーラムのクイック・ジャンプ",
"Ordering for forums in the forum listing" => "フォーラムの一覧の表示順",
"Forum listing configuration" => "フォーラムの表示設定",
"Topics" => "トピック",
"Uses Slideshow" => "Slideshowを使う",
"Use database to store images" => "画像をデーターベースに保存する",
"Use a directory to store images" => "画像をディレクタリーに保存する",
"Library to use for processing images" => "画像処理に使うライブラリー",
"Uploaded image names must match regex" => "アップロードする画像名が一致すべきRegex",
"Uploaded image names cannot match regex" => "アップロードする画像名が一致しないRegex",
"Remove images in the system gallery not being used in Wiki pages, articles or blog posts" => "Wikiページ、記事、ブログ・ポストで使われていないシステム・ギャラリー画像を削除する",
"Move" => "ページをストラクチャー内で移動する",
"images" => "画像",
"Image galleries comments settings" => "ギャラリーのコメント設定",
"General Preferences" => "全体の設定",
"Theme" => "テーマ",
"Slideshows theme" => "スライドショウのテーマ",
"Use group homepages" => "グループ・ホームページを使う",
"Use URI as Home Page" => "このURIで示すページをホームページにする",
"Home page" => "ホームページ",
"Custom home" => "カスタムホーム",
"Use database for translation" => "翻訳にデータベースを用いる",
"Record untranslated" => "未翻訳語を記録する",
"Unknown/Other" => "わからない/その他",
"General Settings" => "一般機能",
"Disallow access to the site (except for those with permission)" => "権限を持っている物以外、サイトのアクセスを拒否する",
"Message to display when site is closed" => "サイトが「メンテ中」時に表示するメッセージ",
"Disallow access when load is above the threshold (except for those with permission)" => "権限を持っている物以外、ロードが一定値より高い場合、サイトへのアクセスを拒否する",
"Max average server load threshold in the last minute" => "過去一分間、サーバ・ロード平均の最高値",
"Message to display when server is too busy" => "サーバーがビジーな時表示するメッセージ",
"Open external links in new window" => "このサイト外へのリンクは新規ウィンドウに表示する",
"Display modules to all groups always" => "モジュールは全てのグループに常に表示する",
"Use cache for external pages" => "外のページをキャッシュする",
"Use cache for external images" => "外の画像をキャッシュする",
"Use direct pagination links" => "ページへのリンクを提供する",
"Use gzipped output" => "gzip出力を使用する",
"Count admin pageviews" => "管理者の閲覧回数も記録する",
"No" => "いいえ",
"Yes" => "はい",
"Maximum number of records in listings" => "一覧内レコードの上限",
"Date and Time Formats" => "日付・時刻の書式",
"Long date format" => "日付の書式(長)",
"Short date format" => "日付の書式(短)",
"Long time format" => "時刻の書式(長)",
"Short time format" => "時刻の書式(短)",
"Date and Time Format Help" => "日付・時刻の書式の書き方",
"Change admin password" => "管理者のパスワードを変更する",
"New password" => "新しいパスワード",
"Change password" => "パスワードを変更する",
"port" => "ポート",
"path" => "パス",
"groups" => "グループ",
"Contact" => "連絡先",
"Admin groups" => "グループの管理",
"Authentication method" => "認証手段",
"Just Tiki" => "Tiki方式のみ",
"Web Server" => "Webサーバー",
"Tiki and PEAR::Auth" => "TikiとPEAR::Auth",
"Use WebServer authentication for Tiki" => "Webサーバー認証をTikiに使う",
"Users can register" => "誰でもユーザー登録可能",
"Request passcode to register" => "ユーザー登録時にパスコードを要求する",
"Prevent automatic/robot registration" => "自動/ロボット登録を阻止する",
"Store plaintext passwords" => "パスワードを暗号化せず平文で保存する",
"Use challenge/response authentication" => "チャレンジ・リスポンス認証を利用する",
"Force to use chars and nums in passwords" => "パスワードに文字も数字も必須",
"Minimum password length" => "パスワード長さの下限",
"Password invalid after days" => "パスワードの有効期限(日)",
"day" => "日",
"week" => "週",
"month" => "月",
"Feed for Articles" => "記事のフィード",
"Feed for Weblogs" => "全ブログのフィード",
"Feed for Image Galleries" => "画像ギャラリーのフィード",
"Feed for File Galleries" => "ファイル・ギャラリーのフィード",
"Feed for the Wiki" => "Wikiのフィード",
"Feed for individual Image Galleries" => "角画像ギャラリーのRSSフィード",
"Feed for individual File Galleries" => "角ファイル・ギャラリーのRSSフィード",
"Feed for individual weblogs" => "個別ブログのフィード",
"Feed for forums" => "全フォーラムのフィード",
"Feed for individual forums" => "個別フォーラムのフィード",
"Full Text Search" => "全文検索",
"SearchStats" => "検索の統計",
"Publish" => "公開",
"Path" => "パス",
"Quota (Mb)" => "サイズ上限 (Mb)",
"Use database to store userfiles" => "ファイルをデータベースに格納する",
"Use a directory to store userfiles" => "ファイルをディレクトリに格納する",
"Dumps" => "ダンプ・ファイル保存",
"Generate dump" => "ダンプファイルを作成",
"Download last dump" => "最新ダンプをダウンロード",
"restore" => "復元",
"Export Wiki Pages" => "Wikiページをエキスポートする",
"Export" => "エキスポート",
"Remove unused pictures" => "使われていない画像を削除",
"Wiki Home Page" => "Wikiホームページ",
"Wiki Discussion" => "Wikiディスカッション",
"Discuss pages on forums" => "Wikiページをフォーラムで議論する",
"Wiki Link Format" => "Wikiのリンク形式",
"Controls recognition of Wiki links using the two parenthesis Wiki link syntax <i>((page name))</i>." => "「カッコウ二つ」のWikiリンク形式を制御する<i>((page name))</i>.",
"Creator" => "作成者",
"Last version" => "最後のバージョン",
"Status" => "状態",
"Versions" => "バージョン数",
"Backlinks" => "外からバックリンク",
"Wiki Features" => "Wiki機能",
"Undo" => "元に戻す",
"MultiPrint" => "マルチ印刷",
"PDF generation" => "PDF作成",
"mins" => "分",
"Pictures" => "画像",
"Use page description" => "ページ説明を使う",
"Show page title" => "ページタイトルを表示",
"Cache wiki pages (global)" => "Wikiページをキャッシュする(全体)",
"Individual cache" => "個別キャッシュ",
"Users can lock pages (if perm)" => "ユーザーに権限があれば、ページをロックできる",
"Use WikiWords" => "WikiWordsを使う",
"Link plural WikiWords to their singular forms" => "複数形のWikiWordsを単数形にリンクする",
"Automonospaced text" => "自動モノスペース テキスト",
"Tables syntax" => "表構成",
"|| for rows" => "|| を行の区切りに",
"\\n for rows" => "\\n を行の区切りに",
"Page creators are admin of their pages" => "作成者に自分が作成したページに管理する権限を与える",
"Import HTML" => "HTMLをインポートする",
"Wiki History" => "Wiki履歴",
"Maximum number of versions for history" => "履歴バージョン数の上限",
"Never delete versions younger than days" => "この日数より新しいバージョンをけして削除しない",
"Copyright Management" => "著作権管理",
"Enable Feature" => "機能を有効にする",
"License Page" => "ライセンスページ",
"Submit Notice" => "投降時の注意",
"Wiki Watch" => "Wikiウォッチ",
"Create watch for author on page creation" => "ページ作成時に作成者ウォッチを有効にする",
"Enable watch events when I am the editor" => "私が編集者の場合に、ウォッチ・イベントを有効にする",
"Enable watches on comments" => "コメントに対するウォッチを有効にする",
"Wiki attachments" => "Wiki添付ファイル",
"View tpl" => "tplを見る",
"check / uncheck all" => "全てチェックする / チェックを外す",
"Admin Calendars" => "カレンダーの管理",
"List of Calendars" => "カレンダーの表示",
"permissions" => "権限",
"Create/edit Calendars" => "カレンダーの作成・編集",
"Current category" => "現在のカテゴリ",
"Edit this category:" => "このカテゴリを編集:",
"create new" => "新規作成",
"Add new category" => "新規カテゴリ",
"Parent" => "親",
"Objects in category" => "カテゴリ内のオブジェクト",
"type" => "種類",
"Add objects to category" => "オブジェクトをカテゴリに加える",
"image gal" => "画像ギャラリー",
"file gal" => "ファイルギャラリー",
"Admin chart items" => "チャートのアイテムを管理",
"charts" => "チャート",
"edit chart" => "チャートを編集",
"Add or edit an item" => "アイテムの追加・変更",
"update" => "更新",
"Active" => "アクティブ",
"Voting system" => "投票システム",
"Vote items" => "投票アイテム",
"Each 5 minutes" => "５分毎に",
"Daily" => "日間",
"Weekly" => "週間",
"Monthly" => "月間",
"Show Votes" => "投票を表示する",
"Use Cookies for unregistered users" => "非登録ユーザーにもCookieを利用する",
"Items" => "アイテム",
"Chat Administration" => "チャットの管理",
"Create/edit channel" => "チャンネルの追加・変更",
"Refresh rate" => "更新間隔",
"second" => "秒",
"Chat channels" => "チャットチャンネル",
"active" => "アクティブ",
"last modif" => "最終変更日時",
"Admin cookies" => "中華クッキー管理",
"admin FortuneCookie" => "中華クッキーの管理",
"Create/edit cookies" => "中華クッキー追加・変更",
"Cookie" => "中華クッキー",
"Upload Cookies from textfile" => "中華クッキーをテキストファイルからアップロード",
"Upload from disk:" => "ディスクからアップロード:",
"upload" => "アップロード",
"Remove all cookies" => "全ての中華クッキーを削除",
"cookie" => "中華クッキー",
"Create/Edit External Wiki" => "外Wikiの新規作成・変更",
"Admin Forums" => "フォーラムの管理",
"Create new forum" => "フォーラムの新規作成",
"Edit this Forum:" => "フォーラムの変更:",
"Create New Forum" => "新規フォーラム",
"There are individual permissions set for this forum" => "このフォーラムには個人権限が設定してあります",
"Show description" => "説明を表示する",
"Prevent flooding" => "連続投稿を防止",
"Minimum time between posts" => "投稿間隔時間の下限",
"min" => "分",
"Topics per page" => "ページあたりのトピック数",
"Section" => "セクション",
"Create new" => "新規",
"Moderator user" => "編集者",
"Moderator group" => "編集グループ",
"Password protected" => "パスワードで保護する",
"Topics only" => "トピックのみ",
"All posts" => "全ポスト",
"Forum password" => "フォーラムのパスワード",
"Default ordering for topics" => "標準でのトピック表示順",
"Date (desc)" => "日付 (新しい順)",
"Date (asc)" => "日付 (古い順)",
"Score (desc)" => "点数 (多い順)",
"Replies (desc)" => "返信数 (多い順)",
"Reads (desc)" => "閲覧数 (多い順)",
"Title (desc)" => "タイトル",
"Title (asc)" => "タイトル (逆順)",
"Default ordering for threads" => "スレッドの規定並び順",
"Send this forums posts to this email" => "フォーラムへの投稿をこのアドレスに送信",
"Prune unreplied messages after" => "返事のないポストを次の期間を超えると削除する",
"Prune old messages after" => "古いポストを次の期間を超えると削除する",
"Topic list configuration" => "トピック一覧の表示設定",
"Replies" => "返信数",
"Display last post titles" => "最近のポストのタイトルを表示する",
"no display" => "表示しない",
"Forward messages to this forum to this e-mail address, in a format that can be used for sending back to the inbound forum e-mail address" => "投稿される全ポストをこのメールアドレスに送信する",
"Originating e-mail address for mails from this forum" => "このフォーラムから送信されるメールのアドレス",
"Add messages from this email to the forum" => "このメール・アドレスへ着信したメッセージをフォーラムに自動投稿する",
"POP3 server" => "POP3サーバー",
"Use topic smileys" => "トピックにスマイリーを使う",
"Show topic summary" => "トピックのサマリーを表示する",
"User information display" => "ユーザー情報を表示する",
"avatar" => "アバター",
"flag" => "旗",
"online" => "オンライン状態",
"Approval type" => "承諾の仕組み",
"All posted" => "全ポストを直ぐに表示",
"Queue anonymous posts" => "匿名ポストを承諾キューに追加",
"Queue all posts" => "全ポストを承諾キューに追加",
"Attachments" => "添付",
"No attachments" => "なし",
"Everybody can attach" => "誰でも可能",
"Only users with attach permission" => "添付権限を持っているユーザーのみ",
"Moderators and admin can attach" => "モデレーターと管理者のみ",
"Store attachments in:" => "添付の保存先:",
"Database" => "データベース",
"Max attachment size (bytes)" => "最大の大きさ(バイト数)",
"topics" => "トピック",
"Assign Permissions" => "権限の割当",
"Click here to delete this forum" => "クリックしてフォーラムの削除",
"Add" => "追加",
"Start" => "開始",
"title" => "題",
"position" => "位置",
"Position" => "位置",
"Account name" => "アカウント名",
"POP server" => "POPサーバー",
"Port" => "ポート",
"SMTP server" => "SMTPサーバー",
"SMTP requires authentication" => "SMTPに認証が必要",
"List menus" => "メニュー一覧",
"Edit this menu" => "このメニューを編集する",
"Permissions" => "権限",
"option" => "オプション",
"Choose" => "選択",
"Home Page" => "ホームページ",
"User preferences" => "ユーザー設定",
"User prefs" => "ユーザー設定",
"Upload" => "アップロード",
"All articles" => "全ての記事",
"List Blogs" => "ブログの一覧",
"Create blog" => "新規ブログ",
"File galleries" => "ファイル・ギャラリー",
"View a forum" => "フォーラムを表示する",
"View a thread" => "スレッドを表示する",
"View a FAQ" => "FAQを見る",
"Take a quiz" => "クイズを受ける",
"Stats for a Quiz" => "クイズの統計",
"Preview menu" => "メニューのプレビュー",
"Menu options" => "メニュー・オプション",
"group" => "グループ",
"Create new Menu" => "新規メニュー",
"options" => "オプション",
"Admin Modules" => "モジュールの管理",
"admin modules" => "モジュールの管理",
"assign module" => "モジュール割当",
"left modules" => "左側のモジュール",
"right modules" => "右側のモジュール",
"edit/create" => "編集/作成",
"clear cache" => "キャッシュをクリア",
"User Modules" => "ユーザーモジュール",
"assign" => "権限",
"Assign new module" => "新規モジュールを割当てる",
"Edit this assigned module:" => "この割当モジュールを変更する:",
"Module Name" => "モジュール名",
"left" => "左",
"right" => "右",
"Order" => "順位",
"Parameters" => "パラメータ",
"Assigned Modules" => "割当モジュール",
"Left Modules" => "左側のモジュール",
"order" => "順位",
"Right Modules" => "右側のモジュール",
"Create new user module" => "ユーザーモジュールを作成する",
"Use wysiwyg editor" => "WYSIWYGエディタ",
"Use normal editor" => "通常のエディタ",
"Admin newsletter subscriptions" => "ニュースレター購読者の管理",
"list newsletters" => "ニュースレター一覧",
"admin newsletters" => "ニュースレターの管理",
"send newsletters" => "ニュースレターを送信",
"Add a subscription newsletters" => "このニュースレターの購読者一覧に加える",
"Subscriptions" => "講読",
"Create/edit newsletters" => "ニュースレターの追加・変更",
"There are individual permissions set for this newsletter" => "このニュースレターには個人権限が設定してあります",
"editions" => "号数",
"last sent" => "最終発行日時",
"subscriptions" => "購読者",
"EMail notifications" => "イベントのメール通知",
"admin Email Notifications" => "イベントのメール通知管理",
"Add notification" => "新規通知の追加",
"Event" => "イベント",
"A user registers" => "ユーザーが登録する時",
"A user submits an article" => "ユーザーが記事を提案する時",
"Any wiki page is changed" => "Wikiページが変更される時",
"use admin email" => "Tikiのadminメールを利用する",
"event" => "イベント",
"object" => "オブジェクト",
"Admin Polls" => "アンケートの管理",
"List polls" => "アンケートの一覧",
"Edit this poll" => "このアンケートを変更",
"Preview poll" => "アンケートのプレビュー",
"Edit or add poll options" => "アンケート・オプションの追加・変更",
"Option" => "オプション",
"Poll options" => "アンケートのオプション",
"votes" => "投票",
"admin polls" => "アンケートの管理",
"Set last poll as current" => "最後のアンケートを利用する",
"Close all polls but last" => "最後のアンケート以外を閉じる",
"Activate all polls" => "全アンケートを有効にする",
"Create/edit Polls" => "アンケートの新規作成・変更",
"PublishDate" => "執筆日時",
"Admin Quicktags" => "クイックタグの管理",
"admin QuickTags" => "クイックタグの管理",
"Create/Edit QuickTags" => "クイックタグの追加・変更",
"Category" => "カテゴリ",
"Filename" => "ファイル名",
"Structure ID" => "ストラクチャーID",
"dump tree" => "トリーのダンプ･ファイル作成",
"Destroy the structure leaving the wiki pages" => "Destroy the structure\nleaving the wiki pages",
"Destroy the structure and remove the pages" => "Destroy the structure\nand remove the pages",
"Create new structure" => "新規ストラクチャー作成",
"Use single spaces to indent structure levels" => "トリー作成時、半角空白１つ入れてからサブ・ページ名を入力しますと、ストラクチャーのサブ・レベルの作成ができます。",
"Alias" => "アリアス",
"tree" => "トリー",
"create new structure" => "新ストラクチャーを作成する",
"Edit survey questions" => "サーベイ質問の編集",
"survey stats" => "サーベイの統計",
"this survey stats" => "このサーベイの統計",
"edit this survey" => "このサーベイの変更",
"admin surveys" => "サーベイ管理",
"Create/edit questions for survey" => "サーベイの質問の新規作成・変更",
"Question" => "質問",
"Questions" => "質問",
"question" => "質問",
"list surveys" => "サーベイ一覧",
"Edit this Survey:" => "このサーベイを変更する:",
"There are individual permissions set for this survey" => "このサーベイには個人権限が設定してあります",
"questions" => "質問",
"system admin" => "システム管理",
"system admin tpl" => "システム管理TPL",
"Admin Topics" => "トピックの管理",
"Create a new topic" => "新規トピック",
"Topic Name" => "トピックの名前",
"Upload Image" => "画像のアップロード",
"List of topics" => "トピック一覧",
"Active?" => "有効?",
"Articles (subs)" => "記事(subs)",
"Activate" => "有効にする",
"Deactivate" => "無効にする",
"Admin tracker" => "トラッカーの管理",
"Edit this tracker" => "このトラッカーを変更する",
"View this tracker items" => "このトラッカーのアイテムを見る",
"Edit tracker fields" => "トラッカー・フィールドの変更",
"Is column visible when listing tracker items?" => "トラッカー・アイテム一覧時、列を表示しますか？",
"Column links to edit/view item?" => "この列は「編集・閲覧」へリンクしますか？",
"Tracker fields" => "トラッカー・フィールド",
"isMain" => "主",
"Tbl vis" => "可視",
"Import" => "インポート",
"created" => "作成日",
"items" => "アイテム",
"fields" => "フィールド",
"Create/edit trackers" => "トラッカーの追加・変更",
"There are individual permissions set for this tracker" => "このトラッカーにはには個人権限が設定してあります",
"Show creation date when listing tracker items?" => "トラッカー・アイテム一覧時、作成日を表示しますか？",
"Show lastModif date when listing tracker items?" => "トラッカー・アイテム一覧時、最終更新日を表示しますか？",
"Tracker items allow comments?" => "トラッカー・コメントを有効にする？",
"Tracker items allow attachments?" => "トラッカー添付を有効にする？",
"downloads" => "ダウンロード",
"version" => "バージョン",
"List" => "一覧",
"List of existing groups" => "既存のグループ一覧",
"Include" => "以下を含む",
"admin" => "管理",
"Edit item" => "アイテム編集",
"Add a new user" => "ユーザーを追加する",
"Batch Upload Results" => "バッチ処理の結果",
"Assign Group" => "グループの割当",
"Pass" => "パスワード",
"Again" => "パスワード(もう一度)",
"Overwrite" => "上書き",
"Admin Article Types" => "記事類の管理",
"Article Types tpl" => "記事類TPL",
"Rate" => "評価",
"Show before publish date" => "公開日時以前公開",
"Show after expire date" => "期限切れ日以降公開",
"Heading only" => "見出しのみ",
"Comment Can Rate Article" => "コメント時にも評価",
"Show image" => "画像表示",
"Show avatar" => "アバター表示",
"Show author" => "作者表示",
"Show publish date" => "公開日表示",
"Show expire date" => "期限切れ日表示",
"Show reads" => "閲覧数表示",
"Show size" => "サイズ表示",
"Creator can edit" => "作成者編集可",
"Delete" => "削除",
"List of types" => "記事類一覧",
"Create a new type" => "種類の新規作成",
"Assign permissions to group" => "グループに権限を割当てる",
"Edit Article" => "記事の編集",
"Group Information" => "グループの情報",
"Desc" => "説明",
"all permissions in level" => "次のレベルの権限全て",
"all" => "全て",
"Assign user" => "ユーザーの割当",
"User Information" => "ユーザー情報",
"Default Group" => "規定グループ",
"admin backups" => "バックアップの管理",
"admin admin tpl" => "adminのTPLを管理",
"Warning!" => "注意!",
"Click here to confirm restoring" => "クリックして復帰の確認",
"Browse gallery" => "ギャラリーの閲覧",
"Upload from disk" => "ローカル・ディスクからアップロード",
"Edit Post" => "ポストの編集",
"view blog" => "ブログ閲覧",
"list blogs" => "ブログ一覧",
"Note: if you want to use images please save the post first and you\nwill be able to edit/post images. Use the &lt;img&gt; snippet to include uploaded images in the textarea editor\nor use the image URL to include images using the WYSIWYG editor. " => "注意：画像を挿入したければ、先ずポストを保存して下さい。保存してから、通常のエディタだったら&lt;img&gt;を、WYSYWYGエディタだったら画像のURLを利用することが出来ます。",
"Use ...page... to separate pages in a multi-page post" => "ポストの改ページは、...page... をお使いください",
"Trash" => "ゴミ箱",
"Send trackback pings to:" => "Trackbackピングの送信",
"(comma separated list of URIs)" => "(英半角コンマ区切りで入力して下さい)",
"save and exit" => "保存して終了",
"Image galleries" => "画像ギャラリー",
"search category" => "カテゴリの検索",
"deep" => "深く",
"Objects" => "オブジェクト",
"Browsing Gallery" => "ギャラリー",
"edit gallery" => "ギャラリーの変更",
"rebuild thumbnails" => "サムネールを再作成",
"upload image" => "画像のアップロード",
"list gallery" => "ギャラリーの一覧",
"Sort Images by" => "画像のソート",
"original size" => "元のサイズ",
"rotate right" => "右回転",
"rotate" => "回転",
"popup" => "ポップアップ",
"Browsing Image" => "画像の閲覧",
"return to gallery" => "ギャラリーへ戻る",
"edit image" => "画像を編集",
"first image" => "最初の画像",
"smaller" => "小さく",
"bigger" => "大きく",
"prev image" => "前の画像",
"Popup window" => "ポップアップ ウィンドウ",
"popup window" => "ポップアップ ウィンドウ",
"next image" => "次の画像",
"last image" => "最後の画像",
"Image Name" => "画像名",
"Move image" => "画像の移動",
"You can view this image in your browser using" => "次を利用すると、画像をブラウザーで表示出来ます",
"Date Selector" => "日付選択",
"click to navigate" => "クリックでナビ",
"End" => "終了",
"Hours" => "時間",
"Group Calendars" => "グループ・カレンダー",
"Tools Calendars" => "ツール・カレンダー",
"Duration" => "期間",
"Tentative" => "仮",
"Confirmed" => "承認済み",
"Cancelled" => "取消",
"Edit Calendar Item" => "カレンダー・アイテムの編集",
"New Calendar Item" => "カレンダー・アイテムの新規作成",
"duplicate" => "複製",
"import" => "インポート",
"permission" => "権限",
"No individual permissions global permissions apply" => "個人権限が設定してなくて、グローバル権限のみになってます",
"Assign permissions" => "権限の割当",
"to group" => "をグループ",
"Old password" => "古いパスワード",
"Again please" => "もう一度",
"Welcome to the Tiki Chat Rooms" => "Tikiのチャットルームへようこそ",
"Please select a chat channel" => "参加するチャンネルを選んで下さい",
"Nickname" => "ニックネーム",
"enter chat room" => "参加する",
"There are no channels setup, please contact a site admin" => "チャンネルが設定されてない。管理者にご連絡を入れて下さい",
"Chatroom" => "チャットルーム",
"Active Channels" => "アクティブなチャンネル",
"Users in this channel" => "参加ユーザー",
"Channel" => "チャンネル",
"Use :nickname:message for private messages" => "個人メッセージを送信するのに、コロンを含め、:nickname:メッセージ　を入力して下さい",
"Use [URL|description] or [URL] for links" => "リンクを送るのに、カッコなど含め、[URL|説明] 又は [URL]を入力して下さい",
"Use (:smileyname:) for smileys" => "スマイリーを使うのにカッコとコロンを含め、(:英語のスマイリー名:)を入力して下さい",
"Create PDF" => "PDF作成",
"PDF Settings" => "PDF設定",
"Font" => "フォント",
"add page" => "ページを選択",
"remove page" => "ページをRemove",
"Send a message to us" => "メッセージで連絡する",
"Contact us by email" => "メールで連絡する",
"You can browse the generated WebHelp here" => "これで作成されたWebHelpの閲覧が出来ます",
"Add a new site" => "サイトの追加",
"Site added" => "サイトは追加されました",
"The following site was added and validation by admin may be needed before appearing on the lists" => "サイトは追加されましたが、管理者が許可をしてから一覧に表示されます",
"Add or edit a site" => "サイトの追加・変更",
"Is valid" => "有効",
"Directory Administration" => "ディレクタリー管理",
"Statistics" => "統計",
"There are" => "ディレクタリーには",
"invalid sites" => "つの無効なサイト",
"valid sites" => "つの有効なサイト",
"Users have visited" => "ディレクタリー一覧から、ユーザーがアクセスしたのは",
"sites from the directory" => "サイトです",
"Users have searched" => "ディレクタリーから、ユーザーが",
"times from the directory" => "回検索しました",
"Admin sites" => "サイトの管理",
"Admin category relationships" => "カテゴリ紐付け管理",
"Validate links" => "リンクの有効確認",
"Settings" => "設定",
"browse" => "閲覧",
"related" => "関連",
"sites" => "サイト",
"validate" => "有効確認",
"Admin directory categories" => "ディレクタリー・カテゴリの管理",
"Parent category" => "親カテゴリ",
"Add a directory category" => "ディレクタリー・カテゴリの追加",
"Edit this directory category" => "ディレクタリー・カテゴリ変更",
"Children type" => "子供の種類",
"Most visited sub-categories" => "アクセス数の多いサブ・カテゴリ",
"Category description" => "カテゴリの説明",
"Maximum number of children to show" => "表示する子の最大数",
"Allow sites in this category" => "このカテゴリにサイト追加を可能にする",
"Show number of sites in this category" => "このカテゴリのサイト数を表示する",
"Subcategories" => "サブ・カテゴリ",
"allow" => "許可",
"count" => "数",
"editor" => "編集者",
"relate" => "紐付ける",
"Admin related categories" => "関連カテゴリの管理",
"Admin Directory Related " => "ディレクタリー関連付けの管理 ",
"Add a related category" => "関連カテゴリの追加",
"Mutual" => "お互いに",
"Related categories" => "関連カテゴリ",
"Admin Directory Sites" => "ディレクタリー・サイトの管理",
"country" => "国",
"new sites" => "新サイト",
"cool sites" => "クールなサイト",
"add a site" => "サイト追加",
"search" => "検索",
"Sort by" => "ソート項目",
"name (desc)" => "名前 (降順)",
"name (asc)" => "名前 (昇順)",
"hits (desc)" => "ヒット数 (多い順)",
"hits (asc)" => "ヒット数 (少ない順)",
"Total categories" => "全カテゴリ数",
"Total links" => "全リンク数",
"Links to validate" => "有効確認できるリンク",
"Searches performed" => "検索数",
"Total links visited" => "リンクのアクセス数",
"Directory ranking" => "ディレクタリー・ランキング",
"Search results" => "検索結果",
"Validate sites" => "サイトの有効確認",
"Validate Sites" => "サイトの有効確認",
"list articles" => "一覧の表示",
"view articles" => "記事を読む",
"Author Name" => "作者",
"Own Image" => "自分の画像パス",
"Use own image" => "自分の画像を使う",
"Float text around image" => "画像の周りにテキストを流し込む",
"Own image size x" => "自分の画像サイズX",
"Own image size y" => "自分の画像サイズY",
"Heading" => "見出し",
"Body" => "本文",
"Use ...page... to separate pages in a multi-page article" => "「...page...」を使うと一つの記事の中で複数のページを設ける事ができます",
"Expiration Date" => "期限切れ日",
"Edit or create banners" => "バナーの作成・編集",
"List banners" => "バナー一覧",
"URL to link the banner" => "バナーのリンク先",
"Client" => "依頼主",
"Show the banner only between these dates" => "バナーの表示期間",
"From date" => "開始日",
"To date" => "終了日",
"Use dates" => "日付を使う",
"Show the banner only in this hours" => "バナーの表示時間帯",
"Mon" => "月",
"Tue" => "火",
"Wed" => "水",
"Thu" => "木",
"Fri" => "金",
"Sat" => "土",
"Sun" => "日",
"Edit Blog" => "ブログの変更",
"edit blog tpl" => "ブログTPLの編集",
"There are individual permissions set for this blog" => "このブログには個人権限が設定してあります",
"Number of posts to show" => "表示するポスト数",
"Allow other user to post in this blog" => "他のユーザーにこのブログにポストする権利を与える",
"Use titles in blog posts" => "ブログ・ポスト内にタイトルを使う",
"Allow search" => "検索を有効に",
"Allow comments" => "コメントを有効に",
"Blog heading" => "ブログ・ヘディング",
"Cancel" => "取消",
"display" => "表示",
"height width desc link and align are optional" => "height width desc\nlink and align are optional",
"displays rss feed with id=n maximum=m items" => "displays rss feed with\nid=n maximum=m items",
"The following image was successfully edited" => "The following image\nwas successfully edited",
"Image Description" => "イメージの説明",
"Edit question options" => "質問オプションの編集",
"list quizzes" => "クイズの一覧",
"quiz stats" => "クイズの統計",
"this quiz stats" => "このクイズの統計",
"edit this quiz" => "このクイズを編集",
"admin quizzes" => "クイズの管理",
"Create/edit options for question" => "質問オプションの新規作成・変更",
"points" => "点数",
"Admin quizzes" => "クイズの管理",
"Create/edit quizzes" => "クイズの新規作成・変更",
"There are individual permissions set for this quiz" => "このクイズにはには個人権限が設定してあります",
"Quiz can be repeated" => "クイズ繰り返し可能",
"Store quiz results" => "クイズ結果保存",
"Questions per page" => "ページ毎の質問数",
"Quiz is time limited" => "クイズには時間制限あり",
"Maximum time" => "限定時間",
"canRepeat" => "繰返可",
"timeLimit" => "時間制限",
"results" => "結果",
"Edit quiz questions" => "クイズ質問編集",
"Create/edit questions for quiz" => "クイズ質問の新規作成・変更",
"maxScore" => "最高点数",
"Answer" => "答え",
"Results" => "結果",
"answer" => "答え",
"Modify Structure" => "ストラクチャーの変更",
"and its subpages from the structure, now you have two options:" => "and\nits subpages from the structure, now you have two options:",
"Remove from structure and remove page too" => "Remove from structure\nand remove page too",
"Current Node" => "現在のノード",
"Page alias" => "ページのアリアス",
"Promote" => "より親にする",
"Previous" => "前",
"Demote" => "より子にする",
"Add pages to current node" => "現在のノードにページを追加する",
"After page" => "このページの後に追加する",
"create page" => "ページの新規作成",
"Use pre-existing page" => "既にあるページを使う",
"Structure Layout" => "ストラクチャー図",
"list submissions" => "投稿記事一覧",
"Template listing" => "テンプレートの表示",
"Template" => "テンプレート",
"View" => "表示",
"Try to convert HTML to wiki" => "HTMLをWikiへ変換して見る",
"Admin ephemerides" => "今日のお知らせの管理",
"All ephemerides" => "全てのお知らせ",
"Browse" => "閲覧",
"Admin FAQ" => "FAQの管理",
"View FAQ" => "FAQを表示",
"Edit this FAQ" => "このFAQを変更する",
"new question" => "質問の新規作成",
"Edit FAQ questions" => "FAQの質問を編集する",
"Use a question from another FAQ" => "別FAQからの質問を利用する",
"FAQ questions" => "FAQ 質問集",
"Suggested questions" => "提案質問",
"approve" => "承諾",
"No suggested questions" => "質問の提案はありません",
"configure listing" => "この機能の一般管理パネル",
"Create a file gallery" => "ファイル・ギャラリーの新規作成",
"Edit this file gallery:" => "次のファイル・ギャラリーを変更:",
"create new gallery" => "新規ギャラリー",
"There are individual permissions set for this file gallery" => "このファイル・ギャラリーには個人権限が設定してあります",
"Gallery is visible to non-admin users?" => "管理者以外にこのギャラリーの閲覧を許可する?",
"Listing configuration" => "一覧の設定",
"icon" => "アイコン",
"id" => "ID",
"Max Rows per page" => "1ページあたりの最大行数",
"Other users can upload files to this gallery" => "他のユーザーもギャラリーへのアップロードが出来ます",
"You can access the file gallery using the following URL" => "次のURLを利用してファイル・ギャラリーのアクセスが出来ます",
"back to forum" => "フォーラムへ戻る",
"topic" => "トピック",
"accept" => "承諾",
"Real Name" => "本名",
"start" => "開始",
"activity" => "アクティビティー",
"No roles associated to this activity" => "No roles associated to this\nactivity",
"completed" => "終了率",
"Started" => "サイト設立日",
"Or upload a process using this form" => "Or upload a process using this\nform",
"No roles are defined yet so no roles can be mapped" => "No roles are\ndefined yet so no roles can be mapped",
"Create a gallery" => "新規ギャラリー",
"Edit this gallery:" => "このギャラリーを変更：",
"There are individual permissions set for this gallery" => "このギャラリーには個人権限が設定してあります",
"Images per row" => "1行あたりの画像数",
"Thumbnails size X" => "サムネイルの幅",
"Thumbnails size Y" => "サムネイルの高さ",
"Filesize" => "ファイル・サイズ",
"Available scales" => "可用スケール",
"No scales available" => "スケールはありません",
"Other users can upload images to this gallery" => "このギャラリーに他のユーザーが画像を追加するのを許可する",
"You can access the gallery using the following URL" => "ギャラリーをアクセスするのに、このURLをご利用下さい",
"Available Galleries" => "ギャラリーの一覧",
"Imgs" => "画像",
"Overwrite existing pages if the name is the same" => "Overwrite\nexisting pages if the name is the same",
"Previously remove existing page versions" => "Previously remove\nexisting page versions",
"Weeks" => "週間",
"LastChanges" => "最後の変更",
"hist" => "履歴",
"rollback" => "ロールバック",
"source" => "ソース",
"Pages like" => "類似ページ",
"List Articles" => "一覧の表示",
"edit new article" => "記事の新規作成",
"ExpireDate" => "期限切れ",
"AuthorName" => "作者",
"Create banner" => "バナー作成",
"create new blog" => "ブログの新規作成",
"Last Modified" => "最終変更日時",
"list faqs tpl" => "FAQSのTPLを表示",
"Edit this FAQ:" => "このFAQを編集する:",
"Create new FAQ" => "FAQの新規作成",
"Create New FAQ:" => "新規FAQ作成:",
"Users can suggest questions" => "ユーザーは質問を提案できる",
"Available FAQs" => "FAQの一覧",
"Listing Gallery" => "ギャラリーの一覧",
"upload file" => "ファイルのアップロード",
"Gallery Files" => "ギャラリーのファイル",
"move selected files" => "選択ファイルを移動",
"delete selected files" => "選択ファイルを削除",
"browse gallery" => "ギャラリーの閲覧",
"Gallery Images" => "ギャラリーの画像",
"visit the site for more games and fun" => "次のサイトをアクセスして数々のゲームなどをお楽しみください",
"edit blog" => "ブログの変更",
"Blog Title" => "ブログ・タイトル",
"edit new submission" => "記事を投稿する",
"Survey stats" => "サーベイの統計",
"adm" => "管理",
"Display" => "表示",
"Last mod" => "最終変更日時",
"Last author" => "最後の作者",
"Last ver" => "最後のバージョン",
"Com" => "コメント",
"Vers" => "バージョン数",
"with checked" => "チェックしたアイテムを",
"cancel request and leave a message" => "リクエストをキャンセルして伝言を残す",
"Remove old events" => "古いイベントを削除",
"duration" => "期間",
"Add or edit event" => "イベントの追加・変更",
"Mini Calendar: Preferences" => "ミニ・カレンダー：設定",
"Calendar Interval in daily view" => "カレンダー「日間」表示での合間",
"Start hour for days" => "一日の開始時間",
"End hour for days" => "一日の終了時間",
"Reminders" => "リマインダー",
"no reminders" => "リマインダーなし",
"Import CSV file" => "CVSファイルをインポート",
"Or enter path or URL" => "又は、パスやURLを入力",
"add topic" => "トピックを追加する",
"my tiki tpl" => "私のtikiのtpl",
"My pages" => "Wikiページ",
"My items" => "アイテム",
"My tasks" => "タスク",
"Your email address was removed from the list of subscriptors." => "Your\nemail address was removed from the list of subscriptors.",
"Newsgroup" => "ニュースグループ",
"Configure news servers" => "ネットニュースの設定",
"Select a news server to browse" => "ニュースサーバを選択する",
"server" => "サーバ",
"Add or edit a news server" => "ニュースサーバの追加/編集",
"News server" => "ニュースサーバ",
"Notes" => "メモ帳",
"quota" => "クォータ",
"Write a note" => "メモ作成",
"No notes yet" => "メモはまだありません",
"merge selected notes into" => "このメモに選択されたメモをマージする",
"Assign permissions to " => "次の人へ権限を割当てる ",
"Current permissions for this object" => "Current permissions for this\nobject",
"Assign permissions to this object" => "このオブジェクトに権限を割当てる",
"Votes" => "投票",
"Orphan Pages" => "遺児ページ",
"Assign permissions to page" => "ページに権限の割り当て",
"Current permissions for this page" => "このページの現在の権限設定",
"this page" => "割当",
"Send email notifications when this page changes to" => "変更時のメール通知",
"add email" => "メールアドレスを加える",
"Notifications" => "通知先",
"Pick your avatar" => "アバターを選択",
"Your current avatar" => "現在のアバター",
"Pick avatar from the library" => "ライブラリからアバターを選択",
"Show all" => "全て表示",
"random" => "ランダム",
"Upload your own avatar" => "自作アバターを登録する",
"lastModif" => "最終更新日",
"Other Polls" => "その他のアンケート",
"Print multiple pages" => "複数ページの印刷",
"Print Wiki Pages" => "Wikiページの印刷",
"clear" => "クリア",
"Quiz result stats" => "クイズ結果の統計",
"Quiz" => "クイズ",
"Stats for quizzes" => "全クイズの統計",
"taken" => "受数",
"Stats for quiz" => "クイズの統計",
"clear stats" => "統計のクリアー",
"Stats for this quiz Questions " => "このクイズ質問の統計",
"Received Articles" => "受信記事",
"Edit received article" => "受信記事の編集",
"Accept Article" => "記事を承諾する",
"Site" => "サイト",
"Edit received page" => "受信ページの編集",
"last" => "以前",
"I forgot my password" => "パスワードを忘れた",
"send me my password" => "パスワードを送って下さい",
"Return to HomePage" => "ホームページに戻る",
"Remove page" => "ページの削除",
"You are about to remove the page" => "Wikiページ",
"permanently" => "を削除します。この操作は元に戻すことが出来ません",
"Remove all versions of this page" => "このページの全バージョンも削除する",
"Rename page" => "名前の変更",
"Rollback page" => "ページのロールバック",
"Search Stats" => "検索の統計",
"galleries" => "ギャラリー",
"blog posts" => "ブログのポスト",
"articles" => "記事",
"trackers" => "トラッカー",
"No pages matched the search criteria" => "検索条件に一致したページはありませんでした",
"Send blog post" => "ブログ・ポスト送信",
"A link to this post was sent to the following addresses:" => "次のアドレスにこのポストへのリンクは送信されました:",
"List of email addresses separated by commas" => "半角英文字の「コンマ」で区切った数個のメール・アドレス（例：ky@hoge.jp, ju@hoge.jp）",
"Send objects" => "オブジェクトを送信する",
"Transmission results" => "送信結果",
"Send objects to this site" => "他のサイトにオブジェクトを送信する",
"site" => "サイト",
"password" => "パスワード",
"Send Wiki Pages" => "Wikiページを送る",
"Send Articles" => "記事を送る",
"add article" => "記事を選択する",
"Tiki Shoutbox" => "Tiki 伝言板",
"Post or edit a message" => "メッセージを投稿または編集する",
"CMS" => "CMS(記事)",
"Site Stats" => "サイトの統計",
"Days online" => "オンライン日数",
"Total pageviews" => "全ページビュー数",
"Average pageviews per day" => "リクエスト成功件数日別平均",
"Best day" => "最高日",
"Worst day" => "最低日",
"Wiki Stats" => "Wikiの統計",
"Size of Wiki Pages" => "Wikiページ･サイズ合計",
"Average page length" => "ページ長さ、平均",
"bytes" => "バイト数",
"Average versions per page" => "ページ・バージョン数平均",
"Visits to wiki pages" => "Wikiページ・リクエスト成功件数合計",
"Average links per page" => "ページ毎リンク数平均",
"Image galleries Stats" => "画像キャラリーの統計",
"Average images per gallery" => "ギャラリー毎画像数平均",
"Total size of images" => "画像サイズ合計",
"Average image size" => "画像サイズ平均",
"Visits to image galleries" => "画像ギャラリー・リクエスト成功件数合計",
"File galleries Stats" => "ファイル・ギャラリーの統計",
"Average files per gallery" => "画像ギャラリー毎ファイル数平均",
"Total size of files" => "ファイル・サイズ合計",
"Average file size" => "ファイル・サイズ平均",
"Visits to file galleries" => "ファイル・ギャラリー リクエスト成功件数合計",
"CMS Stats" => "CMS（記事）の統計",
"Total reads" => "記事中閲覧数合計",
"Average reads per article" => "記事毎中閲覧数平均",
"Total articles size" => "記事サイズ合計",
"Average article size" => "記事サイズ平均",
"Forum Stats" => "フォーラムの統計",
"Total topics" => "トピック数合計",
"Average topics per forums" => "フォーラム毎トピック数平均",
"Total threads" => "スレッド数合計",
"Average threads per topic" => "トピック毎スレッド数平均",
"Visits to forums" => "フォーラム リクエスト成功件数",
"Blog Stats" => "ブログの統計",
"Weblogs" => "ブログ数",
"Total posts" => "ポスト数合計",
"Average posts per weblog" => "ブログ毎ポスト数平均",
"Total size of blog posts" => "ポストサイズ合計",
"Average posts size" => "ポストサイズ平均",
"Visits to weblogs" => "ブログ リクエスト成功件数",
"Poll Stats" => "アンケートの統計",
"Total votes" => "票数",
"Average votes per poll" => "アンケート毎票数平均",
"Faq Stats" => "FAQの統計",
"Total questions" => "質問数合計",
"Average questions per FAQ" => "FAQ毎質問数平均",
"User Stats" => "ユーザーの統計",
"User bookmarks" => "ユーザー・ブックマーク数",
"Average bookmarks per user" => "ユーザー毎ブックマーク数平均",
"Quiz Stats" => "クイズの統計",
"Average questions per quiz" => "クイズ毎質問数平均",
"Quizzes taken" => "クイズ開始数",
"Average quiz score" => "クイズ点数平均",
"Average time per quiz" => "クイズ終了時間平均",
"Object" => "オブジェクト",
"Usage chart" => "統計チャート",
"Stats for surveys" => "全サーベイの統計",
"Survey" => "サーベイ",
"Last taken" => "最終受日",
"Stats for survey" => "サーベイの統計",
"Stats for this survey Questions " => "このサーベイの質問に関する統計",
"If not then a theme for the section is used" => "If not then a theme\nfor the section is used",
"If none of the above was selected the user theme is used" => "If none\nof the above was selected the user theme is used",
"Assign themes to categories" => "カテゴリにテーマを割当てる",
"Assigned categories" => "割当カテゴリ",
"Assign themes to objects" => "オブジェクトにテーマを割当てる",
"Assigned objects" => "割当オブジェクト",
"Assign themes to sections" => "セクションにテーマを割当てる",
"Assigned sections" => "割当セクション",
"Upload File" => "ファイルのアップロード",
" or upload a local file from your disk" => " or upload a local file\nfrom your disk",
"The following file was successfully uploaded" => "次のファイルのアップロードが成功しました",
"You can include the file in an HTML/Tiki page using" => "次の文字列を選択、コピー・ペーストすると、ファイルをHTMLやWikiページに含めます",
"Now enter the image URL" => "画像のURLを入力する",
" or upload a local image from your disk" => " か、ローカル・ディスクから画像をアップロードする",
"Thumbnail (optional, overrides automatic thumbnail generation)" => "サムネール画像 (このオプションで自動サムネール作成をオーバライド)",
"Upload successful!" => "アップロード成功!",
"The following image was successfully uploaded" => "画像のアップロードは成功しました",
"Thumbnail" => "サムネール",
"You can include the image in an Wiki page using" => "次の文字列を選択、コピー・ペーストすると、画像をWikiページに含めます",
"User assigned modules" => "ユーザー割当モジュール",
"User Assigned Modules" => "ユーザ割当モジュール",
"Restore defaults" => "規定値に戻す",
"move to right column" => "右列へ移動",
"unassign" => "割当解除",
"move to left column" => "左列へ移動",
"Assign module" => "モジュールの割当",
"Module" => "モジュール",
"Column" => "列",
"Current folder" => "現在のフォルダー",
"Folders" => "フォルダー",
"remove folder" => "フォルダーを削除",
"refresh cache" => "キャッシュを更新",
"Admin folders and bookmarks" => "フォルダーとブックマークを管理する",
"Add or edit folder" => "フォルダーの追加・変更",
"Add or edit a URL" => "URLの追加・変更",
"Avatar" => "アバター",
"Personal Wiki Page" => "個人のWikiページ",
"Displayed time zone" => "表示する時間帯",
"Send me a message" => "私にメッセージを送る",
"User Preferences" => "ユーザー設定",
"Pick user Avatar" => "アバターを選択",
"HomePage" => "ホームページ",
"Your personal Wiki Page" => "自分のWikiページ",
"Is email public? (uses scrambling to prevent spam)" => "メールアドレスを公開しますか? (spam防止のためにスクランブル表示されます)",
"Number of visited pages to remember" => "閲覧履歴を残しておくページ数",
"UTC" => "協定世界時UTC",
"Local" => "現地時間帯",
"User information" => "ユーザー情報",
"private" => "非公開",
"public" => "公開",
"Messages per page" => "1ページあたりのメッセージ表示数",
"Allow messages from other users" => "他のユーザーからのメッセージを受け付ける",
"Send me an email for messages with priority equal or greater than" => "この優先順位かそれ以上のTikiメッセージを、私のメールの転送する",
"Tasks per page" => "ページ毎タスク数",
"My messages" => "メッセージ",
"Percentage completed" => "終了率",
"priority" => "優先順位",
"No tasks entered" => "タスクは登録されていない",
"May need to refresh twice to see changes" => "May need to refresh twice\nto see changes",
"Add top level bookmarks to menu" => "上層のブックマークをメニューに追加",
"Pos" => "位置",
"Mode" => "モード",
"replace window" => "現在のウィンドウで開く",
"no comments" => "コメントはありません",
"Banner stats" => "バナー統計",
"mon" => "月",
"tue" => "火",
"wed" => "水",
"thu" => "木",
"fri" => "金",
"sat" => "土",
"sun" => "日",
"This is a cached version of the page." => "This is a cached version of\nthe page.",
"Click here to view the Google cache of the page instead." => "クリックしてページのGoogleキャッシュ・バージョンを見る",
"info/vote" => "情報・投票",
"View or vote items not listed in the chart" => "View or vote items not\nlisted in the chart",
"Select something to vote on" => "投票する項目を選んで下さい",
"Vote this item" => "このアイテムについて投票する",
"view faq" => "FAQの表示",
"view faq tpl" => "FAQのTPLを表示",
"admin menus tpl" => "メニューのTPLを管理",
"Forum List" => "フォーラムの一覧",
"Edit Forum" => "フォーラム変更",
"monitor this forum" => "フォーラム監視開始",
"stop monitoring this forum" => "フォーラム監視中止",
"You have to enter a title and text" => "タイトルとテキストを入力して下さい",
"post new comment" => "コメントを追加する",
"HTML tags are not allowed inside comments" => "HTMLタグはコメント本文では使用できません",
"topics in this forum" => "このフォーラムのトピック",
"Jump to forum" => "フォーラムへ移動",
"monitor this topic" => "トピック監視開始",
"stop monitoring this topic" => "トピック監視中止",
"Comments below your current threshold" => "Comments below your current\nthreshold",
"Insert new item" => "新規アイテム",
"View item" => "アイテム詳細",
"Add a comment" => "コメント追加",
"Attach a file to this item" => "アイテムにファイルを添付する",
"No attachments for this item" => "アイテムには添付はありません",
"Details" => "詳細",
"settings" => "設定",
"mailbox" => "メールボックス",
"compose" => "作成",
"contacts" => "連絡先",
"Contacts" => "連絡先",
"Add new mail account" => "メールアカウントの新規作成",
"User accounts" => "メールアカウント一覧",
"account" => "アカウント",
"pop" => "POP",
"View All" => "全てを表示",
"back to mailbox" => "メールボックスへ戻る",
"full headers" => "全てのヘッダー",
"normal headers" => "通常のヘッダー",
"reply all" => "全員に返信",
"forward" => "転送",
"Create/edit contacts" => "連絡先の追加・変更",
"First Name" => "名",
"Last Name" => "妙",
"select from address book" => "アドレス帳から選択する",
"cc" => "CC",
"bcc" => "BCC",
"Use HTML mail" => "HTMLメールを使う",
"The following addresses are not in your address book" => "次のアドレスはアドレス帳に登録されてません",
"add contacts" => "連絡先を追加",
"Attachment 1" => "添付1",
"Attachment 2" => "添付2",
"Attachment 3" => "添付3",
"Address book" => "アドレス帳",
"General preferences and settings" => "全体の設定と機能",
"Wiki settings" => "Wiki設定",
"Poll comments settings" => "アンケートにおけるコメントの設定",
"Forums settings" => "フォーラムの設定",
"Search settings" => "検索の設定",
"No chart indicated" => "チャートが指定されてない",
"Upload failed" => "Upload失敗",
"You have to provide a hotword and a URL" => "HotwordとURLを入れて下さい",
"No page indicated" => "ページが指定されてない",
"The passwords don't match" => "入力したパスワードは一致しない",
"Password should be at least" => "パスワードは少なくとも",
"characters long" => "文字にして下さい",
"Your admin password has been changed" => "管理者パスワードを変更しました",
"DATE-of" => "of",
"All Fields except gdaltindex must be filled" => "gdaltindex以外のフィールドを入力して下さい",
"Tag already exists" => "タグは既に存在します",
"Tag not found" => "タグが見つかりません",
"Repository name can't be an empty" => "Repository名を入力して下さい",
"Requested action is not supported on repository" => "ご依頼の操作はレポジトリーでサポートされてません",
"No repository" => "レポジトリーはありません",
"Search is mandatory field" => "「検索」は必須フィールドです",
"File not found " => "ファイルを見つかりませんでした",
"Requested action in not supported on repository" => "ご依頼の操作はレポジトリーでサポートされてません",
"Non-existent link" => "存在しないリンク",
"No menu indicated" => "メニューが指定されてない",
"No newsletter indicated" => "ニュースレターが指定されてない",
"No poll indicated" => "アンケートが指定されてない",
"You must specify a page name, it will be created if it doesn't exist." => "ページ名を記入して下さい。存在してなければ、作成されます。",
"page not added (Exists)" => "ページが存在する為、追加してない",
"No survey indicated" => "サーベイは指定されてません",
"No tracker indicated" => "トラッカーが指定されてない",
"Group already exists" => "グループが既に存在してます",
"No records were found. Check the file please!" => "レコードは見つからないので、ファイル中身を確認して下さい",
"User login is required" => "ユーザー・ログインが必要です",
"Password is required" => "パスワードが必要です",
"Email is required" => "メール・アドレスが必要です",
"User is duplicated" => "ユーザーは重なってます",
"User already exists" => "ユーザーが既に存在してます",
"The passwords dont match" => "パスワードが一致されない",
"Password must contain both letters and numbers" => "パスワードには、半角英文字も英数字もお使い下さい",
"rss feed disabled" => "RSSフィード無効",
"Permission denied you cannot view this section" => "このセクションの閲覧は許可されていません",
"Unknown group" => "判明できないグループ",
"Group doesnt exist" => "グループは存在しません",
"Unknown user" => "判明できないユーザー",
"User doesnt exist" => "ユーザーが存在しない",
"Permission denied you cannot view backlinks for this page" => "権限が無い為、このページのバックリンクを表示できません",
"The page cannot be found" => "ページはありません",
"Invalid directory name" => "ディレクタリー名は無効です",
"Permission denied you cannot post" => "拒否の為ポストはできません",
"Permission denied you cannot edit this post" => "拒否の為このポストの編集はできません",
"You can't post in any blog maybe you have to create a blog first" => "ブログを新規作成してからポストして下さい",
"Top visited blogs" => "アクセス数の多いブログ",
"Last posts" => "最近のポスト",
"Top active blogs" => "アクティビティーの多いブログ",
"No blogId specified" => "blogIdが特定されていない",
"TOP" => "上",
"Permission denied you cannot access this gallery" => "このギャラリーの利用は許可されていません",
"No gallery indicated" => "ギャラリーが指定されてない",
"Permission denied you cannot view this page" => "このページの閲覧は許可されていません",
"Permission denied you can not view this section" => "このセクションの閲覧は許可されていません",
"Permission denied you cannot remove images from this gallery" => "このギャラリーでの画像の削除は許可されていません",
"Permission denied you cannot rebuild thumbnails in this gallery" => "このギャラリーでのサムネイルの作成は許可されていません",
"Permission denied you cannot rotate images in this gallery" => "このギャラリーでの画像の回転は許可されていません",
"No image indicated" => "画像が指定されてない",
"Permission denied you cannot move images from this gallery" => "権限が無い為、このギャラリーから画像を移動できません",
"Permission denied you cannot view the calendar" => "カレンダーの閲覧は許可されていません",
"event without name" => "名前のないイベント",
"You can not use the same password again" => "同じパスワードは利用できません",
"Invalid old password" => "古いパスワードが無効",
"Permission denied to use this feature" => "権限が無い為、この機能が使えない",
"No channel indicated" => "チャンネルが指定されてない",
"No nickname indicated" => "ニックネームが指定されてない",
"Top authors" => "トップ作者",
"Message sent to" => "次の方へメッセージを送信しました",
"This feature has been disabled" => "この機能は無効に設定してあります",
"Must enter a name to add a site. " => "サイト追加するのに、名前が必要。",
"Must enter a url to add a site. " => "サイト追加するのに、URLが必要。",
"URL already added to the directory. Duplicate site? " => "URLは既にディレクタリーに存在してます。サイトは複製してませんか？",
"URL cannot be accessed wrong URL or site is offline and cannot be added to the directory. " => "URLにアクセスできません。URLに誤りがあるか、サイトがオフラインになっている為、ディレクタリーに追加できません。",
"Must select a category. " => "カテゴリを選択して下さい。",
"Must enter a name to add a site" => "サイト追加には、名前が必要",
"Must enter a url to add a site" => "サイト追加には、URLが必要",
"URL already added to the directory. Duplicate site?" => "追加URLは既に存在してます。重ねてませんか？",
"URL cannot be accessed: wrong URL or site is offline and cannot be added to the directory" => "URLにアクセスできません。URLに誤りがあるか、サイトがオフラインになっている為、ディレクタリーに追加できません。",
"Must select a category" => "カテゴリーの選択が必要",
"No site indicated" => "サイトが指定されてない",
"You can not download files" => "ファイルのダウンロードができない",
"Permission denied you cannot edit this article" => "権限が無い為、この記事を編集できません",
"You do not have permissions to edit banners" => "バナーの編集権限はありません",
"Banner not found" => "バナーが見つかりません",
"Permission denied you cannot create or edit blogs" => "操作は拒否されました：ブログの作成や変更はできません",
"Permission denied you cannot edit this blog" => "操作は拒否されました：ブログの変更はできません",
"No content id indicated" => "コンテントIDが指定されてない",
"No question indicated" => "質問が指定されてない",
"No quiz indicated" => "クイズが指定されてない",
"No structure indicated" => "ストラクチャーが指定されてない",
"Invalid structure_id or page_ref_id" => "structure_id又はpage_ref_idは無効です",
"No topic id specified" => "トピックIDは特定してない",
"Invalid topic id specified" => "トピックのIDは無効です",
"Article not found" => "記事が見つかりませんでした",
"Can't import remote HTML page" => "そのリモートHTMLページをインポートできません",
"Can't parse remote HTML page" => "そのリモートHTMLページを読み込む（Parse）出来ません",
"The SandBox is disabled" => "「砂箱」は無効に設定したあります",
"No galleryId specified" => "ギャラリーIDは特定されてません",
"No forum indicated" => "フォラムの指定はありません",
"Forum posts" => "フォーラム・ポスト",
"No forumId specified" => "フォーラムIDは特定されてません",
"Invalid username" => "ユーザー名が無効です",
"No process indicated" => "プロセスが指定されてない",
"No instance indicated" => "インスタンスが指定されてない",
"No activity indicated" => "アクティビティーが指定されてない",
"No user indicated" => "ユーザーが指定されてない",
"No item indicated" => "アイテムが指定されてない",
"No repository given" => "レポジトリーは特定されてません",
"Permission denied you cannot remove this blog" => "操作は拒否されました：ブログの削除はできません",
"You cannot admin blogs" => "ブログの管理権限はありません",
"You have to enable cookies to be able to login to this site" => "このサイトを利用するのにブラウザーのクッキーを有効にして下さい",
"changed" => "変更された",
"You do not have permissions to view the maps" => "地図の閲覧は許可されてません",
"mapfile name incorrect" => "マップファイル名は間違えってます",
"This mapfile already exists" => "そのマップファイル名は既に存在してます",
"You do not have permission to write to the mapfile" => "マップファイルへの書き込みは許可されてません",
"You do not have permission to delete the mapfile" => "マップファイルの削除は許可されてません",
"You do not have permission to read the mapfile" => "マップファイルの読み込みは許可されてません",
"You do not have permissions to view the layers" => "レイヤーの閲覧は許可されてません",
"Could not upload the file" => "ファイルのアップロードできませんでした",
"You do not have permissions to delete a file" => "ファイルの削除は許可されてません",
"File not found" => "ファイルを見つかりませんでした",
"You do not have permissions to create a directory" => "ディレクタリー作成は許可されてません",
"The Directory is not empty" => "ディレクタリーは空じゃありません",
"You do not have permissions to delete a directory" => "ディレクタリーの削除は許可されてません",
"You do not have permissions to create an index file" => "インデックス・ファイルの作成は許可されてません",
"Invalid file name" => "ファイル名は無効です",
"Invalid files to index" => "インデックスするのに、無効なファイル",
"I do not know where is gdaltindex. Set correctly the Map feature" => "gdaltindexが見つかりません。地図機能を正しく設定して下さい",
"I could not create the index file" => "インデックス・ファイル作成出来ませんでした",
"No server indicated" => "サーバーが指定されてない",
"No note indicated" => "ノートが指定されてない",
"No name indicated for wiki page" => "Wikiページの名前が指定されてない",
"Page already exists" => "ページが既に存在されてます",
"Permission denied you cannot assign permissions for this page" => "拒否されたためこのページの権限割当できません",
"No article indicated" => "記事が指定されてない",
"No post indicated" => "ポストが指定されてない",
"Blog not found" => "ブログは見つかりませんでした",
"No pages indicated" => "ページが指定されてない",
"No result indicated" => "結果が指定されてない",
"Permision denied" => "拒否されました",
"Wrong registration code" => "登録コードが違います",
"Username is too long" => "ユーザー名が長すぎます",
"Username cannot contain whitespace" => "ユーザー名には、空白を含まないで下さい",
"Wrong passcode you need to know the passcode to register in this site" => "パスコードが違います。パスコードを貰ってから登録して下さい",
"Invalid email address. You must enter a valid email address" => "メールアドレスが無効です。有効なアドレスをご記入下さい",
"to the registered email address for" => "次のアカウントで登録されたアドレスへ送信されました：",
"Invalid or unknown username" => "ユーザー名が無効です",
"Permission denied you cannot remove versions from this page" => "権限がない為、このページからバージョンを削除することが出来ません",
"Cannot rename page maybe new page already exists" => "記入した名前が存在する可能性がある為、名前変更できません",
"Non-existent version" => "バージョンが存在しない",
"Permission denied you cannot rollback this page" => "権限がない為、ページのロールバックが出来ません",
"You cannot take this quiz twice" => "このクイズを再び受けることができません",
"You cannot take this survey twice" => "このサーベイを再び受けることが出来ません",
"The passwords did not match" => "パスワードは一致されませんでした",
"unicode" => "Unicode",
"Non-existent user" => "ユーザーが存在しない",
"No banner indicated" => "バナーが指定されてない",
"No blog indicated" => "ブログの指定はありません",
"No faq indicated" => "FAQは指定されてない",
"You are not permitted to remove someone else\\'s post!" => "他人のポストを削除することは許可されてません!",
"No thread indicated" => "スレッドの指定はありません",
"Cancel monitoring" => "監視中止",
"Monitor" => "監視開始",
"Top pages" => "トップ・ページ",
"Last pages" => "最近のページ",
"###end###"=>"###end###");
?>
