/**
 * Copyright (C) 2007-2012 Lawrence Murray
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by the Free
 * Software Foundation; either version 2 of the License, or (at your option)
 * any later version.
 * 
 * @author Lawrence Murray <lawrence@indii.org>
 * $Rev: 363 $
 * $Date: 2012-01-22 18:45:43 +0800 (Sun, 22 Jan 2012) $
 */
#include "OpenRecentMenu.hpp"

#include "../meta.hpp"

#include "wx/config.h"
#include "wx/filename.h"

#include <vector>

using namespace indii;

void OpenRecentMenu::OnShow(wxMenuEvent& evt) {
  /* clear current menu */
  while (this->GetMenuItemCount() > 0) {
    this->Destroy(this->FindItemByPosition(0));
  }
  
  /* add recent files */
  wxString key, path;
  bool have;
  long index;
  int id = 300;
  wxConfig config(_(PACKAGE_TARNAME), _("indii.org"));
  config.SetPath(_("OpenRecentFiles"));
  
  have = config.GetFirstEntry(key, index);
  while (have) {
    path = config.Read(key);
    wxFileName file(path);
    this->Append(id, file.GetFullName());
    ++id;
    have = config.GetNextEntry(key, index);
  }
  
  /* add clear recent item */
  if (config.GetNumberOfEntries() > 0) {
    this->AppendSeparator();
  }
  this->Append(ID_CLEAR_RECENT, _("Clear Menu"));
  this->Enable(ID_CLEAR_RECENT, config.GetNumberOfEntries() > 0);
}

void OpenRecentMenu::OnClearRecent(wxCommandEvent& evt) {
	Clear();
}

void OpenRecentMenu::AddFile(const wxString& path) {
  wxFileName file(path);
  file.Normalize();

  /* build new list */
  std::vector<wxString> values;
  wxString key, value;
  bool have;
  long index;
  
  {
    wxConfig config(_(PACKAGE_TARNAME), _("indii.org"));
    config.SetPath(_("OpenRecentFiles"));

    values.push_back(file.GetFullPath());
    have = config.GetFirstEntry(key, index);
    while (have && values.size() < MAX_FILES) {
      value = config.Read(key);
      if (!file.GetFullPath().IsSameAs(value)) {
        values.push_back(value);
      }
      have = config.GetNextEntry(key, index);
    }
  }

  /* write new list */  
  Clear();
  {
    wxConfig config(_(PACKAGE_TARNAME), _("indii.org"));
    config.SetPath(_("OpenRecentFiles"));
    for (unsigned i = 0; i < values.size(); ++i) {
	    key.Clear();
 	    key << _("File") << i;
      config.Write(key, values[i]);
    }
  }
}

void OpenRecentMenu::RemoveFile(const wxString& path) {
  wxConfig config(_(PACKAGE_TARNAME), _("indii.org"));
  config.SetPath(_("OpenRecentFiles"));
  
  wxFileName file(path);
  file.Normalize();
  
  std::vector<wxString> keys;
  std::vector<wxString>::iterator iter;
  wxString key, value;
  bool have;
  long index;
  
  have = config.GetFirstEntry(key, index);
  while (have) {
    value = config.Read(key);
    if (file.GetFullPath().IsSameAs(value)) {
      keys.push_back(key);
    }
    have = config.GetNextEntry(key, index);
  }
  for (iter = keys.begin(); iter != keys.end(); ++iter) {
    config.DeleteEntry(*iter);
  }
}

wxString OpenRecentMenu::GetFile(const int id) {
  wxConfig config(_(PACKAGE_TARNAME), _("indii.org"));
  config.SetPath(_("OpenRecentFiles"));

	wxString key, path;
  bool have;
  long index;
  int i = 0;
  
  have = config.GetFirstEntry(key, index);
  while (have && i + 300 < id) {
    have = config.GetNextEntry(key, index);
    ++i;
  }
  if (i + 300 == id) {
    path = config.Read(key);
  }
  
  return path;
}

void OpenRecentMenu::Clear() {
  wxConfig config(_(PACKAGE_TARNAME), _("indii.org"));
  config.DeleteGroup(_("OpenRecentFiles"));
}

BEGIN_EVENT_TABLE(OpenRecentMenu, wxMenu)
#ifdef __WXOSX__
/* events handled here on Mac, in TintWindow on other platforms */
EVT_MENU_OPEN(OpenRecentMenu::OnShow)
EVT_MENU(ID_CLEAR_RECENT, OpenRecentMenu::OnClearRecent)
#endif
END_EVENT_TABLE()
