##############################################################################
#
# Copyright (c) 2004 TINY SPRL. (http://tiny.be) All Rights Reserved.
#                    Fabien Pinckaers <fp@tiny.Be>
#
# WARNING: This program as such is intended to be used by professional
# programmers who take the whole responsability of assessing all potential
# consequences resulting from its eventual inadequacies and bugs
# End users who are looking for a ready-to-use solution with commercial
# garantees and support are strongly adviced to contract a Free Software
# Service Company
#
# This program is Free Software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; either version 2
# of the License, or (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
#
##############################################################################

import gtk
from gtk import glade
import gettext

import rpc
import widget

import common
import win_search
import copy

def _form_read(name, value):
	if len(value[1])==0:
		return []
	res = rpc.session.rpc_exec_auth('/object', 'execute', value[0], 'read', value[1], False, value[2])
	return res

def _template_get(name, value):
	if (len(value)==2) or (not value[2]):
		res = rpc.session.rpc_exec_auth('/object', 'execute', value[0], 'fields_view_get', 0, value[1])
	else:
		view_id = rpc.session.rpc_exec_auth('/object', 'execute', 'ir.ui.view', 'search', [('name','=',value[2])])
		res = rpc.session.rpc_exec_auth('/object', 'execute', value[0], 'fields_view_get', view_id[0], value[1])
	return (res['fields'], res['model'], res['arch'])

def _many2one_sel(name, value):
	if len(value)==7:
		sel_multi = value[6]
	else:
		sel_multi = False
	ids = rpc.session.rpc_exec_auth('/object', 'execute', value[3], 'name_search', value[2], value[4])
	if len(ids)==1:
		return ids[0]
	res = rpc.session.rpc_exec_auth('/object', 'execute', value[3], 'fields_view_get', False, 'form')
	win = win_search.win_search(value[3], res, {'name':value[2]}, [], sel_multi=sel_multi, preload=True, ids=map(lambda x:x[0], ids), context=value[5])
	res = win.go()
	if res:
		res2 = rpc.session.rpc_exec_auth('/object', 'execute', value[3], 'name_get', res)
		if sel_multi:
			return res2
		return res2[0]
	return None

def _default_get(name, value):
	return rpc.session.rpc_exec_auth('/object', 'execute', value[0], 'default_get', value[1])

def _many2many_name_get(name, value):
	return rpc.session.rpc_exec_auth('/object', 'execute', value[0], 'name_get', value[1])

def _many2one_name_get(name, value):
	name = rpc.session.rpc_exec_auth('/object', 'execute', value[1], 'name_get', [value[0]])
	if not len(name):
		return None
	return name[0]

def _char_selection(domain, args):
	res = rpc.session.rpc_exec_auth('/object', 'execute', args[0], 'distinct_field_get', args[1], args[2], domain)
	if len(res)>1:
		d = {}
		for x in res:
			d[x]=x
		res = common.selection(_('select field value:'), d)
		if res:
			return res[1]
		else:
			return None
	elif len(res)==1:
		return res[0]
	else:
		return None


class win_preference(object):
	def __init__(self, model, id, preferences):
		self.glade = glade.XML(common.terp_path("terp.glade"),'win_preference',gettext.textdomain())
		self.win = self.glade.get_widget('win_preference')
		self.id = id
		self.model = model


		self.triggers = [('template_get', _template_get, None), 
			('name_id_get', _many2one_name_get, None),
			('form_read', _form_read, None),
			('names_get', _many2many_name_get, None),
			('many2one_sel', _many2one_sel, None),
			('default_get', _default_get, None)
			]


		fields = {}
		arch = '<?xml version="1.0"?><form string="%s">\n' % (_('Preferences'),)
		for p in preferences:
			arch+='<field name="%s" colspan="4"/>' % (p[1],)
			fields[p[1]] = p[3]
		arch+= '</form>'
		self.form = widget.form(arch, fields, model, triggers = self.triggers)

		default = rpc.session.rpc_exec_auth('/object', 'execute', 'ir.values', 'get', 'meta', False, [(self.model,self.id)], False, rpc.session.context, True, True, False)
		default2 = {}
		self.default = {}
		for d in default:
			default2[d[1]] = d[2]
			self.default[d[1]] = d[0]
		self.form.value = default2

		vbox = self.glade.get_widget('preference_vbox')
		vbox.pack_start(self.form.widget)

		self.win.set_title(_('Preference')+' '+model)
		self.win.show_all()

	def run(self, datas={}):
		final = False
		while True:
			res = self.win.run()
			if self.form.validate() or (self.states[res]=='end'):
				break
		if res==gtk.RESPONSE_OK:
			final = True

			val = copy.copy(self.form.value)
			for key, value in val.items():
				if value and self.form.fields.get(key, False) and self.form.fields[key]['type'] in ('many2one',):
					val[key] = val[key][0]

			for key in val:
				if val[key]:
					rpc.session.rpc_exec_auth('/object', 'execute', 'ir.values', 'set', 'meta', key, key, [(self.model,self.id)], val[key])
				elif self.default.get(key, False):
					rpc.session.rpc_exec_auth('/common', 'ir_del', self.default[key])

		self.win.destroy()
		return final

