##############################################################################
#
# Copyright (c) 2004 TINY SPRL. (http://tiny.be) All Rights Reserved.
#                    Fabien Pinckaers <fp@tiny.Be>
#
# WARNING: This program as such is intended to be used by professional
# programmers who take the whole responsability of assessing all potential
# consequences resulting from its eventual inadequacies and bugs
# End users who are looking for a ready-to-use solution with commercial
# garantees and support are strongly adviced to contract a Free Software
# Service Company
#
# This program is Free Software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; either version 2
# of the License, or (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
#
##############################################################################

import gobject
import gtk
from gtk import glade

import copy

import wid_int
import wid_common
import common
from widget import tree

class many2many(wid_int.wid_int):
	def __init__(self, parent, attrs={}):
		wid_int.wid_int.__init__(self, parent, attrs)

		self.win_gl = glade.XML(common.terp_path("terp.glade"),"widget_many2many")
		self.win_gl.signal_connect('on_m2m_but_add_pressed', self._sig_add )
		self.win_gl.signal_connect('on_m2m_but_remove_pressed', self._sig_remove )
		self.win_gl.signal_connect('on_m2m_but_refresh_pressed', self._sig_refresh )

		vbox = gtk.VBox(homogeneous=False, spacing=1)
		vbox.pack_start(self.win_gl.get_widget('widget_many2many'))
		if attrs.get('view_data_tree'):
			res = attrs.get('view_data_tree')
			(fields, model, xml) = (res['fields'], res['model'], res['arch'])
		else:
			(fields, model, xml) = self.trigger('template_get', (attrs['relation'],'tree',attrs.get('view_tree',False)))

		self.tree=tree.tree(xml, fields, model, parent=self)
		self.model = model

		self.treeview = self.tree.widget
		self.win_gl.get_widget('scrolledwindow7').add(self.tree.widget)
		self.widget = vbox

		self.model_type = attrs['relation']

		self.wid_text = self.win_gl.get_widget('ent_many2many')
		self.wid_text.connect('activate', self._sig_activate)
		self.wid_text.connect('button_press_event', self._menu_open)
		self._value=[]
		self.clear()

	def _menu_sig_pref(self, obj):
		self._menu_sig_default_set()

	def _menu_sig_default(self, obj):
		res = rpc.session.rpc_exec_auth('/object', 'execute', self.attrs['model'], 'default_get', [self.attrs['name']])
		self.value = res.get(self.attrs['name'], False)

	def _list_reload(self):
		self.tree.value = self._value

	def _sig_add(self, *args):
		arg = self._domain_get(self.parent)
		arg2 = self._context_get(self.parent)
		vals = self.trigger('many2one_sel', (self.parent.model, self.name, self.wid_text.get_text(), self.model_type, arg, arg2, True))
		if vals:
			if type(vals[0]) == list:
				value = [x[0] for x in vals]
			else:
				value = [vals[0]]
			resources = self.trigger('form_read', (self.model, value, arg2))
			if resources:
				for val in resources:
					self._value.append( val )
					if self.attrs.get('on_change',False):
						self.on_change(self.attrs['on_change'])
		self.wid_text.set_text('')
		self._list_reload()

	def _sig_remove(self, *args):
		pos = self.tree.pos_get()
		if pos!=None:
			del self._value[pos]
			self._list_reload()

	def _sig_refresh(self, *args):
		self._list_reload()

	def _sig_activate(self, *args):
		self._sig_add()

	def _value_set(self, value):
		if value and isinstance(value[0], list):
			value = value[0]
		self.modifs = {}
		self._value = []
		self._history = []
		
		arg2 = self._context_get(self.parent)
		if value and not isinstance(value[0], (int, long)):
			value = value[0][2]
		resources = self.trigger('form_read', (self.model, value, arg2))
		for r in resources:
			for k in r.keys():
				if r[k]=='':
					r[k] = False
		self._value = copy.copy(resources)
		self._list_reload()
		return

	def _value_get(self):
		return [(6,0, [ x['id'] for x in self._value ])]

	def clear(self):
		self._value = []
		self._list_reload()

	value2 = property(_value_get, _value_set, None,
	'The content of the widget or ValueError if not valid')
	value = property(_value_get, _value_set, None,
	'The content of the widget or ValueError if not valid')

