##############################################################################
#
# Copyright (c) 2006 TINY SPRL. (http://tiny.be) All Rights Reserved.
#
# $Id: form.py 3077 2006-05-03 18:26:02Z pinky $
#
# WARNING: This program as such is intended to be used by professional
# programmers who take the whole responsability of assessing all potential
# consequences resulting from its eventual inadequacies and bugs
# End users who are looking for a ready-to-use solution with commercial
# garantees and support are strongly adviced to contract a Free Software
# Service Company
#
# This program is Free Software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; either version 2
# of the License, or (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
#
##############################################################################

from widget import ViewWidget

class ViewForm(object):
	def __init__(self, screen, widget, children, buttons=[]):
		self.view_type = 'form'
		self.screen = screen
		self.widget = widget
		self.model_add_new = False
		self.buttons = buttons
		for button in self.buttons:
			button.form = self

		self.widgets = dict([(name, ViewWidget(self, widget, name))
							 for name, widget in children.items()])

	def __getitem__(self, name):
		return self.widgets[name]
	
	def destroy(self):
		self.widget.destroy()
		for widget in self.widgets.keys():
			self.widgets[widget].widget.destroy()
			del self.widgets[widget]
		del self.widget
		del self.widgets
		del self.screen
		del self.buttons
	
	def set_value(self):
		model = self.screen.current_model
		if model:
			for widget in self.widgets.values():
				widget.set_value(model)

	def sel_ids_get(self):
		if self.screen.current_model:
			return [self.screen.current_model.id]
		return []

	def reset(self):
		for wid_name, widget in self.widgets.items():
			widget.reset()

	def signal_record_changed(self, *args):
		pass

	def display(self):
		model = self.screen.current_model
		if model and ('state' in model.fields):
			state = model['state'].get()
		else:
			state = 'draft'
		for widget in self.widgets.values():
			widget.display(model, state)
		for button in self.buttons:
			button.state_set(state)
		return True
