# $Id: balloon.tcl,v 1.10 2003/09/20 18:42:57 aleksey Exp $


option add *Balloon.background LightYellow widgetDefault
option add *Balloon.foreground Black       widgetDefault
option add *Balloon.style      delay       widgetDefault


toplevel .balloon -relief flat -bd 1 -class Balloon
.balloon configure -background [option get .balloon foreground Balloon]
    
pack [message .balloon.text \
	  -bg [option get .balloon background Balloon] \
	  -fg [option get .balloon foreground Balloon] \
	  -font $font -text "" -aspect 5000 -width 0]
    
wm transient .balloon .
wm overrideredirect .balloon 1
wm withdraw .balloon

namespace eval balloon {
    variable screenheight [winfo screenheight .]
    variable screenwidth [winfo screenwidth .]
    variable _id ""
    variable _delay 600
    variable _cur ""
    variable balloon_showed 0
    variable balloon_remove 0

    set style [option get .balloon style Balloon]
}

proc balloon::set_text {text args} {

    set width 0
    set aspect 5000
    foreach {opt val} $args {
	switch -- $opt {
	    -width { set width $val }
	    -aspect { set aspect $val }
	}
    }

    after idle [list .balloon.text configure -text $text -aspect $aspect -width $width]
}

proc balloon::show {mx my} {
    global font
    variable balloon_showed 
    variable balloon_remove 
    variable max_bx 
    variable screenwidth
    variable screenheight

    set balloon_showed 1
    set balloon_remove 0

    set max_bx [expr {$screenwidth - [winfo reqwidth .balloon]}]
    set max_by [expr {$screenheight - [winfo reqheight .balloon]}]

    set b_x [expr {$mx + 12}]
    set b_y [expr {$my + 15}]

    set b_x [min $b_x $max_bx]
    set b_y [min $b_y $max_by]
    wm geometry .balloon +$b_x+$b_y
    

    wm deiconify .balloon
# need the raise in case we're ballooning over a detached menu (emoticons)
    raise .balloon
}

proc balloon::set_delay {w mx my} {
    variable balloon_showed
    variable balloon_remove
    variable _id
    variable _delay
    variable _cur
    
    if {$_cur != $w} {
	if {$_id != ""} {
	    after cancel $_id
	}
	set _id [after $_delay "balloon::show $mx $my"]
	set _cur $w
	wm withdraw .balloon
	set balloon_showed 0
	set balloon_remove 0
    } else {
	set balloon_remove 0
	if {$balloon_showed == 0} {
	    if {$_id != ""} {
		after cancel $_id
	    }
	    set _id [after $_delay "balloon::show $mx $my"]
	}
    }
}

proc balloon::on_mouse_move {w mx my} {
    variable style

    switch -- $style {
	delay  {set_delay $w $mx $my}
	follow {show $mx $my}
    }
}

proc balloon::destroy {} {
    variable balloon_showed
    variable balloon_remove
    variable _id
    
    if {$_id != ""} {
	after cancel $_id
	set _id ""
    }

    set balloon_remove 1
    after 100 {
	if {$balloon::balloon_remove} {
	    wm withdraw .balloon
	    set balloon::balloon_showed 0
	    set balloon::balloon_remove 0
	}
    }
}

proc balloon::default_balloon {w action X Y {body ""} args} {

    switch -- $action {
        enter {
            eval balloon::set_text [list $body] $args
        }

        motion {
            balloon::on_mouse_move $w $X $Y
        }

        leave {
            balloon::destroy
        }
    }
}
