# $Id: hooks.tcl,v 1.5 2003/11/08 20:10:35 aleksey Exp $

namespace eval hook {
}

proc hook::add {hook func {seq 50}} {
    variable $hook

    lappend $hook [list $func $seq]
    set $hook [lsort -integer -index 1 [lsort -unique [set $hook]]]
}

proc hook::set_flag {hook flag} {
    variable F
    set idx [lsearch -exact $F(flags,$hook) $hook]
    set F(flags,$hook) [lreplace $F(flags,$hook) $idx $idx]
}

proc hook::unset_flag {hook flag} {
    variable F
    if {![lcontain $F(flags,$hook) $flag]} {
	lappend F(flags,$hook) $flag
    }
}

proc hook::is_flag {hook flag} {
    variable F
    return [expr ![lcontain $F(flags,$hook) $flag]]
}

proc hook::run {hook args} {
    variable F
    variable $hook

    if {![info exists $hook]} {
	return
    }

    set F(flags,$hook) {}

    foreach func [set $hook] {
	set func [lindex $func 0]
	set code [catch { eval $func $args } state]
        debugmsg hook "$hook: [lindex $func 0] -> $state (code $code)"
	if {$code && ![winfo exists .hook_err]} {
	    MessageDlg .hook_err -aspect 50000 -icon error \
		-message "Hook $hook failed: $code\n$::errorInfo" \
		-type user -buttons ok -default 0 -cancel 0
	}
	if {(!$code) && ([cequal $state stop])} {
	    break
	}
    }
}
