# $Id: taskbar.tcl,v 1.5 2003/05/03 19:06:07 aleksey Exp $

namespace eval taskbar {
    variable saved_state
    variable balloon ""
#    variable state   ""
    variable tray    ""

    variable icon    ""
    variable pos     0
    variable s2p
    array set s2p    [list blank       0 \
			   available   1 \
			   away	       2 \
			   chat	       3 \
			   dnd	       4 \
			   xa	       5 \
		           unavailable 6 \
			   invisible   7 \
			   browser     8 \
			   group       9 \
			   browser32   10 \
			   group32     11 \
			   available32 12]
  
    variable mouse
    array set mouse  [list 1down 0 \
			   3down 0 \
			   menu  ""]
}

proc taskbar::load {} {
    global   curuserstatus

    variable tray

    variable icon
    variable pos
    variable s2p
    variable mouse
    variable saved_state [wm state .]

    if {[catch { package require Winico }]} {
        return
    }

    set icon [winico createfrom [pixmap docking tkabber.ico]]
    winico taskbar add $icon -pos [set pos $s2p(unavailable)] \
	   -text     [balloon_text]    \
	   -callback "[namespace current]::callback %m %i %X %Y"
    winico setwindow . $icon small $s2p(unavailable)
    winico setwindow . $icon big $s2p(available32)

    set m [set mouse(menu) .tray]
    menu $m -tearoff 1 -postcommand "[namespace current]::post $m"
    $m add command -label [::msgcat::mc "About..."]  -command about_window
    $m add separator
    $m add cascade -label [::msgcat::mc "Presence"] -menu [menu [set pm $m.presence] -tearoff 0]
    for {set i 1} {$i <= [[set p .presence.button.menu] index end]} {incr i} {
        $pm add command -label [lindex [$p entryconfigure $i -label] 4] \
                        -command  [lindex [$p entryconfigure $i -command] 4]
    }
    $m add command -label [::msgcat::mc "Log in..."] -command show_login_dialog
    $m add command -label [::msgcat::mc "Log out"]   -command logout
    $m add command -label [::msgcat::mc "Log out with reason..."]  -command show_logout_dialog
    $m add separator
    $m add command -label [::msgcat::mc "Hide Main Window"]  -command "set [namespace current]::saved_state \[wm state .\]
	    wm state . withdrawn"
    $m add command -label [::msgcat::mc "Show Main Window"]  -command "wm state . \$[namespace current]::saved_state
	    wm deiconify ."
    $m add separator
    $m add command -label [::msgcat::mc "Quit"]  -command quit

    set tray ""
    foreach var [list curuserstatus tabcolors] {
        trace variable ::$var w [namespace current]::update
    }

    foreach p [list set_status clear_status] {
        rename ::$p ::${p}_aux
        rename [namespace current]::$p ::$p
    }

    bind Toplevel <Map> [list [namespace current]::win_icon_setup %W Toplevel]

    foreach tag [list Chat JBrowser JDisco] {
	bind $tag <Map> [list [namespace current]::win_icon_setup %W $tag]
    }

    hook::add quit_hook [namespace current]::quit
}

hook::add finload_hook [namespace current]::taskbar::load

proc taskbar::win_icon_setup {w tag} {
    global usetabbar
    variable icon
    variable s2p

    if {[winfo toplevel $w] != $w} {
	return
    }

    switch -- $tag {
	Chat {
	    set small group
	    set big group32
	}
	JBrowser -
	JDisco {
	    set small browser
	    set big browser32
	}
	default {
	    set small available
	    set big available32
	}
    }
    winico setwindow $w $icon small $s2p($small)
    winico setwindow $w $icon big $s2p($big)
}

proc taskbar::quit {} {
    variable icon

    if {![cequal $icon ""]} {
	winico taskbar delete $icon
    }
}

proc taskbar::callback {event unused x y} {
    variable saved_state
    variable icon
    variable pos
    variable s2p
    variable mouse

    switch -- $event {
	WM_MOUSEMOVE -
	default {
	    set mouse(1down) 0
	    set mouse(3down) 0
	    #winico taskbar modify $icon -pos $pos -text [balloon_text]
	}

	WM_LBUTTONDOWN {
	    set mouse(1down) 1
	}

	WM_RBUTTONDOWN {
	    set mouse(3down) 1
	}

	WM_LBUTTONUP {
	    if {$mouse(1down)} {
                switch -- [wm state .] {
		    zoomed -
                    normal  {
			set saved_state [wm state .]
			wm state . withdrawn
		    }
                    default {
			wm state . $saved_state
			wm deiconify .
		    }
		}
	    }
	    set mouse(1down) 0
	}

	WM_RBUTTONUP {
	    if {$mouse(3down)} {
		tk_popup $mouse(menu) $x $y
	    }
	    set mouse(3down) 0
	}
    }
}

proc taskbar::balloon_text {} {
    global userstatusdesc textstatus

    if {![cequal $textstatus ""]} {
	return $textstatus
    }
    return $userstatusdesc
}


proc taskbar::post {m} {
    global curuserstatus

    switch -- [wm state .] {
	zoomed -
        normal {
            set state1 disabled
            set state2 normal
        }

        default {
            set state1 normal
            set state2 disabled
        }
    }
    if {$curuserstatus == "unavailable"} {
	set state0 disabled
    } else {
	set state0 normal
    }

    $m entryconfigure [$m index [::msgcat::mc "Presence"]] -state $state0
    $m entryconfigure [$m index [::msgcat::mc "Show Main Window"]] -state $state1
    $m entryconfigure [$m index [::msgcat::mc "Hide Main Window"]] -state $state2
}


proc taskbar::update {name1 {name2 ""} {op ""}} {
    global   curuserstatus tabcolors

    variable tray

    variable icon
    variable pos
    variable s2p

    switch -- [string trimleft $name1 :] {
        curuserstatus {
            if {[cequal $tray ""]} {
		winico taskbar modify $icon \
		       -pos [set pos $s2p($curuserstatus)] \
		       -text [balloon_text]
		winico setwindow . $icon small $s2p($curuserstatus)
            }
        }

        tabcolors {
            toggle 0 1
        }
    }
}


proc taskbar::toggle {ff {firstP 0}} {
    global   curuserstatus tabcolors

#    variable state
    variable tray

    variable icon
    variable pos
    variable s2p

    if {![cequal $tray ""]} {
        after cancel $tray
        set tray ""
    }

    set hitP 0
    foreach {k v} [array get tabcolors] {
        if {![winfo exists .nb.f$k]} {
            continue
        }
        if {(![cequal $v ""]) && ($v > 0)} {
            set hitP 1
            break
        }
    }

    if {!$hitP} {
        #set state [wm state .]
        update ::curuserstatus
        return
    }

#    set state [wm state .]
#    if {$firstP} {
#        set state $state
#    } elseif {(![cequal $state normal]) \
#		    && ([cequal $state normal])} {
#        update ::curuserstatus
#        return
#    }

    if {$ff} {
        set pos $s2p($curuserstatus)
    } else {
        set pos $s2p(blank)
    }
    winico taskbar modify $icon -pos $pos -text [balloon_text]

    set tray \
	[after 500 [list [namespace current]::toggle [expr ($ff+1)%2]]]
}


proc taskbar::set_status {text} \
    "[namespace current]::taskbar::set_status_aux \$text"

proc taskbar::set_status_aux {text} {
    variable balloon

    switch -- [wm state .] {
	zoomed -
        normal {
            ::set_status_aux $text
        }

        default {
            if {![cequal $balloon ""]} {
                after cancel $balloon
            }
            balloon::set_text $text
            balloon::show [winfo rootx .tray] [winfo rooty .tray]
            set balloon [after 15000 balloon::destroy]
        }
    }
}


proc taskbar::clear_status {} \
    "[namespace current]::taskbar::clear_status_aux"

proc taskbar::clear_status_aux {} {
    variable balloon

    if {![cequal $balloon ""]} {
        after cancel $balloon
    }

    ::clear_status_aux
    balloon::destroy
}


