//: version "1.8.3"
//: property discardChanges = 1

module ALU(F, A, B, Z);
//: interface  /sz:(89, 65) /bd:[ Ti0>A[7:0](20/89) Ti1>B[7:0](67/89) Li0>F[1:0](28/65) Bo0<Z[7:0](44/89) ]
input [7:0] B;    //: /sn:0 {0}(342,147)(342,184){1}
//: {2}(344,186)(367,186){3}
//: {4}(371,186)(425,186)(425,258){5}
//: {6}(369,188)(369,261){7}
//: {8}(342,188)(342,258){9}
input [1:0] F;    //: /sn:0 /dp:1 {0}(343,353)(214,353){1}
input [7:0] A;    //: /sn:0 {0}(265,147)(265,215){1}
//: {2}(267,217)(345,217){3}
//: {4}(349,217)(372,217){5}
//: {6}(376,217)(457,217)(457,258){7}
//: {8}(374,219)(374,261){9}
//: {10}(347,219)(347,258){11}
//: {12}(265,219)(265,322)(348,322)(348,337){13}
supply0 w0;    //: /sn:0 {0}(491,295)(491,272)(465,272){1}
output [7:0] Z;    //: /sn:0 {0}(366,404)(366,366){1}
wire [7:0] w14;    //: /sn:0 {0}(345,279)(345,310)(360,310)(360,337){1}
wire w4;    //: /sn:0 {0}(417,272)(407,272){1}
wire [7:0] w11;    //: /sn:0 {0}(372,282)(372,337){1}
wire [7:0] w10;    //: /sn:0 /dp:1 {0}(384,337)(384,307)(441,307)(441,287){1}
//: enddecls

  //: joint g8 (A) @(347, 217) /w:[ 4 -1 3 10 ]
  add g4 (.A(B), .B(A), .S(w10), .CI(w0), .CO(w4));   //: @(441,274) /sn:0 /w:[ 5 7 1 1 0 ]
  //: supply0 g13 (w0) @(491,301) /sn:0 /w:[ 0 ]
  //: input g3 (F) @(212,353) /sn:0 /w:[ 1 ]
  //: input g2 (A) @(265,145) /sn:0 /R:3 /w:[ 0 ]
  //: input g1 (B) @(342,145) /sn:0 /R:3 /w:[ 0 ]
  //: joint g11 (B) @(369, 186) /w:[ 4 -1 3 6 ]
  //: joint g10 (A) @(374, 217) /w:[ 6 -1 5 8 ]
  and g6 (.I0(B), .I1(A), .Z(w11));   //: @(372,272) /sn:0 /R:3 /w:[ 7 9 0 ] /eb:0
  //: joint g9 (A) @(265, 217) /w:[ 2 1 -1 12 ]
  or g7 (.I0(B), .I1(A), .Z(w14));   //: @(345,269) /sn:0 /R:3 /w:[ 9 11 0 ] /eb:0
  //: output g5 (Z) @(366,401) /sn:0 /R:3 /w:[ 0 ]
  mux g0 (.I0(A), .I1(w14), .I2(w11), .I3(w10), .S(F), .Z(Z));   //: @(366,353) /sn:0 /w:[ 13 1 1 0 0 1 ]
  //: joint g12 (B) @(342, 186) /w:[ 2 1 -1 8 ]

endmodule

module REGS(SB, SA, BOUT, AOUT, ck, AIN);
//: interface  /sz:(94, 80) /bd:[ Ti0>AIN[7:0](46/94) Li0>SA[1:0](14/80) Li1>SB[1:0](34/80) Li2>ck(56/80) Bo0<AOUT[7:0](16/94) Bo1<BOUT[7:0](79/94) ]
supply1 w0;    //: /sn:0 /dp:1 {0}(361,358)(373,358)(373,339){1}
supply1 w21;    //: /sn:0 /dp:1 {0}(260,211)(181,211)(181,173){1}
input [1:0] SB;    //: /sn:0 {0}(507,507)(570,507){1}
supply1 w1;    //: /sn:0 /dp:1 {0}(506,358)(519,358)(519,339){1}
output [7:0] BOUT;    //: /sn:0 {0}(593,549)(593,520){1}
input [1:0] SA;    //: /sn:0 {0}(382,507)(92,507)(92,138){1}
//: {2}(94,136)(284,136)(284,198){3}
//: {4}(90,136)(47,136){5}
supply1 w2;    //: /sn:0 /dp:1 {0}(219,357)(231,357)(231,340){1}
input [7:0] AIN;    //: /sn:0 {0}(467,144)(467,285){1}
//: {2}(469,287)(626,287)(626,353){3}
//: {4}(465,287)(324,287){5}
//: {6}(320,287)(180,287)(180,352){7}
//: {8}(322,289)(322,353){9}
//: {10}(467,289)(467,353){11}
input ck;    //: /sn:0 {0}(51,392)(124,392){1}
//: {2}(128,392)(273,392){3}
//: {4}(277,392)(412,392){5}
//: {6}(416,392)(574,392)(574,363)(589,363){7}
//: {8}(414,390)(414,363)(430,363){9}
//: {10}(275,390)(275,363)(285,363){11}
//: {12}(126,390)(126,362)(143,362){13}
output [7:0] AOUT;    //: /sn:0 /dp:1 {0}(405,520)(405,549){1}
supply1 w5;    //: /sn:0 /dp:1 {0}(665,358)(680,358)(680,340){1}
wire w4;    //: /sn:0 {0}(290,227)(290,266)(555,266)(555,368)(506,368){1}
wire [7:0] R2;    //: /dp:4 {0}(411,491)(411,432)(465,432){1}
//: {2}(469,432)(599,432)(599,491){3}
//: {4}(467,430)(467,374){5}
wire w3;    //: /sn:0 {0}(278,227)(278,281)(404,281)(404,368)(361,368){1}
wire w20;    //: /sn:0 {0}(302,227)(302,248)(712,248)(712,368)(665,368){1}
wire [7:0] R3;    //: /dp:3 {0}(423,491)(423,447)(609,447){1}
//: {2}(613,447)(626,447)(626,374){3}
//: {4}(611,449)(611,491){5}
wire [7:0] R1;    //: /dp:5 {0}(399,491)(399,422){1}
//: {2}(401,420)(587,420)(587,491){3}
//: {4}(397,420)(322,420)(322,374){5}
wire w8;    //: /sn:0 /dp:1 {0}(219,367)(266,367)(266,227){1}
wire [7:0] R0;    //: /dp:3 {0}(575,491)(575,460)(389,460){1}
//: {2}(385,460)(180,460)(180,373){3}
//: {4}(387,462)(387,491){5}
//: enddecls

  register g8 (.Q(R3), .D(AIN), .EN(w20), .CLR(w5), .CK(ck));   //: @(626,363) /sn:0 /w:[ 3 3 1 0 7 ]
  //: input g4 (SB) @(505,507) /sn:0 /w:[ 0 ]
  mux g13 (.I0(R0), .I1(R1), .I2(R2), .I3(R3), .S(SB), .Z(BOUT));   //: @(593,507) /sn:0 /w:[ 0 3 3 5 1 1 ]
  //: input g3 (SA) @(45,136) /sn:0 /w:[ 5 ]
  //: output g2 (BOUT) @(593,546) /sn:0 /R:3 /w:[ 0 ]
  //: output g1 (AOUT) @(405,546) /sn:0 /R:3 /w:[ 1 ]
  //: joint g16 (R0) @(387, 460) /w:[ 1 -1 2 4 ]
  //: joint g11 (ck) @(275, 392) /w:[ 4 10 3 -1 ]
  //: supply1 g10 (w21) @(192,173) /sn:0 /w:[ 1 ]
  //: joint g27 (ck) @(126, 392) /w:[ 2 12 1 -1 ]
  //: joint g19 (R1) @(399, 420) /w:[ 2 -1 4 1 ]
  register g6 (.Q(R1), .D(AIN), .EN(w3), .CLR(w0), .CK(ck));   //: @(322,363) /sn:0 /w:[ 5 9 1 0 11 ]
  demux g9 (.I(SA), .E(w21), .Z0(!w8), .Z1(!w3), .Z2(!w4), .Z3(!w20));   //: @(284,211) /sn:0 /w:[ 3 0 1 0 0 0 ]
  register g7 (.Q(R2), .D(AIN), .EN(w4), .CLR(w1), .CK(ck));   //: @(467,363) /sn:0 /w:[ 5 11 1 0 9 ]
  register g15 (.Q(R0), .D(AIN), .EN(w8), .CLR(w2), .CK(ck));   //: @(180,362) /sn:0 /w:[ 3 7 0 0 13 ]
  //: joint g20 (SA) @(92, 136) /w:[ 2 -1 4 1 ]
  //: supply1 g25 (w2) @(242,340) /sn:0 /w:[ 1 ]
  //: joint g17 (R3) @(611, 447) /w:[ 2 -1 1 4 ]
  mux g14 (.I0(R0), .I1(R1), .I2(R2), .I3(R3), .S(SA), .Z(AOUT));   //: @(405,507) /sn:0 /w:[ 5 0 0 0 0 0 ]
  //: input g5 (ck) @(49,392) /sn:0 /w:[ 0 ]
  //: joint g24 (AIN) @(467, 287) /w:[ 2 1 4 10 ]
  //: supply1 g21 (w0) @(384,339) /sn:0 /w:[ 1 ]
  //: supply1 g23 (w5) @(691,340) /sn:0 /w:[ 1 ]
  //: joint g26 (AIN) @(322, 287) /w:[ 5 -1 6 8 ]
  //: supply1 g22 (w1) @(530,339) /sn:0 /w:[ 1 ]
  //: input g0 (AIN) @(467,142) /sn:0 /R:3 /w:[ 0 ]
  //: joint g18 (R2) @(467, 432) /w:[ 2 4 1 -1 ]
  //: joint g12 (ck) @(414, 392) /w:[ 6 8 5 -1 ]

endmodule

module main;    //: root_module
supply1 w7;    //: /sn:0 {0}(251,359)(251,346){1}
supply0 w2;    //: /sn:0 {0}(290,464)(290,479)(253,479){1}
//: {2}(249,479)(218,479)(218,463){3}
//: {4}(251,481)(251,491){5}
supply0 w12;    //: /sn:0 {0}(482,526)(482,508)(464,508){1}
supply0 w11;    //: /sn:0 {0}(500,422)(500,400)(484,400){1}
supply1 w10;    //: /sn:0 /dp:1 {0}(464,498)(478,498)(478,480){1}
supply0 [7:0] w9;    //: /sn:0 {0}(391,422)(391,412)(415,412)(415,441){1}
wire [7:0] w6;    //: /sn:0 /dp:1 {0}(711,277)(711,265)(771,265){1}
//: {2}(775,265)(817,265)(817,561)(695,561)(695,538){3}
//: {4}(773,263)(773,252){5}
wire b;    //: /dp:1 {0}(57,525)(93,525){1}
//: {2}(95,523)(95,495)(111,495){3}
//: {4}(95,527)(95,571)(123,571){5}
wire [7:0] w14;    //: /sn:0 /dp:1 {0}(444,386)(444,359){1}
wire [7:0] w16;    //: /sn:0 {0}(435,441)(435,427)(460,427)(460,415){1}
wire [7:0] w15;    //: /sn:0 /dp:1 {0}(748,364)(748,335)(771,335){1}
//: {2}(775,335)(798,335)(798,552)(758,552)(758,538){3}
//: {4}(773,333)(773,320){5}
wire w4;    //: /sn:0 /dp:1 {0}(189,569)(144,569){1}
wire w19;    //: /sn:0 /dp:1 {0}(402,457)(365,457){1}
wire w0;    //: /sn:0 {0}(152,367)(224,367){1}
//: {2}(228,367)(237,367){3}
//: {4}(226,365)(226,357){5}
//: {6}(226,369)(226,455)(276,455){7}
wire w3;    //: /sn:0 /dp:1 {0}(189,564)(159,564)(159,548){1}
wire [1:0] w21;    //: /sn:0 {0}(635,453)(652,453)(652,471)(678,471){1}
wire w28;    //: /sn:0 {0}(637,293)(678,293){1}
wire [1:0] w23;    //: /sn:0 /dp:1 {0}(678,491)(651,491)(651,503)(637,503){1}
wire [7:0] w20;    //: /sn:0 {0}(425,470)(425,493){1}
wire w1;    //: /sn:0 {0}(151,401)(187,401){1}
//: {2}(191,401)(237,401){3}
//: {4}(189,399)(189,392){5}
//: {6}(189,403)(189,454)(204,454){7}
wire co;    //: /dp:1 {0}(210,567)(223,567)(223,556){1}
wire [7:0] w25;    //: /sn:0 {0}(658,233)(691,233)(691,277){1}
wire w8;    //: /sn:0 /dp:1 {0}(186,493)(158,493){1}
//: {2}(154,493)(132,493){3}
//: {4}(156,495)(156,527){5}
wire w18;    //: /sn:0 {0}(436,400)(426,400){1}
wire [7:0] w17;    //: /sn:0 {0}(725,456)(725,431){1}
wire ci;    //: {0}(57,454)(161,454)(161,496){1}
//: {2}(163,498)(186,498){3}
//: {4}(161,500)(161,527){5}
wire clk;    //: {0}(342,503)(388,503){1}
wire w13;    //: /sn:0 {0}(218,446)(218,427)(249,427){1}
//: {2}(253,427)(288,427){3}
//: {4}(290,425)(290,415){5}
//: {6}(290,429)(290,447){7}
//: {8}(251,425)(251,410){9}
wire s;    //: /dp:1 {0}(207,496)(225,496)(225,513){1}
wire ck;    //: /sn:0 {0}(611,559)(665,559)(665,513)(678,513){1}
wire w5;    //: /sn:0 /dp:1 {0}(251,376)(251,393){1}
wire a;    //: {0}(57,490)(99,490){1}
//: {2}(103,490)(111,490){3}
//: {4}(101,492)(101,566)(123,566){5}
wire [7:0] w29;    //: /sn:0 /dp:1 {0}(701,364)(701,306){1}
wire [7:0] reg_out;    //: {0}(425,514)(425,550)(470,550){1}
//: {2}(474,550)(524,550)(524,375)(476,375)(476,386){3}
//: {4}(472,552)(472,569){5}
wire [1:0] w26;    //: /sn:0 /dp:1 {0}(637,356)(658,356)(658,393)(680,393){1}
//: enddecls

  //: comment g61 /dolink:1 /link:"@T/edwire_tut.v" @(630,100) /sn:0 /anc:1
  //: /line:"Leitungen editieren"
  //: /end
  nmos g4 (.Z(w2), .S0(w13), .G0(w0));   //: @(284,455) /sn:0 /w:[ 0 7 7 ]
  //: supply1 g8 (w7) @(262,346) /sn:0 /w:[ 1 ]
  clock g51 (.Z(ck));   //: @(598,559) /sn:0 /w:[ 0 ] /omega:200 /phi:0 /duty:50
  //: switch g3 (w0) @(135,367) /sn:0 /w:[ 0 ] /st:0
  //: joint g13 (w1) @(189, 401) /w:[ 2 4 1 6 ]
  or g34 (.I0(w3), .I1(w4), .Z(co));   //: @(200,567) /sn:0 /w:[ 0 0 0 ] /eb:0
  clock g37 (.Z(clk));   //: @(329,503) /sn:0 /w:[ 0 ] /omega:120 /phi:0 /duty:50
  led g55 (.I(w0));   //: @(226,350) /sn:0 /w:[ 5 ] /type:0
  //: joint g58 (w6) @(773, 265) /w:[ 2 4 1 -1 ]
  led g59 (.I(w15));   //: @(773,313) /sn:0 /w:[ 5 ] /type:2
  //: comment g1 /dolink:1 /link:"@T/edit1_tut.v" @(630,70) /sn:0 /anc:1
  //: /line:"Grundlegende Editier-Modi"
  //: /end
  //: comment g16 /dolink:1 /link:"@T/module_tut.v" @(630,115) /sn:0 /anc:1
  //: /line:"Benutzen von Modulen"
  //: /end
  //: joint g11 (w2) @(251, 479) /w:[ 1 -1 2 4 ]
  led g50 (.I(co));   //: @(223,549) /sn:0 /w:[ 1 ] /type:0
  //: supply0 g10 (w2) @(251,497) /sn:0 /w:[ 5 ]
  and g28 (.I0(a), .I1(b), .Z(w4));   //: @(134,569) /sn:0 /w:[ 5 5 1 ] /eb:0
  //: joint g19 (w0) @(226, 367) /w:[ 2 4 1 6 ]
  //: switch g27 (ci) @(40,454) /sn:0 /w:[ 0 ] /st:0
  //: joint g32 (w8) @(156, 493) /w:[ 1 -1 2 4 ]
  //: dip sa (w21) @(597,453) /R:1 /w:[ 0 ] /st:0
  nmos g6 (.Z(w2), .S0(w13), .G0(w1));   //: @(212,454) /sn:0 /w:[ 3 0 7 ]
  //: supply0 g38 (w12) @(482,532) /sn:0 /w:[ 0 ]
  mux g53 (.I0(w25), .I1(w6), .S(w28), .Z(w29));   //: @(701,293) /sn:0 /w:[ 1 0 1 1 ]
  pmos g7 (.Z(w7), .S0(w5), .G0(w0));   //: @(245,367) /sn:0 /w:[ 0 0 3 ]
  //: joint g9 (w13) @(251, 427) /w:[ 2 8 1 -1 ]
  //: joint g57 (w13) @(290, 427) /w:[ -1 4 3 6 ]
  //: frame g15 @(600,25) /sn:0 /anc:1 /wi:213 /ht:149 /tx:"Tutorien"
  //: comment g20 /dolink:1 /link:"@T/create_tut.v" @(630,55) /sn:0 /anc:1
  //: /line:"Erzeugen einer Schaltung"
  //: /end
  and g31 (.I0(w8), .I1(ci), .Z(w3));   //: @(159,538) /sn:0 /R:3 /tech:unit /w:[ 5 5 1 ] /eb:0
  //: dip sb (w23) @(599,503) /R:1 /w:[ 1 ] /st:1
  //: supply1 g39 (w10) @(489,480) /sn:0 /w:[ 1 ]
  led g48 (.I(reg_out));   //: @(472,576) /sn:0 /R:2 /w:[ 5 ] /type:1
  //: dip func (w26) @(599,356) /R:1 /w:[ 0 ] /st:0
  //: supply0 g43 (w11) @(500,428) /sn:0 /w:[ 0 ]
  REGS regs (.AIN(w17), .ck(ck), .SB(w23), .SA(w21), .BOUT(w15), .AOUT(w6));   //: @(679, 457) /sz:(94, 80) /p:[ Ti0>0 Li0>1 Li1>0 Li2>1 Bo0<3 Bo1<3 ]
  ALU alu (.B(w15), .A(w29), .F(w26), .Z(w17));   //: @(681, 365) /sz:(89, 65) /p:[ Ti0>0 Ti1>0 Li0>1 Bo0<1 ]
  //: comment g17 /dolink:1 /link:"@T/sim_tut.v" @(630,130) /sn:0 /anc:1
  //: /line:"Schaltnetzsimulation"
  //: /end
  //: switch g25 (a) @(40,490) /sn:0 /w:[ 0 ] /st:0
  //: joint g29 (a) @(101, 490) /w:[ 2 -1 1 4 ]
  led g62 (.I(w6));   //: @(773,245) /sn:0 /w:[ 5 ] /type:2
  led g52 (.I(s));   //: @(225,520) /sn:0 /R:2 /w:[ 1 ] /type:0
  //: dip g42 (w14) @(444,349) /sn:0 /w:[ 1 ] /st:248
  //: dip data_in (w25) @(620,233) /R:1 /w:[ 0 ] /st:11
  pmos g5 (.Z(w5), .S0(w13), .G0(w1));   //: @(245,401) /sn:0 /w:[ 1 9 3 ]
  led g56 (.I(w13));   //: @(290,408) /sn:0 /w:[ 5 ] /type:0
  //: comment g14 /dolink:1 /link:"@T/seqsim_tut.v" @(630,145) /sn:0 /anc:1
  //: /line:"Schaltwerkssimulation"
  //: /end
  //: switch g44 (w19) @(348,457) /sn:0 /w:[ 1 ] /st:1
  //: comment g47 /dolink:0 /link:"" @(300,308) /sn:0 /anc:1
  //: /line:"klicken."
  //: /end
  //: comment g21 /dolink:1 /link:"@T/edit2_tut.v" @(630,85) /sn:0 /anc:1
  //: /line:"Editieren von Gruppen"
  //: /end
  xor g24 (.I0(w8), .I1(ci), .Z(s));   //: @(197,496) /sn:0 /w:[ 0 3 0 ] /eb:0
  add g36 (.A(w14), .B(reg_out), .S(w16), .CI(w11), .CO(w18));   //: @(460,402) /sn:0 /w:[ 0 3 1 1 0 ]
  xor g23 (.I0(a), .I1(b), .Z(w8));   //: @(122,493) /sn:0 /w:[ 3 3 3 ] /eb:0
  //: supply0 g41 (w9) @(391,428) /sn:0 /w:[ 0 ]
  mux g40 (.I0(w9), .I1(w16), .S(w19), .Z(w20));   //: @(425,457) /sn:0 /w:[ 1 0 0 0 ]
  led g54 (.I(w1));   //: @(189,385) /sn:0 /w:[ 5 ] /type:0
  //: joint g60 (w15) @(773, 335) /w:[ 2 4 1 -1 ]
  //: switch data_select (w28) @(620,293) /w:[ 0 ] /st:0
  //: comment g22 /dolink:0 /link:"" @(605,40) /sn:0 /anc:1
  //: /line:"->"
  //: /end
  //: comment g0 /dolink:0 /link:"" @(19,4)
  //: /line:"Willkommen in TkGate V1.8.3!"
  //: /line:""
  //: /line:"Copyright (C) 1987-2004 by Jeffery P. Hansen"
  //: /line:"TkGate kommt OHNE JEGLICHE GARANTIE-Zusage; Details zur Lizenz und zum"
  //: /line:"Garantieausschlu findet man unter 'Help...License'. Probleme bitte an"
  //: /line:"hansen@cmu.edu weiterleiten."
  //: /line:""
  //: /line:"   * Dieses Tutorial erscheint automatisch beim ersten Start von TkGate."
  //: /line:"     Man kann es ausblenden: Unter dem Menupunkt \"Optionen...\" des "
  //: /line:"     \"Datei\"-Menus den Anfngermodus ausschalten."
  //: /line:""
  //: /line:"   * Eine von Grund auf neue Schaltung kann man mit \"Neu\" (\"Datei\"-Menu)"
  //: /line:"     erzeugen. Oder man ldt eine vorhandene Schaltung aus einer Datei "
  //: /line:"     mit \"ffnen\" aus dem \"Datei\"-Menu."
  //: /line:"   * Die vollstndige Dokumentation zu TKGate findet man unter"
  //: /line:"     http://www.tkgate.org"
  //: /line:""
  //: /line:"Es folgt ein kurzes Tutorium zur Benutzung von TkGate. Zur schnellen "
  //: /line:"Navigation durch die Abschnitte gibt es Links in der rechten oberen Ecke."
  //: /line:"Alternativ dazu kann man sie auch im \"Hilfe\"-Menu auswhlen."
  //: /line:""
  //: /line:"In jedem Abschnitt sollte man die Schritte in der numerierten Reihenfolge"
  //: /line:"nachvollziehen. Nach Beendigung aller Tutorienteile kann man noch eine"
  //: /line:"Reihe von Beispielschaltungen aus dem \"Hilfe\"-Menu bearbeiten."
  //: /end
  //: switch g26 (b) @(40,525) /sn:0 /w:[ 0 ] /st:1
  register g35 (.Q(reg_out), .D(w20), .EN(w12), .CLR(w10), .CK(clk));   //: @(425,503) /sn:0 /w:[ 0 1 1 0 1 ]
  //: comment g45 /dolink:0 /link:"" @(17,308) /sn:0 /anc:1
  //: /line:"Zum Start auf "
  //: /end
  //: comment g46 /dolink:1 /link:"@T/create_tut.v" @(110,308) /sn:0 /anc:1
  //: /line:"\"Erzeugen einer Schaltung\""
  //: /end
  //: comment g18 /dolink:0 /link:"@T/welcome_tut.v" @(630,40) /sn:0 /anc:1
  //: /line:"TkGate Einfhrung"
  //: /end
  //: switch g12 (w1) @(134,401) /sn:0 /w:[ 0 ] /st:0
  //: joint g30 (b) @(95, 525) /w:[ -1 2 1 4 ]
  //: joint g33 (ci) @(161, 498) /w:[ 2 1 -1 4 ]
  //: joint g49 (reg_out) @(472, 550) /w:[ 2 -1 1 4 ]

endmodule
