/****************************************************************************
    Copyright (C) 1987-2004 by Jeffery P. Hansen

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

    Last edit by hansen on Mon Dec  8 13:45:54 2003
****************************************************************************/
#include <string.h>
#include "tkgate.h"

static iconDimensions rom_iconDims[] = {
  {0, 0, 34, 49, 17, 23},
};
static int rom_iconBoldOffset = 50;

GCElement *RamRom_Make(EditState **es,GModuleDef *env,int GType,
		    int x,int y,int r,const char *Name,int noWires,const char **options,int nOptions);
void RamRom_EditProps(GCElement *g,int isLoadDialog);
void RamRom_SetProp(GCElement*,const char*,const void*);
void RamRom_SimHitFunc(EditState *es,GCElement *g);
void RamRom_VerSave(FILE *f,GCElement *g);

#define ROM_A 0
#define ROM_D 1
#define ROM_OE 2

struct locate rom_A_loc[] = {{-18,-1,-18,-1,D_LEFT}};
struct locate rom_D_loc[] = {{17,-1,17,-1,D_RIGHT}};
struct locate rom_oe_loc[] = {{0,26,0,26,D_DOWN}};

static char *psRom[] = {
  "%",
  "% x y r psrom",
  "%",
  "/psrom {",
  "  startgate",
  "  -17.5 23.5 moveto",
  "  16.5 23.5 lineto",
  "  16.5 -25.5 lineto",
  "  -17.5 -25.5 lineto",
  "  closepath stroke",
  "  8 rfont",
  "  -15 -2 moveto (A) show",
  "  5 -2 moveto (D) show",
  "  6 rfont",
  "  (_oe) -4 -23 prshow",
  "  grestore",
  "} def",
  0
};

GGateInfo gate_rom_info = {
  0,
  "ROM",
  "rom",0x0,
  "psrom",psRom,

  {{"u",	{"gmmem",5},		{"gmrom",0,"mem",200},	"gat_make rom"},
   {0}},


  rom_iconDims,

  3,{{"A",IN,8,1,rom_A_loc},
       {"D",TRI,8,1,rom_D_loc},
       {"OE",IN,1,1,rom_oe_loc}},
  {{10,-30,RJ},{10,-30,RJ},{10,-30,RJ},{10,-30,RJ}},
  {0},

  {"OE-D","A-D",0},
  
  RamRom_Make,
  Generic_Init,
  Generic_Delete,
  Generic_GetExtents,
  Generic_HitDistance,
  Generic_Draw,
  Generic_Move,
  Generic_Replicate,
  Err_AddInput,
  Err_AddOutput,
  Err_AddInOut,
  Err_ChangePin,
  Nop_SimStateFunc,
  RamRom_SimHitFunc,
  Generic_PSWrite,
  RamRom_EditProps,
  RamRom_VerSave,
  RamRom_SetProp
};

void init_rom()
{
  Pixmap P;

  P = Pixmap_registerFromFile("rom","rom.b");
  gateinfo_1iconInit(&gate_rom_info,P,rom_iconDims,rom_iconBoldOffset);
  RegisterGate(&gate_rom_info);
}
