/****************************************************************************
    Copyright (C) 1987-2007 by Jeffery P. Hansen

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

    Last edit by hansen on Thu Jan 25 20:55:17 2007
****************************************************************************/
#include "tkgate.h"

#define DIVIDE_A 0
#define DIVIDE_B 1
#define DIVIDE_Q 2
#define DIVIDE_R 3

static iconDimensions divide_iconDims[] = {
  {0,  0,  59, 28, 29, 15},
  {60, 0,  28, 59, 15, 29},
  {29, 60, 59, 28, 28, 12},
  {0,  29, 28, 59, 12, 29},
};
static int divide_iconBoldOffset = 89;

struct locate divide_A_loc[] = {
	{-16,-16,-16,-16,D_UP},
	{-16,16,-16,16,D_LEFT},
	{16,16,16,16,D_DOWN},
	{16,-16,16,-16,D_RIGHT}};

struct locate divide_B_loc[] = {
	{16,-16,16,-16,D_UP},
	{-16,-16,-16,-16,D_LEFT},
	{-16,16,-16,16,D_DOWN},
	{16,16,16,16,D_RIGHT}};

struct locate divide_Q_loc[] = {
	{10,13,10,13,D_DOWN},
	{13,-10,13,-10,D_RIGHT},
	{-10,-13,-10,-13,D_UP},
	{-13,10,-13,10,D_LEFT}};

struct locate divide_R_loc[] = {
	{-10,13,-10,13,D_DOWN},
	{13,10,13,10,D_RIGHT},
	{10,-13,10,-13,D_UP},
	{-13,-10,-13,-10,D_LEFT}};

static char *psDivide[] = {
  "%",
  "% x y r psdiv",
  "%",
  "/psdiv {",
  "  startgate",
  "  -30 15.5 moveto",
  "  -5 15.5 lineto",
  "  0 10 lineto",
  "  5 15.5 lineto",
  "  30 15.5 lineto",
  "  16 -12.5 lineto",
  "  -16 -12.5 lineto",
  "  closepath stroke",
  "  -3 0 moveto 3 0 lineto stroke",
  "  0 3 1 0 360 arc closepath fill",
  "  0 -3 1 0 360 arc closepath fill",
  "  grestore",
  "} def",
  0
};


GGateInfo gate_divide_info = {
  0,
  "Divide",
  "div",0x0,
  "psdiv",psDivide,

  {{"/",	{"gmalu",0},		{"gmdiv",0,0,300},	"gat_make div"},
   {0}},

  divide_iconDims,

  4,{{"A",IN,8,1,divide_A_loc},
       {"B",IN,8,1,divide_B_loc},
       {"Q",OUT,8,1,divide_Q_loc},
       {"R",OUT,8,1,divide_R_loc}},
  {{24,10,LJ},{8,-24,LJ},{-24,-8,RJ},{-12,24,RJ}},
  {1},
  
  {"A/B-Q","A/B-R",0},

  Generic_Make,
  Generic_Init,
  Generic_Delete,
  Generic_GetExtents,
  Generic_HitDistance,
  Generic_Draw,
  Generic_Move,
  Generic_Rotate,
  Generic_Replicate,
  Err_AddInput,
  Err_AddOutput,
  Err_AddInOut,
  Err_ChangePin,
  Nop_SimStateFunc,
  Nop_SimHitFunc,
  Generic_PSWrite,
  Generic_EditProps,
  Generic_VerSave
};

void init_divide()
{
  Pixmap P;

  P = Pixmap_registerFromFile("divide","divide.b");
  gateinfo_iconInit(&gate_divide_info,P,divide_iconDims,divide_iconBoldOffset);
  RegisterGate(&gate_divide_info);
}
