/*
** TleenX2 (Tlen.pl Client)
** Copyright (c) 2002-2003 Hubert Sokoowski <who_ami@tlen.pl>
**                         Pawe Biliski <rael@fr.pl>
**
** This code is free software; you can redistribute it and/or
** modify it under the terms of the GNU General Public License.
**
*/

/*obsluga okna chat*/

#include "main.h"
#include "users.h"
#include "utils.h"
#include "conffile.h"
#include "support.h"
#include "users.h"
#include "jabby.h"
#include "jabber.h"
#include "chat.h"

void window_set_icon(GtkWidget *window, struct user *u)
{
  if(u)
  {
    switch(u->type)
    {
      case USER_TLEN:
        gtk_window_set_icon (GTK_WINDOW (window),
                             gtk_image_get_pixbuf(GTK_IMAGE(icons[u->status])));
        break;
      case USER_JABBER:
        gtk_window_set_icon (GTK_WINDOW (window),
                   gtk_image_get_pixbuf(GTK_IMAGE(j_icons[u->status-2])));
        break;
      case USER_WP:
        gtk_window_set_icon (GTK_WINDOW (window),
                   gtk_image_get_pixbuf(GTK_IMAGE(wp_icons[u->status-2])));
        break;
      case USER_GG:
        gtk_window_set_icon (GTK_WINDOW (window),
                   gtk_image_get_pixbuf(GTK_IMAGE(gg_icons[u->status-2])));
      case USER_AGENT:
        break;
    }
  }
  else
    gtk_window_set_icon (GTK_WINDOW (window),
         gtk_image_get_pixbuf(GTK_IMAGE(icons[TLEN_STATUS_UNAVAILABLE])));
}

void window_talk_update_on_presence(gchar *id)
{
  gchar *s=NULL;
  GtkWidget *widget;
  struct talk *talk;
  struct user *u;

  talk=get_talk(id);
  u = get_user(id);
  if(talk)
  {
    widget=lookup_widget(talk->window,"label_status");
    switch(get_type(id))
    {
      case USER_TLEN:
        s = utf(statusy[(u?u->status:TLEN_STATUS_UNAVAILABLE) - 2]);
        break;
      case USER_JABBER:
      case USER_WP:
      case USER_GG:
      case USER_AGENT:
        s = utf(j_statusy[u?get_status(u):STATUS_UNAVAILABLE]);
        break;
    }
    gtk_label_set_text(GTK_LABEL(widget), s);
    g_free(s);
    chat_set_title(talk, '+');
    window_set_icon(talk->window, u);
  }
}

struct talk *get_talk_by_window(GtkWidget *window)
{
  GList *l=talks_list;
  struct talk *talk;

  if(!window)
  {
    g_print("window is NULL!!\n");
    return NULL;
  }
  while(l)
  {
    talk=(struct talk*) l->data;
    if(talk->window == window)
      return talk;
    l=l->next;
  }
  return NULL;
}

struct talk *get_talk(const gchar *jid)
{
  GList *l=talks_list;

  while(l)
  {
    struct talk *talk;

    talk=(struct talk*) l->data;
    if(!strcasecmp(talk->jid, jid))
      return talk;
    l=l->next;
  }
  return NULL;
}

void chat_append(struct talk *talk, const gchar *message,
                    const gchar *stamp, gint from)
{
  GtkWidget *textview;
  gchar *s, *c, *c2;
  gint num;
  gchar *name;
  gchar *tag;

  textview = lookup_widget(talk->window, "textview_top");
  if(!from)
  {
    name = get_user_name(talk->jid);
    textview_append(textview, name, 0, "nickfg", "fontbold");
    g_free(name);
  }
  else
    textview_append(textview, pname, 0, "nickfg", NULL);
  textview_append(textview," :: ",0,NULL, NULL);

  if(stamp)
    s = g_strdup(stamp);
  else
    s = get_localtime(NULL);
  if(!from)
    textview_append(textview,s,0,"datefg", "fontbold");
  else
    textview_append(textview,s,0,"datefg", NULL);
  g_free(s);

  textview_append(textview,"\n",0,NULL, NULL);
  tag = NULL;
  c = (gchar*)message;
  while(*c != '\0')
  {
    gboolean pixmap = FALSE;

    for(num=0; emots_str[num]; num++)
    {
      gint len = strlen(emots_str[num]);
      gint clen;

      if(!strncmp(emots_str[num], c, len))
      {
        textview_append_pixmap(textview, emots_num[num]);
        clen = strlen(c);
        c += clen < len ? clen : len;
        pixmap = TRUE;
        break;
      }
    }
    if(!pixmap)
    {
      c2 = g_strdup_printf("%c", *c);
      s = utf(c2);
      textview_append(textview,s,0,tag, NULL);
      g_free(s);
      g_free(c2);
      c++;
    }
  }
  textview_append(textview,"\n",0,NULL, NULL);
  textview_append(textview,"\n",1,NULL, NULL);
}

void chat_set_title(struct talk *talk, gchar c)
{
  gchar *user, *title;

  user = get_user_name(talk->jid);
  if(c != 0)
    title = g_strdup_printf("(%c)%s", c, user);
  else
    title = g_strdup(user);
  gtk_window_set_title(GTK_WINDOW(talk->window), title);
  g_free(user);
  g_free(title);
}

void chat_send(struct talk *talk)
{
  gchar *message, *s;
  GtkWidget  *textview;

  if(!talk)
  {
    g_print("talk is NULL\n");
    return;
  }
  textview = lookup_widget(talk->window, "textview_bottom");
  message = (gchar *)textview_get_text(textview);
  if(strlen(message)<=0)
    return;
  s = fromutf(message);
  if(s)
  {
    switch(get_type(talk->jid))
    {
      case USER_TLEN:
        tlen_sendmsg(session, talk->jid, s, TLEN_CHAT);
        break;
      case USER_JABBER:
      case USER_WP:
        jabber_message(talk->jid, s, JABBY_MESSAGE_CHAT);
        break;
      case USER_GG:
        jabber_gg_message(talk->jid, s);
        break;
      case USER_AGENT:
        jabber_agent(talk->jid, s);
        break;
    }
    chat_set_title(talk, 0);
    queue_chat(talk->jid, s, 0);
    chat_append(talk, s, NULL, 1);
    g_free(s);
    textview_clear(textview);
  }
  else
    info("Wprowadzie nieprawidowe znaki\n");
}

void chat_remove(struct talk *talk)
{
  if(!talk)
  {
    g_print("talk is NULL\n");
    return;
  }
  gtk_widget_destroy(talk->window);
  chat_list_flush();
  talks_list = g_list_remove(talks_list, (gpointer)talk);
}

