/*
** TleenX2 (Tlen.pl Client)
** Copyright (c) 2002-2003 Hubert Sokoowski <who_ami@tlen.pl>
**                         Pawe Biliski <rael@fr.pl>
**
** This code is free software; you can redistribute it and/or
** modify it under the terms of the GNU General Public License.
**
*/


//obsluga grup, zakladki, lista, itp

#include "main.h"
#include <stdlib.h>

#include "support.h"
#include "groups.h"



void free_group(struct group *g)
{
  g_free(g->name);
  g_list_free(g->users);
  g_free(g);
}

void groups_list_clear()
{
  GList *l=groups_list;
  struct group *g;

  while(l)
  {
    if(notebook1)
      gtk_notebook_remove_page(GTK_NOTEBOOK(notebook1),0);
    g=(struct group*) l->data;
    free_group(g);
    l=l->next;
  }
  g_list_free(groups_list);
  groups_list=NULL;
}

struct group* get_group(const gchar *name)
{
  GList *l=groups_list;
  struct group *g;

  if(!name)
    return NULL;
  if(!strlen(name))
    return NULL;
  while(l)
  {
    g=(struct group*)l->data;
    if(!strcmp(g->name,name))
      return g;
    l=l->next;
  }
  return NULL;
}

static
gint compare_func(gconstpointer d1, gconstpointer d2)
{
  struct group *g1, *g2;

  g1=(struct group*)d1;
  g2=(struct group*)d2;
  return strcmp(g1->name,g2->name);
}

void add_togroup(const gchar *group, struct user *u)
{
  struct group *g;

  g=get_group(group);
  g->users=g_list_append(g->users,u);
}

void add_group(const gchar *name)
{
  struct group *g;

  if(name[0] == '\0')
    return;
  g=(struct group*)g_malloc(sizeof(struct group));
  g->name=g_strdup(name);
  g->users=NULL;
  groups_list=g_list_insert_sorted(groups_list,(gpointer)g, compare_func);

}

void prepend_group(const gchar *name)
{
  struct group *g;

  if(name[0] == '\0')
    return;
  g=(struct group*)g_malloc(sizeof(struct group));
  g->name=g_strdup(name);
  g->users=NULL;
  groups_list=g_list_prepend(groups_list,(gpointer)g);
}
