/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 * 
 *      http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.apache.catalina.ha.util;

import java.util.Iterator;

/**
 * @author Peter Rossbach
 * @version $Revision: 467206 $, $Date: 2006-10-23 20:45:46 -0600 (Mon, 23 Oct 2006) $
 */

public interface IDynamicProperty {

    /**
     * set config attributes with reflect
     * 
     * @param name
     * @param value
     */
    public void setProperty(String name, Object value) ;

    /**
     * get current config
     * 
     * @param key
     * @return The property
     */
    public Object getProperty(String key) ;
    /**
     * Get all properties keys
     * 
     * @return An iterator over the property names
     */
    public Iterator getPropertyNames() ;

    /**
     * remove a configured property.
     * 
     * @param key
     */
    public void removeProperty(String key) ;

}
