## NOTE: tor.spec is autogenerated from tor.spec.in . Edit the latter,
## not the former.

## Things that need to be edited frequently
#
# This should be incremented whenever the spec file changes, but
# can drop back to zero at a new Tor version

%define specver 0

## Things users may want to change
#
# User (and group) name under which the Tor daemon runs.

%define toruser _tor
%define torgroup _tor

## Target a specific arch and OS
#
# default is i386 linux
%define target gnu
%define target_cpu i386
%define target_os linux

## Override any system rpm macros
#
%define _arch %{target_cpu}
%define _build_arch %{target_cpu}
%define _vendor %{target_os}
%define _host %{target_cpu}-pc-%{target_os}-%{target}
%define _host_cpu %{target_cpu}
%define _host_vendor %{target_os}
%define optflags -march=%{target_cpu} -mtune=%{target_cpu} -O2

## Version song and dance
#
# This should be the Tor version number, as it appears on the tarball,
# including any "pre<x>" or "rc<y>" suffix. This gets massaged to
# create the RPM version number, in a way that depends on the Tor
# numbering scheme.
%define native_version       0.1.1.23

%define version %(echo %{native_version} | sed -e 's/-/./g')

## Define output filename 
# 
# This creates filenames based upon the value of target_cpu defined above
%define _build_name_fmt %%{NAME}-%%{VERSION}-%%{RELEASE}.%{target_cpu}.rpm

## Release and OS identification song and dance
#
# This identifies the lineage of the spec file. This file is the
# standard one that comes with Tor; various distributions may
# have their own ideas about the right ways to do things.
%define pkgspec tor

# This spec is intended to build and install on multiple distributions
# (someday). Detect the distribution we're building on.

%define is_rh   %(test -e /etc/redhat-release && echo 1 || echo 0)
%define is_fc   %(test -e /etc/fedora-release && echo 1 || echo 0)
%define is_mdk  %(test -e /etc/mandrake-release && echo 1 || echo 0)
%define is_suse %(test -e /etc/SuSE-release && echo 1 || echo 0)

%if %{is_fc}
%define ostag %(sed -e 's/^.*release /fc/' -e 's/ .*$//' -e 's/\\./_/g' < /etc/fedora-release)
%else
%if %{is_rh}
%define ostag %(sed -e 's/^.*release /rh/' -e 's/ .*$//' -e 's/\\./_/g' < /etc/redhat-release)
%endif
%endif

# These are probably wrong... just placeholders should we actually
# end up supporting these distributions

%if %{is_mdk}
%define ostag mdk
%endif

%if %{is_suse}
%define ostag suse
%endif

# Using the build date ensures that every build really does get
# a different release number.  We use this trick for CVS versions.
# For release versions, we don't want or need it.
%define is_cvs_version %(echo %{native_version} | grep 'cvs' > /dev/null && echo 1 || echo 0)

%if %{is_cvs_version}
%define blddate %(date -u +"%Y%m%d%H%M")
%define release %{pkgspec}.%{specver}.%{ostag}.%{blddate}
%else
%define release %{pkgspec}.%{specver}.%{ostag}
%endif

## General-purpose macros
#
# Some systems don't have some macros. If a macro doesn't seem
# to exist on your system, add it here...

%if %{!?__make:1}%{?__make:0}
%define __make make
%endif

%if %{!?make:1}%{?make:0}
%define make %{__make}
%endif

%if %{!?_localstatedir:1}%{?_localstatedir:0}
%define _localstatedir /usr/local/var
%endif

## Package information
#
Name: tor
Version: %{version}
Release: %{release}

Summary: Anonymizing overlay network for TCP (The onion router)
URL: http://tor.eff.org/
Group: System Environment/Daemons

License: BSD-like
Vendor: R. Dingledine <arma@seul.org>
Packager: Nick Mathewson <nickm@seul.org>

%if %{is_suse}
Requires: openssl >= 0.9.6
BuildRequires: openssl-devel >= 0.9.6, rpm >= 4.0, zlib-devel
%else 
Requires: openssl >= 0.9.6, libevent >= 1.1a
BuildRequires: openssl-devel >= 0.9.6, libevent-devel >= 1.1a
%endif
%if %{is_fc}
BuildRequires: rpm-build >= 4.0
%endif
Requires(pre): /usr/bin/id, /bin/date, /bin/sh
Requires(pre): %{_sbindir}/useradd, %{_sbindir}/groupadd

Source0: http://tor.eff.org/dist/%{name}-%{native_version}.tar.gz

BuildRoot: %{_tmppath}/%{name}-%{version}-%{release}-root

%description
Tor is a connection-based low-latency anonymous communication system.

This package provides the "tor" program, which serves as both a client and
a relay node. Scripts will automatically create a "%{toruser}" user and
a "%{torgroup}" group, and set tor up to run as a daemon when the system
is rebooted.

Applications connect to the local Tor proxy using the SOCKS
protocol. The local proxy chooses a path through a set of relays, in
which each relay knows its predecessor and successor, but no
others. Traffic flowing down the circuit is unwrapped by a symmetric
key at each relay, which reveals the downstream relay.

Warnings: Tor does no protocol cleaning.  That means there is a danger
that application protocols and associated programs can be induced to
reveal information about the initiator. Tor depends on Privoxy and
similar protocol cleaners to solve this problem. This is alpha code,
and is even more likely than released code to have anonymity-spoiling
bugs. The present network is very small -- this further reduces the
strength of the anonymity provided. Tor is not presently suitable
for high-stakes anonymity.

%prep
%setup -q -n %{name}-%{native_version}

%build
%if %{is_suse}
%configure --with-tor-user=%{toruser} --with-tor-group=%{torgroup} \
	--build=%{_host} --host=%{_host} --target=%{_host} \
	--enable-static --disable-shared
%else
%configure --with-tor-user=%{toruser} --with-tor-group=%{torgroup} \
	--build=%{_host} --host=%{_host} --target=%{_host} 
%endif
%make

%install
%makeinstall

# Install init script and control script
%__mkdir_p ${RPM_BUILD_ROOT}%{_initrddir}
%if %{is_suse}
%__install -p -m 755 contrib/suse/tor.sh ${RPM_BUILD_ROOT}%{_initrddir}/%{name}
%else
%__install -p -m 755 contrib/tor.sh ${RPM_BUILD_ROOT}%{_initrddir}/%{name}
%endif
%__install -p -m 755 contrib/torctl ${RPM_BUILD_ROOT}%{_bindir}

# Set up config file; "sample" file implements a basic user node.
%__install -p -m 644 ${RPM_BUILD_ROOT}%{_sysconfdir}/%{name}/torrc.sample ${RPM_BUILD_ROOT}%{_sysconfdir}/%{name}/torrc

# Install the logrotate control file.
%__mkdir_p -m 755 ${RPM_BUILD_ROOT}%{_sysconfdir}/logrotate.d
%__install -p -m 644 contrib/tor.logrotate ${RPM_BUILD_ROOT}%{_sysconfdir}/logrotate.d/%{name}

# Directories that don't have any preinstalled files
%__mkdir_p -m 700 ${RPM_BUILD_ROOT}%{_localstatedir}/lib/%{name}
%__mkdir_p -m 755 ${RPM_BUILD_ROOT}%{_localstatedir}/run/%{name}
%__mkdir_p -m 755 ${RPM_BUILD_ROOT}%{_localstatedir}/log/%{name}

%clean
[ "${RPM_BUILD_ROOT}" != "/" ] && rm -rf ${RPM_BUILD_ROOT}

# These scripts are probably wrong for Mandrake or SuSE. They're certainly
# wrong for Debian, but what are you doing using RPM on Debian?

%pre

# If tor is already installed and running (whether installed by RPM
# or not), then kill it, but remember that it was running.
%__rm -f /tmp/${name}-was-running-%{version}-%{release}
if [ -f %{_initrddir}/%{name} ] && /sbin/service %{name} status ; then
    /sbin/service %{name} stop
    touch /tmp/${name}-was-running-%{version}-%{release}
fi

#
# Create a user and group if need be
#
if [ ! -n "`/usr/bin/id -g %{torgroup} 2>/dev/null`" ]; then
    # One would like to default the GID, but doing that properly would
    # require thought.
    %{_sbindir}/groupadd %{torgroup} 2> /dev/null
fi
if [ ! -n "`/usr/bin/id -u %{toruser} 2>/dev/null`" ]; then
    # One would also like to default the UID, but doing that properly would
    # also require thought.
    if [ -x %{_sbindir}/nologin ]; then
        %{_sbindir}/useradd -r -g %{torgroup} -d% {_localstatedir}/lib/%{name} -s %{_sbindir}/nologin %{toruser} 2> /dev/null
    else
        %{_sbindir}/useradd -r -g %{torgroup} -d %{_localstatedir}/lib/%{name}  -s /bin/false %{toruser} 2> /dev/null
    fi
fi
exit 0

%post

# If this is a new installation, use chkconfig to put tor in the
# default set of runlevels. If it's an upgrade, leave the existing
# configuration alone.
if [ $1 -eq 1 ]; then
    /sbin/chkconfig --add %{name}
    /sbin/chkconfig %{name} on
fi

# Older tor RPMS used a different username for the tor daemon.
# Make sure the runtime data have the right ownership.
%__chown -R %{toruser}.%{torgroup} %{_localstatedir}/{lib,log,run}/%{name}

if [ -f /tmp/${name}-was-running-%{version}-%{release} ]; then
    /sbin/service %{name} start
    %__rm -f /tmp/${name}-was-running-%{version}-%{release}
fi
exit 0

%preun

# If no instances of tor will be installed when we're done, make
# sure that it gets killed. We *don't* want to kill it or delete
# any of its data on uninstall if it's being upgraded to a new
# version, because the new version will actually already have
# been installed and started before the uninstall script for
# the old version is run, and we'd end up hosing it.
if [ $1 -le 0 ]; then
    if [ -f %{_initrddir}/%{name} ] && /sbin/service %{name} status ; then
        /sbin/service %{name} stop
    fi
    %/sbin/chkconfig --del %{name}
    %__rm -f ${_localstatedir}/lib/%{name}/cached-directory
    %__rm -f ${_localstatedir}/lib/%{name}/bw_accounting
    %__rm -f ${_localstatedir}/lib/%{name}/control_auth_cookie
    %__rm -f ${_localstatedir}/lib/%{name}/router.desc
    %__rm -f ${_localstatedir}/lib/%{name}/fingerprint
fi
exit 0

%files
%defattr(-,root,root)
%doc AUTHORS INSTALL LICENSE README ChangeLog doc/HACKING doc/TODO
%{_mandir}/man*/*
%{_bindir}/tor
%{_bindir}/torctl
%{_bindir}/torify
%{_bindir}/tor-resolve
%config %{_initrddir}/%{name}
%config(noreplace) %attr(0644,root,root) %{_sysconfdir}/logrotate.d/%{name}
%dir %attr(0755,root,%{torgroup}) %{_sysconfdir}/%{name}/
%config(noreplace) %attr(0644,root,%{torgroup}) %{_sysconfdir}/%{name}/*
%attr(0700,%{toruser},%{torgroup}) %dir %{_localstatedir}/lib/%{name}
%attr(0750,%{toruser},%{torgroup}) %dir %{_localstatedir}/run/%{name}
%attr(0750,%{toruser},%{torgroup}) %dir %{_localstatedir}/log/%{name}

%changelog

* Fri May 26 2006 Andrew Lewman <phobos@interloper.org>
- Add in a few "SUSEisms" to make dist-rpm actually work on suse
- Turn Tor "on" via chkconfig
- Update -mcpu to -mtune to make GCC happy
- see OR-CVS for details

* Tue Mar 28 2006 Andrew Lewman <phobos@interloper.org>
- converted to build the specified target cpu and arch
- override related rpm macros to build correctly
- see OR-CVS for details

* Mon Jan 17 2005 John Bashinski <jbash@velvet.com>
- Take runtime user and group names from configure system. Default
  user/group names are now "_tor"; blame Roger...
- Make logrotate control file a separate file in the source distribution,
  rather than creating it from the spec file.
- Properly handle the order in which RPM executes scriptlets on upgrade.
  The old code would kill the daemon on upgrade.
- Start the tor daemon after installation if and only if it was
  running before installation. Preserve runlevel setup on upgrade.
- Package the torctl script; the init script is now a wrapper around it.

* Tue Nov  5 2004 John Bashinski <jbash@velvet.com>
- Add skeletal support for multiple distributions
- Even more ridiculous level of macro-ization
- Modify version numbers so RPM can determine when it has a newer version
- Return to including distribution name in package release number
- Sharply trim description
- Change user/group name from "tor" to "tordmn"; "tor" is a common
  given name (reported by Marius Hjelle)
- Change group to "System Environment/Daemons" (suggested by Marius Hjelle)
- Create logrotate file (suggested by Marius Hjelle)
- Make Tor run as a user proxy by default (suggested by Marius Hjelle)
- Autogenerate spec file from GNU autotools data, substituting version
  and whatnot
- Be perhaps excessively paranoid with config file and directory modes
- Remove auto-start and auto-stop at installation time; there's some kind
  of weird race going on, and it's arguably a bad thing anyway.

* Mon Jun 06 2004 Nick Mathewson <nickm@freehaven.net> 0.0.7-0.std.0.1.rc2
- Make spec file more happy with fc2 packaging

* Sat Jan 17 2004 John Bashinski <jbash@velvet.com>
- Basic spec file; tested with Red Hat 9.
