// Copyright (C) 2002 Samy Bengio (bengio@idiap.ch)
//                
//
// This file is part of Torch. Release II.
// [The Ultimate Machine Learning Library]
//
// Torch is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// Torch is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Torch; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

#ifndef NPTRAINER_INC
#define NPTRAINER_INC

#include "Trainer.h"

namespace Torch {

/** Trainer for Non Parametric Machines. This trainer does nothing during
    training! But it can be used to test Non Parametric models such as
    KNN or ParzenDistributions or even select a correct hyper-parameter
    using cross-validation.

    @author Samy Bengio (bengio@idiap.ch)
 */
class NPTrainer : public Trainer
{
  public:

    NPTrainer(Machine *machine_, DataSet *data_);

    //-----

    virtual void train(List *measurers);
    virtual ~NPTrainer();
};


}

#endif
