// Copyright (C) 2002 Ronan Collobert (collober@iro.umontreal.ca)
//                
//
// This file is part of Torch. Release II.
// [The Ultimate Machine Learning Library]
//
// Torch is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// Torch is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Torch; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

#ifndef WEIGHTED_SUM_MACHINE_INC
#define WEIGHTED_SUM_MACHINE_INC

#include "Trainer.h"

namespace Torch {

/** Weighted-sum machine.
    This class contains a series of #Trainers#, and its forward method
    simply performs the average of the output of each trainer on the same input.

    @author Ronan Collobert (collober@iro.umontreal.ca)
*/
class WeightedSumMachine : public Machine
{
  public:

    /// The trainers used in the combination.
    Trainer **trainers;

    /// The corresponding measurers.
    List **trainers_measurers;

    /// The number of trainers in the combination.
    int n_trainers;

    /** The number of trainers that have been already trained.
        After the initialization, it's zero.
        Note that the forward method depends on this value.
        (only the first #n_trainers_trained# trainers are used)
    */
    int n_trainers_trained;

    /// The weights of the combination.
    real *weights;

    /// True if the weights aren't given by the user, false otherwise.
    bool weights_is_allocated;

    ///
    WeightedSumMachine(Trainer **trainer_, int n_trainers_, List **trainers_measurers, real *weights_=NULL);

    //-----

    virtual void forward(List *inputs);

    virtual void reset();
    virtual void loadFILE(FILE *file);
    virtual void saveFILE(FILE *file);

    virtual ~WeightedSumMachine();
};


}

#endif
