/***************************************************************************
*   Copyright (C) 2006 by Robert Hogan                                    *
*   robert@roberthogan.net                                                *
*   Copyright (C) 2005 by Hugo Parente Lima                               *
*   hugo_pl@users.sourceforge.net                                         *
*                                                                         *
*   This program is free software; you can redistribute it and/or modify  *
*   it under the terms of the GNU General Public License as published by  *
*   the Free Software Foundation; either version 2 of the License, or     *
*   (at your option) any later version.                                   *
*                                                                         *
*   This program is distributed in the hope that it will be useful,       *
*   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
*   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
*   GNU General Public License for more details.                          *
*                                                                         *
*   You should have received a copy of the GNU General Public License     *
*   along with this program; if not, write to the                         *
*   Free Software Foundation, Inc.,                                       *
*   51 Franklin St, Fifth Floor, Boston, MA 02110-1301, USA.              *
***************************************************************************/

#ifndef CHART_H
#define CHART_H

#include <qwidget.h>

class QPaintEvent;

class Chart : public QWidget {
public:
	Chart(QWidget* parent, const double* uploadBuffer, const double* downloadBuffer, int bufferSize, const int* ptr, const double* maxspeed, const double* sys_uploadBuffer, const double* sys_downloadBuffer, int sys_bufferSize, const int* sys_ptr, const double* sys_maxspeed, bool gotEth0);
	QSize sizeHint() { return QSize(600, 25); }
protected:	
	void paintEvent( QPaintEvent* ev );

private:
	const double* mUplBuffer;
	const double* mDldBuffer;
	const int mBufferSize;
	const int* mPtr;
	const double* mMaxSpeed;

	const double* sys_mUplBuffer;
	const double* sys_mDldBuffer;
	const int sys_mBufferSize;
	const int* sys_mPtr;
	const double* sys_mMaxSpeed;
    bool mGotEth0;
};

#endif
