/*
 *  TouchFreezeUI.h
 *
 *  Copyright (C) 2007, 2008  Stefan Kombrink
 *  Copyright (C) 2008 Pau Garcia i Quiles
 *
 *  This file is part of TouchFreeze.
 *
 *  TouchFreeze is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  TouchFreeze is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with touchfreeze; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301 USA
 *
 *  On Debian GNU/Linux systems, the complete text of the GNU General
 *  Public License can be found in the /usr/share/common-licenses/GPL file.
 */


#ifndef TOUCHFREEZEUI_H
#define TOUCHFREEZEUI_H

#include <QWidget>
#include <QString>
#include <QSystemTrayIcon>

#include "ui_TouchFreezeUIBase.h"

class QCloseEvent;

class TouchFreezeUI : public QWidget, protected Ui::TouchFreezeUIBase
{
  Q_OBJECT
public:
  TouchFreezeUI( QWidget* parent = NULL );

  void setup( const QString& tpStr, const QString& clientStr, unsigned int delay );
  void setStatusText( const QString& );
  void setDisabledIcon();
  void setEnabledIcon();

signals:
  void delayChanged( unsigned int );

protected:
  virtual void closeEvent( QCloseEvent* );

protected slots:
  virtual void onSystrayActivation( QSystemTrayIcon::ActivationReason );

  void onSpinBoxValueChange( double );
  void onSliderValueChange( int );

  void onCancel();
  void onApply();

private:
	QSystemTrayIcon* systray;
};



#endif
