/***********************************************************************
 *
 * $RCSfile: ntpctl.h,v $
 * $Revision: 1.2 $
 * $Date: 2001/01/08 21:51:51 $
 *
 * Author: Martin Fluch
 *
 *     Copyright (c) 1999 Martin Fluch, All rights reserved
 *     
 *     This program is free software; you can redistribute it and/or 
 *     modify it under the terms of the GNU General Public License as 
 *     published by the Free Software Foundation; either version 2 of 
 *     the License, or (at your option) any later version.
 * 
 *     This program is distributed in the hope that it will be useful,
 *     but WITHOUT ANY WARRANTY; without even the implied warranty of
 *     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 *     GNU General Public License for more details.
 * 
 *     To receive a copy of the GNU General Public License, please write
 *     to the Free Software Foundation, Inc., 59 Temple Place, Suite 330,
 *     Boston, MA 02111-1307 USA
 *
 ***********************************************************************/

#include "thinkpad_common.h"
#include "thinkpad.h"
#include "smapi.h"
#include "smapidev.h"

#define ACTION_INIT	1
#define ACTION_UPDATE	2
#define ACTION_KEY_H	3
#define ACTION_KEY_A	4
#define ACTION_KEY_M	5
#define ACTION_KEY_Y    6
#define ACTION_KEY_E    7
#define ACTION_KEY_N    8
#define ACTION_KEY_D	9
#define ACTION_KEY_S	10
#define ACTION_KEY_Z	11
#define ACTION_KEY_R	12
#define ACTION_KEY_O	13
#define ACTION_KEY_0	14 /* ZERO */
#define ACTION_KEY_RET  15
#define ACTION_KEY_L	16
#define ACTION_NEXT     50
#define ACTION_PREV	51

struct menuinfo 
{
  ITEM *item;
  char *name;
  char *desc;
  int (*func)(struct menuinfo *,int);
  const char *help;
};

smapi_outparm_t *do_smapi(byte, byte, word, word, word, dword, dword, int);

int pm_mode_ac(struct menuinfo *,int);
int pm_mode_battery(struct menuinfo *,int);
int pm_mode_save_suspend(struct menuinfo *,int);
int pm_resume_hardware(struct menuinfo *,int);
int pm_resume_lid(struct menuinfo *,int);
int pm_resume_RTC(struct menuinfo *,int);
int pm_resume_serial_RI(struct menuinfo *,int);
int rt_time(struct menuinfo *, int);
int rt_date(struct menuinfo *, int);
int rt_daily(struct menuinfo *, int);
int pm_sedate_standby_timer(struct menuinfo *, int);
int pm_sedate_system_timer(struct menuinfo *, int);
int pm_sedate_hib_from_sup(struct menuinfo *, int);
int pm_sedate_hw_and_sw_event(struct menuinfo *, int);
int pm_sedate_power_switch(struct menuinfo *, int);
int pm_sedate_lid(struct menuinfo *, int);
int pm_sedate_low_battery(struct menuinfo *, int);
int pm_sedate_env_exhausted(struct menuinfo *, int);
int tm_system_manual_ac(struct menuinfo *, int);
int tm_system_manual_battery(struct menuinfo *, int);
int tm_system_high(struct menuinfo *, int);
int tm_system_auto(struct menuinfo *, int);
int tm_hibernation(struct menuinfo *, int);
int tm_ctrl_hib_susp(struct menuinfo *, int);
int tm_ctrl_standby(struct menuinfo *, int);
int tm_ctrl_LCD_off(struct menuinfo *, int);
int tm_ctrl_HDD_off(struct menuinfo *, int);
int fn_hotkey(struct menuinfo *,int);
int pd_external_ch(struct menuinfo *, int);
int pd_external_CMOS(struct menuinfo *, int);
int pd_internal_ch(struct menuinfo *, int);
int pd_internal_CMOS(struct menuinfo *, int);

#define MAXNAMESIZE	36
#define MAXDESCSIZE	64

extern const char *helptext[];

#define HELP_ahm	0
#define HELP_ed		1
#define HELP_szrho	2
#define HELP_timer	3
#define HELP_eda	4
#define HELP_yn		5
#define HELP_value	6
