#include "os.h"

#define PLAN9ERRNO 123456878

static char xerrstr[ERRMAX];

void
errstr(char *s, uint n)
{
	char tmp[ERRMAX];

	utfecpy(tmp, tmp+ERRMAX, s);
	rerrstr(s, n);
	memmove(xerrstr, tmp, ERRMAX);
}

void
rerrstr(char *s, uint n)
{
	if(errno == PLAN9ERRNO)
		utfecpy(s, s+n, xerrstr);
	else
		utfecpy(s, s+n, strerror(errno));
}

void
werrstr(char *s, ...)
{
	va_list arg;

	va_start(arg, s);
	vseprint(xerrstr, xerrstr+ERRMAX, s, arg);
	va_end(arg);
	errno = PLAN9ERRNO;
}

