#include "tra.h"

DMap *map;
DStore *s;	

static char*
cmdcreate(int argc, char **argv)
{
	int r;
	static char buf[ERRMAX];
	Datum key, val;

	if(argc != 2)
		return "usage: create key ptr";

	if(map == nil)
		return "not open";

	key.a = argv[0];
	key.n = strlen(argv[0])+1;

	val.a = argv[1];
	val.n = strlen(argv[1])+1;

	r = map->insert(map, &key, &val, DMapCreate);
	if(r < 0){
		rerrstr(buf, sizeof buf);
		return buf;
	}
	return nil;
}

static char*
cmdreplace(int argc, char **argv)
{
	int r;
	static char buf[ERRMAX];
	Datum key, val;

	if(argc != 2)
		return "usage: replace key ptr";

	if(map == nil)
		return "not open";

	key.a = argv[0];
	key.n = strlen(argv[0])+1;

	val.a = argv[1];
	val.n = strlen(argv[1])+1;

	r = map->insert(map, &key, &val, DMapReplace);
	if(r < 0){
		rerrstr(buf, sizeof buf);
		return buf;
	}
	return nil;
}

static char*
cmdinsert(int argc, char **argv)
{
	int r;
	static char buf[ERRMAX];
	Datum key, val;

	if(argc != 2)
		return "usage: insert key ptr";

	if(map == nil)
		return "not open";

	key.a = argv[0];
	key.n = strlen(argv[0])+1;

	val.a = argv[1];
	val.n = strlen(argv[1])+1;

	r = map->insert(map, &key, &val, DMapCreate|DMapReplace);
	if(r < 0){
		rerrstr(buf, sizeof buf);
		return buf;
	}
	return nil;
}

static char*
cmdlookup(int argc, char **argv)
{
	int r;
	static char buf[ERRMAX];
	char xbuf[1024];
	Datum key, val;

	if(argc != 1)
		return "usage: lookup key";

	if(map == nil)
		return "not open";

	key.a = argv[0];
	key.n = strlen(argv[0])+1;

	val.a = xbuf;
	val.n = sizeof xbuf;

	r = map->lookup(map, &key, &val);
	if(r < 0){
		rerrstr(buf, sizeof buf);
		return buf;
	}
	print("%.*s\n", utfnlen(val.a, val.n), val.a);
	return nil;
}

static char*
cmddelete(int argc, char **argv)
{
	int r;
	static char buf[ERRMAX];
	Datum key;

	if(argc != 1)
		return "usage: delete key";

	if(map == nil)
		return "not open";

	key.a = argv[0];
	key.n = strlen(argv[0])+1;

	r = map->delete(map, &key);
	if(r < 0){
		rerrstr(buf, sizeof buf);
		return buf;
	}
	return nil;
}

static char*
cmdshow(int argc, char **argv)
{
	USED(argv);
	if(argc != 0)
		return "usage: show";

	if(map == nil)
		return "not open";

	map->dump(map, 1);
	return nil;
}

static char*
cmdclose(int argc, char **argv)
{
	USED(argv);
	if(argc != 0)
		return "usage: close";

	map->close(map);
	map = nil;
	s->close(s);
	s = nil;
	return nil;
}

static char*
cmdclosemap(int argc, char **argv)
{
	USED(argv);
	if(argc != 0)
		return "usage: closemap";

	map->close(map);
	map = nil;
	return nil;
}

static char*
cmddropmap(int argc, char **argv)
{
	USED(argv);
	if(argc != 0)
		return "usage: dropmap";

	map = nil;
	return nil;
}


static char*
cmdflush(int argc, char **argv)
{
	USED(argv);
	if(argc != 0)
		return "usage: flush";

	if(map == nil)
		return "not open";

	map->flush(map);
	s->flush(s);
	return nil;
}

static char*
cmdopen(int argc, char **argv)
{
	ulong addr;

	if(argc != 1)
		return "usage: open addr";

	if(map != nil)
		return "not closed";

	addr = strtoul(argv[0], 0, 0);
	if(s == nil){
		s = opendstore("tmp.testdb");
		assert(s);
	}
	map = dmaplist(s, addr, 256 - s->hdrsize);
	assert(map);
	return nil;
}

static char*
cmdreopen(int argc, char **argv)
{
	ulong addr;

	USED(argv);

	if(argc != 0)
		return "usage: reopen";

	if(map == nil)
		return "not open";

	addr = map->addr;
	cmdclose(0, nil);
	s = opendstore("tmp.testdb");
	assert(s);
	map = dmaplist(s, addr, 256 - s->hdrsize);
	assert(map);
	return nil;
}

static char*
cmdnew(int argc, char **argv)
{
	USED(argv);

	if(argc != 0)
		return "usage: new";

	if(map)
		cmdclose(0, nil);
	remove("tmp.testdb");
	remove("tmp.testdb.redo");
	s = createdstore("tmp.testdb", 256);
	assert(s);
	map = dmaplist(s, 0, 256 - s->hdrsize);
	assert(map);
	print("map is at addr 0x%ux\n", map->addr);
	return nil;
}

static struct {
	char *cmd;
	char *(*fn)(int, char**);
} tab[] = {
	{ "new",	cmdnew, },
	{ "create",	cmdcreate, },
	{ "replace",	cmdreplace, },
	{ "insert",	cmdinsert, },
	{ "lookup",	cmdlookup, },
	{ "delete",	cmddelete, },
	{ "show",	cmdshow, },
	{ "flush",	cmdflush, },
	{ "close",	cmdclose, },
	{ "closemap",	cmdclosemap, },
	{ "dropmap",	cmddropmap, },
	{ "open",	cmdopen, },
	{ "reopen",	cmdreopen, }
};

void
threadmain(int argc, char **argv)
{
	int i, n;
	char *e, *tok[16], buf[512];

	USED(argc);
	USED(argv);

	for(;;){
		print(">>> ");
		n = read(0, buf, sizeof buf);
		if(n <= 0)
			exits(nil);
		buf[n-1] = '\0';
		n = tokenize(buf, tok, nelem(tok));
		if(n <= 0)
			continue;
		for(i=0; i<nelem(tab); i++)
			if(strcmp(tok[0], tab[i].cmd) == 0){
				e = tab[i].fn(n-1, tok+1);
				if(e)
					print("?%s\n", e);
				break;
			}
		if(i==nelem(tab))
			print("?unknown command\n");
	}	
}

int
config(char *s)
{
	USED(s);
	return 0;
}
