/* tracker-sparql-expression.c generated by valac 0.14.0, the Vala compiler
 * generated from tracker-sparql-expression.vala, do not modify */

/*
 * Copyright (C) 2008-2010, Nokia
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
 * Boston, MA  02110-1301, USA.
 */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <libtracker-sparql/tracker-sparql.h>
#include <libtracker-data/tracker-property.h>
#include <libtracker-data/tracker-db-interface-sqlite.h>
#include <libtracker-data/tracker-class.h>
#include <libtracker-data/tracker-collation.h>
#include <libtracker-data/tracker-ontologies.h>


#define TRACKER_SPARQL_TYPE_EXPRESSION (tracker_sparql_expression_get_type ())
#define TRACKER_SPARQL_EXPRESSION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TRACKER_SPARQL_TYPE_EXPRESSION, TrackerSparqlExpression))
#define TRACKER_SPARQL_EXPRESSION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TRACKER_SPARQL_TYPE_EXPRESSION, TrackerSparqlExpressionClass))
#define TRACKER_SPARQL_IS_EXPRESSION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TRACKER_SPARQL_TYPE_EXPRESSION))
#define TRACKER_SPARQL_IS_EXPRESSION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TRACKER_SPARQL_TYPE_EXPRESSION))
#define TRACKER_SPARQL_EXPRESSION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TRACKER_SPARQL_TYPE_EXPRESSION, TrackerSparqlExpressionClass))

typedef struct _TrackerSparqlExpression TrackerSparqlExpression;
typedef struct _TrackerSparqlExpressionClass TrackerSparqlExpressionClass;
typedef struct _TrackerSparqlExpressionPrivate TrackerSparqlExpressionPrivate;

#define TRACKER_SPARQL_TYPE_QUERY (tracker_sparql_query_get_type ())
#define TRACKER_SPARQL_QUERY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TRACKER_SPARQL_TYPE_QUERY, TrackerSparqlQuery))
#define TRACKER_SPARQL_QUERY_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TRACKER_SPARQL_TYPE_QUERY, TrackerSparqlQueryClass))
#define TRACKER_SPARQL_IS_QUERY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TRACKER_SPARQL_TYPE_QUERY))
#define TRACKER_SPARQL_IS_QUERY_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TRACKER_SPARQL_TYPE_QUERY))
#define TRACKER_SPARQL_QUERY_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TRACKER_SPARQL_TYPE_QUERY, TrackerSparqlQueryClass))

typedef struct _TrackerSparqlQuery TrackerSparqlQuery;
typedef struct _TrackerSparqlQueryClass TrackerSparqlQueryClass;

#define TRACKER_TYPE_SPARQL_TOKEN_TYPE (tracker_sparql_token_type_get_type ())
#define _g_free0(var) (var = (g_free (var), NULL))

#define TRACKER_SPARQL_TYPE_VARIABLE (tracker_sparql_variable_get_type ())
#define TRACKER_SPARQL_VARIABLE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TRACKER_SPARQL_TYPE_VARIABLE, TrackerSparqlVariable))
#define TRACKER_SPARQL_VARIABLE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TRACKER_SPARQL_TYPE_VARIABLE, TrackerSparqlVariableClass))
#define TRACKER_SPARQL_IS_VARIABLE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TRACKER_SPARQL_TYPE_VARIABLE))
#define TRACKER_SPARQL_IS_VARIABLE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TRACKER_SPARQL_TYPE_VARIABLE))
#define TRACKER_SPARQL_VARIABLE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TRACKER_SPARQL_TYPE_VARIABLE, TrackerSparqlVariableClass))

typedef struct _TrackerSparqlVariable TrackerSparqlVariable;
typedef struct _TrackerSparqlVariableClass TrackerSparqlVariableClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define TRACKER_SPARQL_TYPE_CONTEXT (tracker_sparql_context_get_type ())
#define TRACKER_SPARQL_CONTEXT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TRACKER_SPARQL_TYPE_CONTEXT, TrackerSparqlContext))
#define TRACKER_SPARQL_CONTEXT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TRACKER_SPARQL_TYPE_CONTEXT, TrackerSparqlContextClass))
#define TRACKER_SPARQL_IS_CONTEXT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TRACKER_SPARQL_TYPE_CONTEXT))
#define TRACKER_SPARQL_IS_CONTEXT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TRACKER_SPARQL_TYPE_CONTEXT))
#define TRACKER_SPARQL_CONTEXT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TRACKER_SPARQL_TYPE_CONTEXT, TrackerSparqlContextClass))

typedef struct _TrackerSparqlContext TrackerSparqlContext;
typedef struct _TrackerSparqlContextClass TrackerSparqlContextClass;
typedef struct _TrackerSparqlVariablePrivate TrackerSparqlVariablePrivate;

#define TRACKER_SPARQL_TYPE_DATA_BINDING (tracker_sparql_data_binding_get_type ())
#define TRACKER_SPARQL_DATA_BINDING(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TRACKER_SPARQL_TYPE_DATA_BINDING, TrackerSparqlDataBinding))
#define TRACKER_SPARQL_DATA_BINDING_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TRACKER_SPARQL_TYPE_DATA_BINDING, TrackerSparqlDataBindingClass))
#define TRACKER_SPARQL_IS_DATA_BINDING(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TRACKER_SPARQL_TYPE_DATA_BINDING))
#define TRACKER_SPARQL_IS_DATA_BINDING_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TRACKER_SPARQL_TYPE_DATA_BINDING))
#define TRACKER_SPARQL_DATA_BINDING_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TRACKER_SPARQL_TYPE_DATA_BINDING, TrackerSparqlDataBindingClass))

typedef struct _TrackerSparqlDataBinding TrackerSparqlDataBinding;
typedef struct _TrackerSparqlDataBindingClass TrackerSparqlDataBindingClass;

#define TRACKER_SPARQL_TYPE_VARIABLE_BINDING (tracker_sparql_variable_binding_get_type ())
#define TRACKER_SPARQL_VARIABLE_BINDING(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TRACKER_SPARQL_TYPE_VARIABLE_BINDING, TrackerSparqlVariableBinding))
#define TRACKER_SPARQL_VARIABLE_BINDING_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TRACKER_SPARQL_TYPE_VARIABLE_BINDING, TrackerSparqlVariableBindingClass))
#define TRACKER_SPARQL_IS_VARIABLE_BINDING(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TRACKER_SPARQL_TYPE_VARIABLE_BINDING))
#define TRACKER_SPARQL_IS_VARIABLE_BINDING_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TRACKER_SPARQL_TYPE_VARIABLE_BINDING))
#define TRACKER_SPARQL_VARIABLE_BINDING_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TRACKER_SPARQL_TYPE_VARIABLE_BINDING, TrackerSparqlVariableBindingClass))

typedef struct _TrackerSparqlVariableBinding TrackerSparqlVariableBinding;
typedef struct _TrackerSparqlVariableBindingClass TrackerSparqlVariableBindingClass;

#define TRACKER_SPARQL_TYPE_PATTERN (tracker_sparql_pattern_get_type ())
#define TRACKER_SPARQL_PATTERN(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TRACKER_SPARQL_TYPE_PATTERN, TrackerSparqlPattern))
#define TRACKER_SPARQL_PATTERN_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TRACKER_SPARQL_TYPE_PATTERN, TrackerSparqlPatternClass))
#define TRACKER_SPARQL_IS_PATTERN(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TRACKER_SPARQL_TYPE_PATTERN))
#define TRACKER_SPARQL_IS_PATTERN_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TRACKER_SPARQL_TYPE_PATTERN))
#define TRACKER_SPARQL_PATTERN_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TRACKER_SPARQL_TYPE_PATTERN, TrackerSparqlPatternClass))

typedef struct _TrackerSparqlPattern TrackerSparqlPattern;
typedef struct _TrackerSparqlPatternClass TrackerSparqlPatternClass;

#define TRACKER_SPARQL_TYPE_SELECT_CONTEXT (tracker_sparql_select_context_get_type ())
#define TRACKER_SPARQL_SELECT_CONTEXT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TRACKER_SPARQL_TYPE_SELECT_CONTEXT, TrackerSparqlSelectContext))
#define TRACKER_SPARQL_SELECT_CONTEXT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TRACKER_SPARQL_TYPE_SELECT_CONTEXT, TrackerSparqlSelectContextClass))
#define TRACKER_SPARQL_IS_SELECT_CONTEXT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TRACKER_SPARQL_TYPE_SELECT_CONTEXT))
#define TRACKER_SPARQL_IS_SELECT_CONTEXT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TRACKER_SPARQL_TYPE_SELECT_CONTEXT))
#define TRACKER_SPARQL_SELECT_CONTEXT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TRACKER_SPARQL_TYPE_SELECT_CONTEXT, TrackerSparqlSelectContextClass))

typedef struct _TrackerSparqlSelectContext TrackerSparqlSelectContext;
typedef struct _TrackerSparqlSelectContextClass TrackerSparqlSelectContextClass;
#define _tracker_sparql_context_unref0(var) ((var == NULL) ? NULL : (var = (tracker_sparql_context_unref (var), NULL)))
typedef struct _TrackerSparqlContextPrivate TrackerSparqlContextPrivate;

#define TRACKER_SPARQL_TYPE_PREDICATE_VARIABLE (tracker_sparql_predicate_variable_get_type ())
#define TRACKER_SPARQL_PREDICATE_VARIABLE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TRACKER_SPARQL_TYPE_PREDICATE_VARIABLE, TrackerSparqlPredicateVariable))
#define TRACKER_SPARQL_PREDICATE_VARIABLE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TRACKER_SPARQL_TYPE_PREDICATE_VARIABLE, TrackerSparqlPredicateVariableClass))
#define TRACKER_SPARQL_IS_PREDICATE_VARIABLE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TRACKER_SPARQL_TYPE_PREDICATE_VARIABLE))
#define TRACKER_SPARQL_IS_PREDICATE_VARIABLE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TRACKER_SPARQL_TYPE_PREDICATE_VARIABLE))
#define TRACKER_SPARQL_PREDICATE_VARIABLE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TRACKER_SPARQL_TYPE_PREDICATE_VARIABLE, TrackerSparqlPredicateVariableClass))

typedef struct _TrackerSparqlPredicateVariable TrackerSparqlPredicateVariable;
typedef struct _TrackerSparqlPredicateVariableClass TrackerSparqlPredicateVariableClass;
typedef struct _TrackerSparqlSelectContextPrivate TrackerSparqlSelectContextPrivate;
typedef struct _TrackerSparqlDataBindingPrivate TrackerSparqlDataBindingPrivate;

#define TRACKER_SPARQL_TYPE_DATA_TABLE (tracker_sparql_data_table_get_type ())
#define TRACKER_SPARQL_DATA_TABLE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TRACKER_SPARQL_TYPE_DATA_TABLE, TrackerSparqlDataTable))
#define TRACKER_SPARQL_DATA_TABLE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TRACKER_SPARQL_TYPE_DATA_TABLE, TrackerSparqlDataTableClass))
#define TRACKER_SPARQL_IS_DATA_TABLE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TRACKER_SPARQL_TYPE_DATA_TABLE))
#define TRACKER_SPARQL_IS_DATA_TABLE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TRACKER_SPARQL_TYPE_DATA_TABLE))
#define TRACKER_SPARQL_DATA_TABLE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TRACKER_SPARQL_TYPE_DATA_TABLE, TrackerSparqlDataTableClass))

typedef struct _TrackerSparqlDataTable TrackerSparqlDataTable;
typedef struct _TrackerSparqlDataTableClass TrackerSparqlDataTableClass;
typedef struct _TrackerSparqlVariableBindingPrivate TrackerSparqlVariableBindingPrivate;

#define TRACKER_SPARQL_TYPE_VARIABLE_STATE (tracker_sparql_variable_state_get_type ())
#define _g_string_free0(var) ((var == NULL) ? NULL : (var = (g_string_free (var, TRUE), NULL)))

#define TRACKER_SPARQL_TYPE_LITERAL_BINDING (tracker_sparql_literal_binding_get_type ())
#define TRACKER_SPARQL_LITERAL_BINDING(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TRACKER_SPARQL_TYPE_LITERAL_BINDING, TrackerSparqlLiteralBinding))
#define TRACKER_SPARQL_LITERAL_BINDING_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TRACKER_SPARQL_TYPE_LITERAL_BINDING, TrackerSparqlLiteralBindingClass))
#define TRACKER_SPARQL_IS_LITERAL_BINDING(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TRACKER_SPARQL_TYPE_LITERAL_BINDING))
#define TRACKER_SPARQL_IS_LITERAL_BINDING_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TRACKER_SPARQL_TYPE_LITERAL_BINDING))
#define TRACKER_SPARQL_LITERAL_BINDING_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TRACKER_SPARQL_TYPE_LITERAL_BINDING, TrackerSparqlLiteralBindingClass))

typedef struct _TrackerSparqlLiteralBinding TrackerSparqlLiteralBinding;
typedef struct _TrackerSparqlLiteralBindingClass TrackerSparqlLiteralBindingClass;
typedef struct _TrackerSparqlLiteralBindingPrivate TrackerSparqlLiteralBindingPrivate;
typedef struct _TrackerSparqlQueryPrivate TrackerSparqlQueryPrivate;

struct _TrackerSparqlExpression {
	GObject parent_instance;
	TrackerSparqlExpressionPrivate * priv;
};

struct _TrackerSparqlExpressionClass {
	GObjectClass parent_class;
};

struct _TrackerSparqlExpressionPrivate {
	TrackerSparqlQuery* query;
};

typedef enum  {
	TRACKER_SPARQL_TOKEN_TYPE_NONE,
	TRACKER_SPARQL_TOKEN_TYPE_A,
	TRACKER_SPARQL_TOKEN_TYPE_AS,
	TRACKER_SPARQL_TOKEN_TYPE_ASC,
	TRACKER_SPARQL_TOKEN_TYPE_ASK,
	TRACKER_SPARQL_TOKEN_TYPE_ATBASE,
	TRACKER_SPARQL_TOKEN_TYPE_ATPREFIX,
	TRACKER_SPARQL_TOKEN_TYPE_AVG,
	TRACKER_SPARQL_TOKEN_TYPE_BASE,
	TRACKER_SPARQL_TOKEN_TYPE_BLANK_NODE,
	TRACKER_SPARQL_TOKEN_TYPE_BOUND,
	TRACKER_SPARQL_TOKEN_TYPE_BY,
	TRACKER_SPARQL_TOKEN_TYPE_CLOSE_BRACE,
	TRACKER_SPARQL_TOKEN_TYPE_CLOSE_BRACKET,
	TRACKER_SPARQL_TOKEN_TYPE_CLOSE_PARENS,
	TRACKER_SPARQL_TOKEN_TYPE_COALESCE,
	TRACKER_SPARQL_TOKEN_TYPE_COLON,
	TRACKER_SPARQL_TOKEN_TYPE_COMMA,
	TRACKER_SPARQL_TOKEN_TYPE_CONSTRUCT,
	TRACKER_SPARQL_TOKEN_TYPE_COUNT,
	TRACKER_SPARQL_TOKEN_TYPE_DATA,
	TRACKER_SPARQL_TOKEN_TYPE_DATATYPE,
	TRACKER_SPARQL_TOKEN_TYPE_DECIMAL,
	TRACKER_SPARQL_TOKEN_TYPE_DELETE,
	TRACKER_SPARQL_TOKEN_TYPE_DESC,
	TRACKER_SPARQL_TOKEN_TYPE_DESCRIBE,
	TRACKER_SPARQL_TOKEN_TYPE_DISTINCT,
	TRACKER_SPARQL_TOKEN_TYPE_DIV,
	TRACKER_SPARQL_TOKEN_TYPE_DOT,
	TRACKER_SPARQL_TOKEN_TYPE_DOUBLE,
	TRACKER_SPARQL_TOKEN_TYPE_DOUBLE_CIRCUMFLEX,
	TRACKER_SPARQL_TOKEN_TYPE_DROP,
	TRACKER_SPARQL_TOKEN_TYPE_EOF,
	TRACKER_SPARQL_TOKEN_TYPE_EXISTS,
	TRACKER_SPARQL_TOKEN_TYPE_FALSE,
	TRACKER_SPARQL_TOKEN_TYPE_FILTER,
	TRACKER_SPARQL_TOKEN_TYPE_FROM,
	TRACKER_SPARQL_TOKEN_TYPE_GRAPH,
	TRACKER_SPARQL_TOKEN_TYPE_GROUP,
	TRACKER_SPARQL_TOKEN_TYPE_GROUP_CONCAT,
	TRACKER_SPARQL_TOKEN_TYPE_HAVING,
	TRACKER_SPARQL_TOKEN_TYPE_IF,
	TRACKER_SPARQL_TOKEN_TYPE_INSERT,
	TRACKER_SPARQL_TOKEN_TYPE_INTEGER,
	TRACKER_SPARQL_TOKEN_TYPE_INTO,
	TRACKER_SPARQL_TOKEN_TYPE_IRI_REF,
	TRACKER_SPARQL_TOKEN_TYPE_ISBLANK,
	TRACKER_SPARQL_TOKEN_TYPE_ISIRI,
	TRACKER_SPARQL_TOKEN_TYPE_ISLITERAL,
	TRACKER_SPARQL_TOKEN_TYPE_ISURI,
	TRACKER_SPARQL_TOKEN_TYPE_LANG,
	TRACKER_SPARQL_TOKEN_TYPE_LANGMATCHES,
	TRACKER_SPARQL_TOKEN_TYPE_LIMIT,
	TRACKER_SPARQL_TOKEN_TYPE_MAX,
	TRACKER_SPARQL_TOKEN_TYPE_MIN,
	TRACKER_SPARQL_TOKEN_TYPE_MINUS,
	TRACKER_SPARQL_TOKEN_TYPE_NAMED,
	TRACKER_SPARQL_TOKEN_TYPE_NOT,
	TRACKER_SPARQL_TOKEN_TYPE_NULL,
	TRACKER_SPARQL_TOKEN_TYPE_OFFSET,
	TRACKER_SPARQL_TOKEN_TYPE_OP_AND,
	TRACKER_SPARQL_TOKEN_TYPE_OP_EQ,
	TRACKER_SPARQL_TOKEN_TYPE_OP_GE,
	TRACKER_SPARQL_TOKEN_TYPE_OP_GT,
	TRACKER_SPARQL_TOKEN_TYPE_OP_LE,
	TRACKER_SPARQL_TOKEN_TYPE_OP_LT,
	TRACKER_SPARQL_TOKEN_TYPE_OP_NE,
	TRACKER_SPARQL_TOKEN_TYPE_OP_NEG,
	TRACKER_SPARQL_TOKEN_TYPE_OP_OR,
	TRACKER_SPARQL_TOKEN_TYPE_OP_IN,
	TRACKER_SPARQL_TOKEN_TYPE_OPEN_BRACE,
	TRACKER_SPARQL_TOKEN_TYPE_OPEN_BRACKET,
	TRACKER_SPARQL_TOKEN_TYPE_OPEN_PARENS,
	TRACKER_SPARQL_TOKEN_TYPE_OPTIONAL,
	TRACKER_SPARQL_TOKEN_TYPE_OR,
	TRACKER_SPARQL_TOKEN_TYPE_ORDER,
	TRACKER_SPARQL_TOKEN_TYPE_PLUS,
	TRACKER_SPARQL_TOKEN_TYPE_PN_PREFIX,
	TRACKER_SPARQL_TOKEN_TYPE_PREFIX,
	TRACKER_SPARQL_TOKEN_TYPE_REDUCED,
	TRACKER_SPARQL_TOKEN_TYPE_REGEX,
	TRACKER_SPARQL_TOKEN_TYPE_REPLACE,
	TRACKER_SPARQL_TOKEN_TYPE_SAMETERM,
	TRACKER_SPARQL_TOKEN_TYPE_SELECT,
	TRACKER_SPARQL_TOKEN_TYPE_SEMICOLON,
	TRACKER_SPARQL_TOKEN_TYPE_SILENT,
	TRACKER_SPARQL_TOKEN_TYPE_STAR,
	TRACKER_SPARQL_TOKEN_TYPE_STR,
	TRACKER_SPARQL_TOKEN_TYPE_STRING_LITERAL1,
	TRACKER_SPARQL_TOKEN_TYPE_STRING_LITERAL2,
	TRACKER_SPARQL_TOKEN_TYPE_STRING_LITERAL_LONG1,
	TRACKER_SPARQL_TOKEN_TYPE_STRING_LITERAL_LONG2,
	TRACKER_SPARQL_TOKEN_TYPE_SUM,
	TRACKER_SPARQL_TOKEN_TYPE_TRUE,
	TRACKER_SPARQL_TOKEN_TYPE_UNION,
	TRACKER_SPARQL_TOKEN_TYPE_VAR,
	TRACKER_SPARQL_TOKEN_TYPE_WHERE,
	TRACKER_SPARQL_TOKEN_TYPE_WITH
} TrackerSparqlTokenType;

struct _TrackerSparqlVariable {
	GObject parent_instance;
	TrackerSparqlVariablePrivate * priv;
	TrackerSparqlVariableBinding* binding;
};

struct _TrackerSparqlVariableClass {
	GObjectClass parent_class;
};

struct _TrackerSparqlContext {
	GTypeInstance parent_instance;
	volatile int ref_count;
	TrackerSparqlContextPrivate * priv;
	TrackerSparqlQuery* query;
	TrackerSparqlContext* parent_context;
	GHashTable* var_set;
	GHashTable* var_map;
	GHashTable* select_var_set;
	GHashTable* predicate_variable_map;
	gboolean scalar_subquery;
};

struct _TrackerSparqlContextClass {
	GTypeClass parent_class;
	void (*finalize) (TrackerSparqlContext *self);
};

struct _TrackerSparqlSelectContext {
	TrackerSparqlContext parent_instance;
	TrackerSparqlSelectContextPrivate * priv;
	TrackerPropertyType type;
	TrackerPropertyType* types;
	gint types_length1;
	gint _types_size_;
	gchar** variable_names;
	gint variable_names_length1;
	gint _variable_names_size_;
};

struct _TrackerSparqlSelectContextClass {
	TrackerSparqlContextClass parent_class;
};

struct _TrackerSparqlDataBinding {
	GObject parent_instance;
	TrackerSparqlDataBindingPrivate * priv;
	TrackerPropertyType data_type;
	TrackerSparqlDataTable* table;
	gchar* sql_db_column_name;
};

struct _TrackerSparqlDataBindingClass {
	GObjectClass parent_class;
};

struct _TrackerSparqlVariableBinding {
	TrackerSparqlDataBinding parent_instance;
	TrackerSparqlVariableBindingPrivate * priv;
	TrackerSparqlVariable* variable;
	gboolean maybe_null;
	gboolean in_simple_optional;
	TrackerClass* type;
};

struct _TrackerSparqlVariableBindingClass {
	TrackerSparqlDataBindingClass parent_class;
};

typedef enum  {
	TRACKER_SPARQL_VARIABLE_STATE_NONE,
	TRACKER_SPARQL_VARIABLE_STATE_BOUND,
	TRACKER_SPARQL_VARIABLE_STATE_OPTIONAL
} TrackerSparqlVariableState;

struct _TrackerSparqlLiteralBinding {
	TrackerSparqlDataBinding parent_instance;
	TrackerSparqlLiteralBindingPrivate * priv;
	gboolean is_fts_match;
	gchar* literal;
};

struct _TrackerSparqlLiteralBindingClass {
	TrackerSparqlDataBindingClass parent_class;
};

struct _TrackerSparqlQuery {
	GObject parent_instance;
	TrackerSparqlQueryPrivate * priv;
	TrackerSparqlExpression* expression;
	TrackerSparqlPattern* pattern;
	GList* bindings;
	TrackerSparqlContext* context;
	gint last_var_index;
};

struct _TrackerSparqlQueryClass {
	GObjectClass parent_class;
};


static gpointer tracker_sparql_expression_parent_class = NULL;

GType tracker_sparql_expression_get_type (void) G_GNUC_CONST;
GType tracker_sparql_query_get_type (void) G_GNUC_CONST;
#define TRACKER_SPARQL_EXPRESSION_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TRACKER_SPARQL_TYPE_EXPRESSION, TrackerSparqlExpressionPrivate))
enum  {
	TRACKER_SPARQL_EXPRESSION_DUMMY_PROPERTY
};
#define TRACKER_SPARQL_EXPRESSION_MAX_VARIABLES_FOR_IN 20
#define TRACKER_SPARQL_EXPRESSION_XSD_NS "http://www.w3.org/2001/XMLSchema#"
#define TRACKER_SPARQL_EXPRESSION_FN_NS "http://www.w3.org/2005/xpath-functions#"
#define TRACKER_SPARQL_EXPRESSION_FTS_NS "http://www.tracker-project.org/ontologies/fts#"
#define TRACKER_SPARQL_EXPRESSION_TRACKER_NS "http://www.tracker-project.org/ontologies/tracker#"
TrackerSparqlExpression* tracker_sparql_expression_new (TrackerSparqlQuery* query);
TrackerSparqlExpression* tracker_sparql_expression_construct (GType object_type, TrackerSparqlQuery* query);
static inline gboolean tracker_sparql_expression_next (TrackerSparqlExpression* self, GError** error);
gboolean tracker_sparql_query_next (TrackerSparqlQuery* self, GError** error);
GType tracker_sparql_token_type_get_type (void) G_GNUC_CONST;
static inline TrackerSparqlTokenType tracker_sparql_expression_current (TrackerSparqlExpression* self);
TrackerSparqlTokenType tracker_sparql_query_current (TrackerSparqlQuery* self);
static inline TrackerSparqlTokenType tracker_sparql_expression_last (TrackerSparqlExpression* self);
TrackerSparqlTokenType tracker_sparql_query_last (TrackerSparqlQuery* self);
static inline gboolean tracker_sparql_expression_accept (TrackerSparqlExpression* self, TrackerSparqlTokenType type, GError** error);
gboolean tracker_sparql_query_accept (TrackerSparqlQuery* self, TrackerSparqlTokenType type, GError** error);
static GError* tracker_sparql_expression_get_error (TrackerSparqlExpression* self, const gchar* msg);
GError* tracker_sparql_query_get_error (TrackerSparqlQuery* self, const gchar* msg);
static gboolean tracker_sparql_expression_expect (TrackerSparqlExpression* self, TrackerSparqlTokenType type, GError** error);
gboolean tracker_sparql_query_expect (TrackerSparqlQuery* self, TrackerSparqlTokenType type, GError** error);
static gchar* tracker_sparql_expression_get_last_string (TrackerSparqlExpression* self, gint strip);
gchar* tracker_sparql_query_get_last_string (TrackerSparqlQuery* self, gint strip);
static gchar* tracker_sparql_expression_escape_sql_string_literal (TrackerSparqlExpression* self, const gchar* literal);
static gboolean tracker_sparql_expression_maybe_numeric (TrackerSparqlExpression* self, TrackerPropertyType type);
static void tracker_sparql_expression_append_collate (TrackerSparqlExpression* self, GString* sql);
static void tracker_sparql_expression_skip_bracketted_expression (TrackerSparqlExpression* self, GError** error);
void tracker_sparql_expression_skip_select_variables (TrackerSparqlExpression* self, GError** error);
TrackerPropertyType tracker_sparql_expression_translate_select_expression (TrackerSparqlExpression* self, GString* sql, gboolean subquery, gint variable_index, GError** error);
GType tracker_sparql_variable_get_type (void) G_GNUC_CONST;
TrackerPropertyType tracker_sparql_expression_translate_expression (TrackerSparqlExpression* self, GString* sql, GError** error);
gpointer tracker_sparql_context_ref (gpointer instance);
void tracker_sparql_context_unref (gpointer instance);
GParamSpec* tracker_sparql_param_spec_context (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void tracker_sparql_value_set_context (GValue* value, gpointer v_object);
void tracker_sparql_value_take_context (GValue* value, gpointer v_object);
gpointer tracker_sparql_value_get_context (const GValue* value);
GType tracker_sparql_context_get_type (void) G_GNUC_CONST;
static TrackerSparqlContext* tracker_sparql_expression_get_context (TrackerSparqlExpression* self);
TrackerSparqlVariable* tracker_sparql_context_get_variable (TrackerSparqlContext* self, const gchar* name);
GType tracker_sparql_data_binding_get_type (void) G_GNUC_CONST;
GType tracker_sparql_variable_binding_get_type (void) G_GNUC_CONST;
const gchar* tracker_sparql_variable_get_name (TrackerSparqlVariable* self);
GType tracker_sparql_pattern_get_type (void) G_GNUC_CONST;
static TrackerSparqlPattern* tracker_sparql_expression_get_pattern (TrackerSparqlExpression* self);
GType tracker_sparql_select_context_get_type (void) G_GNUC_CONST;
TrackerSparqlSelectContext* tracker_sparql_pattern_translate_select (TrackerSparqlPattern* self, GString* sql, gboolean subquery, gboolean scalar_subquery, GError** error);
GType tracker_sparql_predicate_variable_get_type (void) G_GNUC_CONST;
static void tracker_sparql_expression_convert_expression_to_string (GString* sql, TrackerPropertyType type, glong begin);
const gchar* tracker_sparql_variable_get_sql_expression (TrackerSparqlVariable* self);
TrackerSparqlVariableBinding* tracker_sparql_variable_binding_new (void);
TrackerSparqlVariableBinding* tracker_sparql_variable_binding_construct (GType object_type);
GType tracker_sparql_data_table_get_type (void) G_GNUC_CONST;
void tracker_sparql_data_binding_set_sql_expression (TrackerSparqlDataBinding* self, const gchar* value);
GType tracker_sparql_variable_state_get_type (void) G_GNUC_CONST;
void tracker_sparql_pattern_add_variable_binding (TrackerSparqlPattern* self, GString* sql, TrackerSparqlVariableBinding* binding, TrackerSparqlVariableState variable_state);
static void _vala_array_add1 (gchar*** array, int* length, int* size, gchar* value);
static void _vala_array_add2 (gchar*** array, int* length, int* size, gchar* value);
static void tracker_sparql_expression_translate_expression_as_order_condition (TrackerSparqlExpression* self, GString* sql, GError** error);
void tracker_sparql_expression_translate_order_condition (TrackerSparqlExpression* self, GString* sql, GError** error);
static void tracker_sparql_expression_translate_bound_call (TrackerSparqlExpression* self, GString* sql, GError** error);
static TrackerPropertyType tracker_sparql_expression_translate_if_call (TrackerSparqlExpression* self, GString* sql, GError** error);
static void tracker_sparql_expression_translate_regex (TrackerSparqlExpression* self, GString* sql, GError** error);
static void tracker_sparql_expression_translate_expression_as_string (TrackerSparqlExpression* self, GString* sql, GError** error);
gchar* tracker_sparql_expression_parse_string_literal (TrackerSparqlExpression* self, TrackerPropertyType* type, GError** error);
static void tracker_sparql_expression_translate_exists (TrackerSparqlExpression* self, GString* sql, GError** error);
void tracker_sparql_pattern_translate_exists (TrackerSparqlPattern* self, GString* sql, GError** error);
void tracker_sparql_expression_append_expression_as_string (GString* sql, const gchar* expression, TrackerPropertyType type);
TrackerSparqlLiteralBinding* tracker_sparql_literal_binding_new (void);
TrackerSparqlLiteralBinding* tracker_sparql_literal_binding_construct (GType object_type);
GType tracker_sparql_literal_binding_get_type (void) G_GNUC_CONST;
gchar* tracker_sparql_pattern_parse_var_or_term (TrackerSparqlPattern* self, GString* sql, gboolean* is_var, GError** error);
static TrackerPropertyType tracker_sparql_expression_translate_function (TrackerSparqlExpression* self, GString* sql, const gchar* uri, GError** error);
static void tracker_sparql_expression_translate_str (TrackerSparqlExpression* self, GString* sql, GError** error);
static void tracker_sparql_expression_translate_isuri (TrackerSparqlExpression* self, GString* sql, GError** error);
static void tracker_sparql_expression_translate_datatype (TrackerSparqlExpression* self, GString* sql, GError** error);
gchar* tracker_sparql_variable_get_extra_sql_expression (TrackerSparqlVariable* self, const gchar* suffix);
static TrackerPropertyType tracker_sparql_expression_parse_type_uri (TrackerSparqlExpression* self, GError** error);
gchar* tracker_sparql_query_resolve_prefixed_name (TrackerSparqlQuery* self, const gchar* prefix, const gchar* local_name, GError** error);
static TrackerPropertyType tracker_sparql_expression_translate_uri_expression (TrackerSparqlExpression* self, GString* sql, const gchar* uri, GError** error);
static TrackerPropertyType tracker_sparql_expression_translate_primary_expression (TrackerSparqlExpression* self, GString* sql, GError** error);
static TrackerPropertyType tracker_sparql_expression_translate_bracketted_expression (TrackerSparqlExpression* self, GString* sql, GError** error);
gboolean tracker_sparql_query_get_no_cache (TrackerSparqlQuery* self);
void tracker_sparql_query_set_no_cache (TrackerSparqlQuery* self, gboolean value);
static TrackerPropertyType tracker_sparql_expression_translate_aggregate_expression (TrackerSparqlExpression* self, GString* sql, GError** error);
static TrackerPropertyType tracker_sparql_expression_translate_unary_expression (TrackerSparqlExpression* self, GString* sql, GError** error);
static TrackerPropertyType tracker_sparql_expression_translate_multiplicative_expression (TrackerSparqlExpression* self, GString* sql, GError** error);
static TrackerPropertyType tracker_sparql_expression_translate_additive_expression (TrackerSparqlExpression* self, GString* sql, GError** error);
static TrackerPropertyType tracker_sparql_expression_translate_numeric_expression (TrackerSparqlExpression* self, GString* sql, GError** error);
static TrackerPropertyType tracker_sparql_expression_process_relational_expression (TrackerSparqlExpression* self, GString* sql, glong begin, guint n_bindings, TrackerPropertyType op1type, const gchar* operator, GError** error);
static TrackerPropertyType tracker_sparql_expression_translate_in (TrackerSparqlExpression* self, GString* sql, gboolean not, GError** error);
static TrackerPropertyType tracker_sparql_expression_translate_relational_expression (TrackerSparqlExpression* self, GString* sql, GError** error);
static TrackerPropertyType tracker_sparql_expression_translate_value_logical (TrackerSparqlExpression* self, GString* sql, GError** error);
static TrackerPropertyType tracker_sparql_expression_translate_conditional_and_expression (TrackerSparqlExpression* self, GString* sql, GError** error);
static TrackerPropertyType tracker_sparql_expression_translate_conditional_or_expression (TrackerSparqlExpression* self, GString* sql, GError** error);
TrackerPropertyType tracker_sparql_expression_translate_constraint (TrackerSparqlExpression* self, GString* sql, GError** error);
static void tracker_sparql_expression_finalize (GObject* obj);
static void _vala_tracker_sparql_expression_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);
static gint _vala_array_length (gpointer array);


TrackerSparqlExpression* tracker_sparql_expression_construct (GType object_type, TrackerSparqlQuery* query) {
	TrackerSparqlExpression * self = NULL;
	TrackerSparqlQuery* _tmp0_;
#line 29 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	g_return_val_if_fail (query != NULL, NULL);
#line 29 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	self = (TrackerSparqlExpression*) g_object_new (object_type, NULL);
#line 30 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	_tmp0_ = query;
#line 30 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	self->priv->query = _tmp0_;
#line 29 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	return self;
#line 500 "tracker-sparql-expression.c"
}


TrackerSparqlExpression* tracker_sparql_expression_new (TrackerSparqlQuery* query) {
#line 29 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	return tracker_sparql_expression_construct (TRACKER_SPARQL_TYPE_EXPRESSION, query);
#line 507 "tracker-sparql-expression.c"
}


static inline gboolean tracker_sparql_expression_next (TrackerSparqlExpression* self, GError** error) {
	gboolean result = FALSE;
	TrackerSparqlQuery* _tmp0_;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_;
	GError * _inner_error_ = NULL;
#line 41 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 42 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	_tmp0_ = self->priv->query;
#line 42 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	_tmp1_ = tracker_sparql_query_next (_tmp0_, &_inner_error_);
#line 42 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	_tmp2_ = _tmp1_;
#line 42 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	if (_inner_error_ != NULL) {
#line 42 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 42 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			g_propagate_error (error, _inner_error_);
#line 42 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			return FALSE;
#line 533 "tracker-sparql-expression.c"
		} else {
#line 42 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 42 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			g_clear_error (&_inner_error_);
#line 42 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			return FALSE;
#line 541 "tracker-sparql-expression.c"
		}
	}
#line 42 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	result = _tmp2_;
#line 42 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	return result;
#line 548 "tracker-sparql-expression.c"
}


static inline TrackerSparqlTokenType tracker_sparql_expression_current (TrackerSparqlExpression* self) {
	TrackerSparqlTokenType result = 0;
	TrackerSparqlQuery* _tmp0_;
	TrackerSparqlTokenType _tmp1_ = 0;
#line 45 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	g_return_val_if_fail (self != NULL, 0);
#line 46 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	_tmp0_ = self->priv->query;
#line 46 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	_tmp1_ = tracker_sparql_query_current (_tmp0_);
#line 46 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	result = _tmp1_;
#line 46 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	return result;
#line 566 "tracker-sparql-expression.c"
}


static inline TrackerSparqlTokenType tracker_sparql_expression_last (TrackerSparqlExpression* self) {
	TrackerSparqlTokenType result = 0;
	TrackerSparqlQuery* _tmp0_;
	TrackerSparqlTokenType _tmp1_ = 0;
#line 49 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	g_return_val_if_fail (self != NULL, 0);
#line 50 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	_tmp0_ = self->priv->query;
#line 50 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	_tmp1_ = tracker_sparql_query_last (_tmp0_);
#line 50 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	result = _tmp1_;
#line 50 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	return result;
#line 584 "tracker-sparql-expression.c"
}


static inline gboolean tracker_sparql_expression_accept (TrackerSparqlExpression* self, TrackerSparqlTokenType type, GError** error) {
	gboolean result = FALSE;
	TrackerSparqlQuery* _tmp0_;
	TrackerSparqlTokenType _tmp1_;
	gboolean _tmp2_ = FALSE;
	gboolean _tmp3_;
	GError * _inner_error_ = NULL;
#line 53 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 54 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	_tmp0_ = self->priv->query;
#line 54 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	_tmp1_ = type;
#line 54 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	_tmp2_ = tracker_sparql_query_accept (_tmp0_, _tmp1_, &_inner_error_);
#line 54 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	_tmp3_ = _tmp2_;
#line 54 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	if (_inner_error_ != NULL) {
#line 54 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 54 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			g_propagate_error (error, _inner_error_);
#line 54 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			return FALSE;
#line 613 "tracker-sparql-expression.c"
		} else {
#line 54 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 54 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			g_clear_error (&_inner_error_);
#line 54 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			return FALSE;
#line 621 "tracker-sparql-expression.c"
		}
	}
#line 54 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	result = _tmp3_;
#line 54 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	return result;
#line 628 "tracker-sparql-expression.c"
}


static GError* tracker_sparql_expression_get_error (TrackerSparqlExpression* self, const gchar* msg) {
	GError* result = NULL;
	TrackerSparqlQuery* _tmp0_;
	const gchar* _tmp1_;
	GError* _tmp2_ = NULL;
#line 57 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 57 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	g_return_val_if_fail (msg != NULL, NULL);
#line 58 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	_tmp0_ = self->priv->query;
#line 58 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	_tmp1_ = msg;
#line 58 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	_tmp2_ = tracker_sparql_query_get_error (_tmp0_, _tmp1_);
#line 58 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	result = _tmp2_;
#line 58 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	return result;
#line 651 "tracker-sparql-expression.c"
}


static gboolean tracker_sparql_expression_expect (TrackerSparqlExpression* self, TrackerSparqlTokenType type, GError** error) {
	gboolean result = FALSE;
	TrackerSparqlQuery* _tmp0_;
	TrackerSparqlTokenType _tmp1_;
	gboolean _tmp2_ = FALSE;
	gboolean _tmp3_;
	GError * _inner_error_ = NULL;
#line 61 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 62 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	_tmp0_ = self->priv->query;
#line 62 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	_tmp1_ = type;
#line 62 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	_tmp2_ = tracker_sparql_query_expect (_tmp0_, _tmp1_, &_inner_error_);
#line 62 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	_tmp3_ = _tmp2_;
#line 62 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	if (_inner_error_ != NULL) {
#line 62 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 62 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			g_propagate_error (error, _inner_error_);
#line 62 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			return FALSE;
#line 680 "tracker-sparql-expression.c"
		} else {
#line 62 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 62 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			g_clear_error (&_inner_error_);
#line 62 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			return FALSE;
#line 688 "tracker-sparql-expression.c"
		}
	}
#line 62 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	result = _tmp3_;
#line 62 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	return result;
#line 695 "tracker-sparql-expression.c"
}


static gchar* tracker_sparql_expression_get_last_string (TrackerSparqlExpression* self, gint strip) {
	gchar* result = NULL;
	TrackerSparqlQuery* _tmp0_;
	gint _tmp1_;
	gchar* _tmp2_ = NULL;
#line 65 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 66 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	_tmp0_ = self->priv->query;
#line 66 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	_tmp1_ = strip;
#line 66 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	_tmp2_ = tracker_sparql_query_get_last_string (_tmp0_, _tmp1_);
#line 66 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	result = _tmp2_;
#line 66 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	return result;
#line 716 "tracker-sparql-expression.c"
}


static gchar* tracker_sparql_expression_escape_sql_string_literal (TrackerSparqlExpression* self, const gchar* literal) {
	gchar* result = NULL;
	const gchar* _tmp0_;
	gchar** _tmp1_;
	gchar** _tmp2_ = NULL;
	gchar** _tmp3_;
	gint _tmp3__length1;
	gchar* _tmp4_ = NULL;
	gchar* _tmp5_;
	gchar* _tmp6_ = NULL;
	gchar* _tmp7_;
#line 69 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 69 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	g_return_val_if_fail (literal != NULL, NULL);
#line 70 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	_tmp0_ = literal;
#line 70 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	_tmp2_ = _tmp1_ = g_strsplit (_tmp0_, "'", 0);
#line 70 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	_tmp3_ = _tmp2_;
#line 70 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	_tmp3__length1 = _vala_array_length (_tmp1_);
#line 70 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	_tmp4_ = g_strjoinv ("''", _tmp3_);
#line 70 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	_tmp5_ = _tmp4_;
#line 70 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	_tmp6_ = g_strdup_printf ("'%s'", _tmp5_);
#line 70 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	_tmp7_ = _tmp6_;
#line 70 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	_g_free0 (_tmp5_);
#line 70 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	_tmp3_ = (_vala_array_free (_tmp3_, _tmp3__length1, (GDestroyNotify) g_free), NULL);
#line 70 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	result = _tmp7_;
#line 70 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	return result;
#line 759 "tracker-sparql-expression.c"
}


static gboolean tracker_sparql_expression_maybe_numeric (TrackerSparqlExpression* self, TrackerPropertyType type) {
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_ = FALSE;
	gboolean _tmp3_ = FALSE;
	TrackerPropertyType _tmp4_;
	gboolean _tmp6_;
	gboolean _tmp8_;
	gboolean _tmp10_;
	gboolean _tmp12_;
#line 73 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 74 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	_tmp4_ = type;
#line 74 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	if (_tmp4_ == TRACKER_PROPERTY_TYPE_INTEGER) {
#line 74 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		_tmp3_ = TRUE;
#line 782 "tracker-sparql-expression.c"
	} else {
		TrackerPropertyType _tmp5_;
#line 74 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		_tmp5_ = type;
#line 74 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		_tmp3_ = _tmp5_ == TRACKER_PROPERTY_TYPE_DOUBLE;
#line 789 "tracker-sparql-expression.c"
	}
#line 74 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	_tmp6_ = _tmp3_;
#line 74 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	if (_tmp6_) {
#line 74 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		_tmp2_ = TRUE;
#line 797 "tracker-sparql-expression.c"
	} else {
		TrackerPropertyType _tmp7_;
#line 74 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		_tmp7_ = type;
#line 74 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		_tmp2_ = _tmp7_ == TRACKER_PROPERTY_TYPE_DATE;
#line 804 "tracker-sparql-expression.c"
	}
#line 74 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	_tmp8_ = _tmp2_;
#line 74 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	if (_tmp8_) {
#line 74 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		_tmp1_ = TRUE;
#line 812 "tracker-sparql-expression.c"
	} else {
		TrackerPropertyType _tmp9_;
#line 74 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		_tmp9_ = type;
#line 74 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		_tmp1_ = _tmp9_ == TRACKER_PROPERTY_TYPE_DATETIME;
#line 819 "tracker-sparql-expression.c"
	}
#line 74 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	_tmp10_ = _tmp1_;
#line 74 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	if (_tmp10_) {
#line 74 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		_tmp0_ = TRUE;
#line 827 "tracker-sparql-expression.c"
	} else {
		TrackerPropertyType _tmp11_;
#line 74 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		_tmp11_ = type;
#line 74 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		_tmp0_ = _tmp11_ == TRACKER_PROPERTY_TYPE_UNKNOWN;
#line 834 "tracker-sparql-expression.c"
	}
#line 74 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	_tmp12_ = _tmp0_;
#line 74 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	result = _tmp12_;
#line 74 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	return result;
#line 842 "tracker-sparql-expression.c"
}


static void tracker_sparql_expression_append_collate (TrackerSparqlExpression* self, GString* sql) {
	GString* _tmp0_;
#line 77 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	g_return_if_fail (self != NULL);
#line 77 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	g_return_if_fail (sql != NULL);
#line 78 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	_tmp0_ = sql;
#line 78 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	g_string_append_printf (_tmp0_, " COLLATE %s", TRACKER_COLLATION_NAME);
#line 856 "tracker-sparql-expression.c"
}


static void tracker_sparql_expression_skip_bracketted_expression (TrackerSparqlExpression* self, GError** error) {
	GError * _inner_error_ = NULL;
#line 81 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	g_return_if_fail (self != NULL);
#line 82 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	tracker_sparql_expression_expect (self, TRACKER_SPARQL_TOKEN_TYPE_OPEN_PARENS, &_inner_error_);
#line 82 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	if (_inner_error_ != NULL) {
#line 82 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 82 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			g_propagate_error (error, _inner_error_);
#line 82 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			return;
#line 874 "tracker-sparql-expression.c"
		} else {
#line 82 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 82 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			g_clear_error (&_inner_error_);
#line 82 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			return;
#line 882 "tracker-sparql-expression.c"
		}
	}
#line 83 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	while (TRUE) {
#line 887 "tracker-sparql-expression.c"
		TrackerSparqlTokenType _tmp0_ = 0;
#line 84 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		_tmp0_ = tracker_sparql_expression_current (self);
#line 84 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		switch (_tmp0_) {
#line 84 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			case TRACKER_SPARQL_TOKEN_TYPE_OPEN_PARENS:
#line 895 "tracker-sparql-expression.c"
			{
#line 87 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				tracker_sparql_expression_skip_bracketted_expression (self, &_inner_error_);
#line 87 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				if (_inner_error_ != NULL) {
#line 87 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 87 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
						g_propagate_error (error, _inner_error_);
#line 87 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
						return;
#line 907 "tracker-sparql-expression.c"
					} else {
#line 87 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 87 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
						g_clear_error (&_inner_error_);
#line 87 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
						return;
#line 915 "tracker-sparql-expression.c"
					}
				}
#line 88 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				continue;
#line 920 "tracker-sparql-expression.c"
			}
#line 84 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			case TRACKER_SPARQL_TOKEN_TYPE_CLOSE_PARENS:
#line 84 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			case TRACKER_SPARQL_TOKEN_TYPE_EOF:
#line 926 "tracker-sparql-expression.c"
			{
#line 91 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				break;
#line 930 "tracker-sparql-expression.c"
			}
			default:
			{
#line 93 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				tracker_sparql_expression_next (self, &_inner_error_);
#line 93 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				if (_inner_error_ != NULL) {
#line 93 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 93 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
						g_propagate_error (error, _inner_error_);
#line 93 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
						return;
#line 944 "tracker-sparql-expression.c"
					} else {
#line 93 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 93 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
						g_clear_error (&_inner_error_);
#line 93 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
						return;
#line 952 "tracker-sparql-expression.c"
					}
				}
#line 94 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				continue;
#line 957 "tracker-sparql-expression.c"
			}
		}
#line 96 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		break;
#line 962 "tracker-sparql-expression.c"
	}
#line 98 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	tracker_sparql_expression_expect (self, TRACKER_SPARQL_TOKEN_TYPE_CLOSE_PARENS, &_inner_error_);
#line 98 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	if (_inner_error_ != NULL) {
#line 98 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 98 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			g_propagate_error (error, _inner_error_);
#line 98 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			return;
#line 974 "tracker-sparql-expression.c"
		} else {
#line 98 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 98 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			g_clear_error (&_inner_error_);
#line 98 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			return;
#line 982 "tracker-sparql-expression.c"
		}
	}
}


void tracker_sparql_expression_skip_select_variables (TrackerSparqlExpression* self, GError** error) {
	GError * _inner_error_ = NULL;
#line 101 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	g_return_if_fail (self != NULL);
#line 102 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	while (TRUE) {
#line 994 "tracker-sparql-expression.c"
		TrackerSparqlTokenType _tmp0_ = 0;
#line 103 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		_tmp0_ = tracker_sparql_expression_current (self);
#line 103 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		switch (_tmp0_) {
#line 103 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			case TRACKER_SPARQL_TOKEN_TYPE_OPEN_PARENS:
#line 1002 "tracker-sparql-expression.c"
			{
#line 105 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				tracker_sparql_expression_skip_bracketted_expression (self, &_inner_error_);
#line 105 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				if (_inner_error_ != NULL) {
#line 105 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 105 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
						g_propagate_error (error, _inner_error_);
#line 105 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
						return;
#line 1014 "tracker-sparql-expression.c"
					} else {
#line 105 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 105 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
						g_clear_error (&_inner_error_);
#line 105 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
						return;
#line 1022 "tracker-sparql-expression.c"
					}
				}
#line 106 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				continue;
#line 1027 "tracker-sparql-expression.c"
			}
#line 103 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			case TRACKER_SPARQL_TOKEN_TYPE_FROM:
#line 103 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			case TRACKER_SPARQL_TOKEN_TYPE_WHERE:
#line 103 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			case TRACKER_SPARQL_TOKEN_TYPE_OPEN_BRACE:
#line 103 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			case TRACKER_SPARQL_TOKEN_TYPE_GROUP:
#line 103 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			case TRACKER_SPARQL_TOKEN_TYPE_ORDER:
#line 103 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			case TRACKER_SPARQL_TOKEN_TYPE_LIMIT:
#line 103 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			case TRACKER_SPARQL_TOKEN_TYPE_OFFSET:
#line 103 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			case TRACKER_SPARQL_TOKEN_TYPE_EOF:
#line 1045 "tracker-sparql-expression.c"
			{
#line 115 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				break;
#line 1049 "tracker-sparql-expression.c"
			}
			default:
			{
#line 117 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				tracker_sparql_expression_next (self, &_inner_error_);
#line 117 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				if (_inner_error_ != NULL) {
#line 117 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 117 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
						g_propagate_error (error, _inner_error_);
#line 117 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
						return;
#line 1063 "tracker-sparql-expression.c"
					} else {
#line 117 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 117 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
						g_clear_error (&_inner_error_);
#line 117 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
						return;
#line 1071 "tracker-sparql-expression.c"
					}
				}
#line 118 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				continue;
#line 1076 "tracker-sparql-expression.c"
			}
		}
#line 120 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		break;
#line 1081 "tracker-sparql-expression.c"
	}
}


static glong string_strnlen (gchar* str, glong maxlen) {
	glong result = 0L;
	gchar* _tmp0_;
	glong _tmp1_;
	gchar* _tmp2_ = NULL;
	gchar* end;
	gchar* _tmp3_;
#line 1301 "/usr/share/vala-0.14/vapi/glib-2.0.vapi"
	_tmp0_ = str;
#line 1301 "/usr/share/vala-0.14/vapi/glib-2.0.vapi"
	_tmp1_ = maxlen;
#line 1301 "/usr/share/vala-0.14/vapi/glib-2.0.vapi"
	_tmp2_ = memchr (_tmp0_, 0, (gsize) _tmp1_);
#line 1301 "/usr/share/vala-0.14/vapi/glib-2.0.vapi"
	end = _tmp2_;
#line 1302 "/usr/share/vala-0.14/vapi/glib-2.0.vapi"
	_tmp3_ = end;
#line 1302 "/usr/share/vala-0.14/vapi/glib-2.0.vapi"
	if (_tmp3_ == NULL) {
#line 1105 "tracker-sparql-expression.c"
		glong _tmp4_;
#line 1303 "/usr/share/vala-0.14/vapi/glib-2.0.vapi"
		_tmp4_ = maxlen;
#line 1303 "/usr/share/vala-0.14/vapi/glib-2.0.vapi"
		result = _tmp4_;
#line 1303 "/usr/share/vala-0.14/vapi/glib-2.0.vapi"
		return result;
#line 1113 "tracker-sparql-expression.c"
	} else {
		gchar* _tmp5_;
		gchar* _tmp6_;
#line 1305 "/usr/share/vala-0.14/vapi/glib-2.0.vapi"
		_tmp5_ = end;
#line 1305 "/usr/share/vala-0.14/vapi/glib-2.0.vapi"
		_tmp6_ = str;
#line 1305 "/usr/share/vala-0.14/vapi/glib-2.0.vapi"
		result = (glong) (_tmp5_ - _tmp6_);
#line 1305 "/usr/share/vala-0.14/vapi/glib-2.0.vapi"
		return result;
#line 1125 "tracker-sparql-expression.c"
	}
}


static gchar* string_substring (const gchar* self, glong offset, glong len) {
	gchar* result = NULL;
	glong string_length = 0L;
	gboolean _tmp0_ = FALSE;
	glong _tmp1_;
	gboolean _tmp3_;
	glong _tmp9_;
	glong _tmp15_;
	glong _tmp18_;
	glong _tmp19_;
	glong _tmp20_;
	glong _tmp21_;
	glong _tmp22_;
	gchar* _tmp23_ = NULL;
#line 1312 "/usr/share/vala-0.14/vapi/glib-2.0.vapi"
	g_return_val_if_fail (self != NULL, NULL);
#line 1314 "/usr/share/vala-0.14/vapi/glib-2.0.vapi"
	_tmp1_ = offset;
#line 1314 "/usr/share/vala-0.14/vapi/glib-2.0.vapi"
	if (_tmp1_ >= ((glong) 0)) {
#line 1150 "tracker-sparql-expression.c"
		glong _tmp2_;
#line 1314 "/usr/share/vala-0.14/vapi/glib-2.0.vapi"
		_tmp2_ = len;
#line 1314 "/usr/share/vala-0.14/vapi/glib-2.0.vapi"
		_tmp0_ = _tmp2_ >= ((glong) 0);
#line 1156 "tracker-sparql-expression.c"
	} else {
#line 1314 "/usr/share/vala-0.14/vapi/glib-2.0.vapi"
		_tmp0_ = FALSE;
#line 1160 "tracker-sparql-expression.c"
	}
#line 1314 "/usr/share/vala-0.14/vapi/glib-2.0.vapi"
	_tmp3_ = _tmp0_;
#line 1314 "/usr/share/vala-0.14/vapi/glib-2.0.vapi"
	if (_tmp3_) {
#line 1166 "tracker-sparql-expression.c"
		glong _tmp4_;
		glong _tmp5_;
		glong _tmp6_ = 0L;
#line 1316 "/usr/share/vala-0.14/vapi/glib-2.0.vapi"
		_tmp4_ = offset;
#line 1316 "/usr/share/vala-0.14/vapi/glib-2.0.vapi"
		_tmp5_ = len;
#line 1316 "/usr/share/vala-0.14/vapi/glib-2.0.vapi"
		_tmp6_ = string_strnlen ((gchar*) self, _tmp4_ + _tmp5_);
#line 1316 "/usr/share/vala-0.14/vapi/glib-2.0.vapi"
		string_length = _tmp6_;
#line 1178 "tracker-sparql-expression.c"
	} else {
		gint _tmp7_;
		gint _tmp8_;
#line 1318 "/usr/share/vala-0.14/vapi/glib-2.0.vapi"
		_tmp7_ = strlen (self);
#line 1318 "/usr/share/vala-0.14/vapi/glib-2.0.vapi"
		_tmp8_ = _tmp7_;
#line 1318 "/usr/share/vala-0.14/vapi/glib-2.0.vapi"
		string_length = (glong) _tmp8_;
#line 1188 "tracker-sparql-expression.c"
	}
#line 1321 "/usr/share/vala-0.14/vapi/glib-2.0.vapi"
	_tmp9_ = offset;
#line 1321 "/usr/share/vala-0.14/vapi/glib-2.0.vapi"
	if (_tmp9_ < ((glong) 0)) {
#line 1194 "tracker-sparql-expression.c"
		glong _tmp10_;
		glong _tmp11_;
		glong _tmp12_;
#line 1322 "/usr/share/vala-0.14/vapi/glib-2.0.vapi"
		_tmp10_ = string_length;
#line 1322 "/usr/share/vala-0.14/vapi/glib-2.0.vapi"
		_tmp11_ = offset;
#line 1322 "/usr/share/vala-0.14/vapi/glib-2.0.vapi"
		offset = _tmp10_ + _tmp11_;
#line 1323 "/usr/share/vala-0.14/vapi/glib-2.0.vapi"
		_tmp12_ = offset;
#line 1323 "/usr/share/vala-0.14/vapi/glib-2.0.vapi"
		g_return_val_if_fail (_tmp12_ >= ((glong) 0), NULL);
#line 1208 "tracker-sparql-expression.c"
	} else {
		glong _tmp13_;
		glong _tmp14_;
#line 1325 "/usr/share/vala-0.14/vapi/glib-2.0.vapi"
		_tmp13_ = offset;
#line 1325 "/usr/share/vala-0.14/vapi/glib-2.0.vapi"
		_tmp14_ = string_length;
#line 1325 "/usr/share/vala-0.14/vapi/glib-2.0.vapi"
		g_return_val_if_fail (_tmp13_ <= _tmp14_, NULL);
#line 1218 "tracker-sparql-expression.c"
	}
#line 1327 "/usr/share/vala-0.14/vapi/glib-2.0.vapi"
	_tmp15_ = len;
#line 1327 "/usr/share/vala-0.14/vapi/glib-2.0.vapi"
	if (_tmp15_ < ((glong) 0)) {
#line 1224 "tracker-sparql-expression.c"
		glong _tmp16_;
		glong _tmp17_;
#line 1328 "/usr/share/vala-0.14/vapi/glib-2.0.vapi"
		_tmp16_ = string_length;
#line 1328 "/usr/share/vala-0.14/vapi/glib-2.0.vapi"
		_tmp17_ = offset;
#line 1328 "/usr/share/vala-0.14/vapi/glib-2.0.vapi"
		len = _tmp16_ - _tmp17_;
#line 1233 "tracker-sparql-expression.c"
	}
#line 1330 "/usr/share/vala-0.14/vapi/glib-2.0.vapi"
	_tmp18_ = offset;
#line 1330 "/usr/share/vala-0.14/vapi/glib-2.0.vapi"
	_tmp19_ = len;
#line 1330 "/usr/share/vala-0.14/vapi/glib-2.0.vapi"
	_tmp20_ = string_length;
#line 1330 "/usr/share/vala-0.14/vapi/glib-2.0.vapi"
	g_return_val_if_fail ((_tmp18_ + _tmp19_) <= _tmp20_, NULL);
#line 1331 "/usr/share/vala-0.14/vapi/glib-2.0.vapi"
	_tmp21_ = offset;
#line 1331 "/usr/share/vala-0.14/vapi/glib-2.0.vapi"
	_tmp22_ = len;
#line 1331 "/usr/share/vala-0.14/vapi/glib-2.0.vapi"
	_tmp23_ = g_strndup (((gchar*) self) + _tmp21_, (gsize) _tmp22_);
#line 1331 "/usr/share/vala-0.14/vapi/glib-2.0.vapi"
	result = _tmp23_;
#line 1331 "/usr/share/vala-0.14/vapi/glib-2.0.vapi"
	return result;
#line 1253 "tracker-sparql-expression.c"
}


static gpointer _g_object_ref0 (gpointer self) {
#line 133 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	return self ? g_object_ref (self) : NULL;
#line 1260 "tracker-sparql-expression.c"
}


static void _vala_array_add1 (gchar*** array, int* length, int* size, gchar* value) {
#line 202 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	if ((*length) == (*size)) {
#line 202 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		*size = (*size) ? (2 * (*size)) : 4;
#line 202 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		*array = g_renew (gchar*, *array, (*size) + 1);
#line 1271 "tracker-sparql-expression.c"
	}
#line 202 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	(*array)[(*length)++] = value;
#line 202 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	(*array)[*length] = NULL;
#line 1277 "tracker-sparql-expression.c"
}


static void _vala_array_add2 (gchar*** array, int* length, int* size, gchar* value) {
#line 204 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	if ((*length) == (*size)) {
#line 204 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		*size = (*size) ? (2 * (*size)) : 4;
#line 204 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		*array = g_renew (gchar*, *array, (*size) + 1);
#line 1288 "tracker-sparql-expression.c"
	}
#line 204 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	(*array)[(*length)++] = value;
#line 204 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	(*array)[*length] = NULL;
#line 1294 "tracker-sparql-expression.c"
}


TrackerPropertyType tracker_sparql_expression_translate_select_expression (TrackerSparqlExpression* self, GString* sql, gboolean subquery, gint variable_index, GError** error) {
	TrackerPropertyType result = 0;
	TrackerSparqlVariable* variable;
	gboolean expect_close_parens;
	GString* _tmp0_;
	gssize _tmp1_;
	glong begin;
	TrackerPropertyType type;
	TrackerSparqlTokenType _tmp2_ = 0;
	gboolean _tmp42_;
	gboolean _tmp46_ = FALSE;
	gboolean _tmp47_;
	gboolean _tmp83_;
	TrackerSparqlVariable* _tmp84_;
	GError * _inner_error_ = NULL;
#line 124 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	g_return_val_if_fail (self != NULL, 0);
#line 124 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	g_return_val_if_fail (sql != NULL, 0);
#line 125 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	variable = NULL;
#line 126 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	expect_close_parens = FALSE;
#line 128 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	_tmp0_ = sql;
#line 128 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	_tmp1_ = _tmp0_->len;
#line 128 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	begin = (glong) _tmp1_;
#line 129 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	type = TRACKER_PROPERTY_TYPE_UNKNOWN;
#line 130 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	_tmp2_ = tracker_sparql_expression_current (self);
#line 130 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	if (_tmp2_ == TRACKER_SPARQL_TOKEN_TYPE_VAR) {
#line 1333 "tracker-sparql-expression.c"
		GString* _tmp3_;
		TrackerPropertyType _tmp4_ = 0;
		TrackerPropertyType _tmp5_;
		TrackerSparqlContext* _tmp6_;
		TrackerSparqlContext* _tmp7_;
		gchar* _tmp8_ = NULL;
		gchar* _tmp9_;
		gchar* _tmp10_ = NULL;
		gchar* _tmp11_;
		TrackerSparqlVariable* _tmp12_ = NULL;
		TrackerSparqlVariable* _tmp13_;
		TrackerSparqlVariable* _tmp14_;
		TrackerSparqlVariableBinding* _tmp15_;
#line 131 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		_tmp3_ = sql;
#line 131 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		_tmp4_ = tracker_sparql_expression_translate_expression (self, _tmp3_, &_inner_error_);
#line 131 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		_tmp5_ = _tmp4_;
#line 131 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		if (_inner_error_ != NULL) {
#line 131 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 131 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				g_propagate_error (error, _inner_error_);
#line 131 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				_g_object_unref0 (variable);
#line 131 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				return 0;
#line 1363 "tracker-sparql-expression.c"
			} else {
#line 131 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				_g_object_unref0 (variable);
#line 131 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 131 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				g_clear_error (&_inner_error_);
#line 131 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				return 0;
#line 1373 "tracker-sparql-expression.c"
			}
		}
#line 131 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		type = _tmp5_;
#line 133 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		_tmp6_ = tracker_sparql_expression_get_context (self);
#line 133 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		_tmp7_ = _tmp6_;
#line 133 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		_tmp8_ = tracker_sparql_expression_get_last_string (self, 0);
#line 133 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		_tmp9_ = _tmp8_;
#line 133 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		_tmp10_ = string_substring (_tmp9_, (glong) 1, (glong) (-1));
#line 133 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		_tmp11_ = _tmp10_;
#line 133 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		_tmp12_ = tracker_sparql_context_get_variable (_tmp7_, _tmp11_);
#line 133 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		_tmp13_ = _g_object_ref0 (_tmp12_);
#line 133 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		_g_object_unref0 (variable);
#line 133 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		variable = _tmp13_;
#line 133 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		_g_free0 (_tmp11_);
#line 133 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		_g_free0 (_tmp9_);
#line 135 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		_tmp14_ = variable;
#line 135 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		_tmp15_ = _tmp14_->binding;
#line 135 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		if (_tmp15_ == NULL) {
#line 1408 "tracker-sparql-expression.c"
			TrackerSparqlVariable* _tmp16_;
			const gchar* _tmp17_;
			const gchar* _tmp18_;
			gchar* _tmp19_ = NULL;
			gchar* _tmp20_;
			GError* _tmp21_ = NULL;
			GError* _tmp22_;
#line 136 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp16_ = variable;
#line 136 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp17_ = tracker_sparql_variable_get_name (_tmp16_);
#line 136 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp18_ = _tmp17_;
#line 136 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp19_ = g_strdup_printf ("use of undefined variable `%s'", _tmp18_);
#line 136 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp20_ = _tmp19_;
#line 136 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp21_ = tracker_sparql_expression_get_error (self, _tmp20_);
#line 136 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp22_ = _tmp21_;
#line 136 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_g_free0 (_tmp20_);
#line 136 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_inner_error_ = _tmp22_;
#line 136 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 136 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				g_propagate_error (error, _inner_error_);
#line 136 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				_g_object_unref0 (variable);
#line 136 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				return 0;
#line 1442 "tracker-sparql-expression.c"
			} else {
#line 136 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				_g_object_unref0 (variable);
#line 136 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 136 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				g_clear_error (&_inner_error_);
#line 136 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				return 0;
#line 1452 "tracker-sparql-expression.c"
			}
		}
	} else {
		gboolean _tmp23_ = FALSE;
		gboolean _tmp24_;
#line 138 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		_tmp23_ = tracker_sparql_expression_accept (self, TRACKER_SPARQL_TOKEN_TYPE_OPEN_PARENS, &_inner_error_);
#line 138 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		_tmp24_ = _tmp23_;
#line 138 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		if (_inner_error_ != NULL) {
#line 138 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 138 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				g_propagate_error (error, _inner_error_);
#line 138 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				_g_object_unref0 (variable);
#line 138 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				return 0;
#line 1472 "tracker-sparql-expression.c"
			} else {
#line 138 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				_g_object_unref0 (variable);
#line 138 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 138 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				g_clear_error (&_inner_error_);
#line 138 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				return 0;
#line 1482 "tracker-sparql-expression.c"
			}
		}
#line 138 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		if (_tmp24_) {
#line 1487 "tracker-sparql-expression.c"
			TrackerSparqlTokenType _tmp25_ = 0;
#line 139 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp25_ = tracker_sparql_expression_current (self);
#line 139 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			if (_tmp25_ == TRACKER_SPARQL_TOKEN_TYPE_SELECT) {
#line 1493 "tracker-sparql-expression.c"
				GString* _tmp26_;
				TrackerSparqlPattern* _tmp27_;
				TrackerSparqlPattern* _tmp28_;
				GString* _tmp29_;
				TrackerSparqlSelectContext* _tmp30_ = NULL;
				TrackerSparqlSelectContext* select_context;
				GString* _tmp31_;
				TrackerSparqlSelectContext* _tmp32_;
				TrackerPropertyType _tmp33_;
#line 142 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				_tmp26_ = sql;
#line 142 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				g_string_append (_tmp26_, "(");
#line 143 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				_tmp27_ = tracker_sparql_expression_get_pattern (self);
#line 143 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				_tmp28_ = _tmp27_;
#line 143 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				_tmp29_ = sql;
#line 143 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				_tmp30_ = tracker_sparql_pattern_translate_select (_tmp28_, _tmp29_, TRUE, TRUE, &_inner_error_);
#line 143 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				select_context = _tmp30_;
#line 143 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				if (_inner_error_ != NULL) {
#line 143 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 143 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
						g_propagate_error (error, _inner_error_);
#line 143 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
						_g_object_unref0 (variable);
#line 143 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
						return 0;
#line 1527 "tracker-sparql-expression.c"
					} else {
#line 143 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
						_g_object_unref0 (variable);
#line 143 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 143 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
						g_clear_error (&_inner_error_);
#line 143 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
						return 0;
#line 1537 "tracker-sparql-expression.c"
					}
				}
#line 144 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				_tmp31_ = sql;
#line 144 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				g_string_append (_tmp31_, ")");
#line 146 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				tracker_sparql_expression_expect (self, TRACKER_SPARQL_TOKEN_TYPE_CLOSE_PARENS, &_inner_error_);
#line 146 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				if (_inner_error_ != NULL) {
#line 146 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 146 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
						g_propagate_error (error, _inner_error_);
#line 146 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
						_tracker_sparql_context_unref0 (select_context);
#line 146 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
						_g_object_unref0 (variable);
#line 146 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
						return 0;
#line 1558 "tracker-sparql-expression.c"
					} else {
#line 146 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
						_tracker_sparql_context_unref0 (select_context);
#line 146 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
						_g_object_unref0 (variable);
#line 146 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 146 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
						g_clear_error (&_inner_error_);
#line 146 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
						return 0;
#line 1570 "tracker-sparql-expression.c"
					}
				}
#line 147 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				_tmp32_ = select_context;
#line 147 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				_tmp33_ = _tmp32_->type;
#line 147 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				type = _tmp33_;
#line 139 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				_tracker_sparql_context_unref0 (select_context);
#line 1581 "tracker-sparql-expression.c"
			} else {
				GString* _tmp34_;
				TrackerPropertyType _tmp35_ = 0;
				TrackerPropertyType _tmp36_;
				gboolean _tmp37_ = FALSE;
				gboolean _tmp38_;
#line 149 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				_tmp34_ = sql;
#line 149 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				_tmp35_ = tracker_sparql_expression_translate_expression (self, _tmp34_, &_inner_error_);
#line 149 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				_tmp36_ = _tmp35_;
#line 149 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				if (_inner_error_ != NULL) {
#line 149 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 149 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
						g_propagate_error (error, _inner_error_);
#line 149 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
						_g_object_unref0 (variable);
#line 149 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
						return 0;
#line 1604 "tracker-sparql-expression.c"
					} else {
#line 149 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
						_g_object_unref0 (variable);
#line 149 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 149 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
						g_clear_error (&_inner_error_);
#line 149 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
						return 0;
#line 1614 "tracker-sparql-expression.c"
					}
				}
#line 149 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				type = _tmp36_;
#line 150 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				_tmp37_ = tracker_sparql_expression_accept (self, TRACKER_SPARQL_TOKEN_TYPE_CLOSE_PARENS, &_inner_error_);
#line 150 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				_tmp38_ = _tmp37_;
#line 150 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				if (_inner_error_ != NULL) {
#line 150 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 150 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
						g_propagate_error (error, _inner_error_);
#line 150 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
						_g_object_unref0 (variable);
#line 150 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
						return 0;
#line 1633 "tracker-sparql-expression.c"
					} else {
#line 150 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
						_g_object_unref0 (variable);
#line 150 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 150 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
						g_clear_error (&_inner_error_);
#line 150 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
						return 0;
#line 1643 "tracker-sparql-expression.c"
					}
				}
#line 150 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				if (_tmp38_) {
#line 1648 "tracker-sparql-expression.c"
				} else {
#line 156 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					expect_close_parens = TRUE;
#line 1652 "tracker-sparql-expression.c"
				}
			}
		} else {
			GString* _tmp39_;
			TrackerPropertyType _tmp40_ = 0;
			TrackerPropertyType _tmp41_;
#line 162 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp39_ = sql;
#line 162 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp40_ = tracker_sparql_expression_translate_expression (self, _tmp39_, &_inner_error_);
#line 162 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp41_ = _tmp40_;
#line 162 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			if (_inner_error_ != NULL) {
#line 162 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 162 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_propagate_error (error, _inner_error_);
#line 162 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					_g_object_unref0 (variable);
#line 162 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					return 0;
#line 1675 "tracker-sparql-expression.c"
				} else {
#line 162 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					_g_object_unref0 (variable);
#line 162 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 162 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_clear_error (&_inner_error_);
#line 162 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					return 0;
#line 1685 "tracker-sparql-expression.c"
				}
			}
#line 162 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			type = _tmp41_;
#line 1690 "tracker-sparql-expression.c"
		}
	}
#line 165 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	_tmp42_ = subquery;
#line 165 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	if (!_tmp42_) {
#line 1697 "tracker-sparql-expression.c"
		GString* _tmp43_;
		TrackerPropertyType _tmp44_;
		glong _tmp45_;
#line 166 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		_tmp43_ = sql;
#line 166 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		_tmp44_ = type;
#line 166 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		_tmp45_ = begin;
#line 166 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		tracker_sparql_expression_convert_expression_to_string (_tmp43_, _tmp44_, _tmp45_);
#line 1709 "tracker-sparql-expression.c"
	}
#line 169 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	_tmp46_ = tracker_sparql_expression_accept (self, TRACKER_SPARQL_TOKEN_TYPE_AS, &_inner_error_);
#line 169 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	_tmp47_ = _tmp46_;
#line 169 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	if (_inner_error_ != NULL) {
#line 169 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 169 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			g_propagate_error (error, _inner_error_);
#line 169 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_g_object_unref0 (variable);
#line 169 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			return 0;
#line 1725 "tracker-sparql-expression.c"
		} else {
#line 169 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_g_object_unref0 (variable);
#line 169 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 169 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			g_clear_error (&_inner_error_);
#line 169 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			return 0;
#line 1735 "tracker-sparql-expression.c"
		}
	}
#line 169 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	if (_tmp47_) {
#line 1740 "tracker-sparql-expression.c"
		gboolean _tmp48_ = FALSE;
		gboolean _tmp49_;
		GString* _tmp64_;
		TrackerSparqlVariable* _tmp65_;
		const gchar* _tmp66_;
		const gchar* _tmp67_;
		gboolean _tmp68_;
#line 170 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		_tmp48_ = tracker_sparql_expression_accept (self, TRACKER_SPARQL_TOKEN_TYPE_PN_PREFIX, &_inner_error_);
#line 170 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		_tmp49_ = _tmp48_;
#line 170 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		if (_inner_error_ != NULL) {
#line 170 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 170 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				g_propagate_error (error, _inner_error_);
#line 170 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				_g_object_unref0 (variable);
#line 170 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				return 0;
#line 1762 "tracker-sparql-expression.c"
			} else {
#line 170 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				_g_object_unref0 (variable);
#line 170 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 170 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				g_clear_error (&_inner_error_);
#line 170 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				return 0;
#line 1772 "tracker-sparql-expression.c"
			}
		}
#line 170 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		if (_tmp49_) {
#line 1777 "tracker-sparql-expression.c"
			TrackerSparqlContext* _tmp50_;
			TrackerSparqlContext* _tmp51_;
			gchar* _tmp52_ = NULL;
			gchar* _tmp53_;
			TrackerSparqlVariable* _tmp54_ = NULL;
			TrackerSparqlVariable* _tmp55_;
#line 173 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp50_ = tracker_sparql_expression_get_context (self);
#line 173 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp51_ = _tmp50_;
#line 173 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp52_ = tracker_sparql_expression_get_last_string (self, 0);
#line 173 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp53_ = _tmp52_;
#line 173 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp54_ = tracker_sparql_context_get_variable (_tmp51_, _tmp53_);
#line 173 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp55_ = _g_object_ref0 (_tmp54_);
#line 173 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_g_object_unref0 (variable);
#line 173 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			variable = _tmp55_;
#line 173 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_g_free0 (_tmp53_);
#line 1802 "tracker-sparql-expression.c"
		} else {
			TrackerSparqlContext* _tmp56_;
			TrackerSparqlContext* _tmp57_;
			gchar* _tmp58_ = NULL;
			gchar* _tmp59_;
			gchar* _tmp60_ = NULL;
			gchar* _tmp61_;
			TrackerSparqlVariable* _tmp62_ = NULL;
			TrackerSparqlVariable* _tmp63_;
#line 177 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			tracker_sparql_expression_expect (self, TRACKER_SPARQL_TOKEN_TYPE_VAR, &_inner_error_);
#line 177 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			if (_inner_error_ != NULL) {
#line 177 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 177 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_propagate_error (error, _inner_error_);
#line 177 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					_g_object_unref0 (variable);
#line 177 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					return 0;
#line 1824 "tracker-sparql-expression.c"
				} else {
#line 177 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					_g_object_unref0 (variable);
#line 177 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 177 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_clear_error (&_inner_error_);
#line 177 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					return 0;
#line 1834 "tracker-sparql-expression.c"
				}
			}
#line 178 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp56_ = tracker_sparql_expression_get_context (self);
#line 178 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp57_ = _tmp56_;
#line 178 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp58_ = tracker_sparql_expression_get_last_string (self, 0);
#line 178 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp59_ = _tmp58_;
#line 178 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp60_ = string_substring (_tmp59_, (glong) 1, (glong) (-1));
#line 178 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp61_ = _tmp60_;
#line 178 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp62_ = tracker_sparql_context_get_variable (_tmp57_, _tmp61_);
#line 178 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp63_ = _g_object_ref0 (_tmp62_);
#line 178 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_g_object_unref0 (variable);
#line 178 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			variable = _tmp63_;
#line 178 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_g_free0 (_tmp61_);
#line 178 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_g_free0 (_tmp59_);
#line 1861 "tracker-sparql-expression.c"
		}
#line 180 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		_tmp64_ = sql;
#line 180 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		_tmp65_ = variable;
#line 180 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		_tmp66_ = tracker_sparql_variable_get_sql_expression (_tmp65_);
#line 180 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		_tmp67_ = _tmp66_;
#line 180 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		g_string_append_printf (_tmp64_, " AS %s", _tmp67_);
#line 182 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		_tmp68_ = subquery;
#line 182 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		if (_tmp68_) {
#line 1877 "tracker-sparql-expression.c"
			TrackerSparqlVariableBinding* _tmp69_;
			TrackerSparqlVariableBinding* binding;
			TrackerSparqlVariableBinding* _tmp70_;
			TrackerPropertyType _tmp71_;
			TrackerSparqlVariableBinding* _tmp72_;
			TrackerSparqlVariable* _tmp73_;
			TrackerSparqlVariableBinding* _tmp74_;
			TrackerSparqlVariable* _tmp75_;
			const gchar* _tmp76_;
			const gchar* _tmp77_;
			TrackerSparqlPattern* _tmp78_;
			TrackerSparqlPattern* _tmp79_;
			GString* _tmp80_;
			GString* _tmp81_;
			TrackerSparqlVariableBinding* _tmp82_;
#line 183 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp69_ = tracker_sparql_variable_binding_new ();
#line 183 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			binding = _tmp69_;
#line 184 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp70_ = binding;
#line 184 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp71_ = type;
#line 184 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			((TrackerSparqlDataBinding*) _tmp70_)->data_type = _tmp71_;
#line 185 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp72_ = binding;
#line 185 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp73_ = variable;
#line 185 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp72_->variable = _tmp73_;
#line 186 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp74_ = binding;
#line 186 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp75_ = variable;
#line 186 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp76_ = tracker_sparql_variable_get_sql_expression (_tmp75_);
#line 186 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp77_ = _tmp76_;
#line 186 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			tracker_sparql_data_binding_set_sql_expression ((TrackerSparqlDataBinding*) _tmp74_, _tmp77_);
#line 187 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp78_ = tracker_sparql_expression_get_pattern (self);
#line 187 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp79_ = _tmp78_;
#line 187 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp80_ = g_string_new ("");
#line 187 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp81_ = _tmp80_;
#line 187 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp82_ = binding;
#line 187 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			tracker_sparql_pattern_add_variable_binding (_tmp79_, _tmp81_, _tmp82_, TRACKER_SPARQL_VARIABLE_STATE_BOUND);
#line 187 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_g_string_free0 (_tmp81_);
#line 182 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_g_object_unref0 (binding);
#line 1935 "tracker-sparql-expression.c"
		}
	}
#line 191 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	_tmp83_ = expect_close_parens;
#line 191 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	if (_tmp83_) {
#line 192 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		tracker_sparql_expression_expect (self, TRACKER_SPARQL_TOKEN_TYPE_CLOSE_PARENS, &_inner_error_);
#line 192 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		if (_inner_error_ != NULL) {
#line 192 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 192 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				g_propagate_error (error, _inner_error_);
#line 192 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				_g_object_unref0 (variable);
#line 192 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				return 0;
#line 1954 "tracker-sparql-expression.c"
			} else {
#line 192 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				_g_object_unref0 (variable);
#line 192 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 192 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				g_clear_error (&_inner_error_);
#line 192 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				return 0;
#line 1964 "tracker-sparql-expression.c"
			}
		}
	}
#line 195 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	_tmp84_ = variable;
#line 195 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	if (_tmp84_ != NULL) {
#line 1972 "tracker-sparql-expression.c"
		TrackerSparqlContext* _tmp85_;
		TrackerSparqlContext* _tmp86_;
		GHashTable* _tmp87_;
		TrackerSparqlVariable* _tmp88_;
		gconstpointer _tmp89_ = NULL;
		gint state;
		gint _tmp90_;
		TrackerSparqlContext* _tmp91_;
		TrackerSparqlContext* _tmp92_;
		GHashTable* _tmp93_;
		TrackerSparqlVariable* _tmp94_;
		TrackerSparqlVariable* _tmp95_;
		gint _tmp96_;
		TrackerSparqlContext* _tmp97_;
		TrackerSparqlContext* _tmp98_;
		TrackerSparqlContext* _tmp99_;
		TrackerSparqlContext* _tmp100_;
		gchar** _tmp101_;
		gint _tmp101__length1;
		TrackerSparqlVariable* _tmp102_;
		const gchar* _tmp103_;
		const gchar* _tmp104_;
		gchar* _tmp105_;
#line 196 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		_tmp85_ = tracker_sparql_expression_get_context (self);
#line 196 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		_tmp86_ = _tmp85_;
#line 196 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		_tmp87_ = _tmp86_->var_set;
#line 196 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		_tmp88_ = variable;
#line 196 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		_tmp89_ = g_hash_table_lookup (_tmp87_, _tmp88_);
#line 196 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		state = GPOINTER_TO_INT (_tmp89_);
#line 197 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		_tmp90_ = state;
#line 197 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		if (_tmp90_ == 0) {
#line 198 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			state = (gint) TRACKER_SPARQL_VARIABLE_STATE_BOUND;
#line 2014 "tracker-sparql-expression.c"
		}
#line 200 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		_tmp91_ = tracker_sparql_expression_get_context (self);
#line 200 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		_tmp92_ = _tmp91_;
#line 200 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		_tmp93_ = _tmp92_->select_var_set;
#line 200 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		_tmp94_ = variable;
#line 200 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		_tmp95_ = _g_object_ref0 (_tmp94_);
#line 200 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		_tmp96_ = state;
#line 200 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		g_hash_table_insert (_tmp93_, _tmp95_, GINT_TO_POINTER (_tmp96_));
#line 202 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		_tmp97_ = tracker_sparql_expression_get_context (self);
#line 202 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		_tmp98_ = _tmp97_;
#line 202 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		_tmp99_ = tracker_sparql_expression_get_context (self);
#line 202 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		_tmp100_ = _tmp99_;
#line 202 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		_tmp101_ = TRACKER_SPARQL_SELECT_CONTEXT (_tmp100_)->variable_names;
#line 202 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		_tmp101__length1 = TRACKER_SPARQL_SELECT_CONTEXT (_tmp100_)->variable_names_length1;
#line 202 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		_tmp102_ = variable;
#line 202 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		_tmp103_ = tracker_sparql_variable_get_name (_tmp102_);
#line 202 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		_tmp104_ = _tmp103_;
#line 202 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		_tmp105_ = g_strdup (_tmp104_);
#line 202 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		_vala_array_add1 (&TRACKER_SPARQL_SELECT_CONTEXT (_tmp98_)->variable_names, &TRACKER_SPARQL_SELECT_CONTEXT (_tmp98_)->variable_names_length1, &TRACKER_SPARQL_SELECT_CONTEXT (_tmp98_)->_variable_names_size_, _tmp105_);
#line 2052 "tracker-sparql-expression.c"
	} else {
		TrackerSparqlContext* _tmp106_;
		TrackerSparqlContext* _tmp107_;
		TrackerSparqlContext* _tmp108_;
		TrackerSparqlContext* _tmp109_;
		gchar** _tmp110_;
		gint _tmp110__length1;
		gint _tmp111_;
		gchar* _tmp112_ = NULL;
#line 204 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		_tmp106_ = tracker_sparql_expression_get_context (self);
#line 204 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		_tmp107_ = _tmp106_;
#line 204 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		_tmp108_ = tracker_sparql_expression_get_context (self);
#line 204 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		_tmp109_ = _tmp108_;
#line 204 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		_tmp110_ = TRACKER_SPARQL_SELECT_CONTEXT (_tmp109_)->variable_names;
#line 204 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		_tmp110__length1 = TRACKER_SPARQL_SELECT_CONTEXT (_tmp109_)->variable_names_length1;
#line 204 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		_tmp111_ = variable_index;
#line 204 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		_tmp112_ = g_strdup_printf ("var%d", _tmp111_ + 1);
#line 204 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		_vala_array_add2 (&TRACKER_SPARQL_SELECT_CONTEXT (_tmp107_)->variable_names, &TRACKER_SPARQL_SELECT_CONTEXT (_tmp107_)->variable_names_length1, &TRACKER_SPARQL_SELECT_CONTEXT (_tmp107_)->_variable_names_size_, _tmp112_);
#line 2080 "tracker-sparql-expression.c"
	}
#line 207 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	result = type;
#line 207 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	_g_object_unref0 (variable);
#line 207 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	return result;
#line 2088 "tracker-sparql-expression.c"
}


static void tracker_sparql_expression_translate_expression_as_order_condition (TrackerSparqlExpression* self, GString* sql, GError** error) {
	GString* _tmp0_;
	gssize _tmp1_;
	glong begin;
	GString* _tmp2_;
	TrackerPropertyType _tmp3_ = 0;
	TrackerPropertyType _tmp4_;
	GError * _inner_error_ = NULL;
#line 210 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	g_return_if_fail (self != NULL);
#line 210 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	g_return_if_fail (sql != NULL);
#line 211 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	_tmp0_ = sql;
#line 211 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	_tmp1_ = _tmp0_->len;
#line 211 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	begin = (glong) _tmp1_;
#line 212 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	_tmp2_ = sql;
#line 212 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	_tmp3_ = tracker_sparql_expression_translate_expression (self, _tmp2_, &_inner_error_);
#line 212 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	_tmp4_ = _tmp3_;
#line 212 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	if (_inner_error_ != NULL) {
#line 212 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 212 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			g_propagate_error (error, _inner_error_);
#line 212 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			return;
#line 2124 "tracker-sparql-expression.c"
		} else {
#line 212 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 212 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			g_clear_error (&_inner_error_);
#line 212 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			return;
#line 2132 "tracker-sparql-expression.c"
		}
	}
#line 212 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	if (_tmp4_ == TRACKER_PROPERTY_TYPE_RESOURCE) {
#line 2137 "tracker-sparql-expression.c"
		GString* _tmp5_;
		GString* _tmp6_;
#line 214 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		_tmp5_ = sql;
#line 214 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		g_string_insert (_tmp5_, (gssize) begin, "(SELECT Uri FROM Resource WHERE ID = ");
#line 215 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		_tmp6_ = sql;
#line 215 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		g_string_append (_tmp6_, ")");
#line 2148 "tracker-sparql-expression.c"
	}
}


void tracker_sparql_expression_translate_order_condition (TrackerSparqlExpression* self, GString* sql, GError** error) {
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_;
	GError * _inner_error_ = NULL;
#line 219 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	g_return_if_fail (self != NULL);
#line 219 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	g_return_if_fail (sql != NULL);
#line 220 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	_tmp0_ = tracker_sparql_expression_accept (self, TRACKER_SPARQL_TOKEN_TYPE_ASC, &_inner_error_);
#line 220 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	_tmp1_ = _tmp0_;
#line 220 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	if (_inner_error_ != NULL) {
#line 220 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 220 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			g_propagate_error (error, _inner_error_);
#line 220 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			return;
#line 2173 "tracker-sparql-expression.c"
		} else {
#line 220 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 220 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			g_clear_error (&_inner_error_);
#line 220 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			return;
#line 2181 "tracker-sparql-expression.c"
		}
	}
#line 220 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	if (_tmp1_) {
#line 2186 "tracker-sparql-expression.c"
		GString* _tmp2_;
		GString* _tmp3_;
#line 221 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		_tmp2_ = sql;
#line 221 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		tracker_sparql_expression_translate_expression_as_order_condition (self, _tmp2_, &_inner_error_);
#line 221 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		if (_inner_error_ != NULL) {
#line 221 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 221 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				g_propagate_error (error, _inner_error_);
#line 221 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				return;
#line 2201 "tracker-sparql-expression.c"
			} else {
#line 221 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 221 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				g_clear_error (&_inner_error_);
#line 221 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				return;
#line 2209 "tracker-sparql-expression.c"
			}
		}
#line 222 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		_tmp3_ = sql;
#line 222 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		g_string_append (_tmp3_, " ASC");
#line 2216 "tracker-sparql-expression.c"
	} else {
		gboolean _tmp4_ = FALSE;
		gboolean _tmp5_;
#line 223 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		_tmp4_ = tracker_sparql_expression_accept (self, TRACKER_SPARQL_TOKEN_TYPE_DESC, &_inner_error_);
#line 223 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		_tmp5_ = _tmp4_;
#line 223 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		if (_inner_error_ != NULL) {
#line 223 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 223 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				g_propagate_error (error, _inner_error_);
#line 223 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				return;
#line 2232 "tracker-sparql-expression.c"
			} else {
#line 223 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 223 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				g_clear_error (&_inner_error_);
#line 223 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				return;
#line 2240 "tracker-sparql-expression.c"
			}
		}
#line 223 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		if (_tmp5_) {
#line 2245 "tracker-sparql-expression.c"
			GString* _tmp6_;
			GString* _tmp7_;
#line 224 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp6_ = sql;
#line 224 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			tracker_sparql_expression_translate_expression_as_order_condition (self, _tmp6_, &_inner_error_);
#line 224 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			if (_inner_error_ != NULL) {
#line 224 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 224 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_propagate_error (error, _inner_error_);
#line 224 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					return;
#line 2260 "tracker-sparql-expression.c"
				} else {
#line 224 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 224 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_clear_error (&_inner_error_);
#line 224 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					return;
#line 2268 "tracker-sparql-expression.c"
				}
			}
#line 225 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp7_ = sql;
#line 225 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			g_string_append (_tmp7_, " DESC");
#line 2275 "tracker-sparql-expression.c"
		} else {
			GString* _tmp8_;
#line 227 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp8_ = sql;
#line 227 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			tracker_sparql_expression_translate_expression_as_order_condition (self, _tmp8_, &_inner_error_);
#line 227 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			if (_inner_error_ != NULL) {
#line 227 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 227 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_propagate_error (error, _inner_error_);
#line 227 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					return;
#line 2290 "tracker-sparql-expression.c"
				} else {
#line 227 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 227 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_clear_error (&_inner_error_);
#line 227 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					return;
#line 2298 "tracker-sparql-expression.c"
				}
			}
		}
	}
}


static void tracker_sparql_expression_translate_bound_call (TrackerSparqlExpression* self, GString* sql, GError** error) {
	GString* _tmp0_;
	GString* _tmp1_;
	GString* _tmp2_;
	GError * _inner_error_ = NULL;
#line 231 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	g_return_if_fail (self != NULL);
#line 231 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	g_return_if_fail (sql != NULL);
#line 232 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	tracker_sparql_expression_expect (self, TRACKER_SPARQL_TOKEN_TYPE_BOUND, &_inner_error_);
#line 232 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	if (_inner_error_ != NULL) {
#line 232 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 232 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			g_propagate_error (error, _inner_error_);
#line 232 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			return;
#line 2325 "tracker-sparql-expression.c"
		} else {
#line 232 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 232 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			g_clear_error (&_inner_error_);
#line 232 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			return;
#line 2333 "tracker-sparql-expression.c"
		}
	}
#line 233 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	tracker_sparql_expression_expect (self, TRACKER_SPARQL_TOKEN_TYPE_OPEN_PARENS, &_inner_error_);
#line 233 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	if (_inner_error_ != NULL) {
#line 233 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 233 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			g_propagate_error (error, _inner_error_);
#line 233 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			return;
#line 2346 "tracker-sparql-expression.c"
		} else {
#line 233 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 233 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			g_clear_error (&_inner_error_);
#line 233 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			return;
#line 2354 "tracker-sparql-expression.c"
		}
	}
#line 234 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	_tmp0_ = sql;
#line 234 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	g_string_append (_tmp0_, "(");
#line 235 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	_tmp1_ = sql;
#line 235 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	tracker_sparql_expression_translate_expression (self, _tmp1_, &_inner_error_);
#line 235 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	if (_inner_error_ != NULL) {
#line 235 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 235 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			g_propagate_error (error, _inner_error_);
#line 235 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			return;
#line 2373 "tracker-sparql-expression.c"
		} else {
#line 235 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 235 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			g_clear_error (&_inner_error_);
#line 235 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			return;
#line 2381 "tracker-sparql-expression.c"
		}
	}
#line 236 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	_tmp2_ = sql;
#line 236 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	g_string_append (_tmp2_, " IS NOT NULL)");
#line 237 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	tracker_sparql_expression_expect (self, TRACKER_SPARQL_TOKEN_TYPE_CLOSE_PARENS, &_inner_error_);
#line 237 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	if (_inner_error_ != NULL) {
#line 237 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 237 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			g_propagate_error (error, _inner_error_);
#line 237 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			return;
#line 2398 "tracker-sparql-expression.c"
		} else {
#line 237 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 237 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			g_clear_error (&_inner_error_);
#line 237 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			return;
#line 2406 "tracker-sparql-expression.c"
		}
	}
}


static TrackerPropertyType tracker_sparql_expression_translate_if_call (TrackerSparqlExpression* self, GString* sql, GError** error) {
	TrackerPropertyType result = 0;
	GString* _tmp0_;
	GString* _tmp1_;
	GString* _tmp2_;
	GString* _tmp3_;
	TrackerPropertyType _tmp4_ = 0;
	TrackerPropertyType type;
	GString* _tmp5_;
	GString* _tmp6_;
	GString* _tmp7_;
	GError * _inner_error_ = NULL;
#line 240 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	g_return_val_if_fail (self != NULL, 0);
#line 240 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	g_return_val_if_fail (sql != NULL, 0);
#line 241 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	tracker_sparql_expression_expect (self, TRACKER_SPARQL_TOKEN_TYPE_IF, &_inner_error_);
#line 241 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	if (_inner_error_ != NULL) {
#line 241 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 241 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			g_propagate_error (error, _inner_error_);
#line 241 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			return 0;
#line 2438 "tracker-sparql-expression.c"
		} else {
#line 241 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 241 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			g_clear_error (&_inner_error_);
#line 241 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			return 0;
#line 2446 "tracker-sparql-expression.c"
		}
	}
#line 242 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	tracker_sparql_expression_expect (self, TRACKER_SPARQL_TOKEN_TYPE_OPEN_PARENS, &_inner_error_);
#line 242 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	if (_inner_error_ != NULL) {
#line 242 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 242 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			g_propagate_error (error, _inner_error_);
#line 242 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			return 0;
#line 2459 "tracker-sparql-expression.c"
		} else {
#line 242 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 242 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			g_clear_error (&_inner_error_);
#line 242 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			return 0;
#line 2467 "tracker-sparql-expression.c"
		}
	}
#line 245 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	_tmp0_ = sql;
#line 245 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	g_string_append (_tmp0_, "(CASE ");
#line 246 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	_tmp1_ = sql;
#line 246 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	tracker_sparql_expression_translate_expression (self, _tmp1_, &_inner_error_);
#line 246 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	if (_inner_error_ != NULL) {
#line 246 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 246 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			g_propagate_error (error, _inner_error_);
#line 246 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			return 0;
#line 2486 "tracker-sparql-expression.c"
		} else {
#line 246 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 246 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			g_clear_error (&_inner_error_);
#line 246 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			return 0;
#line 2494 "tracker-sparql-expression.c"
		}
	}
#line 249 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	_tmp2_ = sql;
#line 249 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	g_string_append (_tmp2_, " WHEN 1 THEN ");
#line 250 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	tracker_sparql_expression_expect (self, TRACKER_SPARQL_TOKEN_TYPE_COMMA, &_inner_error_);
#line 250 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	if (_inner_error_ != NULL) {
#line 250 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 250 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			g_propagate_error (error, _inner_error_);
#line 250 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			return 0;
#line 2511 "tracker-sparql-expression.c"
		} else {
#line 250 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 250 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			g_clear_error (&_inner_error_);
#line 250 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			return 0;
#line 2519 "tracker-sparql-expression.c"
		}
	}
#line 251 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	_tmp3_ = sql;
#line 251 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	_tmp4_ = tracker_sparql_expression_translate_expression (self, _tmp3_, &_inner_error_);
#line 251 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	type = _tmp4_;
#line 251 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	if (_inner_error_ != NULL) {
#line 251 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 251 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			g_propagate_error (error, _inner_error_);
#line 251 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			return 0;
#line 2536 "tracker-sparql-expression.c"
		} else {
#line 251 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 251 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			g_clear_error (&_inner_error_);
#line 251 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			return 0;
#line 2544 "tracker-sparql-expression.c"
		}
	}
#line 254 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	_tmp5_ = sql;
#line 254 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	g_string_append (_tmp5_, " WHEN 0 THEN ");
#line 255 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	tracker_sparql_expression_expect (self, TRACKER_SPARQL_TOKEN_TYPE_COMMA, &_inner_error_);
#line 255 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	if (_inner_error_ != NULL) {
#line 255 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 255 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			g_propagate_error (error, _inner_error_);
#line 255 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			return 0;
#line 2561 "tracker-sparql-expression.c"
		} else {
#line 255 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 255 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			g_clear_error (&_inner_error_);
#line 255 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			return 0;
#line 2569 "tracker-sparql-expression.c"
		}
	}
#line 256 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	_tmp6_ = sql;
#line 256 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	tracker_sparql_expression_translate_expression (self, _tmp6_, &_inner_error_);
#line 256 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	if (_inner_error_ != NULL) {
#line 256 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 256 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			g_propagate_error (error, _inner_error_);
#line 256 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			return 0;
#line 2584 "tracker-sparql-expression.c"
		} else {
#line 256 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 256 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			g_clear_error (&_inner_error_);
#line 256 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			return 0;
#line 2592 "tracker-sparql-expression.c"
		}
	}
#line 258 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	_tmp7_ = sql;
#line 258 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	g_string_append (_tmp7_, " ELSE NULL END)");
#line 260 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	tracker_sparql_expression_expect (self, TRACKER_SPARQL_TOKEN_TYPE_CLOSE_PARENS, &_inner_error_);
#line 260 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	if (_inner_error_ != NULL) {
#line 260 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 260 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			g_propagate_error (error, _inner_error_);
#line 260 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			return 0;
#line 2609 "tracker-sparql-expression.c"
		} else {
#line 260 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 260 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			g_clear_error (&_inner_error_);
#line 260 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			return 0;
#line 2617 "tracker-sparql-expression.c"
		}
	}
#line 262 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	result = type;
#line 262 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	return result;
#line 2624 "tracker-sparql-expression.c"
}


static void tracker_sparql_expression_translate_regex (TrackerSparqlExpression* self, GString* sql, GError** error) {
	GString* _tmp0_;
	GString* _tmp1_;
	GString* _tmp2_;
	gchar* _tmp3_ = NULL;
	gchar* _tmp4_;
	GString* _tmp5_;
	gchar* _tmp6_;
	gchar* _tmp7_ = NULL;
	gchar* _tmp8_;
	GString* _tmp9_;
	gboolean _tmp10_ = FALSE;
	gboolean _tmp11_;
	GString* _tmp19_;
	GError * _inner_error_ = NULL;
#line 265 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	g_return_if_fail (self != NULL);
#line 265 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	g_return_if_fail (sql != NULL);
#line 266 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	tracker_sparql_expression_expect (self, TRACKER_SPARQL_TOKEN_TYPE_REGEX, &_inner_error_);
#line 266 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	if (_inner_error_ != NULL) {
#line 266 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 266 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			g_propagate_error (error, _inner_error_);
#line 266 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			return;
#line 2657 "tracker-sparql-expression.c"
		} else {
#line 266 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 266 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			g_clear_error (&_inner_error_);
#line 266 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			return;
#line 2665 "tracker-sparql-expression.c"
		}
	}
#line 267 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	tracker_sparql_expression_expect (self, TRACKER_SPARQL_TOKEN_TYPE_OPEN_PARENS, &_inner_error_);
#line 267 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	if (_inner_error_ != NULL) {
#line 267 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 267 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			g_propagate_error (error, _inner_error_);
#line 267 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			return;
#line 2678 "tracker-sparql-expression.c"
		} else {
#line 267 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 267 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			g_clear_error (&_inner_error_);
#line 267 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			return;
#line 2686 "tracker-sparql-expression.c"
		}
	}
#line 268 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	_tmp0_ = sql;
#line 268 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	g_string_append (_tmp0_, "SparqlRegex(");
#line 269 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	_tmp1_ = sql;
#line 269 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	tracker_sparql_expression_translate_expression_as_string (self, _tmp1_, &_inner_error_);
#line 269 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	if (_inner_error_ != NULL) {
#line 269 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 269 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			g_propagate_error (error, _inner_error_);
#line 269 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			return;
#line 2705 "tracker-sparql-expression.c"
		} else {
#line 269 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 269 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			g_clear_error (&_inner_error_);
#line 269 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			return;
#line 2713 "tracker-sparql-expression.c"
		}
	}
#line 270 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	_tmp2_ = sql;
#line 270 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	g_string_append (_tmp2_, ", ");
#line 271 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	tracker_sparql_expression_expect (self, TRACKER_SPARQL_TOKEN_TYPE_COMMA, &_inner_error_);
#line 271 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	if (_inner_error_ != NULL) {
#line 271 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 271 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			g_propagate_error (error, _inner_error_);
#line 271 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			return;
#line 2730 "tracker-sparql-expression.c"
		} else {
#line 271 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 271 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			g_clear_error (&_inner_error_);
#line 271 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			return;
#line 2738 "tracker-sparql-expression.c"
		}
	}
#line 275 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	_tmp3_ = tracker_sparql_expression_parse_string_literal (self, NULL, &_inner_error_);
#line 275 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	_tmp4_ = _tmp3_;
#line 275 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	if (_inner_error_ != NULL) {
#line 275 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 275 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			g_propagate_error (error, _inner_error_);
#line 275 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			return;
#line 2753 "tracker-sparql-expression.c"
		} else {
#line 275 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 275 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			g_clear_error (&_inner_error_);
#line 275 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			return;
#line 2761 "tracker-sparql-expression.c"
		}
	}
#line 275 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	_tmp5_ = sql;
#line 275 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	_tmp6_ = _tmp4_;
#line 275 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	_tmp7_ = tracker_sparql_expression_escape_sql_string_literal (self, _tmp6_);
#line 275 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	_tmp8_ = _tmp7_;
#line 275 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	g_string_append (_tmp5_, _tmp8_);
#line 275 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	_g_free0 (_tmp8_);
#line 275 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	_g_free0 (_tmp6_);
#line 276 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	_tmp9_ = sql;
#line 276 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	g_string_append (_tmp9_, ", ");
#line 277 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	_tmp10_ = tracker_sparql_expression_accept (self, TRACKER_SPARQL_TOKEN_TYPE_COMMA, &_inner_error_);
#line 277 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	_tmp11_ = _tmp10_;
#line 277 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	if (_inner_error_ != NULL) {
#line 277 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 277 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			g_propagate_error (error, _inner_error_);
#line 277 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			return;
#line 2794 "tracker-sparql-expression.c"
		} else {
#line 277 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 277 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			g_clear_error (&_inner_error_);
#line 277 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			return;
#line 2802 "tracker-sparql-expression.c"
		}
	}
#line 277 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	if (_tmp11_) {
#line 2807 "tracker-sparql-expression.c"
		gchar* _tmp12_ = NULL;
		gchar* _tmp13_;
		GString* _tmp14_;
		gchar* _tmp15_;
		gchar* _tmp16_ = NULL;
		gchar* _tmp17_;
#line 280 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		_tmp12_ = tracker_sparql_expression_parse_string_literal (self, NULL, &_inner_error_);
#line 280 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		_tmp13_ = _tmp12_;
#line 280 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		if (_inner_error_ != NULL) {
#line 280 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 280 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				g_propagate_error (error, _inner_error_);
#line 280 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				return;
#line 2826 "tracker-sparql-expression.c"
			} else {
#line 280 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 280 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				g_clear_error (&_inner_error_);
#line 280 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				return;
#line 2834 "tracker-sparql-expression.c"
			}
		}
#line 280 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		_tmp14_ = sql;
#line 280 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		_tmp15_ = _tmp13_;
#line 280 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		_tmp16_ = tracker_sparql_expression_escape_sql_string_literal (self, _tmp15_);
#line 280 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		_tmp17_ = _tmp16_;
#line 280 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		g_string_append (_tmp14_, _tmp17_);
#line 280 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		_g_free0 (_tmp17_);
#line 280 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		_g_free0 (_tmp15_);
#line 2851 "tracker-sparql-expression.c"
	} else {
		GString* _tmp18_;
#line 282 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		_tmp18_ = sql;
#line 282 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		g_string_append (_tmp18_, "''");
#line 2858 "tracker-sparql-expression.c"
	}
#line 284 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	_tmp19_ = sql;
#line 284 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	g_string_append (_tmp19_, ")");
#line 285 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	tracker_sparql_expression_expect (self, TRACKER_SPARQL_TOKEN_TYPE_CLOSE_PARENS, &_inner_error_);
#line 285 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	if (_inner_error_ != NULL) {
#line 285 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 285 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			g_propagate_error (error, _inner_error_);
#line 285 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			return;
#line 2874 "tracker-sparql-expression.c"
		} else {
#line 285 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 285 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			g_clear_error (&_inner_error_);
#line 285 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			return;
#line 2882 "tracker-sparql-expression.c"
		}
	}
}


static void tracker_sparql_expression_translate_exists (TrackerSparqlExpression* self, GString* sql, GError** error) {
	GString* _tmp0_;
	TrackerSparqlPattern* _tmp1_;
	TrackerSparqlPattern* _tmp2_;
	GString* _tmp3_;
	GString* _tmp4_;
	GError * _inner_error_ = NULL;
#line 288 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	g_return_if_fail (self != NULL);
#line 288 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	g_return_if_fail (sql != NULL);
#line 289 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	_tmp0_ = sql;
#line 289 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	g_string_append (_tmp0_, "(");
#line 290 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	_tmp1_ = tracker_sparql_expression_get_pattern (self);
#line 290 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	_tmp2_ = _tmp1_;
#line 290 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	_tmp3_ = sql;
#line 290 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	tracker_sparql_pattern_translate_exists (_tmp2_, _tmp3_, &_inner_error_);
#line 290 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	if (_inner_error_ != NULL) {
#line 290 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 290 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			g_propagate_error (error, _inner_error_);
#line 290 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			return;
#line 2919 "tracker-sparql-expression.c"
		} else {
#line 290 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 290 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			g_clear_error (&_inner_error_);
#line 290 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			return;
#line 2927 "tracker-sparql-expression.c"
		}
	}
#line 291 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	_tmp4_ = sql;
#line 291 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	g_string_append (_tmp4_, ")");
#line 2934 "tracker-sparql-expression.c"
}


void tracker_sparql_expression_append_expression_as_string (GString* sql, const gchar* expression, TrackerPropertyType type) {
	GString* _tmp0_;
	gssize _tmp1_;
	glong begin;
	GString* _tmp2_;
	const gchar* _tmp3_;
	GString* _tmp4_;
	TrackerPropertyType _tmp5_;
#line 294 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	g_return_if_fail (sql != NULL);
#line 294 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	g_return_if_fail (expression != NULL);
#line 295 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	_tmp0_ = sql;
#line 295 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	_tmp1_ = _tmp0_->len;
#line 295 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	begin = (glong) _tmp1_;
#line 296 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	_tmp2_ = sql;
#line 296 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	_tmp3_ = expression;
#line 296 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	g_string_append (_tmp2_, _tmp3_);
#line 297 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	_tmp4_ = sql;
#line 297 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	_tmp5_ = type;
#line 297 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	tracker_sparql_expression_convert_expression_to_string (_tmp4_, _tmp5_, begin);
#line 2968 "tracker-sparql-expression.c"
}


static void tracker_sparql_expression_convert_expression_to_string (GString* sql, TrackerPropertyType type, glong begin) {
	TrackerPropertyType _tmp0_;
#line 300 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	g_return_if_fail (sql != NULL);
#line 301 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	_tmp0_ = type;
#line 301 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	switch (_tmp0_) {
#line 301 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		case TRACKER_PROPERTY_TYPE_STRING:
#line 301 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		case TRACKER_PROPERTY_TYPE_INTEGER:
#line 2984 "tracker-sparql-expression.c"
		{
#line 307 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			break;
#line 2988 "tracker-sparql-expression.c"
		}
#line 301 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		case TRACKER_PROPERTY_TYPE_RESOURCE:
#line 2992 "tracker-sparql-expression.c"
		{
			GString* _tmp1_;
			glong _tmp2_;
			GString* _tmp3_;
#line 310 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp1_ = sql;
#line 310 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp2_ = begin;
#line 310 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			g_string_insert (_tmp1_, (gssize) _tmp2_, "(SELECT Uri FROM Resource WHERE ID = ");
#line 311 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp3_ = sql;
#line 311 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			g_string_append (_tmp3_, ")");
#line 312 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			break;
#line 3009 "tracker-sparql-expression.c"
		}
#line 301 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		case TRACKER_PROPERTY_TYPE_BOOLEAN:
#line 3013 "tracker-sparql-expression.c"
		{
			GString* _tmp4_;
			glong _tmp5_;
			GString* _tmp6_;
#line 315 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp4_ = sql;
#line 315 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp5_ = begin;
#line 315 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			g_string_insert (_tmp4_, (gssize) _tmp5_, "CASE ");
#line 316 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp6_ = sql;
#line 316 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			g_string_append (_tmp6_, " WHEN 1 THEN 'true' WHEN 0 THEN 'false' ELSE NULL END");
#line 317 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			break;
#line 3030 "tracker-sparql-expression.c"
		}
#line 301 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		case TRACKER_PROPERTY_TYPE_DATE:
#line 3034 "tracker-sparql-expression.c"
		{
			GString* _tmp7_;
			glong _tmp8_;
			GString* _tmp9_;
#line 320 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp7_ = sql;
#line 320 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp8_ = begin;
#line 320 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			g_string_insert (_tmp7_, (gssize) _tmp8_, "strftime (\"%Y-%m-%d\", ");
#line 321 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp9_ = sql;
#line 321 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			g_string_append (_tmp9_, ", \"unixepoch\")");
#line 322 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			break;
#line 3051 "tracker-sparql-expression.c"
		}
#line 301 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		case TRACKER_PROPERTY_TYPE_DATETIME:
#line 3055 "tracker-sparql-expression.c"
		{
			GString* _tmp10_;
			glong _tmp11_;
			GString* _tmp12_;
#line 325 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp10_ = sql;
#line 325 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp11_ = begin;
#line 325 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			g_string_insert (_tmp10_, (gssize) _tmp11_, "SparqlFormatTime (");
#line 326 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp12_ = sql;
#line 326 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			g_string_append (_tmp12_, ")");
#line 327 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			break;
#line 3072 "tracker-sparql-expression.c"
		}
		default:
		{
			GString* _tmp13_;
			glong _tmp14_;
			GString* _tmp15_;
#line 330 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp13_ = sql;
#line 330 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp14_ = begin;
#line 330 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			g_string_insert (_tmp13_, (gssize) _tmp14_, "CAST (");
#line 331 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp15_ = sql;
#line 331 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			g_string_append (_tmp15_, " AS TEXT)");
#line 332 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			break;
#line 3091 "tracker-sparql-expression.c"
		}
	}
}


static void tracker_sparql_expression_translate_expression_as_string (TrackerSparqlExpression* self, GString* sql, GError** error) {
	TrackerSparqlTokenType _tmp0_ = 0;
	GError * _inner_error_ = NULL;
#line 336 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	g_return_if_fail (self != NULL);
#line 336 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	g_return_if_fail (sql != NULL);
#line 337 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	_tmp0_ = tracker_sparql_expression_current (self);
#line 337 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	switch (_tmp0_) {
#line 337 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		case TRACKER_SPARQL_TOKEN_TYPE_IRI_REF:
#line 337 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		case TRACKER_SPARQL_TOKEN_TYPE_PN_PREFIX:
#line 337 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		case TRACKER_SPARQL_TOKEN_TYPE_COLON:
#line 3114 "tracker-sparql-expression.c"
		{
			TrackerSparqlLiteralBinding* _tmp1_;
			TrackerSparqlLiteralBinding* binding;
			gboolean is_var = FALSE;
			TrackerSparqlPattern* _tmp2_;
			TrackerSparqlPattern* _tmp3_;
			gboolean _tmp4_ = FALSE;
			gchar* _tmp5_ = NULL;
			gchar* _tmp6_;
			TrackerSparqlLiteralBinding* _tmp7_;
			gboolean _tmp8_ = FALSE;
			gboolean _tmp9_;
#line 342 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp1_ = tracker_sparql_literal_binding_new ();
#line 342 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			binding = _tmp1_;
#line 344 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp2_ = tracker_sparql_expression_get_pattern (self);
#line 344 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp3_ = _tmp2_;
#line 344 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp5_ = tracker_sparql_pattern_parse_var_or_term (_tmp3_, NULL, &_tmp4_, &_inner_error_);
#line 344 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			is_var = _tmp4_;
#line 344 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp6_ = _tmp5_;
#line 344 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			if (_inner_error_ != NULL) {
#line 344 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 344 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_propagate_error (error, _inner_error_);
#line 344 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					_g_object_unref0 (binding);
#line 344 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					return;
#line 3151 "tracker-sparql-expression.c"
				} else {
#line 344 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					_g_object_unref0 (binding);
#line 344 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 344 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_clear_error (&_inner_error_);
#line 344 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					return;
#line 3161 "tracker-sparql-expression.c"
				}
			}
#line 344 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp7_ = binding;
#line 344 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_g_free0 (_tmp7_->literal);
#line 344 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp7_->literal = _tmp6_;
#line 345 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp8_ = tracker_sparql_expression_accept (self, TRACKER_SPARQL_TOKEN_TYPE_OPEN_PARENS, &_inner_error_);
#line 345 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp9_ = _tmp8_;
#line 345 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			if (_inner_error_ != NULL) {
#line 345 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 345 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_propagate_error (error, _inner_error_);
#line 345 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					_g_object_unref0 (binding);
#line 345 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					return;
#line 3184 "tracker-sparql-expression.c"
				} else {
#line 345 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					_g_object_unref0 (binding);
#line 345 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 345 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_clear_error (&_inner_error_);
#line 345 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					return;
#line 3194 "tracker-sparql-expression.c"
				}
			}
#line 345 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			if (_tmp9_) {
#line 3199 "tracker-sparql-expression.c"
				GString* _tmp10_;
				gssize _tmp11_;
				glong begin;
				GString* _tmp12_;
				TrackerSparqlLiteralBinding* _tmp13_;
				const gchar* _tmp14_;
				TrackerPropertyType _tmp15_ = 0;
				TrackerPropertyType type;
				GString* _tmp16_;
				TrackerPropertyType _tmp17_;
				glong _tmp18_;
#line 347 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				_tmp10_ = sql;
#line 347 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				_tmp11_ = _tmp10_->len;
#line 347 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				begin = (glong) _tmp11_;
#line 348 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				_tmp12_ = sql;
#line 348 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				_tmp13_ = binding;
#line 348 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				_tmp14_ = _tmp13_->literal;
#line 348 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				_tmp15_ = tracker_sparql_expression_translate_function (self, _tmp12_, _tmp14_, &_inner_error_);
#line 348 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				type = _tmp15_;
#line 348 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				if (_inner_error_ != NULL) {
#line 348 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 348 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
						g_propagate_error (error, _inner_error_);
#line 348 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
						_g_object_unref0 (binding);
#line 348 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
						return;
#line 3237 "tracker-sparql-expression.c"
					} else {
#line 348 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
						_g_object_unref0 (binding);
#line 348 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 348 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
						g_clear_error (&_inner_error_);
#line 348 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
						return;
#line 3247 "tracker-sparql-expression.c"
					}
				}
#line 349 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				tracker_sparql_expression_expect (self, TRACKER_SPARQL_TOKEN_TYPE_CLOSE_PARENS, &_inner_error_);
#line 349 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				if (_inner_error_ != NULL) {
#line 349 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 349 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
						g_propagate_error (error, _inner_error_);
#line 349 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
						_g_object_unref0 (binding);
#line 349 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
						return;
#line 3262 "tracker-sparql-expression.c"
					} else {
#line 349 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
						_g_object_unref0 (binding);
#line 349 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 349 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
						g_clear_error (&_inner_error_);
#line 349 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
						return;
#line 3272 "tracker-sparql-expression.c"
					}
				}
#line 350 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				_tmp16_ = sql;
#line 350 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				_tmp17_ = type;
#line 350 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				_tmp18_ = begin;
#line 350 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				tracker_sparql_expression_convert_expression_to_string (_tmp16_, _tmp17_, _tmp18_);
#line 3283 "tracker-sparql-expression.c"
			} else {
				GString* _tmp19_;
				TrackerSparqlQuery* _tmp20_;
				TrackerSparqlLiteralBinding* _tmp21_;
				TrackerSparqlLiteralBinding* _tmp22_;
#line 352 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				_tmp19_ = sql;
#line 352 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				g_string_append (_tmp19_, "?");
#line 353 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				_tmp20_ = self->priv->query;
#line 353 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				_tmp21_ = binding;
#line 353 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				_tmp22_ = _g_object_ref0 (_tmp21_);
#line 353 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				_tmp20_->bindings = g_list_append (_tmp20_->bindings, _tmp22_);
#line 3301 "tracker-sparql-expression.c"
			}
#line 355 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_g_object_unref0 (binding);
#line 355 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			break;
#line 3307 "tracker-sparql-expression.c"
		}
		default:
		{
			GString* _tmp23_;
			gssize _tmp24_;
			glong begin;
			GString* _tmp25_;
			TrackerPropertyType _tmp26_ = 0;
			TrackerPropertyType type;
			GString* _tmp27_;
			TrackerPropertyType _tmp28_;
			glong _tmp29_;
#line 357 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp23_ = sql;
#line 357 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp24_ = _tmp23_->len;
#line 357 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			begin = (glong) _tmp24_;
#line 358 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp25_ = sql;
#line 358 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp26_ = tracker_sparql_expression_translate_expression (self, _tmp25_, &_inner_error_);
#line 358 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			type = _tmp26_;
#line 358 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			if (_inner_error_ != NULL) {
#line 358 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 358 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_propagate_error (error, _inner_error_);
#line 358 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					return;
#line 3340 "tracker-sparql-expression.c"
				} else {
#line 358 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 358 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_clear_error (&_inner_error_);
#line 358 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					return;
#line 3348 "tracker-sparql-expression.c"
				}
			}
#line 359 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp27_ = sql;
#line 359 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp28_ = type;
#line 359 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp29_ = begin;
#line 359 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			tracker_sparql_expression_convert_expression_to_string (_tmp27_, _tmp28_, _tmp29_);
#line 360 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			break;
#line 3361 "tracker-sparql-expression.c"
		}
	}
}


static void tracker_sparql_expression_translate_str (TrackerSparqlExpression* self, GString* sql, GError** error) {
	GString* _tmp0_;
	GError * _inner_error_ = NULL;
#line 364 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	g_return_if_fail (self != NULL);
#line 364 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	g_return_if_fail (sql != NULL);
#line 365 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	tracker_sparql_expression_expect (self, TRACKER_SPARQL_TOKEN_TYPE_STR, &_inner_error_);
#line 365 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	if (_inner_error_ != NULL) {
#line 365 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 365 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			g_propagate_error (error, _inner_error_);
#line 365 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			return;
#line 3384 "tracker-sparql-expression.c"
		} else {
#line 365 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 365 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			g_clear_error (&_inner_error_);
#line 365 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			return;
#line 3392 "tracker-sparql-expression.c"
		}
	}
#line 366 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	tracker_sparql_expression_expect (self, TRACKER_SPARQL_TOKEN_TYPE_OPEN_PARENS, &_inner_error_);
#line 366 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	if (_inner_error_ != NULL) {
#line 366 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 366 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			g_propagate_error (error, _inner_error_);
#line 366 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			return;
#line 3405 "tracker-sparql-expression.c"
		} else {
#line 366 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 366 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			g_clear_error (&_inner_error_);
#line 366 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			return;
#line 3413 "tracker-sparql-expression.c"
		}
	}
#line 368 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	_tmp0_ = sql;
#line 368 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	tracker_sparql_expression_translate_expression_as_string (self, _tmp0_, &_inner_error_);
#line 368 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	if (_inner_error_ != NULL) {
#line 368 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 368 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			g_propagate_error (error, _inner_error_);
#line 368 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			return;
#line 3428 "tracker-sparql-expression.c"
		} else {
#line 368 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 368 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			g_clear_error (&_inner_error_);
#line 368 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			return;
#line 3436 "tracker-sparql-expression.c"
		}
	}
#line 370 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	tracker_sparql_expression_expect (self, TRACKER_SPARQL_TOKEN_TYPE_CLOSE_PARENS, &_inner_error_);
#line 370 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	if (_inner_error_ != NULL) {
#line 370 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 370 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			g_propagate_error (error, _inner_error_);
#line 370 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			return;
#line 3449 "tracker-sparql-expression.c"
		} else {
#line 370 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 370 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			g_clear_error (&_inner_error_);
#line 370 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			return;
#line 3457 "tracker-sparql-expression.c"
		}
	}
}


static void tracker_sparql_expression_translate_isuri (TrackerSparqlExpression* self, GString* sql, GError** error) {
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_;
	GString* _tmp2_;
	TrackerSparqlLiteralBinding* _tmp3_;
	TrackerSparqlLiteralBinding* new_binding;
	TrackerSparqlLiteralBinding* _tmp4_;
	TrackerSparqlTokenType _tmp5_ = 0;
	TrackerSparqlQuery* _tmp17_;
	TrackerSparqlLiteralBinding* _tmp18_;
	TrackerSparqlLiteralBinding* _tmp19_;
	GError * _inner_error_ = NULL;
#line 373 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	g_return_if_fail (self != NULL);
#line 373 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	g_return_if_fail (sql != NULL);
#line 374 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	_tmp0_ = tracker_sparql_expression_accept (self, TRACKER_SPARQL_TOKEN_TYPE_ISURI, &_inner_error_);
#line 374 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	_tmp1_ = _tmp0_;
#line 374 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	if (_inner_error_ != NULL) {
#line 374 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 374 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			g_propagate_error (error, _inner_error_);
#line 374 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			return;
#line 3491 "tracker-sparql-expression.c"
		} else {
#line 374 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 374 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			g_clear_error (&_inner_error_);
#line 374 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			return;
#line 3499 "tracker-sparql-expression.c"
		}
	}
#line 374 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	if (!_tmp1_) {
#line 375 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		tracker_sparql_expression_expect (self, TRACKER_SPARQL_TOKEN_TYPE_ISIRI, &_inner_error_);
#line 375 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		if (_inner_error_ != NULL) {
#line 375 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 375 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				g_propagate_error (error, _inner_error_);
#line 375 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				return;
#line 3514 "tracker-sparql-expression.c"
			} else {
#line 375 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 375 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				g_clear_error (&_inner_error_);
#line 375 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				return;
#line 3522 "tracker-sparql-expression.c"
			}
		}
	}
#line 378 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	tracker_sparql_expression_expect (self, TRACKER_SPARQL_TOKEN_TYPE_OPEN_PARENS, &_inner_error_);
#line 378 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	if (_inner_error_ != NULL) {
#line 378 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 378 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			g_propagate_error (error, _inner_error_);
#line 378 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			return;
#line 3536 "tracker-sparql-expression.c"
		} else {
#line 378 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 378 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			g_clear_error (&_inner_error_);
#line 378 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			return;
#line 3544 "tracker-sparql-expression.c"
		}
	}
#line 380 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	_tmp2_ = sql;
#line 380 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	g_string_append (_tmp2_, "?");
#line 381 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	_tmp3_ = tracker_sparql_literal_binding_new ();
#line 381 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	new_binding = _tmp3_;
#line 382 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	_tmp4_ = new_binding;
#line 382 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	((TrackerSparqlDataBinding*) _tmp4_)->data_type = TRACKER_PROPERTY_TYPE_INTEGER;
#line 384 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	_tmp5_ = tracker_sparql_expression_current (self);
#line 384 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	if (_tmp5_ == TRACKER_SPARQL_TOKEN_TYPE_IRI_REF) {
#line 3563 "tracker-sparql-expression.c"
		TrackerSparqlLiteralBinding* _tmp6_;
		gchar* _tmp7_;
#line 385 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		_tmp6_ = new_binding;
#line 385 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		_tmp7_ = g_strdup ("1");
#line 385 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		_g_free0 (_tmp6_->literal);
#line 385 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		_tmp6_->literal = _tmp7_;
#line 386 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		tracker_sparql_expression_next (self, &_inner_error_);
#line 386 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		if (_inner_error_ != NULL) {
#line 386 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 386 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				g_propagate_error (error, _inner_error_);
#line 386 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				_g_object_unref0 (new_binding);
#line 386 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				return;
#line 3586 "tracker-sparql-expression.c"
			} else {
#line 386 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				_g_object_unref0 (new_binding);
#line 386 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 386 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				g_clear_error (&_inner_error_);
#line 386 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				return;
#line 3596 "tracker-sparql-expression.c"
			}
		}
	} else {
		GString* _tmp8_;
		GString* _tmp9_;
		TrackerPropertyType _tmp10_ = 0;
		TrackerPropertyType _tmp11_;
		TrackerPropertyType _tmp12_;
#line 387 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		_tmp8_ = g_string_new ("");
#line 387 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		_tmp9_ = _tmp8_;
#line 387 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		_tmp10_ = tracker_sparql_expression_translate_expression (self, _tmp9_, &_inner_error_);
#line 387 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		_tmp11_ = _tmp10_;
#line 387 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		_g_string_free0 (_tmp9_);
#line 387 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		_tmp12_ = _tmp11_;
#line 387 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		if (_inner_error_ != NULL) {
#line 387 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 387 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				g_propagate_error (error, _inner_error_);
#line 387 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				_g_object_unref0 (new_binding);
#line 387 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				return;
#line 3627 "tracker-sparql-expression.c"
			} else {
#line 387 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				_g_object_unref0 (new_binding);
#line 387 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 387 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				g_clear_error (&_inner_error_);
#line 387 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				return;
#line 3637 "tracker-sparql-expression.c"
			}
		}
#line 387 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		if (_tmp12_ == TRACKER_PROPERTY_TYPE_RESOURCE) {
#line 3642 "tracker-sparql-expression.c"
			TrackerSparqlLiteralBinding* _tmp13_;
			gchar* _tmp14_;
#line 388 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp13_ = new_binding;
#line 388 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp14_ = g_strdup ("1");
#line 388 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_g_free0 (_tmp13_->literal);
#line 388 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp13_->literal = _tmp14_;
#line 3653 "tracker-sparql-expression.c"
		} else {
			TrackerSparqlLiteralBinding* _tmp15_;
			gchar* _tmp16_;
#line 390 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp15_ = new_binding;
#line 390 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp16_ = g_strdup ("0");
#line 390 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_g_free0 (_tmp15_->literal);
#line 390 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp15_->literal = _tmp16_;
#line 3665 "tracker-sparql-expression.c"
		}
	}
#line 393 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	_tmp17_ = self->priv->query;
#line 393 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	_tmp18_ = new_binding;
#line 393 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	_tmp19_ = _g_object_ref0 (_tmp18_);
#line 393 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	_tmp17_->bindings = g_list_append (_tmp17_->bindings, _tmp19_);
#line 395 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	tracker_sparql_expression_expect (self, TRACKER_SPARQL_TOKEN_TYPE_CLOSE_PARENS, &_inner_error_);
#line 395 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	if (_inner_error_ != NULL) {
#line 395 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 395 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			g_propagate_error (error, _inner_error_);
#line 395 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_g_object_unref0 (new_binding);
#line 395 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			return;
#line 3688 "tracker-sparql-expression.c"
		} else {
#line 395 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_g_object_unref0 (new_binding);
#line 395 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 395 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			g_clear_error (&_inner_error_);
#line 395 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			return;
#line 3698 "tracker-sparql-expression.c"
		}
	}
#line 373 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	_g_object_unref0 (new_binding);
#line 3703 "tracker-sparql-expression.c"
}


static void tracker_sparql_expression_translate_datatype (TrackerSparqlExpression* self, GString* sql, GError** error) {
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_;
	GError * _inner_error_ = NULL;
#line 398 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	g_return_if_fail (self != NULL);
#line 398 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	g_return_if_fail (sql != NULL);
#line 399 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	tracker_sparql_expression_expect (self, TRACKER_SPARQL_TOKEN_TYPE_DATATYPE, &_inner_error_);
#line 399 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	if (_inner_error_ != NULL) {
#line 399 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 399 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			g_propagate_error (error, _inner_error_);
#line 399 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			return;
#line 3725 "tracker-sparql-expression.c"
		} else {
#line 399 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 399 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			g_clear_error (&_inner_error_);
#line 399 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			return;
#line 3733 "tracker-sparql-expression.c"
		}
	}
#line 400 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	tracker_sparql_expression_expect (self, TRACKER_SPARQL_TOKEN_TYPE_OPEN_PARENS, &_inner_error_);
#line 400 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	if (_inner_error_ != NULL) {
#line 400 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 400 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			g_propagate_error (error, _inner_error_);
#line 400 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			return;
#line 3746 "tracker-sparql-expression.c"
		} else {
#line 400 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 400 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			g_clear_error (&_inner_error_);
#line 400 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			return;
#line 3754 "tracker-sparql-expression.c"
		}
	}
#line 402 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	_tmp0_ = tracker_sparql_expression_accept (self, TRACKER_SPARQL_TOKEN_TYPE_VAR, &_inner_error_);
#line 402 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	_tmp1_ = _tmp0_;
#line 402 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	if (_inner_error_ != NULL) {
#line 402 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 402 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			g_propagate_error (error, _inner_error_);
#line 402 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			return;
#line 3769 "tracker-sparql-expression.c"
		} else {
#line 402 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 402 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			g_clear_error (&_inner_error_);
#line 402 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			return;
#line 3777 "tracker-sparql-expression.c"
		}
	}
#line 402 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	if (_tmp1_) {
#line 3782 "tracker-sparql-expression.c"
		gchar* _tmp2_ = NULL;
		gchar* _tmp3_;
		gchar* _tmp4_ = NULL;
		gchar* _tmp5_;
		gchar* variable_name;
		TrackerSparqlContext* _tmp6_;
		TrackerSparqlContext* _tmp7_;
		const gchar* _tmp8_;
		TrackerSparqlVariable* _tmp9_ = NULL;
		TrackerSparqlVariable* _tmp10_;
		TrackerSparqlVariable* variable;
		TrackerSparqlVariable* _tmp11_;
		TrackerSparqlVariableBinding* _tmp12_;
		gboolean _tmp20_ = FALSE;
		TrackerSparqlVariable* _tmp21_;
		TrackerSparqlVariableBinding* _tmp22_;
		TrackerPropertyType _tmp23_;
		gboolean _tmp27_;
		GString* _tmp29_;
		TrackerSparqlLiteralBinding* _tmp30_;
		TrackerSparqlLiteralBinding* new_binding;
		TrackerSparqlLiteralBinding* _tmp31_;
		TrackerSparqlVariable* _tmp32_;
		TrackerSparqlVariableBinding* _tmp33_;
		TrackerClass* _tmp34_;
		const gchar* _tmp35_;
		const gchar* _tmp36_;
		gchar* _tmp37_;
		TrackerSparqlQuery* _tmp38_;
		TrackerSparqlLiteralBinding* _tmp39_;
		TrackerSparqlLiteralBinding* _tmp40_;
#line 403 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		_tmp2_ = tracker_sparql_expression_get_last_string (self, 0);
#line 403 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		_tmp3_ = _tmp2_;
#line 403 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		_tmp4_ = string_substring (_tmp3_, (glong) 1, (glong) (-1));
#line 403 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		_tmp5_ = _tmp4_;
#line 403 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		_g_free0 (_tmp3_);
#line 403 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		variable_name = _tmp5_;
#line 404 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		_tmp6_ = tracker_sparql_expression_get_context (self);
#line 404 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		_tmp7_ = _tmp6_;
#line 404 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		_tmp8_ = variable_name;
#line 404 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		_tmp9_ = tracker_sparql_context_get_variable (_tmp7_, _tmp8_);
#line 404 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		_tmp10_ = _g_object_ref0 (_tmp9_);
#line 404 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		variable = _tmp10_;
#line 406 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		_tmp11_ = variable;
#line 406 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		_tmp12_ = _tmp11_->binding;
#line 406 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		if (_tmp12_ == NULL) {
#line 3844 "tracker-sparql-expression.c"
			TrackerSparqlVariable* _tmp13_;
			const gchar* _tmp14_;
			const gchar* _tmp15_;
			gchar* _tmp16_ = NULL;
			gchar* _tmp17_;
			GError* _tmp18_ = NULL;
			GError* _tmp19_;
#line 407 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp13_ = variable;
#line 407 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp14_ = tracker_sparql_variable_get_name (_tmp13_);
#line 407 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp15_ = _tmp14_;
#line 407 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp16_ = g_strdup_printf ("`%s' is not a valid variable", _tmp15_);
#line 407 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp17_ = _tmp16_;
#line 407 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp18_ = tracker_sparql_expression_get_error (self, _tmp17_);
#line 407 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp19_ = _tmp18_;
#line 407 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_g_free0 (_tmp17_);
#line 407 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_inner_error_ = _tmp19_;
#line 407 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 407 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				g_propagate_error (error, _inner_error_);
#line 407 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				_g_object_unref0 (variable);
#line 407 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				_g_free0 (variable_name);
#line 407 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				return;
#line 3880 "tracker-sparql-expression.c"
			} else {
#line 407 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				_g_object_unref0 (variable);
#line 407 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				_g_free0 (variable_name);
#line 407 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 407 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				g_clear_error (&_inner_error_);
#line 407 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				return;
#line 3892 "tracker-sparql-expression.c"
			}
		}
#line 410 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		_tmp21_ = variable;
#line 410 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		_tmp22_ = _tmp21_->binding;
#line 410 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		_tmp23_ = ((TrackerSparqlDataBinding*) _tmp22_)->data_type;
#line 410 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		if (_tmp23_ == TRACKER_PROPERTY_TYPE_RESOURCE) {
#line 410 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp20_ = TRUE;
#line 3905 "tracker-sparql-expression.c"
		} else {
			TrackerSparqlVariable* _tmp24_;
			TrackerSparqlVariableBinding* _tmp25_;
			TrackerClass* _tmp26_;
#line 410 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp24_ = variable;
#line 410 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp25_ = _tmp24_->binding;
#line 410 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp26_ = _tmp25_->type;
#line 410 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp20_ = _tmp26_ == NULL;
#line 3918 "tracker-sparql-expression.c"
		}
#line 410 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		_tmp27_ = _tmp20_;
#line 410 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		if (_tmp27_) {
#line 3924 "tracker-sparql-expression.c"
			GError* _tmp28_ = NULL;
#line 411 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp28_ = tracker_sparql_expression_get_error (self, "Invalid FILTER");
#line 411 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_inner_error_ = _tmp28_;
#line 411 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 411 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				g_propagate_error (error, _inner_error_);
#line 411 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				_g_object_unref0 (variable);
#line 411 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				_g_free0 (variable_name);
#line 411 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				return;
#line 3940 "tracker-sparql-expression.c"
			} else {
#line 411 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				_g_object_unref0 (variable);
#line 411 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				_g_free0 (variable_name);
#line 411 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 411 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				g_clear_error (&_inner_error_);
#line 411 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				return;
#line 3952 "tracker-sparql-expression.c"
			}
		}
#line 414 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		_tmp29_ = sql;
#line 414 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		g_string_append (_tmp29_, "(SELECT ID FROM Resource WHERE Uri = ?)");
#line 416 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		_tmp30_ = tracker_sparql_literal_binding_new ();
#line 416 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		new_binding = _tmp30_;
#line 417 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		_tmp31_ = new_binding;
#line 417 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		_tmp32_ = variable;
#line 417 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		_tmp33_ = _tmp32_->binding;
#line 417 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		_tmp34_ = _tmp33_->type;
#line 417 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		_tmp35_ = tracker_class_get_uri (_tmp34_);
#line 417 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		_tmp36_ = _tmp35_;
#line 417 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		_tmp37_ = g_strdup (_tmp36_);
#line 417 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		_g_free0 (_tmp31_->literal);
#line 417 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		_tmp31_->literal = _tmp37_;
#line 418 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		_tmp38_ = self->priv->query;
#line 418 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		_tmp39_ = new_binding;
#line 418 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		_tmp40_ = _g_object_ref0 (_tmp39_);
#line 418 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		_tmp38_->bindings = g_list_append (_tmp38_->bindings, _tmp40_);
#line 402 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		_g_object_unref0 (new_binding);
#line 402 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		_g_object_unref0 (variable);
#line 402 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		_g_free0 (variable_name);
#line 3995 "tracker-sparql-expression.c"
	} else {
		GError* _tmp41_ = NULL;
#line 421 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		_tmp41_ = tracker_sparql_expression_get_error (self, "Invalid FILTER");
#line 421 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		_inner_error_ = _tmp41_;
#line 421 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 421 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			g_propagate_error (error, _inner_error_);
#line 421 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			return;
#line 4008 "tracker-sparql-expression.c"
		} else {
#line 421 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 421 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			g_clear_error (&_inner_error_);
#line 421 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			return;
#line 4016 "tracker-sparql-expression.c"
		}
	}
#line 424 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	tracker_sparql_expression_expect (self, TRACKER_SPARQL_TOKEN_TYPE_CLOSE_PARENS, &_inner_error_);
#line 424 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	if (_inner_error_ != NULL) {
#line 424 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 424 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			g_propagate_error (error, _inner_error_);
#line 424 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			return;
#line 4029 "tracker-sparql-expression.c"
		} else {
#line 424 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 424 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			g_clear_error (&_inner_error_);
#line 424 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			return;
#line 4037 "tracker-sparql-expression.c"
		}
	}
}


static gchar* g_unichar_to_string (gunichar self) {
	gchar* result = NULL;
	gchar* _tmp0_ = NULL;
	gchar* str;
	const gchar* _tmp1_;
#line 841 "/usr/share/vala-0.14/vapi/glib-2.0.vapi"
	_tmp0_ = g_new0 (gchar, 7);
#line 841 "/usr/share/vala-0.14/vapi/glib-2.0.vapi"
	str = (gchar*) _tmp0_;
#line 842 "/usr/share/vala-0.14/vapi/glib-2.0.vapi"
	_tmp1_ = str;
#line 842 "/usr/share/vala-0.14/vapi/glib-2.0.vapi"
	g_unichar_to_utf8 (self, _tmp1_);
#line 843 "/usr/share/vala-0.14/vapi/glib-2.0.vapi"
	result = str;
#line 843 "/usr/share/vala-0.14/vapi/glib-2.0.vapi"
	return result;
#line 4060 "tracker-sparql-expression.c"
}


static TrackerPropertyType tracker_sparql_expression_translate_function (TrackerSparqlExpression* self, GString* sql, const gchar* uri, GError** error) {
	TrackerPropertyType result = 0;
	const gchar* _tmp0_;
	GError * _inner_error_ = NULL;
#line 427 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	g_return_val_if_fail (self != NULL, 0);
#line 427 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	g_return_val_if_fail (sql != NULL, 0);
#line 427 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	g_return_val_if_fail (uri != NULL, 0);
#line 428 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	_tmp0_ = uri;
#line 428 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	if (g_strcmp0 (_tmp0_, TRACKER_SPARQL_EXPRESSION_XSD_NS "string") == 0) {
#line 4078 "tracker-sparql-expression.c"
		GString* _tmp1_;
#line 430 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		_tmp1_ = sql;
#line 430 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		tracker_sparql_expression_translate_expression_as_string (self, _tmp1_, &_inner_error_);
#line 430 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		if (_inner_error_ != NULL) {
#line 430 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 430 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				g_propagate_error (error, _inner_error_);
#line 430 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				return 0;
#line 4092 "tracker-sparql-expression.c"
			} else {
#line 430 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 430 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				g_clear_error (&_inner_error_);
#line 430 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				return 0;
#line 4100 "tracker-sparql-expression.c"
			}
		}
#line 432 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		result = TRACKER_PROPERTY_TYPE_STRING;
#line 432 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		return result;
#line 4107 "tracker-sparql-expression.c"
	} else {
		const gchar* _tmp2_;
#line 433 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		_tmp2_ = uri;
#line 433 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		if (g_strcmp0 (_tmp2_, TRACKER_SPARQL_EXPRESSION_XSD_NS "integer") == 0) {
#line 4114 "tracker-sparql-expression.c"
			GString* _tmp3_;
			GString* _tmp4_;
			GString* _tmp5_;
#line 435 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp3_ = sql;
#line 435 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			g_string_append (_tmp3_, "CAST (");
#line 436 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp4_ = sql;
#line 436 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			tracker_sparql_expression_translate_expression_as_string (self, _tmp4_, &_inner_error_);
#line 436 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			if (_inner_error_ != NULL) {
#line 436 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 436 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_propagate_error (error, _inner_error_);
#line 436 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					return 0;
#line 4134 "tracker-sparql-expression.c"
				} else {
#line 436 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 436 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_clear_error (&_inner_error_);
#line 436 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					return 0;
#line 4142 "tracker-sparql-expression.c"
				}
			}
#line 437 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp5_ = sql;
#line 437 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			g_string_append (_tmp5_, " AS INTEGER)");
#line 439 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			result = TRACKER_PROPERTY_TYPE_INTEGER;
#line 439 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			return result;
#line 4153 "tracker-sparql-expression.c"
		} else {
			const gchar* _tmp6_;
#line 440 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp6_ = uri;
#line 440 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			if (g_strcmp0 (_tmp6_, TRACKER_SPARQL_EXPRESSION_XSD_NS "double") == 0) {
#line 4160 "tracker-sparql-expression.c"
				GString* _tmp7_;
				GString* _tmp8_;
				GString* _tmp9_;
#line 442 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				_tmp7_ = sql;
#line 442 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				g_string_append (_tmp7_, "CAST (");
#line 443 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				_tmp8_ = sql;
#line 443 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				tracker_sparql_expression_translate_expression_as_string (self, _tmp8_, &_inner_error_);
#line 443 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				if (_inner_error_ != NULL) {
#line 443 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 443 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
						g_propagate_error (error, _inner_error_);
#line 443 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
						return 0;
#line 4180 "tracker-sparql-expression.c"
					} else {
#line 443 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 443 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
						g_clear_error (&_inner_error_);
#line 443 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
						return 0;
#line 4188 "tracker-sparql-expression.c"
					}
				}
#line 444 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				_tmp9_ = sql;
#line 444 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				g_string_append (_tmp9_, " AS REAL)");
#line 446 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				result = TRACKER_PROPERTY_TYPE_DOUBLE;
#line 446 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				return result;
#line 4199 "tracker-sparql-expression.c"
			} else {
				const gchar* _tmp10_;
#line 447 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				_tmp10_ = uri;
#line 447 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				if (g_strcmp0 (_tmp10_, TRACKER_SPARQL_EXPRESSION_TRACKER_NS "case-fold") == 0) {
#line 4206 "tracker-sparql-expression.c"
					GString* _tmp11_;
					GString* _tmp12_;
					GString* _tmp13_;
#line 449 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					_tmp11_ = sql;
#line 449 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_string_append (_tmp11_, "SparqlCaseFold (");
#line 450 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					_tmp12_ = sql;
#line 450 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					tracker_sparql_expression_translate_expression_as_string (self, _tmp12_, &_inner_error_);
#line 450 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					if (_inner_error_ != NULL) {
#line 450 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
						if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 450 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
							g_propagate_error (error, _inner_error_);
#line 450 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
							return 0;
#line 4226 "tracker-sparql-expression.c"
						} else {
#line 450 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
							g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 450 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
							g_clear_error (&_inner_error_);
#line 450 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
							return 0;
#line 4234 "tracker-sparql-expression.c"
						}
					}
#line 451 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					_tmp13_ = sql;
#line 451 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_string_append (_tmp13_, ")");
#line 452 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					result = TRACKER_PROPERTY_TYPE_STRING;
#line 452 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					return result;
#line 4245 "tracker-sparql-expression.c"
				} else {
					const gchar* _tmp14_;
#line 453 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					_tmp14_ = uri;
#line 453 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					if (g_strcmp0 (_tmp14_, TRACKER_SPARQL_EXPRESSION_TRACKER_NS "ascii-lower-case") == 0) {
#line 4252 "tracker-sparql-expression.c"
						GString* _tmp15_;
						GString* _tmp16_;
						GString* _tmp17_;
#line 455 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
						_tmp15_ = sql;
#line 455 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
						g_string_append (_tmp15_, "lower (");
#line 456 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
						_tmp16_ = sql;
#line 456 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
						tracker_sparql_expression_translate_expression_as_string (self, _tmp16_, &_inner_error_);
#line 456 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
						if (_inner_error_ != NULL) {
#line 456 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
							if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 456 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
								g_propagate_error (error, _inner_error_);
#line 456 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
								return 0;
#line 4272 "tracker-sparql-expression.c"
							} else {
#line 456 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
								g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 456 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
								g_clear_error (&_inner_error_);
#line 456 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
								return 0;
#line 4280 "tracker-sparql-expression.c"
							}
						}
#line 457 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
						_tmp17_ = sql;
#line 457 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
						g_string_append (_tmp17_, ")");
#line 458 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
						result = TRACKER_PROPERTY_TYPE_STRING;
#line 458 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
						return result;
#line 4291 "tracker-sparql-expression.c"
					} else {
						const gchar* _tmp18_;
#line 459 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
						_tmp18_ = uri;
#line 459 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
						if (g_strcmp0 (_tmp18_, TRACKER_SPARQL_EXPRESSION_FN_NS "lower-case") == 0) {
#line 4298 "tracker-sparql-expression.c"
							GString* _tmp19_;
							GString* _tmp20_;
							GString* _tmp21_;
#line 461 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
							_tmp19_ = sql;
#line 461 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
							g_string_append (_tmp19_, "SparqlLowerCase (");
#line 462 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
							_tmp20_ = sql;
#line 462 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
							tracker_sparql_expression_translate_expression_as_string (self, _tmp20_, &_inner_error_);
#line 462 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
							if (_inner_error_ != NULL) {
#line 462 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
								if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 462 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
									g_propagate_error (error, _inner_error_);
#line 462 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
									return 0;
#line 4318 "tracker-sparql-expression.c"
								} else {
#line 462 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
									g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 462 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
									g_clear_error (&_inner_error_);
#line 462 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
									return 0;
#line 4326 "tracker-sparql-expression.c"
								}
							}
#line 463 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
							_tmp21_ = sql;
#line 463 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
							g_string_append (_tmp21_, ")");
#line 464 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
							result = TRACKER_PROPERTY_TYPE_STRING;
#line 464 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
							return result;
#line 4337 "tracker-sparql-expression.c"
						} else {
							const gchar* _tmp22_;
#line 465 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
							_tmp22_ = uri;
#line 465 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
							if (g_strcmp0 (_tmp22_, TRACKER_SPARQL_EXPRESSION_FN_NS "contains") == 0) {
#line 4344 "tracker-sparql-expression.c"
								GString* _tmp23_;
								GString* _tmp24_;
								GString* _tmp25_;
								GString* _tmp26_;
								TrackerSparqlLiteralBinding* _tmp27_;
								TrackerSparqlLiteralBinding* binding;
								gchar* _tmp28_ = NULL;
								gchar* _tmp29_;
								TrackerSparqlLiteralBinding* _tmp30_;
								gchar* _tmp31_;
								gchar* _tmp32_ = NULL;
								TrackerSparqlQuery* _tmp33_;
								TrackerSparqlLiteralBinding* _tmp34_;
								TrackerSparqlLiteralBinding* _tmp35_;
								GString* _tmp36_;
#line 467 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
								_tmp23_ = sql;
#line 467 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
								g_string_append (_tmp23_, "(");
#line 468 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
								_tmp24_ = sql;
#line 468 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
								tracker_sparql_expression_translate_expression_as_string (self, _tmp24_, &_inner_error_);
#line 468 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
								if (_inner_error_ != NULL) {
#line 468 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
									if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 468 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
										g_propagate_error (error, _inner_error_);
#line 468 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
										return 0;
#line 4376 "tracker-sparql-expression.c"
									} else {
#line 468 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
										g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 468 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
										g_clear_error (&_inner_error_);
#line 468 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
										return 0;
#line 4384 "tracker-sparql-expression.c"
									}
								}
#line 469 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
								_tmp25_ = sql;
#line 469 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
								g_string_append (_tmp25_, " GLOB ");
#line 470 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
								tracker_sparql_expression_expect (self, TRACKER_SPARQL_TOKEN_TYPE_COMMA, &_inner_error_);
#line 470 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
								if (_inner_error_ != NULL) {
#line 470 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
									if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 470 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
										g_propagate_error (error, _inner_error_);
#line 470 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
										return 0;
#line 4401 "tracker-sparql-expression.c"
									} else {
#line 470 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
										g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 470 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
										g_clear_error (&_inner_error_);
#line 470 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
										return 0;
#line 4409 "tracker-sparql-expression.c"
									}
								}
#line 472 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
								_tmp26_ = sql;
#line 472 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
								g_string_append (_tmp26_, "?");
#line 473 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
								_tmp27_ = tracker_sparql_literal_binding_new ();
#line 473 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
								binding = _tmp27_;
#line 474 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
								_tmp28_ = tracker_sparql_expression_parse_string_literal (self, NULL, &_inner_error_);
#line 474 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
								_tmp29_ = _tmp28_;
#line 474 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
								if (_inner_error_ != NULL) {
#line 474 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
									if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 474 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
										g_propagate_error (error, _inner_error_);
#line 474 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
										_g_object_unref0 (binding);
#line 474 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
										return 0;
#line 4434 "tracker-sparql-expression.c"
									} else {
#line 474 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
										_g_object_unref0 (binding);
#line 474 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
										g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 474 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
										g_clear_error (&_inner_error_);
#line 474 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
										return 0;
#line 4444 "tracker-sparql-expression.c"
									}
								}
#line 474 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
								_tmp30_ = binding;
#line 474 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
								_tmp31_ = _tmp29_;
#line 474 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
								_tmp32_ = g_strdup_printf ("*%s*", _tmp31_);
#line 474 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
								_g_free0 (_tmp30_->literal);
#line 474 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
								_tmp30_->literal = _tmp32_;
#line 474 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
								_g_free0 (_tmp31_);
#line 475 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
								_tmp33_ = self->priv->query;
#line 475 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
								_tmp34_ = binding;
#line 475 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
								_tmp35_ = _g_object_ref0 (_tmp34_);
#line 475 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
								_tmp33_->bindings = g_list_append (_tmp33_->bindings, _tmp35_);
#line 477 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
								_tmp36_ = sql;
#line 477 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
								g_string_append (_tmp36_, ")");
#line 479 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
								result = TRACKER_PROPERTY_TYPE_BOOLEAN;
#line 479 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
								_g_object_unref0 (binding);
#line 479 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
								return result;
#line 4477 "tracker-sparql-expression.c"
							} else {
								const gchar* _tmp37_;
#line 480 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
								_tmp37_ = uri;
#line 480 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
								if (g_strcmp0 (_tmp37_, TRACKER_SPARQL_EXPRESSION_FN_NS "starts-with") == 0) {
#line 4484 "tracker-sparql-expression.c"
									GString* _tmp38_;
									GString* _tmp39_;
									gchar* _tmp40_ = NULL;
									gchar* prefix;
									GString* _tmp41_;
									TrackerSparqlLiteralBinding* _tmp42_;
									TrackerSparqlLiteralBinding* binding;
									TrackerSparqlLiteralBinding* _tmp43_;
									const gchar* _tmp44_;
									gchar* _tmp45_;
									TrackerSparqlQuery* _tmp46_;
									TrackerSparqlLiteralBinding* _tmp47_;
									TrackerSparqlLiteralBinding* _tmp48_;
									GString* _tmp49_;
									GString* _tmp50_;
									TrackerSparqlLiteralBinding* _tmp51_;
									TrackerSparqlLiteralBinding* _tmp52_;
									const gchar* _tmp53_;
									gchar* _tmp54_ = NULL;
									gchar* _tmp55_;
									gchar* _tmp56_;
									TrackerSparqlQuery* _tmp57_;
									TrackerSparqlLiteralBinding* _tmp58_;
									TrackerSparqlLiteralBinding* _tmp59_;
#line 484 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
									_tmp38_ = sql;
#line 484 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
									tracker_sparql_expression_translate_expression_as_string (self, _tmp38_, &_inner_error_);
#line 484 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
									if (_inner_error_ != NULL) {
#line 484 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
										if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 484 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
											g_propagate_error (error, _inner_error_);
#line 484 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
											return 0;
#line 4521 "tracker-sparql-expression.c"
										} else {
#line 484 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
											g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 484 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
											g_clear_error (&_inner_error_);
#line 484 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
											return 0;
#line 4529 "tracker-sparql-expression.c"
										}
									}
#line 485 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
									_tmp39_ = sql;
#line 485 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
									g_string_append (_tmp39_, " BETWEEN ");
#line 487 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
									tracker_sparql_expression_expect (self, TRACKER_SPARQL_TOKEN_TYPE_COMMA, &_inner_error_);
#line 487 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
									if (_inner_error_ != NULL) {
#line 487 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
										if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 487 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
											g_propagate_error (error, _inner_error_);
#line 487 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
											return 0;
#line 4546 "tracker-sparql-expression.c"
										} else {
#line 487 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
											g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 487 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
											g_clear_error (&_inner_error_);
#line 487 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
											return 0;
#line 4554 "tracker-sparql-expression.c"
										}
									}
#line 488 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
									_tmp40_ = tracker_sparql_expression_parse_string_literal (self, NULL, &_inner_error_);
#line 488 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
									prefix = _tmp40_;
#line 488 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
									if (_inner_error_ != NULL) {
#line 488 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
										if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 488 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
											g_propagate_error (error, _inner_error_);
#line 488 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
											return 0;
#line 4569 "tracker-sparql-expression.c"
										} else {
#line 488 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
											g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 488 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
											g_clear_error (&_inner_error_);
#line 488 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
											return 0;
#line 4577 "tracker-sparql-expression.c"
										}
									}
#line 490 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
									_tmp41_ = sql;
#line 490 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
									g_string_append (_tmp41_, "?");
#line 491 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
									_tmp42_ = tracker_sparql_literal_binding_new ();
#line 491 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
									binding = _tmp42_;
#line 492 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
									_tmp43_ = binding;
#line 492 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
									_tmp44_ = prefix;
#line 492 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
									_tmp45_ = g_strdup (_tmp44_);
#line 492 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
									_g_free0 (_tmp43_->literal);
#line 492 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
									_tmp43_->literal = _tmp45_;
#line 493 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
									_tmp46_ = self->priv->query;
#line 493 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
									_tmp47_ = binding;
#line 493 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
									_tmp48_ = _g_object_ref0 (_tmp47_);
#line 493 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
									_tmp46_->bindings = g_list_append (_tmp46_->bindings, _tmp48_);
#line 495 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
									_tmp49_ = sql;
#line 495 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
									g_string_append (_tmp49_, " AND ");
#line 497 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
									_tmp50_ = sql;
#line 497 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
									g_string_append (_tmp50_, "?");
#line 498 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
									_tmp51_ = tracker_sparql_literal_binding_new ();
#line 498 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
									_g_object_unref0 (binding);
#line 498 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
									binding = _tmp51_;
#line 499 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
									_tmp52_ = binding;
#line 499 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
									_tmp53_ = prefix;
#line 499 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
									_tmp54_ = g_unichar_to_string (TRACKER_COLLATION_LAST_CHAR);
#line 499 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
									_tmp55_ = _tmp54_;
#line 499 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
									_tmp56_ = g_strconcat (_tmp53_, _tmp55_, NULL);
#line 499 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
									_g_free0 (_tmp52_->literal);
#line 499 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
									_tmp52_->literal = _tmp56_;
#line 499 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
									_g_free0 (_tmp55_);
#line 500 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
									_tmp57_ = self->priv->query;
#line 500 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
									_tmp58_ = binding;
#line 500 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
									_tmp59_ = _g_object_ref0 (_tmp58_);
#line 500 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
									_tmp57_->bindings = g_list_append (_tmp57_->bindings, _tmp59_);
#line 502 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
									result = TRACKER_PROPERTY_TYPE_BOOLEAN;
#line 502 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
									_g_object_unref0 (binding);
#line 502 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
									_g_free0 (prefix);
#line 502 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
									return result;
#line 4652 "tracker-sparql-expression.c"
								} else {
									const gchar* _tmp60_;
#line 503 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
									_tmp60_ = uri;
#line 503 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
									if (g_strcmp0 (_tmp60_, TRACKER_SPARQL_EXPRESSION_FN_NS "ends-with") == 0) {
#line 4659 "tracker-sparql-expression.c"
										GString* _tmp61_;
										GString* _tmp62_;
										GString* _tmp63_;
										GString* _tmp64_;
										TrackerSparqlLiteralBinding* _tmp65_;
										TrackerSparqlLiteralBinding* binding;
										gchar* _tmp66_ = NULL;
										gchar* _tmp67_;
										TrackerSparqlLiteralBinding* _tmp68_;
										gchar* _tmp69_;
										gchar* _tmp70_ = NULL;
										TrackerSparqlQuery* _tmp71_;
										TrackerSparqlLiteralBinding* _tmp72_;
										TrackerSparqlLiteralBinding* _tmp73_;
										GString* _tmp74_;
#line 505 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
										_tmp61_ = sql;
#line 505 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
										g_string_append (_tmp61_, "(");
#line 506 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
										_tmp62_ = sql;
#line 506 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
										tracker_sparql_expression_translate_expression_as_string (self, _tmp62_, &_inner_error_);
#line 506 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
										if (_inner_error_ != NULL) {
#line 506 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
											if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 506 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
												g_propagate_error (error, _inner_error_);
#line 506 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
												return 0;
#line 4691 "tracker-sparql-expression.c"
											} else {
#line 506 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
												g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 506 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
												g_clear_error (&_inner_error_);
#line 506 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
												return 0;
#line 4699 "tracker-sparql-expression.c"
											}
										}
#line 507 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
										_tmp63_ = sql;
#line 507 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
										g_string_append (_tmp63_, " GLOB ");
#line 508 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
										tracker_sparql_expression_expect (self, TRACKER_SPARQL_TOKEN_TYPE_COMMA, &_inner_error_);
#line 508 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
										if (_inner_error_ != NULL) {
#line 508 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
											if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 508 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
												g_propagate_error (error, _inner_error_);
#line 508 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
												return 0;
#line 4716 "tracker-sparql-expression.c"
											} else {
#line 508 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
												g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 508 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
												g_clear_error (&_inner_error_);
#line 508 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
												return 0;
#line 4724 "tracker-sparql-expression.c"
											}
										}
#line 510 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
										_tmp64_ = sql;
#line 510 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
										g_string_append (_tmp64_, "?");
#line 511 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
										_tmp65_ = tracker_sparql_literal_binding_new ();
#line 511 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
										binding = _tmp65_;
#line 512 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
										_tmp66_ = tracker_sparql_expression_parse_string_literal (self, NULL, &_inner_error_);
#line 512 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
										_tmp67_ = _tmp66_;
#line 512 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
										if (_inner_error_ != NULL) {
#line 512 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
											if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 512 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
												g_propagate_error (error, _inner_error_);
#line 512 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
												_g_object_unref0 (binding);
#line 512 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
												return 0;
#line 4749 "tracker-sparql-expression.c"
											} else {
#line 512 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
												_g_object_unref0 (binding);
#line 512 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
												g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 512 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
												g_clear_error (&_inner_error_);
#line 512 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
												return 0;
#line 4759 "tracker-sparql-expression.c"
											}
										}
#line 512 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
										_tmp68_ = binding;
#line 512 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
										_tmp69_ = _tmp67_;
#line 512 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
										_tmp70_ = g_strdup_printf ("*%s", _tmp69_);
#line 512 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
										_g_free0 (_tmp68_->literal);
#line 512 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
										_tmp68_->literal = _tmp70_;
#line 512 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
										_g_free0 (_tmp69_);
#line 513 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
										_tmp71_ = self->priv->query;
#line 513 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
										_tmp72_ = binding;
#line 513 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
										_tmp73_ = _g_object_ref0 (_tmp72_);
#line 513 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
										_tmp71_->bindings = g_list_append (_tmp71_->bindings, _tmp73_);
#line 515 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
										_tmp74_ = sql;
#line 515 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
										g_string_append (_tmp74_, ")");
#line 517 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
										result = TRACKER_PROPERTY_TYPE_BOOLEAN;
#line 517 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
										_g_object_unref0 (binding);
#line 517 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
										return result;
#line 4792 "tracker-sparql-expression.c"
									} else {
										const gchar* _tmp75_;
#line 518 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
										_tmp75_ = uri;
#line 518 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
										if (g_strcmp0 (_tmp75_, TRACKER_SPARQL_EXPRESSION_FN_NS "substring") == 0) {
#line 4799 "tracker-sparql-expression.c"
											GString* _tmp76_;
											GString* _tmp77_;
											GString* _tmp78_;
											GString* _tmp79_;
											gboolean _tmp80_ = FALSE;
											gboolean _tmp81_;
											GString* _tmp84_;
#line 519 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
											_tmp76_ = sql;
#line 519 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
											g_string_append (_tmp76_, "substr(");
#line 520 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
											_tmp77_ = sql;
#line 520 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
											tracker_sparql_expression_translate_expression_as_string (self, _tmp77_, &_inner_error_);
#line 520 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
											if (_inner_error_ != NULL) {
#line 520 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
												if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 520 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
													g_propagate_error (error, _inner_error_);
#line 520 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
													return 0;
#line 4823 "tracker-sparql-expression.c"
												} else {
#line 520 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
													g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 520 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
													g_clear_error (&_inner_error_);
#line 520 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
													return 0;
#line 4831 "tracker-sparql-expression.c"
												}
											}
#line 522 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
											_tmp78_ = sql;
#line 522 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
											g_string_append (_tmp78_, ", ");
#line 523 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
											tracker_sparql_expression_expect (self, TRACKER_SPARQL_TOKEN_TYPE_COMMA, &_inner_error_);
#line 523 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
											if (_inner_error_ != NULL) {
#line 523 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
												if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 523 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
													g_propagate_error (error, _inner_error_);
#line 523 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
													return 0;
#line 4848 "tracker-sparql-expression.c"
												} else {
#line 523 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
													g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 523 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
													g_clear_error (&_inner_error_);
#line 523 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
													return 0;
#line 4856 "tracker-sparql-expression.c"
												}
											}
#line 524 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
											_tmp79_ = sql;
#line 524 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
											tracker_sparql_expression_translate_expression_as_string (self, _tmp79_, &_inner_error_);
#line 524 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
											if (_inner_error_ != NULL) {
#line 524 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
												if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 524 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
													g_propagate_error (error, _inner_error_);
#line 524 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
													return 0;
#line 4871 "tracker-sparql-expression.c"
												} else {
#line 524 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
													g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 524 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
													g_clear_error (&_inner_error_);
#line 524 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
													return 0;
#line 4879 "tracker-sparql-expression.c"
												}
											}
#line 526 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
											_tmp80_ = tracker_sparql_expression_accept (self, TRACKER_SPARQL_TOKEN_TYPE_COMMA, &_inner_error_);
#line 526 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
											_tmp81_ = _tmp80_;
#line 526 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
											if (_inner_error_ != NULL) {
#line 526 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
												if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 526 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
													g_propagate_error (error, _inner_error_);
#line 526 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
													return 0;
#line 4894 "tracker-sparql-expression.c"
												} else {
#line 526 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
													g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 526 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
													g_clear_error (&_inner_error_);
#line 526 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
													return 0;
#line 4902 "tracker-sparql-expression.c"
												}
											}
#line 526 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
											if (_tmp81_) {
#line 4907 "tracker-sparql-expression.c"
												GString* _tmp82_;
												GString* _tmp83_;
#line 527 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
												_tmp82_ = sql;
#line 527 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
												g_string_append (_tmp82_, ", ");
#line 528 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
												_tmp83_ = sql;
#line 528 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
												tracker_sparql_expression_translate_expression_as_string (self, _tmp83_, &_inner_error_);
#line 528 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
												if (_inner_error_ != NULL) {
#line 528 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
													if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 528 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
														g_propagate_error (error, _inner_error_);
#line 528 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
														return 0;
#line 4926 "tracker-sparql-expression.c"
													} else {
#line 528 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
														g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 528 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
														g_clear_error (&_inner_error_);
#line 528 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
														return 0;
#line 4934 "tracker-sparql-expression.c"
													}
												}
											}
#line 531 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
											_tmp84_ = sql;
#line 531 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
											g_string_append (_tmp84_, ")");
#line 533 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
											result = TRACKER_PROPERTY_TYPE_STRING;
#line 533 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
											return result;
#line 4946 "tracker-sparql-expression.c"
										} else {
											const gchar* _tmp85_;
#line 534 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
											_tmp85_ = uri;
#line 534 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
											if (g_strcmp0 (_tmp85_, TRACKER_SPARQL_EXPRESSION_FN_NS "concat") == 0) {
#line 4953 "tracker-sparql-expression.c"
												GString* _tmp86_;
												GString* _tmp87_;
												GString* _tmp88_;
#line 535 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
												_tmp86_ = sql;
#line 535 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
												tracker_sparql_expression_translate_expression_as_string (self, _tmp86_, &_inner_error_);
#line 535 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
												if (_inner_error_ != NULL) {
#line 535 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
													if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 535 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
														g_propagate_error (error, _inner_error_);
#line 535 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
														return 0;
#line 4969 "tracker-sparql-expression.c"
													} else {
#line 535 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
														g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 535 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
														g_clear_error (&_inner_error_);
#line 535 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
														return 0;
#line 4977 "tracker-sparql-expression.c"
													}
												}
#line 536 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
												_tmp87_ = sql;
#line 536 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
												g_string_append (_tmp87_, "||");
#line 537 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
												tracker_sparql_expression_expect (self, TRACKER_SPARQL_TOKEN_TYPE_COMMA, &_inner_error_);
#line 537 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
												if (_inner_error_ != NULL) {
#line 537 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
													if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 537 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
														g_propagate_error (error, _inner_error_);
#line 537 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
														return 0;
#line 4994 "tracker-sparql-expression.c"
													} else {
#line 537 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
														g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 537 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
														g_clear_error (&_inner_error_);
#line 537 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
														return 0;
#line 5002 "tracker-sparql-expression.c"
													}
												}
#line 538 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
												_tmp88_ = sql;
#line 538 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
												tracker_sparql_expression_translate_expression_as_string (self, _tmp88_, &_inner_error_);
#line 538 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
												if (_inner_error_ != NULL) {
#line 538 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
													if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 538 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
														g_propagate_error (error, _inner_error_);
#line 538 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
														return 0;
#line 5017 "tracker-sparql-expression.c"
													} else {
#line 538 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
														g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 538 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
														g_clear_error (&_inner_error_);
#line 538 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
														return 0;
#line 5025 "tracker-sparql-expression.c"
													}
												}
#line 539 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
												while (TRUE) {
#line 5030 "tracker-sparql-expression.c"
													gboolean _tmp89_ = FALSE;
													gboolean _tmp90_;
													GString* _tmp91_;
													GString* _tmp92_;
#line 539 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
													_tmp89_ = tracker_sparql_expression_accept (self, TRACKER_SPARQL_TOKEN_TYPE_COMMA, &_inner_error_);
#line 539 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
													_tmp90_ = _tmp89_;
#line 539 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
													if (_inner_error_ != NULL) {
#line 539 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
														if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 539 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
															g_propagate_error (error, _inner_error_);
#line 539 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
															return 0;
#line 5047 "tracker-sparql-expression.c"
														} else {
#line 539 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
															g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 539 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
															g_clear_error (&_inner_error_);
#line 539 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
															return 0;
#line 5055 "tracker-sparql-expression.c"
														}
													}
#line 539 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
													if (!_tmp90_) {
#line 539 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
														break;
#line 5062 "tracker-sparql-expression.c"
													}
#line 540 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
													_tmp91_ = sql;
#line 540 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
													g_string_append (_tmp91_, "||");
#line 541 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
													_tmp92_ = sql;
#line 541 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
													tracker_sparql_expression_translate_expression_as_string (self, _tmp92_, &_inner_error_);
#line 541 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
													if (_inner_error_ != NULL) {
#line 541 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
														if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 541 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
															g_propagate_error (error, _inner_error_);
#line 541 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
															return 0;
#line 5080 "tracker-sparql-expression.c"
														} else {
#line 541 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
															g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 541 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
															g_clear_error (&_inner_error_);
#line 541 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
															return 0;
#line 5088 "tracker-sparql-expression.c"
														}
													}
												}
#line 544 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
												result = TRACKER_PROPERTY_TYPE_STRING;
#line 544 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
												return result;
#line 5096 "tracker-sparql-expression.c"
											} else {
												const gchar* _tmp93_;
#line 545 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
												_tmp93_ = uri;
#line 545 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
												if (g_strcmp0 (_tmp93_, TRACKER_SPARQL_EXPRESSION_FN_NS "string-join") == 0) {
#line 5103 "tracker-sparql-expression.c"
													GString* _tmp94_;
													GString* _tmp95_;
													GString* _tmp96_;
													GString* _tmp97_;
													GString* _tmp102_;
													GString* _tmp103_;
													GString* _tmp104_;
#line 546 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
													_tmp94_ = sql;
#line 546 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
													g_string_append (_tmp94_, "SparqlStringJoin(");
#line 547 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
													tracker_sparql_expression_expect (self, TRACKER_SPARQL_TOKEN_TYPE_OPEN_PARENS, &_inner_error_);
#line 547 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
													if (_inner_error_ != NULL) {
#line 547 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
														if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 547 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
															g_propagate_error (error, _inner_error_);
#line 547 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
															return 0;
#line 5125 "tracker-sparql-expression.c"
														} else {
#line 547 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
															g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 547 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
															g_clear_error (&_inner_error_);
#line 547 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
															return 0;
#line 5133 "tracker-sparql-expression.c"
														}
													}
#line 549 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
													_tmp95_ = sql;
#line 549 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
													tracker_sparql_expression_translate_expression_as_string (self, _tmp95_, &_inner_error_);
#line 549 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
													if (_inner_error_ != NULL) {
#line 549 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
														if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 549 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
															g_propagate_error (error, _inner_error_);
#line 549 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
															return 0;
#line 5148 "tracker-sparql-expression.c"
														} else {
#line 549 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
															g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 549 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
															g_clear_error (&_inner_error_);
#line 549 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
															return 0;
#line 5156 "tracker-sparql-expression.c"
														}
													}
#line 550 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
													_tmp96_ = sql;
#line 550 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
													g_string_append (_tmp96_, ", ");
#line 551 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
													tracker_sparql_expression_expect (self, TRACKER_SPARQL_TOKEN_TYPE_COMMA, &_inner_error_);
#line 551 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
													if (_inner_error_ != NULL) {
#line 551 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
														if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 551 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
															g_propagate_error (error, _inner_error_);
#line 551 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
															return 0;
#line 5173 "tracker-sparql-expression.c"
														} else {
#line 551 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
															g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 551 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
															g_clear_error (&_inner_error_);
#line 551 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
															return 0;
#line 5181 "tracker-sparql-expression.c"
														}
													}
#line 552 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
													_tmp97_ = sql;
#line 552 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
													tracker_sparql_expression_translate_expression_as_string (self, _tmp97_, &_inner_error_);
#line 552 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
													if (_inner_error_ != NULL) {
#line 552 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
														if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 552 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
															g_propagate_error (error, _inner_error_);
#line 552 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
															return 0;
#line 5196 "tracker-sparql-expression.c"
														} else {
#line 552 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
															g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 552 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
															g_clear_error (&_inner_error_);
#line 552 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
															return 0;
#line 5204 "tracker-sparql-expression.c"
														}
													}
#line 553 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
													while (TRUE) {
#line 5209 "tracker-sparql-expression.c"
														gboolean _tmp98_ = FALSE;
														gboolean _tmp99_;
														GString* _tmp100_;
														GString* _tmp101_;
#line 553 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
														_tmp98_ = tracker_sparql_expression_accept (self, TRACKER_SPARQL_TOKEN_TYPE_COMMA, &_inner_error_);
#line 553 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
														_tmp99_ = _tmp98_;
#line 553 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
														if (_inner_error_ != NULL) {
#line 553 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
															if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 553 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																g_propagate_error (error, _inner_error_);
#line 553 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																return 0;
#line 5226 "tracker-sparql-expression.c"
															} else {
#line 553 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 553 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																g_clear_error (&_inner_error_);
#line 553 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																return 0;
#line 5234 "tracker-sparql-expression.c"
															}
														}
#line 553 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
														if (!_tmp99_) {
#line 553 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
															break;
#line 5241 "tracker-sparql-expression.c"
														}
#line 554 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
														_tmp100_ = sql;
#line 554 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
														g_string_append (_tmp100_, ", ");
#line 555 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
														_tmp101_ = sql;
#line 555 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
														tracker_sparql_expression_translate_expression_as_string (self, _tmp101_, &_inner_error_);
#line 555 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
														if (_inner_error_ != NULL) {
#line 555 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
															if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 555 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																g_propagate_error (error, _inner_error_);
#line 555 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																return 0;
#line 5259 "tracker-sparql-expression.c"
															} else {
#line 555 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 555 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																g_clear_error (&_inner_error_);
#line 555 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																return 0;
#line 5267 "tracker-sparql-expression.c"
															}
														}
													}
#line 558 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
													tracker_sparql_expression_expect (self, TRACKER_SPARQL_TOKEN_TYPE_CLOSE_PARENS, &_inner_error_);
#line 558 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
													if (_inner_error_ != NULL) {
#line 558 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
														if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 558 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
															g_propagate_error (error, _inner_error_);
#line 558 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
															return 0;
#line 5281 "tracker-sparql-expression.c"
														} else {
#line 558 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
															g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 558 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
															g_clear_error (&_inner_error_);
#line 558 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
															return 0;
#line 5289 "tracker-sparql-expression.c"
														}
													}
#line 559 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
													_tmp102_ = sql;
#line 559 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
													g_string_append (_tmp102_, ",");
#line 560 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
													tracker_sparql_expression_expect (self, TRACKER_SPARQL_TOKEN_TYPE_COMMA, &_inner_error_);
#line 560 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
													if (_inner_error_ != NULL) {
#line 560 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
														if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 560 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
															g_propagate_error (error, _inner_error_);
#line 560 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
															return 0;
#line 5306 "tracker-sparql-expression.c"
														} else {
#line 560 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
															g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 560 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
															g_clear_error (&_inner_error_);
#line 560 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
															return 0;
#line 5314 "tracker-sparql-expression.c"
														}
													}
#line 561 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
													_tmp103_ = sql;
#line 561 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
													tracker_sparql_expression_translate_expression (self, _tmp103_, &_inner_error_);
#line 561 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
													if (_inner_error_ != NULL) {
#line 561 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
														if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 561 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
															g_propagate_error (error, _inner_error_);
#line 561 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
															return 0;
#line 5329 "tracker-sparql-expression.c"
														} else {
#line 561 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
															g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 561 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
															g_clear_error (&_inner_error_);
#line 561 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
															return 0;
#line 5337 "tracker-sparql-expression.c"
														}
													}
#line 562 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
													_tmp104_ = sql;
#line 562 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
													g_string_append (_tmp104_, ")");
#line 564 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
													result = TRACKER_PROPERTY_TYPE_STRING;
#line 564 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
													return result;
#line 5348 "tracker-sparql-expression.c"
												} else {
													const gchar* _tmp105_;
#line 565 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
													_tmp105_ = uri;
#line 565 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
													if (g_strcmp0 (_tmp105_, TRACKER_SPARQL_EXPRESSION_FN_NS "year-from-dateTime") == 0) {
#line 5355 "tracker-sparql-expression.c"
														gchar* _tmp106_ = NULL;
														gchar* _tmp107_;
														gchar* _tmp108_ = NULL;
														gchar* _tmp109_;
														gchar* variable_name;
														TrackerSparqlContext* _tmp110_;
														TrackerSparqlContext* _tmp111_;
														const gchar* _tmp112_;
														TrackerSparqlVariable* _tmp113_ = NULL;
														TrackerSparqlVariable* _tmp114_;
														TrackerSparqlVariable* variable;
														GString* _tmp115_;
														GString* _tmp116_;
														TrackerSparqlVariable* _tmp117_;
														gchar* _tmp118_ = NULL;
														gchar* _tmp119_;
														GString* _tmp120_;
#line 566 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
														tracker_sparql_expression_expect (self, TRACKER_SPARQL_TOKEN_TYPE_VAR, &_inner_error_);
#line 566 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
														if (_inner_error_ != NULL) {
#line 566 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
															if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 566 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																g_propagate_error (error, _inner_error_);
#line 566 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																return 0;
#line 5383 "tracker-sparql-expression.c"
															} else {
#line 566 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 566 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																g_clear_error (&_inner_error_);
#line 566 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																return 0;
#line 5391 "tracker-sparql-expression.c"
															}
														}
#line 567 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
														_tmp106_ = tracker_sparql_expression_get_last_string (self, 0);
#line 567 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
														_tmp107_ = _tmp106_;
#line 567 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
														_tmp108_ = string_substring (_tmp107_, (glong) 1, (glong) (-1));
#line 567 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
														_tmp109_ = _tmp108_;
#line 567 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
														_g_free0 (_tmp107_);
#line 567 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
														variable_name = _tmp109_;
#line 568 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
														_tmp110_ = tracker_sparql_expression_get_context (self);
#line 568 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
														_tmp111_ = _tmp110_;
#line 568 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
														_tmp112_ = variable_name;
#line 568 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
														_tmp113_ = tracker_sparql_context_get_variable (_tmp111_, _tmp112_);
#line 568 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
														_tmp114_ = _g_object_ref0 (_tmp113_);
#line 568 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
														variable = _tmp114_;
#line 570 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
														_tmp115_ = sql;
#line 570 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
														g_string_append (_tmp115_, "strftime (\"%Y\", ");
#line 571 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
														_tmp116_ = sql;
#line 571 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
														_tmp117_ = variable;
#line 571 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
														_tmp118_ = tracker_sparql_variable_get_extra_sql_expression (_tmp117_, "localDate");
#line 571 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
														_tmp119_ = _tmp118_;
#line 571 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
														g_string_append (_tmp116_, _tmp119_);
#line 571 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
														_g_free0 (_tmp119_);
#line 572 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
														_tmp120_ = sql;
#line 572 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
														g_string_append (_tmp120_, " * 24 * 3600, \"unixepoch\")");
#line 574 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
														result = TRACKER_PROPERTY_TYPE_INTEGER;
#line 574 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
														_g_object_unref0 (variable);
#line 574 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
														_g_free0 (variable_name);
#line 574 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
														return result;
#line 5446 "tracker-sparql-expression.c"
													} else {
														const gchar* _tmp121_;
#line 575 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
														_tmp121_ = uri;
#line 575 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
														if (g_strcmp0 (_tmp121_, TRACKER_SPARQL_EXPRESSION_FN_NS "month-from-dateTime") == 0) {
#line 5453 "tracker-sparql-expression.c"
															gchar* _tmp122_ = NULL;
															gchar* _tmp123_;
															gchar* _tmp124_ = NULL;
															gchar* _tmp125_;
															gchar* variable_name;
															TrackerSparqlContext* _tmp126_;
															TrackerSparqlContext* _tmp127_;
															const gchar* _tmp128_;
															TrackerSparqlVariable* _tmp129_ = NULL;
															TrackerSparqlVariable* _tmp130_;
															TrackerSparqlVariable* variable;
															GString* _tmp131_;
															GString* _tmp132_;
															TrackerSparqlVariable* _tmp133_;
															gchar* _tmp134_ = NULL;
															gchar* _tmp135_;
															GString* _tmp136_;
#line 576 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
															tracker_sparql_expression_expect (self, TRACKER_SPARQL_TOKEN_TYPE_VAR, &_inner_error_);
#line 576 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
															if (_inner_error_ != NULL) {
#line 576 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 576 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																	g_propagate_error (error, _inner_error_);
#line 576 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																	return 0;
#line 5481 "tracker-sparql-expression.c"
																} else {
#line 576 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 576 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																	g_clear_error (&_inner_error_);
#line 576 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																	return 0;
#line 5489 "tracker-sparql-expression.c"
																}
															}
#line 577 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
															_tmp122_ = tracker_sparql_expression_get_last_string (self, 0);
#line 577 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
															_tmp123_ = _tmp122_;
#line 577 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
															_tmp124_ = string_substring (_tmp123_, (glong) 1, (glong) (-1));
#line 577 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
															_tmp125_ = _tmp124_;
#line 577 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
															_g_free0 (_tmp123_);
#line 577 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
															variable_name = _tmp125_;
#line 578 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
															_tmp126_ = tracker_sparql_expression_get_context (self);
#line 578 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
															_tmp127_ = _tmp126_;
#line 578 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
															_tmp128_ = variable_name;
#line 578 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
															_tmp129_ = tracker_sparql_context_get_variable (_tmp127_, _tmp128_);
#line 578 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
															_tmp130_ = _g_object_ref0 (_tmp129_);
#line 578 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
															variable = _tmp130_;
#line 580 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
															_tmp131_ = sql;
#line 580 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
															g_string_append (_tmp131_, "strftime (\"%m\", ");
#line 581 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
															_tmp132_ = sql;
#line 581 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
															_tmp133_ = variable;
#line 581 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
															_tmp134_ = tracker_sparql_variable_get_extra_sql_expression (_tmp133_, "localDate");
#line 581 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
															_tmp135_ = _tmp134_;
#line 581 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
															g_string_append (_tmp132_, _tmp135_);
#line 581 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
															_g_free0 (_tmp135_);
#line 582 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
															_tmp136_ = sql;
#line 582 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
															g_string_append (_tmp136_, " * 24 * 3600, \"unixepoch\")");
#line 584 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
															result = TRACKER_PROPERTY_TYPE_INTEGER;
#line 584 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
															_g_object_unref0 (variable);
#line 584 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
															_g_free0 (variable_name);
#line 584 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
															return result;
#line 5544 "tracker-sparql-expression.c"
														} else {
															const gchar* _tmp137_;
#line 585 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
															_tmp137_ = uri;
#line 585 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
															if (g_strcmp0 (_tmp137_, TRACKER_SPARQL_EXPRESSION_FN_NS "day-from-dateTime") == 0) {
#line 5551 "tracker-sparql-expression.c"
																gchar* _tmp138_ = NULL;
																gchar* _tmp139_;
																gchar* _tmp140_ = NULL;
																gchar* _tmp141_;
																gchar* variable_name;
																TrackerSparqlContext* _tmp142_;
																TrackerSparqlContext* _tmp143_;
																const gchar* _tmp144_;
																TrackerSparqlVariable* _tmp145_ = NULL;
																TrackerSparqlVariable* _tmp146_;
																TrackerSparqlVariable* variable;
																GString* _tmp147_;
																GString* _tmp148_;
																TrackerSparqlVariable* _tmp149_;
																gchar* _tmp150_ = NULL;
																gchar* _tmp151_;
																GString* _tmp152_;
#line 586 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																tracker_sparql_expression_expect (self, TRACKER_SPARQL_TOKEN_TYPE_VAR, &_inner_error_);
#line 586 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																if (_inner_error_ != NULL) {
#line 586 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																	if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 586 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																		g_propagate_error (error, _inner_error_);
#line 586 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																		return 0;
#line 5579 "tracker-sparql-expression.c"
																	} else {
#line 586 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 586 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																		g_clear_error (&_inner_error_);
#line 586 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																		return 0;
#line 5587 "tracker-sparql-expression.c"
																	}
																}
#line 587 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																_tmp138_ = tracker_sparql_expression_get_last_string (self, 0);
#line 587 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																_tmp139_ = _tmp138_;
#line 587 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																_tmp140_ = string_substring (_tmp139_, (glong) 1, (glong) (-1));
#line 587 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																_tmp141_ = _tmp140_;
#line 587 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																_g_free0 (_tmp139_);
#line 587 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																variable_name = _tmp141_;
#line 588 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																_tmp142_ = tracker_sparql_expression_get_context (self);
#line 588 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																_tmp143_ = _tmp142_;
#line 588 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																_tmp144_ = variable_name;
#line 588 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																_tmp145_ = tracker_sparql_context_get_variable (_tmp143_, _tmp144_);
#line 588 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																_tmp146_ = _g_object_ref0 (_tmp145_);
#line 588 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																variable = _tmp146_;
#line 590 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																_tmp147_ = sql;
#line 590 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																g_string_append (_tmp147_, "strftime (\"%d\", ");
#line 591 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																_tmp148_ = sql;
#line 591 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																_tmp149_ = variable;
#line 591 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																_tmp150_ = tracker_sparql_variable_get_extra_sql_expression (_tmp149_, "localDate");
#line 591 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																_tmp151_ = _tmp150_;
#line 591 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																g_string_append (_tmp148_, _tmp151_);
#line 591 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																_g_free0 (_tmp151_);
#line 592 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																_tmp152_ = sql;
#line 592 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																g_string_append (_tmp152_, " * 24 * 3600, \"unixepoch\")");
#line 594 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																result = TRACKER_PROPERTY_TYPE_INTEGER;
#line 594 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																_g_object_unref0 (variable);
#line 594 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																_g_free0 (variable_name);
#line 594 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																return result;
#line 5642 "tracker-sparql-expression.c"
															} else {
																const gchar* _tmp153_;
#line 595 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																_tmp153_ = uri;
#line 595 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																if (g_strcmp0 (_tmp153_, TRACKER_SPARQL_EXPRESSION_FN_NS "hours-from-dateTime") == 0) {
#line 5649 "tracker-sparql-expression.c"
																	gchar* _tmp154_ = NULL;
																	gchar* _tmp155_;
																	gchar* _tmp156_ = NULL;
																	gchar* _tmp157_;
																	gchar* variable_name;
																	TrackerSparqlContext* _tmp158_;
																	TrackerSparqlContext* _tmp159_;
																	const gchar* _tmp160_;
																	TrackerSparqlVariable* _tmp161_ = NULL;
																	TrackerSparqlVariable* _tmp162_;
																	TrackerSparqlVariable* variable;
																	GString* _tmp163_;
																	GString* _tmp164_;
																	TrackerSparqlVariable* _tmp165_;
																	gchar* _tmp166_ = NULL;
																	gchar* _tmp167_;
																	GString* _tmp168_;
#line 596 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																	tracker_sparql_expression_expect (self, TRACKER_SPARQL_TOKEN_TYPE_VAR, &_inner_error_);
#line 596 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																	if (_inner_error_ != NULL) {
#line 596 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																		if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 596 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																			g_propagate_error (error, _inner_error_);
#line 596 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																			return 0;
#line 5677 "tracker-sparql-expression.c"
																		} else {
#line 596 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 596 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																			g_clear_error (&_inner_error_);
#line 596 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																			return 0;
#line 5685 "tracker-sparql-expression.c"
																		}
																	}
#line 597 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																	_tmp154_ = tracker_sparql_expression_get_last_string (self, 0);
#line 597 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																	_tmp155_ = _tmp154_;
#line 597 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																	_tmp156_ = string_substring (_tmp155_, (glong) 1, (glong) (-1));
#line 597 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																	_tmp157_ = _tmp156_;
#line 597 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																	_g_free0 (_tmp155_);
#line 597 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																	variable_name = _tmp157_;
#line 598 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																	_tmp158_ = tracker_sparql_expression_get_context (self);
#line 598 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																	_tmp159_ = _tmp158_;
#line 598 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																	_tmp160_ = variable_name;
#line 598 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																	_tmp161_ = tracker_sparql_context_get_variable (_tmp159_, _tmp160_);
#line 598 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																	_tmp162_ = _g_object_ref0 (_tmp161_);
#line 598 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																	variable = _tmp162_;
#line 600 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																	_tmp163_ = sql;
#line 600 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																	g_string_append (_tmp163_, "(");
#line 601 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																	_tmp164_ = sql;
#line 601 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																	_tmp165_ = variable;
#line 601 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																	_tmp166_ = tracker_sparql_variable_get_extra_sql_expression (_tmp165_, "localTime");
#line 601 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																	_tmp167_ = _tmp166_;
#line 601 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																	g_string_append (_tmp164_, _tmp167_);
#line 601 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																	_g_free0 (_tmp167_);
#line 602 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																	_tmp168_ = sql;
#line 602 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																	g_string_append (_tmp168_, " / 3600)");
#line 604 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																	result = TRACKER_PROPERTY_TYPE_INTEGER;
#line 604 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																	_g_object_unref0 (variable);
#line 604 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																	_g_free0 (variable_name);
#line 604 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																	return result;
#line 5740 "tracker-sparql-expression.c"
																} else {
																	const gchar* _tmp169_;
#line 605 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																	_tmp169_ = uri;
#line 605 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																	if (g_strcmp0 (_tmp169_, TRACKER_SPARQL_EXPRESSION_FN_NS "minutes-from-dateTime") == 0) {
#line 5747 "tracker-sparql-expression.c"
																		gchar* _tmp170_ = NULL;
																		gchar* _tmp171_;
																		gchar* _tmp172_ = NULL;
																		gchar* _tmp173_;
																		gchar* variable_name;
																		TrackerSparqlContext* _tmp174_;
																		TrackerSparqlContext* _tmp175_;
																		const gchar* _tmp176_;
																		TrackerSparqlVariable* _tmp177_ = NULL;
																		TrackerSparqlVariable* _tmp178_;
																		TrackerSparqlVariable* variable;
																		GString* _tmp179_;
																		GString* _tmp180_;
																		TrackerSparqlVariable* _tmp181_;
																		gchar* _tmp182_ = NULL;
																		gchar* _tmp183_;
																		GString* _tmp184_;
#line 606 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																		tracker_sparql_expression_expect (self, TRACKER_SPARQL_TOKEN_TYPE_VAR, &_inner_error_);
#line 606 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																		if (_inner_error_ != NULL) {
#line 606 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																			if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 606 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																				g_propagate_error (error, _inner_error_);
#line 606 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																				return 0;
#line 5775 "tracker-sparql-expression.c"
																			} else {
#line 606 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 606 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																				g_clear_error (&_inner_error_);
#line 606 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																				return 0;
#line 5783 "tracker-sparql-expression.c"
																			}
																		}
#line 607 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																		_tmp170_ = tracker_sparql_expression_get_last_string (self, 0);
#line 607 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																		_tmp171_ = _tmp170_;
#line 607 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																		_tmp172_ = string_substring (_tmp171_, (glong) 1, (glong) (-1));
#line 607 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																		_tmp173_ = _tmp172_;
#line 607 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																		_g_free0 (_tmp171_);
#line 607 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																		variable_name = _tmp173_;
#line 608 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																		_tmp174_ = tracker_sparql_expression_get_context (self);
#line 608 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																		_tmp175_ = _tmp174_;
#line 608 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																		_tmp176_ = variable_name;
#line 608 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																		_tmp177_ = tracker_sparql_context_get_variable (_tmp175_, _tmp176_);
#line 608 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																		_tmp178_ = _g_object_ref0 (_tmp177_);
#line 608 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																		variable = _tmp178_;
#line 610 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																		_tmp179_ = sql;
#line 610 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																		g_string_append (_tmp179_, "(");
#line 611 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																		_tmp180_ = sql;
#line 611 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																		_tmp181_ = variable;
#line 611 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																		_tmp182_ = tracker_sparql_variable_get_extra_sql_expression (_tmp181_, "localTime");
#line 611 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																		_tmp183_ = _tmp182_;
#line 611 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																		g_string_append (_tmp180_, _tmp183_);
#line 611 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																		_g_free0 (_tmp183_);
#line 612 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																		_tmp184_ = sql;
#line 612 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																		g_string_append (_tmp184_, " / 60 % 60)");
#line 614 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																		result = TRACKER_PROPERTY_TYPE_INTEGER;
#line 614 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																		_g_object_unref0 (variable);
#line 614 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																		_g_free0 (variable_name);
#line 614 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																		return result;
#line 5838 "tracker-sparql-expression.c"
																	} else {
																		const gchar* _tmp185_;
#line 615 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																		_tmp185_ = uri;
#line 615 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																		if (g_strcmp0 (_tmp185_, TRACKER_SPARQL_EXPRESSION_FN_NS "seconds-from-dateTime") == 0) {
#line 5845 "tracker-sparql-expression.c"
																			gchar* _tmp186_ = NULL;
																			gchar* _tmp187_;
																			gchar* _tmp188_ = NULL;
																			gchar* _tmp189_;
																			gchar* variable_name;
																			TrackerSparqlContext* _tmp190_;
																			TrackerSparqlContext* _tmp191_;
																			const gchar* _tmp192_;
																			TrackerSparqlVariable* _tmp193_ = NULL;
																			TrackerSparqlVariable* _tmp194_;
																			TrackerSparqlVariable* variable;
																			GString* _tmp195_;
																			GString* _tmp196_;
																			TrackerSparqlVariable* _tmp197_;
																			gchar* _tmp198_ = NULL;
																			gchar* _tmp199_;
																			GString* _tmp200_;
#line 616 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																			tracker_sparql_expression_expect (self, TRACKER_SPARQL_TOKEN_TYPE_VAR, &_inner_error_);
#line 616 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																			if (_inner_error_ != NULL) {
#line 616 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																				if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 616 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																					g_propagate_error (error, _inner_error_);
#line 616 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																					return 0;
#line 5873 "tracker-sparql-expression.c"
																				} else {
#line 616 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 616 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																					g_clear_error (&_inner_error_);
#line 616 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																					return 0;
#line 5881 "tracker-sparql-expression.c"
																				}
																			}
#line 617 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																			_tmp186_ = tracker_sparql_expression_get_last_string (self, 0);
#line 617 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																			_tmp187_ = _tmp186_;
#line 617 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																			_tmp188_ = string_substring (_tmp187_, (glong) 1, (glong) (-1));
#line 617 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																			_tmp189_ = _tmp188_;
#line 617 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																			_g_free0 (_tmp187_);
#line 617 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																			variable_name = _tmp189_;
#line 618 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																			_tmp190_ = tracker_sparql_expression_get_context (self);
#line 618 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																			_tmp191_ = _tmp190_;
#line 618 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																			_tmp192_ = variable_name;
#line 618 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																			_tmp193_ = tracker_sparql_context_get_variable (_tmp191_, _tmp192_);
#line 618 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																			_tmp194_ = _g_object_ref0 (_tmp193_);
#line 618 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																			variable = _tmp194_;
#line 620 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																			_tmp195_ = sql;
#line 620 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																			g_string_append (_tmp195_, "(");
#line 621 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																			_tmp196_ = sql;
#line 621 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																			_tmp197_ = variable;
#line 621 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																			_tmp198_ = tracker_sparql_variable_get_extra_sql_expression (_tmp197_, "localTime");
#line 621 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																			_tmp199_ = _tmp198_;
#line 621 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																			g_string_append (_tmp196_, _tmp199_);
#line 621 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																			_g_free0 (_tmp199_);
#line 622 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																			_tmp200_ = sql;
#line 622 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																			g_string_append (_tmp200_, "% 60)");
#line 624 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																			result = TRACKER_PROPERTY_TYPE_INTEGER;
#line 624 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																			_g_object_unref0 (variable);
#line 624 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																			_g_free0 (variable_name);
#line 624 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																			return result;
#line 5936 "tracker-sparql-expression.c"
																		} else {
																			const gchar* _tmp201_;
#line 625 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																			_tmp201_ = uri;
#line 625 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																			if (g_strcmp0 (_tmp201_, TRACKER_SPARQL_EXPRESSION_FN_NS "timezone-from-dateTime") == 0) {
#line 5943 "tracker-sparql-expression.c"
																				gchar* _tmp202_ = NULL;
																				gchar* _tmp203_;
																				gchar* _tmp204_ = NULL;
																				gchar* _tmp205_;
																				gchar* variable_name;
																				TrackerSparqlContext* _tmp206_;
																				TrackerSparqlContext* _tmp207_;
																				const gchar* _tmp208_;
																				TrackerSparqlVariable* _tmp209_ = NULL;
																				TrackerSparqlVariable* _tmp210_;
																				TrackerSparqlVariable* variable;
																				GString* _tmp211_;
																				GString* _tmp212_;
																				TrackerSparqlVariable* _tmp213_;
																				gchar* _tmp214_ = NULL;
																				gchar* _tmp215_;
																				GString* _tmp216_;
																				GString* _tmp217_;
																				TrackerSparqlVariable* _tmp218_;
																				gchar* _tmp219_ = NULL;
																				gchar* _tmp220_;
																				GString* _tmp221_;
																				GString* _tmp222_;
																				GString* _tmp223_;
																				TrackerSparqlVariable* _tmp224_;
																				const gchar* _tmp225_;
																				const gchar* _tmp226_;
																				GString* _tmp227_;
																				GString* _tmp228_;
#line 626 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																				tracker_sparql_expression_expect (self, TRACKER_SPARQL_TOKEN_TYPE_VAR, &_inner_error_);
#line 626 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																				if (_inner_error_ != NULL) {
#line 626 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																					if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 626 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																						g_propagate_error (error, _inner_error_);
#line 626 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																						return 0;
#line 5983 "tracker-sparql-expression.c"
																					} else {
#line 626 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 626 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																						g_clear_error (&_inner_error_);
#line 626 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																						return 0;
#line 5991 "tracker-sparql-expression.c"
																					}
																				}
#line 627 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																				_tmp202_ = tracker_sparql_expression_get_last_string (self, 0);
#line 627 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																				_tmp203_ = _tmp202_;
#line 627 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																				_tmp204_ = string_substring (_tmp203_, (glong) 1, (glong) (-1));
#line 627 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																				_tmp205_ = _tmp204_;
#line 627 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																				_g_free0 (_tmp203_);
#line 627 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																				variable_name = _tmp205_;
#line 628 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																				_tmp206_ = tracker_sparql_expression_get_context (self);
#line 628 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																				_tmp207_ = _tmp206_;
#line 628 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																				_tmp208_ = variable_name;
#line 628 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																				_tmp209_ = tracker_sparql_context_get_variable (_tmp207_, _tmp208_);
#line 628 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																				_tmp210_ = _g_object_ref0 (_tmp209_);
#line 628 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																				variable = _tmp210_;
#line 630 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																				_tmp211_ = sql;
#line 630 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																				g_string_append (_tmp211_, "(");
#line 631 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																				_tmp212_ = sql;
#line 631 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																				_tmp213_ = variable;
#line 631 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																				_tmp214_ = tracker_sparql_variable_get_extra_sql_expression (_tmp213_, "localDate");
#line 631 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																				_tmp215_ = _tmp214_;
#line 631 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																				g_string_append (_tmp212_, _tmp215_);
#line 631 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																				_g_free0 (_tmp215_);
#line 632 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																				_tmp216_ = sql;
#line 632 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																				g_string_append (_tmp216_, " * 24 * 3600 + ");
#line 633 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																				_tmp217_ = sql;
#line 633 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																				_tmp218_ = variable;
#line 633 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																				_tmp219_ = tracker_sparql_variable_get_extra_sql_expression (_tmp218_, "localTime");
#line 633 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																				_tmp220_ = _tmp219_;
#line 633 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																				g_string_append (_tmp217_, _tmp220_);
#line 633 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																				_g_free0 (_tmp220_);
#line 634 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																				_tmp221_ = sql;
#line 634 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																				g_string_append (_tmp221_, "- ");
#line 635 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																				_tmp222_ = sql;
#line 635 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																				g_string_append (_tmp222_, "CAST (");
#line 636 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																				_tmp223_ = sql;
#line 636 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																				_tmp224_ = variable;
#line 636 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																				_tmp225_ = tracker_sparql_variable_get_sql_expression (_tmp224_);
#line 636 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																				_tmp226_ = _tmp225_;
#line 636 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																				g_string_append (_tmp223_, _tmp226_);
#line 637 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																				_tmp227_ = sql;
#line 637 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																				g_string_append (_tmp227_, " AS INTEGER)");
#line 638 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																				_tmp228_ = sql;
#line 638 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																				g_string_append (_tmp228_, ")");
#line 640 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																				result = TRACKER_PROPERTY_TYPE_INTEGER;
#line 640 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																				_g_object_unref0 (variable);
#line 640 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																				_g_free0 (variable_name);
#line 640 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																				return result;
#line 6084 "tracker-sparql-expression.c"
																			} else {
																				const gchar* _tmp229_;
#line 641 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																				_tmp229_ = uri;
#line 641 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																				if (g_strcmp0 (_tmp229_, TRACKER_SPARQL_EXPRESSION_FTS_NS "rank") == 0) {
#line 6091 "tracker-sparql-expression.c"
																					gboolean is_var = FALSE;
																					TrackerSparqlPattern* _tmp230_;
																					TrackerSparqlPattern* _tmp231_;
																					gboolean _tmp232_ = FALSE;
																					gchar* _tmp233_ = NULL;
																					gchar* v;
																					GString* _tmp234_;
																					const gchar* _tmp235_;
#line 643 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																					_tmp230_ = tracker_sparql_expression_get_pattern (self);
#line 643 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																					_tmp231_ = _tmp230_;
#line 643 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																					_tmp233_ = tracker_sparql_pattern_parse_var_or_term (_tmp231_, NULL, &_tmp232_, &_inner_error_);
#line 643 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																					is_var = _tmp232_;
#line 643 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																					v = _tmp233_;
#line 643 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																					if (_inner_error_ != NULL) {
#line 643 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																						if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 643 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																							g_propagate_error (error, _inner_error_);
#line 643 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																							return 0;
#line 6118 "tracker-sparql-expression.c"
																						} else {
#line 643 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																							g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 643 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																							g_clear_error (&_inner_error_);
#line 643 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																							return 0;
#line 6126 "tracker-sparql-expression.c"
																						}
																					}
#line 644 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																					_tmp234_ = sql;
#line 644 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																					_tmp235_ = v;
#line 644 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																					g_string_append_printf (_tmp234_, "\"%s_u_rank\"", _tmp235_);
#line 646 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																					result = TRACKER_PROPERTY_TYPE_DOUBLE;
#line 646 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																					_g_free0 (v);
#line 646 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																					return result;
#line 6141 "tracker-sparql-expression.c"
																				} else {
																					const gchar* _tmp236_;
#line 647 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																					_tmp236_ = uri;
#line 647 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																					if (g_strcmp0 (_tmp236_, TRACKER_SPARQL_EXPRESSION_FTS_NS "offsets") == 0) {
#line 6148 "tracker-sparql-expression.c"
																						gboolean is_var = FALSE;
																						TrackerSparqlPattern* _tmp237_;
																						TrackerSparqlPattern* _tmp238_;
																						gboolean _tmp239_ = FALSE;
																						gchar* _tmp240_ = NULL;
																						gchar* v;
																						GString* _tmp241_;
																						const gchar* _tmp242_;
#line 649 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																						_tmp237_ = tracker_sparql_expression_get_pattern (self);
#line 649 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																						_tmp238_ = _tmp237_;
#line 649 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																						_tmp240_ = tracker_sparql_pattern_parse_var_or_term (_tmp238_, NULL, &_tmp239_, &_inner_error_);
#line 649 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																						is_var = _tmp239_;
#line 649 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																						v = _tmp240_;
#line 649 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																						if (_inner_error_ != NULL) {
#line 649 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																							if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 649 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																								g_propagate_error (error, _inner_error_);
#line 649 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																								return 0;
#line 6175 "tracker-sparql-expression.c"
																							} else {
#line 649 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																								g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 649 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																								g_clear_error (&_inner_error_);
#line 649 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																								return 0;
#line 6183 "tracker-sparql-expression.c"
																							}
																						}
#line 650 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																						_tmp241_ = sql;
#line 650 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																						_tmp242_ = v;
#line 650 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																						g_string_append_printf (_tmp241_, "\"%s_u_offsets\"", _tmp242_);
#line 652 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																						result = TRACKER_PROPERTY_TYPE_STRING;
#line 652 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																						_g_free0 (v);
#line 652 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																						return result;
#line 6198 "tracker-sparql-expression.c"
																					} else {
																						const gchar* _tmp243_;
#line 653 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																						_tmp243_ = uri;
#line 653 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																						if (g_strcmp0 (_tmp243_, TRACKER_SPARQL_EXPRESSION_TRACKER_NS "id") == 0) {
#line 6205 "tracker-sparql-expression.c"
																							GString* _tmp244_;
																							TrackerPropertyType _tmp245_ = 0;
																							TrackerPropertyType type;
																							TrackerPropertyType _tmp246_;
#line 654 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																							_tmp244_ = sql;
#line 654 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																							_tmp245_ = tracker_sparql_expression_translate_expression (self, _tmp244_, &_inner_error_);
#line 654 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																							type = _tmp245_;
#line 654 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																							if (_inner_error_ != NULL) {
#line 654 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																								if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 654 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																									g_propagate_error (error, _inner_error_);
#line 654 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																									return 0;
#line 6224 "tracker-sparql-expression.c"
																								} else {
#line 654 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																									g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 654 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																									g_clear_error (&_inner_error_);
#line 654 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																									return 0;
#line 6232 "tracker-sparql-expression.c"
																								}
																							}
#line 655 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																							_tmp246_ = type;
#line 655 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																							if (_tmp246_ != TRACKER_PROPERTY_TYPE_RESOURCE) {
#line 6239 "tracker-sparql-expression.c"
																								GError* _tmp247_ = NULL;
#line 656 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																								_tmp247_ = tracker_sparql_expression_get_error (self, "expected resource");
#line 656 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																								_inner_error_ = _tmp247_;
#line 656 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																								if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 656 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																									g_propagate_error (error, _inner_error_);
#line 656 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																									return 0;
#line 6251 "tracker-sparql-expression.c"
																								} else {
#line 656 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																									g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 656 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																									g_clear_error (&_inner_error_);
#line 656 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																									return 0;
#line 6259 "tracker-sparql-expression.c"
																								}
																							}
#line 659 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																							result = TRACKER_PROPERTY_TYPE_INTEGER;
#line 659 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																							return result;
#line 6266 "tracker-sparql-expression.c"
																						} else {
																							const gchar* _tmp248_;
#line 660 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																							_tmp248_ = uri;
#line 660 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																							if (g_strcmp0 (_tmp248_, TRACKER_SPARQL_EXPRESSION_TRACKER_NS "uri") == 0) {
#line 6273 "tracker-sparql-expression.c"
																								GString* _tmp249_;
																								TrackerPropertyType _tmp250_ = 0;
																								TrackerPropertyType type;
																								TrackerPropertyType _tmp251_;
#line 661 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																								_tmp249_ = sql;
#line 661 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																								_tmp250_ = tracker_sparql_expression_translate_expression (self, _tmp249_, &_inner_error_);
#line 661 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																								type = _tmp250_;
#line 661 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																								if (_inner_error_ != NULL) {
#line 661 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																									if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 661 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																										g_propagate_error (error, _inner_error_);
#line 661 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																										return 0;
#line 6292 "tracker-sparql-expression.c"
																									} else {
#line 661 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																										g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 661 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																										g_clear_error (&_inner_error_);
#line 661 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																										return 0;
#line 6300 "tracker-sparql-expression.c"
																									}
																								}
#line 662 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																								_tmp251_ = type;
#line 662 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																								if (_tmp251_ != TRACKER_PROPERTY_TYPE_INTEGER) {
#line 6307 "tracker-sparql-expression.c"
																									GError* _tmp252_ = NULL;
#line 663 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																									_tmp252_ = tracker_sparql_expression_get_error (self, "expected integer ID");
#line 663 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																									_inner_error_ = _tmp252_;
#line 663 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																									if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 663 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																										g_propagate_error (error, _inner_error_);
#line 663 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																										return 0;
#line 6319 "tracker-sparql-expression.c"
																									} else {
#line 663 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																										g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 663 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																										g_clear_error (&_inner_error_);
#line 663 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																										return 0;
#line 6327 "tracker-sparql-expression.c"
																									}
																								}
#line 666 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																								result = TRACKER_PROPERTY_TYPE_RESOURCE;
#line 666 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																								return result;
#line 6334 "tracker-sparql-expression.c"
																							} else {
																								const gchar* _tmp253_;
#line 667 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																								_tmp253_ = uri;
#line 667 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																								if (g_strcmp0 (_tmp253_, TRACKER_SPARQL_EXPRESSION_TRACKER_NS "cartesian-distance") == 0) {
#line 6341 "tracker-sparql-expression.c"
																									GString* _tmp254_;
																									GString* _tmp255_;
																									GString* _tmp256_;
																									GString* _tmp257_;
																									GString* _tmp258_;
																									GString* _tmp259_;
																									GString* _tmp260_;
																									GString* _tmp261_;
																									GString* _tmp262_;
#line 668 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																									_tmp254_ = sql;
#line 668 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																									g_string_append (_tmp254_, "SparqlCartesianDistance(");
#line 669 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																									_tmp255_ = sql;
#line 669 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																									tracker_sparql_expression_translate_expression (self, _tmp255_, &_inner_error_);
#line 669 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																									if (_inner_error_ != NULL) {
#line 669 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																										if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 669 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																											g_propagate_error (error, _inner_error_);
#line 669 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																											return 0;
#line 6367 "tracker-sparql-expression.c"
																										} else {
#line 669 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																											g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 669 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																											g_clear_error (&_inner_error_);
#line 669 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																											return 0;
#line 6375 "tracker-sparql-expression.c"
																										}
																									}
#line 670 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																									_tmp256_ = sql;
#line 670 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																									g_string_append (_tmp256_, ", ");
#line 671 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																									tracker_sparql_expression_expect (self, TRACKER_SPARQL_TOKEN_TYPE_COMMA, &_inner_error_);
#line 671 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																									if (_inner_error_ != NULL) {
#line 671 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																										if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 671 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																											g_propagate_error (error, _inner_error_);
#line 671 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																											return 0;
#line 6392 "tracker-sparql-expression.c"
																										} else {
#line 671 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																											g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 671 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																											g_clear_error (&_inner_error_);
#line 671 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																											return 0;
#line 6400 "tracker-sparql-expression.c"
																										}
																									}
#line 672 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																									_tmp257_ = sql;
#line 672 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																									tracker_sparql_expression_translate_expression (self, _tmp257_, &_inner_error_);
#line 672 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																									if (_inner_error_ != NULL) {
#line 672 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																										if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 672 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																											g_propagate_error (error, _inner_error_);
#line 672 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																											return 0;
#line 6415 "tracker-sparql-expression.c"
																										} else {
#line 672 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																											g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 672 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																											g_clear_error (&_inner_error_);
#line 672 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																											return 0;
#line 6423 "tracker-sparql-expression.c"
																										}
																									}
#line 673 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																									_tmp258_ = sql;
#line 673 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																									g_string_append (_tmp258_, ", ");
#line 674 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																									tracker_sparql_expression_expect (self, TRACKER_SPARQL_TOKEN_TYPE_COMMA, &_inner_error_);
#line 674 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																									if (_inner_error_ != NULL) {
#line 674 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																										if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 674 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																											g_propagate_error (error, _inner_error_);
#line 674 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																											return 0;
#line 6440 "tracker-sparql-expression.c"
																										} else {
#line 674 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																											g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 674 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																											g_clear_error (&_inner_error_);
#line 674 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																											return 0;
#line 6448 "tracker-sparql-expression.c"
																										}
																									}
#line 675 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																									_tmp259_ = sql;
#line 675 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																									tracker_sparql_expression_translate_expression (self, _tmp259_, &_inner_error_);
#line 675 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																									if (_inner_error_ != NULL) {
#line 675 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																										if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 675 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																											g_propagate_error (error, _inner_error_);
#line 675 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																											return 0;
#line 6463 "tracker-sparql-expression.c"
																										} else {
#line 675 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																											g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 675 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																											g_clear_error (&_inner_error_);
#line 675 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																											return 0;
#line 6471 "tracker-sparql-expression.c"
																										}
																									}
#line 676 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																									_tmp260_ = sql;
#line 676 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																									g_string_append (_tmp260_, ", ");
#line 677 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																									tracker_sparql_expression_expect (self, TRACKER_SPARQL_TOKEN_TYPE_COMMA, &_inner_error_);
#line 677 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																									if (_inner_error_ != NULL) {
#line 677 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																										if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 677 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																											g_propagate_error (error, _inner_error_);
#line 677 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																											return 0;
#line 6488 "tracker-sparql-expression.c"
																										} else {
#line 677 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																											g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 677 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																											g_clear_error (&_inner_error_);
#line 677 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																											return 0;
#line 6496 "tracker-sparql-expression.c"
																										}
																									}
#line 678 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																									_tmp261_ = sql;
#line 678 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																									tracker_sparql_expression_translate_expression (self, _tmp261_, &_inner_error_);
#line 678 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																									if (_inner_error_ != NULL) {
#line 678 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																										if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 678 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																											g_propagate_error (error, _inner_error_);
#line 678 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																											return 0;
#line 6511 "tracker-sparql-expression.c"
																										} else {
#line 678 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																											g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 678 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																											g_clear_error (&_inner_error_);
#line 678 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																											return 0;
#line 6519 "tracker-sparql-expression.c"
																										}
																									}
#line 679 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																									_tmp262_ = sql;
#line 679 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																									g_string_append (_tmp262_, ")");
#line 681 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																									result = TRACKER_PROPERTY_TYPE_DOUBLE;
#line 681 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																									return result;
#line 6530 "tracker-sparql-expression.c"
																								} else {
																									const gchar* _tmp263_;
#line 682 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																									_tmp263_ = uri;
#line 682 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																									if (g_strcmp0 (_tmp263_, TRACKER_SPARQL_EXPRESSION_TRACKER_NS "haversine-distance") == 0) {
#line 6537 "tracker-sparql-expression.c"
																										GString* _tmp264_;
																										GString* _tmp265_;
																										GString* _tmp266_;
																										GString* _tmp267_;
																										GString* _tmp268_;
																										GString* _tmp269_;
																										GString* _tmp270_;
																										GString* _tmp271_;
																										GString* _tmp272_;
#line 683 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																										_tmp264_ = sql;
#line 683 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																										g_string_append (_tmp264_, "SparqlHaversineDistance(");
#line 684 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																										_tmp265_ = sql;
#line 684 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																										tracker_sparql_expression_translate_expression (self, _tmp265_, &_inner_error_);
#line 684 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																										if (_inner_error_ != NULL) {
#line 684 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																											if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 684 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																												g_propagate_error (error, _inner_error_);
#line 684 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																												return 0;
#line 6563 "tracker-sparql-expression.c"
																											} else {
#line 684 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																												g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 684 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																												g_clear_error (&_inner_error_);
#line 684 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																												return 0;
#line 6571 "tracker-sparql-expression.c"
																											}
																										}
#line 685 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																										_tmp266_ = sql;
#line 685 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																										g_string_append (_tmp266_, ", ");
#line 686 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																										tracker_sparql_expression_expect (self, TRACKER_SPARQL_TOKEN_TYPE_COMMA, &_inner_error_);
#line 686 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																										if (_inner_error_ != NULL) {
#line 686 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																											if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 686 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																												g_propagate_error (error, _inner_error_);
#line 686 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																												return 0;
#line 6588 "tracker-sparql-expression.c"
																											} else {
#line 686 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																												g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 686 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																												g_clear_error (&_inner_error_);
#line 686 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																												return 0;
#line 6596 "tracker-sparql-expression.c"
																											}
																										}
#line 687 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																										_tmp267_ = sql;
#line 687 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																										tracker_sparql_expression_translate_expression (self, _tmp267_, &_inner_error_);
#line 687 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																										if (_inner_error_ != NULL) {
#line 687 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																											if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 687 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																												g_propagate_error (error, _inner_error_);
#line 687 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																												return 0;
#line 6611 "tracker-sparql-expression.c"
																											} else {
#line 687 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																												g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 687 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																												g_clear_error (&_inner_error_);
#line 687 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																												return 0;
#line 6619 "tracker-sparql-expression.c"
																											}
																										}
#line 688 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																										_tmp268_ = sql;
#line 688 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																										g_string_append (_tmp268_, ", ");
#line 689 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																										tracker_sparql_expression_expect (self, TRACKER_SPARQL_TOKEN_TYPE_COMMA, &_inner_error_);
#line 689 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																										if (_inner_error_ != NULL) {
#line 689 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																											if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 689 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																												g_propagate_error (error, _inner_error_);
#line 689 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																												return 0;
#line 6636 "tracker-sparql-expression.c"
																											} else {
#line 689 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																												g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 689 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																												g_clear_error (&_inner_error_);
#line 689 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																												return 0;
#line 6644 "tracker-sparql-expression.c"
																											}
																										}
#line 690 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																										_tmp269_ = sql;
#line 690 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																										tracker_sparql_expression_translate_expression (self, _tmp269_, &_inner_error_);
#line 690 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																										if (_inner_error_ != NULL) {
#line 690 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																											if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 690 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																												g_propagate_error (error, _inner_error_);
#line 690 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																												return 0;
#line 6659 "tracker-sparql-expression.c"
																											} else {
#line 690 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																												g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 690 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																												g_clear_error (&_inner_error_);
#line 690 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																												return 0;
#line 6667 "tracker-sparql-expression.c"
																											}
																										}
#line 691 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																										_tmp270_ = sql;
#line 691 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																										g_string_append (_tmp270_, ", ");
#line 692 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																										tracker_sparql_expression_expect (self, TRACKER_SPARQL_TOKEN_TYPE_COMMA, &_inner_error_);
#line 692 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																										if (_inner_error_ != NULL) {
#line 692 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																											if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 692 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																												g_propagate_error (error, _inner_error_);
#line 692 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																												return 0;
#line 6684 "tracker-sparql-expression.c"
																											} else {
#line 692 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																												g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 692 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																												g_clear_error (&_inner_error_);
#line 692 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																												return 0;
#line 6692 "tracker-sparql-expression.c"
																											}
																										}
#line 693 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																										_tmp271_ = sql;
#line 693 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																										tracker_sparql_expression_translate_expression (self, _tmp271_, &_inner_error_);
#line 693 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																										if (_inner_error_ != NULL) {
#line 693 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																											if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 693 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																												g_propagate_error (error, _inner_error_);
#line 693 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																												return 0;
#line 6707 "tracker-sparql-expression.c"
																											} else {
#line 693 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																												g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 693 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																												g_clear_error (&_inner_error_);
#line 693 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																												return 0;
#line 6715 "tracker-sparql-expression.c"
																											}
																										}
#line 694 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																										_tmp272_ = sql;
#line 694 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																										g_string_append (_tmp272_, ")");
#line 696 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																										result = TRACKER_PROPERTY_TYPE_DOUBLE;
#line 696 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																										return result;
#line 6726 "tracker-sparql-expression.c"
																									} else {
																										const gchar* _tmp273_;
#line 697 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																										_tmp273_ = uri;
#line 697 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																										if (g_strcmp0 (_tmp273_, TRACKER_SPARQL_EXPRESSION_TRACKER_NS "coalesce") == 0) {
#line 6733 "tracker-sparql-expression.c"
																											GString* _tmp274_;
																											GString* _tmp275_;
																											GString* _tmp276_;
																											GString* _tmp277_;
																											GString* _tmp282_;
#line 698 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																											_tmp274_ = sql;
#line 698 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																											g_string_append (_tmp274_, "COALESCE(");
#line 699 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																											_tmp275_ = sql;
#line 699 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																											tracker_sparql_expression_translate_expression_as_string (self, _tmp275_, &_inner_error_);
#line 699 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																											if (_inner_error_ != NULL) {
#line 699 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																												if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 699 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																													g_propagate_error (error, _inner_error_);
#line 699 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																													return 0;
#line 6755 "tracker-sparql-expression.c"
																												} else {
#line 699 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																													g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 699 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																													g_clear_error (&_inner_error_);
#line 699 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																													return 0;
#line 6763 "tracker-sparql-expression.c"
																												}
																											}
#line 700 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																											_tmp276_ = sql;
#line 700 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																											g_string_append (_tmp276_, ", ");
#line 701 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																											tracker_sparql_expression_expect (self, TRACKER_SPARQL_TOKEN_TYPE_COMMA, &_inner_error_);
#line 701 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																											if (_inner_error_ != NULL) {
#line 701 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																												if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 701 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																													g_propagate_error (error, _inner_error_);
#line 701 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																													return 0;
#line 6780 "tracker-sparql-expression.c"
																												} else {
#line 701 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																													g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 701 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																													g_clear_error (&_inner_error_);
#line 701 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																													return 0;
#line 6788 "tracker-sparql-expression.c"
																												}
																											}
#line 702 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																											_tmp277_ = sql;
#line 702 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																											tracker_sparql_expression_translate_expression_as_string (self, _tmp277_, &_inner_error_);
#line 702 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																											if (_inner_error_ != NULL) {
#line 702 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																												if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 702 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																													g_propagate_error (error, _inner_error_);
#line 702 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																													return 0;
#line 6803 "tracker-sparql-expression.c"
																												} else {
#line 702 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																													g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 702 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																													g_clear_error (&_inner_error_);
#line 702 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																													return 0;
#line 6811 "tracker-sparql-expression.c"
																												}
																											}
#line 703 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																											while (TRUE) {
#line 6816 "tracker-sparql-expression.c"
																												gboolean _tmp278_ = FALSE;
																												gboolean _tmp279_;
																												GString* _tmp280_;
																												GString* _tmp281_;
#line 703 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																												_tmp278_ = tracker_sparql_expression_accept (self, TRACKER_SPARQL_TOKEN_TYPE_COMMA, &_inner_error_);
#line 703 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																												_tmp279_ = _tmp278_;
#line 703 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																												if (_inner_error_ != NULL) {
#line 703 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																													if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 703 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																														g_propagate_error (error, _inner_error_);
#line 703 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																														return 0;
#line 6833 "tracker-sparql-expression.c"
																													} else {
#line 703 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																														g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 703 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																														g_clear_error (&_inner_error_);
#line 703 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																														return 0;
#line 6841 "tracker-sparql-expression.c"
																													}
																												}
#line 703 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																												if (!_tmp279_) {
#line 703 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																													break;
#line 6848 "tracker-sparql-expression.c"
																												}
#line 704 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																												_tmp280_ = sql;
#line 704 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																												g_string_append (_tmp280_, ", ");
#line 705 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																												_tmp281_ = sql;
#line 705 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																												tracker_sparql_expression_translate_expression_as_string (self, _tmp281_, &_inner_error_);
#line 705 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																												if (_inner_error_ != NULL) {
#line 705 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																													if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 705 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																														g_propagate_error (error, _inner_error_);
#line 705 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																														return 0;
#line 6866 "tracker-sparql-expression.c"
																													} else {
#line 705 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																														g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 705 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																														g_clear_error (&_inner_error_);
#line 705 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																														return 0;
#line 6874 "tracker-sparql-expression.c"
																													}
																												}
																											}
#line 707 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																											_tmp282_ = sql;
#line 707 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																											g_string_append (_tmp282_, ")");
#line 709 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																											result = TRACKER_PROPERTY_TYPE_STRING;
#line 709 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																											return result;
#line 6886 "tracker-sparql-expression.c"
																										} else {
																											const gchar* _tmp283_;
#line 710 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																											_tmp283_ = uri;
#line 710 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																											if (g_strcmp0 (_tmp283_, TRACKER_SPARQL_EXPRESSION_TRACKER_NS "uri-is-parent") == 0) {
#line 6893 "tracker-sparql-expression.c"
																												GString* _tmp284_;
																												GString* _tmp285_;
																												GString* _tmp286_;
																												GString* _tmp287_;
																												GString* _tmp288_;
#line 711 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																												_tmp284_ = sql;
#line 711 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																												g_string_append (_tmp284_, "SparqlUriIsParent(");
#line 712 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																												_tmp285_ = sql;
#line 712 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																												tracker_sparql_expression_translate_expression_as_string (self, _tmp285_, &_inner_error_);
#line 712 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																												if (_inner_error_ != NULL) {
#line 712 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																													if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 712 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																														g_propagate_error (error, _inner_error_);
#line 712 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																														return 0;
#line 6915 "tracker-sparql-expression.c"
																													} else {
#line 712 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																														g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 712 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																														g_clear_error (&_inner_error_);
#line 712 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																														return 0;
#line 6923 "tracker-sparql-expression.c"
																													}
																												}
#line 713 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																												_tmp286_ = sql;
#line 713 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																												g_string_append (_tmp286_, ", ");
#line 714 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																												tracker_sparql_expression_expect (self, TRACKER_SPARQL_TOKEN_TYPE_COMMA, &_inner_error_);
#line 714 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																												if (_inner_error_ != NULL) {
#line 714 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																													if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 714 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																														g_propagate_error (error, _inner_error_);
#line 714 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																														return 0;
#line 6940 "tracker-sparql-expression.c"
																													} else {
#line 714 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																														g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 714 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																														g_clear_error (&_inner_error_);
#line 714 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																														return 0;
#line 6948 "tracker-sparql-expression.c"
																													}
																												}
#line 716 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																												_tmp287_ = sql;
#line 716 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																												tracker_sparql_expression_translate_expression_as_string (self, _tmp287_, &_inner_error_);
#line 716 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																												if (_inner_error_ != NULL) {
#line 716 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																													if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 716 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																														g_propagate_error (error, _inner_error_);
#line 716 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																														return 0;
#line 6963 "tracker-sparql-expression.c"
																													} else {
#line 716 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																														g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 716 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																														g_clear_error (&_inner_error_);
#line 716 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																														return 0;
#line 6971 "tracker-sparql-expression.c"
																													}
																												}
#line 717 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																												_tmp288_ = sql;
#line 717 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																												g_string_append (_tmp288_, ")");
#line 719 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																												result = TRACKER_PROPERTY_TYPE_BOOLEAN;
#line 719 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																												return result;
#line 6982 "tracker-sparql-expression.c"
																											} else {
																												const gchar* _tmp289_;
#line 720 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																												_tmp289_ = uri;
#line 720 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																												if (g_strcmp0 (_tmp289_, TRACKER_SPARQL_EXPRESSION_TRACKER_NS "uri-is-descendant") == 0) {
#line 6989 "tracker-sparql-expression.c"
																													GString* _tmp290_;
																													GString* _tmp291_;
																													GString* _tmp292_;
																													GString* _tmp293_;
																													GString* _tmp298_;
#line 721 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																													_tmp290_ = sql;
#line 721 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																													g_string_append (_tmp290_, "SparqlUriIsDescendant(");
#line 722 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																													_tmp291_ = sql;
#line 722 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																													tracker_sparql_expression_translate_expression_as_string (self, _tmp291_, &_inner_error_);
#line 722 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																													if (_inner_error_ != NULL) {
#line 722 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																														if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 722 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																															g_propagate_error (error, _inner_error_);
#line 722 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																															return 0;
#line 7011 "tracker-sparql-expression.c"
																														} else {
#line 722 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																															g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 722 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																															g_clear_error (&_inner_error_);
#line 722 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																															return 0;
#line 7019 "tracker-sparql-expression.c"
																														}
																													}
#line 723 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																													_tmp292_ = sql;
#line 723 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																													g_string_append (_tmp292_, ", ");
#line 724 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																													tracker_sparql_expression_expect (self, TRACKER_SPARQL_TOKEN_TYPE_COMMA, &_inner_error_);
#line 724 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																													if (_inner_error_ != NULL) {
#line 724 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																														if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 724 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																															g_propagate_error (error, _inner_error_);
#line 724 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																															return 0;
#line 7036 "tracker-sparql-expression.c"
																														} else {
#line 724 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																															g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 724 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																															g_clear_error (&_inner_error_);
#line 724 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																															return 0;
#line 7044 "tracker-sparql-expression.c"
																														}
																													}
#line 726 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																													_tmp293_ = sql;
#line 726 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																													tracker_sparql_expression_translate_expression_as_string (self, _tmp293_, &_inner_error_);
#line 726 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																													if (_inner_error_ != NULL) {
#line 726 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																														if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 726 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																															g_propagate_error (error, _inner_error_);
#line 726 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																															return 0;
#line 7059 "tracker-sparql-expression.c"
																														} else {
#line 726 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																															g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 726 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																															g_clear_error (&_inner_error_);
#line 726 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																															return 0;
#line 7067 "tracker-sparql-expression.c"
																														}
																													}
#line 727 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																													while (TRUE) {
#line 7072 "tracker-sparql-expression.c"
																														gboolean _tmp294_ = FALSE;
																														gboolean _tmp295_;
																														GString* _tmp296_;
																														GString* _tmp297_;
#line 727 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																														_tmp294_ = tracker_sparql_expression_accept (self, TRACKER_SPARQL_TOKEN_TYPE_COMMA, &_inner_error_);
#line 727 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																														_tmp295_ = _tmp294_;
#line 727 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																														if (_inner_error_ != NULL) {
#line 727 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																															if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 727 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																																g_propagate_error (error, _inner_error_);
#line 727 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																																return 0;
#line 7089 "tracker-sparql-expression.c"
																															} else {
#line 727 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																																g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 727 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																																g_clear_error (&_inner_error_);
#line 727 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																																return 0;
#line 7097 "tracker-sparql-expression.c"
																															}
																														}
#line 727 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																														if (!_tmp295_) {
#line 727 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																															break;
#line 7104 "tracker-sparql-expression.c"
																														}
#line 728 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																														_tmp296_ = sql;
#line 728 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																														g_string_append (_tmp296_, ", ");
#line 729 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																														_tmp297_ = sql;
#line 729 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																														tracker_sparql_expression_translate_expression_as_string (self, _tmp297_, &_inner_error_);
#line 729 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																														if (_inner_error_ != NULL) {
#line 729 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																															if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 729 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																																g_propagate_error (error, _inner_error_);
#line 729 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																																return 0;
#line 7122 "tracker-sparql-expression.c"
																															} else {
#line 729 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																																g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 729 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																																g_clear_error (&_inner_error_);
#line 729 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																																return 0;
#line 7130 "tracker-sparql-expression.c"
																															}
																														}
																													}
#line 731 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																													_tmp298_ = sql;
#line 731 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																													g_string_append (_tmp298_, ")");
#line 733 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																													result = TRACKER_PROPERTY_TYPE_BOOLEAN;
#line 733 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																													return result;
#line 7142 "tracker-sparql-expression.c"
																												} else {
																													const gchar* _tmp299_;
#line 734 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																													_tmp299_ = uri;
#line 734 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																													if (g_strcmp0 (_tmp299_, TRACKER_SPARQL_EXPRESSION_TRACKER_NS "string-from-filename") == 0) {
#line 7149 "tracker-sparql-expression.c"
																														GString* _tmp300_;
																														GString* _tmp301_;
																														GString* _tmp302_;
#line 735 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																														_tmp300_ = sql;
#line 735 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																														g_string_append (_tmp300_, "SparqlStringFromFilename(");
#line 736 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																														_tmp301_ = sql;
#line 736 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																														tracker_sparql_expression_translate_expression_as_string (self, _tmp301_, &_inner_error_);
#line 736 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																														if (_inner_error_ != NULL) {
#line 736 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																															if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 736 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																																g_propagate_error (error, _inner_error_);
#line 736 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																																return 0;
#line 7169 "tracker-sparql-expression.c"
																															} else {
#line 736 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																																g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 736 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																																g_clear_error (&_inner_error_);
#line 736 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																																return 0;
#line 7177 "tracker-sparql-expression.c"
																															}
																														}
#line 737 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																														_tmp302_ = sql;
#line 737 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																														g_string_append (_tmp302_, ")");
#line 739 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																														result = TRACKER_PROPERTY_TYPE_STRING;
#line 739 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																														return result;
#line 7188 "tracker-sparql-expression.c"
																													} else {
																														const gchar* _tmp303_;
																														TrackerProperty* _tmp304_ = NULL;
																														TrackerProperty* _tmp305_;
																														TrackerProperty* prop;
																														TrackerProperty* _tmp306_;
																														GString* _tmp308_;
																														GString* expr;
																														GString* _tmp309_;
																														gchar* _tmp310_;
																														gchar* value_separator;
																														gchar* graph_separator;
																														gboolean _tmp311_ = FALSE;
																														gboolean _tmp312_;
																														TrackerProperty* _tmp319_;
																														gboolean _tmp320_;
																														gboolean _tmp321_;
#line 742 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																														_tmp303_ = uri;
#line 742 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																														_tmp304_ = tracker_ontologies_get_property_by_uri (_tmp303_);
#line 742 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																														_tmp305_ = _g_object_ref0 (_tmp304_);
#line 742 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																														prop = _tmp305_;
#line 743 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																														_tmp306_ = prop;
#line 743 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																														if (_tmp306_ == NULL) {
#line 7218 "tracker-sparql-expression.c"
																															GError* _tmp307_ = NULL;
#line 744 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																															_tmp307_ = tracker_sparql_expression_get_error (self, "Unknown function");
#line 744 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																															_inner_error_ = _tmp307_;
#line 744 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																															if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 744 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																																g_propagate_error (error, _inner_error_);
#line 744 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																																_g_object_unref0 (prop);
#line 744 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																																return 0;
#line 7232 "tracker-sparql-expression.c"
																															} else {
#line 744 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																																_g_object_unref0 (prop);
#line 744 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																																g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 744 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																																g_clear_error (&_inner_error_);
#line 744 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																																return 0;
#line 7242 "tracker-sparql-expression.c"
																															}
																														}
#line 747 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																														_tmp308_ = g_string_new ("");
#line 747 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																														expr = _tmp308_;
#line 748 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																														_tmp309_ = expr;
#line 748 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																														tracker_sparql_expression_translate_expression (self, _tmp309_, &_inner_error_);
#line 748 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																														if (_inner_error_ != NULL) {
#line 748 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																															if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 748 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																																g_propagate_error (error, _inner_error_);
#line 748 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																																_g_string_free0 (expr);
#line 748 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																																_g_object_unref0 (prop);
#line 748 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																																return 0;
#line 7265 "tracker-sparql-expression.c"
																															} else {
#line 748 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																																_g_string_free0 (expr);
#line 748 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																																_g_object_unref0 (prop);
#line 748 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																																g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 748 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																																g_clear_error (&_inner_error_);
#line 748 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																																return 0;
#line 7277 "tracker-sparql-expression.c"
																															}
																														}
#line 750 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																														_tmp310_ = g_strdup (",");
#line 750 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																														value_separator = _tmp310_;
#line 751 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																														graph_separator = NULL;
#line 753 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																														_tmp311_ = tracker_sparql_expression_accept (self, TRACKER_SPARQL_TOKEN_TYPE_COMMA, &_inner_error_);
#line 753 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																														_tmp312_ = _tmp311_;
#line 753 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																														if (_inner_error_ != NULL) {
#line 753 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																															if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 753 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																																g_propagate_error (error, _inner_error_);
#line 753 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																																_g_free0 (graph_separator);
#line 753 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																																_g_free0 (value_separator);
#line 753 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																																_g_string_free0 (expr);
#line 753 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																																_g_object_unref0 (prop);
#line 753 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																																return 0;
#line 7306 "tracker-sparql-expression.c"
																															} else {
#line 753 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																																_g_free0 (graph_separator);
#line 753 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																																_g_free0 (value_separator);
#line 753 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																																_g_string_free0 (expr);
#line 753 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																																_g_object_unref0 (prop);
#line 753 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																																g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 753 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																																g_clear_error (&_inner_error_);
#line 753 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																																return 0;
#line 7322 "tracker-sparql-expression.c"
																															}
																														}
#line 753 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																														if (_tmp312_) {
#line 7327 "tracker-sparql-expression.c"
																															gchar* _tmp313_ = NULL;
																															gchar* _tmp314_;
																															gboolean _tmp315_ = FALSE;
																															gboolean _tmp316_;
#line 754 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																															_tmp313_ = tracker_sparql_expression_parse_string_literal (self, NULL, &_inner_error_);
#line 754 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																															_tmp314_ = _tmp313_;
#line 754 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																															if (_inner_error_ != NULL) {
#line 754 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																																if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 754 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																																	g_propagate_error (error, _inner_error_);
#line 754 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																																	_g_free0 (graph_separator);
#line 754 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																																	_g_free0 (value_separator);
#line 754 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																																	_g_string_free0 (expr);
#line 754 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																																	_g_object_unref0 (prop);
#line 754 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																																	return 0;
#line 7352 "tracker-sparql-expression.c"
																																} else {
#line 754 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																																	_g_free0 (graph_separator);
#line 754 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																																	_g_free0 (value_separator);
#line 754 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																																	_g_string_free0 (expr);
#line 754 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																																	_g_object_unref0 (prop);
#line 754 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																																	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 754 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																																	g_clear_error (&_inner_error_);
#line 754 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																																	return 0;
#line 7368 "tracker-sparql-expression.c"
																																}
																															}
#line 754 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																															_g_free0 (value_separator);
#line 754 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																															value_separator = _tmp314_;
#line 756 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																															_tmp315_ = tracker_sparql_expression_accept (self, TRACKER_SPARQL_TOKEN_TYPE_COMMA, &_inner_error_);
#line 756 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																															_tmp316_ = _tmp315_;
#line 756 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																															if (_inner_error_ != NULL) {
#line 756 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																																if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 756 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																																	g_propagate_error (error, _inner_error_);
#line 756 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																																	_g_free0 (graph_separator);
#line 756 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																																	_g_free0 (value_separator);
#line 756 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																																	_g_string_free0 (expr);
#line 756 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																																	_g_object_unref0 (prop);
#line 756 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																																	return 0;
#line 7395 "tracker-sparql-expression.c"
																																} else {
#line 756 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																																	_g_free0 (graph_separator);
#line 756 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																																	_g_free0 (value_separator);
#line 756 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																																	_g_string_free0 (expr);
#line 756 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																																	_g_object_unref0 (prop);
#line 756 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																																	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 756 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																																	g_clear_error (&_inner_error_);
#line 756 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																																	return 0;
#line 7411 "tracker-sparql-expression.c"
																																}
																															}
#line 756 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																															if (_tmp316_) {
#line 7416 "tracker-sparql-expression.c"
																																gchar* _tmp317_ = NULL;
																																gchar* _tmp318_;
#line 757 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																																_tmp317_ = tracker_sparql_expression_parse_string_literal (self, NULL, &_inner_error_);
#line 757 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																																_tmp318_ = _tmp317_;
#line 757 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																																if (_inner_error_ != NULL) {
#line 757 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																																	if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 757 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																																		g_propagate_error (error, _inner_error_);
#line 757 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																																		_g_free0 (graph_separator);
#line 757 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																																		_g_free0 (value_separator);
#line 757 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																																		_g_string_free0 (expr);
#line 757 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																																		_g_object_unref0 (prop);
#line 757 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																																		return 0;
#line 7439 "tracker-sparql-expression.c"
																																	} else {
#line 757 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																																		_g_free0 (graph_separator);
#line 757 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																																		_g_free0 (value_separator);
#line 757 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																																		_g_string_free0 (expr);
#line 757 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																																		_g_object_unref0 (prop);
#line 757 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																																		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 757 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																																		g_clear_error (&_inner_error_);
#line 757 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																																		return 0;
#line 7455 "tracker-sparql-expression.c"
																																	}
																																}
#line 757 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																																_g_free0 (graph_separator);
#line 757 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																																graph_separator = _tmp318_;
#line 7462 "tracker-sparql-expression.c"
																															}
																														}
#line 761 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																														_tmp319_ = prop;
#line 761 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																														_tmp320_ = tracker_property_get_multiple_values (_tmp319_);
#line 761 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																														_tmp321_ = _tmp320_;
#line 761 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																														if (_tmp321_) {
#line 7473 "tracker-sparql-expression.c"
																															GString* _tmp322_;
																															GString* _tmp323_;
																															gssize _tmp324_;
																															glong begin;
																															GString* _tmp325_;
																															TrackerProperty* _tmp326_;
																															const gchar* _tmp327_;
																															const gchar* _tmp328_;
																															GString* _tmp329_;
																															TrackerProperty* _tmp330_;
																															TrackerPropertyType _tmp331_;
																															TrackerPropertyType _tmp332_;
																															glong _tmp333_;
																															const gchar* _tmp334_;
																															GString* _tmp342_;
																															const gchar* _tmp343_;
																															gchar* _tmp344_ = NULL;
																															gchar* _tmp345_;
																															GString* _tmp346_;
																															TrackerProperty* _tmp347_;
																															const gchar* _tmp348_;
																															const gchar* _tmp349_;
																															GString* _tmp350_;
																															const gchar* _tmp351_;
#line 763 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																															_tmp322_ = sql;
#line 763 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																															g_string_append (_tmp322_, "(SELECT GROUP_CONCAT(");
#line 764 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																															_tmp323_ = sql;
#line 764 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																															_tmp324_ = _tmp323_->len;
#line 764 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																															begin = (glong) _tmp324_;
#line 765 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																															_tmp325_ = sql;
#line 765 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																															_tmp326_ = prop;
#line 765 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																															_tmp327_ = tracker_property_get_name (_tmp326_);
#line 765 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																															_tmp328_ = _tmp327_;
#line 765 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																															g_string_append_printf (_tmp325_, "\"%s\"", _tmp328_);
#line 766 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																															_tmp329_ = sql;
#line 766 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																															_tmp330_ = prop;
#line 766 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																															_tmp331_ = tracker_property_get_data_type (_tmp330_);
#line 766 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																															_tmp332_ = _tmp331_;
#line 766 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																															_tmp333_ = begin;
#line 766 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																															tracker_sparql_expression_convert_expression_to_string (_tmp329_, _tmp332_, _tmp333_);
#line 767 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																															_tmp334_ = graph_separator;
#line 767 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																															if (_tmp334_ != NULL) {
#line 7534 "tracker-sparql-expression.c"
																																GString* _tmp335_;
																																const gchar* _tmp336_;
																																gchar* _tmp337_ = NULL;
																																gchar* _tmp338_;
																																TrackerProperty* _tmp339_;
																																const gchar* _tmp340_;
																																const gchar* _tmp341_;
#line 768 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																																_tmp335_ = sql;
#line 768 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																																_tmp336_ = graph_separator;
#line 768 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																																_tmp337_ = tracker_sparql_expression_escape_sql_string_literal (self, _tmp336_);
#line 768 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																																_tmp338_ = _tmp337_;
#line 768 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																																_tmp339_ = prop;
#line 768 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																																_tmp340_ = tracker_property_get_name (_tmp339_);
#line 768 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																																_tmp341_ = _tmp340_;
#line 768 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																																g_string_append_printf (_tmp335_, " || %s || COALESCE((SELECT Uri FROM Resource WHERE ID = \"%s:graph\")," \
" '')", _tmp338_, _tmp341_);
#line 768 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																																_g_free0 (_tmp338_);
#line 7560 "tracker-sparql-expression.c"
																															}
#line 770 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																															_tmp342_ = sql;
#line 770 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																															_tmp343_ = value_separator;
#line 770 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																															_tmp344_ = tracker_sparql_expression_escape_sql_string_literal (self, _tmp343_);
#line 770 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																															_tmp345_ = _tmp344_;
#line 770 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																															g_string_append_printf (_tmp342_, ",%s)", _tmp345_);
#line 770 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																															_g_free0 (_tmp345_);
#line 771 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																															_tmp346_ = sql;
#line 771 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																															_tmp347_ = prop;
#line 771 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																															_tmp348_ = tracker_property_get_table_name (_tmp347_);
#line 771 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																															_tmp349_ = _tmp348_;
#line 771 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																															_tmp350_ = expr;
#line 771 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																															_tmp351_ = _tmp350_->str;
#line 771 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																															g_string_append_printf (_tmp346_, " FROM \"%s\" WHERE ID = %s)", _tmp349_, _tmp351_);
#line 773 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																															result = TRACKER_PROPERTY_TYPE_STRING;
#line 773 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																															_g_free0 (graph_separator);
#line 773 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																															_g_free0 (value_separator);
#line 773 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																															_g_string_free0 (expr);
#line 773 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																															_g_object_unref0 (prop);
#line 773 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																															return result;
#line 7600 "tracker-sparql-expression.c"
																														} else {
																															const gchar* _tmp352_;
#line 776 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																															_tmp352_ = graph_separator;
#line 776 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																															if (_tmp352_ == NULL) {
#line 7607 "tracker-sparql-expression.c"
																																GString* _tmp353_;
																																TrackerProperty* _tmp354_;
																																const gchar* _tmp355_;
																																const gchar* _tmp356_;
																																TrackerProperty* _tmp357_;
																																const gchar* _tmp358_;
																																const gchar* _tmp359_;
																																GString* _tmp360_;
																																const gchar* _tmp361_;
																																TrackerProperty* _tmp362_;
																																TrackerPropertyType _tmp363_;
																																TrackerPropertyType _tmp364_;
																																TrackerProperty* _tmp366_;
																																TrackerPropertyType _tmp367_;
																																TrackerPropertyType _tmp368_;
#line 777 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																																_tmp353_ = sql;
#line 777 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																																_tmp354_ = prop;
#line 777 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																																_tmp355_ = tracker_property_get_name (_tmp354_);
#line 777 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																																_tmp356_ = _tmp355_;
#line 777 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																																_tmp357_ = prop;
#line 777 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																																_tmp358_ = tracker_property_get_table_name (_tmp357_);
#line 777 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																																_tmp359_ = _tmp358_;
#line 777 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																																_tmp360_ = expr;
#line 777 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																																_tmp361_ = _tmp360_->str;
#line 777 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																																g_string_append_printf (_tmp353_, "(SELECT \"%s\" FROM \"%s\" WHERE ID = %s)", _tmp356_, _tmp359_, _tmp361_);
#line 779 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																																_tmp362_ = prop;
#line 779 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																																_tmp363_ = tracker_property_get_data_type (_tmp362_);
#line 779 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																																_tmp364_ = _tmp363_;
#line 779 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																																if (_tmp364_ == TRACKER_PROPERTY_TYPE_STRING) {
#line 7651 "tracker-sparql-expression.c"
																																	GString* _tmp365_;
#line 780 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																																	_tmp365_ = sql;
#line 780 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																																	tracker_sparql_expression_append_collate (self, _tmp365_);
#line 7657 "tracker-sparql-expression.c"
																																}
#line 783 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																																_tmp366_ = prop;
#line 783 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																																_tmp367_ = tracker_property_get_data_type (_tmp366_);
#line 783 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																																_tmp368_ = _tmp367_;
#line 783 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																																result = _tmp368_;
#line 783 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																																_g_free0 (graph_separator);
#line 783 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																																_g_free0 (value_separator);
#line 783 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																																_g_string_free0 (expr);
#line 783 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																																_g_object_unref0 (prop);
#line 783 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																																return result;
#line 7677 "tracker-sparql-expression.c"
																															} else {
																																GString* _tmp369_;
																																GString* _tmp370_;
																																gssize _tmp371_;
																																glong begin;
																																GString* _tmp372_;
																																TrackerProperty* _tmp373_;
																																const gchar* _tmp374_;
																																const gchar* _tmp375_;
																																GString* _tmp376_;
																																TrackerProperty* _tmp377_;
																																TrackerPropertyType _tmp378_;
																																TrackerPropertyType _tmp379_;
																																glong _tmp380_;
																																GString* _tmp381_;
																																const gchar* _tmp382_;
																																gchar* _tmp383_ = NULL;
																																gchar* _tmp384_;
																																TrackerProperty* _tmp385_;
																																const gchar* _tmp386_;
																																const gchar* _tmp387_;
																																GString* _tmp388_;
																																TrackerProperty* _tmp389_;
																																const gchar* _tmp390_;
																																const gchar* _tmp391_;
																																GString* _tmp392_;
																																const gchar* _tmp393_;
#line 785 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																																_tmp369_ = sql;
#line 785 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																																g_string_append (_tmp369_, "(SELECT ");
#line 786 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																																_tmp370_ = sql;
#line 786 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																																_tmp371_ = _tmp370_->len;
#line 786 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																																begin = (glong) _tmp371_;
#line 787 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																																_tmp372_ = sql;
#line 787 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																																_tmp373_ = prop;
#line 787 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																																_tmp374_ = tracker_property_get_name (_tmp373_);
#line 787 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																																_tmp375_ = _tmp374_;
#line 787 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																																g_string_append_printf (_tmp372_, "\"%s\"", _tmp375_);
#line 788 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																																_tmp376_ = sql;
#line 788 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																																_tmp377_ = prop;
#line 788 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																																_tmp378_ = tracker_property_get_data_type (_tmp377_);
#line 788 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																																_tmp379_ = _tmp378_;
#line 788 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																																_tmp380_ = begin;
#line 788 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																																tracker_sparql_expression_convert_expression_to_string (_tmp376_, _tmp379_, _tmp380_);
#line 789 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																																_tmp381_ = sql;
#line 789 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																																_tmp382_ = graph_separator;
#line 789 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																																_tmp383_ = tracker_sparql_expression_escape_sql_string_literal (self, _tmp382_);
#line 789 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																																_tmp384_ = _tmp383_;
#line 789 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																																_tmp385_ = prop;
#line 789 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																																_tmp386_ = tracker_property_get_name (_tmp385_);
#line 789 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																																_tmp387_ = _tmp386_;
#line 789 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																																g_string_append_printf (_tmp381_, " || %s || COALESCE((SELECT Uri FROM Resource WHERE ID = \"%s:graph\")," \
" '')", _tmp384_, _tmp387_);
#line 789 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																																_g_free0 (_tmp384_);
#line 790 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																																_tmp388_ = sql;
#line 790 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																																_tmp389_ = prop;
#line 790 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																																_tmp390_ = tracker_property_get_table_name (_tmp389_);
#line 790 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																																_tmp391_ = _tmp390_;
#line 790 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																																_tmp392_ = expr;
#line 790 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																																_tmp393_ = _tmp392_->str;
#line 790 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																																g_string_append_printf (_tmp388_, " FROM \"%s\" WHERE ID = %s)", _tmp391_, _tmp393_);
#line 792 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																																result = TRACKER_PROPERTY_TYPE_STRING;
#line 792 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																																_g_free0 (graph_separator);
#line 792 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																																_g_free0 (value_separator);
#line 792 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																																_g_string_free0 (expr);
#line 792 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																																_g_object_unref0 (prop);
#line 792 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																																return result;
#line 7781 "tracker-sparql-expression.c"
																															}
																														}
#line 734 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																														_g_free0 (graph_separator);
#line 734 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																														_g_free0 (value_separator);
#line 734 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																														_g_string_free0 (expr);
#line 734 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																														_g_object_unref0 (prop);
#line 7792 "tracker-sparql-expression.c"
																													}
																												}
																											}
																										}
																									}
																								}
																							}
																						}
																					}
																				}
																			}
																		}
																	}
																}
															}
														}
													}
												}
											}
										}
									}
								}
							}
						}
					}
				}
			}
		}
	}
}


static TrackerPropertyType tracker_sparql_expression_parse_type_uri (TrackerSparqlExpression* self, GError** error) {
	TrackerPropertyType result = 0;
	gchar* type_iri = NULL;
	TrackerPropertyType type = 0;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_;
	const gchar* _tmp23_;
	GError * _inner_error_ = NULL;
#line 798 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	g_return_val_if_fail (self != NULL, 0);
#line 802 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	_tmp0_ = tracker_sparql_expression_accept (self, TRACKER_SPARQL_TOKEN_TYPE_IRI_REF, &_inner_error_);
#line 802 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	_tmp1_ = _tmp0_;
#line 802 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	if (_inner_error_ != NULL) {
#line 802 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 802 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			g_propagate_error (error, _inner_error_);
#line 802 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_g_free0 (type_iri);
#line 802 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			return 0;
#line 7849 "tracker-sparql-expression.c"
		} else {
#line 802 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_g_free0 (type_iri);
#line 802 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 802 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			g_clear_error (&_inner_error_);
#line 802 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			return 0;
#line 7859 "tracker-sparql-expression.c"
		}
	}
#line 802 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	if (_tmp1_) {
#line 7864 "tracker-sparql-expression.c"
		gchar* _tmp2_ = NULL;
#line 803 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		_tmp2_ = tracker_sparql_expression_get_last_string (self, 1);
#line 803 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		_g_free0 (type_iri);
#line 803 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		type_iri = _tmp2_;
#line 7872 "tracker-sparql-expression.c"
	} else {
		gboolean _tmp3_ = FALSE;
		gboolean _tmp4_;
#line 804 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		_tmp3_ = tracker_sparql_expression_accept (self, TRACKER_SPARQL_TOKEN_TYPE_PN_PREFIX, &_inner_error_);
#line 804 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		_tmp4_ = _tmp3_;
#line 804 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		if (_inner_error_ != NULL) {
#line 804 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 804 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				g_propagate_error (error, _inner_error_);
#line 804 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				_g_free0 (type_iri);
#line 804 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				return 0;
#line 7890 "tracker-sparql-expression.c"
			} else {
#line 804 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				_g_free0 (type_iri);
#line 804 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 804 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				g_clear_error (&_inner_error_);
#line 804 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				return 0;
#line 7900 "tracker-sparql-expression.c"
			}
		}
#line 804 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		if (_tmp4_) {
#line 7905 "tracker-sparql-expression.c"
			gchar* _tmp5_ = NULL;
			gchar* ns;
			TrackerSparqlQuery* _tmp6_;
			const gchar* _tmp7_;
			gchar* _tmp8_ = NULL;
			gchar* _tmp9_;
			gchar* _tmp10_ = NULL;
			gchar* _tmp11_;
			gchar* _tmp12_ = NULL;
			gchar* _tmp13_;
			gchar* _tmp14_;
#line 805 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp5_ = tracker_sparql_expression_get_last_string (self, 0);
#line 805 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			ns = _tmp5_;
#line 806 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			tracker_sparql_expression_expect (self, TRACKER_SPARQL_TOKEN_TYPE_COLON, &_inner_error_);
#line 806 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			if (_inner_error_ != NULL) {
#line 806 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 806 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_propagate_error (error, _inner_error_);
#line 806 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					_g_free0 (ns);
#line 806 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					_g_free0 (type_iri);
#line 806 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					return 0;
#line 7935 "tracker-sparql-expression.c"
				} else {
#line 806 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					_g_free0 (ns);
#line 806 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					_g_free0 (type_iri);
#line 806 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 806 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_clear_error (&_inner_error_);
#line 806 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					return 0;
#line 7947 "tracker-sparql-expression.c"
				}
			}
#line 807 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp6_ = self->priv->query;
#line 807 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp7_ = ns;
#line 807 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp8_ = tracker_sparql_expression_get_last_string (self, 0);
#line 807 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp9_ = _tmp8_;
#line 807 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp10_ = string_substring (_tmp9_, (glong) 1, (glong) (-1));
#line 807 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp11_ = _tmp10_;
#line 807 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp12_ = tracker_sparql_query_resolve_prefixed_name (_tmp6_, _tmp7_, _tmp11_, &_inner_error_);
#line 807 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp13_ = _tmp12_;
#line 807 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_g_free0 (_tmp11_);
#line 807 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_g_free0 (_tmp9_);
#line 807 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp14_ = _tmp13_;
#line 807 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			if (_inner_error_ != NULL) {
#line 807 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 807 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_propagate_error (error, _inner_error_);
#line 807 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					_g_free0 (ns);
#line 807 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					_g_free0 (type_iri);
#line 807 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					return 0;
#line 7984 "tracker-sparql-expression.c"
				} else {
#line 807 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					_g_free0 (ns);
#line 807 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					_g_free0 (type_iri);
#line 807 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 807 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_clear_error (&_inner_error_);
#line 807 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					return 0;
#line 7996 "tracker-sparql-expression.c"
				}
			}
#line 807 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_g_free0 (type_iri);
#line 807 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			type_iri = _tmp14_;
#line 804 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_g_free0 (ns);
#line 8005 "tracker-sparql-expression.c"
		} else {
			TrackerSparqlQuery* _tmp15_;
			gchar* _tmp16_ = NULL;
			gchar* _tmp17_;
			gchar* _tmp18_ = NULL;
			gchar* _tmp19_;
			gchar* _tmp20_ = NULL;
			gchar* _tmp21_;
			gchar* _tmp22_;
#line 809 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			tracker_sparql_expression_expect (self, TRACKER_SPARQL_TOKEN_TYPE_COLON, &_inner_error_);
#line 809 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			if (_inner_error_ != NULL) {
#line 809 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 809 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_propagate_error (error, _inner_error_);
#line 809 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					_g_free0 (type_iri);
#line 809 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					return 0;
#line 8027 "tracker-sparql-expression.c"
				} else {
#line 809 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					_g_free0 (type_iri);
#line 809 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 809 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_clear_error (&_inner_error_);
#line 809 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					return 0;
#line 8037 "tracker-sparql-expression.c"
				}
			}
#line 810 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp15_ = self->priv->query;
#line 810 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp16_ = tracker_sparql_expression_get_last_string (self, 0);
#line 810 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp17_ = _tmp16_;
#line 810 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp18_ = string_substring (_tmp17_, (glong) 1, (glong) (-1));
#line 810 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp19_ = _tmp18_;
#line 810 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp20_ = tracker_sparql_query_resolve_prefixed_name (_tmp15_, "", _tmp19_, &_inner_error_);
#line 810 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp21_ = _tmp20_;
#line 810 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_g_free0 (_tmp19_);
#line 810 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_g_free0 (_tmp17_);
#line 810 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp22_ = _tmp21_;
#line 810 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			if (_inner_error_ != NULL) {
#line 810 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 810 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_propagate_error (error, _inner_error_);
#line 810 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					_g_free0 (type_iri);
#line 810 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					return 0;
#line 8070 "tracker-sparql-expression.c"
				} else {
#line 810 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					_g_free0 (type_iri);
#line 810 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 810 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_clear_error (&_inner_error_);
#line 810 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					return 0;
#line 8080 "tracker-sparql-expression.c"
				}
			}
#line 810 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_g_free0 (type_iri);
#line 810 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			type_iri = _tmp22_;
#line 8087 "tracker-sparql-expression.c"
		}
	}
#line 813 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	_tmp23_ = type_iri;
#line 813 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	if (g_strcmp0 (_tmp23_, TRACKER_SPARQL_EXPRESSION_XSD_NS "boolean") == 0) {
#line 814 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		type = TRACKER_PROPERTY_TYPE_BOOLEAN;
#line 8096 "tracker-sparql-expression.c"
	} else {
		gboolean _tmp24_ = FALSE;
		gboolean _tmp25_ = FALSE;
		gboolean _tmp26_ = FALSE;
		gboolean _tmp27_ = FALSE;
		gboolean _tmp28_ = FALSE;
		gboolean _tmp29_ = FALSE;
		gboolean _tmp30_ = FALSE;
		gboolean _tmp31_ = FALSE;
		gboolean _tmp32_ = FALSE;
		gboolean _tmp33_ = FALSE;
		gboolean _tmp34_ = FALSE;
		gboolean _tmp35_ = FALSE;
		const gchar* _tmp36_;
		gboolean _tmp38_;
		gboolean _tmp40_;
		gboolean _tmp42_;
		gboolean _tmp44_;
		gboolean _tmp46_;
		gboolean _tmp48_;
		gboolean _tmp50_;
		gboolean _tmp52_;
		gboolean _tmp54_;
		gboolean _tmp56_;
		gboolean _tmp58_;
		gboolean _tmp60_;
#line 815 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		_tmp36_ = type_iri;
#line 815 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		if (g_strcmp0 (_tmp36_, TRACKER_SPARQL_EXPRESSION_XSD_NS "integer") == 0) {
#line 815 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp35_ = TRUE;
#line 8129 "tracker-sparql-expression.c"
		} else {
			const gchar* _tmp37_;
#line 816 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp37_ = type_iri;
#line 816 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp35_ = g_strcmp0 (_tmp37_, TRACKER_SPARQL_EXPRESSION_XSD_NS "nonPositiveInteger") == 0;
#line 8136 "tracker-sparql-expression.c"
		}
#line 815 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		_tmp38_ = _tmp35_;
#line 815 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		if (_tmp38_) {
#line 815 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp34_ = TRUE;
#line 8144 "tracker-sparql-expression.c"
		} else {
			const gchar* _tmp39_;
#line 817 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp39_ = type_iri;
#line 817 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp34_ = g_strcmp0 (_tmp39_, TRACKER_SPARQL_EXPRESSION_XSD_NS "negativeInteger") == 0;
#line 8151 "tracker-sparql-expression.c"
		}
#line 815 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		_tmp40_ = _tmp34_;
#line 815 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		if (_tmp40_) {
#line 815 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp33_ = TRUE;
#line 8159 "tracker-sparql-expression.c"
		} else {
			const gchar* _tmp41_;
#line 818 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp41_ = type_iri;
#line 818 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp33_ = g_strcmp0 (_tmp41_, TRACKER_SPARQL_EXPRESSION_XSD_NS "long") == 0;
#line 8166 "tracker-sparql-expression.c"
		}
#line 815 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		_tmp42_ = _tmp33_;
#line 815 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		if (_tmp42_) {
#line 815 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp32_ = TRUE;
#line 8174 "tracker-sparql-expression.c"
		} else {
			const gchar* _tmp43_;
#line 819 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp43_ = type_iri;
#line 819 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp32_ = g_strcmp0 (_tmp43_, TRACKER_SPARQL_EXPRESSION_XSD_NS "int") == 0;
#line 8181 "tracker-sparql-expression.c"
		}
#line 815 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		_tmp44_ = _tmp32_;
#line 815 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		if (_tmp44_) {
#line 815 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp31_ = TRUE;
#line 8189 "tracker-sparql-expression.c"
		} else {
			const gchar* _tmp45_;
#line 820 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp45_ = type_iri;
#line 820 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp31_ = g_strcmp0 (_tmp45_, TRACKER_SPARQL_EXPRESSION_XSD_NS "short") == 0;
#line 8196 "tracker-sparql-expression.c"
		}
#line 815 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		_tmp46_ = _tmp31_;
#line 815 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		if (_tmp46_) {
#line 815 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp30_ = TRUE;
#line 8204 "tracker-sparql-expression.c"
		} else {
			const gchar* _tmp47_;
#line 821 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp47_ = type_iri;
#line 821 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp30_ = g_strcmp0 (_tmp47_, TRACKER_SPARQL_EXPRESSION_XSD_NS "byte") == 0;
#line 8211 "tracker-sparql-expression.c"
		}
#line 815 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		_tmp48_ = _tmp30_;
#line 815 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		if (_tmp48_) {
#line 815 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp29_ = TRUE;
#line 8219 "tracker-sparql-expression.c"
		} else {
			const gchar* _tmp49_;
#line 822 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp49_ = type_iri;
#line 822 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp29_ = g_strcmp0 (_tmp49_, TRACKER_SPARQL_EXPRESSION_XSD_NS "nonNegativeInteger") == 0;
#line 8226 "tracker-sparql-expression.c"
		}
#line 815 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		_tmp50_ = _tmp29_;
#line 815 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		if (_tmp50_) {
#line 815 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp28_ = TRUE;
#line 8234 "tracker-sparql-expression.c"
		} else {
			const gchar* _tmp51_;
#line 823 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp51_ = type_iri;
#line 823 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp28_ = g_strcmp0 (_tmp51_, TRACKER_SPARQL_EXPRESSION_XSD_NS "unsignedLong") == 0;
#line 8241 "tracker-sparql-expression.c"
		}
#line 815 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		_tmp52_ = _tmp28_;
#line 815 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		if (_tmp52_) {
#line 815 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp27_ = TRUE;
#line 8249 "tracker-sparql-expression.c"
		} else {
			const gchar* _tmp53_;
#line 824 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp53_ = type_iri;
#line 824 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp27_ = g_strcmp0 (_tmp53_, TRACKER_SPARQL_EXPRESSION_XSD_NS "unsignedInt") == 0;
#line 8256 "tracker-sparql-expression.c"
		}
#line 815 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		_tmp54_ = _tmp27_;
#line 815 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		if (_tmp54_) {
#line 815 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp26_ = TRUE;
#line 8264 "tracker-sparql-expression.c"
		} else {
			const gchar* _tmp55_;
#line 825 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp55_ = type_iri;
#line 825 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp26_ = g_strcmp0 (_tmp55_, TRACKER_SPARQL_EXPRESSION_XSD_NS "unsignedShort") == 0;
#line 8271 "tracker-sparql-expression.c"
		}
#line 815 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		_tmp56_ = _tmp26_;
#line 815 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		if (_tmp56_) {
#line 815 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp25_ = TRUE;
#line 8279 "tracker-sparql-expression.c"
		} else {
			const gchar* _tmp57_;
#line 826 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp57_ = type_iri;
#line 826 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp25_ = g_strcmp0 (_tmp57_, TRACKER_SPARQL_EXPRESSION_XSD_NS "unsignedByte") == 0;
#line 8286 "tracker-sparql-expression.c"
		}
#line 815 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		_tmp58_ = _tmp25_;
#line 815 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		if (_tmp58_) {
#line 815 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp24_ = TRUE;
#line 8294 "tracker-sparql-expression.c"
		} else {
			const gchar* _tmp59_;
#line 827 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp59_ = type_iri;
#line 827 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp24_ = g_strcmp0 (_tmp59_, TRACKER_SPARQL_EXPRESSION_XSD_NS "positiveInteger") == 0;
#line 8301 "tracker-sparql-expression.c"
		}
#line 815 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		_tmp60_ = _tmp24_;
#line 815 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		if (_tmp60_) {
#line 828 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			type = TRACKER_PROPERTY_TYPE_INTEGER;
#line 8309 "tracker-sparql-expression.c"
		} else {
			const gchar* _tmp61_;
#line 829 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp61_ = type_iri;
#line 829 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			if (g_strcmp0 (_tmp61_, TRACKER_SPARQL_EXPRESSION_XSD_NS "double") == 0) {
#line 830 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				type = TRACKER_PROPERTY_TYPE_DOUBLE;
#line 8318 "tracker-sparql-expression.c"
			} else {
				const gchar* _tmp62_;
#line 831 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				_tmp62_ = type_iri;
#line 831 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				if (g_strcmp0 (_tmp62_, TRACKER_SPARQL_EXPRESSION_XSD_NS "date") == 0) {
#line 832 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					type = TRACKER_PROPERTY_TYPE_DATE;
#line 8327 "tracker-sparql-expression.c"
				} else {
					const gchar* _tmp63_;
#line 833 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					_tmp63_ = type_iri;
#line 833 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					if (g_strcmp0 (_tmp63_, TRACKER_SPARQL_EXPRESSION_XSD_NS "dateTime") == 0) {
#line 834 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
						type = TRACKER_PROPERTY_TYPE_DATETIME;
#line 8336 "tracker-sparql-expression.c"
					} else {
#line 836 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
						type = TRACKER_PROPERTY_TYPE_STRING;
#line 8340 "tracker-sparql-expression.c"
					}
				}
			}
		}
	}
#line 839 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	result = type;
#line 839 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	_g_free0 (type_iri);
#line 839 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	return result;
#line 8352 "tracker-sparql-expression.c"
}


gchar* tracker_sparql_expression_parse_string_literal (TrackerSparqlExpression* self, TrackerPropertyType* type, GError** error) {
	TrackerPropertyType _vala_type = 0;
	gchar* result = NULL;
	TrackerSparqlTokenType _tmp0_ = 0;
	GError * _inner_error_ = NULL;
#line 842 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 843 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	_vala_type = TRACKER_PROPERTY_TYPE_STRING;
#line 845 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	tracker_sparql_expression_next (self, &_inner_error_);
#line 845 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	if (_inner_error_ != NULL) {
#line 845 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 845 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			g_propagate_error (error, _inner_error_);
#line 845 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			return NULL;
#line 8375 "tracker-sparql-expression.c"
		} else {
#line 845 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 845 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			g_clear_error (&_inner_error_);
#line 845 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			return NULL;
#line 8383 "tracker-sparql-expression.c"
		}
	}
#line 846 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	_tmp0_ = tracker_sparql_expression_last (self);
#line 846 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	switch (_tmp0_) {
#line 846 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		case TRACKER_SPARQL_TOKEN_TYPE_STRING_LITERAL1:
#line 846 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		case TRACKER_SPARQL_TOKEN_TYPE_STRING_LITERAL2:
#line 8394 "tracker-sparql-expression.c"
		{
			GString* _tmp1_;
			GString* sb;
			gchar* _tmp2_ = NULL;
			gchar* s;
			const gchar* _tmp3_;
			const gchar* p;
			const gchar* _tmp4_;
			const gchar* _tmp5_;
			gint _tmp6_;
			gint _tmp7_;
			const gchar* end;
			gboolean _tmp50_ = FALSE;
			gboolean _tmp51_;
			GString* _tmp54_;
			const gchar* _tmp55_;
			gchar* _tmp56_;
#line 849 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp1_ = g_string_new ("");
#line 849 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			sb = _tmp1_;
#line 851 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp2_ = tracker_sparql_expression_get_last_string (self, 1);
#line 851 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			s = _tmp2_;
#line 852 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp3_ = s;
#line 852 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			p = _tmp3_;
#line 853 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp4_ = p;
#line 853 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp5_ = s;
#line 853 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp6_ = strlen (_tmp5_);
#line 853 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp7_ = _tmp6_;
#line 853 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			end = _tmp4_ + _tmp7_;
#line 854 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			while (TRUE) {
#line 8436 "tracker-sparql-expression.c"
				const gchar* _tmp8_;
				const gchar* _tmp9_;
				const gchar* _tmp10_;
				const gchar* _tmp11_ = NULL;
				const gchar* q;
				const gchar* _tmp12_;
#line 854 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				_tmp8_ = p;
#line 854 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				_tmp9_ = end;
#line 854 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				if (!(((glong) _tmp8_) < ((glong) _tmp9_))) {
#line 854 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					break;
#line 8451 "tracker-sparql-expression.c"
				}
#line 855 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				_tmp10_ = p;
#line 855 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				_tmp11_ = strchr (_tmp10_, (gint) '\\');
#line 855 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				q = _tmp11_;
#line 856 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				_tmp12_ = q;
#line 856 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				if (_tmp12_ == NULL) {
#line 8463 "tracker-sparql-expression.c"
					GString* _tmp13_;
					const gchar* _tmp14_;
					const gchar* _tmp15_;
					const gchar* _tmp16_;
					const gchar* _tmp17_;
#line 857 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					_tmp13_ = sb;
#line 857 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					_tmp14_ = p;
#line 857 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					_tmp15_ = end;
#line 857 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					_tmp16_ = p;
#line 857 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_string_append_len (_tmp13_, _tmp14_, (gssize) ((glong) (_tmp15_ - _tmp16_)));
#line 858 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					_tmp17_ = end;
#line 858 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					p = _tmp17_;
#line 8483 "tracker-sparql-expression.c"
				} else {
					GString* _tmp18_;
					const gchar* _tmp19_;
					const gchar* _tmp20_;
					const gchar* _tmp21_;
					const gchar* _tmp22_;
					const gchar* _tmp23_;
					gchar _tmp24_;
					const gchar* _tmp49_;
#line 860 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					_tmp18_ = sb;
#line 860 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					_tmp19_ = p;
#line 860 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					_tmp20_ = q;
#line 860 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					_tmp21_ = p;
#line 860 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_string_append_len (_tmp18_, _tmp19_, (gssize) ((glong) (_tmp20_ - _tmp21_)));
#line 861 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					_tmp22_ = q;
#line 861 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					p = _tmp22_ + 1;
#line 862 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					_tmp23_ = p;
#line 862 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					_tmp24_ = ((gchar*) _tmp23_)[0];
#line 862 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					switch (_tmp24_) {
#line 862 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
						case '\'':
#line 862 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
						case '"':
#line 862 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
						case '\\':
#line 8519 "tracker-sparql-expression.c"
						{
							GString* _tmp25_;
							const gchar* _tmp26_;
							gchar _tmp27_;
#line 866 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
							_tmp25_ = sb;
#line 866 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
							_tmp26_ = p;
#line 866 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
							_tmp27_ = ((gchar*) _tmp26_)[0];
#line 866 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
							g_string_append_c (_tmp25_, _tmp27_);
#line 867 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
							break;
#line 8534 "tracker-sparql-expression.c"
						}
#line 862 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
						case 'b':
#line 8538 "tracker-sparql-expression.c"
						{
							GString* _tmp28_;
#line 869 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
							_tmp28_ = sb;
#line 869 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
							g_string_append_c (_tmp28_, '\b');
#line 870 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
							break;
#line 8547 "tracker-sparql-expression.c"
						}
#line 862 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
						case 'f':
#line 8551 "tracker-sparql-expression.c"
						{
							GString* _tmp29_;
#line 872 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
							_tmp29_ = sb;
#line 872 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
							g_string_append_c (_tmp29_, '\f');
#line 873 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
							break;
#line 8560 "tracker-sparql-expression.c"
						}
#line 862 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
						case 'n':
#line 8564 "tracker-sparql-expression.c"
						{
							GString* _tmp30_;
#line 875 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
							_tmp30_ = sb;
#line 875 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
							g_string_append_c (_tmp30_, '\n');
#line 876 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
							break;
#line 8573 "tracker-sparql-expression.c"
						}
#line 862 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
						case 'r':
#line 8577 "tracker-sparql-expression.c"
						{
							GString* _tmp31_;
#line 878 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
							_tmp31_ = sb;
#line 878 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
							g_string_append_c (_tmp31_, '\r');
#line 879 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
							break;
#line 8586 "tracker-sparql-expression.c"
						}
#line 862 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
						case 't':
#line 8590 "tracker-sparql-expression.c"
						{
							GString* _tmp32_;
#line 881 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
							_tmp32_ = sb;
#line 881 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
							g_string_append_c (_tmp32_, '\t');
#line 882 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
							break;
#line 8599 "tracker-sparql-expression.c"
						}
#line 862 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
						case 'u':
#line 8603 "tracker-sparql-expression.c"
						{
							const gchar* _tmp33_;
							gchar* ptr;
							gchar* _tmp34_;
							gchar _tmp35_;
							gint _tmp36_ = 0;
							gchar* _tmp37_;
							gchar _tmp38_;
							gint _tmp39_ = 0;
							gchar* _tmp40_;
							gchar _tmp41_;
							gint _tmp42_ = 0;
							gchar* _tmp43_;
							gchar _tmp44_;
							gint _tmp45_ = 0;
							gunichar c;
							GString* _tmp46_;
							gunichar _tmp47_;
							const gchar* _tmp48_;
#line 884 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
							_tmp33_ = p;
#line 884 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
							ptr = ((gchar*) _tmp33_) + 1;
#line 885 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
							_tmp34_ = ptr;
#line 885 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
							_tmp35_ = _tmp34_[0];
#line 885 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
							_tmp36_ = g_ascii_xdigit_value (_tmp35_);
#line 885 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
							_tmp37_ = ptr;
#line 885 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
							_tmp38_ = _tmp37_[1];
#line 885 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
							_tmp39_ = g_ascii_xdigit_value (_tmp38_);
#line 885 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
							_tmp40_ = ptr;
#line 885 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
							_tmp41_ = _tmp40_[2];
#line 885 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
							_tmp42_ = g_ascii_xdigit_value (_tmp41_);
#line 885 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
							_tmp43_ = ptr;
#line 885 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
							_tmp44_ = _tmp43_[3];
#line 885 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
							_tmp45_ = g_ascii_xdigit_value (_tmp44_);
#line 885 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
							c = (((((((gunichar) _tmp36_) * 16) + _tmp39_) * 16) + _tmp42_) * 16) + _tmp45_;
#line 886 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
							_tmp46_ = sb;
#line 886 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
							_tmp47_ = c;
#line 886 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
							g_string_append_unichar (_tmp46_, _tmp47_);
#line 887 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
							_tmp48_ = p;
#line 887 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
							p = _tmp48_ + 4;
#line 888 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
							break;
#line 8665 "tracker-sparql-expression.c"
						}
						default:
#line 862 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
						break;
#line 8670 "tracker-sparql-expression.c"
					}
#line 890 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					_tmp49_ = p;
#line 890 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					p = _tmp49_ + 1;
#line 8676 "tracker-sparql-expression.c"
				}
			}
#line 894 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp50_ = tracker_sparql_expression_accept (self, TRACKER_SPARQL_TOKEN_TYPE_DOUBLE_CIRCUMFLEX, &_inner_error_);
#line 894 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp51_ = _tmp50_;
#line 894 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			if (_inner_error_ != NULL) {
#line 894 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 894 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_propagate_error (error, _inner_error_);
#line 894 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					_g_free0 (s);
#line 894 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					_g_string_free0 (sb);
#line 894 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					return NULL;
#line 8695 "tracker-sparql-expression.c"
				} else {
#line 894 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					_g_free0 (s);
#line 894 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					_g_string_free0 (sb);
#line 894 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 894 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_clear_error (&_inner_error_);
#line 894 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					return NULL;
#line 8707 "tracker-sparql-expression.c"
				}
			}
#line 894 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			if (_tmp51_) {
#line 8712 "tracker-sparql-expression.c"
				TrackerPropertyType _tmp52_ = 0;
				TrackerPropertyType _tmp53_;
#line 896 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				_tmp52_ = tracker_sparql_expression_parse_type_uri (self, &_inner_error_);
#line 896 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				_tmp53_ = _tmp52_;
#line 896 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				if (_inner_error_ != NULL) {
#line 896 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 896 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
						g_propagate_error (error, _inner_error_);
#line 896 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
						_g_free0 (s);
#line 896 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
						_g_string_free0 (sb);
#line 896 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
						return NULL;
#line 8731 "tracker-sparql-expression.c"
					} else {
#line 896 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
						_g_free0 (s);
#line 896 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
						_g_string_free0 (sb);
#line 896 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 896 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
						g_clear_error (&_inner_error_);
#line 896 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
						return NULL;
#line 8743 "tracker-sparql-expression.c"
					}
				}
#line 896 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				_vala_type = _tmp53_;
#line 8748 "tracker-sparql-expression.c"
			}
#line 899 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp54_ = sb;
#line 899 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp55_ = _tmp54_->str;
#line 899 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp56_ = g_strdup (_tmp55_);
#line 899 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			result = _tmp56_;
#line 899 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_g_free0 (s);
#line 899 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_g_string_free0 (sb);
#line 899 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			if (type) {
#line 899 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				*type = _vala_type;
#line 8766 "tracker-sparql-expression.c"
			}
#line 899 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			return result;
#line 8770 "tracker-sparql-expression.c"
		}
#line 846 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		case TRACKER_SPARQL_TOKEN_TYPE_STRING_LITERAL_LONG1:
#line 846 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		case TRACKER_SPARQL_TOKEN_TYPE_STRING_LITERAL_LONG2:
#line 8776 "tracker-sparql-expression.c"
		{
			gchar* _tmp57_ = NULL;
			gchar* _result_;
			gboolean _tmp58_ = FALSE;
			gboolean _tmp59_;
#line 902 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp57_ = tracker_sparql_expression_get_last_string (self, 3);
#line 902 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_result_ = _tmp57_;
#line 904 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp58_ = tracker_sparql_expression_accept (self, TRACKER_SPARQL_TOKEN_TYPE_DOUBLE_CIRCUMFLEX, &_inner_error_);
#line 904 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp59_ = _tmp58_;
#line 904 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			if (_inner_error_ != NULL) {
#line 904 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 904 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_propagate_error (error, _inner_error_);
#line 904 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					_g_free0 (_result_);
#line 904 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					return NULL;
#line 8800 "tracker-sparql-expression.c"
				} else {
#line 904 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					_g_free0 (_result_);
#line 904 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 904 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_clear_error (&_inner_error_);
#line 904 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					return NULL;
#line 8810 "tracker-sparql-expression.c"
				}
			}
#line 904 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			if (_tmp59_) {
#line 8815 "tracker-sparql-expression.c"
				TrackerPropertyType _tmp60_ = 0;
				TrackerPropertyType _tmp61_;
#line 906 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				_tmp60_ = tracker_sparql_expression_parse_type_uri (self, &_inner_error_);
#line 906 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				_tmp61_ = _tmp60_;
#line 906 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				if (_inner_error_ != NULL) {
#line 906 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 906 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
						g_propagate_error (error, _inner_error_);
#line 906 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
						_g_free0 (_result_);
#line 906 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
						return NULL;
#line 8832 "tracker-sparql-expression.c"
					} else {
#line 906 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
						_g_free0 (_result_);
#line 906 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 906 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
						g_clear_error (&_inner_error_);
#line 906 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
						return NULL;
#line 8842 "tracker-sparql-expression.c"
					}
				}
#line 906 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				_vala_type = _tmp61_;
#line 8847 "tracker-sparql-expression.c"
			}
#line 909 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			result = _result_;
#line 909 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			if (type) {
#line 909 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				*type = _vala_type;
#line 8855 "tracker-sparql-expression.c"
			}
#line 909 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			return result;
#line 8859 "tracker-sparql-expression.c"
		}
		default:
		{
			GError* _tmp62_ = NULL;
#line 911 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp62_ = tracker_sparql_expression_get_error (self, "expected string literal");
#line 911 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_inner_error_ = _tmp62_;
#line 911 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 911 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				g_propagate_error (error, _inner_error_);
#line 911 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				return NULL;
#line 8874 "tracker-sparql-expression.c"
			} else {
#line 911 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 911 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				g_clear_error (&_inner_error_);
#line 911 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				return NULL;
#line 8882 "tracker-sparql-expression.c"
			}
		}
	}
#line 842 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	if (type) {
#line 842 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		*type = _vala_type;
#line 8890 "tracker-sparql-expression.c"
	}
}


static TrackerPropertyType tracker_sparql_expression_translate_uri_expression (TrackerSparqlExpression* self, GString* sql, const gchar* uri, GError** error) {
	TrackerPropertyType result = 0;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_;
	GError * _inner_error_ = NULL;
#line 915 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	g_return_val_if_fail (self != NULL, 0);
#line 915 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	g_return_val_if_fail (sql != NULL, 0);
#line 915 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	g_return_val_if_fail (uri != NULL, 0);
#line 916 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	_tmp0_ = tracker_sparql_expression_accept (self, TRACKER_SPARQL_TOKEN_TYPE_OPEN_PARENS, &_inner_error_);
#line 916 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	_tmp1_ = _tmp0_;
#line 916 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	if (_inner_error_ != NULL) {
#line 916 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 916 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			g_propagate_error (error, _inner_error_);
#line 916 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			return 0;
#line 8918 "tracker-sparql-expression.c"
		} else {
#line 916 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 916 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			g_clear_error (&_inner_error_);
#line 916 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			return 0;
#line 8926 "tracker-sparql-expression.c"
		}
	}
#line 916 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	if (_tmp1_) {
#line 8931 "tracker-sparql-expression.c"
		GString* _tmp2_;
		const gchar* _tmp3_;
		TrackerPropertyType _tmp4_ = 0;
		TrackerPropertyType _result_;
#line 918 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		_tmp2_ = sql;
#line 918 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		_tmp3_ = uri;
#line 918 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		_tmp4_ = tracker_sparql_expression_translate_function (self, _tmp2_, _tmp3_, &_inner_error_);
#line 918 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		_result_ = _tmp4_;
#line 918 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		if (_inner_error_ != NULL) {
#line 918 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 918 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				g_propagate_error (error, _inner_error_);
#line 918 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				return 0;
#line 8952 "tracker-sparql-expression.c"
			} else {
#line 918 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 918 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				g_clear_error (&_inner_error_);
#line 918 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				return 0;
#line 8960 "tracker-sparql-expression.c"
			}
		}
#line 919 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		tracker_sparql_expression_expect (self, TRACKER_SPARQL_TOKEN_TYPE_CLOSE_PARENS, &_inner_error_);
#line 919 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		if (_inner_error_ != NULL) {
#line 919 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 919 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				g_propagate_error (error, _inner_error_);
#line 919 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				return 0;
#line 8973 "tracker-sparql-expression.c"
			} else {
#line 919 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 919 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				g_clear_error (&_inner_error_);
#line 919 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				return 0;
#line 8981 "tracker-sparql-expression.c"
			}
		}
#line 920 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		result = _result_;
#line 920 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		return result;
#line 8988 "tracker-sparql-expression.c"
	} else {
		GString* _tmp5_;
		TrackerSparqlLiteralBinding* _tmp6_;
		TrackerSparqlLiteralBinding* binding;
		TrackerSparqlLiteralBinding* _tmp7_;
		const gchar* _tmp8_;
		gchar* _tmp9_;
		TrackerSparqlQuery* _tmp10_;
		TrackerSparqlLiteralBinding* _tmp11_;
		TrackerSparqlLiteralBinding* _tmp12_;
#line 923 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		_tmp5_ = sql;
#line 923 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		g_string_append (_tmp5_, "COALESCE((SELECT ID FROM Resource WHERE Uri = ?), 0)");
#line 924 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		_tmp6_ = tracker_sparql_literal_binding_new ();
#line 924 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		binding = _tmp6_;
#line 925 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		_tmp7_ = binding;
#line 925 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		_tmp8_ = uri;
#line 925 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		_tmp9_ = g_strdup (_tmp8_);
#line 925 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		_g_free0 (_tmp7_->literal);
#line 925 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		_tmp7_->literal = _tmp9_;
#line 926 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		_tmp10_ = self->priv->query;
#line 926 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		_tmp11_ = binding;
#line 926 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		_tmp12_ = _g_object_ref0 (_tmp11_);
#line 926 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		_tmp10_->bindings = g_list_append (_tmp10_->bindings, _tmp12_);
#line 927 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		result = TRACKER_PROPERTY_TYPE_RESOURCE;
#line 927 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		_g_object_unref0 (binding);
#line 927 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		return result;
#line 9031 "tracker-sparql-expression.c"
	}
}


static TrackerPropertyType tracker_sparql_expression_translate_primary_expression (TrackerSparqlExpression* self, GString* sql, GError** error) {
	TrackerPropertyType result = 0;
	TrackerPropertyType type = 0;
	TrackerSparqlTokenType _tmp0_ = 0;
	GError * _inner_error_ = NULL;
#line 931 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	g_return_val_if_fail (self != NULL, 0);
#line 931 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	g_return_val_if_fail (sql != NULL, 0);
#line 934 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	_tmp0_ = tracker_sparql_expression_current (self);
#line 934 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	switch (_tmp0_) {
#line 934 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		case TRACKER_SPARQL_TOKEN_TYPE_OPEN_PARENS:
#line 9051 "tracker-sparql-expression.c"
		{
			GString* _tmp1_;
			TrackerPropertyType _tmp2_ = 0;
			TrackerPropertyType _tmp3_;
#line 936 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp1_ = sql;
#line 936 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp2_ = tracker_sparql_expression_translate_bracketted_expression (self, _tmp1_, &_inner_error_);
#line 936 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp3_ = _tmp2_;
#line 936 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			if (_inner_error_ != NULL) {
#line 936 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 936 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_propagate_error (error, _inner_error_);
#line 936 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					return 0;
#line 9070 "tracker-sparql-expression.c"
				} else {
#line 936 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 936 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_clear_error (&_inner_error_);
#line 936 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					return 0;
#line 9078 "tracker-sparql-expression.c"
				}
			}
#line 936 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			result = _tmp3_;
#line 936 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			return result;
#line 9085 "tracker-sparql-expression.c"
		}
#line 934 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		case TRACKER_SPARQL_TOKEN_TYPE_IRI_REF:
#line 9089 "tracker-sparql-expression.c"
		{
			GString* _tmp4_;
			gchar* _tmp5_ = NULL;
			gchar* _tmp6_;
			TrackerPropertyType _tmp7_ = 0;
			TrackerPropertyType _tmp8_;
			TrackerPropertyType _tmp9_;
#line 938 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			tracker_sparql_expression_next (self, &_inner_error_);
#line 938 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			if (_inner_error_ != NULL) {
#line 938 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 938 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_propagate_error (error, _inner_error_);
#line 938 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					return 0;
#line 9107 "tracker-sparql-expression.c"
				} else {
#line 938 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 938 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_clear_error (&_inner_error_);
#line 938 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					return 0;
#line 9115 "tracker-sparql-expression.c"
				}
			}
#line 939 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp4_ = sql;
#line 939 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp5_ = tracker_sparql_expression_get_last_string (self, 1);
#line 939 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp6_ = _tmp5_;
#line 939 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp7_ = tracker_sparql_expression_translate_uri_expression (self, _tmp4_, _tmp6_, &_inner_error_);
#line 939 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp8_ = _tmp7_;
#line 939 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_g_free0 (_tmp6_);
#line 939 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp9_ = _tmp8_;
#line 939 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			if (_inner_error_ != NULL) {
#line 939 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 939 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_propagate_error (error, _inner_error_);
#line 939 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					return 0;
#line 9140 "tracker-sparql-expression.c"
				} else {
#line 939 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 939 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_clear_error (&_inner_error_);
#line 939 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					return 0;
#line 9148 "tracker-sparql-expression.c"
				}
			}
#line 939 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			result = _tmp9_;
#line 939 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			return result;
#line 9155 "tracker-sparql-expression.c"
		}
#line 934 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		case TRACKER_SPARQL_TOKEN_TYPE_DECIMAL:
#line 934 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		case TRACKER_SPARQL_TOKEN_TYPE_DOUBLE:
#line 9161 "tracker-sparql-expression.c"
		{
			TrackerSparqlQuery* _tmp10_;
			gboolean _tmp11_;
			gboolean _tmp12_;
#line 942 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			tracker_sparql_expression_next (self, &_inner_error_);
#line 942 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			if (_inner_error_ != NULL) {
#line 942 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 942 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_propagate_error (error, _inner_error_);
#line 942 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					return 0;
#line 9176 "tracker-sparql-expression.c"
				} else {
#line 942 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 942 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_clear_error (&_inner_error_);
#line 942 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					return 0;
#line 9184 "tracker-sparql-expression.c"
				}
			}
#line 944 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp10_ = self->priv->query;
#line 944 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp11_ = tracker_sparql_query_get_no_cache (_tmp10_);
#line 944 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp12_ = _tmp11_;
#line 944 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			if (_tmp12_) {
#line 9195 "tracker-sparql-expression.c"
				GString* _tmp13_;
				gchar* _tmp14_ = NULL;
				gchar* _tmp15_;
#line 945 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				_tmp13_ = sql;
#line 945 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				_tmp14_ = tracker_sparql_expression_get_last_string (self, 0);
#line 945 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				_tmp15_ = _tmp14_;
#line 945 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				g_string_append (_tmp13_, _tmp15_);
#line 945 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				_g_free0 (_tmp15_);
#line 9209 "tracker-sparql-expression.c"
			} else {
				GString* _tmp16_;
				TrackerSparqlLiteralBinding* _tmp17_;
				TrackerSparqlLiteralBinding* binding;
				TrackerSparqlLiteralBinding* _tmp18_;
				gchar* _tmp19_ = NULL;
				TrackerSparqlQuery* _tmp20_;
				TrackerSparqlLiteralBinding* _tmp21_;
				TrackerSparqlLiteralBinding* _tmp22_;
#line 947 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				_tmp16_ = sql;
#line 947 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				g_string_append (_tmp16_, "?");
#line 949 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				_tmp17_ = tracker_sparql_literal_binding_new ();
#line 949 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				binding = _tmp17_;
#line 950 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				_tmp18_ = binding;
#line 950 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				_tmp19_ = tracker_sparql_expression_get_last_string (self, 0);
#line 950 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				_g_free0 (_tmp18_->literal);
#line 950 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				_tmp18_->literal = _tmp19_;
#line 951 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				_tmp20_ = self->priv->query;
#line 951 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				_tmp21_ = binding;
#line 951 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				_tmp22_ = _g_object_ref0 (_tmp21_);
#line 951 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				_tmp20_->bindings = g_list_append (_tmp20_->bindings, _tmp22_);
#line 944 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				_g_object_unref0 (binding);
#line 9245 "tracker-sparql-expression.c"
			}
#line 954 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			result = TRACKER_PROPERTY_TYPE_DOUBLE;
#line 954 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			return result;
#line 9251 "tracker-sparql-expression.c"
		}
#line 934 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		case TRACKER_SPARQL_TOKEN_TYPE_TRUE:
#line 9255 "tracker-sparql-expression.c"
		{
			TrackerSparqlQuery* _tmp23_;
			gboolean _tmp24_;
			gboolean _tmp25_;
#line 956 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			tracker_sparql_expression_next (self, &_inner_error_);
#line 956 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			if (_inner_error_ != NULL) {
#line 956 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 956 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_propagate_error (error, _inner_error_);
#line 956 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					return 0;
#line 9270 "tracker-sparql-expression.c"
				} else {
#line 956 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 956 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_clear_error (&_inner_error_);
#line 956 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					return 0;
#line 9278 "tracker-sparql-expression.c"
				}
			}
#line 958 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp23_ = self->priv->query;
#line 958 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp24_ = tracker_sparql_query_get_no_cache (_tmp23_);
#line 958 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp25_ = _tmp24_;
#line 958 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			if (_tmp25_) {
#line 9289 "tracker-sparql-expression.c"
				GString* _tmp26_;
#line 959 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				_tmp26_ = sql;
#line 959 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				g_string_append (_tmp26_, "1");
#line 9295 "tracker-sparql-expression.c"
			} else {
				GString* _tmp27_;
				TrackerSparqlLiteralBinding* _tmp28_;
				TrackerSparqlLiteralBinding* binding;
				TrackerSparqlLiteralBinding* _tmp29_;
				gchar* _tmp30_;
				TrackerSparqlLiteralBinding* _tmp31_;
				TrackerSparqlQuery* _tmp32_;
				TrackerSparqlLiteralBinding* _tmp33_;
				TrackerSparqlLiteralBinding* _tmp34_;
#line 961 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				_tmp27_ = sql;
#line 961 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				g_string_append (_tmp27_, "?");
#line 963 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				_tmp28_ = tracker_sparql_literal_binding_new ();
#line 963 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				binding = _tmp28_;
#line 964 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				_tmp29_ = binding;
#line 964 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				_tmp30_ = g_strdup ("1");
#line 964 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				_g_free0 (_tmp29_->literal);
#line 964 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				_tmp29_->literal = _tmp30_;
#line 965 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				_tmp31_ = binding;
#line 965 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				((TrackerSparqlDataBinding*) _tmp31_)->data_type = TRACKER_PROPERTY_TYPE_INTEGER;
#line 966 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				_tmp32_ = self->priv->query;
#line 966 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				_tmp33_ = binding;
#line 966 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				_tmp34_ = _g_object_ref0 (_tmp33_);
#line 966 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				_tmp32_->bindings = g_list_append (_tmp32_->bindings, _tmp34_);
#line 958 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				_g_object_unref0 (binding);
#line 9336 "tracker-sparql-expression.c"
			}
#line 969 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			result = TRACKER_PROPERTY_TYPE_BOOLEAN;
#line 969 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			return result;
#line 9342 "tracker-sparql-expression.c"
		}
#line 934 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		case TRACKER_SPARQL_TOKEN_TYPE_FALSE:
#line 9346 "tracker-sparql-expression.c"
		{
			TrackerSparqlQuery* _tmp35_;
			gboolean _tmp36_;
			gboolean _tmp37_;
#line 971 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			tracker_sparql_expression_next (self, &_inner_error_);
#line 971 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			if (_inner_error_ != NULL) {
#line 971 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 971 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_propagate_error (error, _inner_error_);
#line 971 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					return 0;
#line 9361 "tracker-sparql-expression.c"
				} else {
#line 971 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 971 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_clear_error (&_inner_error_);
#line 971 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					return 0;
#line 9369 "tracker-sparql-expression.c"
				}
			}
#line 973 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp35_ = self->priv->query;
#line 973 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp36_ = tracker_sparql_query_get_no_cache (_tmp35_);
#line 973 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp37_ = _tmp36_;
#line 973 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			if (_tmp37_) {
#line 9380 "tracker-sparql-expression.c"
				GString* _tmp38_;
#line 974 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				_tmp38_ = sql;
#line 974 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				g_string_append (_tmp38_, "0");
#line 9386 "tracker-sparql-expression.c"
			} else {
				GString* _tmp39_;
				TrackerSparqlLiteralBinding* _tmp40_;
				TrackerSparqlLiteralBinding* binding;
				TrackerSparqlLiteralBinding* _tmp41_;
				gchar* _tmp42_;
				TrackerSparqlLiteralBinding* _tmp43_;
				TrackerSparqlQuery* _tmp44_;
				TrackerSparqlLiteralBinding* _tmp45_;
				TrackerSparqlLiteralBinding* _tmp46_;
#line 976 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				_tmp39_ = sql;
#line 976 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				g_string_append (_tmp39_, "?");
#line 978 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				_tmp40_ = tracker_sparql_literal_binding_new ();
#line 978 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				binding = _tmp40_;
#line 979 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				_tmp41_ = binding;
#line 979 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				_tmp42_ = g_strdup ("0");
#line 979 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				_g_free0 (_tmp41_->literal);
#line 979 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				_tmp41_->literal = _tmp42_;
#line 980 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				_tmp43_ = binding;
#line 980 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				((TrackerSparqlDataBinding*) _tmp43_)->data_type = TRACKER_PROPERTY_TYPE_INTEGER;
#line 981 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				_tmp44_ = self->priv->query;
#line 981 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				_tmp45_ = binding;
#line 981 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				_tmp46_ = _g_object_ref0 (_tmp45_);
#line 981 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				_tmp44_->bindings = g_list_append (_tmp44_->bindings, _tmp46_);
#line 973 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				_g_object_unref0 (binding);
#line 9427 "tracker-sparql-expression.c"
			}
#line 984 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			result = TRACKER_PROPERTY_TYPE_BOOLEAN;
#line 984 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			return result;
#line 9433 "tracker-sparql-expression.c"
		}
#line 934 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		case TRACKER_SPARQL_TOKEN_TYPE_STRING_LITERAL1:
#line 934 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		case TRACKER_SPARQL_TOKEN_TYPE_STRING_LITERAL2:
#line 934 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		case TRACKER_SPARQL_TOKEN_TYPE_STRING_LITERAL_LONG1:
#line 934 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		case TRACKER_SPARQL_TOKEN_TYPE_STRING_LITERAL_LONG2:
#line 9443 "tracker-sparql-expression.c"
		{
			TrackerPropertyType _tmp47_ = 0;
			gchar* _tmp48_ = NULL;
			gchar* literal;
			TrackerPropertyType _tmp49_;
#line 989 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp48_ = tracker_sparql_expression_parse_string_literal (self, &_tmp47_, &_inner_error_);
#line 989 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			type = _tmp47_;
#line 989 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			literal = _tmp48_;
#line 989 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			if (_inner_error_ != NULL) {
#line 989 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 989 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_propagate_error (error, _inner_error_);
#line 989 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					return 0;
#line 9463 "tracker-sparql-expression.c"
				} else {
#line 989 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 989 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_clear_error (&_inner_error_);
#line 989 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					return 0;
#line 9471 "tracker-sparql-expression.c"
				}
			}
#line 991 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp49_ = type;
#line 991 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			switch (_tmp49_) {
#line 991 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				case TRACKER_PROPERTY_TYPE_INTEGER:
#line 991 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				case TRACKER_PROPERTY_TYPE_BOOLEAN:
#line 991 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				case TRACKER_PROPERTY_TYPE_DOUBLE:
#line 991 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				case TRACKER_PROPERTY_TYPE_DATE:
#line 991 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				case TRACKER_PROPERTY_TYPE_DATETIME:
#line 9488 "tracker-sparql-expression.c"
				{
					TrackerSparqlQuery* _tmp50_;
					gboolean _tmp51_;
					gboolean _tmp52_;
#line 997 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					_tmp50_ = self->priv->query;
#line 997 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					_tmp51_ = tracker_sparql_query_get_no_cache (_tmp50_);
#line 997 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					_tmp52_ = _tmp51_;
#line 997 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					if (_tmp52_) {
#line 9501 "tracker-sparql-expression.c"
						GString* _tmp53_;
						const gchar* _tmp54_;
						gchar* _tmp55_ = NULL;
						gchar* _tmp56_;
#line 998 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
						_tmp53_ = sql;
#line 998 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
						_tmp54_ = literal;
#line 998 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
						_tmp55_ = tracker_sparql_expression_escape_sql_string_literal (self, _tmp54_);
#line 998 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
						_tmp56_ = _tmp55_;
#line 998 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
						g_string_append (_tmp53_, _tmp56_);
#line 998 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
						_g_free0 (_tmp56_);
#line 9518 "tracker-sparql-expression.c"
					} else {
						TrackerSparqlLiteralBinding* _tmp57_;
						TrackerSparqlLiteralBinding* binding;
						TrackerSparqlLiteralBinding* _tmp58_;
						const gchar* _tmp59_;
						gchar* _tmp60_;
						TrackerSparqlLiteralBinding* _tmp61_;
						TrackerPropertyType _tmp62_;
						TrackerSparqlQuery* _tmp63_;
						TrackerSparqlLiteralBinding* _tmp64_;
						TrackerSparqlLiteralBinding* _tmp65_;
						GString* _tmp66_;
#line 1000 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
						_tmp57_ = tracker_sparql_literal_binding_new ();
#line 1000 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
						binding = _tmp57_;
#line 1001 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
						_tmp58_ = binding;
#line 1001 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
						_tmp59_ = literal;
#line 1001 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
						_tmp60_ = g_strdup (_tmp59_);
#line 1001 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
						_g_free0 (_tmp58_->literal);
#line 1001 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
						_tmp58_->literal = _tmp60_;
#line 1002 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
						_tmp61_ = binding;
#line 1002 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
						_tmp62_ = type;
#line 1002 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
						((TrackerSparqlDataBinding*) _tmp61_)->data_type = _tmp62_;
#line 1003 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
						_tmp63_ = self->priv->query;
#line 1003 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
						_tmp64_ = binding;
#line 1003 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
						_tmp65_ = _g_object_ref0 (_tmp64_);
#line 1003 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
						_tmp63_->bindings = g_list_append (_tmp63_->bindings, _tmp65_);
#line 1004 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
						_tmp66_ = sql;
#line 1004 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
						g_string_append (_tmp66_, "?");
#line 997 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
						_g_object_unref0 (binding);
#line 9565 "tracker-sparql-expression.c"
					}
#line 1006 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					result = type;
#line 1006 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					_g_free0 (literal);
#line 1006 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					return result;
#line 9573 "tracker-sparql-expression.c"
				}
				default:
				{
					TrackerSparqlQuery* _tmp67_;
					gboolean _tmp68_;
					gboolean _tmp69_;
					GString* _tmp82_;
#line 1008 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					_tmp67_ = self->priv->query;
#line 1008 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					_tmp68_ = tracker_sparql_query_get_no_cache (_tmp67_);
#line 1008 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					_tmp69_ = _tmp68_;
#line 1008 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					if (_tmp69_) {
#line 9589 "tracker-sparql-expression.c"
						GString* _tmp70_;
						const gchar* _tmp71_;
						gchar* _tmp72_ = NULL;
						gchar* _tmp73_;
#line 1009 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
						_tmp70_ = sql;
#line 1009 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
						_tmp71_ = literal;
#line 1009 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
						_tmp72_ = tracker_sparql_expression_escape_sql_string_literal (self, _tmp71_);
#line 1009 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
						_tmp73_ = _tmp72_;
#line 1009 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
						g_string_append (_tmp70_, _tmp73_);
#line 1009 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
						_g_free0 (_tmp73_);
#line 9606 "tracker-sparql-expression.c"
					} else {
						TrackerSparqlLiteralBinding* _tmp74_;
						TrackerSparqlLiteralBinding* binding;
						TrackerSparqlLiteralBinding* _tmp75_;
						const gchar* _tmp76_;
						gchar* _tmp77_;
						TrackerSparqlQuery* _tmp78_;
						TrackerSparqlLiteralBinding* _tmp79_;
						TrackerSparqlLiteralBinding* _tmp80_;
						GString* _tmp81_;
#line 1011 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
						_tmp74_ = tracker_sparql_literal_binding_new ();
#line 1011 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
						binding = _tmp74_;
#line 1012 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
						_tmp75_ = binding;
#line 1012 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
						_tmp76_ = literal;
#line 1012 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
						_tmp77_ = g_strdup (_tmp76_);
#line 1012 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
						_g_free0 (_tmp75_->literal);
#line 1012 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
						_tmp75_->literal = _tmp77_;
#line 1013 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
						_tmp78_ = self->priv->query;
#line 1013 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
						_tmp79_ = binding;
#line 1013 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
						_tmp80_ = _g_object_ref0 (_tmp79_);
#line 1013 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
						_tmp78_->bindings = g_list_append (_tmp78_->bindings, _tmp80_);
#line 1014 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
						_tmp81_ = sql;
#line 1014 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
						g_string_append (_tmp81_, "?");
#line 1008 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
						_g_object_unref0 (binding);
#line 9645 "tracker-sparql-expression.c"
					}
#line 1016 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					_tmp82_ = sql;
#line 1016 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					tracker_sparql_expression_append_collate (self, _tmp82_);
#line 1017 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					result = TRACKER_PROPERTY_TYPE_STRING;
#line 1017 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					_g_free0 (literal);
#line 1017 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					return result;
#line 9657 "tracker-sparql-expression.c"
				}
			}
#line 934 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_g_free0 (literal);
#line 9662 "tracker-sparql-expression.c"
		}
#line 934 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		case TRACKER_SPARQL_TOKEN_TYPE_INTEGER:
#line 9666 "tracker-sparql-expression.c"
		{
			TrackerSparqlQuery* _tmp83_;
			gboolean _tmp84_;
			gboolean _tmp85_;
#line 1020 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			tracker_sparql_expression_next (self, &_inner_error_);
#line 1020 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			if (_inner_error_ != NULL) {
#line 1020 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 1020 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_propagate_error (error, _inner_error_);
#line 1020 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					return 0;
#line 9681 "tracker-sparql-expression.c"
				} else {
#line 1020 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1020 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_clear_error (&_inner_error_);
#line 1020 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					return 0;
#line 9689 "tracker-sparql-expression.c"
				}
			}
#line 1022 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp83_ = self->priv->query;
#line 1022 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp84_ = tracker_sparql_query_get_no_cache (_tmp83_);
#line 1022 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp85_ = _tmp84_;
#line 1022 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			if (_tmp85_) {
#line 9700 "tracker-sparql-expression.c"
				GString* _tmp86_;
				gchar* _tmp87_ = NULL;
				gchar* _tmp88_;
#line 1023 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				_tmp86_ = sql;
#line 1023 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				_tmp87_ = tracker_sparql_expression_get_last_string (self, 0);
#line 1023 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				_tmp88_ = _tmp87_;
#line 1023 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				g_string_append (_tmp86_, _tmp88_);
#line 1023 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				_g_free0 (_tmp88_);
#line 9714 "tracker-sparql-expression.c"
			} else {
				GString* _tmp89_;
				TrackerSparqlLiteralBinding* _tmp90_;
				TrackerSparqlLiteralBinding* binding;
				TrackerSparqlLiteralBinding* _tmp91_;
				gchar* _tmp92_ = NULL;
				TrackerSparqlLiteralBinding* _tmp93_;
				TrackerSparqlQuery* _tmp94_;
				TrackerSparqlLiteralBinding* _tmp95_;
				TrackerSparqlLiteralBinding* _tmp96_;
#line 1025 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				_tmp89_ = sql;
#line 1025 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				g_string_append (_tmp89_, "?");
#line 1027 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				_tmp90_ = tracker_sparql_literal_binding_new ();
#line 1027 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				binding = _tmp90_;
#line 1028 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				_tmp91_ = binding;
#line 1028 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				_tmp92_ = tracker_sparql_expression_get_last_string (self, 0);
#line 1028 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				_g_free0 (_tmp91_->literal);
#line 1028 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				_tmp91_->literal = _tmp92_;
#line 1029 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				_tmp93_ = binding;
#line 1029 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				((TrackerSparqlDataBinding*) _tmp93_)->data_type = TRACKER_PROPERTY_TYPE_INTEGER;
#line 1030 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				_tmp94_ = self->priv->query;
#line 1030 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				_tmp95_ = binding;
#line 1030 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				_tmp96_ = _g_object_ref0 (_tmp95_);
#line 1030 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				_tmp94_->bindings = g_list_append (_tmp94_->bindings, _tmp96_);
#line 1022 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				_g_object_unref0 (binding);
#line 9755 "tracker-sparql-expression.c"
			}
#line 1033 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			result = TRACKER_PROPERTY_TYPE_INTEGER;
#line 1033 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			return result;
#line 9761 "tracker-sparql-expression.c"
		}
#line 934 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		case TRACKER_SPARQL_TOKEN_TYPE_VAR:
#line 9765 "tracker-sparql-expression.c"
		{
			gchar* _tmp97_ = NULL;
			gchar* _tmp98_;
			gchar* _tmp99_ = NULL;
			gchar* _tmp100_;
			gchar* variable_name;
			TrackerSparqlContext* _tmp101_;
			TrackerSparqlContext* _tmp102_;
			const gchar* _tmp103_;
			TrackerSparqlVariable* _tmp104_ = NULL;
			TrackerSparqlVariable* _tmp105_;
			TrackerSparqlVariable* variable;
			GString* _tmp106_;
			TrackerSparqlVariable* _tmp107_;
			const gchar* _tmp108_;
			const gchar* _tmp109_;
			TrackerSparqlVariable* _tmp110_;
			TrackerSparqlVariableBinding* _tmp111_;
#line 1035 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			tracker_sparql_expression_next (self, &_inner_error_);
#line 1035 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			if (_inner_error_ != NULL) {
#line 1035 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 1035 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_propagate_error (error, _inner_error_);
#line 1035 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					return 0;
#line 9794 "tracker-sparql-expression.c"
				} else {
#line 1035 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1035 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_clear_error (&_inner_error_);
#line 1035 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					return 0;
#line 9802 "tracker-sparql-expression.c"
				}
			}
#line 1036 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp97_ = tracker_sparql_expression_get_last_string (self, 0);
#line 1036 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp98_ = _tmp97_;
#line 1036 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp99_ = string_substring (_tmp98_, (glong) 1, (glong) (-1));
#line 1036 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp100_ = _tmp99_;
#line 1036 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_g_free0 (_tmp98_);
#line 1036 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			variable_name = _tmp100_;
#line 1037 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp101_ = tracker_sparql_expression_get_context (self);
#line 1037 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp102_ = _tmp101_;
#line 1037 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp103_ = variable_name;
#line 1037 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp104_ = tracker_sparql_context_get_variable (_tmp102_, _tmp103_);
#line 1037 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp105_ = _g_object_ref0 (_tmp104_);
#line 1037 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			variable = _tmp105_;
#line 1038 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp106_ = sql;
#line 1038 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp107_ = variable;
#line 1038 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp108_ = tracker_sparql_variable_get_sql_expression (_tmp107_);
#line 1038 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp109_ = _tmp108_;
#line 1038 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			g_string_append (_tmp106_, _tmp109_);
#line 1040 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp110_ = variable;
#line 1040 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp111_ = _tmp110_->binding;
#line 1040 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			if (_tmp111_ == NULL) {
#line 1041 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				result = TRACKER_PROPERTY_TYPE_UNKNOWN;
#line 1041 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				_g_object_unref0 (variable);
#line 1041 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				_g_free0 (variable_name);
#line 1041 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				return result;
#line 9853 "tracker-sparql-expression.c"
			} else {
				TrackerSparqlVariable* _tmp112_;
				TrackerSparqlVariableBinding* _tmp113_;
				TrackerPropertyType _tmp114_;
				TrackerSparqlVariable* _tmp116_;
				TrackerSparqlVariableBinding* _tmp117_;
				TrackerPropertyType _tmp118_;
#line 1043 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				_tmp112_ = variable;
#line 1043 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				_tmp113_ = _tmp112_->binding;
#line 1043 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				_tmp114_ = ((TrackerSparqlDataBinding*) _tmp113_)->data_type;
#line 1043 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				if (_tmp114_ == TRACKER_PROPERTY_TYPE_STRING) {
#line 9869 "tracker-sparql-expression.c"
					GString* _tmp115_;
#line 1044 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					_tmp115_ = sql;
#line 1044 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					tracker_sparql_expression_append_collate (self, _tmp115_);
#line 9875 "tracker-sparql-expression.c"
				}
#line 1046 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				_tmp116_ = variable;
#line 1046 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				_tmp117_ = _tmp116_->binding;
#line 1046 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				_tmp118_ = ((TrackerSparqlDataBinding*) _tmp117_)->data_type;
#line 1046 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				result = _tmp118_;
#line 1046 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				_g_object_unref0 (variable);
#line 1046 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				_g_free0 (variable_name);
#line 1046 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				return result;
#line 9891 "tracker-sparql-expression.c"
			}
#line 934 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_g_object_unref0 (variable);
#line 934 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_g_free0 (variable_name);
#line 9897 "tracker-sparql-expression.c"
		}
#line 934 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		case TRACKER_SPARQL_TOKEN_TYPE_STR:
#line 9901 "tracker-sparql-expression.c"
		{
			GString* _tmp119_;
#line 1049 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp119_ = sql;
#line 1049 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			tracker_sparql_expression_translate_str (self, _tmp119_, &_inner_error_);
#line 1049 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			if (_inner_error_ != NULL) {
#line 1049 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 1049 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_propagate_error (error, _inner_error_);
#line 1049 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					return 0;
#line 9916 "tracker-sparql-expression.c"
				} else {
#line 1049 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1049 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_clear_error (&_inner_error_);
#line 1049 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					return 0;
#line 9924 "tracker-sparql-expression.c"
				}
			}
#line 1050 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			result = TRACKER_PROPERTY_TYPE_STRING;
#line 1050 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			return result;
#line 9931 "tracker-sparql-expression.c"
		}
#line 934 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		case TRACKER_SPARQL_TOKEN_TYPE_LANG:
#line 9935 "tracker-sparql-expression.c"
		{
			GString* _tmp120_;
#line 1052 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			tracker_sparql_expression_next (self, &_inner_error_);
#line 1052 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			if (_inner_error_ != NULL) {
#line 1052 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 1052 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_propagate_error (error, _inner_error_);
#line 1052 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					return 0;
#line 9948 "tracker-sparql-expression.c"
				} else {
#line 1052 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1052 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_clear_error (&_inner_error_);
#line 1052 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					return 0;
#line 9956 "tracker-sparql-expression.c"
				}
			}
#line 1053 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp120_ = sql;
#line 1053 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			g_string_append (_tmp120_, "''");
#line 1054 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			result = TRACKER_PROPERTY_TYPE_STRING;
#line 1054 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			return result;
#line 9967 "tracker-sparql-expression.c"
		}
#line 934 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		case TRACKER_SPARQL_TOKEN_TYPE_LANGMATCHES:
#line 9971 "tracker-sparql-expression.c"
		{
			GString* _tmp121_;
#line 1056 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			tracker_sparql_expression_next (self, &_inner_error_);
#line 1056 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			if (_inner_error_ != NULL) {
#line 1056 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 1056 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_propagate_error (error, _inner_error_);
#line 1056 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					return 0;
#line 9984 "tracker-sparql-expression.c"
				} else {
#line 1056 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1056 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_clear_error (&_inner_error_);
#line 1056 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					return 0;
#line 9992 "tracker-sparql-expression.c"
				}
			}
#line 1057 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp121_ = sql;
#line 1057 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			g_string_append (_tmp121_, "0");
#line 1058 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			result = TRACKER_PROPERTY_TYPE_BOOLEAN;
#line 1058 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			return result;
#line 10003 "tracker-sparql-expression.c"
		}
#line 934 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		case TRACKER_SPARQL_TOKEN_TYPE_DATATYPE:
#line 10007 "tracker-sparql-expression.c"
		{
			GString* _tmp122_;
#line 1060 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp122_ = sql;
#line 1060 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			tracker_sparql_expression_translate_datatype (self, _tmp122_, &_inner_error_);
#line 1060 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			if (_inner_error_ != NULL) {
#line 1060 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 1060 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_propagate_error (error, _inner_error_);
#line 1060 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					return 0;
#line 10022 "tracker-sparql-expression.c"
				} else {
#line 1060 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1060 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_clear_error (&_inner_error_);
#line 1060 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					return 0;
#line 10030 "tracker-sparql-expression.c"
				}
			}
#line 1061 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			result = TRACKER_PROPERTY_TYPE_RESOURCE;
#line 1061 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			return result;
#line 10037 "tracker-sparql-expression.c"
		}
#line 934 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		case TRACKER_SPARQL_TOKEN_TYPE_BOUND:
#line 10041 "tracker-sparql-expression.c"
		{
			GString* _tmp123_;
#line 1063 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp123_ = sql;
#line 1063 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			tracker_sparql_expression_translate_bound_call (self, _tmp123_, &_inner_error_);
#line 1063 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			if (_inner_error_ != NULL) {
#line 1063 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 1063 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_propagate_error (error, _inner_error_);
#line 1063 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					return 0;
#line 10056 "tracker-sparql-expression.c"
				} else {
#line 1063 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1063 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_clear_error (&_inner_error_);
#line 1063 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					return 0;
#line 10064 "tracker-sparql-expression.c"
				}
			}
#line 1064 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			result = TRACKER_PROPERTY_TYPE_BOOLEAN;
#line 1064 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			return result;
#line 10071 "tracker-sparql-expression.c"
		}
#line 934 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		case TRACKER_SPARQL_TOKEN_TYPE_COALESCE:
#line 10075 "tracker-sparql-expression.c"
		{
			GString* _tmp124_;
			TrackerPropertyType _tmp125_ = 0;
			TrackerPropertyType _result_;
#line 1066 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			tracker_sparql_expression_next (self, &_inner_error_);
#line 1066 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			if (_inner_error_ != NULL) {
#line 1066 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 1066 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_propagate_error (error, _inner_error_);
#line 1066 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					return 0;
#line 10090 "tracker-sparql-expression.c"
				} else {
#line 1066 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1066 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_clear_error (&_inner_error_);
#line 1066 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					return 0;
#line 10098 "tracker-sparql-expression.c"
				}
			}
#line 1067 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			tracker_sparql_expression_expect (self, TRACKER_SPARQL_TOKEN_TYPE_OPEN_PARENS, &_inner_error_);
#line 1067 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			if (_inner_error_ != NULL) {
#line 1067 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 1067 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_propagate_error (error, _inner_error_);
#line 1067 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					return 0;
#line 10111 "tracker-sparql-expression.c"
				} else {
#line 1067 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1067 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_clear_error (&_inner_error_);
#line 1067 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					return 0;
#line 10119 "tracker-sparql-expression.c"
				}
			}
#line 1068 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp124_ = sql;
#line 1068 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp125_ = tracker_sparql_expression_translate_function (self, _tmp124_, TRACKER_SPARQL_EXPRESSION_TRACKER_NS "coalesce", &_inner_error_);
#line 1068 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_result_ = _tmp125_;
#line 1068 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			if (_inner_error_ != NULL) {
#line 1068 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 1068 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_propagate_error (error, _inner_error_);
#line 1068 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					return 0;
#line 10136 "tracker-sparql-expression.c"
				} else {
#line 1068 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1068 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_clear_error (&_inner_error_);
#line 1068 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					return 0;
#line 10144 "tracker-sparql-expression.c"
				}
			}
#line 1069 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			tracker_sparql_expression_expect (self, TRACKER_SPARQL_TOKEN_TYPE_CLOSE_PARENS, &_inner_error_);
#line 1069 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			if (_inner_error_ != NULL) {
#line 1069 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 1069 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_propagate_error (error, _inner_error_);
#line 1069 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					return 0;
#line 10157 "tracker-sparql-expression.c"
				} else {
#line 1069 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1069 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_clear_error (&_inner_error_);
#line 1069 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					return 0;
#line 10165 "tracker-sparql-expression.c"
				}
			}
#line 1070 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			result = _result_;
#line 1070 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			return result;
#line 10172 "tracker-sparql-expression.c"
		}
#line 934 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		case TRACKER_SPARQL_TOKEN_TYPE_IF:
#line 10176 "tracker-sparql-expression.c"
		{
			GString* _tmp126_;
			TrackerPropertyType _tmp127_ = 0;
			TrackerPropertyType _tmp128_;
#line 1072 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp126_ = sql;
#line 1072 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp127_ = tracker_sparql_expression_translate_if_call (self, _tmp126_, &_inner_error_);
#line 1072 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp128_ = _tmp127_;
#line 1072 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			if (_inner_error_ != NULL) {
#line 1072 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 1072 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_propagate_error (error, _inner_error_);
#line 1072 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					return 0;
#line 10195 "tracker-sparql-expression.c"
				} else {
#line 1072 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1072 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_clear_error (&_inner_error_);
#line 1072 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					return 0;
#line 10203 "tracker-sparql-expression.c"
				}
			}
#line 1072 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			result = _tmp128_;
#line 1072 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			return result;
#line 10210 "tracker-sparql-expression.c"
		}
#line 934 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		case TRACKER_SPARQL_TOKEN_TYPE_SAMETERM:
#line 10214 "tracker-sparql-expression.c"
		{
			GString* _tmp129_;
			GString* _tmp130_;
			GString* _tmp131_;
			GString* _tmp132_;
			GString* _tmp133_;
#line 1074 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			tracker_sparql_expression_next (self, &_inner_error_);
#line 1074 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			if (_inner_error_ != NULL) {
#line 1074 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 1074 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_propagate_error (error, _inner_error_);
#line 1074 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					return 0;
#line 10231 "tracker-sparql-expression.c"
				} else {
#line 1074 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1074 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_clear_error (&_inner_error_);
#line 1074 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					return 0;
#line 10239 "tracker-sparql-expression.c"
				}
			}
#line 1075 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			tracker_sparql_expression_expect (self, TRACKER_SPARQL_TOKEN_TYPE_OPEN_PARENS, &_inner_error_);
#line 1075 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			if (_inner_error_ != NULL) {
#line 1075 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 1075 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_propagate_error (error, _inner_error_);
#line 1075 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					return 0;
#line 10252 "tracker-sparql-expression.c"
				} else {
#line 1075 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1075 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_clear_error (&_inner_error_);
#line 1075 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					return 0;
#line 10260 "tracker-sparql-expression.c"
				}
			}
#line 1076 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp129_ = sql;
#line 1076 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			g_string_append (_tmp129_, "(");
#line 1077 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp130_ = sql;
#line 1077 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			tracker_sparql_expression_translate_expression (self, _tmp130_, &_inner_error_);
#line 1077 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			if (_inner_error_ != NULL) {
#line 1077 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 1077 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_propagate_error (error, _inner_error_);
#line 1077 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					return 0;
#line 10279 "tracker-sparql-expression.c"
				} else {
#line 1077 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1077 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_clear_error (&_inner_error_);
#line 1077 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					return 0;
#line 10287 "tracker-sparql-expression.c"
				}
			}
#line 1078 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp131_ = sql;
#line 1078 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			g_string_append (_tmp131_, " = ");
#line 1079 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			tracker_sparql_expression_expect (self, TRACKER_SPARQL_TOKEN_TYPE_COMMA, &_inner_error_);
#line 1079 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			if (_inner_error_ != NULL) {
#line 1079 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 1079 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_propagate_error (error, _inner_error_);
#line 1079 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					return 0;
#line 10304 "tracker-sparql-expression.c"
				} else {
#line 1079 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1079 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_clear_error (&_inner_error_);
#line 1079 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					return 0;
#line 10312 "tracker-sparql-expression.c"
				}
			}
#line 1080 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp132_ = sql;
#line 1080 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			tracker_sparql_expression_translate_expression (self, _tmp132_, &_inner_error_);
#line 1080 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			if (_inner_error_ != NULL) {
#line 1080 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 1080 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_propagate_error (error, _inner_error_);
#line 1080 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					return 0;
#line 10327 "tracker-sparql-expression.c"
				} else {
#line 1080 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1080 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_clear_error (&_inner_error_);
#line 1080 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					return 0;
#line 10335 "tracker-sparql-expression.c"
				}
			}
#line 1081 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp133_ = sql;
#line 1081 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			g_string_append (_tmp133_, ")");
#line 1082 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			tracker_sparql_expression_expect (self, TRACKER_SPARQL_TOKEN_TYPE_CLOSE_PARENS, &_inner_error_);
#line 1082 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			if (_inner_error_ != NULL) {
#line 1082 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 1082 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_propagate_error (error, _inner_error_);
#line 1082 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					return 0;
#line 10352 "tracker-sparql-expression.c"
				} else {
#line 1082 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1082 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_clear_error (&_inner_error_);
#line 1082 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					return 0;
#line 10360 "tracker-sparql-expression.c"
				}
			}
#line 1083 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			result = TRACKER_PROPERTY_TYPE_BOOLEAN;
#line 1083 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			return result;
#line 10367 "tracker-sparql-expression.c"
		}
#line 934 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		case TRACKER_SPARQL_TOKEN_TYPE_ISIRI:
#line 934 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		case TRACKER_SPARQL_TOKEN_TYPE_ISURI:
#line 10373 "tracker-sparql-expression.c"
		{
			GString* _tmp134_;
#line 1086 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp134_ = sql;
#line 1086 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			tracker_sparql_expression_translate_isuri (self, _tmp134_, &_inner_error_);
#line 1086 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			if (_inner_error_ != NULL) {
#line 1086 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 1086 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_propagate_error (error, _inner_error_);
#line 1086 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					return 0;
#line 10388 "tracker-sparql-expression.c"
				} else {
#line 1086 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1086 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_clear_error (&_inner_error_);
#line 1086 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					return 0;
#line 10396 "tracker-sparql-expression.c"
				}
			}
#line 1087 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			result = TRACKER_PROPERTY_TYPE_BOOLEAN;
#line 1087 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			return result;
#line 10403 "tracker-sparql-expression.c"
		}
#line 934 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		case TRACKER_SPARQL_TOKEN_TYPE_ISBLANK:
#line 10407 "tracker-sparql-expression.c"
		{
			GString* _tmp135_;
#line 1089 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			tracker_sparql_expression_next (self, &_inner_error_);
#line 1089 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			if (_inner_error_ != NULL) {
#line 1089 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 1089 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_propagate_error (error, _inner_error_);
#line 1089 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					return 0;
#line 10420 "tracker-sparql-expression.c"
				} else {
#line 1089 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1089 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_clear_error (&_inner_error_);
#line 1089 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					return 0;
#line 10428 "tracker-sparql-expression.c"
				}
			}
#line 1090 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			tracker_sparql_expression_expect (self, TRACKER_SPARQL_TOKEN_TYPE_OPEN_PARENS, &_inner_error_);
#line 1090 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			if (_inner_error_ != NULL) {
#line 1090 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 1090 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_propagate_error (error, _inner_error_);
#line 1090 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					return 0;
#line 10441 "tracker-sparql-expression.c"
				} else {
#line 1090 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1090 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_clear_error (&_inner_error_);
#line 1090 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					return 0;
#line 10449 "tracker-sparql-expression.c"
				}
			}
#line 1091 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			tracker_sparql_expression_next (self, &_inner_error_);
#line 1091 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			if (_inner_error_ != NULL) {
#line 1091 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 1091 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_propagate_error (error, _inner_error_);
#line 1091 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					return 0;
#line 10462 "tracker-sparql-expression.c"
				} else {
#line 1091 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1091 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_clear_error (&_inner_error_);
#line 1091 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					return 0;
#line 10470 "tracker-sparql-expression.c"
				}
			}
#line 1093 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp135_ = sql;
#line 1093 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			g_string_append (_tmp135_, "0");
#line 1094 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			tracker_sparql_expression_expect (self, TRACKER_SPARQL_TOKEN_TYPE_CLOSE_PARENS, &_inner_error_);
#line 1094 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			if (_inner_error_ != NULL) {
#line 1094 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 1094 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_propagate_error (error, _inner_error_);
#line 1094 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					return 0;
#line 10487 "tracker-sparql-expression.c"
				} else {
#line 1094 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1094 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_clear_error (&_inner_error_);
#line 1094 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					return 0;
#line 10495 "tracker-sparql-expression.c"
				}
			}
#line 1095 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			result = TRACKER_PROPERTY_TYPE_BOOLEAN;
#line 1095 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			return result;
#line 10502 "tracker-sparql-expression.c"
		}
#line 934 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		case TRACKER_SPARQL_TOKEN_TYPE_ISLITERAL:
#line 10506 "tracker-sparql-expression.c"
		{
#line 1097 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			tracker_sparql_expression_next (self, &_inner_error_);
#line 1097 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			if (_inner_error_ != NULL) {
#line 1097 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 1097 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_propagate_error (error, _inner_error_);
#line 1097 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					return 0;
#line 10518 "tracker-sparql-expression.c"
				} else {
#line 1097 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1097 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_clear_error (&_inner_error_);
#line 1097 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					return 0;
#line 10526 "tracker-sparql-expression.c"
				}
			}
#line 1098 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			result = TRACKER_PROPERTY_TYPE_BOOLEAN;
#line 1098 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			return result;
#line 10533 "tracker-sparql-expression.c"
		}
#line 934 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		case TRACKER_SPARQL_TOKEN_TYPE_REGEX:
#line 10537 "tracker-sparql-expression.c"
		{
			GString* _tmp136_;
			TrackerSparqlQuery* _tmp137_;
#line 1100 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp136_ = sql;
#line 1100 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			tracker_sparql_expression_translate_regex (self, _tmp136_, &_inner_error_);
#line 1100 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			if (_inner_error_ != NULL) {
#line 1100 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 1100 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_propagate_error (error, _inner_error_);
#line 1100 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					return 0;
#line 10553 "tracker-sparql-expression.c"
				} else {
#line 1100 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1100 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_clear_error (&_inner_error_);
#line 1100 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					return 0;
#line 10561 "tracker-sparql-expression.c"
				}
			}
#line 1101 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp137_ = self->priv->query;
#line 1101 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			tracker_sparql_query_set_no_cache (_tmp137_, TRUE);
#line 1102 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			result = TRACKER_PROPERTY_TYPE_BOOLEAN;
#line 1102 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			return result;
#line 10572 "tracker-sparql-expression.c"
		}
#line 934 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		case TRACKER_SPARQL_TOKEN_TYPE_EXISTS:
#line 934 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		case TRACKER_SPARQL_TOKEN_TYPE_NOT:
#line 10578 "tracker-sparql-expression.c"
		{
			GString* _tmp138_;
#line 1105 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp138_ = sql;
#line 1105 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			tracker_sparql_expression_translate_exists (self, _tmp138_, &_inner_error_);
#line 1105 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			if (_inner_error_ != NULL) {
#line 1105 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 1105 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_propagate_error (error, _inner_error_);
#line 1105 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					return 0;
#line 10593 "tracker-sparql-expression.c"
				} else {
#line 1105 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1105 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_clear_error (&_inner_error_);
#line 1105 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					return 0;
#line 10601 "tracker-sparql-expression.c"
				}
			}
#line 1106 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			result = TRACKER_PROPERTY_TYPE_BOOLEAN;
#line 1106 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			return result;
#line 10608 "tracker-sparql-expression.c"
		}
#line 934 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		case TRACKER_SPARQL_TOKEN_TYPE_COUNT:
#line 10612 "tracker-sparql-expression.c"
		{
			GString* _tmp139_;
			GString* _tmp140_;
			GString* _tmp141_;
#line 1108 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			tracker_sparql_expression_next (self, &_inner_error_);
#line 1108 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			if (_inner_error_ != NULL) {
#line 1108 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 1108 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_propagate_error (error, _inner_error_);
#line 1108 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					return 0;
#line 10627 "tracker-sparql-expression.c"
				} else {
#line 1108 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1108 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_clear_error (&_inner_error_);
#line 1108 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					return 0;
#line 10635 "tracker-sparql-expression.c"
				}
			}
#line 1109 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp139_ = sql;
#line 1109 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			g_string_append (_tmp139_, "COUNT(");
#line 1110 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp140_ = sql;
#line 1110 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			tracker_sparql_expression_translate_aggregate_expression (self, _tmp140_, &_inner_error_);
#line 1110 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			if (_inner_error_ != NULL) {
#line 1110 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 1110 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_propagate_error (error, _inner_error_);
#line 1110 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					return 0;
#line 10654 "tracker-sparql-expression.c"
				} else {
#line 1110 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1110 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_clear_error (&_inner_error_);
#line 1110 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					return 0;
#line 10662 "tracker-sparql-expression.c"
				}
			}
#line 1111 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp141_ = sql;
#line 1111 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			g_string_append (_tmp141_, ")");
#line 1112 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			result = TRACKER_PROPERTY_TYPE_INTEGER;
#line 1112 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			return result;
#line 10673 "tracker-sparql-expression.c"
		}
#line 934 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		case TRACKER_SPARQL_TOKEN_TYPE_SUM:
#line 10677 "tracker-sparql-expression.c"
		{
			GString* _tmp142_;
			GString* _tmp143_;
			TrackerPropertyType _tmp144_ = 0;
			TrackerPropertyType _tmp145_;
			GString* _tmp146_;
#line 1114 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			tracker_sparql_expression_next (self, &_inner_error_);
#line 1114 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			if (_inner_error_ != NULL) {
#line 1114 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 1114 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_propagate_error (error, _inner_error_);
#line 1114 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					return 0;
#line 10694 "tracker-sparql-expression.c"
				} else {
#line 1114 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1114 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_clear_error (&_inner_error_);
#line 1114 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					return 0;
#line 10702 "tracker-sparql-expression.c"
				}
			}
#line 1115 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp142_ = sql;
#line 1115 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			g_string_append (_tmp142_, "SUM(");
#line 1116 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp143_ = sql;
#line 1116 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp144_ = tracker_sparql_expression_translate_aggregate_expression (self, _tmp143_, &_inner_error_);
#line 1116 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp145_ = _tmp144_;
#line 1116 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			if (_inner_error_ != NULL) {
#line 1116 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 1116 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_propagate_error (error, _inner_error_);
#line 1116 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					return 0;
#line 10723 "tracker-sparql-expression.c"
				} else {
#line 1116 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1116 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_clear_error (&_inner_error_);
#line 1116 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					return 0;
#line 10731 "tracker-sparql-expression.c"
				}
			}
#line 1116 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			type = _tmp145_;
#line 1117 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp146_ = sql;
#line 1117 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			g_string_append (_tmp146_, ")");
#line 1118 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			result = type;
#line 1118 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			return result;
#line 10744 "tracker-sparql-expression.c"
		}
#line 934 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		case TRACKER_SPARQL_TOKEN_TYPE_AVG:
#line 10748 "tracker-sparql-expression.c"
		{
			GString* _tmp147_;
			GString* _tmp148_;
			TrackerPropertyType _tmp149_ = 0;
			TrackerPropertyType _tmp150_;
			GString* _tmp151_;
#line 1120 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			tracker_sparql_expression_next (self, &_inner_error_);
#line 1120 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			if (_inner_error_ != NULL) {
#line 1120 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 1120 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_propagate_error (error, _inner_error_);
#line 1120 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					return 0;
#line 10765 "tracker-sparql-expression.c"
				} else {
#line 1120 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1120 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_clear_error (&_inner_error_);
#line 1120 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					return 0;
#line 10773 "tracker-sparql-expression.c"
				}
			}
#line 1121 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp147_ = sql;
#line 1121 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			g_string_append (_tmp147_, "AVG(");
#line 1122 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp148_ = sql;
#line 1122 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp149_ = tracker_sparql_expression_translate_aggregate_expression (self, _tmp148_, &_inner_error_);
#line 1122 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp150_ = _tmp149_;
#line 1122 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			if (_inner_error_ != NULL) {
#line 1122 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 1122 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_propagate_error (error, _inner_error_);
#line 1122 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					return 0;
#line 10794 "tracker-sparql-expression.c"
				} else {
#line 1122 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1122 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_clear_error (&_inner_error_);
#line 1122 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					return 0;
#line 10802 "tracker-sparql-expression.c"
				}
			}
#line 1122 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			type = _tmp150_;
#line 1123 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp151_ = sql;
#line 1123 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			g_string_append (_tmp151_, ")");
#line 1124 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			result = type;
#line 1124 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			return result;
#line 10815 "tracker-sparql-expression.c"
		}
#line 934 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		case TRACKER_SPARQL_TOKEN_TYPE_MIN:
#line 10819 "tracker-sparql-expression.c"
		{
			GString* _tmp152_;
			GString* _tmp153_;
			TrackerPropertyType _tmp154_ = 0;
			TrackerPropertyType _tmp155_;
			GString* _tmp156_;
#line 1126 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			tracker_sparql_expression_next (self, &_inner_error_);
#line 1126 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			if (_inner_error_ != NULL) {
#line 1126 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 1126 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_propagate_error (error, _inner_error_);
#line 1126 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					return 0;
#line 10836 "tracker-sparql-expression.c"
				} else {
#line 1126 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1126 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_clear_error (&_inner_error_);
#line 1126 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					return 0;
#line 10844 "tracker-sparql-expression.c"
				}
			}
#line 1127 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp152_ = sql;
#line 1127 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			g_string_append (_tmp152_, "MIN(");
#line 1128 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp153_ = sql;
#line 1128 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp154_ = tracker_sparql_expression_translate_aggregate_expression (self, _tmp153_, &_inner_error_);
#line 1128 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp155_ = _tmp154_;
#line 1128 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			if (_inner_error_ != NULL) {
#line 1128 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 1128 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_propagate_error (error, _inner_error_);
#line 1128 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					return 0;
#line 10865 "tracker-sparql-expression.c"
				} else {
#line 1128 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1128 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_clear_error (&_inner_error_);
#line 1128 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					return 0;
#line 10873 "tracker-sparql-expression.c"
				}
			}
#line 1128 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			type = _tmp155_;
#line 1129 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp156_ = sql;
#line 1129 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			g_string_append (_tmp156_, ")");
#line 1130 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			result = type;
#line 1130 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			return result;
#line 10886 "tracker-sparql-expression.c"
		}
#line 934 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		case TRACKER_SPARQL_TOKEN_TYPE_MAX:
#line 10890 "tracker-sparql-expression.c"
		{
			GString* _tmp157_;
			GString* _tmp158_;
			TrackerPropertyType _tmp159_ = 0;
			TrackerPropertyType _tmp160_;
			GString* _tmp161_;
#line 1132 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			tracker_sparql_expression_next (self, &_inner_error_);
#line 1132 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			if (_inner_error_ != NULL) {
#line 1132 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 1132 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_propagate_error (error, _inner_error_);
#line 1132 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					return 0;
#line 10907 "tracker-sparql-expression.c"
				} else {
#line 1132 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1132 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_clear_error (&_inner_error_);
#line 1132 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					return 0;
#line 10915 "tracker-sparql-expression.c"
				}
			}
#line 1133 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp157_ = sql;
#line 1133 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			g_string_append (_tmp157_, "MAX(");
#line 1134 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp158_ = sql;
#line 1134 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp159_ = tracker_sparql_expression_translate_aggregate_expression (self, _tmp158_, &_inner_error_);
#line 1134 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp160_ = _tmp159_;
#line 1134 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			if (_inner_error_ != NULL) {
#line 1134 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 1134 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_propagate_error (error, _inner_error_);
#line 1134 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					return 0;
#line 10936 "tracker-sparql-expression.c"
				} else {
#line 1134 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1134 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_clear_error (&_inner_error_);
#line 1134 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					return 0;
#line 10944 "tracker-sparql-expression.c"
				}
			}
#line 1134 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			type = _tmp160_;
#line 1135 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp161_ = sql;
#line 1135 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			g_string_append (_tmp161_, ")");
#line 1136 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			result = type;
#line 1136 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			return result;
#line 10957 "tracker-sparql-expression.c"
		}
#line 934 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		case TRACKER_SPARQL_TOKEN_TYPE_GROUP_CONCAT:
#line 10961 "tracker-sparql-expression.c"
		{
			GString* _tmp162_;
			GString* _tmp163_;
			GString* _tmp164_;
			gchar* _tmp165_ = NULL;
			gchar* _tmp166_;
			GString* _tmp167_;
			gchar* _tmp168_;
			gchar* _tmp169_ = NULL;
			gchar* _tmp170_;
			GString* _tmp171_;
#line 1138 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			tracker_sparql_expression_next (self, &_inner_error_);
#line 1138 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			if (_inner_error_ != NULL) {
#line 1138 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 1138 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_propagate_error (error, _inner_error_);
#line 1138 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					return 0;
#line 10983 "tracker-sparql-expression.c"
				} else {
#line 1138 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1138 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_clear_error (&_inner_error_);
#line 1138 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					return 0;
#line 10991 "tracker-sparql-expression.c"
				}
			}
#line 1139 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp162_ = sql;
#line 1139 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			g_string_append (_tmp162_, "GROUP_CONCAT(");
#line 1140 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			tracker_sparql_expression_expect (self, TRACKER_SPARQL_TOKEN_TYPE_OPEN_PARENS, &_inner_error_);
#line 1140 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			if (_inner_error_ != NULL) {
#line 1140 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 1140 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_propagate_error (error, _inner_error_);
#line 1140 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					return 0;
#line 11008 "tracker-sparql-expression.c"
				} else {
#line 1140 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1140 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_clear_error (&_inner_error_);
#line 1140 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					return 0;
#line 11016 "tracker-sparql-expression.c"
				}
			}
#line 1141 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp163_ = sql;
#line 1141 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			tracker_sparql_expression_translate_expression_as_string (self, _tmp163_, &_inner_error_);
#line 1141 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			if (_inner_error_ != NULL) {
#line 1141 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 1141 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_propagate_error (error, _inner_error_);
#line 1141 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					return 0;
#line 11031 "tracker-sparql-expression.c"
				} else {
#line 1141 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1141 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_clear_error (&_inner_error_);
#line 1141 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					return 0;
#line 11039 "tracker-sparql-expression.c"
				}
			}
#line 1142 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp164_ = sql;
#line 1142 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			g_string_append (_tmp164_, ", ");
#line 1143 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			tracker_sparql_expression_expect (self, TRACKER_SPARQL_TOKEN_TYPE_COMMA, &_inner_error_);
#line 1143 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			if (_inner_error_ != NULL) {
#line 1143 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 1143 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_propagate_error (error, _inner_error_);
#line 1143 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					return 0;
#line 11056 "tracker-sparql-expression.c"
				} else {
#line 1143 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1143 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_clear_error (&_inner_error_);
#line 1143 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					return 0;
#line 11064 "tracker-sparql-expression.c"
				}
			}
#line 1144 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp165_ = tracker_sparql_expression_parse_string_literal (self, NULL, &_inner_error_);
#line 1144 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp166_ = _tmp165_;
#line 1144 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			if (_inner_error_ != NULL) {
#line 1144 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 1144 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_propagate_error (error, _inner_error_);
#line 1144 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					return 0;
#line 11079 "tracker-sparql-expression.c"
				} else {
#line 1144 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1144 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_clear_error (&_inner_error_);
#line 1144 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					return 0;
#line 11087 "tracker-sparql-expression.c"
				}
			}
#line 1144 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp167_ = sql;
#line 1144 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp168_ = _tmp166_;
#line 1144 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp169_ = tracker_sparql_expression_escape_sql_string_literal (self, _tmp168_);
#line 1144 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp170_ = _tmp169_;
#line 1144 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			g_string_append (_tmp167_, _tmp170_);
#line 1144 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_g_free0 (_tmp170_);
#line 1144 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_g_free0 (_tmp168_);
#line 1145 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp171_ = sql;
#line 1145 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			g_string_append (_tmp171_, ")");
#line 1146 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			tracker_sparql_expression_expect (self, TRACKER_SPARQL_TOKEN_TYPE_CLOSE_PARENS, &_inner_error_);
#line 1146 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			if (_inner_error_ != NULL) {
#line 1146 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 1146 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_propagate_error (error, _inner_error_);
#line 1146 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					return 0;
#line 11118 "tracker-sparql-expression.c"
				} else {
#line 1146 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1146 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_clear_error (&_inner_error_);
#line 1146 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					return 0;
#line 11126 "tracker-sparql-expression.c"
				}
			}
#line 1147 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			result = TRACKER_PROPERTY_TYPE_STRING;
#line 1147 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			return result;
#line 11133 "tracker-sparql-expression.c"
		}
#line 934 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		case TRACKER_SPARQL_TOKEN_TYPE_PN_PREFIX:
#line 11137 "tracker-sparql-expression.c"
		{
			gchar* _tmp172_ = NULL;
			gchar* ns;
			TrackerSparqlQuery* _tmp173_;
			const gchar* _tmp174_;
			gchar* _tmp175_ = NULL;
			gchar* _tmp176_;
			gchar* _tmp177_ = NULL;
			gchar* _tmp178_;
			gchar* _tmp179_ = NULL;
			gchar* _tmp180_;
			gchar* uri;
			GString* _tmp181_;
			const gchar* _tmp182_;
			TrackerPropertyType _tmp183_ = 0;
			TrackerPropertyType _tmp184_;
#line 1149 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			tracker_sparql_expression_next (self, &_inner_error_);
#line 1149 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			if (_inner_error_ != NULL) {
#line 1149 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 1149 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_propagate_error (error, _inner_error_);
#line 1149 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					return 0;
#line 11164 "tracker-sparql-expression.c"
				} else {
#line 1149 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1149 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_clear_error (&_inner_error_);
#line 1149 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					return 0;
#line 11172 "tracker-sparql-expression.c"
				}
			}
#line 1150 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp172_ = tracker_sparql_expression_get_last_string (self, 0);
#line 1150 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			ns = _tmp172_;
#line 1151 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			tracker_sparql_expression_expect (self, TRACKER_SPARQL_TOKEN_TYPE_COLON, &_inner_error_);
#line 1151 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			if (_inner_error_ != NULL) {
#line 1151 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 1151 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_propagate_error (error, _inner_error_);
#line 1151 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					_g_free0 (ns);
#line 1151 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					return 0;
#line 11191 "tracker-sparql-expression.c"
				} else {
#line 1151 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					_g_free0 (ns);
#line 1151 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1151 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_clear_error (&_inner_error_);
#line 1151 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					return 0;
#line 11201 "tracker-sparql-expression.c"
				}
			}
#line 1152 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp173_ = self->priv->query;
#line 1152 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp174_ = ns;
#line 1152 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp175_ = tracker_sparql_expression_get_last_string (self, 0);
#line 1152 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp176_ = _tmp175_;
#line 1152 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp177_ = string_substring (_tmp176_, (glong) 1, (glong) (-1));
#line 1152 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp178_ = _tmp177_;
#line 1152 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp179_ = tracker_sparql_query_resolve_prefixed_name (_tmp173_, _tmp174_, _tmp178_, &_inner_error_);
#line 1152 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp180_ = _tmp179_;
#line 1152 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_g_free0 (_tmp178_);
#line 1152 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_g_free0 (_tmp176_);
#line 1152 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			uri = _tmp180_;
#line 1152 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			if (_inner_error_ != NULL) {
#line 1152 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 1152 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_propagate_error (error, _inner_error_);
#line 1152 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					_g_free0 (ns);
#line 1152 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					return 0;
#line 11236 "tracker-sparql-expression.c"
				} else {
#line 1152 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					_g_free0 (ns);
#line 1152 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1152 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_clear_error (&_inner_error_);
#line 1152 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					return 0;
#line 11246 "tracker-sparql-expression.c"
				}
			}
#line 1153 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp181_ = sql;
#line 1153 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp182_ = uri;
#line 1153 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp183_ = tracker_sparql_expression_translate_uri_expression (self, _tmp181_, _tmp182_, &_inner_error_);
#line 1153 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp184_ = _tmp183_;
#line 1153 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			if (_inner_error_ != NULL) {
#line 1153 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 1153 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_propagate_error (error, _inner_error_);
#line 1153 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					_g_free0 (uri);
#line 1153 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					_g_free0 (ns);
#line 1153 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					return 0;
#line 11269 "tracker-sparql-expression.c"
				} else {
#line 1153 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					_g_free0 (uri);
#line 1153 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					_g_free0 (ns);
#line 1153 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1153 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_clear_error (&_inner_error_);
#line 1153 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					return 0;
#line 11281 "tracker-sparql-expression.c"
				}
			}
#line 1153 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			result = _tmp184_;
#line 1153 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_g_free0 (uri);
#line 1153 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_g_free0 (ns);
#line 1153 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			return result;
#line 11292 "tracker-sparql-expression.c"
		}
#line 934 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		case TRACKER_SPARQL_TOKEN_TYPE_COLON:
#line 11296 "tracker-sparql-expression.c"
		{
			TrackerSparqlQuery* _tmp185_;
			gchar* _tmp186_ = NULL;
			gchar* _tmp187_;
			gchar* _tmp188_ = NULL;
			gchar* _tmp189_;
			gchar* _tmp190_ = NULL;
			gchar* _tmp191_;
			gchar* uri;
			GString* _tmp192_;
			const gchar* _tmp193_;
			TrackerPropertyType _tmp194_ = 0;
			TrackerPropertyType _tmp195_;
#line 1155 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			tracker_sparql_expression_next (self, &_inner_error_);
#line 1155 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			if (_inner_error_ != NULL) {
#line 1155 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 1155 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_propagate_error (error, _inner_error_);
#line 1155 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					return 0;
#line 11320 "tracker-sparql-expression.c"
				} else {
#line 1155 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1155 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_clear_error (&_inner_error_);
#line 1155 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					return 0;
#line 11328 "tracker-sparql-expression.c"
				}
			}
#line 1156 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp185_ = self->priv->query;
#line 1156 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp186_ = tracker_sparql_expression_get_last_string (self, 0);
#line 1156 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp187_ = _tmp186_;
#line 1156 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp188_ = string_substring (_tmp187_, (glong) 1, (glong) (-1));
#line 1156 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp189_ = _tmp188_;
#line 1156 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp190_ = tracker_sparql_query_resolve_prefixed_name (_tmp185_, "", _tmp189_, &_inner_error_);
#line 1156 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp191_ = _tmp190_;
#line 1156 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_g_free0 (_tmp189_);
#line 1156 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_g_free0 (_tmp187_);
#line 1156 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			uri = _tmp191_;
#line 1156 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			if (_inner_error_ != NULL) {
#line 1156 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 1156 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_propagate_error (error, _inner_error_);
#line 1156 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					return 0;
#line 11359 "tracker-sparql-expression.c"
				} else {
#line 1156 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1156 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_clear_error (&_inner_error_);
#line 1156 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					return 0;
#line 11367 "tracker-sparql-expression.c"
				}
			}
#line 1157 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp192_ = sql;
#line 1157 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp193_ = uri;
#line 1157 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp194_ = tracker_sparql_expression_translate_uri_expression (self, _tmp192_, _tmp193_, &_inner_error_);
#line 1157 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp195_ = _tmp194_;
#line 1157 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			if (_inner_error_ != NULL) {
#line 1157 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 1157 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_propagate_error (error, _inner_error_);
#line 1157 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					_g_free0 (uri);
#line 1157 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					return 0;
#line 11388 "tracker-sparql-expression.c"
				} else {
#line 1157 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					_g_free0 (uri);
#line 1157 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1157 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_clear_error (&_inner_error_);
#line 1157 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					return 0;
#line 11398 "tracker-sparql-expression.c"
				}
			}
#line 1157 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			result = _tmp195_;
#line 1157 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_g_free0 (uri);
#line 1157 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			return result;
#line 11407 "tracker-sparql-expression.c"
		}
		default:
		{
			GError* _tmp196_ = NULL;
#line 1159 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp196_ = tracker_sparql_expression_get_error (self, "expected primary expression");
#line 1159 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_inner_error_ = _tmp196_;
#line 1159 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 1159 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				g_propagate_error (error, _inner_error_);
#line 1159 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				return 0;
#line 11422 "tracker-sparql-expression.c"
			} else {
#line 1159 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1159 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				g_clear_error (&_inner_error_);
#line 1159 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				return 0;
#line 11430 "tracker-sparql-expression.c"
			}
		}
	}
}


static TrackerPropertyType tracker_sparql_expression_translate_unary_expression (TrackerSparqlExpression* self, GString* sql, GError** error) {
	TrackerPropertyType result = 0;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_;
	GString* _tmp19_;
	TrackerPropertyType _tmp20_ = 0;
	TrackerPropertyType _tmp21_;
	GError * _inner_error_ = NULL;
#line 1163 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	g_return_val_if_fail (self != NULL, 0);
#line 1163 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	g_return_val_if_fail (sql != NULL, 0);
#line 1164 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	_tmp0_ = tracker_sparql_expression_accept (self, TRACKER_SPARQL_TOKEN_TYPE_OP_NEG, &_inner_error_);
#line 1164 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	_tmp1_ = _tmp0_;
#line 1164 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	if (_inner_error_ != NULL) {
#line 1164 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 1164 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			g_propagate_error (error, _inner_error_);
#line 1164 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			return 0;
#line 11461 "tracker-sparql-expression.c"
		} else {
#line 1164 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1164 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			g_clear_error (&_inner_error_);
#line 1164 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			return 0;
#line 11469 "tracker-sparql-expression.c"
		}
	}
#line 1164 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	if (_tmp1_) {
#line 11474 "tracker-sparql-expression.c"
		GString* _tmp2_;
		GString* _tmp3_;
		TrackerPropertyType _tmp4_ = 0;
		TrackerPropertyType optype;
		GString* _tmp5_;
		TrackerPropertyType _tmp6_;
#line 1165 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		_tmp2_ = sql;
#line 1165 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		g_string_append (_tmp2_, "NOT (");
#line 1166 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		_tmp3_ = sql;
#line 1166 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		_tmp4_ = tracker_sparql_expression_translate_primary_expression (self, _tmp3_, &_inner_error_);
#line 1166 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		optype = _tmp4_;
#line 1166 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		if (_inner_error_ != NULL) {
#line 1166 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 1166 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				g_propagate_error (error, _inner_error_);
#line 1166 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				return 0;
#line 11499 "tracker-sparql-expression.c"
			} else {
#line 1166 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1166 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				g_clear_error (&_inner_error_);
#line 1166 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				return 0;
#line 11507 "tracker-sparql-expression.c"
			}
		}
#line 1167 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		_tmp5_ = sql;
#line 1167 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		g_string_append (_tmp5_, ")");
#line 1168 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		_tmp6_ = optype;
#line 1168 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		if (_tmp6_ != TRACKER_PROPERTY_TYPE_BOOLEAN) {
#line 11518 "tracker-sparql-expression.c"
			GError* _tmp7_ = NULL;
#line 1169 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp7_ = tracker_sparql_expression_get_error (self, "expected boolean expression");
#line 1169 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_inner_error_ = _tmp7_;
#line 1169 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 1169 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				g_propagate_error (error, _inner_error_);
#line 1169 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				return 0;
#line 11530 "tracker-sparql-expression.c"
			} else {
#line 1169 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1169 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				g_clear_error (&_inner_error_);
#line 1169 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				return 0;
#line 11538 "tracker-sparql-expression.c"
			}
		}
#line 1171 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		result = TRACKER_PROPERTY_TYPE_BOOLEAN;
#line 1171 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		return result;
#line 11545 "tracker-sparql-expression.c"
	} else {
		gboolean _tmp8_ = FALSE;
		gboolean _tmp9_;
#line 1172 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		_tmp8_ = tracker_sparql_expression_accept (self, TRACKER_SPARQL_TOKEN_TYPE_PLUS, &_inner_error_);
#line 1172 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		_tmp9_ = _tmp8_;
#line 1172 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		if (_inner_error_ != NULL) {
#line 1172 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 1172 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				g_propagate_error (error, _inner_error_);
#line 1172 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				return 0;
#line 11561 "tracker-sparql-expression.c"
			} else {
#line 1172 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1172 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				g_clear_error (&_inner_error_);
#line 1172 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				return 0;
#line 11569 "tracker-sparql-expression.c"
			}
		}
#line 1172 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		if (_tmp9_) {
#line 11574 "tracker-sparql-expression.c"
			GString* _tmp10_;
			TrackerPropertyType _tmp11_ = 0;
			TrackerPropertyType _tmp12_;
#line 1173 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp10_ = sql;
#line 1173 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp11_ = tracker_sparql_expression_translate_primary_expression (self, _tmp10_, &_inner_error_);
#line 1173 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp12_ = _tmp11_;
#line 1173 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			if (_inner_error_ != NULL) {
#line 1173 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 1173 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_propagate_error (error, _inner_error_);
#line 1173 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					return 0;
#line 11592 "tracker-sparql-expression.c"
				} else {
#line 1173 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1173 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_clear_error (&_inner_error_);
#line 1173 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					return 0;
#line 11600 "tracker-sparql-expression.c"
				}
			}
#line 1173 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			result = _tmp12_;
#line 1173 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			return result;
#line 11607 "tracker-sparql-expression.c"
		} else {
			gboolean _tmp13_ = FALSE;
			gboolean _tmp14_;
#line 1174 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp13_ = tracker_sparql_expression_accept (self, TRACKER_SPARQL_TOKEN_TYPE_MINUS, &_inner_error_);
#line 1174 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp14_ = _tmp13_;
#line 1174 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			if (_inner_error_ != NULL) {
#line 1174 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 1174 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_propagate_error (error, _inner_error_);
#line 1174 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					return 0;
#line 11623 "tracker-sparql-expression.c"
				} else {
#line 1174 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1174 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_clear_error (&_inner_error_);
#line 1174 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					return 0;
#line 11631 "tracker-sparql-expression.c"
				}
			}
#line 1174 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			if (_tmp14_) {
#line 11636 "tracker-sparql-expression.c"
				GString* _tmp15_;
				GString* _tmp16_;
				TrackerPropertyType _tmp17_ = 0;
				TrackerPropertyType optype;
				GString* _tmp18_;
#line 1175 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				_tmp15_ = sql;
#line 1175 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				g_string_append (_tmp15_, "-(");
#line 1176 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				_tmp16_ = sql;
#line 1176 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				_tmp17_ = tracker_sparql_expression_translate_primary_expression (self, _tmp16_, &_inner_error_);
#line 1176 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				optype = _tmp17_;
#line 1176 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				if (_inner_error_ != NULL) {
#line 1176 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 1176 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
						g_propagate_error (error, _inner_error_);
#line 1176 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
						return 0;
#line 11660 "tracker-sparql-expression.c"
					} else {
#line 1176 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1176 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
						g_clear_error (&_inner_error_);
#line 1176 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
						return 0;
#line 11668 "tracker-sparql-expression.c"
					}
				}
#line 1177 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				_tmp18_ = sql;
#line 1177 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				g_string_append (_tmp18_, ")");
#line 1178 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				result = optype;
#line 1178 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				return result;
#line 11679 "tracker-sparql-expression.c"
			}
		}
	}
#line 1180 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	_tmp19_ = sql;
#line 1180 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	_tmp20_ = tracker_sparql_expression_translate_primary_expression (self, _tmp19_, &_inner_error_);
#line 1180 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	_tmp21_ = _tmp20_;
#line 1180 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	if (_inner_error_ != NULL) {
#line 1180 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 1180 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			g_propagate_error (error, _inner_error_);
#line 1180 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			return 0;
#line 11697 "tracker-sparql-expression.c"
		} else {
#line 1180 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1180 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			g_clear_error (&_inner_error_);
#line 1180 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			return 0;
#line 11705 "tracker-sparql-expression.c"
		}
	}
#line 1180 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	result = _tmp21_;
#line 1180 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	return result;
#line 11712 "tracker-sparql-expression.c"
}


static TrackerPropertyType tracker_sparql_expression_translate_multiplicative_expression (TrackerSparqlExpression* self, GString* sql, GError** error) {
	TrackerPropertyType result = 0;
	GString* _tmp0_;
	gssize _tmp1_;
	glong begin;
	GString* _tmp2_;
	TrackerPropertyType _tmp3_ = 0;
	TrackerPropertyType optype;
	GError * _inner_error_ = NULL;
#line 1183 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	g_return_val_if_fail (self != NULL, 0);
#line 1183 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	g_return_val_if_fail (sql != NULL, 0);
#line 1184 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	_tmp0_ = sql;
#line 1184 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	_tmp1_ = _tmp0_->len;
#line 1184 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	begin = (glong) _tmp1_;
#line 1185 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	_tmp2_ = sql;
#line 1185 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	_tmp3_ = tracker_sparql_expression_translate_unary_expression (self, _tmp2_, &_inner_error_);
#line 1185 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	optype = _tmp3_;
#line 1185 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	if (_inner_error_ != NULL) {
#line 1185 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 1185 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			g_propagate_error (error, _inner_error_);
#line 1185 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			return 0;
#line 11749 "tracker-sparql-expression.c"
		} else {
#line 1185 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1185 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			g_clear_error (&_inner_error_);
#line 1185 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			return 0;
#line 11757 "tracker-sparql-expression.c"
		}
	}
#line 1186 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	while (TRUE) {
#line 11762 "tracker-sparql-expression.c"
		gboolean _tmp4_ = FALSE;
		gboolean _tmp5_;
#line 1187 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		_tmp4_ = tracker_sparql_expression_accept (self, TRACKER_SPARQL_TOKEN_TYPE_STAR, &_inner_error_);
#line 1187 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		_tmp5_ = _tmp4_;
#line 1187 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		if (_inner_error_ != NULL) {
#line 1187 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 1187 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				g_propagate_error (error, _inner_error_);
#line 1187 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				return 0;
#line 11777 "tracker-sparql-expression.c"
			} else {
#line 1187 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1187 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				g_clear_error (&_inner_error_);
#line 1187 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				return 0;
#line 11785 "tracker-sparql-expression.c"
			}
		}
#line 1187 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		if (_tmp5_) {
#line 11790 "tracker-sparql-expression.c"
			TrackerPropertyType _tmp6_;
			gboolean _tmp7_ = FALSE;
			GString* _tmp9_;
			glong _tmp10_;
			GString* _tmp11_;
			GString* _tmp12_;
			TrackerPropertyType _tmp13_ = 0;
			TrackerPropertyType _tmp14_;
			gboolean _tmp15_ = FALSE;
			GString* _tmp17_;
#line 1188 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp6_ = optype;
#line 1188 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp7_ = tracker_sparql_expression_maybe_numeric (self, _tmp6_);
#line 1188 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			if (!_tmp7_) {
#line 11807 "tracker-sparql-expression.c"
				GError* _tmp8_ = NULL;
#line 1189 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				_tmp8_ = tracker_sparql_expression_get_error (self, "expected numeric operand");
#line 1189 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				_inner_error_ = _tmp8_;
#line 1189 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 1189 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_propagate_error (error, _inner_error_);
#line 1189 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					return 0;
#line 11819 "tracker-sparql-expression.c"
				} else {
#line 1189 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1189 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_clear_error (&_inner_error_);
#line 1189 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					return 0;
#line 11827 "tracker-sparql-expression.c"
				}
			}
#line 1191 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp9_ = sql;
#line 1191 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp10_ = begin;
#line 1191 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			g_string_insert (_tmp9_, (gssize) _tmp10_, "(");
#line 1192 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp11_ = sql;
#line 1192 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			g_string_append (_tmp11_, " * ");
#line 1193 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp12_ = sql;
#line 1193 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp13_ = tracker_sparql_expression_translate_unary_expression (self, _tmp12_, &_inner_error_);
#line 1193 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp14_ = _tmp13_;
#line 1193 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			if (_inner_error_ != NULL) {
#line 1193 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 1193 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_propagate_error (error, _inner_error_);
#line 1193 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					return 0;
#line 11854 "tracker-sparql-expression.c"
				} else {
#line 1193 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1193 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_clear_error (&_inner_error_);
#line 1193 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					return 0;
#line 11862 "tracker-sparql-expression.c"
				}
			}
#line 1193 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp15_ = tracker_sparql_expression_maybe_numeric (self, _tmp14_);
#line 1193 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			if (!_tmp15_) {
#line 11869 "tracker-sparql-expression.c"
				GError* _tmp16_ = NULL;
#line 1194 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				_tmp16_ = tracker_sparql_expression_get_error (self, "expected numeric operand");
#line 1194 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				_inner_error_ = _tmp16_;
#line 1194 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 1194 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_propagate_error (error, _inner_error_);
#line 1194 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					return 0;
#line 11881 "tracker-sparql-expression.c"
				} else {
#line 1194 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1194 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_clear_error (&_inner_error_);
#line 1194 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					return 0;
#line 11889 "tracker-sparql-expression.c"
				}
			}
#line 1196 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp17_ = sql;
#line 1196 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			g_string_append (_tmp17_, ")");
#line 11896 "tracker-sparql-expression.c"
		} else {
			gboolean _tmp18_ = FALSE;
			gboolean _tmp19_;
#line 1197 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp18_ = tracker_sparql_expression_accept (self, TRACKER_SPARQL_TOKEN_TYPE_DIV, &_inner_error_);
#line 1197 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp19_ = _tmp18_;
#line 1197 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			if (_inner_error_ != NULL) {
#line 1197 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 1197 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_propagate_error (error, _inner_error_);
#line 1197 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					return 0;
#line 11912 "tracker-sparql-expression.c"
				} else {
#line 1197 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1197 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_clear_error (&_inner_error_);
#line 1197 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					return 0;
#line 11920 "tracker-sparql-expression.c"
				}
			}
#line 1197 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			if (_tmp19_) {
#line 11925 "tracker-sparql-expression.c"
				TrackerPropertyType _tmp20_;
				gboolean _tmp21_ = FALSE;
				GString* _tmp23_;
				glong _tmp24_;
				GString* _tmp25_;
				GString* _tmp26_;
				TrackerPropertyType _tmp27_ = 0;
				TrackerPropertyType _tmp28_;
				gboolean _tmp29_ = FALSE;
				GString* _tmp31_;
#line 1198 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				_tmp20_ = optype;
#line 1198 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				_tmp21_ = tracker_sparql_expression_maybe_numeric (self, _tmp20_);
#line 1198 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				if (!_tmp21_) {
#line 11942 "tracker-sparql-expression.c"
					GError* _tmp22_ = NULL;
#line 1199 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					_tmp22_ = tracker_sparql_expression_get_error (self, "expected numeric operand");
#line 1199 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					_inner_error_ = _tmp22_;
#line 1199 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 1199 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
						g_propagate_error (error, _inner_error_);
#line 1199 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
						return 0;
#line 11954 "tracker-sparql-expression.c"
					} else {
#line 1199 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1199 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
						g_clear_error (&_inner_error_);
#line 1199 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
						return 0;
#line 11962 "tracker-sparql-expression.c"
					}
				}
#line 1201 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				_tmp23_ = sql;
#line 1201 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				_tmp24_ = begin;
#line 1201 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				g_string_insert (_tmp23_, (gssize) _tmp24_, "(");
#line 1202 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				_tmp25_ = sql;
#line 1202 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				g_string_append (_tmp25_, " / ");
#line 1203 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				_tmp26_ = sql;
#line 1203 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				_tmp27_ = tracker_sparql_expression_translate_unary_expression (self, _tmp26_, &_inner_error_);
#line 1203 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				_tmp28_ = _tmp27_;
#line 1203 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				if (_inner_error_ != NULL) {
#line 1203 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 1203 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
						g_propagate_error (error, _inner_error_);
#line 1203 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
						return 0;
#line 11989 "tracker-sparql-expression.c"
					} else {
#line 1203 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1203 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
						g_clear_error (&_inner_error_);
#line 1203 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
						return 0;
#line 11997 "tracker-sparql-expression.c"
					}
				}
#line 1203 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				_tmp29_ = tracker_sparql_expression_maybe_numeric (self, _tmp28_);
#line 1203 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				if (!_tmp29_) {
#line 12004 "tracker-sparql-expression.c"
					GError* _tmp30_ = NULL;
#line 1204 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					_tmp30_ = tracker_sparql_expression_get_error (self, "expected numeric operand");
#line 1204 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					_inner_error_ = _tmp30_;
#line 1204 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 1204 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
						g_propagate_error (error, _inner_error_);
#line 1204 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
						return 0;
#line 12016 "tracker-sparql-expression.c"
					} else {
#line 1204 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1204 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
						g_clear_error (&_inner_error_);
#line 1204 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
						return 0;
#line 12024 "tracker-sparql-expression.c"
					}
				}
#line 1206 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				_tmp31_ = sql;
#line 1206 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				g_string_append (_tmp31_, ")");
#line 12031 "tracker-sparql-expression.c"
			} else {
#line 1208 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				break;
#line 12035 "tracker-sparql-expression.c"
			}
		}
	}
#line 1211 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	result = optype;
#line 1211 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	return result;
#line 12043 "tracker-sparql-expression.c"
}


static TrackerPropertyType tracker_sparql_expression_translate_additive_expression (TrackerSparqlExpression* self, GString* sql, GError** error) {
	TrackerPropertyType result = 0;
	GString* _tmp0_;
	gssize _tmp1_;
	glong begin;
	GString* _tmp2_;
	TrackerPropertyType _tmp3_ = 0;
	TrackerPropertyType optype;
	GError * _inner_error_ = NULL;
#line 1214 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	g_return_val_if_fail (self != NULL, 0);
#line 1214 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	g_return_val_if_fail (sql != NULL, 0);
#line 1215 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	_tmp0_ = sql;
#line 1215 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	_tmp1_ = _tmp0_->len;
#line 1215 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	begin = (glong) _tmp1_;
#line 1216 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	_tmp2_ = sql;
#line 1216 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	_tmp3_ = tracker_sparql_expression_translate_multiplicative_expression (self, _tmp2_, &_inner_error_);
#line 1216 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	optype = _tmp3_;
#line 1216 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	if (_inner_error_ != NULL) {
#line 1216 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 1216 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			g_propagate_error (error, _inner_error_);
#line 1216 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			return 0;
#line 12080 "tracker-sparql-expression.c"
		} else {
#line 1216 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1216 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			g_clear_error (&_inner_error_);
#line 1216 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			return 0;
#line 12088 "tracker-sparql-expression.c"
		}
	}
#line 1217 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	while (TRUE) {
#line 12093 "tracker-sparql-expression.c"
		gboolean _tmp4_ = FALSE;
		gboolean _tmp5_;
#line 1218 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		_tmp4_ = tracker_sparql_expression_accept (self, TRACKER_SPARQL_TOKEN_TYPE_PLUS, &_inner_error_);
#line 1218 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		_tmp5_ = _tmp4_;
#line 1218 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		if (_inner_error_ != NULL) {
#line 1218 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 1218 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				g_propagate_error (error, _inner_error_);
#line 1218 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				return 0;
#line 12108 "tracker-sparql-expression.c"
			} else {
#line 1218 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1218 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				g_clear_error (&_inner_error_);
#line 1218 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				return 0;
#line 12116 "tracker-sparql-expression.c"
			}
		}
#line 1218 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		if (_tmp5_) {
#line 12121 "tracker-sparql-expression.c"
			TrackerPropertyType _tmp6_;
			gboolean _tmp7_ = FALSE;
			GString* _tmp9_;
			glong _tmp10_;
			GString* _tmp11_;
			GString* _tmp12_;
			TrackerPropertyType _tmp13_ = 0;
			TrackerPropertyType _tmp14_;
			gboolean _tmp15_ = FALSE;
			GString* _tmp17_;
#line 1219 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp6_ = optype;
#line 1219 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp7_ = tracker_sparql_expression_maybe_numeric (self, _tmp6_);
#line 1219 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			if (!_tmp7_) {
#line 12138 "tracker-sparql-expression.c"
				GError* _tmp8_ = NULL;
#line 1220 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				_tmp8_ = tracker_sparql_expression_get_error (self, "expected numeric operand");
#line 1220 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				_inner_error_ = _tmp8_;
#line 1220 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 1220 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_propagate_error (error, _inner_error_);
#line 1220 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					return 0;
#line 12150 "tracker-sparql-expression.c"
				} else {
#line 1220 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1220 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_clear_error (&_inner_error_);
#line 1220 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					return 0;
#line 12158 "tracker-sparql-expression.c"
				}
			}
#line 1222 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp9_ = sql;
#line 1222 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp10_ = begin;
#line 1222 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			g_string_insert (_tmp9_, (gssize) _tmp10_, "(");
#line 1223 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp11_ = sql;
#line 1223 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			g_string_append (_tmp11_, " + ");
#line 1224 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp12_ = sql;
#line 1224 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp13_ = tracker_sparql_expression_translate_multiplicative_expression (self, _tmp12_, &_inner_error_);
#line 1224 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp14_ = _tmp13_;
#line 1224 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			if (_inner_error_ != NULL) {
#line 1224 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 1224 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_propagate_error (error, _inner_error_);
#line 1224 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					return 0;
#line 12185 "tracker-sparql-expression.c"
				} else {
#line 1224 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1224 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_clear_error (&_inner_error_);
#line 1224 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					return 0;
#line 12193 "tracker-sparql-expression.c"
				}
			}
#line 1224 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp15_ = tracker_sparql_expression_maybe_numeric (self, _tmp14_);
#line 1224 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			if (!_tmp15_) {
#line 12200 "tracker-sparql-expression.c"
				GError* _tmp16_ = NULL;
#line 1225 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				_tmp16_ = tracker_sparql_expression_get_error (self, "expected numeric operand");
#line 1225 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				_inner_error_ = _tmp16_;
#line 1225 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 1225 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_propagate_error (error, _inner_error_);
#line 1225 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					return 0;
#line 12212 "tracker-sparql-expression.c"
				} else {
#line 1225 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1225 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_clear_error (&_inner_error_);
#line 1225 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					return 0;
#line 12220 "tracker-sparql-expression.c"
				}
			}
#line 1227 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp17_ = sql;
#line 1227 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			g_string_append (_tmp17_, ")");
#line 12227 "tracker-sparql-expression.c"
		} else {
			gboolean _tmp18_ = FALSE;
			gboolean _tmp19_;
#line 1228 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp18_ = tracker_sparql_expression_accept (self, TRACKER_SPARQL_TOKEN_TYPE_MINUS, &_inner_error_);
#line 1228 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp19_ = _tmp18_;
#line 1228 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			if (_inner_error_ != NULL) {
#line 1228 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 1228 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_propagate_error (error, _inner_error_);
#line 1228 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					return 0;
#line 12243 "tracker-sparql-expression.c"
				} else {
#line 1228 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1228 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_clear_error (&_inner_error_);
#line 1228 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					return 0;
#line 12251 "tracker-sparql-expression.c"
				}
			}
#line 1228 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			if (_tmp19_) {
#line 12256 "tracker-sparql-expression.c"
				TrackerPropertyType _tmp20_;
				gboolean _tmp21_ = FALSE;
				GString* _tmp23_;
				glong _tmp24_;
				GString* _tmp25_;
				GString* _tmp26_;
				TrackerPropertyType _tmp27_ = 0;
				TrackerPropertyType _tmp28_;
				gboolean _tmp29_ = FALSE;
				GString* _tmp31_;
#line 1229 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				_tmp20_ = optype;
#line 1229 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				_tmp21_ = tracker_sparql_expression_maybe_numeric (self, _tmp20_);
#line 1229 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				if (!_tmp21_) {
#line 12273 "tracker-sparql-expression.c"
					GError* _tmp22_ = NULL;
#line 1230 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					_tmp22_ = tracker_sparql_expression_get_error (self, "expected numeric operand");
#line 1230 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					_inner_error_ = _tmp22_;
#line 1230 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 1230 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
						g_propagate_error (error, _inner_error_);
#line 1230 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
						return 0;
#line 12285 "tracker-sparql-expression.c"
					} else {
#line 1230 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1230 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
						g_clear_error (&_inner_error_);
#line 1230 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
						return 0;
#line 12293 "tracker-sparql-expression.c"
					}
				}
#line 1232 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				_tmp23_ = sql;
#line 1232 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				_tmp24_ = begin;
#line 1232 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				g_string_insert (_tmp23_, (gssize) _tmp24_, "(");
#line 1233 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				_tmp25_ = sql;
#line 1233 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				g_string_append (_tmp25_, " - ");
#line 1234 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				_tmp26_ = sql;
#line 1234 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				_tmp27_ = tracker_sparql_expression_translate_multiplicative_expression (self, _tmp26_, &_inner_error_);
#line 1234 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				_tmp28_ = _tmp27_;
#line 1234 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				if (_inner_error_ != NULL) {
#line 1234 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 1234 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
						g_propagate_error (error, _inner_error_);
#line 1234 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
						return 0;
#line 12320 "tracker-sparql-expression.c"
					} else {
#line 1234 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1234 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
						g_clear_error (&_inner_error_);
#line 1234 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
						return 0;
#line 12328 "tracker-sparql-expression.c"
					}
				}
#line 1234 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				_tmp29_ = tracker_sparql_expression_maybe_numeric (self, _tmp28_);
#line 1234 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				if (!_tmp29_) {
#line 12335 "tracker-sparql-expression.c"
					GError* _tmp30_ = NULL;
#line 1235 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					_tmp30_ = tracker_sparql_expression_get_error (self, "expected numeric operand");
#line 1235 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					_inner_error_ = _tmp30_;
#line 1235 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 1235 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
						g_propagate_error (error, _inner_error_);
#line 1235 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
						return 0;
#line 12347 "tracker-sparql-expression.c"
					} else {
#line 1235 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1235 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
						g_clear_error (&_inner_error_);
#line 1235 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
						return 0;
#line 12355 "tracker-sparql-expression.c"
					}
				}
#line 1237 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				_tmp31_ = sql;
#line 1237 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				g_string_append (_tmp31_, ")");
#line 12362 "tracker-sparql-expression.c"
			} else {
#line 1239 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				break;
#line 12366 "tracker-sparql-expression.c"
			}
		}
	}
#line 1242 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	result = optype;
#line 1242 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	return result;
#line 12374 "tracker-sparql-expression.c"
}


static TrackerPropertyType tracker_sparql_expression_translate_numeric_expression (TrackerSparqlExpression* self, GString* sql, GError** error) {
	TrackerPropertyType result = 0;
	GString* _tmp0_;
	TrackerPropertyType _tmp1_ = 0;
	TrackerPropertyType _tmp2_;
	GError * _inner_error_ = NULL;
#line 1245 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	g_return_val_if_fail (self != NULL, 0);
#line 1245 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	g_return_val_if_fail (sql != NULL, 0);
#line 1246 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	_tmp0_ = sql;
#line 1246 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	_tmp1_ = tracker_sparql_expression_translate_additive_expression (self, _tmp0_, &_inner_error_);
#line 1246 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	_tmp2_ = _tmp1_;
#line 1246 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	if (_inner_error_ != NULL) {
#line 1246 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 1246 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			g_propagate_error (error, _inner_error_);
#line 1246 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			return 0;
#line 12402 "tracker-sparql-expression.c"
		} else {
#line 1246 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1246 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			g_clear_error (&_inner_error_);
#line 1246 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			return 0;
#line 12410 "tracker-sparql-expression.c"
		}
	}
#line 1246 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	result = _tmp2_;
#line 1246 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	return result;
#line 12417 "tracker-sparql-expression.c"
}


static TrackerPropertyType tracker_sparql_expression_process_relational_expression (TrackerSparqlExpression* self, GString* sql, glong begin, guint n_bindings, TrackerPropertyType op1type, const gchar* operator, GError** error) {
	TrackerPropertyType result = 0;
	GString* _tmp0_;
	glong _tmp1_;
	GString* _tmp2_;
	const gchar* _tmp3_;
	GString* _tmp4_;
	TrackerPropertyType _tmp5_ = 0;
	TrackerPropertyType op2type;
	GString* _tmp6_;
	gboolean _tmp7_ = FALSE;
	gboolean _tmp8_ = FALSE;
	TrackerPropertyType _tmp9_;
	gboolean _tmp10_;
	gboolean _tmp14_;
	GError * _inner_error_ = NULL;
#line 1249 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	g_return_val_if_fail (self != NULL, 0);
#line 1249 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	g_return_val_if_fail (sql != NULL, 0);
#line 1249 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	g_return_val_if_fail (operator != NULL, 0);
#line 1250 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	_tmp0_ = sql;
#line 1250 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	_tmp1_ = begin;
#line 1250 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	g_string_insert (_tmp0_, (gssize) _tmp1_, "(");
#line 1251 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	_tmp2_ = sql;
#line 1251 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	_tmp3_ = operator;
#line 1251 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	g_string_append (_tmp2_, _tmp3_);
#line 1252 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	_tmp4_ = sql;
#line 1252 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	_tmp5_ = tracker_sparql_expression_translate_numeric_expression (self, _tmp4_, &_inner_error_);
#line 1252 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	op2type = _tmp5_;
#line 1252 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	if (_inner_error_ != NULL) {
#line 1252 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 1252 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			g_propagate_error (error, _inner_error_);
#line 1252 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			return 0;
#line 12469 "tracker-sparql-expression.c"
		} else {
#line 1252 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1252 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			g_clear_error (&_inner_error_);
#line 1252 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			return 0;
#line 12477 "tracker-sparql-expression.c"
		}
	}
#line 1253 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	_tmp6_ = sql;
#line 1253 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	g_string_append (_tmp6_, ")");
#line 1254 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	_tmp9_ = op1type;
#line 1254 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	if (_tmp9_ == TRACKER_PROPERTY_TYPE_DATETIME) {
#line 1254 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		_tmp8_ = op2type == TRACKER_PROPERTY_TYPE_STRING;
#line 12490 "tracker-sparql-expression.c"
	} else {
#line 1254 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		_tmp8_ = FALSE;
#line 12494 "tracker-sparql-expression.c"
	}
#line 1254 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	_tmp10_ = _tmp8_;
#line 1254 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	if (_tmp10_) {
#line 1254 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		_tmp7_ = TRUE;
#line 12502 "tracker-sparql-expression.c"
	} else {
		gboolean _tmp11_ = FALSE;
		TrackerPropertyType _tmp12_;
		gboolean _tmp13_;
#line 1255 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		_tmp12_ = op1type;
#line 1255 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		if (_tmp12_ == TRACKER_PROPERTY_TYPE_STRING) {
#line 1255 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp11_ = op2type == TRACKER_PROPERTY_TYPE_DATETIME;
#line 12513 "tracker-sparql-expression.c"
		} else {
#line 1255 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp11_ = FALSE;
#line 12517 "tracker-sparql-expression.c"
		}
#line 1255 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		_tmp13_ = _tmp11_;
#line 1255 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		_tmp7_ = _tmp13_;
#line 12523 "tracker-sparql-expression.c"
	}
#line 1254 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	_tmp14_ = _tmp7_;
#line 1254 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	if (_tmp14_) {
#line 12529 "tracker-sparql-expression.c"
		TrackerSparqlQuery* _tmp15_;
		GList* _tmp16_;
		guint _tmp17_ = 0U;
		guint _tmp18_;
#line 1257 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		_tmp15_ = self->priv->query;
#line 1257 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		_tmp16_ = _tmp15_->bindings;
#line 1257 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		_tmp17_ = g_list_length (_tmp16_);
#line 1257 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		_tmp18_ = n_bindings;
#line 1257 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		if (_tmp17_ == (_tmp18_ + 1)) {
#line 12544 "tracker-sparql-expression.c"
			TrackerSparqlQuery* _tmp19_;
			GList* _tmp20_;
			GList* _tmp21_ = NULL;
			gconstpointer _tmp22_;
#line 1259 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp19_ = self->priv->query;
#line 1259 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp20_ = _tmp19_->bindings;
#line 1259 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp21_ = g_list_last (_tmp20_);
#line 1259 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp22_ = _tmp21_->data;
#line 1259 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			((TrackerSparqlDataBinding*) ((TrackerSparqlLiteralBinding*) _tmp22_))->data_type = TRACKER_PROPERTY_TYPE_DATETIME;
#line 12559 "tracker-sparql-expression.c"
		}
	} else {
		gboolean _tmp23_ = FALSE;
		gboolean _tmp24_ = FALSE;
		TrackerPropertyType _tmp25_;
		gboolean _tmp26_;
		gboolean _tmp30_;
#line 1261 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		_tmp25_ = op1type;
#line 1261 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		if (_tmp25_ == TRACKER_PROPERTY_TYPE_DATE) {
#line 1261 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp24_ = op2type == TRACKER_PROPERTY_TYPE_STRING;
#line 12573 "tracker-sparql-expression.c"
		} else {
#line 1261 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp24_ = FALSE;
#line 12577 "tracker-sparql-expression.c"
		}
#line 1261 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		_tmp26_ = _tmp24_;
#line 1261 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		if (_tmp26_) {
#line 1261 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp23_ = TRUE;
#line 12585 "tracker-sparql-expression.c"
		} else {
			gboolean _tmp27_ = FALSE;
			TrackerPropertyType _tmp28_;
			gboolean _tmp29_;
#line 1262 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp28_ = op1type;
#line 1262 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			if (_tmp28_ == TRACKER_PROPERTY_TYPE_STRING) {
#line 1262 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				_tmp27_ = op2type == TRACKER_PROPERTY_TYPE_DATE;
#line 12596 "tracker-sparql-expression.c"
			} else {
#line 1262 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				_tmp27_ = FALSE;
#line 12600 "tracker-sparql-expression.c"
			}
#line 1262 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp29_ = _tmp27_;
#line 1262 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp23_ = _tmp29_;
#line 12606 "tracker-sparql-expression.c"
		}
#line 1261 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		_tmp30_ = _tmp23_;
#line 1261 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		if (_tmp30_) {
#line 12612 "tracker-sparql-expression.c"
			TrackerSparqlQuery* _tmp31_;
			GList* _tmp32_;
			guint _tmp33_ = 0U;
			guint _tmp34_;
#line 1264 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp31_ = self->priv->query;
#line 1264 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp32_ = _tmp31_->bindings;
#line 1264 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp33_ = g_list_length (_tmp32_);
#line 1264 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp34_ = n_bindings;
#line 1264 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			if (_tmp33_ == (_tmp34_ + 1)) {
#line 12627 "tracker-sparql-expression.c"
				TrackerSparqlQuery* _tmp35_;
				GList* _tmp36_;
				GList* _tmp37_ = NULL;
				gconstpointer _tmp38_;
#line 1266 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				_tmp35_ = self->priv->query;
#line 1266 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				_tmp36_ = _tmp35_->bindings;
#line 1266 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				_tmp37_ = g_list_last (_tmp36_);
#line 1266 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				_tmp38_ = _tmp37_->data;
#line 1266 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				((TrackerSparqlDataBinding*) ((TrackerSparqlLiteralBinding*) _tmp38_))->data_type = TRACKER_PROPERTY_TYPE_DATE;
#line 12642 "tracker-sparql-expression.c"
			}
		}
	}
#line 1269 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	result = TRACKER_PROPERTY_TYPE_BOOLEAN;
#line 1269 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	return result;
#line 12650 "tracker-sparql-expression.c"
}


static TrackerPropertyType tracker_sparql_expression_translate_in (TrackerSparqlExpression* self, GString* sql, gboolean not, GError** error) {
	TrackerPropertyType result = 0;
	gint in_variable_count;
	gboolean _tmp0_;
	GString* _tmp2_;
	gboolean _tmp3_ = FALSE;
	gboolean _tmp4_;
	GString* _tmp19_;
	GError * _inner_error_ = NULL;
#line 1272 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	g_return_val_if_fail (self != NULL, 0);
#line 1272 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	g_return_val_if_fail (sql != NULL, 0);
#line 1274 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	in_variable_count = 0;
#line 1276 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	_tmp0_ = not;
#line 1276 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	if (_tmp0_) {
#line 12673 "tracker-sparql-expression.c"
		GString* _tmp1_;
#line 1277 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		_tmp1_ = sql;
#line 1277 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		g_string_append (_tmp1_, " NOT");
#line 12679 "tracker-sparql-expression.c"
	}
#line 1280 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	tracker_sparql_expression_expect (self, TRACKER_SPARQL_TOKEN_TYPE_OPEN_PARENS, &_inner_error_);
#line 1280 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	if (_inner_error_ != NULL) {
#line 1280 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 1280 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			g_propagate_error (error, _inner_error_);
#line 1280 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			return 0;
#line 12691 "tracker-sparql-expression.c"
		} else {
#line 1280 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1280 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			g_clear_error (&_inner_error_);
#line 1280 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			return 0;
#line 12699 "tracker-sparql-expression.c"
		}
	}
#line 1281 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	_tmp2_ = sql;
#line 1281 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	g_string_append (_tmp2_, " IN (");
#line 1282 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	_tmp3_ = tracker_sparql_expression_accept (self, TRACKER_SPARQL_TOKEN_TYPE_CLOSE_PARENS, &_inner_error_);
#line 1282 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	_tmp4_ = _tmp3_;
#line 1282 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	if (_inner_error_ != NULL) {
#line 1282 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 1282 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			g_propagate_error (error, _inner_error_);
#line 1282 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			return 0;
#line 12718 "tracker-sparql-expression.c"
		} else {
#line 1282 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1282 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			g_clear_error (&_inner_error_);
#line 1282 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			return 0;
#line 12726 "tracker-sparql-expression.c"
		}
	}
#line 1282 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	if (!_tmp4_) {
#line 12731 "tracker-sparql-expression.c"
		gint _tmp5_;
		GString* _tmp6_;
#line 1283 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		_tmp5_ = in_variable_count;
#line 1283 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		in_variable_count = _tmp5_ + 1;
#line 1284 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		_tmp6_ = sql;
#line 1284 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		tracker_sparql_expression_translate_expression (self, _tmp6_, &_inner_error_);
#line 1284 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		if (_inner_error_ != NULL) {
#line 1284 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 1284 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				g_propagate_error (error, _inner_error_);
#line 1284 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				return 0;
#line 12750 "tracker-sparql-expression.c"
			} else {
#line 1284 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1284 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				g_clear_error (&_inner_error_);
#line 1284 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				return 0;
#line 12758 "tracker-sparql-expression.c"
			}
		}
#line 1285 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		while (TRUE) {
#line 12763 "tracker-sparql-expression.c"
			gboolean _tmp7_ = FALSE;
			gboolean _tmp8_;
			GString* _tmp9_;
			gint _tmp10_;
			gboolean _tmp11_ = FALSE;
			gint _tmp12_;
			gboolean _tmp16_;
			GString* _tmp18_;
#line 1285 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp7_ = tracker_sparql_expression_accept (self, TRACKER_SPARQL_TOKEN_TYPE_COMMA, &_inner_error_);
#line 1285 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp8_ = _tmp7_;
#line 1285 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			if (_inner_error_ != NULL) {
#line 1285 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 1285 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_propagate_error (error, _inner_error_);
#line 1285 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					return 0;
#line 12784 "tracker-sparql-expression.c"
				} else {
#line 1285 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1285 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_clear_error (&_inner_error_);
#line 1285 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					return 0;
#line 12792 "tracker-sparql-expression.c"
				}
			}
#line 1285 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			if (!_tmp8_) {
#line 1285 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				break;
#line 12799 "tracker-sparql-expression.c"
			}
#line 1286 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp9_ = sql;
#line 1286 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			g_string_append (_tmp9_, ", ");
#line 1288 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp10_ = in_variable_count;
#line 1288 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			in_variable_count = _tmp10_ + 1;
#line 1290 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp12_ = in_variable_count;
#line 1290 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			if (_tmp12_ > TRACKER_SPARQL_EXPRESSION_MAX_VARIABLES_FOR_IN) {
#line 12813 "tracker-sparql-expression.c"
				TrackerSparqlQuery* _tmp13_;
				gboolean _tmp14_;
				gboolean _tmp15_;
#line 1290 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				_tmp13_ = self->priv->query;
#line 1290 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				_tmp14_ = tracker_sparql_query_get_no_cache (_tmp13_);
#line 1290 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				_tmp15_ = _tmp14_;
#line 1290 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				_tmp11_ = !_tmp15_;
#line 12825 "tracker-sparql-expression.c"
			} else {
#line 1290 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				_tmp11_ = FALSE;
#line 12829 "tracker-sparql-expression.c"
			}
#line 1290 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp16_ = _tmp11_;
#line 1290 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			if (_tmp16_) {
#line 12835 "tracker-sparql-expression.c"
				TrackerSparqlQuery* _tmp17_;
#line 1291 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				_tmp17_ = self->priv->query;
#line 1291 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				tracker_sparql_query_set_no_cache (_tmp17_, TRUE);
#line 12841 "tracker-sparql-expression.c"
			}
#line 1294 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp18_ = sql;
#line 1294 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			tracker_sparql_expression_translate_expression (self, _tmp18_, &_inner_error_);
#line 1294 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			if (_inner_error_ != NULL) {
#line 1294 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 1294 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_propagate_error (error, _inner_error_);
#line 1294 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					return 0;
#line 12855 "tracker-sparql-expression.c"
				} else {
#line 1294 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1294 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_clear_error (&_inner_error_);
#line 1294 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					return 0;
#line 12863 "tracker-sparql-expression.c"
				}
			}
		}
#line 1296 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		tracker_sparql_expression_expect (self, TRACKER_SPARQL_TOKEN_TYPE_CLOSE_PARENS, &_inner_error_);
#line 1296 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		if (_inner_error_ != NULL) {
#line 1296 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 1296 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				g_propagate_error (error, _inner_error_);
#line 1296 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				return 0;
#line 12877 "tracker-sparql-expression.c"
			} else {
#line 1296 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1296 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				g_clear_error (&_inner_error_);
#line 1296 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				return 0;
#line 12885 "tracker-sparql-expression.c"
			}
		}
	}
#line 1298 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	_tmp19_ = sql;
#line 1298 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	g_string_append (_tmp19_, ")");
#line 1300 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	result = TRACKER_PROPERTY_TYPE_BOOLEAN;
#line 1300 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	return result;
#line 12897 "tracker-sparql-expression.c"
}


static TrackerPropertyType tracker_sparql_expression_translate_relational_expression (TrackerSparqlExpression* self, GString* sql, GError** error) {
	TrackerPropertyType result = 0;
	GString* _tmp0_;
	gssize _tmp1_;
	glong begin;
	TrackerSparqlQuery* _tmp2_;
	GList* _tmp3_;
	guint _tmp4_ = 0U;
	guint n_bindings;
	GString* _tmp5_;
	TrackerPropertyType _tmp6_ = 0;
	TrackerPropertyType optype;
	gboolean _tmp7_ = FALSE;
	gboolean _tmp8_;
	GError * _inner_error_ = NULL;
#line 1303 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	g_return_val_if_fail (self != NULL, 0);
#line 1303 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	g_return_val_if_fail (sql != NULL, 0);
#line 1304 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	_tmp0_ = sql;
#line 1304 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	_tmp1_ = _tmp0_->len;
#line 1304 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	begin = (glong) _tmp1_;
#line 1306 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	_tmp2_ = self->priv->query;
#line 1306 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	_tmp3_ = _tmp2_->bindings;
#line 1306 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	_tmp4_ = g_list_length (_tmp3_);
#line 1306 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	n_bindings = _tmp4_;
#line 1307 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	_tmp5_ = sql;
#line 1307 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	_tmp6_ = tracker_sparql_expression_translate_numeric_expression (self, _tmp5_, &_inner_error_);
#line 1307 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	optype = _tmp6_;
#line 1307 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	if (_inner_error_ != NULL) {
#line 1307 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 1307 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			g_propagate_error (error, _inner_error_);
#line 1307 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			return 0;
#line 12948 "tracker-sparql-expression.c"
		} else {
#line 1307 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1307 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			g_clear_error (&_inner_error_);
#line 1307 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			return 0;
#line 12956 "tracker-sparql-expression.c"
		}
	}
#line 1308 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	_tmp7_ = tracker_sparql_expression_accept (self, TRACKER_SPARQL_TOKEN_TYPE_OP_GE, &_inner_error_);
#line 1308 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	_tmp8_ = _tmp7_;
#line 1308 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	if (_inner_error_ != NULL) {
#line 1308 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 1308 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			g_propagate_error (error, _inner_error_);
#line 1308 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			return 0;
#line 12971 "tracker-sparql-expression.c"
		} else {
#line 1308 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1308 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			g_clear_error (&_inner_error_);
#line 1308 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			return 0;
#line 12979 "tracker-sparql-expression.c"
		}
	}
#line 1308 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	if (_tmp8_) {
#line 12984 "tracker-sparql-expression.c"
		GString* _tmp9_;
		glong _tmp10_;
		guint _tmp11_;
		TrackerPropertyType _tmp12_;
		TrackerPropertyType _tmp13_ = 0;
		TrackerPropertyType _tmp14_;
#line 1309 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		_tmp9_ = sql;
#line 1309 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		_tmp10_ = begin;
#line 1309 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		_tmp11_ = n_bindings;
#line 1309 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		_tmp12_ = optype;
#line 1309 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		_tmp13_ = tracker_sparql_expression_process_relational_expression (self, _tmp9_, _tmp10_, _tmp11_, _tmp12_, " >= ", &_inner_error_);
#line 1309 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		_tmp14_ = _tmp13_;
#line 1309 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		if (_inner_error_ != NULL) {
#line 1309 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 1309 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				g_propagate_error (error, _inner_error_);
#line 1309 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				return 0;
#line 13011 "tracker-sparql-expression.c"
			} else {
#line 1309 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1309 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				g_clear_error (&_inner_error_);
#line 1309 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				return 0;
#line 13019 "tracker-sparql-expression.c"
			}
		}
#line 1309 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		result = _tmp14_;
#line 1309 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		return result;
#line 13026 "tracker-sparql-expression.c"
	} else {
		gboolean _tmp15_ = FALSE;
		gboolean _tmp16_;
#line 1310 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		_tmp15_ = tracker_sparql_expression_accept (self, TRACKER_SPARQL_TOKEN_TYPE_OP_EQ, &_inner_error_);
#line 1310 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		_tmp16_ = _tmp15_;
#line 1310 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		if (_inner_error_ != NULL) {
#line 1310 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 1310 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				g_propagate_error (error, _inner_error_);
#line 1310 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				return 0;
#line 13042 "tracker-sparql-expression.c"
			} else {
#line 1310 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1310 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				g_clear_error (&_inner_error_);
#line 1310 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				return 0;
#line 13050 "tracker-sparql-expression.c"
			}
		}
#line 1310 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		if (_tmp16_) {
#line 13055 "tracker-sparql-expression.c"
			GString* _tmp17_;
			glong _tmp18_;
			guint _tmp19_;
			TrackerPropertyType _tmp20_;
			TrackerPropertyType _tmp21_ = 0;
			TrackerPropertyType _tmp22_;
#line 1311 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp17_ = sql;
#line 1311 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp18_ = begin;
#line 1311 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp19_ = n_bindings;
#line 1311 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp20_ = optype;
#line 1311 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp21_ = tracker_sparql_expression_process_relational_expression (self, _tmp17_, _tmp18_, _tmp19_, _tmp20_, " = ", &_inner_error_);
#line 1311 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp22_ = _tmp21_;
#line 1311 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			if (_inner_error_ != NULL) {
#line 1311 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 1311 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_propagate_error (error, _inner_error_);
#line 1311 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					return 0;
#line 13082 "tracker-sparql-expression.c"
				} else {
#line 1311 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1311 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_clear_error (&_inner_error_);
#line 1311 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					return 0;
#line 13090 "tracker-sparql-expression.c"
				}
			}
#line 1311 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			result = _tmp22_;
#line 1311 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			return result;
#line 13097 "tracker-sparql-expression.c"
		} else {
			gboolean _tmp23_ = FALSE;
			gboolean _tmp24_;
#line 1312 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp23_ = tracker_sparql_expression_accept (self, TRACKER_SPARQL_TOKEN_TYPE_OP_NE, &_inner_error_);
#line 1312 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp24_ = _tmp23_;
#line 1312 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			if (_inner_error_ != NULL) {
#line 1312 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 1312 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_propagate_error (error, _inner_error_);
#line 1312 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					return 0;
#line 13113 "tracker-sparql-expression.c"
				} else {
#line 1312 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1312 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_clear_error (&_inner_error_);
#line 1312 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					return 0;
#line 13121 "tracker-sparql-expression.c"
				}
			}
#line 1312 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			if (_tmp24_) {
#line 13126 "tracker-sparql-expression.c"
				GString* _tmp25_;
				glong _tmp26_;
				guint _tmp27_;
				TrackerPropertyType _tmp28_;
				TrackerPropertyType _tmp29_ = 0;
				TrackerPropertyType _tmp30_;
#line 1313 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				_tmp25_ = sql;
#line 1313 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				_tmp26_ = begin;
#line 1313 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				_tmp27_ = n_bindings;
#line 1313 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				_tmp28_ = optype;
#line 1313 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				_tmp29_ = tracker_sparql_expression_process_relational_expression (self, _tmp25_, _tmp26_, _tmp27_, _tmp28_, " <> ", &_inner_error_);
#line 1313 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				_tmp30_ = _tmp29_;
#line 1313 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				if (_inner_error_ != NULL) {
#line 1313 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 1313 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
						g_propagate_error (error, _inner_error_);
#line 1313 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
						return 0;
#line 13153 "tracker-sparql-expression.c"
					} else {
#line 1313 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1313 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
						g_clear_error (&_inner_error_);
#line 1313 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
						return 0;
#line 13161 "tracker-sparql-expression.c"
					}
				}
#line 1313 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				result = _tmp30_;
#line 1313 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				return result;
#line 13168 "tracker-sparql-expression.c"
			} else {
				gboolean _tmp31_ = FALSE;
				gboolean _tmp32_;
#line 1314 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				_tmp31_ = tracker_sparql_expression_accept (self, TRACKER_SPARQL_TOKEN_TYPE_OP_LT, &_inner_error_);
#line 1314 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				_tmp32_ = _tmp31_;
#line 1314 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				if (_inner_error_ != NULL) {
#line 1314 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 1314 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
						g_propagate_error (error, _inner_error_);
#line 1314 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
						return 0;
#line 13184 "tracker-sparql-expression.c"
					} else {
#line 1314 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1314 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
						g_clear_error (&_inner_error_);
#line 1314 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
						return 0;
#line 13192 "tracker-sparql-expression.c"
					}
				}
#line 1314 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				if (_tmp32_) {
#line 13197 "tracker-sparql-expression.c"
					GString* _tmp33_;
					glong _tmp34_;
					guint _tmp35_;
					TrackerPropertyType _tmp36_;
					TrackerPropertyType _tmp37_ = 0;
					TrackerPropertyType _tmp38_;
#line 1315 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					_tmp33_ = sql;
#line 1315 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					_tmp34_ = begin;
#line 1315 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					_tmp35_ = n_bindings;
#line 1315 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					_tmp36_ = optype;
#line 1315 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					_tmp37_ = tracker_sparql_expression_process_relational_expression (self, _tmp33_, _tmp34_, _tmp35_, _tmp36_, " < ", &_inner_error_);
#line 1315 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					_tmp38_ = _tmp37_;
#line 1315 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					if (_inner_error_ != NULL) {
#line 1315 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
						if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 1315 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
							g_propagate_error (error, _inner_error_);
#line 1315 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
							return 0;
#line 13224 "tracker-sparql-expression.c"
						} else {
#line 1315 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
							g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1315 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
							g_clear_error (&_inner_error_);
#line 1315 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
							return 0;
#line 13232 "tracker-sparql-expression.c"
						}
					}
#line 1315 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					result = _tmp38_;
#line 1315 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					return result;
#line 13239 "tracker-sparql-expression.c"
				} else {
					gboolean _tmp39_ = FALSE;
					gboolean _tmp40_;
#line 1316 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					_tmp39_ = tracker_sparql_expression_accept (self, TRACKER_SPARQL_TOKEN_TYPE_OP_LE, &_inner_error_);
#line 1316 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					_tmp40_ = _tmp39_;
#line 1316 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					if (_inner_error_ != NULL) {
#line 1316 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
						if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 1316 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
							g_propagate_error (error, _inner_error_);
#line 1316 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
							return 0;
#line 13255 "tracker-sparql-expression.c"
						} else {
#line 1316 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
							g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1316 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
							g_clear_error (&_inner_error_);
#line 1316 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
							return 0;
#line 13263 "tracker-sparql-expression.c"
						}
					}
#line 1316 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					if (_tmp40_) {
#line 13268 "tracker-sparql-expression.c"
						GString* _tmp41_;
						glong _tmp42_;
						guint _tmp43_;
						TrackerPropertyType _tmp44_;
						TrackerPropertyType _tmp45_ = 0;
						TrackerPropertyType _tmp46_;
#line 1317 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
						_tmp41_ = sql;
#line 1317 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
						_tmp42_ = begin;
#line 1317 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
						_tmp43_ = n_bindings;
#line 1317 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
						_tmp44_ = optype;
#line 1317 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
						_tmp45_ = tracker_sparql_expression_process_relational_expression (self, _tmp41_, _tmp42_, _tmp43_, _tmp44_, " <= ", &_inner_error_);
#line 1317 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
						_tmp46_ = _tmp45_;
#line 1317 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
						if (_inner_error_ != NULL) {
#line 1317 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
							if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 1317 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
								g_propagate_error (error, _inner_error_);
#line 1317 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
								return 0;
#line 13295 "tracker-sparql-expression.c"
							} else {
#line 1317 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
								g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1317 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
								g_clear_error (&_inner_error_);
#line 1317 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
								return 0;
#line 13303 "tracker-sparql-expression.c"
							}
						}
#line 1317 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
						result = _tmp46_;
#line 1317 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
						return result;
#line 13310 "tracker-sparql-expression.c"
					} else {
						gboolean _tmp47_ = FALSE;
						gboolean _tmp48_;
#line 1318 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
						_tmp47_ = tracker_sparql_expression_accept (self, TRACKER_SPARQL_TOKEN_TYPE_OP_GT, &_inner_error_);
#line 1318 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
						_tmp48_ = _tmp47_;
#line 1318 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
						if (_inner_error_ != NULL) {
#line 1318 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
							if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 1318 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
								g_propagate_error (error, _inner_error_);
#line 1318 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
								return 0;
#line 13326 "tracker-sparql-expression.c"
							} else {
#line 1318 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
								g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1318 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
								g_clear_error (&_inner_error_);
#line 1318 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
								return 0;
#line 13334 "tracker-sparql-expression.c"
							}
						}
#line 1318 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
						if (_tmp48_) {
#line 13339 "tracker-sparql-expression.c"
							GString* _tmp49_;
							glong _tmp50_;
							guint _tmp51_;
							TrackerPropertyType _tmp52_;
							TrackerPropertyType _tmp53_ = 0;
							TrackerPropertyType _tmp54_;
#line 1319 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
							_tmp49_ = sql;
#line 1319 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
							_tmp50_ = begin;
#line 1319 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
							_tmp51_ = n_bindings;
#line 1319 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
							_tmp52_ = optype;
#line 1319 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
							_tmp53_ = tracker_sparql_expression_process_relational_expression (self, _tmp49_, _tmp50_, _tmp51_, _tmp52_, " > ", &_inner_error_);
#line 1319 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
							_tmp54_ = _tmp53_;
#line 1319 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
							if (_inner_error_ != NULL) {
#line 1319 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
								if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 1319 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
									g_propagate_error (error, _inner_error_);
#line 1319 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
									return 0;
#line 13366 "tracker-sparql-expression.c"
								} else {
#line 1319 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
									g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1319 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
									g_clear_error (&_inner_error_);
#line 1319 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
									return 0;
#line 13374 "tracker-sparql-expression.c"
								}
							}
#line 1319 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
							result = _tmp54_;
#line 1319 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
							return result;
#line 13381 "tracker-sparql-expression.c"
						} else {
							gboolean _tmp55_ = FALSE;
							gboolean _tmp56_;
#line 1320 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
							_tmp55_ = tracker_sparql_expression_accept (self, TRACKER_SPARQL_TOKEN_TYPE_OP_IN, &_inner_error_);
#line 1320 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
							_tmp56_ = _tmp55_;
#line 1320 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
							if (_inner_error_ != NULL) {
#line 1320 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
								if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 1320 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
									g_propagate_error (error, _inner_error_);
#line 1320 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
									return 0;
#line 13397 "tracker-sparql-expression.c"
								} else {
#line 1320 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
									g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1320 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
									g_clear_error (&_inner_error_);
#line 1320 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
									return 0;
#line 13405 "tracker-sparql-expression.c"
								}
							}
#line 1320 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
							if (_tmp56_) {
#line 13410 "tracker-sparql-expression.c"
								GString* _tmp57_;
								TrackerPropertyType _tmp58_ = 0;
								TrackerPropertyType _tmp59_;
#line 1321 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
								_tmp57_ = sql;
#line 1321 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
								_tmp58_ = tracker_sparql_expression_translate_in (self, _tmp57_, FALSE, &_inner_error_);
#line 1321 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
								_tmp59_ = _tmp58_;
#line 1321 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
								if (_inner_error_ != NULL) {
#line 1321 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
									if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 1321 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
										g_propagate_error (error, _inner_error_);
#line 1321 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
										return 0;
#line 13428 "tracker-sparql-expression.c"
									} else {
#line 1321 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
										g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1321 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
										g_clear_error (&_inner_error_);
#line 1321 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
										return 0;
#line 13436 "tracker-sparql-expression.c"
									}
								}
#line 1321 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
								result = _tmp59_;
#line 1321 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
								return result;
#line 13443 "tracker-sparql-expression.c"
							} else {
								gboolean _tmp60_ = FALSE;
								gboolean _tmp61_;
#line 1322 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
								_tmp60_ = tracker_sparql_expression_accept (self, TRACKER_SPARQL_TOKEN_TYPE_NOT, &_inner_error_);
#line 1322 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
								_tmp61_ = _tmp60_;
#line 1322 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
								if (_inner_error_ != NULL) {
#line 1322 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
									if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 1322 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
										g_propagate_error (error, _inner_error_);
#line 1322 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
										return 0;
#line 13459 "tracker-sparql-expression.c"
									} else {
#line 1322 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
										g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1322 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
										g_clear_error (&_inner_error_);
#line 1322 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
										return 0;
#line 13467 "tracker-sparql-expression.c"
									}
								}
#line 1322 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
								if (_tmp61_) {
#line 13472 "tracker-sparql-expression.c"
									GString* _tmp62_;
									TrackerPropertyType _tmp63_ = 0;
									TrackerPropertyType _tmp64_;
#line 1323 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
									tracker_sparql_expression_expect (self, TRACKER_SPARQL_TOKEN_TYPE_OP_IN, &_inner_error_);
#line 1323 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
									if (_inner_error_ != NULL) {
#line 1323 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
										if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 1323 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
											g_propagate_error (error, _inner_error_);
#line 1323 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
											return 0;
#line 13486 "tracker-sparql-expression.c"
										} else {
#line 1323 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
											g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1323 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
											g_clear_error (&_inner_error_);
#line 1323 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
											return 0;
#line 13494 "tracker-sparql-expression.c"
										}
									}
#line 1324 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
									_tmp62_ = sql;
#line 1324 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
									_tmp63_ = tracker_sparql_expression_translate_in (self, _tmp62_, TRUE, &_inner_error_);
#line 1324 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
									_tmp64_ = _tmp63_;
#line 1324 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
									if (_inner_error_ != NULL) {
#line 1324 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
										if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 1324 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
											g_propagate_error (error, _inner_error_);
#line 1324 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
											return 0;
#line 13511 "tracker-sparql-expression.c"
										} else {
#line 1324 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
											g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1324 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
											g_clear_error (&_inner_error_);
#line 1324 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
											return 0;
#line 13519 "tracker-sparql-expression.c"
										}
									}
#line 1324 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
									result = _tmp64_;
#line 1324 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
									return result;
#line 13526 "tracker-sparql-expression.c"
								}
							}
						}
					}
				}
			}
		}
	}
#line 1326 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	result = optype;
#line 1326 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	return result;
#line 13539 "tracker-sparql-expression.c"
}


static TrackerPropertyType tracker_sparql_expression_translate_value_logical (TrackerSparqlExpression* self, GString* sql, GError** error) {
	TrackerPropertyType result = 0;
	GString* _tmp0_;
	TrackerPropertyType _tmp1_ = 0;
	TrackerPropertyType _tmp2_;
	GError * _inner_error_ = NULL;
#line 1329 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	g_return_val_if_fail (self != NULL, 0);
#line 1329 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	g_return_val_if_fail (sql != NULL, 0);
#line 1330 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	_tmp0_ = sql;
#line 1330 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	_tmp1_ = tracker_sparql_expression_translate_relational_expression (self, _tmp0_, &_inner_error_);
#line 1330 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	_tmp2_ = _tmp1_;
#line 1330 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	if (_inner_error_ != NULL) {
#line 1330 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 1330 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			g_propagate_error (error, _inner_error_);
#line 1330 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			return 0;
#line 13567 "tracker-sparql-expression.c"
		} else {
#line 1330 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1330 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			g_clear_error (&_inner_error_);
#line 1330 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			return 0;
#line 13575 "tracker-sparql-expression.c"
		}
	}
#line 1330 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	result = _tmp2_;
#line 1330 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	return result;
#line 13582 "tracker-sparql-expression.c"
}


static TrackerPropertyType tracker_sparql_expression_translate_conditional_and_expression (TrackerSparqlExpression* self, GString* sql, GError** error) {
	TrackerPropertyType result = 0;
	GString* _tmp0_;
	gssize _tmp1_;
	glong begin;
	GString* _tmp2_;
	TrackerPropertyType _tmp3_ = 0;
	TrackerPropertyType optype;
	GError * _inner_error_ = NULL;
#line 1333 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	g_return_val_if_fail (self != NULL, 0);
#line 1333 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	g_return_val_if_fail (sql != NULL, 0);
#line 1334 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	_tmp0_ = sql;
#line 1334 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	_tmp1_ = _tmp0_->len;
#line 1334 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	begin = (glong) _tmp1_;
#line 1335 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	_tmp2_ = sql;
#line 1335 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	_tmp3_ = tracker_sparql_expression_translate_value_logical (self, _tmp2_, &_inner_error_);
#line 1335 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	optype = _tmp3_;
#line 1335 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	if (_inner_error_ != NULL) {
#line 1335 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 1335 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			g_propagate_error (error, _inner_error_);
#line 1335 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			return 0;
#line 13619 "tracker-sparql-expression.c"
		} else {
#line 1335 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1335 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			g_clear_error (&_inner_error_);
#line 1335 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			return 0;
#line 13627 "tracker-sparql-expression.c"
		}
	}
#line 1336 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	while (TRUE) {
#line 13632 "tracker-sparql-expression.c"
		gboolean _tmp4_ = FALSE;
		gboolean _tmp5_;
		TrackerPropertyType _tmp6_;
		GString* _tmp8_;
		glong _tmp9_;
		GString* _tmp10_;
		GString* _tmp11_;
		TrackerPropertyType _tmp12_ = 0;
		TrackerPropertyType _tmp13_;
		GString* _tmp14_;
		TrackerPropertyType _tmp15_;
#line 1336 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		_tmp4_ = tracker_sparql_expression_accept (self, TRACKER_SPARQL_TOKEN_TYPE_OP_AND, &_inner_error_);
#line 1336 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		_tmp5_ = _tmp4_;
#line 1336 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		if (_inner_error_ != NULL) {
#line 1336 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 1336 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				g_propagate_error (error, _inner_error_);
#line 1336 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				return 0;
#line 13656 "tracker-sparql-expression.c"
			} else {
#line 1336 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1336 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				g_clear_error (&_inner_error_);
#line 1336 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				return 0;
#line 13664 "tracker-sparql-expression.c"
			}
		}
#line 1336 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		if (!_tmp5_) {
#line 1336 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			break;
#line 13671 "tracker-sparql-expression.c"
		}
#line 1337 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		_tmp6_ = optype;
#line 1337 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		if (_tmp6_ != TRACKER_PROPERTY_TYPE_BOOLEAN) {
#line 13677 "tracker-sparql-expression.c"
			GError* _tmp7_ = NULL;
#line 1338 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp7_ = tracker_sparql_expression_get_error (self, "expected boolean expression");
#line 1338 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_inner_error_ = _tmp7_;
#line 1338 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 1338 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				g_propagate_error (error, _inner_error_);
#line 1338 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				return 0;
#line 13689 "tracker-sparql-expression.c"
			} else {
#line 1338 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1338 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				g_clear_error (&_inner_error_);
#line 1338 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				return 0;
#line 13697 "tracker-sparql-expression.c"
			}
		}
#line 1340 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		_tmp8_ = sql;
#line 1340 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		_tmp9_ = begin;
#line 1340 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		g_string_insert (_tmp8_, (gssize) _tmp9_, "(");
#line 1341 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		_tmp10_ = sql;
#line 1341 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		g_string_append (_tmp10_, " AND ");
#line 1342 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		_tmp11_ = sql;
#line 1342 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		_tmp12_ = tracker_sparql_expression_translate_value_logical (self, _tmp11_, &_inner_error_);
#line 1342 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		_tmp13_ = _tmp12_;
#line 1342 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		if (_inner_error_ != NULL) {
#line 1342 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 1342 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				g_propagate_error (error, _inner_error_);
#line 1342 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				return 0;
#line 13724 "tracker-sparql-expression.c"
			} else {
#line 1342 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1342 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				g_clear_error (&_inner_error_);
#line 1342 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				return 0;
#line 13732 "tracker-sparql-expression.c"
			}
		}
#line 1342 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		optype = _tmp13_;
#line 1343 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		_tmp14_ = sql;
#line 1343 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		g_string_append (_tmp14_, ")");
#line 1344 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		_tmp15_ = optype;
#line 1344 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		if (_tmp15_ != TRACKER_PROPERTY_TYPE_BOOLEAN) {
#line 13745 "tracker-sparql-expression.c"
			GError* _tmp16_ = NULL;
#line 1345 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp16_ = tracker_sparql_expression_get_error (self, "expected boolean expression");
#line 1345 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_inner_error_ = _tmp16_;
#line 1345 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 1345 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				g_propagate_error (error, _inner_error_);
#line 1345 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				return 0;
#line 13757 "tracker-sparql-expression.c"
			} else {
#line 1345 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1345 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				g_clear_error (&_inner_error_);
#line 1345 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				return 0;
#line 13765 "tracker-sparql-expression.c"
			}
		}
	}
#line 1348 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	result = optype;
#line 1348 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	return result;
#line 13773 "tracker-sparql-expression.c"
}


static TrackerPropertyType tracker_sparql_expression_translate_conditional_or_expression (TrackerSparqlExpression* self, GString* sql, GError** error) {
	TrackerPropertyType result = 0;
	GString* _tmp0_;
	gssize _tmp1_;
	glong begin;
	GString* _tmp2_;
	TrackerPropertyType _tmp3_ = 0;
	TrackerPropertyType optype;
	GError * _inner_error_ = NULL;
#line 1351 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	g_return_val_if_fail (self != NULL, 0);
#line 1351 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	g_return_val_if_fail (sql != NULL, 0);
#line 1352 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	_tmp0_ = sql;
#line 1352 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	_tmp1_ = _tmp0_->len;
#line 1352 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	begin = (glong) _tmp1_;
#line 1353 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	_tmp2_ = sql;
#line 1353 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	_tmp3_ = tracker_sparql_expression_translate_conditional_and_expression (self, _tmp2_, &_inner_error_);
#line 1353 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	optype = _tmp3_;
#line 1353 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	if (_inner_error_ != NULL) {
#line 1353 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 1353 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			g_propagate_error (error, _inner_error_);
#line 1353 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			return 0;
#line 13810 "tracker-sparql-expression.c"
		} else {
#line 1353 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1353 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			g_clear_error (&_inner_error_);
#line 1353 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			return 0;
#line 13818 "tracker-sparql-expression.c"
		}
	}
#line 1354 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	while (TRUE) {
#line 13823 "tracker-sparql-expression.c"
		gboolean _tmp4_ = FALSE;
		gboolean _tmp5_;
		TrackerPropertyType _tmp6_;
		GString* _tmp8_;
		glong _tmp9_;
		GString* _tmp10_;
		GString* _tmp11_;
		TrackerPropertyType _tmp12_ = 0;
		TrackerPropertyType _tmp13_;
		GString* _tmp14_;
		TrackerPropertyType _tmp15_;
#line 1354 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		_tmp4_ = tracker_sparql_expression_accept (self, TRACKER_SPARQL_TOKEN_TYPE_OP_OR, &_inner_error_);
#line 1354 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		_tmp5_ = _tmp4_;
#line 1354 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		if (_inner_error_ != NULL) {
#line 1354 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 1354 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				g_propagate_error (error, _inner_error_);
#line 1354 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				return 0;
#line 13847 "tracker-sparql-expression.c"
			} else {
#line 1354 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1354 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				g_clear_error (&_inner_error_);
#line 1354 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				return 0;
#line 13855 "tracker-sparql-expression.c"
			}
		}
#line 1354 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		if (!_tmp5_) {
#line 1354 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			break;
#line 13862 "tracker-sparql-expression.c"
		}
#line 1355 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		_tmp6_ = optype;
#line 1355 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		if (_tmp6_ != TRACKER_PROPERTY_TYPE_BOOLEAN) {
#line 13868 "tracker-sparql-expression.c"
			GError* _tmp7_ = NULL;
#line 1356 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp7_ = tracker_sparql_expression_get_error (self, "expected boolean expression");
#line 1356 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_inner_error_ = _tmp7_;
#line 1356 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 1356 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				g_propagate_error (error, _inner_error_);
#line 1356 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				return 0;
#line 13880 "tracker-sparql-expression.c"
			} else {
#line 1356 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1356 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				g_clear_error (&_inner_error_);
#line 1356 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				return 0;
#line 13888 "tracker-sparql-expression.c"
			}
		}
#line 1358 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		_tmp8_ = sql;
#line 1358 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		_tmp9_ = begin;
#line 1358 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		g_string_insert (_tmp8_, (gssize) _tmp9_, "(");
#line 1359 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		_tmp10_ = sql;
#line 1359 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		g_string_append (_tmp10_, " OR ");
#line 1360 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		_tmp11_ = sql;
#line 1360 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		_tmp12_ = tracker_sparql_expression_translate_conditional_and_expression (self, _tmp11_, &_inner_error_);
#line 1360 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		_tmp13_ = _tmp12_;
#line 1360 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		if (_inner_error_ != NULL) {
#line 1360 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 1360 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				g_propagate_error (error, _inner_error_);
#line 1360 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				return 0;
#line 13915 "tracker-sparql-expression.c"
			} else {
#line 1360 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1360 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				g_clear_error (&_inner_error_);
#line 1360 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				return 0;
#line 13923 "tracker-sparql-expression.c"
			}
		}
#line 1360 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		optype = _tmp13_;
#line 1361 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		_tmp14_ = sql;
#line 1361 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		g_string_append (_tmp14_, ")");
#line 1362 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		_tmp15_ = optype;
#line 1362 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		if (_tmp15_ != TRACKER_PROPERTY_TYPE_BOOLEAN) {
#line 13936 "tracker-sparql-expression.c"
			GError* _tmp16_ = NULL;
#line 1363 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp16_ = tracker_sparql_expression_get_error (self, "expected boolean expression");
#line 1363 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_inner_error_ = _tmp16_;
#line 1363 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 1363 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				g_propagate_error (error, _inner_error_);
#line 1363 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				return 0;
#line 13948 "tracker-sparql-expression.c"
			} else {
#line 1363 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1363 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				g_clear_error (&_inner_error_);
#line 1363 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				return 0;
#line 13956 "tracker-sparql-expression.c"
			}
		}
	}
#line 1366 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	result = optype;
#line 1366 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	return result;
#line 13964 "tracker-sparql-expression.c"
}


TrackerPropertyType tracker_sparql_expression_translate_expression (TrackerSparqlExpression* self, GString* sql, GError** error) {
	TrackerPropertyType result = 0;
	GString* _tmp0_;
	TrackerPropertyType _tmp1_ = 0;
	TrackerPropertyType _tmp2_;
	GError * _inner_error_ = NULL;
#line 1369 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	g_return_val_if_fail (self != NULL, 0);
#line 1369 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	g_return_val_if_fail (sql != NULL, 0);
#line 1370 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	_tmp0_ = sql;
#line 1370 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	_tmp1_ = tracker_sparql_expression_translate_conditional_or_expression (self, _tmp0_, &_inner_error_);
#line 1370 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	_tmp2_ = _tmp1_;
#line 1370 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	if (_inner_error_ != NULL) {
#line 1370 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 1370 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			g_propagate_error (error, _inner_error_);
#line 1370 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			return 0;
#line 13992 "tracker-sparql-expression.c"
		} else {
#line 1370 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1370 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			g_clear_error (&_inner_error_);
#line 1370 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			return 0;
#line 14000 "tracker-sparql-expression.c"
		}
	}
#line 1370 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	result = _tmp2_;
#line 1370 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	return result;
#line 14007 "tracker-sparql-expression.c"
}


static TrackerPropertyType tracker_sparql_expression_translate_bracketted_expression (TrackerSparqlExpression* self, GString* sql, GError** error) {
	TrackerPropertyType result = 0;
	TrackerSparqlTokenType _tmp0_ = 0;
	GString* _tmp9_;
	TrackerPropertyType _tmp10_ = 0;
	TrackerPropertyType optype;
	GError * _inner_error_ = NULL;
#line 1373 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	g_return_val_if_fail (self != NULL, 0);
#line 1373 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	g_return_val_if_fail (sql != NULL, 0);
#line 1374 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	tracker_sparql_expression_expect (self, TRACKER_SPARQL_TOKEN_TYPE_OPEN_PARENS, &_inner_error_);
#line 1374 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	if (_inner_error_ != NULL) {
#line 1374 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 1374 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			g_propagate_error (error, _inner_error_);
#line 1374 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			return 0;
#line 14032 "tracker-sparql-expression.c"
		} else {
#line 1374 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1374 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			g_clear_error (&_inner_error_);
#line 1374 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			return 0;
#line 14040 "tracker-sparql-expression.c"
		}
	}
#line 1376 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	_tmp0_ = tracker_sparql_expression_current (self);
#line 1376 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	if (_tmp0_ == TRACKER_SPARQL_TOKEN_TYPE_SELECT) {
#line 14047 "tracker-sparql-expression.c"
		GString* _tmp1_;
		TrackerSparqlPattern* _tmp2_;
		TrackerSparqlPattern* _tmp3_;
		GString* _tmp4_;
		TrackerSparqlSelectContext* _tmp5_ = NULL;
		TrackerSparqlSelectContext* select_context;
		GString* _tmp6_;
		TrackerSparqlSelectContext* _tmp7_;
		TrackerPropertyType _tmp8_;
#line 1379 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		_tmp1_ = sql;
#line 1379 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		g_string_append (_tmp1_, "(");
#line 1380 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		_tmp2_ = tracker_sparql_expression_get_pattern (self);
#line 1380 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		_tmp3_ = _tmp2_;
#line 1380 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		_tmp4_ = sql;
#line 1380 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		_tmp5_ = tracker_sparql_pattern_translate_select (_tmp3_, _tmp4_, TRUE, TRUE, &_inner_error_);
#line 1380 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		select_context = _tmp5_;
#line 1380 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		if (_inner_error_ != NULL) {
#line 1380 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 1380 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				g_propagate_error (error, _inner_error_);
#line 1380 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				return 0;
#line 14079 "tracker-sparql-expression.c"
			} else {
#line 1380 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1380 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				g_clear_error (&_inner_error_);
#line 1380 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				return 0;
#line 14087 "tracker-sparql-expression.c"
			}
		}
#line 1381 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		_tmp6_ = sql;
#line 1381 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		g_string_append (_tmp6_, ")");
#line 1383 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		tracker_sparql_expression_expect (self, TRACKER_SPARQL_TOKEN_TYPE_CLOSE_PARENS, &_inner_error_);
#line 1383 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		if (_inner_error_ != NULL) {
#line 1383 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 1383 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				g_propagate_error (error, _inner_error_);
#line 1383 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				_tracker_sparql_context_unref0 (select_context);
#line 1383 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				return 0;
#line 14106 "tracker-sparql-expression.c"
			} else {
#line 1383 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				_tracker_sparql_context_unref0 (select_context);
#line 1383 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1383 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				g_clear_error (&_inner_error_);
#line 1383 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				return 0;
#line 14116 "tracker-sparql-expression.c"
			}
		}
#line 1384 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		_tmp7_ = select_context;
#line 1384 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		_tmp8_ = _tmp7_->type;
#line 1384 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		result = _tmp8_;
#line 1384 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		_tracker_sparql_context_unref0 (select_context);
#line 1384 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		return result;
#line 14129 "tracker-sparql-expression.c"
	}
#line 1387 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	_tmp9_ = sql;
#line 1387 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	_tmp10_ = tracker_sparql_expression_translate_expression (self, _tmp9_, &_inner_error_);
#line 1387 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	optype = _tmp10_;
#line 1387 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	if (_inner_error_ != NULL) {
#line 1387 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 1387 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			g_propagate_error (error, _inner_error_);
#line 1387 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			return 0;
#line 14145 "tracker-sparql-expression.c"
		} else {
#line 1387 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1387 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			g_clear_error (&_inner_error_);
#line 1387 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			return 0;
#line 14153 "tracker-sparql-expression.c"
		}
	}
#line 1388 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	tracker_sparql_expression_expect (self, TRACKER_SPARQL_TOKEN_TYPE_CLOSE_PARENS, &_inner_error_);
#line 1388 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	if (_inner_error_ != NULL) {
#line 1388 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 1388 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			g_propagate_error (error, _inner_error_);
#line 1388 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			return 0;
#line 14166 "tracker-sparql-expression.c"
		} else {
#line 1388 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1388 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			g_clear_error (&_inner_error_);
#line 1388 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			return 0;
#line 14174 "tracker-sparql-expression.c"
		}
	}
#line 1389 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	result = optype;
#line 1389 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	return result;
#line 14181 "tracker-sparql-expression.c"
}


static TrackerPropertyType tracker_sparql_expression_translate_aggregate_expression (TrackerSparqlExpression* self, GString* sql, GError** error) {
	TrackerPropertyType result = 0;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_;
	GString* _tmp3_;
	TrackerPropertyType _tmp4_ = 0;
	TrackerPropertyType optype;
	GError * _inner_error_ = NULL;
#line 1392 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	g_return_val_if_fail (self != NULL, 0);
#line 1392 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	g_return_val_if_fail (sql != NULL, 0);
#line 1393 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	tracker_sparql_expression_expect (self, TRACKER_SPARQL_TOKEN_TYPE_OPEN_PARENS, &_inner_error_);
#line 1393 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	if (_inner_error_ != NULL) {
#line 1393 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 1393 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			g_propagate_error (error, _inner_error_);
#line 1393 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			return 0;
#line 14207 "tracker-sparql-expression.c"
		} else {
#line 1393 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1393 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			g_clear_error (&_inner_error_);
#line 1393 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			return 0;
#line 14215 "tracker-sparql-expression.c"
		}
	}
#line 1394 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	_tmp0_ = tracker_sparql_expression_accept (self, TRACKER_SPARQL_TOKEN_TYPE_DISTINCT, &_inner_error_);
#line 1394 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	_tmp1_ = _tmp0_;
#line 1394 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	if (_inner_error_ != NULL) {
#line 1394 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 1394 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			g_propagate_error (error, _inner_error_);
#line 1394 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			return 0;
#line 14230 "tracker-sparql-expression.c"
		} else {
#line 1394 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1394 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			g_clear_error (&_inner_error_);
#line 1394 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			return 0;
#line 14238 "tracker-sparql-expression.c"
		}
	}
#line 1394 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	if (_tmp1_) {
#line 14243 "tracker-sparql-expression.c"
		GString* _tmp2_;
#line 1395 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		_tmp2_ = sql;
#line 1395 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		g_string_append (_tmp2_, "DISTINCT ");
#line 14249 "tracker-sparql-expression.c"
	}
#line 1397 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	_tmp3_ = sql;
#line 1397 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	_tmp4_ = tracker_sparql_expression_translate_expression (self, _tmp3_, &_inner_error_);
#line 1397 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	optype = _tmp4_;
#line 1397 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	if (_inner_error_ != NULL) {
#line 1397 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 1397 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			g_propagate_error (error, _inner_error_);
#line 1397 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			return 0;
#line 14265 "tracker-sparql-expression.c"
		} else {
#line 1397 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1397 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			g_clear_error (&_inner_error_);
#line 1397 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			return 0;
#line 14273 "tracker-sparql-expression.c"
		}
	}
#line 1398 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	tracker_sparql_expression_expect (self, TRACKER_SPARQL_TOKEN_TYPE_CLOSE_PARENS, &_inner_error_);
#line 1398 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	if (_inner_error_ != NULL) {
#line 1398 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 1398 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			g_propagate_error (error, _inner_error_);
#line 1398 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			return 0;
#line 14286 "tracker-sparql-expression.c"
		} else {
#line 1398 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1398 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			g_clear_error (&_inner_error_);
#line 1398 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			return 0;
#line 14294 "tracker-sparql-expression.c"
		}
	}
#line 1399 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	result = optype;
#line 1399 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	return result;
#line 14301 "tracker-sparql-expression.c"
}


TrackerPropertyType tracker_sparql_expression_translate_constraint (TrackerSparqlExpression* self, GString* sql, GError** error) {
	TrackerPropertyType result = 0;
	TrackerSparqlTokenType _tmp0_ = 0;
	GError * _inner_error_ = NULL;
#line 1402 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	g_return_val_if_fail (self != NULL, 0);
#line 1402 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	g_return_val_if_fail (sql != NULL, 0);
#line 1403 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	_tmp0_ = tracker_sparql_expression_current (self);
#line 1403 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	switch (_tmp0_) {
#line 1403 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		case TRACKER_SPARQL_TOKEN_TYPE_STR:
#line 1403 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		case TRACKER_SPARQL_TOKEN_TYPE_LANG:
#line 1403 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		case TRACKER_SPARQL_TOKEN_TYPE_LANGMATCHES:
#line 1403 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		case TRACKER_SPARQL_TOKEN_TYPE_DATATYPE:
#line 1403 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		case TRACKER_SPARQL_TOKEN_TYPE_BOUND:
#line 1403 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		case TRACKER_SPARQL_TOKEN_TYPE_IF:
#line 1403 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		case TRACKER_SPARQL_TOKEN_TYPE_SAMETERM:
#line 1403 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		case TRACKER_SPARQL_TOKEN_TYPE_ISIRI:
#line 1403 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		case TRACKER_SPARQL_TOKEN_TYPE_ISURI:
#line 1403 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		case TRACKER_SPARQL_TOKEN_TYPE_ISBLANK:
#line 1403 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		case TRACKER_SPARQL_TOKEN_TYPE_ISLITERAL:
#line 1403 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		case TRACKER_SPARQL_TOKEN_TYPE_REGEX:
#line 1403 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		case TRACKER_SPARQL_TOKEN_TYPE_EXISTS:
#line 1403 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		case TRACKER_SPARQL_TOKEN_TYPE_NOT:
#line 14345 "tracker-sparql-expression.c"
		{
			GString* _tmp1_;
			TrackerPropertyType _tmp2_ = 0;
			TrackerPropertyType _tmp3_;
#line 1418 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp1_ = sql;
#line 1418 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp2_ = tracker_sparql_expression_translate_primary_expression (self, _tmp1_, &_inner_error_);
#line 1418 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp3_ = _tmp2_;
#line 1418 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			if (_inner_error_ != NULL) {
#line 1418 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 1418 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_propagate_error (error, _inner_error_);
#line 1418 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					return 0;
#line 14364 "tracker-sparql-expression.c"
				} else {
#line 1418 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1418 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_clear_error (&_inner_error_);
#line 1418 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					return 0;
#line 14372 "tracker-sparql-expression.c"
				}
			}
#line 1418 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			result = _tmp3_;
#line 1418 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			return result;
#line 14379 "tracker-sparql-expression.c"
		}
		default:
		{
			GString* _tmp4_;
			TrackerPropertyType _tmp5_ = 0;
			TrackerPropertyType _tmp6_;
#line 1420 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp4_ = sql;
#line 1420 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp5_ = tracker_sparql_expression_translate_bracketted_expression (self, _tmp4_, &_inner_error_);
#line 1420 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp6_ = _tmp5_;
#line 1420 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			if (_inner_error_ != NULL) {
#line 1420 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 1420 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_propagate_error (error, _inner_error_);
#line 1420 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					return 0;
#line 14400 "tracker-sparql-expression.c"
				} else {
#line 1420 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1420 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_clear_error (&_inner_error_);
#line 1420 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					return 0;
#line 14408 "tracker-sparql-expression.c"
				}
			}
#line 1420 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			result = _tmp6_;
#line 1420 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			return result;
#line 14415 "tracker-sparql-expression.c"
		}
	}
}


static TrackerSparqlContext* tracker_sparql_expression_get_context (TrackerSparqlExpression* self) {
	TrackerSparqlContext* result;
	TrackerSparqlQuery* _tmp0_;
	TrackerSparqlContext* _tmp1_;
#line 34 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 34 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	_tmp0_ = self->priv->query;
#line 34 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	_tmp1_ = _tmp0_->context;
#line 34 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	result = _tmp1_;
#line 34 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	return result;
#line 14435 "tracker-sparql-expression.c"
}


static TrackerSparqlPattern* tracker_sparql_expression_get_pattern (TrackerSparqlExpression* self) {
	TrackerSparqlPattern* result;
	TrackerSparqlQuery* _tmp0_;
	TrackerSparqlPattern* _tmp1_;
#line 38 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 38 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	_tmp0_ = self->priv->query;
#line 38 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	_tmp1_ = _tmp0_->pattern;
#line 38 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	result = _tmp1_;
#line 38 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	return result;
#line 14453 "tracker-sparql-expression.c"
}


static void tracker_sparql_expression_class_init (TrackerSparqlExpressionClass * klass) {
#line 20 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	tracker_sparql_expression_parent_class = g_type_class_peek_parent (klass);
#line 20 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	g_type_class_add_private (klass, sizeof (TrackerSparqlExpressionPrivate));
#line 20 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	G_OBJECT_CLASS (klass)->get_property = _vala_tracker_sparql_expression_get_property;
#line 20 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	G_OBJECT_CLASS (klass)->finalize = tracker_sparql_expression_finalize;
#line 14466 "tracker-sparql-expression.c"
}


static void tracker_sparql_expression_instance_init (TrackerSparqlExpression * self) {
#line 20 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	self->priv = TRACKER_SPARQL_EXPRESSION_GET_PRIVATE (self);
#line 14473 "tracker-sparql-expression.c"
}


static void tracker_sparql_expression_finalize (GObject* obj) {
	TrackerSparqlExpression * self;
#line 20 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	self = TRACKER_SPARQL_EXPRESSION (obj);
#line 20 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	G_OBJECT_CLASS (tracker_sparql_expression_parent_class)->finalize (obj);
#line 14483 "tracker-sparql-expression.c"
}


GType tracker_sparql_expression_get_type (void) {
	static volatile gsize tracker_sparql_expression_type_id__volatile = 0;
	if (g_once_init_enter (&tracker_sparql_expression_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (TrackerSparqlExpressionClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) tracker_sparql_expression_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (TrackerSparqlExpression), 0, (GInstanceInitFunc) tracker_sparql_expression_instance_init, NULL };
		GType tracker_sparql_expression_type_id;
		tracker_sparql_expression_type_id = g_type_register_static (G_TYPE_OBJECT, "TrackerSparqlExpression", &g_define_type_info, 0);
		g_once_init_leave (&tracker_sparql_expression_type_id__volatile, tracker_sparql_expression_type_id);
	}
	return tracker_sparql_expression_type_id__volatile;
}


static void _vala_tracker_sparql_expression_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	TrackerSparqlExpression * self;
	self = TRACKER_SPARQL_EXPRESSION (object);
#line 20 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	switch (property_id) {
#line 14504 "tracker-sparql-expression.c"
		default:
#line 20 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 20 "/home/martyn/Source/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		break;
#line 14510 "tracker-sparql-expression.c"
	}
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}


static gint _vala_array_length (gpointer array) {
	int length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}



