#include "languagemodel.h"

#include <KIcon>
#include <KLocale>
#include <KStandardDirs>
LanguageModel::LanguageModel(QObject * parent)
        : QStandardItemModel(parent)
{

    setupLanguageMap();
    setColumnCount (2);

    setHeaderData(0, Qt::Horizontal,i18n("code"));
    setHeaderData(1, Qt::Horizontal,i18n("contry"));

    QMapIterator<QString, Language> i(m_languageMap);
    while (i.hasNext()) {
        i.next();
//         m_listWidget->addItem(new QListWidgetItem(KIcon(i.value().icon), i.value().name));

        QStandardItem * item = new QStandardItem(i.value().code);
        item->setIcon ( KIcon(i.value().icon) );
        item->setEditable ( false );
        appendRow (item );

        QStandardItem * itemName= new QStandardItem(i.value().name);

        setItem (item->row(),1, itemName);

    }
}
//=============================================================
QString LanguageModel::getCode(const QModelIndex& index)
{
    QStandardItem * item = itemFromIndex (index );
    return m_languageMap[item->text()].code;
}

//=============================================================
QString LanguageModel::getName(const QModelIndex& index)
{
    QStandardItem * item = itemFromIndex (index );
    return m_languageMap[item->text()].name;
}
//=============================================================

QString LanguageModel::getIcon(const QModelIndex& index)
{
    QStandardItem * item = itemFromIndex (index );
    return m_languageMap[item->text()].icon;
}
//=============================================================
Language LanguageModel::getLanguage(const QModelIndex& index)
{
    QStandardItem * item = itemFromIndex (index );
    return m_languageMap[item->text()];
}
//=============================================================
Language LanguageModel::getLanguageFromCode(QString code)
{

    return m_languageMap[code];

}
//============================================================
void LanguageModel::setupLanguageMap()
{
    Language c;

    c.code = "auto";
    c.icon = KStandardDirs::locate("icon", "oxygen/16x16/actions/help-hint.png");
    c.name = i18n("autodetect");
    m_languageMap[c.code] = (c);

    c.code = "de";
    c.icon = "kbflags/de.png";
    c.name = i18n("german");
    m_languageMap[c.code] = (c);

    c.code = "en";
    c.icon = "kbflags/gb.png";
    c.name = i18n("english");
    m_languageMap[c.code] = (c);

    c.code = "ar";
    c.icon = "kbflags/ae.png";
    c.name = i18n("arabic");
    m_languageMap[c.code] = (c);

    c.code = "bg";
    c.icon = "kbflags/bg.png";
    c.name = i18n("bulgarian");
    m_languageMap[c.code] = (c);

    c.code = "ca";
    c.icon = "kbflags/ct.png";
    c.name = i18n("catalan");
    m_languageMap[c.code] = (c);

    c.code = "zh-CN";
    c.icon = "kbflags/cn.png";
    c.name = i18n("chinese");
    m_languageMap[c.code] = (c);

    c.code = "ko";
    c.icon = "kbflags/kr.png";
    c.name = i18n("korean");
    m_languageMap[c.code] = (c);

    c.code = "hr";
    c.icon = "kbflags/hr.png";
    c.name = i18n("croatian");
    m_languageMap[c.code] = (c);

    c.code = "da";
    c.icon = "kbflags/dk.png";
    c.name = i18n("danish");
    m_languageMap[c.code] = (c);

    c.code = "es";
    c.icon = "kbflags/es.png";
    c.name = i18n("spanish");
    m_languageMap[c.code] = (c);

    c.code = "fi";
    c.icon = "kbflags/fi.png";
    c.name = i18n("finnish");
    m_languageMap[c.code] = (c);

    c.code = "fr";
    c.icon = "kbflags/fr.png";
    c.name = i18n("french");
    m_languageMap[c.code] = (c);

    c.code = "el";
    c.icon = "kbflags/gr.png";
    c.name = i18n("greek");
    m_languageMap[c.code] = (c);

    c.code = "iw";
    c.icon = "kbflags/il.png";
    c.name = i18n("hebrew");
    m_languageMap[c.code] = (c);

    c.code = "hi";
    c.icon = "kbflags/in.png";
    c.name = i18n("hindi");
    m_languageMap[c.code] = (c);

    c.code = "id";
    c.icon = "kbflags/id.png";
    c.name = i18n("indonesian");
    m_languageMap[c.code] = (c);

    c.code = "it";
    c.icon = "kbflags/it.png";
    c.name = i18n("italian");
    m_languageMap[c.code] = (c);

    c.code = "ja";
    c.icon = "kbflags/jp.png";
    c.name = i18n("japanese");
    m_languageMap[c.code] = (c);

    c.code = "lv";
    c.icon = "kbflags/lv.png";
    c.name = i18n("latvian");
    m_languageMap[c.code] = (c);

    c.code = "lt";
    c.icon = "kbflags/lt.png";
    c.name = i18n("lithuanian");
    m_languageMap[c.code] = (c);

    c.code = "nl";
    c.icon = "kbflags/nl.png";
    c.name = i18n("dutch");
    m_languageMap[c.code] = (c);

    c.code = "no";
    c.icon = "kbflags/no.png";
    c.name = i18n("norwegian");
    m_languageMap[c.code] = (c);

    c.code = "pl";
    c.icon = "kbflags/pl.png";
    c.name = i18n("polish");
    m_languageMap[c.code] = (c);


    c.code = "pt";
    c.icon = "kbflags/pt.png";
    c.name = i18n("portuguese");
    m_languageMap[c.code] = (c);

    c.code = "ro";
    c.icon = "kbflags/ro.png";
    c.name = i18n("romanian");
    m_languageMap[c.code] = (c);

    c.code = "ru";
    c.icon = "kbflags/ru.png";
    c.name = i18n("russian");
    m_languageMap[c.code] = (c);

    c.code = "sr";
    c.icon = "kbflags/sr.png";
    c.name = i18n("serbian");
    m_languageMap[c.code] = (c);

    c.code = "sk";
    c.icon = "kbflags/sk.png";
    c.name = i18n("slovak");
    m_languageMap[c.code] = (c);


    c.code = "sl";
    c.icon = "kbflags/si.png";
    c.name = i18n("slovenian");
    m_languageMap[c.code] = (c);

    c.code = "sv";
    c.icon = "kbflags/sv.png";
    c.name = i18n("swedish");
    m_languageMap[c.code] = (c);

    c.code = "tl";
    c.icon = "kbflags/ph.png";
    c.name = i18n("tagalog");
    m_languageMap[c.code] = (c);


    c.code = "cs";
    c.icon = "kbflags/cz.png";
    c.name = i18n("czech");
    m_languageMap[c.code] = (c);

    c.code = "uk";
    c.icon = "kbflags/ua.png";
    c.name = i18n("ukrainian");
    m_languageMap[c.code] = (c);

    c.code = "vi";
    c.icon = "kbflags/vi.png";
    c.name = i18n("vietnamese");
    m_languageMap[c.code] = (c);







}
