/*****************************************************************************
    TRAVIS - Trajectory Analyzer and Visualizer
    Copyright (C) 2009-2012 Martin Brehm

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
*****************************************************************************/

#ifndef VOROANALYSIS_H
#define VOROANALYSIS_H

#include "xobject.h"
#include "xobarray.h"
#include "xvector3.h"
#include "xintarray.h"
#include "voro++.h"
#include "timestep.h"
#include "df.h"
#include "moltools.h"

class CDelaunayPoint : public CxObject
{
public:
	CDelaunayPoint();
	~CDelaunayPoint();

	CxVector3 m_vPos;
	float m_fRadius;
};


class CVoroPoint : public CxObject
{
public:
	CVoroPoint();
	~CVoroPoint();

	int m_iID;
	CxVector3 m_vPos;
	CxIntArray m_iaVoroCells;
};


/*class CVoroFace : public CxObject
{
public:
	CVoroFace();
	~CVoroFace();

	int m_iID;
	int m_iPointID[3];
	int m_iTetrahedronID[2];
};*/


class CVoroCell : public CxObject
{
public:
	CVoroCell();
	~CVoroCell();

	int m_iAtomIndex;
	CxIntArray m_iaVoroPoints;
	CxIntArray m_iaNeighborCells;
	CxVector3 m_vPos;
	int m_iFaceID[4];
};


class CDelaunayTetrahedron : public CxObject
{
public:
	CDelaunayTetrahedron();
	~CDelaunayTetrahedron();

	double m_fRadius;
	CxVector3 m_vCenter;
	int m_iID;
	int m_iPointID[4];
	int m_iFaceID[4];
};


class CVoroAnalysis : public CxObject
{
public:
	void BinSphereHoleSDF(CxMatrix3 *m, CxVector3 *c);
	void BinEmptySDF();
	void BinEmptySDF_New(CxMatrix3 *m, CxVector3 *c);
	void Clean();
	void Finish();
	void Step(CTimeStep *ts);
	void Parse();
	void Build(CTimeStep *ts, bool sanity, bool verbose);
	CVoroAnalysis();
	~CVoroAnalysis();

	CxObArray m_oaVoroCells;
	CxObArray m_oaDelaunayTetrahedra;
	CxObArray m_oaDelaunayPoints;
	CxObArray m_oaVoroPoints;

	bool m_bSphereHole;
	CDF *m_pSphereHoleDF;

	bool m_bSphereHoleRDF;
	bool m_bAllAtomRDF;
	bool m_bSphereHole2DF;
	bool m_bNewEmptyMode;

	bool m_bSphereHoleSDF;
	bool m_bEmptySpaceSDF;
	bool m_bEmptySpaceSDF_RefMol;

	CDF *m_pAllAtomRDF;
	CDF *m_pSphereHoleRDF;
	C2DF *m_pSphereHole2DF;

	C3DF *m_pTempSDF;

	CSDF *m_pSphereHoleSDF;
	CxVec3Array *m_pTempVA;
	CSDF *m_pEmptySpaceSDF;

//	unsigned short *m_pEmptyTempBin;
//	int m_iEmptyTempRes;
//	double m_fEmptyTempRange;

	int m_iTempRes;

	int m_iEmptySpaceBorder;

	unsigned long *m_pSphereHole2DFCounter;

	bool m_bHoleDump;
	FILE *m_fHoleDump;
	double m_fDumpMinHole;

	int m_iMaxVoroPoints;
};

#endif


