/*****************************************************************************
    TRAVIS - Trajectory Analyzer and Visualizer
    http://www.travis-analyzer.de/

    Copyright (c) 2009-2013 Martin Brehm
                  2012-2013 Martin Thomas

    This file written by Martin Brehm.

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
*****************************************************************************/

#ifndef _3DF_H
#define _3DF_H

#include "xobject.h"
#include "df.h"
#include "2df.h"


class C3DF : public CxObject
{
public:
	void Clear();
	void CreateSlice(int axis, int v1, int v2, C2DF *cdf);
	void WriteHistogram(const char *prefix, const char *name, const char *suffix);
	void CalcHistogram();
	void ClipPlane(int dir, double val);
	void Invert();
	void MultiplyBin(double d);
	void WriteCube(const char *prefix, const char *name, const char *suffix, bool sdf);
	void CopyFrom(C3DF *p);
	void NormalizeBin(double mi, double ma);
	double NormalizeBinIntegral(double val);
	void CorrectAngle(int i);
	void CorrectRadialDist(int i);
	void WritePLT(const char *s1, const char *s2, const char *s3, bool sdf);
	C3DF();
	~C3DF();
	void AddToBin(double x, double y, double z);
	void AddToBin_IntZ(double x, double y, int z);

	inline void AddToBin(const CxVector3 &vec)
	{
		AddToBin(vec[0],vec[1],vec[2]);
	};

	void AddToBin_Sphere(double x, double y, double z, double r);

	inline void AddToBin_Sphere(const CxVector3 &vec, double r)
	{
		AddToBin_Sphere(vec[0],vec[1],vec[2],r);
	};

	void AddToBin_SphereWrap(double x, double y, double z, double r);

	inline void AddToBin_SphereWrap(const CxVector3 &vec, double r)
	{
		AddToBin_SphereWrap(vec[0],vec[1],vec[2],r);
	};

	double GetValue(double x, double y, double z);
	bool IsZero(double x, double y, double z);
	double GetValue(const CxVector3 &vec);
	void Create();
	void SetLabelX(const char *s);
	void SetLabelY(const char *s);
	void SetLabelZ(const char *s);
	void Smooth(int n);
	void CalcMaxEntry();

	double m_fMinVal[3];
	double m_fMaxVal[3];

	CDF *m_pChannels[3];
	C2DF *m_p2DF[3];

	double m_fMinEntry;
	double m_fMaxEntry;
	char *m_sLabelX;
	char *m_sLabelY;
	char *m_sLabelZ;

	double *m_fCountX;
	double *m_fCountY;
	double *m_fCountZ;

	int m_iRes[3];
	int m_iHistogramRes;
	long m_iResXY;
	double m_fBinEntries;
	double m_fSkipEntries;

	double *m_pBin;
	double *m_pHistogram;
	double m_fFac[3];
};

#endif
