//@HEADER
// ************************************************************************
// 
//            NOX: An Object-Oriented Nonlinear Solver Package
//                 Copyright (2002) Sandia Corporation
// 
//            LOCA: Library of Continuation Algorithms Package
//                 Copyright (2005) Sandia Corporation
// 
// Under terms of Contract DE-AC04-94AL85000, there is a non-exclusive
// license for use of this work by or on behalf of the U.S. Government.
// 
// This library is free software; you can redistribute it and/or modify
// it under the terms of the GNU Lesser General Public License as
// published by the Free Software Foundation; either version 2.1 of the
// License, or (at your option) any later version.
//  
// This library is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Lesser General Public License for more details.
// 
// You should have received a copy of the GNU Lesser General Public
// License along with this library; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
// USA
// 
// Questions? Contact Roger Pawlowski (rppawlo@sandia.gov) or 
// Eric Phipps (etphipp@sandia.gov), Sandia National Laboratories.
// ************************************************************************
//  CVS Information
//  $Source: /space/CVS/Trilinos/packages/nox/examples/petsc/1DFiniteDifference/FiniteDifference.H,v $
//  $Author: rppawlo $
//  $Date: 2006/08/22 00:01:00 $
//  $Revision: 1.3 $
// ************************************************************************
//@HEADER
                                                                                
// Finite Difference Problem Class
/* Description HERE 
 */

#ifndef _NOX_PETSC_EXAMPLE_1D_FD
#define _NOX_PETSC_EXAMPLE_1D_FD

#include "petscsnes.h"
#include "petscda.h"

/*
   User-defined application context
*/
typedef struct {
   DA        da;     /* distributed array */
   int       rank;   /* rank of processor */
   int       size;   /* size of communicator */
   PetscReal h;      /* mesh spacing */
} ApplicationCtx;

// Flag to tell the evaluate routine what objects to fill
enum FillType {RHS_ONLY, MATRIX_ONLY, ALL}; 

// Finite Element Problem Class
class FiniteDifference { 

public:

  // Constructor
  FiniteDifference(SNES* snes, void* ctx = NULL);

  // Destructor
  ~FiniteDifference();

  // Evaluates the function (RHS) and/or the Jacobian using the solution 
  // values in solnVector.
  bool evaluate(FillType f, const Vec *solnVector, 
		Vec *rhsVector, Mat *matrix);

  // Return a reference to the Vec with the Jacobian
  // that is generated by this class.
  Mat& getJacobian();

private:

  void *ctx;   // user-defined context optionally used in fill
  SNES *snes;  // A nonlinear solver object needed to respect fill interfaces
  MatStructure *matStruct; 

  FillType flag;
  Vec *initialSolution;
  Vec *overlapSolution;
  Vec *soln;
  Vec *rhs;
  Mat *A;
  VecScatter* petscMap;

  int MyPID;              // Process number
  int NumProc;            // Total number of processes
  int NumMyElements;      // Number of elements owned by this process
  int NumGlobalElements;  // Total Number of elements

};
#endif
