// $Id: Problem_Interface_MP.H,v 1.1 2007/04/13 19:26:05 agsalin Exp $
// $Source: /space/CVS/Trilinos/packages/nox/test/epetra/LOCA_MultiPoint_Tcubed/Problem_Interface_MP.H,v $

//@HEADER
// ************************************************************************
// 
//            NOX: An Object-Oriented Nonlinear Solver Package
//                 Copyright (2002) Sandia Corporation
// 
//            LOCA: Library of Continuation Algorithms Package
//                 Copyright (2005) Sandia Corporation
// 
// Under terms of Contract DE-AC04-94AL85000, there is a non-exclusive
// license for use of this work by or on behalf of the U.S. Government.
// 
// This library is free software; you can redistribute it and/or modify
// it under the terms of the GNU Lesser General Public License as
// published by the Free Software Foundation; either version 2.1 of the
// License, or (at your option) any later version.
//  
// This library is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Lesser General Public License for more details.
// 
// You should have received a copy of the GNU Lesser General Public
// License along with this library; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
// USA
// 
// Questions? Contact Roger Pawlowski (rppawlo@sandia.gov) or 
// Eric Phipps (etphipp@sandia.gov), Sandia National Laboratories.
// ************************************************************************
//  CVS Information
//  $Source: /space/CVS/Trilinos/packages/nox/test/epetra/LOCA_MultiPoint_Tcubed/Problem_Interface_MP.H,v $
//  $Author: agsalin $
//  $Date: 2007/04/13 19:26:05 $
//  $Revision: 1.1 $
// ************************************************************************
//@HEADER

//-----------------------------------------------------------------------------
#ifndef Problem_Interface_MP_H
#define Problem_Interface_MP_H

// Interface to the NLS_PetraGroup to provide for 
// residual and matrix fill routines.

// ---------- Standard Includes ----------
#include <iostream>
#include "Epetra_Vector.h"
#include "LOCA_Epetra.H"

// ---------- Forward Declarations ----------
class FiniteElementProblem;
namespace LOCA {
  class ParameterVector;
}


class  Problem_Interface_MP : 
  public LOCA::Epetra::Interface::Required,
  public NOX::Epetra::Interface::Jacobian
{
public:
  Problem_Interface_MP(FiniteElementProblem& Problem);
  ~Problem_Interface_MP();
  
  //! Compute and return F
  bool computeF(const Epetra_Vector& x, Epetra_Vector& F, FillType flag);

  //! Compute an explicit Jacobian
  bool computeJacobian(const Epetra_Vector& x, Epetra_Operator& Jac);

  //! Set a parameter in the user's code.
  void setParameters(const LOCA::ParameterVector& params);

  //! Application Operator: Object that points to the user's evaluation routines.
  /*! This is used to point to the actual routines and to store 
   *  auxiliary data required by the user's application for function/Jacobian
   *  evaluations that NOX does not need to know about.  This is type of 
   *  passdown class design by the application code.
   */ 
  FiniteElementProblem& problem;

  //! Number of residual fills
  int numFillsF;


  /* 
    These two functions are added for the multipoint problem.
    All above functions are the same as for regular problem.
   */

  //! Provides data to application for output files.
  virtual void dataForPrintSolution(const int conStep,
                                    const int timeStep,
                                    const int totalTimeSteps);

  //! Set multipoint parameter in the user's application.
  virtual void setMultiPointParameter(const int stepNum);

};

#endif

