
/*
 * Licensed Materials - Property of IBM
 *
 * trousers - An open source TCG Software Stack
 *
 * (C) Copyright International Business Machines Corp. 2004-2006
 *
 */

#ifndef _HOSTTABLE_H_
#define _HOSTTABLE_H_

#include <pthread.h>
#include <tcsd_wrap.h>

#define CONNECTION_TYPE_TCP_PERSISTANT	1

struct host_table_entry {
	struct host_table_entry *next;
	TSS_HCONTEXT tspContext;
	TCS_CONTEXT_HANDLE tcsContext;
	BYTE *hostname;
	int type;
	int socket;
	struct tcsd_comm_data comm;
	pthread_mutex_t lock; /* per-entry lock making calls serialized per-TCS */
};

struct host_table {
	struct host_table_entry *entries;
	pthread_mutex_t lock; /* Lock for the integrity of the host table list */
};

struct host_table_entry *get_table_entry(TSS_HCONTEXT);
void put_table_entry(struct host_table_entry *);
TSS_RESULT add_table_entry(TSS_HCONTEXT, BYTE *, int, struct host_table_entry **);
void remove_table_entry(TSS_HCONTEXT);


#endif
