#!/home/trashman/bin/fontforge

import fontforge
import sys


###########################################################################


simplification_flags = ("removesingletonpoints", "setstarttoextremum", "smoothcurves", "mergelines")
simplification_error = 0.5
simplification_angle = 0.1


def hint_glyph(glyph):
    if glyph.manualHints:
        print "(not autohinted)"
    else:
        glyph.autoHint()


def prepare_glyph(glyph):

    glyph.removeOverlap()

    glyph.addExtrema("only_good_rm")
    glyph.simplify(simplification_error, simplification_flags, simplification_angle)
    glyph.round()
    glyph.addExtrema("only_good_rm")
    glyph.simplify(simplification_error, simplification_flags, simplification_angle)
    glyph.round()
    hint_glyph(glyph)


source_path = sys.argv[1]
font_path   = sys.argv[2]

f = fontforge.open(source_path)

for glyph_name in f:
    sys.stdout.write(glyph_name + " ")
    sys.stdout.flush()
    glyph = f[glyph_name]
    glyph.background = glyph.foreground
    prepare_glyph(glyph)

sys.stdout.write("\n")
sys.stdout.flush()

f.save("comparison.sfd")

f.generate(font_path, flags=("opentype",))
