#ifndef INCLUDED_GETOPT_H
#define INCLUDED_GETOPT_H
/* vim:ts=4:sw=4:noet
 * (tabspace=4)
 * 
 * Copyright (C) 2004, 2005 Walter Doekes, <walter@djcvt.net>.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#ifdef _WIN32

#include "types.h"

#ifdef __cplusplus
extern "C" {
#endif

/**
 * A simplified getopt, works just like unix getopt, except that
 * it only works for argument-less options.
 */
int getopt(int argc, char* const argv[], const char* optstring);

/**
 * The getopt extern variable.
 */
int optind;

#ifdef __cplusplus
} /* extern "C" */
#endif /* __cplusplus */

#else /* !_WIN32 */

#include <unistd.h>

#endif /* !_WIN32 */

#endif /* INCLUDED_GETOPT_H */
