//-*-c++-*-

/**
 Author: David Auber
 Email : auber@labri.fr
 Last modification : 20/08/2001
 This program is free software; you can redistribute it and/or modify  *
 it under the terms of the GNU General Public License as published by  
 the Free Software Foundation; either version 2 of the License, or     
 (at your option) any later version.
*/

#ifndef TULIP_PROPERTY_H
#define TULIP_PROPERTY_H

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "PluginContext.h"
#include "SuperGraph.h"
#include "Reflect.h"
#include "WithParameter.h"

class PropertyManager;

/**
 * \defgroup plugins
 */ 
/*@{*/

class TLP_SCOPE PProperty:public WithParameter{
public:
  ///
  virtual ~PProperty(){}
  ///
  virtual bool run() = 0;
  ///
  virtual bool check(std::string &) = 0;
  ///
  virtual void reset() = 0;
};

///
template <typename Tnode, typename Tedge> 
class TLP_SCOPE Property: public PProperty {
public :
  ///
  Property(const PropertyContext & context) :
    superGraph(context.superGraph),
    pluginProgress(context.pluginProgress),
    dataSet(context.dataSet) {
  }
  ///
  virtual ~Property(){}
  ///
  virtual typename Tnode::RealType getNodeValue(const node ) {return Tnode::defaultValue();}
  ///
  virtual typename Tedge::RealType getEdgeValue(const edge ) {return Tedge::defaultValue();}
  ///
  virtual bool run() {return true;}
  ///
  virtual bool check(std::string &) {return true;}
  ///
  virtual void reset() {}

protected:
  SuperGraph *superGraph;
  PluginProgress *pluginProgress;
  DataSet *dataSet;
};
/*@}*/
#endif
