//-*-c++-*-
#include <float.h>
#include "tulip/ColorsProxy.h"
#include "tulip/PluginContext.h"
#include "tulip/Observable.h"
#include "tulip/Colors.h"
#include "tulip/PropertyProxy.h"
#include "tulip/MethodFactory.h"

using namespace std;

//==============================
ColorsProxy::ColorsProxy (SuperGraph *graph):PropertyProxy<ColorType,ColorType, Colors>(graph) {
  //  propertyProxy=this;
}
//==============================
ColorsProxy::~ColorsProxy() {
}    
//=================================================================================
PProxy* ColorsProxy::clonePrototype(SuperGraph * g, std::string n) {
  if( !g )
    return 0;
  ColorsProxy * p = g->getLocalProperty<ColorsProxy>( n );
  p->setAllNodeValue( getNodeDefaultValue() );
  p->setAllEdgeValue( getEdgeDefaultValue() );
  return p;
}
//=============================================================
void ColorsProxy::copy( const node n0, const node n1, PProxy * p ) {
  if( !p )
    return;
  ColorsProxy * tp = dynamic_cast<ColorsProxy*>(p);
  assert( tp );
  setNodeValue( n0, tp->getNodeValue(n1) );
}
//=============================================================
void ColorsProxy::copy( const edge e0, const edge e1, PProxy * p ) {
  if( !p )
    return;
  ColorsProxy * tp = dynamic_cast<ColorsProxy*>(p);
  assert( tp );
  setEdgeValue( e0, tp->getEdgeValue(e1) );
}
