//-*-c++-*-
/**
 Authors: David Auber, Romain Bourqui, Patrick Mary
 from the LaBRI Visualization Team
 Email : auber@tulip-software.org
 Last modification : 13/07/2007 
 This program is free software; you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by  
 the Free Software Foundation; either version 2 of the License, or     
 (at your option) any later version.
*/
//*********************************************************************************
//** GlADRenderOptions.cpp : Source for a rendering options class
//** 
//** author : Delorme Maxime
//** date   : 07/11/05
//*********************************************************************************

#include "tulip/GlADRenderOptions.h"

namespace tlp {

  GlADRenderOptions::GlADRenderOptions() {
    renderStatesValue = 2 + 8 + 32; // We enable GlAD_Solid, GlAD_ZEnable and GlAD_Culling
  }

  GlADRenderOptions::GlADRenderOptions(int baseValue) {
    renderStatesValue = baseValue;
  }

  GlADRenderOptions::~GlADRenderOptions() {
  }

  void GlADRenderOptions::setRenderOptions(const GlADRenderOptions &renderOptions) {
    renderStatesValue = renderOptions.renderStatesValue;
  }

  void GlADRenderOptions::setRenderState(GlADRenderState renderState, bool value) {
    int bit  =  1 << renderState;
    int mask = (1 << (N_RENDERSTATES + 1)) - 1;

    if (value)
      renderStatesValue = renderStatesValue | bit;
    else
      renderStatesValue = renderStatesValue & (mask - bit);
  }

  bool GlADRenderOptions::getRenderState(GlADRenderState renderState) const {
    int bit = 1 << renderState;
    if ((renderStatesValue & bit) > 0)
      return true;
    return false;
  }

  void GlADRenderOptions::setup() {
    if (getRenderState(GlAD_AlphaBlending)) {
      glEnable(GL_BLEND);
      glBlendFunc(GL_SRC_ALPHA, GL_ONE_MINUS_SRC_ALPHA);
    }
    else
      glDisable(GL_BLEND);

    if (getRenderState(GlAD_ZEnable))
      glEnable(GL_DEPTH_TEST);
    else
      glDisable(GL_DEPTH_TEST);
    
    if (getRenderState(GlAD_Lighting))
      glEnable(GL_LIGHTING);
    else
      glDisable(GL_LIGHTING);

    if (getRenderState(GlAD_Culling))
      glEnable(GL_CULL_FACE);
    else
      glDisable(GL_CULL_FACE);
  }
  
}
