//-*-c++-*-
/**
 Authors: David Auber, Romain Bourqui, Patrick Mary
 from the LaBRI Visualization Team
 Email : auber@tulip-software.org
 Last modification : 13/07/2007 
 This program is free software; you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by  
 the Free Software Foundation; either version 2 of the License, or     
 (at your option) any later version.
*/
#ifndef _TULIPWITHPARAMETER
#define _TULIPWITHPARAMETER

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "Reflect.h"

namespace tlp {

/** \addtogroup plugins */ 
/*@{*/
struct TLP_SCOPE WithParameter {
  ///
  StructDef getParameters();
  ///
  template<typename Ty> void addParameter(const char* str,
					  const char* inHelp=0,
					  const char* inDefValue = 0,
					  bool isMandatory = true)
  { parameters.template add<Ty>(str,inHelp,inDefValue,isMandatory); }
protected:
  ///
  StructDef parameters;
};
/*@}*/

}
#endif


