//-*-c++-*-
/**
 Authors: David Auber, Romain Bourqui, Patrick Mary
 from the LaBRI Visualization Team
 Email : auber@tulip-software.org
 Last modification : 13/07/2007 
 This program is free software; you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by  
 the Free Software Foundation; either version 2 of the License, or     
 (at your option) any later version.
*/
#include <float.h>
#include "tulip/ColorProperty.h"
#include "tulip/PluginContext.h"
#include "tulip/Observable.h"
#include "tulip/ColorAlgorithm.h"
#include "tulip/AbstractProperty.h"

using namespace std;
using namespace tlp;

//==============================
ColorProperty::ColorProperty (Graph *sg):AbstractProperty<ColorType,ColorType, ColorAlgorithm>(sg) {
  //  propertyProxy=this;
}
//==============================
ColorProperty::~ColorProperty() {
  notifyDestroy();
}    
//=================================================================================
PropertyInterface* ColorProperty::clonePrototype(Graph * g, std::string n) {
  if( !g )
    return 0;
  ColorProperty * p = g->getLocalProperty<ColorProperty>( n );
  p->setAllNodeValue( getNodeDefaultValue() );
  p->setAllEdgeValue( getEdgeDefaultValue() );
  return p;
}
//=============================================================
void ColorProperty::copy( const node n0, const node n1, PropertyInterface * p ) {
  if( !p )
    return;
  ColorProperty * tp = dynamic_cast<ColorProperty*>(p);
  assert( tp );
  setNodeValue( n0, tp->getNodeValue(n1) );
}
//=============================================================
void ColorProperty::copy( const edge e0, const edge e1, PropertyInterface * p ) {
  if( !p )
    return;
  ColorProperty * tp = dynamic_cast<ColorProperty*>(p);
  assert( tp );
  setEdgeValue( e0, tp->getEdgeValue(e1) );
}
