//-*-c++-*-
/**
 Authors: David Auber, Romain Bourqui, Patrick Mary
 from the LaBRI Visualization Team
 Email : auber@tulip-software.org
 Last modification : 13/07/2007 
 This program is free software; you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by  
 the Free Software Foundation; either version 2 of the License, or     
 (at your option) any later version.
*/
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <cassert>
#include <iostream>
#include "tulip/ObservableGraph.h"

using namespace std;
using namespace tlp;

void ObservableGraph::notifyAddNode(Graph *sg, const node n) {
  set<GraphObserver *> copy(observers); //Used to preserve iteratros
  for (set<GraphObserver *>::iterator itlObs=copy.begin();itlObs!=copy.end();++itlObs)
    (*itlObs)->addNode(sg, n);
}

void ObservableGraph::notifyDelNode(Graph *sg, const node n) {
  set<GraphObserver *> copy(observers); //Used to preserve iteratros
  for (set<GraphObserver *>::iterator itlObs=copy.begin();itlObs!=copy.end();++itlObs)
    (*itlObs)->delNode(sg, n);
}

void ObservableGraph::notifyAddEdge(Graph *sg, const edge e) {
  set<GraphObserver *> copy(observers); //Used to preserve iteratros
  for (set<GraphObserver *>::iterator itlObs=copy.begin();itlObs!=copy.end();++itlObs)
    (*itlObs)->addEdge(sg, e);
}

void ObservableGraph::notifyDelEdge(Graph *sg, const edge e) {
  set<GraphObserver *> copy(observers); //Used to preserve iteratros
  for (set<GraphObserver *>::iterator itlObs=copy.begin();itlObs!=copy.end();++itlObs)
    (*itlObs)->delEdge(sg, e);
}

void ObservableGraph::notifyReverseEdge(Graph *sg, const edge e) {
  set<GraphObserver *> copy(observers); //Used to preserve iteratros
  for (set<GraphObserver *>::iterator itlObs=copy.begin();itlObs!=copy.end();++itlObs)
    (*itlObs)->reverseEdge(sg, e);
}

void ObservableGraph::notifyDestroy(Graph *sg) {
  set<GraphObserver *> copy(observers); //Used to preserve iteratros
  for (set<GraphObserver *>::iterator itlObs=copy.begin();itlObs!=copy.end();++itlObs)
    (*itlObs)->destroy(sg);
}

