//-*-c++-*-
/**
 Authors: David Auber, Romain Bourqui, Patrick Mary
 from the LaBRI Visualization Team
 Email : auber@tulip-software.org
 Last modification : 13/07/2007 
 This program is free software; you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by  
 the Free Software Foundation; either version 2 of the License, or     
 (at your option) any later version.
*/
#ifndef Tulip_SpanningDagSelection_H
#define Tulip_SpanningDagSelection_H

#include <tulip/TulipPlugin.h>

template<typename T>
class MutableConatainer;

/** \addtogroup selection */
/*@{*/

/// This selection plugins enables to find a subgraph of G that is acyclic.
/**
 * This selection plugins enables to find a subgraph of G that is acyclic.
 *
 *  \author David Auber, LaBRI University Bordeaux I France: 
 *   auber@tulip-software.org
 */
class SpanningDagSelection:public tlp::BooleanAlgorithm { 

public:
  SpanningDagSelection(const tlp::PropertyContext &);
  bool run();
};
/*@}*/
#endif
