//-*-c++-*-
/**
 Authors: David Auber, Romain Bourqui, Patrick Mary
 from the LaBRI Visualization Team
 Email : auber@tulip-software.org
 Last modification : 13/07/2007 
 This program is free software; you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by  
 the Free Software Foundation; either version 2 of the License, or     
 (at your option) any later version.
*/
#ifndef IMAGE_WRITER_H // -*-c++-*-
#define IMAGE_WRITER_H
#include <iostream>
#include <string>
#include <GL/gl.h>

namespace tlprender
{
  extern const std::string SUPPORTED_IMAGE_FORMATS[];
  
  class ImageWriter {
  protected:
    const GLubyte *buffer;
    int width, height;
    std::string title, software, source, layout, comment;
    bool titleState, softwareState, sourceState, layoutState, commentState;
    ImageWriter(const GLubyte *imagebuffer, const int width, const int height);
    
  public:
    virtual ~ImageWriter() {}
    static ImageWriter *getImageWriter(std::string &type, const GLubyte *buffer, const int width, const int height);
    void setTitle(const std::string &);
    void setSoftware(const std::string &);
    void setSource(const std::string &);
    void setLayout(const std::string &);
    void setComment(const std::string &);

    //an image writer will define this method and write date to the provided stream
    virtual bool writeImage(std::ostream &) const = 0;
  };
}

#endif //IMAGE_WRITER_H
