<?php
/**
 * $Horde: turba/minisearch.php,v 1.20.4.3 2005/03/05 23:15:55 chuck Exp $
 *
 * Copyright 2000-2005 Charles J. Hagenbuch <chuck@horde.org>
 *
 * See the enclosed file LICENSE for license information (ASL).  If you
 * did not receive this file, see http://www.horde.org/licenses/asl.php.
 */

@define('TURBA_BASE', dirname(__FILE__));
require_once TURBA_BASE . '/lib/base.php';

$search = Util::getFormData('search');
$results = array();

// Make sure we have a source.
$source = Util::getFormData('source');
if (!isset($source) && isset($cfgSources) && is_array($cfgSources) && count($cfgSources) > 0) {
    $source = $prefs->getValue('default_dir');
}
if (!isset($cfgSources[$source])) {
    reset($cfgSources);
    $source = key($cfgSources);
}

// Do the search if we have one.
if (!is_null($search)) {
    $driver = &Turba_Driver::singleton($source, $cfgSources[$source]);
    if (!is_a($driver, 'PEAR_Error')) {
        $criteria['name'] = trim($search);
        $res = $driver->search($criteria);
        if (is_a($res, 'Turba_List')) {
            while ($ob = $res->next()) {
                if ($ob->isGroup()) {
                    continue;
                }
                $att = $ob->getAttributes();
                foreach ($att as $key => $value) {
                    if (!empty($attributes[$key]['type']) && $attributes[$key]['type'] == 'email') {
                        $results[] = array('name' => $att['name'],
                                           'email' => $value,
                                           'source' => $source,
                                           'key' => $att['__key']
                                           );
                        break;
                    }
                }
            }
        }
    }
}

$bodyClass = 'summary';
require TURBA_TEMPLATES . '/common-header.inc';

?>
<script language="JavaScript" type="text/javascript">
<!--
window.setTimeout('var status = window.parent.document.getElementById(\'turba_minisearch_searching\'); status.style.visibility = \'hidden\'', 10);
window.parent.busyExpanding = false;
//--//-->
</script>
<?php
if (count($results)) {
    echo '<table width="100%"><tr><td class="control"><b>' . _("Search Results") . ':</b></td></tr>';

    $i = 0;
    foreach ($results as $contact) {
        $url = 'display.php';
        $url = Util::addParameter($url, 'source', $contact['source']);
        $url = Util::addParameter($url, 'key', $contact['key']);

        $mail_link = $GLOBALS['registry']->call('mail/compose', array(array('to' => addslashes($contact['email']))));
        $target = ' target="_parent"';
        if (is_a($mail_link, 'PEAR_Error')) {
            $mail_link = 'mailto:' . urlencode($contact['email']);
            $target = '';
        }

        echo '<tr><td class="item' . ($i++ % 2) . '">';
        echo Horde::link(Horde::applicationUrl($url), _("View Contact"), '', '_parent') . Horde::img('contact.png', _("View Contact")) . '</a> ';
        echo '<a href="' . $mail_link . '"' . $target . '>' . htmlspecialchars($contact['name'] . " <" . $contact['email'] . ">") . '</a></td></tr>';
    }
    echo '</table>';
} elseif (!is_null($search)) {
    echo _("No contacts found");
}
?>
</body>
</html>
