"Template support for Json"

from turbojson import jsonify

class JsonSupport(object):
    
    def __init__(self, extra_vars_func=None, options=None):
        pass
        
    def render(self, info, format=None, fragment=False, template=None):
        """Renders data in the desired format.
    
        @param info: the data itself
        @type info: dict
        @param format: not used
        @type format: string
        @param fragment: not used
        @type fragment: bool
        @param template: not used
        @type template: string
        """
        info.pop('tg_css', None)
        info.pop('tg_js_bodybottom', None)
        info.pop('tg_js_bodytop', None)
        info.pop('tg_js_head', None)
        info.pop('tg_mochikit', None)

        return jsonify.encode(info)

    def get_content_type(self, user_agent):
        if "Opera" in user_agent.browser: 
            return "text/plain"
        else:
            return "text/javascript"


