#!/usr/bin/env python
# -*- coding: utf-8 -*-

import glob
import os
import re

try:
    from setuptools import setup, find_packages
except ImportError:
    from ez_setup import use_setuptools
    use_setuptools()
    from setuptools import setup, find_packages

from distutils.command.build import build as _build
from babel.messages import frontend as babel
from turpial.config import GLOBAL_CFG

LONG_DESCRIPTION = """
Turpial es un cliente alternativo para microblogging con multiples
interfaces. Esta escrito en Python y tiene como meta ser una aplicacion con
bajo consumo de recursos y que se integre al escritorio del usuario pero sin
renunciar a ninguna funcionalidad
"""

class build(_build):
    
    def get_sub_commands(self):
        sub_commands = _build.get_sub_commands(self)
        return ['compile_catalog'] + sub_commands

# TODO: Maybe find some better ways to do this
# looking distutils's copy_tree method
data_files=[
    ('./', ['AUTHORS', 'TRANSLATORS']),
    ('share/pixmaps', ['turpial/data/pixmaps/turpial.png']),
    ('share/applications', ['turpial.desktop']),
    ('share/doc/turpial', ['doc/turpial.png',
                   'doc/turpial.dia',
                   'ChangeLog',
                   'README.rst',
                   'COPYING']),
]

pattern = re.compile('turpial/i18n/')
for root, dirs, files in os.walk(os.path.join('turpial', 'i18n')):
    for filename in files:
        if filename.endswith('.po'):
            # Yes, it's an ugly hack to build list of files that do not exist yet
            fullpath = os.path.join(root, filename[0:-2] + 'mo')
            dest = os.path.join('share', 'locale', re.sub(pattern, '', root))
            data_files.append((dest, [fullpath]))

setup(name="turpial",
      version=GLOBAL_CFG['App']['version'],
      description="Cliente Twitter escrito en Python",
      long_description=LONG_DESCRIPTION,
      author="Wil Alvarez",
      author_email="wil.alejandro@gmail.com",
      maintainer="Wil Alvarez",
      maintainer_email="wil.alejandro@gmail.com",
      url="http://turpial.org.ve",
      download_url="http://turpial.org.ve/downloads",
      license="GPLv3",
      keywords='twitter identi.ca microblogging turpial',
      classifiers=[
        "Development Status :: 5 - Production/Stable",
        "Environment :: X11 Applications :: GTK",
        "Intended Audience :: End Users/Desktop",
        "License :: OSI Approved :: GNU General Public License (GPL)",
        "Operating System :: POSIX :: Linux",
        "Programming Language :: Python",
        "Topic :: Communications"
      ],
      packages=find_packages(),
      package_data={
        'turpial': ['data/pixmaps/*', 'data/sounds/*', 'data/themes/default/*',
            'certs/*']
      },
      entry_points={
        'console_scripts': [
            'turpial = turpial.main:Turpial',
        ],
      },
      cmdclass={
        'build': build,
        'compile_catalog': babel.compile_catalog,
        'extract_messages': babel.extract_messages,
        'init_catalog': babel.init_catalog,
        'update_catalog': babel.update_catalog,
      },
      data_files=data_files,
)
