<?php
/**
 * Copyright 1999 - 2003 by Gero Kohnert
 *
 * this script parses all the inputs and stores the object into the database.
 * on completition it jumps to the detail screen of the stored object
 *
 * @modulegroup department
 * @module department_ins
 * @package department
 */
 include_once 'webelements.p3';
 include_once 'permission.p3';

 /* Check if user is allowed to use tutos */
 check_user();
 loadmodules("department","ins");

 $gotourl = "department_new.php";
 $msg = "";
 $d = new department($dbconn);
 # Location 
 $l = new location($dbconn);

 if ( isset($_POST['id']) ) {
   $gotourl = addUrlParameter($gotourl,"id=". $d->id,true);
   $d->read($_POST['id']);
   if ( ! $d->mod_ok() ) {
     # Not allowed
     $msg .= sprintf($lang['Err0024'],$lang[$d->getType()],true);
   }
 }

 if ( isset($_POST['loc_id']) ) {
   $gotourl= addUrlParameter($gotourl,"loc_id=". $_POST['loc_id'],true);
   $l->read($_POST['loc_id']);
   if ( ! $l->mod_ok() ) {
     # Not allowed
     $msg .= sprintf($lang['Err0024'],$lang[$l->getType()],true);
   }
 }

 if ( !isset($_POST['name']) || ($_POST['name'] == $lang['PlsChangeName']) || empty($_POST['name']) ) {
   $msg .= sprintf($lang['Err0009'],$lang['Department']) ."<br>";
 } else {
   $name = trim(StripSlashes($_POST['name']));
   $gotourl = addUrlParameter($gotourl,"name=". UrlEncode($name),true);
 }

 # Check Company
 if ( isset($_POST['cfn']) ) {
   if ( empty($_POST['cfn']) ) {
     $msg .= sprintf($lang['Err0009'],$lang['Company']) ."<br>";
   } else {
     $x = check_field(StripSlashes($_POST['cfn']),"cfn","cl","c");
     $d->setCompany($x->id);
   }
 }
 if ( isset($_POST['cid']) ) {
   $d->setCompany($_POST['cid']);
 }


 if ( $msg == "" ) {
   if ( ($d->id < 0) || ($name != $d->name) ) {
     $q = "SELECT * FROM ". $d->tablename ." WHERE ". $dbconn->Like2("name",$name) ." AND c_id = ". $d->company->id;
     $r = $dbconn->Exec($q);
     $n = $r->numrows();
     if ( 0 != $n) {
       $x = new department($dbconn);
       $x->read_result($r,0);
       $msg .= sprintf($lang['Err0045'],$x->getLink()) ."<br>";
     }
     $r->free();
   }
 }

 # location
 $lmsg = $l->parseform();
 if ($l->used || ($l->id >0)) {
   $msg .= $lmsg;
 }

 # other modules
 $msg .= module_parseforms($current_user,$d,$gotourl);

 if ( $msg == "" ) {
   $d->setName($name);
   $d->c_id = $d->company->id;

   $dbconn->Begin("WORK");
   $msg .= $d->save();
   $l->adr_id = $d->id;
   if ($l->used || ($l->id >0)) {
     $msg = $l->save();
#     $gotourl= addUrlParameter($gotourl,"loc_id=". $l->id,true);
   }
   $dbconn->Commit("WORK");

   $gotourl = $d->getURL();
 }

 $gotourl = addMessage($gotourl,$msg,true);
 $gotourl = addSessionKey($gotourl,true);

 Header("Status: 302 Moved Temporarily");
 Header("Location: ". getBaseUrl() . $gotourl);
 $dbconn->Close();
 /*
  *  CVS Info:  $Id: department_ins.php,v 1.27 2003/10/01 15:26:11 gokohnert Exp $
  *  $Author: gokohnert $
  */
?>