<?php
/**
 * Copyright 1999 - 2003 by Gero Kohnert
 *
 * @modulegroup bug
 * @module bug_overview
 * @package bug
 */
 $tutos['base'] = "../..";
 ini_set("include_path","..");
 include_once 'webelements.p3';
 include_once 'permission.p3';
 include_once 'product.pinc';
 include_once 'timetrack.pinc';

 require_once 'layout/layout.pinc';

 /* Check if user is allowed to use it */
 check_user();
 loadmodules("bugtracking","overview");
 loadmodule("bugtracking");

 /**
  * show a overview of bugs
  */
 class bug_overview extends layout {
   /**
    * display the info
    */
   Function info() {
     global $lang,$tutos;

     if ( $this->format == "stat") {
       $this->statinfo();
       return;
     }

     $n = count($this->blist);
     if ( 0 == $n) {
       $this->error($lang['Err0048']);
       return;
     }

     $this->assign('action', "bug_overview.php");
     $this->assign('massupdate', $tutos[massupdate]);
     $this->assign('filter ', $this->filter);

     /**
      * Overview Table Header
      * Don't provide name to avoid ordering option*
      *
      * If you provide a 'name' element, its value must be a valid SQL
      * column. Please have a look at the request at the end of the
      * prepare function.
      */
     $headers = array();
     $headers[] = array('name' => 'name',       'label' => $lang['BugID']);
     $headers[] = array('name' => 'b.creation', 'label' => $lang['Date']);
     $headers[] = array('label' => $lang['LastDate']);
     $headers[] = array('name' => 'ref', 'label' => $lang['BugReference']);
     $headers[] = array('name' => 'short', 'label' => $lang['BugShort']);
     $headers[] = array('name' => 'state',  'label' => $lang['BugState']);
     $headers[] = array('name' => 'class',  'label' => $lang['BugClass']);
     $headers[] = array('name' => 'creator', 'label' => $lang['BugCreator']);
     $headers[] = array('name' => 'solver', 'label' => $lang['BugAssignedTo']);

     $this->assign('headers', $headers);
     $this->assign('nb_cols', count($headers) + 1);
     $this->assign('inner_cols', count($headers) - 1);

     if ( $this->format == "paper" ) {
       $a = 0;
       $end = $n;
     } else if ( $this->start == -1 ) {
       $a = $n - $tutos[maxshow];
       $end = $n;
       $this->start = $a;
     } else {
       $a = $this->start;
       $end = $this->start + $tutos[maxshow];
     }

     // The filter is not directly usable for our purpose
     $search = array();
     foreach( $this->filter as $k => $v ) {
       if( $k == "parent" )
	 $search['pid'] = $v;
       else
	 $search[$k] = $v;
     }
     $this->assign_navbar($a, $end, $n, $search);

     $this->filter['name'] = prepare_regpattern($this->filter['name']);
     $bugs = array();

     while( ($a < $n) && ($a < $end) ) {
       $b = &$this->blist[$a];

       if( $b->parent->id > 0 )
         $parent = array('label' => $b->parent->getFullName(),
			 'link'  => $b->parent->getUrl(),
			 'title' => sprintf($lang['ProdLinkInfo'],
					    $b->parent->getFullName()));
       else
         $parent = $lang['HistoryDeleted'];

       if( $b->creator->id > 0 )
         $creator = array('label' => $b->creator->getShortName(),
			  'link'  => $b->creator->getUrl());
       else
         $creator = $lang['HistoryDeleted'];

       if( $b->solver->id > 0 )
	 $solver = array('label' => $b->solver->getShortName(),
			 'title' => $b->solver->getFullName(),
			 'link'  => $b->solver->getUrl());
       else
         $solver = $lang['HistoryDeleted'];

       // search for the last date of intervention
       $b->read_bugHistory();
       
       $last = $b->creation;
       foreach( $b->bughist as $i => $h ) {
	 if( $last->datecmp($h->creation) < 0 )
	   $last = $h->creation;
       }

       $bugs[] = array('id'       => $b->id,
		       'name'     => $b->getFullName(),
		       'link'     => $b->getUrl(),
		       'title'    => myentities($b->short),
		       'creation' => $b->creation->getDate(),
		       'lasth'    => $last->getDate(),
		       'parent'   => $parent,
		       'desc'     => myentities($b->short),
		       'state'    => 
		       array('value' => $b->state,
			     'label' => $lang['BugStates'][$b->state]),
		       'class'    => 
		       array('value' => $b->class,
			     'label' => $lang['BugClasses'][$b->class]),
		       'creator'  => $creator,
		       'solver'   => $solver);
       $a++;
     }
     $this->assign("bugs", $bugs);
     // $this->debug($bugs);

     // Actions to perform on marked elements
     $this->assign("marked", sprintf($lang['withmarked'],$lang['Bugs']));

     // Mass update bug solver
     $project = -1;
     if( isset($search['pid']) ) {
       switch( $this->ref->getType() ) {
       case "product":
	 $project = &$this->ref;
	 break;

       case "task":
	 $ptasks  = array();
	 $project = $this->ref->getProject($ptasks);
	 break;
       }
     }

     $parts = $this->user->askPeople($this->user, $project);
     $this->assign('solver',
		   array('id'      => 'solver',
			 'name'    => 'solver',
			 'label'   => $lang['BugAssignedTo'],
			 'options' => $parts));

     $actions = array();
     $actions[-1] = $lang['ActionNil'];
     if ( $tutos[bugdelete] == 1 ) {
       $actions[-2] = $lang['Delete'];
     }

     // Mass update bug solver
     $actions[-8] = $lang['BugAssignedTo'];

     foreach($lang['BugClasses'] as $f => $i) {
       $actions["C".$f] = sprintf($lang['SetTo'], $lang['BugClass'], $i);
     }
     foreach($lang['BugStates'] as $f => $i) {
       $actions["S".$f] = sprintf($lang['SetTo'], $lang['BugState'], $i);
     }
     $actions[-4] = $lang['AclModify'];
     if (class_exists('watchlist')) {
       $actions["WatchAdd"] = $lang['WatchAdd'];
       $actions["WatchDel"] = $lang['WatchDel'];
     }
     $this->assign("actions", $actions);

     $this->assign('Enter',   $lang['Enter']);
     $this->template('bugtracking/bug_overview');

   }

   /**
    * Statistical Bug Info
    */
   Function statinfo() {
     global $lang,$tutos;

     $n = count($this->blist);
     $a = 0;

     $cmin = time();
     $cmax = -1;
     $tmin = time();
     $tmax = -1;
     $ttl = 0.0;
     $tts = 0.0;
     $ttc = 0.0;
     $ns = 0;
     $nc = 0;

     $cnt = 0;
     while ( $a < $n ) {
       $b = &$this->blist[$a];
       $a++;

       if ( ! $b->see_ok() ) {
         unset($b);
         continue;
       }
       if ( !isset($states[$b->state]) ) {
         $states[$b->state] = 0;
       }
       if ( !isset($classes[$b->class]) ) {
         $classes[$b->class] = 0;
       }
       $states[$b->state]++;
       $classes[$b->class]++;
       $t1 = $b->creation->getTimestamp();
       $cmin = min($t1,$cmin);
       $tmin = min($t1,$tmin);
       $cmax = max($t1,$cmax);
       $tmax = max($t1,$tmax);

       if ( ($b->state == BUG_STATE_SOLVED) && ($b->solvedate->notime != 1) ) {
         $t2 = $b->solvedate->getTimestamp();
         $tts += ( $t2 - $t1 );
         $tmax = max($t2,$tmax);
         $ns++;
       } else if ( ($b->state == BUG_STATE_CLOSED) && ($b->solvedate->notime != 1)) {
         $t2 = $b->solvedate->getTimestamp();
         $ttc += ( $t2 - $t1 );
         $tmax = max($t2,$tmax);
         $nc++;
       } else {
         $t2 = time();
       }
       $ttl += ( $t2 - $t1 );
       $bl[] = &$b;
       $cnt++;
       unset($b);
     }

     # we need it 
     $b = new bug($this->dbconn);

     echo $this->DataTableStart();
     echo "<tr>\n";
     echo " <th colspan=\"5\">". $lang['BugStatsTitle'] ."</th>\n";
     echo "</tr>\n";

     echo "<tr>\n";
     echo $this->showfield($lang['Count']);
     echo " <td colspan=\"4\">". $cnt ."\n";
     $pre = "filterd by ";
     while ( list ($i,$f) = @each ($this->filter) ) {
       if ( $i == 'state' ) {
         echo $pre . $lang['BugState'];
         if ( $f == -2 ) {
           echo " ". $lang['BugAnyButClosed'];
         } else {
           echo " ". $lang['BugStates'][$f];
         }
       } else if ( $i == 'classes' ) {
         echo $pre . $lang['BugClass'];
         echo " ". $lang['BugClasses'][$f];
       } else if ( ($i == 'name') && ($f != "") ) {
         echo $pre . $lang['ProdDesc'];
         echo " ". $f;
       } else if ( $i == 'from' ) {
         echo $pre . $lang['DateTimeFrom'];
         echo " ". $f->getDateTime();
       } else if ( $i == 'to' ) {
         echo $pre . $lang['DateTimeTill'];
         echo " ". $f->getDateTime();
       } else if ( $i == 'parent' ) {
         $p = getObject($this->dbconn,$f);
         echo $pre . $lang[$p->getType()];
         echo " ". $p->getLink();
       } else if ( $f != "" ) {
         echo $pre . $i;
         echo " ". $f;
       }
       $pre = " and ";
     }

     echo " </td>\n";
     echo "</tr>\n";

     # Creation Times
     $c1 = new DateTime();
     $c2 = new DateTime();
     $t1 = new DateTime();
     $t2 = new DateTime();
     $c1->setDateTimeTS($cmin);
     $c2->setDateTimeTS($cmax);
     $t1->setDateTimeTS($tmin);
     $t2->setDateTimeTS($tmax);
     echo "<tr>\n";
     echo $this->showfield($lang['BugBetween']);
     echo " <td colspan=\"2\">". $c1->getDateTime() ."</td>\n";
     echo " <td colspan=\"2\">". $c2->getDateTime() ."</td>\n";
     echo "</tr>\n";

     # Average Times
     echo "<tr>\n";
     echo $this->showfield($lang['BugAverage']);
     echo " <td>". sprintf($lang['BugAvgEnd'],($ttl /$cnt)/3600) ."<br>\n";
     if ( $ns > 0 ) {
       echo sprintf($lang['BugAvgSolve'],($tts /$ns)/3600,$ns) ."<br>\n";
     }
     if ( $nc > 0 ) {
       echo " ". sprintf($lang['BugAvgClose'],($ttc /$nc)/3600,$nc) ."\n";
     }
     echo "</td></tr>\n";

     # State distribution
     $link = $tutos['base'] ."/php/graph_bars.php";
     $link = addSessionKey($link);
     $link = addUrlParameter($link,"type=pie");
     @reset($states);
     echo "<tr>\n";
     if ( !function_exists('ImageCreate') ) {
       echo " <td valign=\"top\" rowspan=\"". count($states) ."\"><b>". $lang['BugState'] ."</b></td>";
     } else {
       echo $this->showfield($lang['BugState']);
     }
     $c = 0;
     while ( list ($i,$f) = @each ($states) ) {
       $val = number_format($f * 100.0 / $cnt ,2);
       if ( !function_exists('ImageCreate') ) {
         echo " <td>". $lang['BugStates'][$i] ."</td>\n";
         echo " <td align=\"right\">". $f ."</td>\n";
         echo " <td align=\"right\">". $val ."%</td>\n";
         echo "</tr>\n";
       }
       $link = addUrlParameter($link,"f[". $c ."]=".$val);
       $link = addUrlParameter($link,"t0[". $c ."]=". UrlEncode($lang['BugStates'][$i]));
       $link = addUrlParameter($link,"t1[". $c ."]=". $f );
       $link = addUrlParameter($link,"col[". $c ."]=". UrlEncode($b->c_state[$i]));
       $c++;
     }
     if ( function_exists('ImageCreate') ) {
       echo " <td colspan=\"4\" valign=\"top\"><img src=\"". $link ."\"></td>";
       echo "</tr>\n";
     }

     echo "<tr>\n";
     echo " <td>&nbsp;</td>\n";
     echo " <td colspan=\"4\">\n";
     echo " <table cellspacing=\"0\" cellpadding=\"0\" border=\"0\">\n";
     echo " <tr>\n";
     echo "  <th align=\"left\">". $t1->getDateTime() ."</th>\n";
     echo " </tr>\n";
     @reset($bl);
     $h = 10;
     $w = 400;
     $xx = ($tmax - $tmin) / $w;
     if ( $xx > 0 ) {
       while ( list ($i,$b) = @each ($bl) ) {
         $x1 = $b->creation->getTimeStamp();
         if ( ($b->state == 3) || ($b->state == 4) ) {
           $x2 = $b->solvedate->getTimeStamp();
         } else {
           $x2 = time();
         }
         if ( $x2 > $tmax ) {
           $x2 = $tmax;
         }
         $part1 = number_format(($x1 - $tmin) / $xx);
         $part2 = number_format(($x2 - $x1) / $xx);
         $part3 = number_format(($tmax - $x2) / $xx);

         if ( $part2 < 1 ) {
           $part2 = 1;
         }
         if ( ($part1 + $part2 + $part3) < ($w + 1) ) {
           $part3 = $w + 1 - $part2 - $part1;
         }

         echo " <tr>\n";
         echo "<td width=\"". ($w +1) ."\">";
         if ( $part1 > 0 ) {
           $text = "<img border=\"0\" src=\"". $tutos['base'] ."/html/white.png\" width=\"". $part1 ."\" height=\"". $h ."\">";
           echo makelink($b->getURL(),$text,sprintf($lang['BugShow'],$b->getFullName()) );
         }
         $text = "<img border=\"0\" src=\"". $tutos['base'] ."/html/". $b->c_state[$b->state] .".png\" width=\"". $part2 ."\" height=\"". $h ."\">";
         echo makelink($b->getURL(),$text,sprintf($lang['BugShow'],$b->getFullName()) );

         if ( $part3 > 0 ) {
           $text = "<img border=\"0\" src=\"". $tutos['base'] ."/html/white.png\" width=\"". $part3 ."\" height=\"". $h ."\">";
           echo makelink($b->getURL(),$text,sprintf($lang['BugShow'],$b->getFullName()) );
         }
         echo "</td>\n";
         echo " </tr>\n";
       }
     }
     echo " <tr>\n";
     echo "  <th align=\"right\">". $t2->getDateTime() ."</th>\n";
     echo " </tr>\n";
     echo " </table>\n";
     echo " </td>\n";
     echo "</tr>\n";

     # Class distribution
     $b = new bug($this->dbconn);
     $link = $tutos['base'] ."/php/graph_bars.php";
     $link = addSessionKey($link);
     $link = addUrlParameter($link,"type=pie");
     @reset($classes);
     echo "<tr>\n";
     if ( !function_exists('ImageCreate') ) {
       echo " <td valign=\"top\" rowspan=\"". count($classes) ."\"><b>". $lang['BugClass'] ."</b></td>";
     } else {
       echo $this->showfield($lang['BugClass']);
     }
     $c = 0;
     while ( list ($i,$f) = @each ($classes) ) {
       $val = number_format($f * 100.0 / $cnt ,2);
       if ( !function_exists('ImageCreate') ) {
         echo " <td>". $lang['BugClasses'][$i] ."</td>\n";
         echo " <td align=\"right\">". $f ."</td>\n";
         echo " <td align=\"right\">". $val ."%</td>\n";
         echo "</tr>\n";
       }
       $link = addUrlParameter($link,"f[". $c ."]=".$val);
       $link = addUrlParameter($link,"t0[". $c ."]=". UrlEncode($lang['BugClasses'][$i]));
       $link = addUrlParameter($link,"t1[". $c ."]=". $f );
       $link = addUrlParameter($link,"col[". $c ."]=". UrlEncode($b->c_class[$i]));
       $c++;
     }
     if ( function_exists('ImageCreate') ) {
       echo " <td colspan=\"5\" valign=\"top\"><img src=\"". $link ."\"></td>";
       echo "</tr>\n";
     }

     echo $this->DataTableEnd();
     $this->result1->free();
   }

   /**
    * navigate
    */
   Function navigate() {
   }

   /**
    * action via massupdate
    */
   Function action() {
     global $lang,$msg;

     if ( $_GET['action'] == -2 ) {
       /**
	* Delete bug
	*/

       $this->dbconn->Begin("WORK");
       foreach ($_GET['mark'] as $key => $val) {
         $b = new bug($this->dbconn);
         $b->read($val);
         if ( $b->id != $val ) {
           continue;
         }
         if ( $b->del_ok() ) {
           $msg .= sprintf($lang['BugDeleteI'], $b->getFullName()) ."<br>";
           $msg .= $b->delete();
         } else {
           $msg .= $b->getLink() .": ". sprintf($lang['Err0023'],$lang[$b->getType()]) ."<br>\n";
         }
         unset($b);
       }
       $this->dbconn->Commit("WORK");
       return;
     }

     if ( $_GET['action'] == -4 ) {
       /**
	* ALC modification
	*/
       $this->redirect = "../". acl_action();
       return;
     }

     if ( ereg("^([SC])(.*)",$_GET['action'],$a) ) {
       /**
	* Setting State or Class
	*
	* We create a new bug history entry with the new values.
	*/
       $this->dbconn->Begin("WORK");
       foreach ($_GET['mark'] as $key => $val) {
         $b = new bug($this->dbconn);
         $b->read($val);
         if ( $b->id != $val ) {
           continue;
         }
         if ( $b->mod_ok() ) {
	   $b->read_bugHistory();

	   $h = new bugdata($this->dbconn);
	   $h->bugid  = $b->id;
	   $h->state  = $b->state;
	   $h->class  = $b->class;
	   $h->solver = $b->solver;

	   // echo $a[1].' '.$a[2]."<br>\n";

           if ( $a[1] == "S" ) {
             $msg .= $b->getLink() ." "
		. $lang['BugState']." = ".$lang['BugStates'][$a[2]]
		."<br>";
	     $h->state = $a[2];
           }
	   else if ( $a[1] == "C" ) {
             $msg .= $b->getLink() ." "
		. $lang['BugClass'] ." = ". $lang['BugClasses'][$a[2]]
		."<br>";
	     $h->class = $a[2];
           }
	   else {
             $msg .= "A:".$_GET['action']
		." M: '". $val[1] ."'  V:". $val[2] ."<br>";
           }

           $msg .= $h->save();
         }
	 else {
           $msg .= $b->getLink() .": "
	      . sprintf($lang['Err0024'],$lang[$b->getType()])."<br>\n";
         }
         unset ($b);
         unset ($h);
       }
       $this->dbconn->Commit("WORK");
       return;
     }

     if( $_GET['action'] == -8 ) {
       /**
	* New solver
	*/
       $solverid = $_GET['solver'];
       if( $solverid == "" || $solverid == -1 ) {
	 return;
       }

       $solver = new tutos_user($this->dbconn);
       $solver->read($solverid);
       if( $solver->id != $solverid )
	 return;

       $this->dbconn->Begin("WORK");
       foreach ($_GET['mark'] as $key => $val) {
         $b = new bug($this->dbconn);
         $b->read($val);
         if ( $b->id != $val ) {
           continue;
         }

         if ( $b->mod_ok() ) {
	   $b->read_bugHistory();

	   if( $b->solver->id != $solver->id ) {
	     $h = new bugdata($this->dbconn);
	     $h->bugid  = $b->id;
	     $h->state  = $b->state;
	     $h->class  = $b->class;
	     $h->solver = $solver;

	     $b->save();
	     $h->save();
	   }
         }
	 else {
           $msg .= $b->getLink().": "
	      .sprintf($lang['Err0023'], $lang[$b->getType()])."<br>\n";
         }
         unset($b);
	 unset($h);
       }
       $this->dbconn->Commit("WORK");
       return;
     }

     if (class_exists('watchlist')) {
       watchlist::parse_action($this->user);
     }
   }

   /**
    * prepare
    */
   Function prepare() {
     global $msg,$lang;

     if ( $this->format == "stat") {
       $this->name = $lang['BugStatsTitle'];
     } else {
       $this->name = $lang['BugsOverview'];
     }

     if ( ! $this->user->feature_ok(usebugtracking,PERM_SEE) ) {
       $msg .= sprintf($lang['Err0022'],"'". $this->name ."'");
       $this->stop = true;
     }

     $this->link1 = "bugtracking/bug_overview.php";
     $this->filter = array();

     $this->link1 = addUrlParameter($this->link1,"format=".UrlEncode($this->format));

     if ( isset($_GET['id']) ) {
       $id = $_GET['id'];
     }
     if ( isset($_GET['pid']) ) {
       $pid = $_GET['pid'];
     }
     if ( isset($_GET['solverid']) ) {
       $solverid = $_GET['solverid'];
     }
     if ( isset($_GET['state']) ) {
       $state = $_GET['state'];
     } else {
       $state = "";
     }
     if ( isset($_GET['class']) ) {
       $class = $_GET['class'];
     } else {
       $class = "";
     }
     if ( isset($_GET['name']) ) {
       $name = $_GET['name'];
     } else {
       $name = "";
     }
     $this->filter['name'] = "";

     /**
      *
      * Note: I did not understand why 2 SQL queries where used and
      * unioned in the PHP source. So I made a single query to obtain
      * the wanted data, and drop the code belonging the the second
      * query...
      *
      * Here's how the SQL query will look like:
      *
      * SELECT b.*, h.*, tt.adr_id as solver
      * FROM
      *  (SELECT DISTINCT ON (bugid) bugid,
      *        c.creation, c.class, c.state, c.tt_id
      *   FROM bugchanges c
      *   ORDER BY bugid, c.creation DESC) h
      *  JOIN timetrack tt ON tt.id = h.tt_id
      *  JOIN bugs b ON b.id = h.bugid
      * WHERE
      *  b.product_id = 6581 and h.state = 2
      * ORDER BY b.id, c.state, c.creation;
      *
      * The joins are used in order to better use the indexes.
      */
     $q =
	" SELECT b.*, h.* ".
	" FROM ".
	"  (SELECT DISTINCT ON (bugid) bugid, ".
	"        c.creation, c.class, c.state, c.solver, c.tt_id ".
	"   FROM bugchanges c ".
	"   ORDER BY bugid, c.creation DESC, c.id DESC) h".
	"  JOIN bugs b ON b.id = h.bugid ";

     $pre = " WHERE ";

     if ( ($name != "*") && ($name != "") ) {
       $q .= " " . $pre
	  ."(". $this->dbconn->Like("b.short",$name)
	  ." OR ". $this->dbconn->Like("b.id",$name)
	  ." OR ". $this->dbconn->Like("b.name",$name) .")";
       $pre = " AND ";

       $this->link1 = addUrlParameter($this->link1,"name=".UrlEncode($name));
       // $this->addHidden("name",$name);
       $this->filter['name'] = $name;
     }

     if ( isset($id) ) {
       $q .= " ". $pre ." b.id = ".$id;
       $pre = " AND ";
       $this->link1 = addUrlParameter($this->link1,"id=". $id);
       // $this->addHidden("id",$id);
     }

     // States to display
     if ( $state == -2 )  {
       $q .= " ". $pre ." h.state != ". BUG_STATE_SOLVED;
       $pre = " AND ";
       $this->link1 = addUrlParameter($this->link1,"state=". $state);
       // remember this
       //   session_register('bugsearchstate');
       $_SESSION['bugsearchstate'] = $state;
       $this->filter['state'] = $state;
     }
     else if ( $state > 0 )  {
       $q .= " ". $pre ." h.state=".$state;
       $pre = " AND ";
       $this->link1 = addUrlParameter($this->link1,"state=". $state);
       // remember this
       //   session_register('bugsearchstate');
       $_SESSION['bugsearchstate'] = $state;
       $this->filter['state'] = $state;
     }

     // Classes to display
     if ( $class > 0 ) {
       $q .= " ". $pre ." h.class=". $class;
       $pre1 = " AND ";
       $this->link1 = addUrlParameter($this->link1,"class=". $class);
       // remember this
       // session_register('bugsearchclass');
       $_SESSION['bugsearchclass'] = $class;
       $this->filter['classes'] = $class;
     }

     // Parent to display
     if ( isset($pid) ) {
       $ref = getObject($this->dbconn,$pid);
       $this->name .= " : ".$ref->getFullName();
       $q .= $pre ." b.product_id in (". $pid;
       $pre1 = " AND ";

       $sep = ",";
       if ( isset($_GET['show']) && ($_GET['show'] == "all") ) {
	 loadmodule('installation');
         $this->link1 = addUrlParameter($this->link1,"show=". $_GET['show']);

	 // $this->addHidden("show",$_GET['show']);
	 $this->filter['show'] = $_GET['show'];
		 
         add_task_ids($ref,$q1,$sep);
         add_inst_ids($ref,$q1,$sep);
       }
       $q .= ")";
       $this->link1 = addUrlParameter($this->link1,"pid=". $pid);
       $this->filter['parent'] = $pid;

       $this->ref = &$ref;
       $this->assign('parent_type', $ref->getType());
       // $this->addHidden("pid",$pid);
     }

     // Start Date for search
     $from = new DateTime(0);
     if ( isset($_GET['fd']) ) {
       $from->setDateTime($_GET['fd']);
     }
     else {
       $from->setDateTimeF("f");
       // remember this
       //  session_register('bugsearchfrom');
       $_SESSION['bugsearchfrom'] = $from->getYYYYMMDD();
     }
     if ( $from->notime != 1 ) {
       $q .= $pre ."(b.creation >= ". $this->dbconn->Date($from) .")";
       $pre1 = " AND ";
       $this->link1 = addUrlParameter($this->link1,"fd=".$from->getYYYYMMDD());
       $this->filter['from'] = $from;
       $this->addHidden("fd",$from->getYYYYMMDD());
     }

     // End Date for search
     $to = new DateTime(0);
     if ( isset($_GET['td']) ) {
       $to->setDateTime($_GET['td']);
     }
     else {
       $to->setDateTimeF("t");
       // remember this
       //  session_register('bugsearchto');
       $_SESSION['bugsearchto'] = $to->getYYYYMMDD();
     }

     if ( $to->notime != 1 ) {
       $q .= $pre ."(b.creation <= ". $this->dbconn->Date($to) .")";
       $pre = " AND ";
       $this->link1 = addUrlParameter($this->link1,"td=".$to->getYYYYMMDD());
       $this->filter['to'] = $to;
       $this->addHidden("td",$to->getYYYYMMDD());
     }

     // user to display
     if ( isset($solverid) ) {
       $q .= $pre ." h.solver = ". $solverid;
       $pre1 = " AND ";
       $this->link1 = addUrlParameter($this->link1,"solverid=". $solverid);
       $this->filter['solver'] = $solverid;
       
       $this->assign("solverid", $solverid);
     }

     check_dbacl($q1, $this->user->id);

     // sorting
     $xxx = "";
     order_parse($q, $this->link1, $xxx, $hidden,"h.state, h.creation");

     $this->result = $this->dbconn->Exec($q);

     $n = $this->result->numrows();

     $this->assign('xf', $_GET['xf']);
     $this->assign('xo', $_GET['xo']);

     /*
     echo "Q:".$q."<br>";
     echo "N:".$n."<br>";
     */

     // Make a big array of all visible bugs
     $this->blist = array();
     $h = array();
     $x = 0;
     while ( $x < $n ) {
       $b = new bug($this->dbconn);
       $b->read($this->result->get($x, "id"));

       /**
	* Get the solver afterwards... TO FIX!
	*/
       // $this->debug($this->result1->get($x, "solver"));
       $b->solver = getObject($this->dbconn,
			      $this->result->get($x, "solver"));

       $x++;
       if ( ! $b->see_ok() ) {
         continue;
       }
       if (! isset($h[$b->id]) ) {
         $this->blist[] = &$b;
	 $h[$b->id] = 1;
       }

       unset($b);
     }

     if ( 0 == $n) {
       $this->redirect = "bug_select.php?msg=". UrlEncode($lang['Err0048']);
       return;
     }
     else if ( ($this->format == "html") && ($n == 1) ) {
       $this->redirect =  "bug_show.php?id=".$this->blist[0]->id;
       return;
     }


     // menu
     $x = bug::getSelectLink($this->user,$lang['Search']);
     $x['category'][] = "obj";
     $x['image'] = "search";
     $this->addmenu($x);

     if ( $this->user->feature_ok(usebugtracking,PERM_NEW) ) {

       if( $this->filter['parent'] != "" && $this->filter['parent'] != -1 )
	 $url = "bugtracking/bug_new.php?pid=".$this->filter['parent'];
       else
	 $url = "bugtracking/bug_new.php";

       $x = array('url'   => $url,
                  'text'  => $lang['NewEntry'],
		  'image' => 'new',
                  'info'  => $lang['CreateNewBug'],
                  'category' => array("bug","new","obj")
                 );
       $this->addMenu($x);
     }

     if ( $this->format != "stat" ) {
       $l = addUrlParameter($this->link1,"format=paper");
       $x = array('url'    => $l,
                  'image'  => bug::getHtmlIcon(),
                  'text'   => $lang['Printable'],
                  'info'   => $lang['PrintableInfo'],
                  'category' => array("view","bug")
                 );
       $this->addMenu($x);

       $l = addUrlParameter($this->link1,"format=stat");
       $x = array('url'   => $l,
                  'image' => bug::getHtmlIcon(),
                  'text'  => $lang['BugStats'],
                  'info'  => $lang['BugStatsInfo'],
                  'category' => array("view","bug")
                 );


       $this->addMenu($x);
     }
     web_StackStartLayout($this,"bug_overview.php","bug_overview.php?".$_SERVER['QUERY_STRING']);
   }
 }

 $l = new bug_overview($current_user);
 $l->display();
 $dbconn->Close();
?>
<!--
    CVS Info:  $Id: bug_overview.php,v 1.8.2.24 2005/03/10 15:36:12 tapoueh Exp $
    $Author: tapoueh $
-->
