<?php
/**
 * Copyright 1999 - 2004 by Gero Kohnert
 *
 * @modulegroup appointment
 * @module calendar
 */
 include_once 'webelements.p3';
 include_once 'permission.p3';
 include_once 'calendar.p3';

 if ( $tutos[tasksincalendar] == 1 ) {
   include_once 'task.pinc';
 }
 include_once 'appointment.pinc';
 include_once 'product.pinc';

 include_once 'layout/layout.pinc';

 /* Check if user is allowed to use it */
 check_user();
 loadmodules("appointment","show");

 /**
  * display a calendar for some weeks
  */
 class calendar extends layout {
   /**
    * the data display part
    */
   Function info() {
     global $tutos , $lang;

     $w  = $this->user->get_prefweeks();

     // Previous and next month
     $ts = mktime(0, 0, 0,
		  substr($this->t,4,2),
		  substr($this->t,6,2), substr($this->t,0,4));

     $last = Date("Ymd", $ts -  $w * 7 * 86400);
     $next = Date("Ymd", $ts +  $w * 7 * 86400);

     // Display for current time
     $this->assign("t", $this->t);
     $this->assign("id", $this->id);
     $this->assign('action', "calendar.php");
     $this->assign('cal_options', cal_options($this->team, $this->teamname));

     $weeks = array_reverse(cal_week($this->user, $this->t, $this->uids, $w));
     $wdays = $weeks[0]['wdays'];

     // $this->debug($weeks);

     $this->assign('last_week', $last);
     $this->assign('next_week', $next);

     $this->assign('week', $lang['week']);
     $this->assign('wdays', $wdays);
     $this->assign('calendar', $lang['Calendar']);
     
     $this->assign('lastw_href',  "?t=".$last);
     $this->assign('lastw_img',   'left');
     $this->assign('lastw_label', $lang['lastweek']);
     
     $this->assign('nextw_href',  "?t=".$next);
     $this->assign('nextw_img',   'right');
     $this->assign('nextw_label', $lang['nextweek']);

     $this->assign('weeks', $weeks);
     $this->template('calendar');
   }

   /**
    *
    */
   Function navigate() {
   }

   /**
    *
    */
   Function prepare() {
     global $lang;

     $this->name = $lang['Calendar'];

     if ( ! $this->user->feature_ok(usecalendar,PERM_SEE) ) {
       $msg .= sprintf($lang['Err0022'],"'". $this->name ."'");
       $this->stop = true;
     }

     $this->teamname = "";
     $this->t = Date("Ymd");
     $this->id = -1;

     if ( isset($_GET['t']) ) {
       $this->t = $_GET['t'];
     }
     /* Show a calendar containing Appointment id */
     if ( isset($_GET['id']) ) {
       $this->id = $_GET['id'];
       $query = "SELECT id,a_start FROM ". $this->dbconn->prefix ."calendar where id =". $this->id;
       check_dbacl( $query, $this->user->id);
       $result = $this->dbconn->Exec($query);
       if ( 1 != $result->numrows()) {
         echo $this->error ( sprintf($lang['Err0040'],$lang['Appointment']) );
         $this->id = -1;
       } else {
         $d = $result->getDateTime(0, "a_start");
         $this->t = $d->getYYYYMMDD();
       }
       $result->free();
     }

     $this->uids = cal_parse_options($this->user, $this->teamname);
     $this->team = $this->user->get_prefteam();

     // menu
     // App module is not ready
     /*
     $m = appointment::getSelectLink($this->user);
     $m[category][] = "obj";
     $this->addmenu($m);

     $m = appointment::getAddLink($this->user,$this->user);
     $m['image'] = "new";
     $this->addMenu($m);
     */
   }
 }

 $l = new calendar($current_user);
 $l->display();
 $dbconn->Close();
?>
<!--
    CVS Info:  $Id: calendar.php,v 1.77.2.4 2005/01/11 14:44:29 tapoueh Exp $
    $Author: tapoueh $
-->