<?php
/**
 * Copyright 1999 - 2003 by Gero Kohnert
 *
 *   CVS Info:  $Id: company_overview.php,v 1.43.2.5 2004/09/29 16:23:53 tapoueh Exp $
 *   $Author: tapoueh $
 *
 * @modulegroup company
 * @module company_overview
 * @package company
 */
 include_once 'webelements.p3';
 include_once 'permission.p3';
 include_once 'product.pinc';
 include_once 'appointment.pinc';

 include_once 'layout/layout.pinc';

 /* Check if user is allowed to use it */
 check_user();
 loadmodules("company","overview");

 /**
  * show a overview of comapanies
  */
 class company_overview extends layout {
   /**
    * display the info
    */
   Function info() {
     global $lang,$tutos;

     $n = $this->result->numrows();

     if ( $this->format == "xml" ) {
       $a = new company($this->dbconn);
       echo $a->exportXMLHeader();
       echo $a->exportXML_head() ;
       echo "<company_set>\n";
       $x = 0;
       while ( $x < $n ) {
         $a = new company($this->dbconn);
         $a->read_result($this->result,$x);
         echo $a->exportXML(false);
         $x++;
       }
       echo "</company_set>\n";
       return;
     }

     $this->assign('action', "company_overview.php");
     $this->assign('massupdate', $tutos[massupdate]);

     // Overview Table Header
     $headers = array();
     $headers[] = array('name' => 'name', 'label' => $lang['Company']);
     $headers[] = array('label' => $lang['Department']);

     $this->assign('headers', $headers);

     $this->assign('nb_cols', count($headers) + 1);
     $this->assign('inner_cols', count($headers) - 1);

     if ( $this->start == -1 ) {
       $a = $n - $tutos[maxshow];
       $end = $n;
       $this->start = $a;
     }
     else {
       $a = $this->start;
       $end = $this->start + $tutos[maxshow];
     }
     $this->assign_navbar($a, $end, $n, $this->search);

     $companies = array();

     $line = 0;
     while ( ($a < $n) && ($a < $end) ) {
       $c = new company($this->dbconn);
       $c->read_result($this->result,$a);
       $c->read_departments();
       $a++;
       if (! $c->see_ok() ) {
         continue;
       }

       $departments = array();
       $rs = max(count($c->list[usedepartment]),1);

       foreach($c->list[usedepartment] as $i => $f) {

	 $departments[] = array('name'  => $f->getFullName(),
				'title' => $f->getFullName(),
				'link'  => $f->getUrl());
       }

       $companies[] = array('id'    => $c->id,
			    'name'  => $c->getFullName(),
			    'title' => $c->getFullName(),
			    'link'  => $c->getUrl(),
			    'deps'  => $departments);

       unset($c);
     }
     // $this->debug($companies);
     $this->assign('companies', $companies);

     $actions = array();
     $actions[-1] = $lang['ActionNil'];
     $actions[-2] = $lang['Delete'];
     $actions[-4] = $lang['AclModify'];

     $this->assign("actions", $actions);
     $this->assign('Enter',   $lang['Enter']);

     $this->template('company_overview');
   }

   /**
    * navigate
    */
   Function navigate() {
   }

   /**
    * action via massupdate
    */
   Function action() {
     global $lang,$msg;

     @reset($_GET['mark']);
     if ( $_GET['action'] == -2 ) {
       $this->dbconn->Begin("WORK");
       while (list ($key,$val) = @each ($_GET['mark'])) {
         $c = new company($this->dbconn);
         $c->read($val);
         if ( $c->id != $val ) {
           continue;
	 }
         if ( $c->del_ok() ) {
           $msg .= sprintf($lang['CompanyDelInfo'], $c->getFullName()) ."<br>";
           $msg .= $c->delete();
	 }
	 else {
	   $msg .= $c->getLink() .": ".
	      sprintf($lang['Err0023'],$lang[$c->getType()]) ."<br>\n";
	 }
         unset($c);
       }
       $this->dbconn->Commit("WORK");
     }
     else if ( $_GET['action'] == -4 ) {
       $this->redirect = acl_action();
     }
   }

   /**
    * prepare
    */
   Function prepare() {
     global $msg,$lang;

     $this->name = $lang['CompanyOverview'];
     $this->search = array();

     $this->link1 = "company_overview.php";
     $this->link2 = "company_overview.php";

     $q = "SELECT * FROM ". $this->dbconn->prefix ."companies";
     $pre = "WHERE";

     if ( isset($_GET['name']) && ($_GET['name'] != "*")
	  && ($_GET['name'] != "") ) {

       $q .= " ".  $pre ." ". $this->dbconn->Like("name",$_GET['name']);
       $pre = " AND ";
       $this->link1 =
	  addUrlParameter($this->link1,"name=". UrlEncode($_GET['name']));

       $this->link2 =
	  addUrlParameter($this->link2,"name=". UrlEncode($_GET['name']));

       $this->search['name'] = $_GET['name'];
     }

     check_dbacl( $q, $this->user->id);

     // sorting
     $xxx = "";
     order_parse($q,$this->link1,$xxx,$xxx,"name");

     $this->result = $this->dbconn->Exec($q);

     if ( $this->format != 'xml' ) {
       if ( 0 == $this->result->numrows()) {
	 $this->redirect = 
	    "address_select.php?msg=". UrlEncode($lang['Err0048']);
	 $this->result->free();
       }
       else if ($this->result->numrows() == 1) {
	 $c = new company($this->dbconn);
	 $c->read_result($this->result,0);
	 $this->redirect =  "company_show.php?id=".$c->id;
	 $this->result->free();
       }
     }
     $this->assign('xf', $_GET['xf']);
     $this->assign('xo', $_GET['xo']);

     // menu
     $x = tutos_address::getSelectLink($this->user,$lang['Search']);
     $this->addMenu($x);
     if ( $this->user->feature_ok(useaddressbook,PERM_NEW) ) {
       $x = array('url'   => "company_new.php",
                  'text'  => $lang['NewEntry'],
		  'image' => 'new',
                  'info'  => $lang['CompanyCreateInfo'],
                  'category' => array("company","new","obj")
                 );
       $this->addMenu($x);
     }
   }
 }

 $l = new company_overview($current_user);
 $l->display();
 $dbconn->Close();
?>