<?php
/**
 * Copyright 1999 - 2003 by Gero Kohnert
 *
 * @modulegroup department
 * @module department_del
 * @package department
 */
 include_once 'webelements.p3';
 include_once 'permission.p3';
 include_once 'product.pinc';
 include_once 'appointment.pinc';

 /* Check if user is allowed to use it */
 check_user();
 loadmodules("department","del");

 $msg = "";
 $d = new department($dbconn);

 if ( !isset($_GET['id']) ) {
   $msg .= "Could not delete department<br>";
 } else {
   $d->read($_GET['id']);
 }

 if ( ! $d->del_ok() ) {
   $msg = sprintf($lang['Err0023'],$lang[$d->getType()]);
   $gotourl = $d->getUrl() ;
 }


 if ( $msg == "" ) {
   $dbconn->Begin("WORK");
   $msg = $d->delete();
   $dbconn->Commit("WORK");

   $gotourl = "address_select.php" ;
 } else {
   $gotourl= addUrlParameter($gotourl,"id=". $id);
 }

 $gotourl = addMessage($gotourl,$msg,true);
 $gotourl = addSessionKey($gotourl,true);

 Header("Status: 302 Moved Temporarily");
 Header("Location: ". getBaseUrl() . $gotourl);
 $dbconn->Close();
 /*
  *  CVS Info:  $Id: department_del.php,v 1.20 2003/08/24 09:50:46 gokohnert Exp $
  *  $Author: gokohnert $
  */
?>
