<?php
/**
 * Copyright 2000 - 2004 by Gero Kohnert
 *
 * @modulegroup file
 * @module file_new
 * @package file
 */
 $tutos['base'] = "../..";
 ini_set("include_path","..");
 include_once 'webelements.p3';
 include_once 'permission.p3';

 /* Check if user is allowed to use it */
 check_user();
 loadmodules('file','new');
 loadmodule('file');
 loadlayout();

 /**
  * change/modify a document
  */
 class file_new extends layout {
   /**
    * display the form
    */
   Function info() {
     global $tutos,$lang,$table;

     echo "<form name=\"fileadd\" enctype=\"multipart/form-data\" method=\"post\" action=\"file_ins.php\">\n";

     if ( $this->obj->id != -1 ) {
       $this->addHidden("id",$this->obj->id);
     }
     echo $this->DataTableStart();
     echo "<tr>\n";
     echo " <th colspan=\"4\">". $lang['File'] ."</th>\n";
     echo "</tr>\n";

     if ( $this->obj->id > 0 ) {
       echo "<tr>\n";
       echo " <td colspan=\"3\">&nbsp;</td>\n";
       echo " <td align=\"right\" colspan=\"1\">". acl_link($this->obj) ."</td>\n";
       echo "</tr>\n";
     }
     echo "<tr>\n";
     echo $this->showfieldc($lang['FileNameDoc'],1,"name");
     echo " <td><input id=\"name\" maxlength=\"".$table['file']['name'][size]."\" name=\"name\" value=\"". $this->obj->name ."\"></td>\n";
     echo $this->showfieldc($lang['FileVersion'],0,"version");
     echo " <td><input id=\"version\" size=\"10\" maxlength=\"".$table['file']['version'][size]."\" name=\"version\" value=\"". $this->obj->version ."\"></td>\n";
     echo "</tr>\n";

     echo "<tr>\n";
     echo $this->showfieldc($lang['FileAuthor'],0,"a");
     echo " <td colspan=\"3\">\n";
     select_from_array_or_input($this->obj,"a",$this->obj->author,0);
     echo " </td>\n";
     echo "</tr>\n";

     $cnt = 0;
     foreach ($this->obj->links as $i => $f) {
       echo "<tr>\n";
       if ($cnt == 0) {
         echo $this->showfield($lang['FileReference'],0,"link_id_".$cnt);
       } else {
         echo "<td>&nbsp;</td>\n";
       }
       echo " <td colspan=\"2\">\n";
       echo "  <select name=\"link_id[]\">\n";
       foreach ($this->obj->plist[$i] as $i1 => $f1) {
         echo "   <option value=\"". $i1 ."\"". ($i1 == $i ? " selected>* ":">") . $lang[$f1->getType()] .": ". myentities($f1->getFullName()) ."</option>\n";
       }
       echo "  </select>\n";
       $cnt++;
       echo " </td>\n";
       echo " <td align=\"left\">&nbsp;\n";
       if (count($this->obj->links) > 1) {
         echo "<input type=\"checkbox\" id=\"del[]\" name=\"del[]\" value=\"". $i ."\">". $lang['Remove']." ". $f->getLink();
       }
       echo " </td>\n";

       echo "</tr>\n";
     }
     # Allow new References
     echo "<tr>\n";
     if ($cnt == 0) {
       echo $this->showfield($lang['FileReference'],0,"link_id_".$cnt);
     } else {
       echo "<td>&nbsp;</td>\n";
     }
	 if (count($this->refl) > 0) {
       echo " <td colspan=\"3\">";
	   echo "  <select name=\"link_id[]\">\n";
       echo "   <option value=\"-1\" selcted>--</option>\n";
  	   foreach ($this->refl as $f) {
	     echo "   <option value=\"". $f->id ."\">". $lang[$f->getType()] .": ". myentities($f->getFullName()) ."</option>\n";
	   }
       echo "  </select>\n";
       echo " </td>\n";
	 } else {	 
       echo " <td colspan=\"3\">";
	   echo "  <select name=\"reftype\">\n";
       echo "   <option value=\"0\">--</option>\n";
  	   foreach ($tutos['docowners'] as $f) {
	     if (! class_exists($f)) continue;
	     $x = new $f($this->dbconn);
    	 if (method_exists($x,"search_by_name")) {
	       echo "   <option value=\"". $f ."\"". ($this->reftype == $f ? " selected":"") .">". $lang[$x->getType()] ."</option>\n";
	     }
	   }
       echo "  </select>\n";
       echo "  <input name=\"refname\" size=\"30\" value=\"". myentities($this->refname)."\"></input>\n";
       echo " </td>\n";
	 }
     echo "</tr>\n";

     echo "<tr>\n";
     echo $this->showfield($lang['FileName'],0,"file");
     echo " <td colspan=\"3\"><input id=\"file\" size=\"40\" name=\"file\" type=\"file\" value=\"". $this->obj->filename ."\">\n";
     if ( $this->obj->id != -1 ) {
       echo "<br><font size=\"-1\">". $this->obj->filename ."</font>";
     }
     echo "<br><font size=\"-1\">(max. allowed size = ". ini_get('upload_max_filesize') ." Bytes)</font>";
     echo "</td>\n";
     echo "</tr>\n";

     if ( ($this->obj->id != -1) && ($this->obj->vsys != 0) ) {
       echo "<tr>\n";
       echo $this->showfield($lang['FileVersioning'],0,"save");
       echo " <td id=\"save\" colspan=\"3\">\n";
       echo " <font size=\"-1\">". $lang['FileVersioningI'] ."</font><br>\n";
       echo "  <input type=\"radio\" name=\"save\" value=\"0\">&nbsp;". sprintf($lang['FileOverwrite'],$this->obj->getFullname()) ."<br>\n";
       echo "  <input type=\"radio\" name=\"save\" value=\"1\" checked>&nbsp;". sprintf($lang['FileSave'],$this->obj->name,$this->obj->version) ."\n";
       echo " </td>\n";
       echo "</tr>\n";
     }
     if ( $this->obj->id == -1 ) {
       echo "<tr>\n";
       echo $this->showfield($lang['FileVersionType'],0,"vsys");
       echo " <td id=\"vsys\" colspan=\"3\">&nbsp;\n";
       echo " <font size=\"-1\">". $lang['FileVersionTypeI'] ."</font><br>\n";
       echo "  <input type=\"radio\" name=\"vsys\" value=\"0\"". ( $this->obj->vsys == 0 ? " checked":"") .">&nbsp;none \n";
       echo "  <input type=\"radio\" name=\"vsys\" value=\"1\"". ( $this->obj->vsys == 1 ? " checked":"") .">&nbsp;TUTOS \n";
       if ( file_exists($tutos[ci]) && is_executable($tutos[ci]) ) {
         echo "  <input type=\"radio\" name=\"vsys\" value=\"2\"". ( $this->obj->vsys == 2 ? " checked":"") .">&nbsp;RCS \n";
       }
       echo " </td>\n";
       echo "</tr>\n";
     }

     echo "<tr>\n";
     echo $this->showfield($lang['FileLocking'],0,"locked");
     echo " <td id=\"locked\" colspan=\"3\">&nbsp;\n";
     echo "  <input type=\"radio\" name=\"locked\" value=\"0\" ". ( $this->obj->locked == 0 ? " checked":"") .">&nbsp;". $lang['FileUnlocked'] ."\n";
     echo "  <input type=\"radio\" name=\"locked\" value=\"". $this->user->id ."\"". ( $this->obj->locked == $this->user->id ? " checked":"") .">&nbsp;". sprintf ($lang['FileLocked'], $this->user->getLink()) ."\n" ;
     echo " </td>\n";
     echo "</tr>\n";

     module_addforms($this->user,$this->obj,4);

     echo "<tr>\n";
     if ( isset($this->obj->id) && ($this->obj->id != -1) ) {
       submit_reset(0,1,1,1,1,0);
     } else {
       submit_reset(0,-1,1,1,1,0);
     }
     echo "</tr>\n";

     echo $this->DataTableEnd();
     hiddenFormElements();
     $this->addHidden("gotourl","file/file_new.php");
     echo $this->getHidden();
     echo "</form>\n";
     echo $lang['FldsRequired'] ."\n";
     echo $this->setfocus("fileadd.name");
   }
   /**
    * navigate
    */
   Function navigate() {
   }
   /**
    * prepare
    */
   Function prepare() {
     global $msg,$lang,$tutos;

	 $this->refl = array();
	 $this->refname = "";
	 $this->reftype = "0";
     $this->obj = new tutos_file($this->dbconn);
     if ( isset($_GET['id']) ){
       $this->name = $lang['FileMod'];
       $this->obj->read($_GET['id']);
       if ( $this->obj->id < 0 ) {
         $msg .= sprintf($lang['Err0040'],$lang[$this->obj->getType()]);
         $this->stop = true ;
       } else if ( ! $this->obj->mod_ok() ) {
         $msg .= sprintf($lang['Err0024'],$lang[$this->obj->getType()]);
         $this->stop = true;
       }
       $this->name .= ": ".$this->obj->getFullName();
     } else {
       $this->name = $lang['FileCreation'];
       if ( ! $this->user->feature_ok(usedocmanagement,PERM_NEW) ) {
         $msg .= sprintf($lang['Err0054'],$lang[$this->obj->getType()]);
         $this->stop = true;
       }
     }

     if ( isset($_GET['link_id']) && is_array($_GET['link_id']) ){
	   $arr = $_GET['link_id'];
	   foreach($arr as $i) {
         $l = getObject($this->dbconn,$i);
         $this->obj->links[$l->id] = &$l;
		 unset($l);
	   }
     }
     if ( isset($_GET['link_id']) && is_numeric($_GET['link_id']) ){
	   $arr = $_GET['link_id'];
       $l = getObject($this->dbconn,$arr);
       $this->obj->links[$l->id] = &$l;
     }
     if ( isset($_GET['refl']) && is_array($_GET['refl']) ){
	   $arr = $_GET['refl'];
	   foreach($arr as $i) {
         $l = getObject($this->dbconn,$i);
         $this->refl[$l->id] = &$l;
		 unset($l);
	   }
     }
     if ( isset($_GET['refname']) ) {
	   $this->refname = Stripslashes($_GET['refname']);
	 }
     if ( isset($_GET['reftype']) ) {
	   $this->reftype = Stripslashes($_GET['reftype']);
	 }

     if ( isset($_GET['name']) ){
       $this->obj->name = StripSlashes($_GET['name']);
     }
     if ( isset($_GET['version']) ){
       $this->obj->version = StripSlashes($_GET['version']);
     }
     preset_from_array_or_input($this->obj,'author',"a");

     $this->obj->readLinks();
     $this->obj->read_relations();
     # menu
     $m = tutos_file::getSelectLink($this->user,$lang['Search']);
     $m[category][] = "obj";
     $this->addmenu($m);

     if ( ($this->obj->id > 0) && $this->obj->del_ok() ) {
       $x = array( url => "file/file_del.php?id=". $this->obj->id,
                   text => $lang['Delete'],
                   info => sprintf($lang['FileDeleteI'],$this->obj->getFullName()),
                   confirm => true,
                   category => array("file","del","obj")
                 );
       $this->addMenu($x);
     }

     add_module_newlinks($this,$this->obj);
   }
 }

 $l = new file_new($current_user);
 $l->display();
 $dbconn->Close();
?>
<!--
    CVS Info:  $Id: file_new.php,v 1.12.2.1 2004/04/14 17:39:19 tapoueh Exp $
    $Author: tapoueh $
-->