<?php
/**
 * Copyright 1999 - 2004 by Gero Kohnert
 *
 * Display mails
 *
 * CVS Info:  $Id: mail_show.php,v 1.13.2.1 2004/04/14 17:39:22 tapoueh Exp $
 * $Author: tapoueh $
 *
 * @modulegroup mailbox
 * @module mail_show
 * @package mailbox
 *
 */
 $tutos['base'] = "../..";
 ini_set("include_path","..");
 include_once 'webelements.p3';
 include_once 'permission.p3';

 /* Check if user is allowed to use it */
 check_user();
 loadmodules('mailbox','show');
 loadmodule('mailbox');
 loadlayout();


 /**
  * show a mail
  */
 class mail_show extends layout {
   /**
    *
    */
   Function info() {
     global $lang,$tutos;
 
     if (($this->part == 0) && ($this->format == 'download')) {
       Header("Expires: 0");
       Header("Pragma: no-cache");
       Header("Content-type: message/rfc822");
       Header("Content-Disposition: attachment; filename=\"". $this->mno .".eml\"");
       Header("Content-Description: Upload from TUTOS" );
       $b1 = imap_fetchheader($this->obj->mbox,imap_msgno($this->obj->mbox,$this->mno),FT_PEEK);
       $b2 = imap_body($this->obj->mbox,imap_msgno($this->obj->mbox,$this->mno));
       echo $b1.$b2;
     } else {
       $this->mail->init_by_phpimap($this->obj,$this->mno,false);
       echo $this->mail->info($this,$this->format,$this->part);
     }

     return;
   }
   /**
    * navigate
    */
   Function navigate() {
   }
   /**
    * prepare
    */
   Function prepare() {
     global $lang,$msg,$tutos;

     $this->name = $lang['MailboxDetail'];
     $this->allto = 0;
     $this->allcc = 0;
     $this->header = 0;
     $this->obj = new mailbox($this->dbconn);
     $this->mail = new mail($this->user);

     $this->obj->read($_GET['id']);
     if ( isset($_GET['path']) ) {
       $this->path = Base64_Decode($_GET['path']);
       $this->obj->setPath($this->path);
     } else {
       $this->path = "";
     }
     if ( isset($_GET['mno']) ) {
       $this->mno = $_GET['mno'];
     } else {
       $this->stop = true;
     }
     if ( isset($_GET['header']) ) {
       $this->header = $_GET['header'];
     }
     if ( isset($_GET['allto']) ) {
       $this->allto = $_GET['allto'];
     }
     if ( isset($_GET['allcc']) ) {
       $this->allcc = $_GET['allcc'];
     }
     if ( isset($_GET['part']) ) {
       $this->part = $_GET['part'];
     } else {
       $this->part = 0;
     }
     if ( !isset($_GET['t']) ) {
       $this->t = 0 ;
     } else {
       $this->t = $_GET['t'] ;
     }
     $x = sprintf("mpw%d",$this->obj->id);
     if ( isset($_POST['mbpw']) ) {
       $this->obj->pw = $_POST['mbpw'];
#       session_register($x);
       $_SESSION[$x] = $this->obj->pw;
     } else if ( isset($_SESSION[$x]) ) {
       $this->obj->pw = $_SESSION[$x];
     }
     if ( isset($_GET['mformat']) ) {
       $this->format = $_GET['mformat'];
     }


     if ( $this->obj->id < 1 ) {
       $this->stop = true;
       $msg .= sprintf($lang['Err0040'],$lang[$this->obj->getType()]);
     }
     if ( ! $this->obj->see_ok() ) {
       $msg .= sprintf($lang['Err0022'],$lang[$this->obj->getType()]);
       $this->stop = true;
     }
     # Open the box
     if ( ($this->stop == false) ) {
       if (false == $this->obj->open()) {
         $this->stop = true;
       }
     }

     $this->mail->seturl("mailbox/mail_show.php?id=". $this->obj->id ."&path=". Base64_Encode($this->obj->addpath)."&mno=".$this->mno);
     # MENU
     $url = $this->obj->getUrl();
     if ( $this->obj->addpath != "" ) {
       $url= addUrlParameter($url,"path=".Base64_Encode($this->obj->addpath));
     }
     $x = array( url => $url,
                 text => $lang['MailboxOverview'],
                 info => $lang['MailboxOverview'],
                 confirm => false,
                 category => array("mailbox","show","obj")
               );
     $this->addMenu($x);


     if ( ($this->obj->id > 0) && $this->obj->del_ok() ) {
       $url = $this->obj->getUrl();
       $u= addUrlParameter($url,"del=".$this->mno);
       $x = array( url => $u,
                   text => $lang['Delete'],
                   info => $lang['MailDeleteI'],
                   confirm => true,
                   category => array("mailbox","del","obj")
                 );
       $this->addMenu($x);
     }
     if ( $this->obj->id > 0 ) {
       $url = "mail_new.php";
       $url= addUrlParameter($url,"mid=".$this->obj->id);
       $url= addUrlParameter($url,"mno=".$this->mno);
       if ($this->path != "") {
         $url= addUrlParameter($url,"mpath=".Base64_Encode($this->path));
       }

       $u= addUrlParameter($url,"reply=1");
       $x = array( url => $u,
                   text => $lang['MailReply'],
                   info => $lang['MailReplyI'],
                   category => array("mail","new","obj")
                 );
       $this->addMenu($x);

       $u= addUrlParameter($url,"reply=2");
       $x = array( url => $u,
                   text => $lang['MailReplyAll'],
                   info => $lang['MailReplyI'],
                   category => array("mail","new","obj")
                 );
       $this->addMenu($x);
	 }
     if ( $this->obj->id > 0 ) {
       $url = $this->mail->getUrl(true);
       $u= addUrlParameter($url,"format=download");
       $x = array( url => $u,
                   text => $lang['MailDownload'],
                   info => $lang['MailDownload'],
                   category => array("mailbox","view","obj")
                 );
       $this->addMenu($x);
     }
   }
 }

 $l = new mail_show($current_user);
 $l->display();
 $l->obj->close();
 $dbconn->Close();
?>
