<?php
/**
 * Copyright 1999 - 2003 by Gero Kohnert
 *
 * @modulegroup product
 * @module product_overview
 * @package product
 */
 include_once 'webelements.p3';
 include_once 'permission.p3';
 include_once 'appointment.pinc';
 include_once 'timetrack.pinc';
 include_once 'product.pinc';
 include_once 'task.pinc';

 require_once 'layout/layout.pinc';

 /* Check if user is allowed to use it */
 check_user();
 loadmodules('product','overview');

 /**
  * show a overview of projects
  */
 class product_overview extends layout {
   /**
    * display the info
    */
   Function info() {
     global $lang,$tutos;

     $plist = array();
     $n = $this->result->numrows();
     if ($this->format == "stat" ) {
       $this->statinfo();
       $this->result->free();
       return;
     }

     $flds = 0;
     $pf = 0;

     foreach($tutos[currencies] as $c) {
       $sum[1][$c] = 0;
       $sum[2][$c] = 0;
     }
     $sum[1][""] = 0;
     $sum[2][""] = 0;

     if ( $this->start == -1 ) {
       $a = $n - $tutos[maxshow];
       $end = $n;
       $this->start = $a;
     }
     else {
       $a = $this->start;
       $end = $this->start + $tutos[maxshow];
     }

     // Prepare a navigation bar
     $this->assign_navbar($a, $end, $n, $this->filter);

     // Make a big array of all visible products
     $projects = array();
     $x = $a;
     while ( $x < $end ) {
       $p = new product($this->dbconn);
       $p->read_result($this->result, $x);
       $x++;
       if ( ! $p->see_ok() ) {
         unset($p);
         continue;
       }
       if ( ($this->pshow['price'] == 1) || ($this->pshow['cost'] == 1) ) {
         $sum[1][$p->currency] += $p->price;
         $sum[2][$p->currency] += $p->cost;
       }
       $plist[] = &$p;

       $p->readroles();
       // $this->debug($p->role[1]->);
       // Get manager
       $roles = array();
       if( isset($p->role[1]) && (count($p->role[1]) > 0) ) {
	 foreach( $p->role[1] as $i => $r ) {
	   $roles[] = 
	      array('name'  => $r->getShortName(),
		    'title' => $r->getFullName(),
		    'link'  => $r->getUrl());
	 }
       }

       $projects[] = array('id'       => $p->id,
			   'name'     => $p->getFullName(),
			   'link'     => $p->getUrl(),
			   'version'  => $p->version,
			   'creation' => $p->creation->getDate(),
			   'state'    => $lang['ProdStates'][$p->state],
			   'desc'     => myentities($p->description),
			   'roles'    => $roles);
       unset($p);
     }
     $n = count($plist);
     if ( 0 == $n) {
       echo $this->error($lang['Err0048']);
       $this->result->free();
       return;
     }
     $this->assign('projects', $projects);

     $headers = array();
     $headers[] = array('name' => 'name',    'label' => $lang['Product']);
     $headers[] = array('name' => 'version', 'label'  => $lang['ProdVersion']);
     $headers[] = array('name' => 'creation','label' => $lang['Date']);
     $headers[] = array('label' => $lang['ProdRole'][1]);
     $headers[] = array('name' => 'state',   'label'  => $lang['ProdState']);
     $headers[] = array('name' => 'description',
			'label'  => $lang['ProdDesc']);

     $this->assign('headers', $headers);
     $this->template('product_overview');
 }

 /* ---------------------------------------------------------------------------
  *
  */
 Function statinfo() {
   global $lang,$tutos;

   $a = 0;
   $n = $this->result->numrows();
   $cnt = 0;
   while ( $a < $n ) {
     $p = new product($this->dbconn);
     $p->read_result($this->result,$a);
     $p->readroles();
     $a++;
     if ( ! $p->see_ok() ) {
       continue;
     }
     $cnt++;

     //  Manager
     if (isset($p->role[1]) && (count($p->role[1]) > 0) ) {
       @reset ($p->role[1]) ;
       $x = 0;
       while ( list ($i,$r) = @each ($p->role[1]) ) {
         if ( !isset($manager[$r->id]) ) {
           $manager[$r->id] = 0;
         }
         $manager[$r->id]++;
       }
     }
     if (isset($p->role[3]) && (count($p->role[3]) > 0) ) {
       @reset ($p->role[3]) ;
       $x = 0;
       while ( list ($i,$r) = @each ($p->role[3]) ) {
         if ( !isset($manager[$r->id]) ) {
           $manager[$r->id] = 0;
         }
         $manager[$r->id]++;
       }
     }

     //  States
     if ( !isset($states[$p->state]) ) {
       $states[$p->state] = 0;
     }
     $states[$p->state]++;

     //  Classifications
     for ( $c = 1;$c <= 2; $c++) {
       @reset($p->cl[$c]);
       while ( list ($i,$f) = @each ($p->cl[$c]) ) {
         if ( !isset($cl[$c][$i]) ) {
           $cl[$c][$i] = 0;
         }
         $cl[$c][$i]++;
       }
     }
     unset($p);
   }

   echo $this->DataTableStart();
   echo "<tr>\n";
   echo " <th colspan=\"6\">". $lang['ProdStatsTitle'] ."</th>\n";
   echo "</tr>\n";

   echo "<tr>\n";
   echo $this->showfield($lang['Count']);
   echo "<td colspan=\"5\">". $cnt ."\n";
   $pre = "filtered by ";
   while ( list ($i,$f) = @each ($this->filter) ) {
     if ( $f == "" ) {
       continue;
     }
     if ( $i == 'state' ) {
       $f = $f + 0;
       echo $pre . $lang['ProdState'];
       echo " ". $lang['ProdStates'][$f];
     } else if ( $i == 'cl1' ) {
       echo $pre . $lang['ProdClass1'];
       echo " ". $lang['ProdClasses1'][$f];
     } else if ( $i == 'cl2' ) {
       echo $pre . $lang['ProdClass2'];
       echo " ". $lang['ProdClasses2'][$f];
     } else if ( $i == 'name' ) {
       echo $pre . $lang['ProdDesc'];
       echo " ". $f;
     } else if ( $i == 'from' ) {
       echo $pre . $lang['DateTimeFrom'];
       echo " ". $f->getDateTime();
     } else if ( $i == 'to' ) {
       echo $pre . $lang['DateTimeTill'];
       echo " ". $f->getDateTime();
     } else {
       echo $pre . $i;
       echo " ". $f;
     }
     $pre = " and ";
   }
   echo " </td>\n";
   echo "</tr>\n";

   //  State distribution
   echo "<tr>\n";
   $link = "graph_bars.php";
   $link = addSessionKey($link);
   $link = addUrlParameter($link,"type=pie");
   @reset($states);
   if ( !function_exists('ImageCreate') ) {
     echo " <td valign=\"top\" rowspan=\"". count($states) ."\"><b>". $lang['ProdState'] ."</b></td>";
   } else {
     echo $this->showfield($lang['ProdState']);
   }
   $c = 0;
   while ( list ($i,$f) = @each ($states) ) {
     $val = number_format($f * 100.0 / $cnt ,2);
     if ( !function_exists('ImageCreate') ) {
       echo " <td>". $lang['ProdStates'][$i] ."</td>\n";
       echo " <td align=\"right\">". $f ."</td>\n";
       echo " <td align=\"right\">". $val ."%</td>\n";
     }
     $link = addUrlParameter($link,"f[". $c ."]=".$val);
     $link = addUrlParameter($link,"t0[". $c ."]=". UrlEncode($lang['ProdStates'][$i]));
     $link = addUrlParameter($link,"t1[". $c ."]=".$f);
     $c++;
   }
   if ( function_exists('ImageCreate') ) {
     echo " <td colspan=\"5\" valign=\"top\"><img src=\"". $link ."\"></td>\n";
   }
   echo "</tr>\n";

   //  Classifications
   for ( $c = 1;$c <= 2; $c++) {
     echo "<tr>\n";
     $link = "graph_bars.php";
     $link = addSessionKey($link);
     $link = addUrlParameter($link,"type=pie");
     @reset($cl[$c]);
     if ( !function_exists('ImageCreate') ) {
       echo " <td valign=\"top\" rowspan=\"". count($cl[$c]) ."\"><b>". $lang['ProdClass'.$c] ."</b></td>";
       } else {
         echo $this->showfield($lang['ProdClass'.$c]);
       }
       $x = 0;
       while ( list ($i,$f) = @each ($cl[$c]) ) {
         $val = number_format($f * 100.0 / $cnt ,2);
         if ( !function_exists('ImageCreate') ) {
           if ( isset($lang['ProdClasses'.$c][$i]) ) {
             echo " <td>". $lang['ProdClasses'.$c][$i] ."</td>\n";
           } else {
             echo " <td>". $i ."</td>\n";
           }
           echo " <td align=\"right\">". $f ."</td>\n";
           echo " <td align=\"right\">". $val ."%</td>\n";
         }
         $link = addUrlParameter($link,"f[". $x ."]=".$val);
         if ( isset($lang['ProdClasses'.$c][$i]) ) {
           $link = addUrlParameter($link,"t0[". $x ."]=". UrlEncode($lang['ProdClasses'.$c][$i]));
         } else {
           $link = addUrlParameter($link,"t0[". $x ."]=". $i);
         }
         $link = addUrlParameter($link,"t1[". $x ."]=". $f );
         $x++;
       }
       if ( function_exists('ImageCreate') ) {
         echo " <td colspan=\"5\" valign=\"top\"><img src=\"". $link ."\"></td>\n";
       }
       echo "</tr>\n";
     }

     //  Manager distribution
     echo "<tr>\n";
     $link = "graph_bars.php";
     $link = addSessionKey($link);
     $link = addUrlParameter($link,"type=pie");
     @reset($manager);
     if ( !function_exists('ImageCreate') ) {
       echo " <td valign=\"top\" rowspan=". count($manager) ."><b>". $lang['ProdRole'][1] ."</b></td>";
     } else {
       echo $this->showfield($lang['ProdRole'][1]);
     }
     $c = 0;
     while ( list ($i,$f) = @each ($manager) ) {
       $m = new tutos_address($this->dbconn);
       $m->read($i);
       if ( $m->id == -1 ) {
         $m = new team($this->dbconn);
         $m->read($i);
       }
       $val = number_format($f * 100.0 / $cnt ,2);
       if ( !function_exists('ImageCreate') ) {
         echo " <td>". $m->getLink() ."</td>\n";
         echo " <td align=\"right\">". $f ."</td>\n";
         echo " <td align=\"right\">". $val ."%</td>\n";
       }
       $link = addUrlParameter($link,"f[". $c ."]=". $val);
       $link = addUrlParameter($link,"t0[". $c ."]=". UrlEncode($m->getShortName()));
       $link = addUrlParameter($link,"t1[". $c ."]=". $f);
       $c++;
     }
     if ( function_exists('ImageCreate') ) {
       echo " <td colspan=\"5\" valign=\"top\"><img src=\"". $link ."\"></td>\n";
     }
     echo "</tr>\n";

     echo $this->DataTableEnd();
   }

   /**
    * navigate
    */
   Function navigate() {
     global $lang,$tutos;

     // FIXME: Temporary deactivated
     return;
  
     if ( $this->format != "stat" ) {
       foreach ($this->pshow as $i => $f) {
         if ( $f == 0 ) {
           $schecked[$i] = "";
         } else {
           $schecked[$i] = " checked";
         }
       }
       echo "<tr><td>";
       echo "<form name=\"ProdFields\" action=\"product_overview.php\" method=\"GET\">";
       echo "<script type=\"text/javascript\" language=\"JavaScript\">\n";
       echo "<!--\n";
       echo "function CheckAll() {\n";
       echo "  for (var i=0; i < document.forms['ProdFields'].elements.length; i++) {\n";
       echo "   var e = document.forms['ProdFields'].elements[i];\n";
       echo "   if (e.name != 'checkit')\n";
       echo "     e.checked = document.forms['ProdFields'].checkit.checked;\n";
       echo "  }\n";
       echo "}\n";
       echo "//-->\n";
       echo "</script>\n";
       DoubleTableStart(0,0);
       echo "<tr><th>". $lang['ProdFields'] ."</th></tr>\n";
       foreach ($tutos[prodfields] as $i => $c) {
         if ( ! isset($this->flds[$c]) ) {
           continue;
         }
         if ( $this->flds[$c] == '' ) {
           continue;
         }
         echo "<tr><td nowrap>\n";
         echo " <input type=\"checkbox\" name=\"ps[]\"". $schecked[$c] ." value=\"". $c ."\">&nbsp;". $lang[$this->flds[$c]] ."\n";
         echo "</td></tr>\n";
       }

       echo "<tr><td nowrap><hr noshade></td></tr>\n";
       echo "<tr><td nowrap>\n";
       echo " <input type=\"checkbox\" name=\"checkit\" onClick=\"CheckAll();\">&nbsp;". $lang['all'] ."\n";
       echo "</td></tr>\n";

       echo "<tr><td><input type=\"submit\" value=\"". $lang['show'] ."\"></td></tr>\n";
       DoubleTableEnd();
       hiddenFormElements();
       // echo $this->getHidden();
       echo "</form>\n";
       echo "</td></tr>";
     }
   }

   /**
    * action
    */
   Function action() {
     global $msg,$lang;

     if ( $_GET['action'] == -2 ) {
       $this->dbconn->Begin("WORK");
       foreach ($_GET['mark'] as $key => $val) {
         $p = new product($this->dbconn);
         $p->read($val);
         $p->readroles();
         if ( $p->id != $val ) {
           continue;
         }
         if ( $p->del_ok() ) {
           $msg .= sprintf($lang['ProdDelInfo'], $p->getFullName()) ."<br>";
           $msg .= $p->delete();
         } else {
           $msg .= $p->getLink() .": ". sprintf($lang['Err0023'],$lang[$p->getType()]);
         }
         unset($p);
       }
       $this->dbconn->Commit("WORK");
       return;
     }
     if ( ereg("^(S)(.*)",$_GET['action'],$a) ) {
       $this->dbconn->Begin("WORK");
       foreach ($_GET['mark'] as $key => $val) {
         $p = new product($this->dbconn);
         $p->read($val);
         $p->readroles();
         if ( $p->id != $val ) {
           continue;
         }
         if ( $p->mod_ok() ) {
           $msg .= $p->getLink() ." ". $lang['ProdState'] ." = ". $lang['ProdStates'][$a[2]] ."<br>";
           $msg .= $p->setState($a[2]);
           $msg .= $p->save();
         } else {
           $msg .= $p->getLink() .": ". sprintf($lang['Err0024'],$lang[$p->getType()]);
         }
         unset ($p);
       }
       $this->dbconn->Commit("WORK");
       return;
     }

     if ( $_GET['action'] == -4 ) {
       $this->redirect = acl_action();
       return;
     } 

     if (class_exists('watchlist')) {
       watchlist::parse_action($this->user);
     }

   }
   /**
    * prepare
    */
   Function prepare() {
     global $msg,$lang,$tutos;

     $this->name = $lang['ProductsOverview'];

     if ( ! $this->user->feature_ok(useprojects,PERM_SEE) ) {
       $msg .= sprintf($lang['Err0022'],"'". $this->name ."'");
       $this->stop = true;
     }

     $this->link1 = "product_overview.php";
     $this->flds = array();
     $this->filter = array();

     $this->flds['name']         = 'ProdName';
     $this->flds['version']      = 'ProdVersion';
     $this->flds['seller']       = 'ProdRole4';
     $this->flds['manager']      = 'ProdRole1';
     $this->flds['customer']     = 'ProdRole6';
     $this->flds['supplier']     = 'ProdRole7';
     $this->flds['reseller']     = 'ProdRole8';
     $this->flds['partner']      = 'ProdRole9';
     $this->flds['desc']         = 'ProdDesc';
     $this->flds['desc1']        = 'ProdDesc1';
     $this->flds['desc2']        = 'ProdDesc2';
     $this->flds['cost']         = 'ProdCost';
     $this->flds['price']        = 'ProdPrice';
     $this->flds['probability']  = 'ProdProb';
     $this->flds['state']        = 'ProdState';
     $this->flds['creator']      = 'ProdCreator';
     $this->flds['creation']     = 'ProdCreationS';
     $this->flds['p_start']      = 'ProdStart';
     $this->flds['p_end']        = 'ProdEnd';
     if ( $this->user->feature_ok(usebugtracking,PERM_SEE) && class_exists('bug') ) {
       $this->flds['pbugs']        = 'Bugs';
     }
     $p = new product($this->dbconn);
     for ( $cl = 1;$cl <= $p->classes; $cl++) {
       $x = sprintf("cl%d",$cl);
       $this->flds['cl'.$cl]     = 'ProdClass'.$cl;
     }
     $this->flds['checkbox']     = '';
     $tutos[prodfields][]  = 'checkbox';
     foreach($tutos[prodfields] as $c) {
       $this->pshow[$c] = 0;
     }
     if ( isset($_GET['name']) ) {
       $name = $_GET['name'];
     } else {
       $name = "";
     }
     if ( isset($_GET['state']) ) {
       if (false == is_numeric($_GET['state'])) {
         $msg .= sprintf($lang['Err0012'],"state",$_GET['state']);
         $this->stop = true;
       }
       $state = $_GET['state'];
       //  remember this
//        session_register('prodsearchstate');
       $_SESSION['prodsearchstate'] = $state;
     } else {
       $state = "";
     }
     if ( isset($_GET['role']) ) {
       $role = $_GET['role'];
     } else {
       $role = "";
     }
     $rid = array();
     if ( isset($_GET['rid']) ) {
       $rid = $_GET['rid'];
     }
     /* Fields to show */
     $pscnt = 0;
     if ( isset($_GET['ps']) ) {
       //  New Set Default
       @reset($_GET['ps']);
       while ( list ($i1,$f1) = @each ($_GET['ps']) ) {
         $this->pshow[$f1] = 1;
         $pscnt++;
         $this->link1 = addUrlParameter($this->link1,"ps[]=".$f1);
       }
       //  remember this
//        session_register('prodshow');
       $_SESSION['prodshow'] = $this->pshow;
     } else if ( isset($_SESSION['prodshow']) ) {
       //  Session Default
       foreach($_SESSION['prodshow'] as $i1 => $f1) {
         if ( $f1 != 0 ) {
           $this->pshow[$i1] = $f1;
           $pscnt++;
           $this->link1 = addUrlParameter($this->link1,"ps[]=".$i1);
         }
       }
     }
     if ( $pscnt == 0 ) {
       //  Default
      $this->pshow['name'] = 1;
      $this->pshow['version'] = 1;
      $this->pshow['manager'] = 1;
      $this->pshow['state'] = 1;
     }
     if ( $tutos[massupdate] == 1 ) {
       $this->pshow['checkbox'] = 1;
     }

     $this->q = "SELECT * FROM ". $p->tablename;
     $pre = " WHERE ";
     if ( ($name != "*") && ($name != "") ) {
       $name = StripSlashes($name);
       $this->q .= $pre ."(".  $this->dbconn->Like("name",$name);
       $this->q .= " OR ". $this->dbconn->Like("description",$name);
       $this->q .= " OR ". $this->dbconn->Like("desc1",$name);
       $this->q .= " OR ". $this->dbconn->Like("desc2",$name);
       $this->q .= " OR ". $this->dbconn->Like("version",$name);
       $this->q .= ")";
       $pre = " AND ";
       $this->link1 = addUrlParameter($this->link1,"name=".UrlEncode($name));
       // $this->addHidden("name",$name);
       $this->filter['name'] = $name;
     } else {
       $this->filter['name'] = "";
     }
     //  Start Date for search
     $from = new DateTime(0);
     if ( isset($_GET['fd']) ) {
       $from->setDateTime($_GET['fd']);
     } else {
       $from->setDateTimeF("f");
       //  remember this
//        session_register('prodsearchfrom');
       $_SESSION['prodsearchfrom'] = $from->getYYYYMMDD();
     }
     if ( $from->notime != 1 ) {
       $this->q .= $pre ."(creation >= ". $this->dbconn->Date($from) .")";
       $pre = " AND ";
       $this->link1 = addUrlParameter($this->link1,"fd=".$from->getYYYYMMDD());
       // $this->addHidden("fd",$from->getYYYYMMDD());
       $this->filter['from'] = $from;
     }
     //  End Date for search
     $to = new DateTime(0);
     if ( isset($_GET['td']) ) {
       $to->setDateTime($_GET['td']);
     } else {
       $to->setDateTimeF("t");
       //  remember this
//        session_register('prodsearchto');
       $_SESSION['prodsearchto'] = $to->getYYYYMMDD();
     }
     if ( $to->notime != 1 ) {
       $this->q .= $pre ."(creation <= ". $this->dbconn->Date($to) .")";
       $pre = " AND ";
       $this->link1 = addUrlParameter($this->link1,"td=".$to->getYYYYMMDD());
       // $this->addHidden("td",$to->getYYYYMMDD());
       $this->filter['to'] = $to;
     }
     // 
     //  State to display
     // 
     if ( ($state != -1) && ($state != "") ) {
       if ( $state < 0 ) {
         $this->q .= $pre . " ( state != 2 AND state != 3 and state != 5 ) " ;
       } else {
         $this->q .= $pre . " state = " . $state ;
       }
       $pre = " AND ";
       $this->link1 = addUrlParameter($this->link1,"state=".$state);
       // $this->addHidden("state",$state);
       $this->filter['state'] = $state;
     }
     // 
     //  Classifications to display
     // 
     for ( $cl = 1;$cl <= $p->classes; $cl++) {
       $x = sprintf("cl%d",$cl);
       if ( isset($_GET[$x]) && ($_GET[$x] != -1) ) {
  	     if (false == is_numeric($_GET[$x])) {
           $msg .= sprintf($lang['Err0012'],$x,$_GET[$x]);
	       $this->stop = true;
		   return;
	     }
         //  Get all project with classification
         $q1 =  "SELECT * from ". $this->dbconn->prefix ."projectclass". $cl ." WHERE class_id = ". $_GET[$x];
         $r = $this->dbconn->Exec($q1);
         $n = $r->numrows();
         $a = 0;
         $pre1 = "";
         $z = "";
         while ($a < $n) {
           $z .= $pre1 . $r->get($a, "pro_id");
           $pre1 = ",";
           $a++;
         }
         $r->free();
         if ( $z != "" ) {
           $this->q .= $pre ." id in (". $z .")";
           $pre = " AND ";
         }

         $this->link1 = addUrlParameter($this->link1,"cl". $cl ."=".$_GET[$x]);
         // $this->addHidden("cl". $cl, $_GET[$x]);
         $this->filter['cl'.$cl] = $_GET[$x];
       }
       if ( isset($_GET[$x]) ) {
         $y = sprintf("prodsearchcl%d",$cl);
         //  remember this
//          session_register($y);
         $_SESSION[$y] = $_GET[$x];
       }
     }
     //  Role Specific Selection
     if ( count($rid) > 0 ) {
       //  Get all managed product ids
       @reset ($rid);
       $ml = "";
       $mpre = "";
       foreach( $rid as $f1) {
         $ml .= $mpre . $f1;
         $mpre = ",";
         $this->link1 = addUrlParameter($this->link1,"rid[]=".$f1);
         // $this->addHidden("rid[]",$f1);
       }
       if ( isset($role) ) {
         $q1 = "SELECT pro_id FROM ". $this->dbconn->prefix ."projectroles WHERE role_id in (". $role .") AND adr_id in (". $ml .")";
         $this->link1 = addUrlParameter($this->link1,"role=".$role);
         // $this->addHidden("role",$role);
       } else {
         $q1 = "SELECT pro_id FROM ". $this->dbconn->prefix ."projectroles WHERE adr_id in (". $ml .")";
       }
       $r = $this->dbconn->Exec($q1);
       $n = $r->numrows();
       $a = 0;
       $pre1 = "";
       $x = "";
       while ($a < $n) {
         $x .= $pre1 . $r->get($a, "pro_id");
         $pre1 = ",";
        $a++;
       }
       $r->free();
       if ( $x != "" ) {
         $this->q .= $pre ." id in (". $x .")";
       }
       $pre = " AND ";
     }

     check_dbacl( $this->q, $this->user->id);

     //  Order of output
     $this->link2 = $this->link1;
     $this->link2 = addUrlParameter($this->link2,"format=".UrlEncode($this->format));
     $xxx = "";
     order_parse($this->q,$this->link1,$xxx,$xxx,"creation DESC");

     if ($this->stop) {
       return;
     }
     $this->result = $this->dbconn->Exec($this->q);
     if ( 0 == $this->result->numrows()) {
       $this->redirect = "product_select.php?msg=". UrlEncode($lang['Err0048']);
       $this->result->free();
     }

     $this->assign('xf', $_GET['xf']);
     $this->assign('xo', $_GET['xo']);

     
     //  menu
     $x = product::getSelectLink($this->user,$lang['Search']);
     $x['category'][] = "obj";
     $x['image'] = "search";
     $this->addMenu($x);

     if ( $this->user->feature_ok(useprojects,PERM_NEW) ) {
       $x = array('url'   => "product_new.php",
                  'text'  => $lang['NewEntry'],
		  'image' => 'new',
                  'info'  => $lang['ProdCreateInfo'],
                  'category' => array("product","new","obj")
                 );
       $this->addMenu($x);
     }
     if ( $this->format != "stat" ) {
       $ll = addUrlParameter($this->link1,"format=stat");
       $x = array('url'  => $ll,
                  'text' => $lang['ProdStats'],
                  'info' => $lang['ProdStatsInfo'],
                  'category' => array("product","view")
                 );
       $this->addMenu($x);
     }

     if ( $this->format != "paper" ) {
       $ll = addUrlParameter($this->link1,"format=paper");
       $x = array('url'  => $ll,
                  'text' => $lang['Printable'],
                  'info' => $lang['PrintableInfo'],
                  'category' => array("product","view")
                 );
       $this->addMenu($x);
     }

     $x = array('url'  => "sales_forecast.php",
                'text' => $lang['SalesForecastRep'],
                'info' => $lang['SalesForecastRep'],
                'category' => array("product","view")
               );
     $this->addMenu($x);
     
     web_StackStartLayout($this,"product_overview.php","product_overview.php?".$_SERVER['QUERY_STRING']);

   }
 }

 $l = new product_overview($current_user);
 $l->display();
 $dbconn->Close();
?>
<!--
    CVS Info:  $Id: product_overview.php,v 1.99.2.10 2004/10/06 16:38:58 tapoueh Exp $
    $Author: tapoueh $
-->
